/*
 *	cliprc.c
 *
 *	Range Coder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Wed Dec 03 21:01:59 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	  RangeCoderDecoder_Decode(),RangeCoderDecoder_Init(),RangeCoderDecoder_Getc()̃AZus܂B
 *	  kf[^̍쐬́ADOSR}hCc[utool/dprcv𗘗pĂB
 *	- L̋LQlɂ܂B
 *	  uȎZpkuRange Codervv(http://codezine.jp/article/detail/443)
 *	  (_E[hāukeep/ȎZpkuRange Coderv.7zvɕۑĂ܂B)
 *	  W[̎́ATv\[X̎QlɂAĈȉ̍Hvs܂B
 *	  EkɊi[m\ςނ悤Hv܂B
 *	  ETv\[X͊mꂪf[^TCŶ܂܂łAW[1/65536ɐK܂B
 *	  ETv\[X̓fR[_񕪒TsĂ܂AW[͏omɐ`Ts悤ɂ܂B
 *	  ETv\[X͌f[^̃TCYwb_Ɋi[Ă܂AW[͏I[Ŕf悤ɂ܂B
 *	- RangeCoderDecoder_Decode()̑x́AHuffmanDecoder_Decode()ɊrׂāA悻{xłB
 *	  om̕΂肪t@Cł́Ak卷ÁAm\傫nt}k܂B
 *	  \̂̃TCYAnt}8oCgɊrׂāARange Coder16oCgƁAĂ܂B
 *	  R[hTCÝAnt}ARange Coder̕AȂ菬łB
 *	  ȏ̓lƁAom̕΂肪傫ƂĂꍇAR[hTCYɏdvȏꍇāA
 *	  ʓIɂ́Ant}gpK؂ł悤Ɏv܂B
 *	* Fri Dec 05 21:45:35 JST 2014 Naoyuki Sawa
 *	- AZuRangeCoderDecoder_Getc()́A'Hv'쐬܂B
 *	  RangeCoderDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA1.350b˖1.272bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	  RangeCoderDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA0.554b˖0.534bɍ܂B(Clock=48MHz,Code=FRAM,Stack=FRAM)
 *	  ڍׂ́A'Hv''RangeCoderDecoder_Getc_L10`'̃[vԂ̃RgQƂĂB
 *	  R[hTCÝA'fȎ''Hv'AłB
 *	* Thu Sep 29 21:37:05 JST 2016 Naoyuki Sawa
 *	- Hewł̓GR[_[܂߂Ȃ悤ɂ܂B
 */
#include "clip.h"

#ifndef __RENESAS__	//{{2016/09/29ǉ:Hewł̓GR[_[܂߂Ȃ悤ɂ܂B}}
/****************************************************************************
 *	RangeCoderGR[_[
 ****************************************************************************/
//̃m[h
typedef struct _ST_RangeCoderNode {
	int	x;	//0`255
	int	c;	//c(x)=x̏o
	int	p;	//p(x)=x̏om(p/65536)		//I[(1/65536)̏om^̂ŁA0`255̏om(65535/65536)ȉƂȂB
	int	cum;	//cum(x+1)=0`x̏om̘a
} ST_RangeCoderNode;
//------------------------------------------------------------------------------
//(ST_RangeCoderNode)A(ST_RangeCoderNode.c)̍~Ƀ\[gAr֐B
//(ST_RangeCoderNode.c)Ȃ΁A(ST_RangeCoderNode.x)̏ƂB		̔f͕K{ł͂ȂBՂ̂߂łB
static int RangeCoderEncoder_CompareNode(const void* _a, const void* _b) {
	ST_RangeCoderNode* a = (ST_RangeCoderNode*)_a;
	ST_RangeCoderNode* b = (ST_RangeCoderNode*)_b;
	if(a->c > b->c) { return -1; }	//o񐔂̍~ƂB
	if(a->c < b->c) { return  1; }	//
	if(a->x < b->x) { return -1; }	//o񐔂Ȃ΁ȀƂB	̔f͕K{ł͂ȂBՂ̂߂łB
	if(a->x > b->x) { return  1; }	//
	return 0;
}
//------------------------------------------------------------------------------
//kf[^ŜGR[hAkf[^쐬B
// - src,dstɁAACgsvB
// - kf[^dstBytes𒴂ꍇ́Az͊i[ȂB
//   i[̉ۂɊ֌WȂA߂ĺAkf[^̃oCgłB
//   ̐𗘗pāAڂ(dst=NULL,dstBytes=0)ŌĂяoAKvȃobt@TCYmF,mۂAēxĂяo@\łB
//   <>
//   dstBytes=RangeCoderEncoder_Encode(src,srcBytes,NULL,0);
//   dst=malloc(dstBytes);
//   RangeCoderEncoder_Encode(src,srcBytes,dst,dstBytes);
int RangeCoderEncoder_Encode(const void* _src, int srcBytes, void* _dst, int dstBytes) {
	ST_RangeCoderNode TBL_Node[256];
	unsigned char     TBL_Map[ 256];	//˃m[hΉ\	xɑΉm[h́ATBL_Node[TBL_Map[x]]ŋ܂B
	const unsigned char* src = _src;
	      unsigned char* dst = _dst;
	int dstPos = 0;
	//---  ---
	{
		int i;
		//m[hB
		memset(TBL_Node, 0, sizeof TBL_Node);
		for(i = 0; i < 256; i++) {
			TBL_Node[i].x = i;
		}
		//0`255̏o񐔂𐔂B
		for(i = 0; i < srcBytes; i++) {
			TBL_Node[src[i]].c++;
		}
		//m[ho񐔂̍~Ƀ\[gB
		qsort(TBL_Node, 256, sizeof TBL_Node[0], RangeCoderEncoder_CompareNode);
		//o񐔂Aom(p/65536)ɕϊB
		TBL_Node[0].p = 65536 - 1/*I[̏om*/;	//I[(1/65536)̏om^Ac𕶎0`255ɕzB	//ł؂덷ɂė]oḿAo񐔂ő̏̕omɊ܂߂ė^B
		for(i = 255; i > 0; i--) {
			ST_RangeCoderNode* pNode = &TBL_Node[i];
			if(pNode->c) {
				pNode->p = (int)((uint64_t)pNode->c * (uint64_t)(65536 - 1/*I[̏om*/) / (uint64_t)srcBytes);	//̏Zőł؂덷B
				if(!pNode->p) { pNode->p = 1; }											//oc(x)1A(o񐔁ˏom)ɕϊAomp(x)1ƂȂ悤ɁAKvLB
				TBL_Node[0].p -= pNode->p;											//o񐔂ő̏̕omB
				if(TBL_Node[0].p <= 0) { DIE(); }										//L̐؂グݐςĂȂ邱Ƃ͋N蓾邩H_IɋN蓾ȂƎvÔߊmFĂƂɂBŒ~ASYČB
			}
		}
		//om(p/65536)Aom̘a(cum(x+1))ɕϊB
		for(i = 0; i < 256; i++) {
			TBL_Node[i].cum = TBL_Node[i].p;
			if(i) { TBL_Node[i].cum += TBL_Node[i - 1].cum; }
		}
		if(TBL_Node[255].cum != 65536 - 1/*I[̏om*/) { DIE(); }	//oO
#if 1 //{{0oCg̃f[^ɑ΂ᏈBm\łB̓Ꮘ͕K{ł͂ȂAʏʂ̏sĂ\ȂB
		// - 0oCg̃f[^kƁASẴm[hc=0ATBL_Node[0].pɏom̗]肪^ATBL_Node[0].p=65535ɂȂB
		//   ̂߁ATBL_Node[0]m\ɏo͂Ă܂B͖薳AʂłB
		//   ŁATBL_Node[0].p𖾎I0ɂ邱ƂɂATBL_Node[0]m\ɏo͂邱ƂhƂɂB
		//   ATBL_Node[i].cum0ɂKv͖̂AՂ̂߂0ɂĂƂɂBɂ͊֌WB
		// - ȏ̓sƂɂāA0oCg̃f[^k̃TCYA11oCg8oCgɒጸB
		//   fR[_́A̓ᏈlKv͖B
		if(!srcBytes) {
			for(i = 0; i < 256; i++) {
				TBL_Node[i].p = TBL_Node[i].cum = 0;
			}
		}
#endif//}}0oCg̃f[^ɑ΂ᏈBm\łB̓Ꮘ͕K{ł͂ȂAʏʂ̏sĂ\ȂB
		//˃m[hΉ\쐬B
		for(i = 0; i < 256; i++) {
			TBL_Map[TBL_Node[i].x] = i;
		}
	}
	//--- m\o͏ ---
	{
		int i;
		//m\o͂B
		//- m\̌`́Aȉ̒ʂ:
		//+ 0,2 HIBYTE(p(0))	ʃoCgsŊi[邱ƂɂŔAAZuRangeCoderDecoder_Getc()ŃC^[bN点邩łB
		//+ 2,2 LOBYTE(p(0))	ڍׂ́AAZuRangeCoderDecoder_Getc()'Hv'́A'RangeCoderDecoder_Getc_L10`'̃[vԂQƂĂB
		//+ 4,1 0
		//+ 5,2 HIBYTE(p(1))
		//+ 7,2 LOBYTE(p(1))
		//+ 9,1 1
		//      c
		//+ ?,2 HIBYTE(p(x))
		//+ ?,2 LOBYTE(p(x))
		//+ ?,1 x
		//+ ?,2 0		p(x)=0ŏI[\B0oCg̃f[^kāÅm\o͂ꍇ́Åm\{0,0}2oCgō\B
		//+ ?,2 0		
		//			p(x)=0̌ɕx͖ƂɒӂB
		//` 爳kf[^Jn `
		//- I[͊m\Ɋ܂߂ȂB
		//  ]āAfR[_͊m\𑖍āAɈv镶Ȃ΁AI[ƔfłB
		for(i = 0; i < 256; i++) {
			ST_RangeCoderNode* pNode = &TBL_Node[i];
			if(!pNode->p) { break; }
			if(dstPos++ < dstBytes) { *dst++ = pNode->p >> 8; }	//HIBYTE(p(x))
			if(dstPos++ < dstBytes) { *dst++ = pNode->p; }		//LOBYTE(p(x))
			if(dstPos++ < dstBytes) { *dst++ = pNode->x; }		//x
		}
		if(dstPos++ < dstBytes) { *dst++ = 0; }	//p(x)=0ŏI[\B
		if(dstPos++ < dstBytes) { *dst++ = 0; }	//
	}
	//--- k ---
	{
		int buffer =  0;	//'buffer=newBuffer'ŝŏsvAx}̂߂ɏ邱ƂɂB
		int carryN = -1;	//(carryN==-1)́AX^[g(=bufferi[)ł鎖ӖB
		int L      =  0;
		int R      = -1;
		int i, lo, hi, r, newL;
		for(i = 0; i <= srcBytes; i++) {	//[v'<'ł͂Ȃ'<='ł邱ƂɒӂB'i=srcBytes'̎ɉzIȏI[o͂B
			//lo=cum(x),hi=cum(x+1)߂B
			if(i < srcBytes) {		//0`255
				int  x = TBL_Map[src[i]];
				lo = x ? TBL_Node[x - 1].cum : 0;
				hi =     TBL_Node[x    ].cum;
			} else {			//I[
				lo = 65536 - 1;		//I[(1/65536)̏om^B
				hi = 65536;		//
			}
			if(lo >= hi) { DIE(); }		//oO
			//RXVB
			r = (unsigned)R >> 16;		//r = (unsigned)R / 65536
			R = r * (hi - lo);												//Ql̃vÓAŌ̕Ɏc̋ԂSė^Ă邪Ał͕͂̏svłBɂāAŌ̕Ƃ͏I[łAk̍ŏIɂȂBI[Ɏc̋ԂSė^Ă Ak̉PɊ^ȂB
			//LXVB
			newL = L + r * lo;
			if((unsigned)newL < (unsigned)L) {	//Jオ肪c
				if(buffer == -1) { DIE(); }	//oOBbufferɕێĂlJオ邱Ƃ͖͂B
				if(carryN == -1) { DIE(); }	//oOBX^[gԂŌJオ肪邱Ƃ͖͂B
				//{buffer,FF,FF,c,FF,FF}  {buffer+1,00,00,c,00,00}
				//        carryN               carryN
				buffer++;
				if(carryN) {
					//{buffer+1,00,00,c,00,00}  {buffer+1,00,00,c,00,00}
					//          carryN      o͂鄟 buffer
					do {
						if(dstPos++ < dstBytes) { *dst++ = buffer; }
						buffer = 0;
					} while(--carryN);
				}
			}
			L = newL;
			//V̏8rbg肵Ao͂B
			while((unsigned)R < (unsigned)(1 << 24)) {
				int newBuffer = L >> 24;
				//X^[g(=bufferi[)Ȃ΁c
				if(carryN == -1) {
					carryN = 0;		//X^[gԂ̒ɁA(buffer=-1)ƂȂ鎖L链B̏ꍇA(buffer=-1,carryN=0)ŕ\BX^[gԂ̒ɁA(buffer=-1)ƂȂ鎖͖悤ȋCĂB
					buffer = newBuffer;	//(buffer=0,carryN=1)ŕ\ƁǍ̏ŕsv(buffer=0)o͂Ă܂肪BɂĂAL̏ŖȂ삷͂B
				//bufferɂ͍Ō0xFFł͖lۑĂAcarryN0xFFAĉo񐔂ۑB
				//buffercarryNpāAݏo͑҂́̕A{buffer,FF,FF,c,FF,FF} ƕ\B(carryN=0̏ꍇL)
				//                                                      carryN
				} else if(newBuffer == -1) {
					carryN++;
				} else {
					//{buffer,FF,FF,c,FF,FF},newBuffer
					//      carryN     
					//  o͂鄟     buffer
					if(dstPos++ < dstBytes) { *dst++ = buffer; }
					if(carryN) {
						do {
							if(dstPos++ < dstBytes) { *dst++ = -1; }
						} while(--carryN);
					}
					buffer = newBuffer;
				}
				//LRVtgB
				L <<= 8;
				R <<= 8;
			}
		}
		//cĂbuffer,y,Lo͂B
		if(carryN != -1) {	//X^[g(=bufferi[)łȂ΁c							//Ql̃vÓAL̔fsĂ炸AX^[g(=bufferi[)łĂAbuffero͂Ă悤BQl̃vÓAł͂ȂHȃf[^kāAbufferi[OɏIƁA{݂͑Ȃbuffero͂Ă܂AłȂkf[^ƎvB
			if(dstPos++ < dstBytes) { *dst++ = buffer; }
			if(carryN) {
				do {
					if(dstPos++ < dstBytes) { *dst++ = -1; }
				} while(--carryN);
			}
		}
		for(i = 0; i < 4; i++) {
			if(dstPos++ < dstBytes) { *dst++ = L >> 24; }
			L <<= 8;
		}
	}
	//o̓oCgԂB
	return dstPos;
}
#endif//__RENESAS__	//{{2016/09/29ǉ:Hewł̓GR[_[܂߂Ȃ悤ɂ܂B}}
