/*
 *	clipquaf.h
 *
 *	_ŃNH[^jICu`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2009 Naoyuki Sawa
 *
 *	* Sat May 02 20:49:01 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	- clipquat.cW[ɁAPɕs_č쐬܂B
 *	  éAclipquat.hclipquat.c̃RgQƂĂB
 *	  ꕔAό`ĂӏȂǂ܂AASY͓łB
 *	- 2009/05/02݁A܂A쌟؂s[łB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_QUAF_H__
#define __CLIP_QUAF_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	quatf
 *****************************************************************************/

typedef struct _quatf {
	float x, y, z, w;
} quatf;

extern const quatf quatf_0;
extern const quatf quatf_1;

void quatf_add(quatf* q1/*[in,out]*/, const quatf* q2/*[in]*/);
void quatf_mul(quatf* q1/*[in,out]*/, const quatf* q2/*[in]*/);
void quatf_mulf(quatf* q/*[in,out]*/, float f/*[in]*/);
void quatf_divf(quatf* q/*[in,out]*/, float f/*[in]*/);

void quatf_neg(quatf* q/*[in,out]*/);
void quatf_inv(quatf* q/*[in,out]*/);
void quatf_conj(quatf* q/*[in,out]*/);
void quatf_normal(quatf* q/*[in,out]*/);

float/*[out]*/ quatf_norm2(const quatf* q/*[in]*/);
float/*[out]*/ quatf_norm(const quatf* q/*[in]*/);
float/*[out]*/ quatf_dot(const quatf* q1/*[in]*/, const quatf* q2/*[in]*/);

void quatf_rot(quatf* out/*[out]*/, const vec3f* axis/*[in]*/, float ang/*[in]*/);
void quatf_slerp(quatf* out/*[out]*/, const quatf* q1/*[in]*/, const quatf* q2/*[in]*/, float t/*[in]*/);

void vec3f_rotq(const quatf* q/*[in]*/, vec3f* v/*[in,out]*/);
void mat3f_rotq(mat3f* m/*[in,out]*/, const quatf* q/*[in]*/);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_QUAF_H__*/
