/*	
 *	clipmidi.h
 *
 *	P/ECE MIDI Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Tue Aug 30 22:28:00 JST 2003 Naoyuki Sawa
 *	- VK쐬B
 *	* Tue Sep 02 24:00:00 JST 2003 Naoyuki Sawa
 *	- F}bvΉB
 *	- Yp[gΉB
 *	- `laΉB
 *	* Tue Sep 03 04:02:00 JST 2003 Naoyuki Sawa
 *	- e|CB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_MIDI_H__
#define __CLIP_MIDI_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	萔E^`
 ****************************************************************************/

#define MIDITRACKS	16		/* T|[gőgbN() */

/* F}bv\(AvP[Vw) */
typedef struct _MIDIMAP {
	unsigned char melody[128];	/* fB[F}bv(MIDIvONo.(0`127)MODTvNo.(1`32A0͖)) */
	unsigned char rhythm[128];	/* YF}bv(MIDIm[gNo.(0`127)MODTvNo.(1`32A0͖)) */
} MIDIMAP;

/* MIDIgbN\(gp) */
typedef struct _MIDITRACK {
	const unsigned char* pos;	/* tʒu */
	int delta;			/* f^^C */
	int running_status;		/* jOXe[^X */
} MIDITRACK;

/* MIDI`l\(gp) */
typedef struct _MIDICHANNEL {
	int program;			/* vOio[ */
} MIDICHANNEL;

/* MOD`lǗ\(gp) */
typedef struct _MIDIVOICE {
	int age;			/* 0:~/1`:(͖+1) */
	int channel;			/* MIDI`l */
	int note;			/* m[gio[ */
} MIDIVOICE;

/* MIDIhCo\(gp) */
typedef struct _MIDIDRIVER {
	const MIDIMAP* map;		/* F}bv */
	int track_count;		/* gbN */
	int time_unit;			/* ԒP(l̃f^^C) */
	int tempo;			/* e|(l̃}CNb) */
	long long timer;		/* oߎԂ̗][usec] (ԌvZ̓~bPʂȂ̂ŁAintł͑Ȃ) */
	MIDITRACK track[MIDITRACKS];	/* gbN */
	MIDICHANNEL channel[16];	/* `l */
	MIDIVOICE voice[MODCHANS];	/* MOD`lǗ */
	MODDRIVER mod;			/* MODhCo(Ƃėp) */
} MIDIDRIVER;

/****************************************************************************
 *	֐
 ****************************************************************************/

/*------------------------------ x֐ ------------------------------*/

/* WMIDIt@C(SMF)̍ĐJn܂B
 * [in]
 *	data		SMFf[^̐擪AhXB
 *	inst		ƂĎgpMODf[^̐擪AhXB
 *	map		F}bv`f[^̃AhXB
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 */
int midi_play(const void* data, const void* inst, const MIDIMAP* map);

/* WMIDIt@C(SMF)̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void midi_stop();

/* F}bv`̗F
 *
 *	MIDIMAP map = {
 *		{
 *			[0 ... 127] = 1
 *		}, {
 *			2,2,2,2,2,2,2,2,2,2,	// 0-9
 *			2,2,2,2,2,2,2,2,2,2,	// 10-19
 *			2,2,2,2,2,2,2,2,2,2,	// 20-29
 *			2,2,2,2,2,		// 30-34
 *			0x83,			// 35 Acoustic Bass Drum
 *			0x83,			// 36 Bass Drum1
 *			2,			// 37 Side Stick
 *			0x82,			// 38 Acoustic Snare
 *			0x84,			// 39 Hand Clap
 *			0x82,			// 40 Electric Snare
 *			0x85,			// 41 Low Floor Tom
 *			2,			// 42 Closed Hi-Hat
 *			0x85,			// 43 High Floor Tom
 *			2,			// 44 Pedal Hi-Hat
 *			0x85,			// 45 Low Tom
 *			2,			// 46 Open Hi-Hat
 *			0x85,			// 47 Low-Mid Tom
 *			0x85,			// 48 Hi-Mid Tom
 *			2,			// 49 Crash Cymbal1
 *			0x85,			// 50 High Tom
 *			2,			// 51 Ride Cymbal1
 *			2,			// 52 Chinese Cymbal
 *			2,			// 53 Ride Bell
 *			2,			// 54 Tambourine
 *			2,			// 55 Splash Cymbal
 *			2,			// 56 Cowbell
 *			2,			// 57 Crash Cymbal2
 *			2,			// 58 Vibraslap
 *			2,			// 59 Ride Cymbal2
 *			2,			// 60 Hi Bongo
 *			2,			// 61 Low Bongo
 *			2,			// 62 Mute Hi Conga
 *			2,			// 63 Open Hi Conga
 *			0x85,			// 64 Low Conga
 *			2,			// 65 High Timbale
 *			2,			// 66 Low Timbale
 *			2,			// 67 High Agogo
 *			2,			// 68 Low Agogo
 *			2,			// 69 Cabasa
 *			2,			// 70 Maracas
 *			2,			// 71 Short Whistle
 *			2,			// 72 Long Whistle
 *			2,			// 73 Short Guiro
 *			2,			// 74 Long Guiro
 *			2,			// 75 Clavas
 *			2,			// 76 Hi Wood Block
 *			2,			// 77 Low Wood Block
 *			2,			// 78 Mute Cuica
 *			2,			// 79 Open Cuica
 *			2,			// 80 Mute Triangle
 *			2,			// 81 Open Triangle
 *			2,2,2,2,2,2,2,2,	// 82-89
 *			2,2,2,2,2,2,2,2,2,2,	// 90-99
 *			2,2,2,2,2,2,2,2,2,2,	// 100-109
 *			2,2,2,2,2,2,2,2,2,2,	// 110-119
 *			2,2,2,2,2,2,2,2		// 120-127
 *		}
 *	};
 *
 * EMODt@CɎ̂悤ȃTv`A
 *	Tv#1 ... sAm
 *	Tv#2 ... XlAh
 *	Tv#3 ... oXh
 *	Tv#4 ... nhNbv
 *	Tv#5 ... ^
 *   fB[F͑SăsAmɐU蕪AYF̓XlA`^ɐU蕪ꍇ̗łB
 *
 * EMODTvio[0w肷ƁÃvOio[(fB̏ꍇ)/m[gio[(Y̏ꍇ)͖܂B
 *   ̗ł͗pĂ܂B
 *
 * EMODTvio[͊{I 0:/1`32:MODTvio[ Ŏw肵܂A0x80Ɖʂ4{ɂȂ܂B
 *   ̗ł́AYF̈ꕔɗpĂ܂B
 */

/*------------------------------ x֐ ------------------------------*/

/* mod_init()/mod_tick()́AMIDITvWJs჌x֐łB
 * * P/ECEŎgꍇ́Axmidi_play()/midi_stop()gĂB
 *   midi_init()/midi_tick()𒼐ڎgKv͂܂B
 */
int midi_init(MIDIDRIVER* driver, const void* data, const void* inst, const MIDIMAP* map);
int midi_tick(MIDIDRIVER* driver, short wbuff[/*MODBUFLEN*/]);

/*------------------------------ ჌x֐ ------------------------------*/

/* mod_tick()Ă΂֐B */
int midi_seq(MIDIDRIVER* driver);
int midi_mix(MIDIDRIVER* driver, short wbuff[/*MODBUFLEN*/]);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_MIDI_H__*/
