/*	
 *	clipmath.h
 *
 *	[eBeBFw֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Thu Dec 31 09:54:58 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	- math.hɂ͊܂܂ȂẂAw֐܂Ƃ߂邽߂̃W[łB
 *	  AW̐w֐ǉꍇ́AW[ɒǉĉB
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- determinant(),cofactor(),solve()ǉ܂B
 */
#ifndef __CLIP_MATH_H__
#define __CLIP_MATH_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	`
 *****************************************************************************/
//Performs a Linear intERPolation.
//[in]
//	x		The first-floating point value.							xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.						
//	s		A value that Linearly intERPolates between the x parameter and the y parameter.	Iɂ(0<=s<=1)łA(s<0)(s>1)ł삵܂B
//[out]
//	return value	The result of the Linear intERPolation.
//[note]
//	- PȐ`Ԋ֐łB
//	  WC֐ł͂܂񂪁ÃQ[pCuɔĂ̂ŁAĂɂ܂B
//	- ʓIɂ'x+(s*(y-x))'ŌvZ܂A'x-(s*(x-y))'ŌvZ܂B
//	  'x+(s*(y-x))''x-(s*(x-y))'̕AAsmɃWX^̈ړ񐔂ČǂłB
double lerp(double x, double y, double s);
/*****************************************************************************
 *	A
 *****************************************************************************/
//m[ns][n]̍s(determinant)߂܂B
//[note]
//	- matnf_determinant()APx˔{xɕύX֐łB
//	  gASÝAmatnf_determinant()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_determinant()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double determinant(const double* m/*[n][n]*/, int n);
//m[ns][n]isjA]q(cofactor)߂܂B
//[note]
//	- matnf_cofactor()APx˔{xɕύX֐łB
//	  gASÝAmatnf_cofactor()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_cofactor()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double cofactor(const double* m/*[n][n]*/, int n, int i, int j);
//nẢ߂܂B
//[note]
//	- solve_simultaneous_equations()APx˔{xɕύX֐łB
//	  gASÝAsolve_simultaneous_equations()ƓłB
//	  ڍׂ́Aclipflt1.csolve_simultaneous_equations()̎QƂĉB
//	- Asolve_simultaneous_equations()ƊrׂāAύX_L܂B
//	  solve_simultaneous_equations()͖߂lłA֐͏̓rŋ߂s񎮂̒lԂ悤ɂ܂B
//	  ẢLs񎮂̒lĔf邽߂ɁAʓrdeterminant()ĂяoǂłB
//	  solve_simultaneous_equations()ł́ALȉA͎w肳ȂOŖ߂lɂĂ܂A
//	  ۂɂ́ALȉAw肳\LƍlďL̖߂l̎dlύXsɂ܂B
//	  ܂ł̓rŋ߂s񎮂̒lԂ悤ɂ̕ύXłAê͈ؕύXĂ܂B
//	  ܂A֐ԂlQƂ邩ǂAĂяołB
//	  LȉAw肵ȂOȂ΁A߂l𖳎Ă\܂B
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
//	  Ȃ݂MATLABɂAA֐Ƃsolve()ƂO̊֐邻łB
//	  pr͎Ă܂Adl͌݊ł͂܂B܂ܖOvłB
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n);
/*****************************************************************************
 *	
 *****************************************************************************/
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_MATH_H__
