/*	
 *	clipcrc.h
 *
 *	CRCvZ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sat Feb 15 06:47:35 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_CRC_H__
#define __CLIP_CRC_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

/* CRC-8-CCITT
 *  = X^8+X^7+X^3+X^2+1
 * l     = 0x00
 * oXor    = 0x00
 * rbg = E
 */
int crc8_ccitt_r(const void* data, int len);

/* CRC-16-CCITT
 *  = X^16+X^12+X^5+1
 * l     = 0xFFFF
 * oXor    = 0x0000
 * rbg = E
 */
int crc16_ccitt_r(const void* data, int len);

/* CRC-32-IEEE 802.3
 * =X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X+1
 * l     = 0xFFFFFFFF
 * oXor    = 0xFFFFFFFF
 * rbg = E
 */
int crc32_ieee_r(const void* data, int len);

/****************************************************************************
 *	
 ****************************************************************************/

/* CRC-8-CCITT
 *  = X^8+X^7+X^3+X^2+1
 * l     = 0x00
 * oXor    = 0x00
 * rbg = 
 */
int crc8_ccitt_l(const void* data, int len);

/* CRC-16-CCITT
 *  = X^16+X^12+X^5+1
 * l     = 0xFFFF
 * oXor    = 0x0000
 * rbg = 
 */
int crc16_ccitt_l(const void* data, int len);

/* CRC-32-IEEE 802.3
 * =X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X+1
 * l     = 0xFFFFFFFF
 * oXor    = 0xFFFFFFFF
 * rbg = 
 */
int crc32_ieee_l(const void* data, int len);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_CRC_H__*/
