/*
 *	clipcqrd.c
 *
 *	R[obNL[pDxt`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sat Jan 30 21:30:05 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- ɗǂg`֐́ADxto[W`܂B
 *	  ɂDxt`s`֐L΁ÃW[ɒǉĉB
 *	- W[ɂ͓ɗǂg`֐`̂ŁAW[̊֐͊̕`֐Ƃق1:1ɑΉĂ܂B
 *	  AR[obNL[ɂ`́AK̂悤ɎgKv͗L܂B
 *	  Ⴆ΁A̗DxŃR[obNsA̎_̃t[obt@ɑ΂āAAvP[V`̃tB^|悤Ȏgo܂B
 *	  ̗ƂẮADx}CiXwi,DxvXOiƂāADx0ŃR[obN|āAwiɃX^XN[|o܂B
 *	  L̂悤ȁAAvP[VL̏sꍇ́AW[ɋ@\ǉAX̃AvP[Ṽ\[XŒ`ǂł傤
 *	* Sun Jan 31 21:43:46 JST 2016 Naoyuki Sawa
 *	- CbkQue_render_set_draw_area()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_surface_clear {
	SURFACE*		surface;		//+ 0, 4
	uint16_t		color;			//+ 4, 2
    //	uint16_t		padding;		//+ 6, 2
};							//= 8
static void fn_CbkQue_surface_clear(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_surface_clear* p = param;
	surface_clear(p->surface, p->color);
}
/*--------------------------------------------------------------------------*/
//surface_clear()̗Dxto[W
void CbkQue_surface_clear(ST_CbkQue* pCbkQue, int pri, SURFACE* surface, int color) {
	struct ST_CbkQue_surface_clear* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_surface_clear, sizeof(struct ST_CbkQue_surface_clear));
	p->surface		= surface;
	p->color		= color;
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_set_draw_area {
	RENDER*			render;			//+ 0, 4
	 int16_t		left;			//+ 4, 2
	 int16_t		top;			//+ 6, 2
	 int16_t		right;			//+ 8, 2
	 int16_t		bottom;			//+10, 2
};							//=12
static void fn_CbkQue_render_set_draw_area(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_set_draw_area* p = param;
	RENDER* render		= p->render;
	render->left		= p->left;
	render->top		= p->top;
	render->right		= p->right;
	render->bottom		= p->bottom;
}
/*--------------------------------------------------------------------------*/
//RENDER.left,top,right,bottomݒ肷Dxto[W
void CbkQue_render_set_draw_area(ST_CbkQue* pCbkQue, int pri, RENDER* render, int left, int top, int right, int bottom) {
	struct ST_CbkQue_render_set_draw_area* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_set_draw_area, sizeof(struct ST_CbkQue_render_set_draw_area));
//{{NbsÖɃT[tFCX͈͊Oݒ肷Ɗe`֐j󂷂鋰ꂪL̂ŁAŜ߂ɃNbsÖ悪͈͓ł鎖mFĂB
	SURFACE* surface	= render->surface;
	if((left < 0) || (right  > surface->w) || (left >  right) ||		//NbsÖ̍ET[tFCX͈͓̔łAEt]ĂȂB
	   (top  < 0) || (bottom > surface->h) || (top  > bottom)) { DIE(); }	//NbsÖ̏㉺T[tFCX͈͓̔łA㉺t]ĂȂB
//}}NbsÖɃT[tFCX͈͊Oݒ肷Ɗe`֐j󂷂鋰ꂪL̂ŁAŜ߂ɃNbsÖ悪͈͓ł鎖mFĂB
	p->render		= render;
	p->left			= left;
	p->top			= top;
	p->right		= right;
	p->bottom		= bottom;
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_set_draw_area_full {
	RENDER*			render;			//+ 0, 4
};							//= 4
static void fn_CbkQue_render_set_draw_area_full(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_set_draw_area_full* p = param;
	RENDER* render		= p->render;
	SURFACE* surface	= render->surface;
	render->left		= 0;
	render->top		= 0;
	render->right		= surface->w;
	render->bottom		= surface->h;
}
/*--------------------------------------------------------------------------*/
//RENDER.left,top,right,bottomT[tFCXŜɐݒ肷Dxto[W
void CbkQue_render_set_draw_area_full(ST_CbkQue* pCbkQue, int pri, RENDER* render) {
	struct ST_CbkQue_render_set_draw_area_full* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_set_draw_area_full, sizeof(struct ST_CbkQue_render_set_draw_area_full));
	p->render		= render;
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_point {
	RENDER*			render;			//+ 0, 4
	 int16_t		x;			//+ 4, 2
	 int16_t		y;			//+ 6, 2
	uint16_t		color;			//+ 8, 2
    //	uint16_t		padding;		//+10, 2
};							//=12
static void fn_CbkQue_render_point(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_point* p = param;
	render_point(p->render, p->x, p->y, p->color);
}
/*--------------------------------------------------------------------------*/
//render_point()̗Dxto[W
void CbkQue_render_point(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int color) {
	struct ST_CbkQue_render_point* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_point, sizeof(struct ST_CbkQue_render_point));
	p->render		= render;
	p->x			= x;
	p->y			= y;
	p->color		= color;
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_line {
	RENDER*			render;			//+ 0, 4
	 int16_t		x0;			//+ 4, 2
	 int16_t		y0;			//+ 6, 2
	 int16_t		x1;			//+ 8, 2
	 int16_t		y1;			//+10, 2
	uint16_t		color;			//+12, 2
    //	uint16_t		padding;		//+14, 2
};							//=16
static void fn_CbkQue_render_line(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_line* p = param;
	render_line(p->render, p->x0, p->y0, p->x1, p->y1, p->color);
}
/*--------------------------------------------------------------------------*/
//render_line()̗Dxto[W
void CbkQue_render_line(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x0, int y0, int x1, int y1, int color) {
	struct ST_CbkQue_render_line* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_line, sizeof(struct ST_CbkQue_render_line));
	p->render		= render;
	p->x0			= x0;
	p->y0			= y0;
	p->x1			= x1;
	p->y1			= y1;
	p->color		= color;
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_rectangle {
	RENDER*			render;			//+ 0, 4
	 int16_t		x;			//+ 4, 2
	 int16_t		y;			//+ 6, 2
	 int16_t		w;			//+ 8, 2
	 int16_t		h;			//+10, 2
	uint16_t		color;			//+12, 2
	uint8_t			fill;			//+14, 1
    //	uint8_t			padding;		//+15, 1
};							//=16
static void fn_CbkQue_render_rectangle(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_rectangle* p = param;
	(*(p->fill ? render_rectangle_fill : render_rectangle))(p->render, p->x, p->y, p->w, p->h, p->color);
}
static void CbkQue_render_rectangle_subr(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int w, int h, int color, int fill) {
	struct ST_CbkQue_render_rectangle* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_rectangle, sizeof(struct ST_CbkQue_render_rectangle));
	p->render		= render;
	p->x			= x;
	p->y			= y;
	p->w			= w;
	p->h			= h;
	p->color		= color;
	p->fill			= fill;
}
/*--------------------------------------------------------------------------*/
//render_rectangle()̗Dxto[W
void CbkQue_render_rectangle(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int w, int h, int color) {
	CbkQue_render_rectangle_subr(pCbkQue, pri, render, x, y, w, h, color, 0/*fill*/);
}
//render_rectangle_fill()̗Dxto[W
void CbkQue_render_rectangle_fill(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int w, int h, int color) {
	CbkQue_render_rectangle_subr(pCbkQue, pri, render, x, y, w, h, color, 1/*fill*/);
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_printf {
	RENDER*			render;			//+ 0, 4
	 int16_t		x;			//+ 4, 2
	 int16_t		y;			//+ 6, 2
	uint16_t		type;			//+ 8, 2
	uint16_t		color;			//+10, 2
	uint8_t			framed;			//+12, 1
	char			str[0];			//+13, ?
};							//=13+ ?
static void fn_CbkQue_render_printf(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_printf* p = param;
	(*(p->framed ? render_string_framed : render_string))(p->render, p->x, p->y, p->str, p->type, p->color);
}
static void CbkQue_render_printf_subr(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int type, int color, const char* fmt, va_list ap, int framed) {
	struct ST_CbkQue_render_printf* p;
	va_list ap2;
	va_copy(ap2, ap);
	p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_printf, sizeof(struct ST_CbkQue_render_printf) + vscprintf(fmt, ap2) + 1/*nul*/);
	va_end(ap2);
	p->render		= render;
	p->x			= x;
	p->y			= y;
	p->type			= type;
	p->color		= color;
	p->framed		= framed;
	vsprintf(p->str, fmt, ap);
}
/*--------------------------------------------------------------------------*/
//render_printf()̗Dxto[W
void CbkQue_render_printf(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int type, int color, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	CbkQue_render_printf_subr(pCbkQue, pri, render, x, y, type, color, fmt, ap, 0/*framed*/);
	va_end(ap);
}
//render_printf_framed()̗Dxto[W
void CbkQue_render_printf_framed(ST_CbkQue* pCbkQue, int pri, RENDER* render, int x, int y, int type, int color, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	CbkQue_render_printf_subr(pCbkQue, pri, render, x, y, type, color, fmt, ap, 1/*framed*/);
	va_end(ap);
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_sprite_draw {
	 int16_t		x;			//+ 0, 2
	 int16_t		y;			//+ 2, 2
	uint16_t		sprno;			//+ 4, 2
	uint16_t		param;			//+ 6, 2
};							//= 8
static void fn_CbkQue_sprite_draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_sprite_draw* p = param;
	sprite_draw(p->x, p->y, p->sprno, p->param);
}
/*--------------------------------------------------------------------------*/
//sprite_draw()̗Dxto[W
void CbkQue_sprite_draw(ST_CbkQue* pCbkQue, int pri, int x, int y, int sprno, int param) {
	struct ST_CbkQue_sprite_draw* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_sprite_draw, sizeof(struct ST_CbkQue_sprite_draw));
	p->x			= x;
	p->y			= y;
	p->sprno		= sprno;
	p->param		= param;
}
/****************************************************************************
 *	
 ****************************************************************************/
//W[łsprite_draw2()̗Dxto[W`Ȃɂ܂BŔAȉ̒ʂłB
//sprite_draw2()ĂяoƁAclipspr2.o,y,A3D֘AW[NĂ܂܂BɁA3D֘AW[̗eʂ傫łB
//炪ʂɃNāAAvP[V̗eʂ鎖邽߂ɁAW[łsprite_draw2()̗Dxto[W`Ȃɂ܂B
//̑ɁAsprite_draw2()̗Dxto[WgpAvP[Vł́AAvP[Ṽ\[XR[hɁAȉ̃R[hRs[ĎgpĉB
#if 0
struct ST_CbkQue_sprite_draw2 {
	 int16_t		x;			//+ 0, 2
	 int16_t		y;			//+ 2, 2
	uint16_t		sprno;			//+ 4, 2
	uint16_t		param;			//+ 6, 2
	fixed			scale_x;		//+ 8, 4
	fixed			scale_y;		//+12, 4
	fixed			rot;			//+16, 4
};							//=20
static void fn_CbkQue_sprite_draw2(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_sprite_draw2* p = param;
	sprite_draw2(p->x, p->y, p->sprno, p->param, p->scale_x, p->scale_y, p->rot);
}
/*--------------------------------------------------------------------------*/
//sprite_draw2()̗Dxto[W
void CbkQue_sprite_draw2(ST_CbkQue* pCbkQue, int pri, int x, int y, int sprno, int param, fixed scale_x, fixed scale_y, fixed rot) {
	struct ST_CbkQue_sprite_draw2* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_sprite_draw2, sizeof(struct ST_CbkQue_sprite_draw2));
	p->x			= x;
	p->y			= y;
	p->sprno		= sprno;
	p->param		= param;
	p->scale_x		= scale_x;
	p->scale_y		= scale_y;
	p->rot			= rot;
}
#endif
