/*	
 *	clipacm.c
 *
 *	USB CDC ACM (Communication Device Class Abstract Control Model)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2007 Naoyuki Sawa
 *
 *	* Tue Oct 30 17:22:39 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	- clipuioW[ɂč쐬܂B
 *	  ̓eclipuioƊSɓȂ̂ŁAȂ܂B
 *	  clipuio.c̃RgQƂĂB
 *	- clipuioƂ̈Ⴂ́Aȉ̓_łB
 *	  clipuio̓x_ƎNX̃foCXłApcecom.sysɂāAVA|[gƔFĂ܂B
 *	  clipacmCDC ACMNX̃foCXłAWindowsWusbser.sysɂāAVA|[gƔF܂B
 *	  ACXg[̂݁AƎcdcacm.infKvłB(usbser.sys𗘗pfoCX̋ʎdlłB)
 *	* Wed Oct 31 22:31:30 JST 2007 Naoyuki Sawa
 *	- SERIAL_STATE NotificationɑΉ܂B
 *	* Sun Nov 04 14:04:02 JST 2007 Naoyuki Sawa
 *	- (DTR)(DSR)łȂA(DSR)(CD)Ƀ[vobN悤ύX܂B
 *	* Thu Nov 08 17:28:08 JST 2007 Naoyuki Sawa
 *	- 64~NoCg̃f[^𑗐MƂɁAWindowsŎMȂ܂B
 *	* Fri Dec 07 16:28:26 JST 2007 Naoyuki Sawa
 *	- class_request()̃RgǋL܂B
 *	* Sat Dec 08 14:51:28 JST 2007 Naoyuki Sawa
 *	- clipusb̎dlύXɒǏ]AMI[o[Ƃ܂B
 *	  Acdcacm_recv()AMI[o[}CiXl̖߂lԂƂ͖Ȃ̂ŁA
 *	  AvP[V߂lāAKvɉcdcacm_reset()Ăяo͕svƂȂ܂B
 *		[ύXO]
 *			len = cdcacm_recv(dat, sizeof dat);
 *			if(len < 0) {
 *				MI[o[̏();
 *				cdcacm_reset();
 *			}
 *			if(len > 0) {
 *				Mł̏();
 *			}
 *		[ύX]
 *			len = cdcacm_recv(dat, sizeof dat);
 *			if(len > 0) {
 *				Mł̏();
 *			}
 *	  MI[o[̊TOȂ̂ŁAAvP[V̏啪ȒPɂȂƎv܂B
 *	- ̕ύXɂAɂclipuioƊ֐dl̈ꕔႪ̂ŁARgǋL܂B
 *	* Tue Dec 11 14:26:45 JST 2007 Naoyuki Sawa
 *	- M_uobt@𗘗p悤ύX܂B
 *	- ܂ł́AM_uobt@͗pĂ܂AM_uobt@͗pĂ܂łB
 *	  Mobt@͕Жʂ݂̂pÃpPbgM荞݂҂āÃpPbg𑗐MĂ܂B
 *	  ̕ύXɂAMobt@ʂpāAʊJĂ΂܂Ƃ߂2pPbgނ悤ύX܂B
 *	  ܂AЖʏݒɂЖʂJAJЖʂɂ݂܂B
 *	  (^C~OIɂ܂Ƃ͎v܂A3pPbgȏ܂Ƃ߂ďނƂ肦܂B)
 *	- ̕ύXɂAЖʂւ݂̏ƂЖʂ̑MŝŁAMxシƎv܂B
 *	  AĂ݂ƁAMx͕ύXOƕς܂łBőX[vbǵAȉ̂ƂłB
 *		P/ECE <- PC	 120000 oCg/b
 *		P/ECE -> PC	  60000 oCg/b
 *	  AbvXg[̃X[vbgA_EXg[̃X[vbgoȂ́AMobt@
 *	  ЖʂgĂȂ̂ƍlāA̕ύXŝłAOq̂Ƃʂ܂łB
 *	  USB̓A܂́AWindowsUSBVAhCo̓Ǝv܂B
 *	- Ȃ킯ŁA̕ύX́AxIɂ͌ʂȂ̂łǁAȉ̂悤ȕʂ̗_܂B
 *	- _1: MƑMŃR[hΏ̓IɂȂ܂B
 *		 cdcacm_recv()cdcacm_send()Aep2_rxsub()ep2_txsub()̏eAقڑΏۂłB
 *		 ύXOA킩₷vOɂȂƎv܂B
 *	- _2: 萫サ܂B
 *		 ύXÓAȉ̂悤ȏꍇɁAP/ECE->PC̑MłȂȂĂ܂ꍇ܂B
 *			1. P/ECEPCɐڑAUSB CDC ACMsBPCzCOM|[gFB
 *			2. WindowsAvP[VzCOM|[gJOɁAP/ECEf[^𑗐MB
 *			3. WindowsAvP[VzCOM|[gJB
 *			4. ȍ~AǂĂP/ECE->PC̃f[^͂ȂȂ܂B(P/ECEȂΉ)
 *			   ̖hɂ́AWindowsAvP[VzCOM|[gJ܂ŁA
 *			   P/ECEf[^𑗐MȂ悤ɂ邵܂łB
 *		 ̕ύXɂAq̂悤ȃP[XłAP/ECE->PC̃f[^͂悤ɂȂ܂B
 *		 (AWindowsAvP[VzCOM|[gJOɑMf[^͔j悤łB)
 *		 ȂPꂽ̂R͂肵Ȃ̂łǁAύXO͑Mobt@̋󂫏ԂvO
 *		 ǐՂĂ̂AύXUSBCɎۂɏł݂Ĕf悤ɂȂ̂Rm܂B
 *		 ύXÕR[h́AMobt@̋󂫏ԂǐՂ@ɖ肪̂܂B(v)
 *		 2007/12/13:ǋL
 *		 킩܂B
 *		 ́ASetAddressEnableSetEndpointEnablesOɁAMsĂ܂ĂƂłB
 *		 ȉɁAڂ܂B
 *		 - ŁAuWindowsAvP[VzCOM|[gJOɁAP/ECEf[^𑗐MvƖ肪Ə܂AsmłB
 *		   ́AuWindowsUSBVAhCozCOM|[gFASET_ADDRESS,SET_CONFIGURATIOÑfoCXNGXg𔭍sOɁA
 *		   P/ECEf[^𑗐MvƖ肪܂B
 *		   USB CDC ACMsA10b炢҂ĉzCOM|[gƂĔFꂽł΁AWindowsAvP[VzCOM|[gJO
 *		   P/ECEf[^𑗐MĂAWindowsUSBVAhCoK؂ɃubN̂Ŗ͔܂B
 *		 - SET_ADDRESS,SET_CONFIGURATIOÑfoCXNGXg𔭍sOAȂ킿APDIUSBD12SetAddressEnableSetEndpointEnablesO
 *		   WriteBufferƁAꌩA݂͐Ă悤Ɍ̂łA񂾃f[^͎̂ĂĂ܂悤łB
 *		   ǂɂG[Xe[^X͎ꂸAM荞݂܂B(BPDIUSBD12̃}jAɂ͋LڂĂ܂B)
 *		   ύXÕR[h́AAăf[^𑗐Mꍇ́AM荞݂gKƂĂ߁AgKƁA
 *		   iɎ̑MsȂȂĂ܂Ă̂łB
 *		   ύX̃R[h́AgKĂAcdcacm_send()ɃGh|Cgł邱ƂăGh|Cgɏ݂܂B
 *		   񂾃f[^͂܂̂Ă܂AAWindowsUSBVAhCoSET_ADDRESS,SET_CONFIGURATIOÑfoCXNGXg𔭍sA
 *		   SetAddressEnableSetEndpointEnablesƁAȍ~ɏ񂾃f[^͎̂ĂꂸɗLɑM̂łB
 *		   ύXÕR[hAύX̃R[hAȃGh|CgWriteBufferĂƂ_ŁAPDIUSBD12Undoc'dȋɈˑA
 *		   ]܂ȂłBύX̃R[h́A܂܉񕜂\łƂႢłB
 *		 - ]܂Ȃh߂ɂ́Aɂ́AWindowsUSBVAhCoSET_ADDRESS,SET_CONFIGURATIOÑfoCXNGXg𔭍sA
 *		   SetAddressEnableSetEndpointEnables܂ł́Acdcacm_send()gȂĂKv܂B
 *		   A_ł́ẢC͍sȂƂɂ܂B
 *		   C͍sȂRƂāAP/ECE\IɃf[^MJn邱Ƃ͋Hł邩łB(̓eXĝ߂ɂ킴Ƃ܂)
 *		   AP/ECE\IɃf[^MJn邱ƂƂĂAύX̃R[hł΁AOq̂悤ɒPɎ̂Ă邾łB
 *		   PC̏OɑMf[^̂ĂƂ́A{RS-232CƓłA܂Aɂ͂ȂȂƎv܂B
 *		   ȏ̂悤ȗRƁAvOPɕۂ߂ɁACsȂƂɂ܂B
 *		 - ȂAuWindowsUSBVAhCozCOM|[gFASET_ADDRESS,SET_CONFIGURATIOÑfoCXNGXg𔭍sOɁA
 *		   P/ECEf[^𑗐MvƂ󋵂́AP/ECEɊdrĎgƁAȒPɍČł܂B
 *		   P/ECEɊdrāAUSB CDC ACMsAMJnǍPCɐڑ΁A󋵂ƂȂ܂B
 *		   ̏ꍇłĂAύX̃R[hȂ΁APCɐڑĉzCOM|[gƂĔFOɑMf[^́APɎ̂Ă邾łB
 *		   PCɐڑĉzCOM|[gƂĔFꂽ́AɃf[^M܂B
 */
#include "clip.h"

/****************************************************************************
 *	fBXNv^`
 ****************************************************************************/

static const DEVICE_DESCRIPTOR device_desc = {
	bLength:		sizeof(DEVICE_DESCRIPTOR),
	bDescriptorType:	DEVICE_DESCRIPTOR_TYPE,
	bcdUSB:			0x0110,
	bDeviceClass:		0x02,			/* Communication Device Class */
	bMaxPacketSize0:	EP0_PACKET_SIZE,
	idVendor:		PCE_VENDOR_ID,
	idProduct:		CDCACM_PRODUCT_ID,	/* d֎~!! */
	bcdDevice:		0x0001,
	iManufacture:		1,
	iProduct:		2,
	bNumConfigurations:	1,
};

/*--------------------------------------------------------------------------*/

static const CONFIGURATION_DESCRIPTOR config_desc = {
	bLength:		sizeof(CONFIGURATION_DESCRIPTOR),
	bDescriptorType:	CONFIGURATION_DESCRIPTOR_TYPE,
	wTotalLength:		sizeof(CONFIGURATION_DESCRIPTOR) +	/* config_desc */
				sizeof(INTERFACE_DESCRIPTOR) +		/* interface_desc_0 */
				(5+4+5+5) +				/* cdc_class_specific_desc_0 */
				sizeof(ENDPOINT_DESCRIPTOR) +		/* endpoint_desc_ep1in */
				sizeof(INTERFACE_DESCRIPTOR) +		/* interface_desc_1 */
				sizeof(ENDPOINT_DESCRIPTOR) +		/* endpoint_desc_ep2out */
				sizeof(ENDPOINT_DESCRIPTOR),		/* endpoint_desc_ep2in */
	bNumInterfaces:		2,
	bConfigurationValue:	1,
	bmAttributes:		0x80,		/* Bus-powered */
	MaxPower:		100 / 2,	/* 100[mA] () */
};
static const INTERFACE_DESCRIPTOR interface_desc_0 = {
	bLength:		sizeof(INTERFACE_DESCRIPTOR),
	bDescriptorType:	INTERFACE_DESCRIPTOR_TYPE,
	bInterfaceNumber:	0,
	bNumEndpoints:		1,
	bInterfaceClass:	0x02,	/* Communication Interface Class */
	bInterfaceSubClass:	0x02,	/* Abstract Control Model */
	bInterfaceProtocol:	0x01,	/* V.25ter */
};
static const unsigned char cdc_class_specific_desc_0[5+4+5+5] = {
	5,		/* bFunctionLength */
	0x24,		/* bDescriptorType = CS_INTERFACE */
	0x00,		/* bDescriptorSubtype = Header Functional Descriptor */
	0x10, 0x01,	/* bcdCDC */
	//
	4,		/* bFunctionLength */
	0x24,		/* bDescriptorType = CS_INTERFACE */
	0x02,		/* bDescriptorSubtype = Abstract Control Management Functional Descriptor */
	0x02,		/* bmCapabilities = SET_LINE_CODING,GET_LINE_CODING,SET_CONTROL_LINE_STATE,SERIAL_STATE */
	//
	5,		/* bFunctionLength */
	0x24,		/* bDescriptorType = CS_INTERFACE */
	0x06,		/* bDescriptorSubtype = Union Functional descriptor */
	0,		/* bMasterInterface */
	1,		/* bSlaveInterface0 */
	//
	5,		/* bFunctionLength */
	0x24,		/* bDescriptorType = CS_INTERFACE */
	0x01,		/* bDescriptorSubtype = Call Management Functional Descriptor */
	0x00,		/* bmCapabilities */
	1,		/* bDataInterface */
};
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep1in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x81,				/* EP1IN */
	bmAttributes:		3,				/* Interrupt */
	wMaxPacketSize:		EP1_PACKET_SIZE,
	bInterval:		2,				/* 2[ms] */
};
static const INTERFACE_DESCRIPTOR interface_desc_1 = {
	bLength:		sizeof(INTERFACE_DESCRIPTOR),
	bDescriptorType:	INTERFACE_DESCRIPTOR_TYPE,
	bInterfaceNumber:	1,
	bNumEndpoints:		2,
	bInterfaceClass:	0x0A,				/* Data Interface Class */
};
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2out = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x02,				/* EP2OUT */
	bmAttributes:		2,				/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x82,				/* EP2IN */
	bmAttributes:		2,				/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};

/*--------------------------------------------------------------------------*/

static const char* const string_desc[] = {
//	   ++-- 04 06 08 0a 0c 0e 10 12 14 16 18 1a 1c 1e 20 22 24 26 28 2a 2c 2e 30
//	   ||
//	"\x??\3_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0"
	"\x04\3\x09\x04",						// 0: wLANGID = 0x0409 English (United States)
	"\x16\3P\0i\0e\0c\0e\0 \0L\0a\0b\0.\0",				// 1: iManufacture   = "Piece Lab."
	"\x22\3P\0/\0E\0C\0E\0 \0U\0S\0B\0 \0d\0e\0v\0i\0c\0e\0",	// 2: iProduct       = "P/ECE USB device"
};

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _CDCACM {
	unsigned char* rxbuf/*[rxcap]*/;
	int rxcap;
	int rxpos;
	int rxlen;
	int rxlog;
	void (*rxdone)();
	//
	unsigned char* txbuf/*[txcap]*/;
	int txcap;
	int txpos;
	int txlen;
	int txlog;
	void (*txdone)();
} CDCACM;
static CDCACM cdcacm;

static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void ep2_rxdone();
static void ep2_rxsub();
static void ep2_txdone();
static void ep2_txsub();

static const USBINF usb_inf = {
	/* USBC mode */
	mode:			D12_ENDP_NONISO,
	/* USBC raw event */
	/* Communication Class Interface */
/*{{gp*/
//	ep1_txdone:		ep1_txdone,
/*}}gp*/
	/* Data Class Interface */
	ep2_rxdone:		ep2_rxdone,
	ep2_txdone:		ep2_txdone,
	/* Device request */
	get_descriptor:		get_descriptor,
	set_configuration:	set_configuration,
	set_interface:		set_interface,
	/* Class request */
	class_request:		class_request,
};

/* * Wed Oct 31 22:31:30 JST 2007 Naoyuki Sawa
 * - xłSERIAL_STATEʒm(CTS)=1ɂȂAx(CTS)=0ɖ߂܂B
 *   usbser.sys̎dl݂łB(Win2K SP4ɂĎ)
 * - wIndexɂ́ACommunication Class InterfaceA܂́AData Class InterfaceA
 *   ǂInterfaceԍw肷ׂȂ̂słB
 *   Win2K SP4ŎƂAǂł삵܂B
 *   wIndex=0(Communication Class Interface)ƂĂƂɂ܂B
 * * Sun Nov 04 14:43:12 JST 2007 Naoyuki Sawa
 * - (CTS)=0ɖ߂Ȃ̗RɂāA[L܂B
 *	u˓cF̎ݔiΔ(http://www.lbm.go.jp/toda/)v
 *	uRS-232CP[ũNXdlɊւl@(http://www.lbm.go.jp/toda/comp/rscross.html)v
 *   ukeep/RS-232CP[ũNXdlɊւl@.7zvɕۑĂ̂ŁAQƂĂB
 */
typedef struct _SerialStateNotification {
	unsigned char bmRequestType;	/* +0,1 = 0xA1 (In,ClassRequest,1)*/
	unsigned char bNotification;	/* +1,1 = 0x20 (SERIAL_STATE) */
	unsigned short wValue;		/* +2,2 = 0 (Œ) */
	unsigned short wIndex;		/* +4,2 = 0 (Interface) */
	unsigned short wLength;		/* +6,2 = 2 (DataLength) */
	/*{{UART State Bitmap*/		/* +8,2 */
	unsigned short bRxCarrier  : 1;	/*      = (CD) */
	unsigned short bTxCarrier  : 1;	/*      = (DSR) */
	unsigned short bBreak      : 1;
	unsigned short bRingSignal : 1;	/*      = (RI) */
	unsigned short bFraming    : 1;
	unsigned short bParity     : 1;
	unsigned short bOverRun    : 1;
	unsigned short             : 9;
	/*}}UART State Bitmap*/
} SerialStateNotification;		/* =10 */
static SerialStateNotification serial_state_notification = { 0xA1,0x20,0,0,2 };

/****************************************************************************
 *	
 ****************************************************************************/

static void
get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	static unsigned char tmpbuf[sizeof(CONFIGURATION_DESCRIPTOR) +	/* config_desc */
				    sizeof(INTERFACE_DESCRIPTOR) +	/* interface_desc_0 */
				    (5+4+5+5) +				/* cdc_class_specific_desc_0 */
				    sizeof(ENDPOINT_DESCRIPTOR) +	/* endpoint_desc_ep1in */
				    sizeof(INTERFACE_DESCRIPTOR) +	/* interface_desc_1 */
				    sizeof(ENDPOINT_DESCRIPTOR) +	/* endpoint_desc_ep2out */
				    sizeof(ENDPOINT_DESCRIPTOR)];	/* endpoint_desc_ep2in */
	//
	int type  = HIBYTE(req->wValue);
	int index = LOBYTE(req->wValue);

	switch(type) {
	case DEVICE_DESCRIPTOR_TYPE:
		usb_ep0_tx(&device_desc, sizeof(DEVICE_DESCRIPTOR));
		return;
	case CONFIGURATION_DESCRIPTOR_TYPE:
		switch(index) {
		case 0:
			len = 0;
			memcpy(&tmpbuf[len], &config_desc              , sizeof(CONFIGURATION_DESCRIPTOR)); len += sizeof(CONFIGURATION_DESCRIPTOR);
			memcpy(&tmpbuf[len], &interface_desc_0         , sizeof(INTERFACE_DESCRIPTOR)    ); len += sizeof(INTERFACE_DESCRIPTOR)    ;
			memcpy(&tmpbuf[len], &cdc_class_specific_desc_0, (5+4+5+5)                       ); len += (5+4+5+5)                       ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep1in      , sizeof(ENDPOINT_DESCRIPTOR)     ); len += sizeof(ENDPOINT_DESCRIPTOR)     ;
			memcpy(&tmpbuf[len], &interface_desc_1         , sizeof(INTERFACE_DESCRIPTOR)    ); len += sizeof(INTERFACE_DESCRIPTOR)    ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2out     , sizeof(ENDPOINT_DESCRIPTOR)     ); len += sizeof(ENDPOINT_DESCRIPTOR)     ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2in      , sizeof(ENDPOINT_DESCRIPTOR)     ); len += sizeof(ENDPOINT_DESCRIPTOR)     ;
			usb_ep0_tx(tmpbuf, len);
			return;
		}
		break;
	case STRING_DESCRIPTOR_TYPE:
		if(index < ARRAY_SIZE(string_desc)) {
			usb_ep0_tx(string_desc[index], string_desc[index][0]);
			return;
		}
		break;
	}
	usb_ep0_stall(); /* Ή */
}

static void
set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	D12_SetEndpointEnable(req->wValue == 1);
	usb_ep0_tx(NULL, 0); /* ACK */
}

static void
set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	usb_ep0_tx(NULL, 0); /* ACK */
}

static void
class_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	static unsigned char line_coding_structure[7];

	switch(req->bRequest) {
/*{{Ή*/
//	/* SEND_ENCAPSULATED_COMMAND (Required) */
//	case 0x00:
//	/* GET_ENCAPSULATED_RESPONSE (Required) */
//	case 0x01:
/*}}Ή*/
	/* SET_LINE_CODING (Optional) */
	case 0x20:
		memcpy(line_coding_structure, dat, 7);
		usb_ep0_tx(NULL, 0); /* ACK */
		return;
	/* GET_LINE_CODING (Optional) */
	case 0x21:
		usb_ep0_tx(line_coding_structure, 7);
		return;
	/* SET_CONTROL_LINE_STATE (Optional) */
	case 0x22:
		usb_ep0_tx(NULL, 0); /* ACK */
		/* * Wed Oct 31 22:31:30 JST 2007 Naoyuki Sawa
		 * - (DTR)(DSR)Ƀ[vobN邱Ƃɂ܂B
		 * - AInterrupt|[OԊuZԊuSET_CONTROL_LINE_STATEāA
		 *   O"D12_WriteEndpoint(EP1IN,`)"ɂȂĂA肠܂B
		 *   SERIAL_STATE{bRxCarrier,bTxCarrier}́AŐVԂ݂̂ʒmΗǂłB
		 *   A{bBreak,bRingSignal,bFraming,bParity,bOverRun}̓gKʒmȂ̂ŁA
		 *   Ɩ肪܂A2007/10/31݂͎gĂȂ̂ővłB
		 *    * Fri Dec 07 16:28:26 JST 2007 Naoyuki Sawa
		 *    悭lAD12_WriteEndpoint()̓obt@t̂Ƃ͏܂ȂdlōĂ̂ŁAȌԂD悳Ă܂܂B
		 *    Interrupt|[OԊuZԊuSET_CONTROL_LINE_STATE邱Ƃ͂܂Ǝv̂ŁAԂvƎv܂A
		 *    肪ꍇ́Aep1_txdoneR[obN𗘗p悤AύXKv邩m܂B
		 * - SERIAL_STATEʒm邱ƂɂāAWindows͎I(CTS)=1Ɣf܂B
		 *   ڂ́ASerialStateNotification\̂̏ɏRgQƂĂB
		 */
		//serial_state_notification.bTxCarrier = (req->wValue & 1);
		//* Sun Nov 04 14:04:02 JST 2007 Naoyuki Sawa
		//- (DTR)(DSR)łȂA(DSR)(CD)Ƀ[vobN悤ύX܂B
		//  ʓIȃNXP[uڑ͈ȉ̂悤Ȃ̂ŁAɏ]߂łB
		//
		//	 DTE(p\R) 			 DTE(p\R) 
		//	-----------------			-----------------
		//	M sԍ			M sԍ
		//	   GND       1   -----------------------   GND       1   
		//	   TxD       2   -----------+   +-------   TxD       2   
		//	                        +---|---+                        
		//	   RxD       3   <------+   +---------->   RxD       3   
		//	   RTS       4   -----------+   +-------   RTS       4   
		//	                        +---|---+                        
		//	   CTS       5   <------+   +---------->   CTS       5   
		//	   DSR       6   <--+               +-->   DSR       6   
		//	   GND       7   ---|---------------|---   GND       7   
		//	   CD        8   <--+-------+   +---+-->   CD        8   
		//	   TxC2     15          +---|---+          TxC2     15   
		//	   RxC      17          |   |              RxC      17   
		//	   DTR      20   -------+   +-----------   DTR      20   
		//	   RI       22   			   RI       22   
		//	   TxC1     24   			   TxC1     24   
		//
		//	wgI/OC^tF[XbuxFrv,ĉj
		//	p.159}4-14:RS-232C𗘗pDTEm̐ڑ(NXP[ugڑ)
		//- ɂ́A(CD)ĎĂAvP[V͂قƂǖƎv̂ŁA
		//  ̕ύX͂܂Ӗm܂񂪁AÔ߂ɕύXĂƂɂ܂B
		//
		if(req->wValue & 1) { /* (DTR) */
			serial_state_notification.bRxCarrier = 1; /* (CD) */
			serial_state_notification.bTxCarrier = 1; /* (DSR) */
		} else {
			serial_state_notification.bRxCarrier = 0; /* (CD) */
			serial_state_notification.bTxCarrier = 0; /* (DSR) */
		}
		len = D12_WriteBuffer(EP1IN, &serial_state_notification, 10);
		if(len != -1) {
			D12_ValidateBuffer(EP1IN);
		}
		return;
	}
	usb_ep0_stall(); /* Ή */
}

/****************************************************************************
 *	
 ****************************************************************************/

/* * Sat Dec 08 14:00:19 JST 2007 Naoyuki Sawa
 * - NOTE: M_uobt@́Aobt@#1t(܂ǂݏoĂȂ)Aobt@#2̏ԂŁA
 *   obt@#2ɁAVpPbg^C~OłAM荞݂悤łB
 *   ̎ɂ͓Ɋ֌WL܂񂪁Â߂ɁAȏ̂ƂL^ĂƂɂ܂B
 */
static void
ep2_rxdone()
{
	ep2_rxsub();
	if(cdcacm.rxdone) {
		cdcacm.rxdone();
	}
}

static void
ep2_rxsub()
{
	unsigned char _dat[EP2_NONISO_PACKET_SIZE];
	unsigned char* dat;
	int len;
	int pos;

	for(;;) { /* _uobt@ɓpPbgSď */
		len = D12_ReadBuffer(EP2OUT, _dat, sizeof _dat);
		if((len == -1) || /* pPbg */
		   (len > (cdcacm.rxcap - cdcacm.rxlen))) {
			/* cdcacm.rxbufɋ󂫂ꍇ́ApPbgNAɁAUSBC̎Mobt@ɎcĂ܂B
			 * Mobt@ɑÕpPbgcĂ΁APC͎̃pPbg𑗐MłAubNԂƂȂ܂B
			 * ƂŁAcdcacm_recv()ĂяoAcdcacm.rxbufɋ󂫂łAcĂpPbgǂݏo܂B
			 * ɂāAMobt@ƂȂāAPC̃ubNԂāÃpPbgĂ܂B
			 */
			break;
		}
		D12_ClearBuffer(EP2OUT);
		if(len) {
			pos = (cdcacm.rxpos + cdcacm.rxlen);
			cdcacm.rxlen += len;
			dat = _dat;
			do {
				if(pos >= cdcacm.rxcap) {
					pos -= cdcacm.rxcap;
				}
				cdcacm.rxbuf[pos] = *dat++;
				pos++;
			} while(--len);
		}
	}
}

static void
ep2_txdone()
{
	if(cdcacm.txlen) {
		ep2_txsub();
	} else {
		if(cdcacm.txdone) {
			cdcacm.txdone();
		}
	}
}

static void
ep2_txsub()
{
	/* * Thu Nov 08 17:28:08 JST 2007 Naoyuki Sawa
	 * - 64~NoCg̃f[^𑗐MƂɁAWindowsŎMȂ܂B(WindowsXP SP2ɂČۂƏCmF)
	 *   ȉɁAl@L^Ă܂B
	 * - Data Class InterfaceBulkgXt@́AVAʐMf[^^т܂B
	 *   USBdlɂƁABulkgXt@́Aȉ̕@ŋ؂ƂɂȂĂ܂B
	 * 	 A bulk transfer is complete when the endpoint does one of the following:
	 * 	  Has transferred exactly the amount of data expected						(Öق̋؂)
	 * 	  Transfers a packet with a payload size less than wMaxPacketSize or transfers a zero-length packet	(Iȋ؂)
	 * 	wUniversal Serial Bus Specification Revision 2.0xu5.8.3 Bulk Transfer Packet Size Constraintsv
	 *   VAʐMf[^̓Xg[łAData Class InterfaceBulkgXt@ɂ́A{A؂肪svȂ͂łB
	 *   ƁA1gUNV1gXt@ƌȂƂłAyC[hTCY҂(=64oCg)łÖق̋؂ƔfׂłB
	 *   Ƃ낪AWindowsusbser.syśAData Class InterfaceBulkgXt@ɂAIȋ؂v悤łB
	 *   gUNV̋؂́AzXgRg[≺ʃhCo(usbd.sys)ł͂ȂAusbser.sysfׂƂłB
	 *   usbser.sys̎sK؂Ȃ̂ł͂ȂƎv܂B(Al̗ԈĂ̂܂񂯂ǁc)
	 * - ƂẮA64oCgPʂőMꍇAǉ0oCgpPbg𑗐M̂@łB
	 *   ̂߂ɂ́AclipusbW[EP0(Control Pipe)ɑ΂čsĂ̂ƓlȁAԊǗ̒ǉKvƂȂAGɂȂ肷܂B
	 *   ŁA1gUV̍ő]TCYA63oCgȉɐƂ@p邱Ƃɂ܂B
	 *   M҂f[^64oCgȏcĂꍇA63oCgȉ̃gUVɕđM܂B
	 *   SẴgUNV63oCgȉƂȂ̂ŁAusbser.syśA1gUNV1gXt@ƌȂĂ܂B
	 * - AIusbser.sys̋ύXāAŏɏqׂ]܂dlŋ؂𔻒f悤ɂȂƂĂAe͖͂łB
	 *   64oCgȏ̑傫ȃf[^𑗐MƂɁA1gUNV1oCgቺ邾ŁAɓ삷͂łB
	 * - (v)
	 *   t[c[Bterm.exegĒʐMeXgsƁA64oCgȏ̃f[^MƂɁABterm.exesȃG[(Err00)\悤łB
	 *   ܂A11264oCg(1ʕ)̃f[^ʐMsƁABterm.exeI܂B
	 *   nCp[^[~igĒʐMeXgsꍇɂ͖͔Ȃ̂ŁABterm.exe̖肾Ǝv܂B(obt@?)
	 *   yC[hTCY(=64oCg)ɕs̂͂܂܂łA{W[usbser.sysł͂ȂƎv܂B
	 */
	unsigned char _dat[EP2_NONISO_PACKET_SIZE - 1/*LRgQ*/];
	unsigned char* dat;
	int len;
	int pos;

	for(;;) { /* _uobt@ɏ߂邾Sď */
		len = cdcacm.txlen < sizeof _dat ? cdcacm.txlen : sizeof _dat;
		if(!len) {
			break;
		}
		pos = cdcacm.txpos;
		dat = _dat;
		do {
			*dat++ = cdcacm.txbuf[pos];
			if(++pos == cdcacm.txcap) {
				pos = 0;
			}
		} while(--len);
		len = D12_WriteBuffer(EP2IN, _dat, dat - _dat);
		if(len == -1) { /* _uobt@ʂƂt */
			break;
		}
		D12_ValidateBuffer(EP2IN);
		cdcacm.txlen -= len;
		cdcacm.txpos  = pos;
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
cdcacm_start(int rxcap, int txcap, void (*rxdone)(), void (*txdone)())
{
	cdcacm_stop();
	memset(&cdcacm, 0, sizeof cdcacm);
	if(rxcap < EP2_NONISO_PACKET_SIZE) {
		rxcap = EP2_NONISO_PACKET_SIZE;
	}
	cdcacm.rxcap = rxcap;
	cdcacm.rxbuf = malloc(rxcap);
	if(!cdcacm.rxbuf) {
		DIE();
	}
	cdcacm.rxdone = rxdone;
	if(txcap < EP2_NONISO_PACKET_SIZE) {
		txcap = EP2_NONISO_PACKET_SIZE;
	}
	cdcacm.txcap = txcap;
	cdcacm.txbuf = malloc(txcap);
	if(!cdcacm.txbuf) {
		DIE();
	}
	cdcacm.txdone = txdone;
	usb_start(&usb_inf);
}

void
cdcacm_stop()
{
	usb_stop();
	free(cdcacm.rxbuf);
	free(cdcacm.txbuf);
	memset(&cdcacm, 0, sizeof cdcacm);
}

void
cdcacm_reset()
{
ENTER_CS;
	cdcacm.rxpos = 0;
	cdcacm.rxlen = 0;
	cdcacm.rxlog = 0;
	cdcacm.txpos = 0;
	cdcacm.txlen = 0;
	cdcacm.txlog = 0;
LEAVE_CS;
}

int
cdcacm_recv(void* _dat, int maxlen)
{
	unsigned char* dat = _dat;
	int len;

ENTER_CS;
	do {
		len = cdcacm.rxlen < maxlen ? cdcacm.rxlen : maxlen;
		if(len) {
			maxlen       -= len;
			cdcacm.rxlen -= len;
			cdcacm.rxlog += len;
			do {
				*dat++ = cdcacm.rxbuf[cdcacm.rxpos];
				if(++cdcacm.rxpos == cdcacm.rxcap) {
					cdcacm.rxpos = 0;
				}
			} while(--len);
		}
		/* cdcacm.rxbufɋ󂫂łA̕USBC̎Mobt@ǂݏoB
		 * USBC̎Mobt@ł邾ɂ邽߁AKx͌ĂяoB
		 */
		ep2_rxsub();
	} while(cdcacm.rxlen && maxlen);
LEAVE_CS;
	return dat - (unsigned char*)_dat;
}

int
cdcacm_send(const void* _dat, int maxlen)
{
	const unsigned char* dat = _dat;
	int len;
	int pos;

	if(maxlen < 0) {
		maxlen = strlen((char*)dat);
	}
ENTER_CS;
	do {
		len = (cdcacm.txcap - cdcacm.txlen) < maxlen ? (cdcacm.txcap - cdcacm.txlen) : maxlen;
		if(len) {
			pos = (cdcacm.txpos + cdcacm.txlen);
			maxlen       -= len;
			cdcacm.txlen += len;
			cdcacm.txlog += len;
			do {
				if(pos >= cdcacm.txcap) {
					pos -= cdcacm.txcap;
				}
				cdcacm.txbuf[pos] = *dat++;
				pos++;
			} while(--len);
		}
		/* cdcacm.txbufɒ~ςĂf[^AUSBC̑Mobt@ɏށB
		 * USBC̑Mobt@ɂł邾ނ߁AKx͌ĂяoB
		 */
		ep2_txsub();
	} while((cdcacm.txcap - cdcacm.txlen) && maxlen);
LEAVE_CS;
	return dat - (unsigned char*)_dat;
}

void
cdcacm_stat(CDCACMSTAT* stat)
{
ENTER_CS;
	stat->rxlen = cdcacm.rxlen;
	stat->rxlog = cdcacm.rxlog;
	stat->txlen = cdcacm.txlen;
	stat->txlog = cdcacm.txlog;
LEAVE_CS;
}
