/*
 *	app.c
 *
 *	p`XP/ECE AT
 *
 *	* Sat Aug 30 00:16:12 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_MUSIC
#include "instdef2.c"
#endif /*USE_MUSIC*/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	app_main();

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static void SndMxr_Update() {
	int i;
	unsigned char AttSum[32];
	SndMxr_GetSndChAttAll(pSndMxr,-1,AttSum); //Sق̌ʂ擾
	for(i=0;i<SOUND_MAXCH;i++) {sound_att(i,AttSum[i]);} //Sق̌ʂݒ肷
}
static void SndMxr_TimerProc(void* context) { //Sound Mixerpϊ
//	if(sound_stat(1)) {SndMxr_SetMxrChAtt(pSndMxr,4,64, 0,0);} //1ŉoBGMĐȂΤðBGM𑦏          
//	else              {SndMxr_SetMxrChAtt(pSndMxr,4, 0,64,5);} //1ŉoBGM~ȂΤðBGM0.5bŕA     {{TODO:عݒ}}
//	if(sound_stat(3)) {SndMxr_SetMxrChAtt(pSndMxr,5,64, 0,0);} //3ŴװĐȂΤðBGM,oBGM,SE𑦏 
//	else              {SndMxr_SetMxrChAtt(pSndMxr,5, 0, 0,0);} //3Ŵװ~ȂΤðBGM,oBGM,SE𑦕A 
	SndMxr_Exec(pSndMxr); //Sound Mixers
	SndMxr_Update(); //Sق̌ʂݒ肷
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static int SndSeq_fnLen(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int SndSeq_fnNext(int iPhr) {
	switch(iPhr) {
	case SND_BGM_INTR: return SND_BGM_LOOP;
	case SND_BGM_LOOP: return SND_BGM_LOOP;
	}
	return -1;
}
static int SndSeq_fnPrev(int iPhr) {
	switch(iPhr) {
	case SND_BGM_INTR: return SND_BGM_INTR;
	case SND_BGM_LOOP: return SND_BGM_INTR;
	}
	return -1;
}
static void SndSeq_fnPan(int iTrk, int iPan) {
	//P/ECEɂ̓XeIĐ͖̂ŁA{֐͎gpȂB
}
static void SndSeq_fnVol(int iTrk, int iVol) {
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static void SndSeq_fnStop(int iTrk) {
	sound_stop(iTrk);
}
static void SndSeq_fnPlay(int iTrk, int iPhr, int iVol, int iPan) {
	sound_play(iTrk, sound_table[iPhr], -1);
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static int SndSeq_fnTime() {
	return pceTimerGetCount(); //ݎ[ms]PʂŕԂB
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	switch(iEvtTmrCh) {
	case EvtTmrCh_Mute:	/* 쌸 */
		SndMxr_SetMxrChAtt(pSndMxr, SOUND_MAXCH, iEvent/**/, 64, 30);
		break;
	}
}
#endif/*USE_EVENT_TIMER*/

void
app_init()
{
	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
	pceLCDDispStart();
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(99/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	music_loudness(1);
	loadInst(); /* uRandomism Zone(http://www8.plala.or.jp/randomism/)v́whFLbgver.2.10xgp */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * - music_wchύX鏈́AInitMusic()ōsKv܂B
	 *   InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * - Amusic_loudness()̋@\music_wchQƂĂ܂A
	 *   Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* Sound Mixer܂B */
#ifdef  USE_SOUND_MIXER
	{
		static const int TBL_SndMxr_SndChMask[] = { //Ͻz
			(1<<0),               //Sound Mixer0:ׯ0(޼ݻɂحюw)         
			(1<<1),               //Sound Mixer1:ׯ1(޼ݻɂحюw)         
			(1<<2),               //Sound Mixer2:ׯ2(޼ݻɂحюw)         
			(1<<3),               //Sound Mixer3:ׯ3(޼ݻɂحюw)         {{TODO:عݒ}}
//			(1<<0),               //Sound Mixer4:oBGMĐΏ:ðBGM            
//			(1<<0)|(1<<1)|(1<<2), //Sound Mixer5:װĐΏ  :ðBGM,oBGM,SE 
			-1};                  //Sound Mixer6:İح           :S         
		pSndMxr = SndMxr_Init(ARRAY_SIZE(TBL_SndMxr_SndChMask), TBL_SndMxr_SndChMask); //Sound Mixer쐬
		timer_start(100, SndMxr_TimerProc, NULL); //Sound MixerpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TEhV[PT܂B */
#ifdef  USE_SOUND_SEQUENCER
	{
		static const ST_SndSeqInfo stSndSeqInfo = { &SndSeq_fnTime, &SndSeq_fnPlay, &SndSeq_fnStop, &SndSeq_fnVol, &SndSeq_fnPan, &SndSeq_fnLen, &SndSeq_fnNext, &SndSeq_fnPrev };
		SndSeq_Init(&stSndSeqInfo);
		timer_start(10, SndSeq_Exec, NULL); //޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static const uint16_t TBL_EvtTmr_Mute[]={//쌸^C}
			SEC(30),16,//30b҂āAB
			SEC(30),64,//30b҂āASB
			0,0};//I[
		static const uint16_t* const TBL_EvtTmr_Data[]={//eقް
			TBL_EvtTmr_Mute};//#0ް
		pEvtTmr=EvtTmr_Init(ARRAY_SIZE(TBL_EvtTmr_Data),TBL_EvtTmr_Data,EvtTmr_onEvent);//ς
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_Init(COUNTER_MAXCH);
#endif/*USE_COUNTER_MANAGER*/

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

/*{{AvP[VL̏*/
	/* B */
	WELL_init(&stApp.Rng, pceTimerGetCount());
	/* ݒB */
	stApp.Rank = WELL_next(&stApp.Rng) % 6;
	/* ^XNXPW[B */
	task_init();
	/* t[Cxg쐬B */
	stApp.FrmEvt = event_create(1);		//蓮ZbgCxg
	/* C^XNB */
	Main_Init();
	/* Tu^XNB */
	Sub_Init();
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_MUSIC
	/* mɉyt~܂B
	 * TEh̒~̓CupceAppExit()ōsĂ̂ŁA
	 * ł͕Kv܂B
	 */
	StopMusic();
	music_loudness(0);
#endif /*USE_MUSIC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 */
void
update()
{
#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_EVENT_TIMER
			/* Cxg^C}B */
			EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
			/* ėpJE^Ǘ */
			CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();

#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

//			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
//			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */

/*{{AvP[VL̎*/
	/* 擾B */
	WELL_next(&stApp.Rng);
/*}}AvP[VL̎*/
}

/****************************************************************************
 *	app_main
 ****************************************************************************/

static void DoMenu();
static void DoInput();
static void DrawCab();

void app_main() {
	int FastSkip = 0;
//{{fobO
#if defined(TRACE_ON) && (TRACE_ON)
	pcePowerSetReport(PWR_RPTOFF);
	pceWaveSetMasterAtt(0);
#endif
//}}fobO
	for(;;) {
		/* f[^\ */
		DoMenu();
		/* ͍XV */
		DoInput();
		/* wi`B */
		sprite_draw(0, 0, SPR_CAB, 0);
		/* t\ȃL[NAB */
		stApp.OkReady = 0;	//Kv!!C^XN̓Zbg邾ŁANAĂȂB
		/* C^XNƃTu^XNNB */
		event_pulse(stApp.FrmEvt);	//蓮ZbgCxgւ̃pXł邩ACxg҂ĂSẴ^XNNACxgZbg铮ƂȂB
		/* I[gvCȂ΁AAvP[V^XN̕`ƎԈB */
		if((stApp.ApExec == Ap_Fast) && (FastSkip++ & 7/**/)) { continue; }
		/* ➑̂`B */
		DrawCab();
		/*  */
		schedule();
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

/* u𒊑IB
 * [out]
 *	߂l		uԍ	0`(HitCd_Zk-1)
 */
int LotHitCd() {
	int iRndVal = (uint16_t)WELL_next(&stApp.Rng);
	int iHitCd, iWeight;
	for(iHitCd = 0; iHitCd < HitCd_Zk; iHitCd++) {
		iWeight = TBL_HitCd[iHitCd];
		iWeight = (unsigned short)(iWeight + 1);
		iRndVal -= iWeight;
		if(iRndVal < 0) { return iHitCd; }
	}
	DIE();
}

/****************************************************************************
 *	
 ****************************************************************************/

/* uiHitCdAGgiHitFlg܂ނׂB
 * [in]
 *	iHitCd		uԍ	0`(HitCd_Size-1)
 *	iHitFlg		Ggԍ	0`(HitFlg_Size-1)
 * [out]
 *	߂l		܂ނȂ΁A0ȊO̒lԂB
 */
int GetHitCd_HitFlg(int iHitCd, int iHitFlg) {
	if((unsigned)iHitCd >= HitCd_Size) { DIE(); }
	if((unsigned)iHitFlg >= HitFlg_Size) { DIE(); }
	return (TBL_HitCd_HitFlg[iHitCd][iHitFlg/8] >> (iHitFlg%8)) & 1;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* GgiHitFlǵAo擾B
 * [in]
 *	iHitFlg		Ggԍ	0`(HitFlg_Size-1)
 * [out]
 * 	߂l		o	0`15
 */
int GetHitFlg_Pay(int iHitFlg) {
	if((unsigned)iHitFlg >= HitFlg_Size) { DIE(); }
	return (TBL_HitFlg[iHitFlg] >> 12) & 15;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* |CgIsB
 * [in]
 *	iRank		ݒl		0`5
 *	iStat		ʏ펞(0),,AT(1)
 * [out]
 *	߂l		|Cg	0`100
 */
int LotInitPoint(int iRank, int iStat) {
	int iHitVal, iLotTblNo, iLotCol;
	if((unsigned)iRank > 5) { DIE(); }
	if((unsigned)iStat > 1) { DIE(); }
	iLotTblNo = (iStat == 0) ? LotTblNo_PtIn/*ʏ펞*/ : LotTblNo_PaIn/*AT*/;
	iLotCol = iRank + 1;
	iHitVal = LOT_draw_table_l(&TBL_LotTbl[TBL_LotTblNo[iLotTblNo]], (unsigned short)WELL_next(&stApp.Rng), iLotCol, -1);
	if((unsigned)iHitVal > 100) { DIE(); }
	return iHitVal;
}

/****************************************************************************
 *	
 ****************************************************************************/

static const uint16_t TBL_LotPtXx[][2/*ʏ펞,AT*/]={
{0            ,0            },// 0 HitCd_Hz  ʽ    
{0            ,0            },// 1 HitCd_Bo  ްŽ   
{0            ,0            },// 2 HitCd_Rp  ڲ   
{LotTblNo_PtJs,LotTblNo_PaJs},// 3 HitCd_Js  㽲   
{LotTblNo_PtKs,LotTblNo_PaKs},// 4 HitCd_Ks     
{LotTblNo_PtCm,LotTblNo_PaCm},// 5 HitCd_Cm  ݽ  
{LotTblNo_PtJc,LotTblNo_PaJc},// 6 HitCd_Jc  ذ  
{LotTblNo_PtKc,LotTblNo_PaKc},// 7 HitCd_Kc  ذ  
{LotTblNo_PtMc,LotTblNo_PaMc},// 8 HitCd_Mc  iذ
{LotTblNo_PtBe,LotTblNo_PaBe},// 9 HitCd_Cr1 CRL1 
{LotTblNo_PtBe,LotTblNo_PaBe},//10 HitCd_Cr2 CRL2 
{LotTblNo_PtBe,LotTblNo_PaBe},//11 HitCd_Cr3 CRL3 
{LotTblNo_PtBe,LotTblNo_PaBe},//12 HitCd_Cr4 CRL4 
{LotTblNo_PtBe,LotTblNo_PaBe},//13 HitCd_Cr5 CRL5 
{LotTblNo_PtBe,LotTblNo_PaBe},//14 HitCd_Cr6 CRL6 
{LotTblNo_PtBe,LotTblNo_PaBe},//15 HitCd_Cr7 CRL7 
{LotTblNo_PtBe,LotTblNo_PaBe},//16 HitCd_Cr8 CRL8 
{LotTblNo_PtBe,LotTblNo_PaBe},//17 HitCd_Cr9 CRL9 
{LotTblNo_PtBe,LotTblNo_PaBe},//18 HitCd_Rl1 RLC1 
{LotTblNo_PtBe,LotTblNo_PaBe},//19 HitCd_Rl2 RLC2 
{LotTblNo_PtBe,LotTblNo_PaBe},//20 HitCd_Rl3 RLC3 
{LotTblNo_PtBe,LotTblNo_PaBe},//21 HitCd_Rl4 RLC4 
{LotTblNo_PtBe,LotTblNo_PaBe},//22 HitCd_Rl5 RLC5 
{LotTblNo_PtBe,LotTblNo_PaBe},//23 HitCd_Rl6 RLC6 
{LotTblNo_PtBe,LotTblNo_PaBe},//24 HitCd_Rl7 RLC7 
{LotTblNo_PtBe,LotTblNo_PaBe},//25 HitCd_Rl8 RLC8 
{LotTblNo_PtBe,LotTblNo_PaBe},//26 HitCd_Rl9 RLC9 
{LotTblNo_PtBe,LotTblNo_PaBe},//27 HitCd_Cl1 CLR1 
{LotTblNo_PtBe,LotTblNo_PaBe},//28 HitCd_Cl2 CLR2 
{LotTblNo_PtBe,LotTblNo_PaBe},//29 HitCd_Cl3 CLR3 
{LotTblNo_PtBe,LotTblNo_PaBe},//30 HitCd_Cl4 CLR4 
{LotTblNo_PtBe,LotTblNo_PaBe},//31 HitCd_Cl5 CLR5 
{LotTblNo_PtBe,LotTblNo_PaBe},//32 HitCd_Cl6 CLR6 
{LotTblNo_PtBe,LotTblNo_PaBe},//33 HitCd_Cl7 CLR7 
{LotTblNo_PtBe,LotTblNo_PaBe},//34 HitCd_Cl8 CLR8 
{LotTblNo_PtBe,LotTblNo_PaBe},//35 HitCd_Cl9 CLR9 
{LotTblNo_PtBe,LotTblNo_PaBe},//36 HitCd_Rc1 RCL1 
{LotTblNo_PtBe,LotTblNo_PaBe},//37 HitCd_Rc2 RCL2 
{LotTblNo_PtBe,LotTblNo_PaBe},//38 HitCd_Rc3 RCL3 
{LotTblNo_PtBe,LotTblNo_PaBe},//39 HitCd_Rc4 RCL4 
{LotTblNo_PtBe,LotTblNo_PaBe},//40 HitCd_Rc5 RCL5 
{LotTblNo_PtBe,LotTblNo_PaBe},//41 HitCd_Rc6 RCL6 
{LotTblNo_PtBe,LotTblNo_PaBe},//42 HitCd_Rc7 RCL7 
{LotTblNo_PtBe,LotTblNo_PaBe},//43 HitCd_Rc8 RCL8 
{LotTblNo_PtBe,LotTblNo_PaBe},//44 HitCd_Rc9 RCL9 
{0            ,0            },//45 HitCd_Zk  S  
};

/* |CgIsB
 * [in]
 *	iRank		ݒl		0`5
 *	iHitCd		uԍ	0`(HitCd_Size-1)
 * [out]
 *	߂l		|Cg	0`100
 */
int LotHitCdPoint(int iRank, int iStat, int iHitCd) {
	int iHitVal, iLotTblNo, iLotCol;
	if((unsigned)iRank > 5) { DIE(); }
	if((unsigned)iStat > 1) { DIE(); }
	if((unsigned)iHitCd >= ARRAY_SIZE(TBL_LotPtXx)) { DIE(); }
	iLotTblNo = TBL_LotPtXx[iHitCd][iStat];
	iLotCol = iRank + 1;
	iHitVal = iLotTblNo ? LOT_draw_table_l(&TBL_LotTbl[TBL_LotTblNo[iLotTblNo]], (unsigned short)WELL_next(&stApp.Rng), iLotCol, -1) : 0;
	if((unsigned)iHitVal > 100) { DIE(); }
	return iHitVal;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* AT˓I,,ATpIsB
 * [in]
 *	Point		|Cg	0`100
 * [out]
 *	߂l		񓖑I(0),,I(1)
 */
int LotPercent(int Point) {
	int iRndVal;
	if((unsigned)Point > 100) { DIE(); }
	iRndVal = random_value_less_than_or_equal_to(99, (unsigned(*)(void*))WELL_next, &stApp.Rng);
///	TRACE("%d <=> %d\n", Point, iRndVal);
	return Point > iRndVal;
}

/****************************************************************************
 *	
 ****************************************************************************/

void SendCmd(int iCmd) {
	int iPos;
	/* obt@tłȂƂmFB */
	if(stApp.CmdCnt >= ARRAY_SIZE(stApp.CmdBuf)) { DIE(); }
	/* i[ʒu߂B */
	iPos  = stApp.CmdPos;
	iPos += stApp.CmdCnt;
	if(iPos >= ARRAY_SIZE(stApp.CmdBuf)) { iPos -= ARRAY_SIZE(stApp.CmdBuf); }
	/* R}hi[B */
	stApp.CmdBuf[iPos] = iCmd;
	/* i[𑝂₷B */
	stApp.CmdCnt++;
}

/****************************************************************************
 *	
 ****************************************************************************/

int RecvCmd() {
	int iCmd;
	/* obt@Ȃ΁A(-1)ԂB */
	if(!stApp.CmdCnt) { return -1; }
	/* i[炷B */
	stApp.CmdCnt--;
	/* R}hǂݏoB */
	iCmd = stApp.CmdBuf[stApp.CmdPos];
	/* ǂݏoʒui߂B */
	stApp.CmdPos++;
	if(stApp.CmdPos >= ARRAY_SIZE(stApp.CmdBuf)) { stApp.CmdPos = 0; }
	/* R}hԂB */
	return iCmd;
}

/****************************************************************************
 *	
 ****************************************************************************/

static void DoMenu() {
	int x, y, w, h, i, j, n, s, t, c, x1, y1, x2, y2;
	if(!(joy & PAD_SELECT)) { return; }
	for(;;) {
		schedule();
		surface_clear(&surface, 3);
		/* I[gvCIB */
		if(joy & TRG_UP) { if(stApp.ApExec > 0      ) { stApp.ApExec--; stApp.ApWait = 0; } }
		if(joy & TRG_DN) { if(stApp.ApExec < Ap_Fast) { stApp.ApExec++; stApp.ApWait = 0; } }
		if(joy & TRG_A ) { while(joy) { schedule(); } return; }
		if(joy & TRG_B ) { break; }
		/*--- ` ---*/
		/* ^Cg */
		y = 1;
		x = 1 + (DISP_X - 4 * 4) / 2;
		render_rectangle_fill(&render, 0, 0, DISP_X, 7, 2);
		render_printf(&render, x, y, 2, 0, "ް");
		/* Wv */
		x = 1;
		y = 1 + 8;
		n = 0; for(i = HitCd_Cr1; i <= HitCd_Rc9; i++) { n += stApp.HitCnt[i]; }	/* xZo */
		render_printf(&render, x, y, 2, 0, "ĳݶ޸  %4d[k]", stApp.Invest / 1000); y += 6;
		render_printf(&render, x, y, 2, 0, "ݽ  %4d", stApp.TotalG); y += 6;
	//	render_printf(&render, x, y, 2, 0, "ʽ      %4d (1/%.2f)", stApp.HitCnt[HitCd_Hz], stApp.HitCnt[HitCd_Hz] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Hz]) : (double)0); y += 6;
	//	render_printf(&render, x, y, 2, 0, "ްŽ     %4d (1/%.2f)", stApp.HitCnt[HitCd_Bo], stApp.HitCnt[HitCd_Bo] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Bo]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ڲ     %4d (1/%.2f)", stApp.HitCnt[HitCd_Rp], stApp.HitCnt[HitCd_Rp] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Rp]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ެ   %4d (1/%.2f)", stApp.HitCnt[HitCd_Js], stApp.HitCnt[HitCd_Js] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Js]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "    %4d (1/%.2f)", stApp.HitCnt[HitCd_Ks], stApp.HitCnt[HitCd_Ks] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Ks]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ݽ     %4d (1/%.2f)", stApp.HitCnt[HitCd_Cm], stApp.HitCnt[HitCd_Cm] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Cm]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ެذ  %4d (1/%.2f)", stApp.HitCnt[HitCd_Jc], stApp.HitCnt[HitCd_Jc] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Jc]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ذ   %4d (1/%.2f)", stApp.HitCnt[HitCd_Kc], stApp.HitCnt[HitCd_Kc] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Kc]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ذ%4d (1/%.2f)", stApp.HitCnt[HitCd_Mc], stApp.HitCnt[HitCd_Mc] ? ((double)stApp.TotalG / stApp.HitCnt[HitCd_Mc]) : (double)0); y += 6;
		render_printf(&render, x, y, 2, 0, "ޭ %4d (1/%.2f)", n                     , n                      ? ((double)stApp.TotalG / n                     ) : (double)0); y += 7;
		render_line(&render, 1, y, DISP_X - 1, y, 2); y += 1;
		/* I[gvC */
		x = DISP_X - 4 * 6;
		y = 1 + 8;
		render_printf(&render, x, y, 2, 0, "ڲ"); render_point(&render, x + 4 * 3 + 2, y - 1, 0); y += 6;
		render_printf(&render, x, y, 2, 0, "%c ż  ", (stApp.ApExec ==       0) ? '>' : ' '); y += 6;
		render_printf(&render, x, y, 2, 0, "%c ò", (stApp.ApExec == Ap_Slow) ? '>' : ' '); y += 6;
		render_printf(&render, x, y, 2, 0, "%c ", (stApp.ApExec == Ap_Fast) ? '>' : ' '); y += 6;
		/* vvg */
		x = DISP_X - 4 * 6;
		y = DISP_Y - 12;
		render_printf(&render, x, y, 2, 0, "[A]");
		render_point(&render, x + 4 * 4 + 2, y - 1, 0);
		render_point(&render, x + 4 * 4 + 3, y - 1, 0); y += 6;
		render_printf(&render, x, y, 2, 0, "[B]");   y += 6;
		/* IOt */
		x = 1;
		y = DISP_Y - 2;
		for(i = 0; i < ARRAY_SIZE(stApp.History); i++) {
			if(stApp.History[i]) {
				if((n = (stApp.History[i] + 99) / 100) > 10) { n = 10; }
			} else {
				n = 0;
			}
			for(j = 0; j <= 8/*10*/; j++) {
				if(j == 0) {
					c = 1;			/* y̕ */
				} else {
					c = (j <= n) ? 0 : 2;	/* Q[̗̕ */
				}
				render_rectangle_fill(&render, x, y - j * 2, 3, 1, c);
			}
			x += 4;
		}
		/* XvOt */
		x = 42;
		y = DISP_Y - 17/*21*/;
		w = 61;
		h = 17/*19*/;
		render_rectangle(&render, x-1, y-1, w+2, h+2, 2);
		render_line(&render, x, y+h/2, x+w, y+h/2, 1);
		s = 100;	//100Pʂ̍ő卷TAOt̏cXP[ƂB
		for(i = 0; i < stApp.SamHisG; i++) {
			if(abs(stApp.SamHis[i]) > s) { s = abs(stApp.SamHis[i]); }
		}
		s = (s + (100-1)) / 100 * 100;
		t = 100;	//G100GPʂɐ؏グAOt̉XP[ƂB
		while(stApp.SamHisG > t) { t += 100; }
		render.top    = y;
		render.bottom = y + h;
		x1 = x;
		y1 = y + (h/2);
		for(i = 0; i < w; i++) {
			j = i * t / w;
			if(j >= stApp.SamHisG) { break; }	//v:͖ʏ?
			n = (h/2) - (stApp.SamHis[j] * (h/2) / s);
			x2 = x + i;
			y2 = y + n;
			render_line(&render, x1, y1, x2, y2, 0);
			x1 = x2;
			y1 = y2;
		}
		render.top    = 0;
		render.bottom = DISP_Y;
	}
	/* ݒ\āAIB */
	SndMxr_SetMxrChAtt(pSndMxr, SOUND_MAXCH, 128, 128, 50);	/*  */
	surface_clear(&surface, 3);
	x = (DISP_X - 10 * 3) / 2;
	y = 20;
	render_string(&render, x, y, "ݒ́A", 0, 0);
	x = (DISP_X - 10) / 2;
	y = (DISP_Y - 16) / 2 - 1;
	render_printf_framed(&render, x, y, 1, 0x220, "%d", stApp.Rank + 1);
	x = (DISP_X - 10 * 3) / 2;
	y = DISP_Y - 20 - 10;
	render_string(&render, x, y, "łB", 0, 0);
	for(i = 0; i < SEC(5); i++) { schedule(); if(joy & TRG_MASK) { break; } }	/* 5bo߂邩,,{^ꂽIB */
	exit(EXIT_SUCCESS);
}

/****************************************************************************
 *	
 ****************************************************************************/

/* L[V[PX */
static const char TBL_Ok[][8]={{0},
{Sw_Max,-1},				//Ok_Max
{Sw_Max,0,0,0,0,0,Sw_Med,-1},		//Ok_Max_Med
{Sw_Max,0,0,Sw_Med,0,0,Sw_Med,-1},	//Ok_Max_Med_Med
{Sw_Med,0,0,Sw_Med,0,0,Sw_Med,-1},	//Ok_Med_Med_Med
{Sw_Med,0,0,Sw_Med,-1},			//Ok_Med_Med
{Sw_Med,-1},	//Ok_Med
{Sw_Lev,-1},	//Ok_Lev
{Sw_1st,-1},	//Ok_1st
{Sw_2nd,-1},	//Ok_2nd
{Sw_3rd,-1}};	//Ok_3rd

static void DoInput() {
	/* I[gvCsȂ΁c */
	if(stApp.ApExec) {
		stApp.Sw = 0;
		/* I[gvCEFCg΁c */
		if(!stApp.ApWait) {
			/* t\ȃL[삪L΁c */
			switch(stApp.OkReady) {
			case Ok_Max:		/* MAXBET{^ */
			case Ok_Max_Med:	/* MAXBET{^˃_1 */
			case Ok_Max_Med_Med:	/* MAXBET{^˃_2 */
				stApp.Sw = Sw_Max;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : 2;
				break;
			case Ok_Med_Med_Med:	/* _3 */
			case Ok_Med_Med:	/* _2 */
			case Ok_Med:		/* _1 */
				stApp.Sw = Sw_Med;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : 2;
				break;
			case Ok_Lev:		/* X^[go[ */
				stApp.Sw = Sw_Lev;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : SEC(0.5);
				break;
			case Ok_1st:		/* ~{^ */
				stApp.Sw = Sw_1st;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : SEC(0.5);
				break;
			case Ok_2nd:		/* ~{^ */
				stApp.Sw = Sw_2nd;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : SEC(0.5);
				break;
			case Ok_3rd:		/* E~{^ */
				stApp.Sw = Sw_3rd;
				stApp.ApWait = (stApp.ApExec == Ap_Fast) ? 0 : SEC(1.0);
				break;
			}
		}
		/* I[gvCEFCgL΁AI[gvCEFCg炷B */
		if(stApp.ApWait) { stApp.ApWait--; }
	/* I[gvCsłȂ΁c */
	} else {
		/* t\ȃL[삪L΁c */
		if(stApp.OkReady) {
			/* ɃL[słȂAA{^ꂽAL[̎sJnB */
			if(!stApp.OkExec && (joy & TRG_A)) { stApp.OkExec = stApp.OkReady; }
		}
		/* L[sȂ΁c */
		if(stApp.OkExec) {
			/* L[擾B */
			int c = TBL_Ok[stApp.OkExec][stApp.OkStep++];
			/* ȌԂ̂AL[V[PX̍ŏ̃L[NAB(_͏ɃNA)
			 * A{^ĂȂ΁AL[V[PX̍ŏ̃L[NAB */
			stApp.Sw &= (joy & PAD_A) ? (TBL_Ok[stApp.OkExec][0] & ~Sw_Med) : 0;
			/* L[V[PXI[łȂ΁ÃL[ZbgAIB */
			if(c != -1) { stApp.Sw |= c; return; }
			/* L[V[PXI[Ȃ΁AL[V[PX̍ŏ̃L[܂ő҂B(_͏)
			 * L[łAł˂葀ł悤ɂ邽߂̔fłB */
			if(stApp.Sw & TBL_Ok[stApp.OkExec][0]) { stApp.OkStep--; return; }
			/* L[IAȉ̏pB */
			stApp.OkExec = stApp.OkStep = 0;
		}
		/* ÕXCb`ԂMAXBETȊONABOMAXBETȂ΁c */
		if(stApp.Sw &= Sw_Max) {
			/* MAXBETȂ΁Â܂܁B */
			if(joy & PAD_B) {
				/** no job **/
			/* MAXBETꂽANAB */
			} else {
				stApp.Sw = 0;
			}
		/* OMAXBETłȂ΁c */
		} else {
			/* MAXBET\łȂA_\Ȃ΁c */
			if((stApp.Led & (Led_Ins|Led_Max)) == Led_Ins) {
				if(joy & TRG_B) { stApp.Sw |= Sw_Med; }	/* _1 */
			/* ȊOȂ΁c(MAXBET\łȂƂ܂) */
			} else {
				if(joy & PAD_B) { stApp.Sw |= Sw_Max; }	/* MAXBET{^ */
			}
		}
		if(joy & PAD_LF) { stApp.Sw |= Sw_1st; }	/* ~{^ */
		if(joy & PAD_DN) { stApp.Sw |= Sw_2nd; }	/* ~{^ */
		if(joy & PAD_RI) { stApp.Sw |= Sw_3rd; }	/* E~{^ */
		if(joy & PAD_UP) { stApp.Sw |= Sw_Lev; }	/* X^[go[ */
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

static void DrawCab() {
	int iSpr;
	/* ~{^ */
	iSpr = (stApp.Led & Led_1st) ? SPR_BTN_LI_UP : SPR_BTN_DK_UP;
	if(stApp.Sw & Sw_1st) { iSpr++; }
	sprite_draw(Cab_1st_X, Cab_1st_Y, iSpr, 0);
	/* ~{^ */
	iSpr = (stApp.Led & Led_2nd) ? SPR_BTN_LI_UP : SPR_BTN_DK_UP;
	if(stApp.Sw & Sw_2nd) { iSpr++; }
	sprite_draw(Cab_2nd_X, Cab_2nd_Y, iSpr, 0);
	/* E~{^ */
	iSpr = (stApp.Led & Led_3rd) ? SPR_BTN_LI_UP : SPR_BTN_DK_UP;
	if(stApp.Sw & Sw_3rd) { iSpr++; }
	sprite_draw(Cab_3rd_X, Cab_3rd_Y, iSpr, 0);
	/* MAXBET{^ */
	if(stApp.Sw & Sw_Max) {
		if(stApp.MaxPos < 2) { stApp.MaxPos++; }
	} else {
		if(stApp.MaxPos) { stApp.MaxPos--; }
	}
	iSpr = (stApp.Led & Led_Max) ? SPR_MAX_LI_UP : SPR_MAX_DK_UP;
	iSpr += stApp.MaxPos;
	sprite_draw(Cab_Max_X, Cab_Max_Y, iSpr, 0);
	/* X^[go[ */
	if(stApp.Sw & Sw_Lev) {
		if(stApp.LevPos < 2) { stApp.LevPos++; }
	} else {
		if(stApp.LevPos) { stApp.LevPos--; }
	}
	iSpr = SPR_LEV_UP;
	iSpr += stApp.LevPos;
	sprite_draw(Cab_Lev_X, Cab_Lev_Y, iSpr, 0);
	/* _ */
	iSpr = SPR_MED;
	iSpr += stApp.MedPos;
	sprite_draw(Cab_Med_X, Cab_Med_Y, iSpr, 0);
	if(stApp.MedPos && (++stApp.MedPos > 7)) { stApp.MedPos = 0; }
	/* AT */
	render_printf(&render, Dtc_AtN_X, Dtc_AtN_Y, 2, 0, "A%4d", stApp.AtNum);
	/* X^[g] */
	render_printf(&render, Dtc_StG_X, Dtc_StG_Y, 2, 0, "S%4d", stApp.StartG);
	/* _ */
	render_printf(&render, Dtc_Med_X, Dtc_Med_Y, 2, 0, "M%4d", stApp.Medal);
}

