/*
 *	pthpse.c
 *
 *	uToHeart PSEvPGDRo[^
 *	Copyright (C) 2003 Naoyuki Sawa
 *
 *	* Fri Jul 4 21:30:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

/****************************************************************************
 *	}NE萔
 ****************************************************************************/

#define VERSION		"20030705"

#define REG_KEY		"Software\\AQUAPLUS\\ToHeartPSE"
#define REG_VALUE	"InstallDir"

/* LEAFPACK`
 *
 * 擪+            0,              8:	"LEAFPACK"
 * 擪+            8,     ÍL[:	ÍL[
 *     .
 *     .				Íꂽt@C
 *     .
 * I[-24*t@C-3,24*t@C:	t@Ce[u (FILEINFO\̎Q)
 * I[-              3,            2:	t@C
 * I[-              1,            1:	ÍL[
 */

/* FILEINFO\
 *	e[uŜÍĂ܂B
 *	e[u(           0)oCgڂÍL[(           0)oCgڂ,
 *	e[u(           1)oCgڂÍL[(           1)oCgڂ,
 *	e[u(ÍL[-1)oCgڂÍL[(ÍL[-1)oCgڂ,
 *	e[u(ÍL[  )oCgڂÍL[(           0)oCgڂ,
 *	e[u(ÍL[+1)oCgڂÍL[(           1)oCgڂ,...
 * ƂŁAÍ܂B
 *
 * + 0,8:	x[XB8ɖȂꍇ́A󔒕l߂܂B
 * + 8,4:	gqB4ɖȂꍇ́Akl߂܂B
 * +12,4:	t@CʒuBLEAFPACKt@C擪̐ΈʒułB
 * +16,4:	t@CB
 * +20,4:	̃t@CʒuB͎g܂B
 */
typedef struct _FILEINFO {
	char fname[8 + 4];
	int pos;
	int len;
	int next;
} FILEINFO;

/* et@C̓eAt@Ce[uƓlɈÍĂ܂B
 * t@Ce[u͑SGgʂňÍĂ܂At@C͈ÂÍĂ܂B
 * t@Č`ɂẮALEAFFUL`,LEAFCFL`QƂĂB
 * ɂ`܂A͎g܂B
 */

/* LEAFFUL`
 * ߂Ȃ̃tJ[摜łB
 *
 * + 0, 8:	"LEAFFUL\0"
 * + 8, 2:	X_B͎g܂B
 * +10, 2:	Y_B͎g܂B
 * +12, 2:	B
 * +14, 2:	B
 * +16, 4:	20ŒBLZkf[^JnʒuĂ悤łA͎g܂B
 * +20,...	LZkf[^B
 *
 * LZWJf[^̂܂܁A(B,G,R)̃tJ[rbg}bvɂȂ܂B
 */
typedef struct _LEAFFUL {
	char signature[8];
	unsigned short x;
	unsigned short y;
	unsigned short w;
	unsigned short h;
	int ofs;
} LEAFFUL;

/* LEAFCFL`
 * ߂̃tJ[`łB
 *
 * + 0, 8:	"LEAFCFL\0"
 * + 8, 2:	X_B͎g܂B
 * +10, 2:	Y_B͎g܂B
 * +12, 2:	B
 * +14, 2:	B
 * +16, 4:	24ŒBLZkf[^JnʒuĂ悤łA͎g܂B
 * +20, 4:	LZWJf[^TCYB
 * +24,...	LZkf[^B
 *
 * LZWJf[^̓éA1sNZɎ̂ꂩ̌`ƂȂ܂B
 *
 * (0x00)	S	1oCg
 * (0xFF,B,G,R)	Ss	4oCg
 * (0x??,B,G,R)			4oCg
 *
 * AwiƂ̃}[Ŵ͎悤ɍs܂B
 *
 * Ro = ((0x?? * R) + ((0xff-0x??) * wiR)) >> 8
 * Go = ((0x?? * G) + ((0xff-0x??) * wiG)) >> 8
 * Bo = ((0x?? * B) + ((0xff-0x??) * wiB)) >> 8
 *
 * ̌vZł 0x??=0xff ̂ƂɊSsɂȂȂ̂ŁA
 * Oq̂悤 0x??=0xff ̏ꍇꍇŊSsƂĂ񂾂Ǝv܂B
 *
 * ̃Ro[^ł͔}[W͍sȂ̂ŁAq̌vZ͍sĂ܂B
 */
typedef struct _LEAFCFL {
	char signature[8];
	unsigned short x;
	unsigned short y;
	unsigned short w;
	unsigned short h;
	int ofs;
	int len;
} LEAFCFL;

/* LZkɂ
 * Ń}k̕ό`łłB
 * rbgႤ̂ƁA̓f[^rbg]Ăg_قȂ܂B
 * ڂ̓\[XQƂĂB
 */

/* ̍\͎̂ۂ̃t@C`ɂ͑ΉĂ܂B
 * ̃c[̊Ǘ`łB
 */
typedef struct _LEAFPACK {
	FILE* fp;		/* t@C|C^ */
	int key_len;		/* ÍL[ */
	unsigned char* key;	/* ÍL[ */
	int file_cnt;		/* t@C */
	FILEINFO* file;		/* t@C */
} LEAFPACK;

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

/* 摜܂܂ĂpbNt@CXg */
const char* const pack_list[] = {
	"bck.pak",
	"chr.pak",
	"sys.pak",
	"vis.pak",
};
#define PACK_LIST_COUNT	(sizeof pack_list / sizeof *pack_list)

char app_dir[_MAX_DIR];		/* uToHeart PSEṽtH_ */
char item_name[_MAX_PATH];	/* oACeis870Ȃǁj */

int opt_bmp;			/* BMPóieXgpj */
int opt_chr;			/* G[hi؂j */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

void err(const char* fmt, ...);
void usage();
LEAFPACK* pack_open(const char* fname);
void pack_close(LEAFPACK* pack);
void decode_key(LEAFPACK* pack, void* ptr, int len);
void decode_lz(unsigned char* dst, unsigned char* src, int out_len);
unsigned char* decode_ful(unsigned char* in_buf);
unsigned char* decode_cfl(unsigned char* in_buf);
void extract(const char* item_name);
unsigned char* bmp24to32(unsigned char* in_buf);
unsigned char* bmp32to8(unsigned char* in_buf);
unsigned char* reduce(unsigned char* in_buf);

/****************************************************************************
 *	err
 ****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	exit(1);
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "pthpse - uToHeart PSEiAQUAPLUSjvPGDRo[^i%sj\n", VERSION);
	fprintf(stderr, "Copyright (C) 2003 Naoyuki Sawa\n");
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  pthpse [options] <item-name>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "  ACeɁu*vƎw肷ƁAo\ȑSẴACe𒊏o܂B\n");
	fprintf(stderr, "  ၄ pthpse -b *\n");
	fprintf(stderr, "         SẴt@CBMPt@CƂĒo܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -b        -b2ƓłB\n");
	fprintf(stderr, "  -b1       rbg}bvt@Ĉ܂܏o͂܂B\n");
	fprintf(stderr, "  -b2       rbg}bvt@Ckďo͂܂B\n");
	fprintf(stderr, "  -b3       rbg}bvt@CkEFďo͂܂B\n");
	fprintf(stderr, "  -b/-b1/-b2/-b3̂ǂw肵Ȃ΁APGDt@Co͂܂B\n");
	fprintf(stderr, "  -c        kAcɂ͂ݏoꍇ́A؂܂B\n");
	fprintf(stderr, "  -d<path>  ToHeart PSEtH_w ilWXg擾j\n");
	exit(1);
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, i, n;
	char* p;
	HKEY hKey;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'b': /* BMPo */
				if(opt_bmp) usage(); /* dw */
				if(p[2]) {
					opt_bmp = p[2] - '0';
				} else {
					opt_bmp = 2; /* -b݂̂Ȃ2 */
				}
				if(opt_bmp < 1 || 3 < opt_bmp) usage();
				break;
			case 'c': /* G[h */
				if(opt_chr) usage(); /* dw */
				opt_chr = 1;
				break;
			case 'd': /* uToHeart PSEvCXg[tH_w */
				if(strlen(app_dir) != 0) usage(); /* dw */
				strncpy(app_dir, &p[2], sizeof app_dir);
				break;
			default:
				usage();
			}
		} else {
			/* oACe */
			if(strlen(item_name) != 0) usage(); /* dw */
			strncpy(item_name, p, sizeof item_name);
		}
	}

	/* uToHeart PSEvCXg[tH_𒲂ׂ܂B */
	if(strlen(app_dir) == 0) {
		retval = RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY, 0, KEY_QUERY_VALUE, &hKey);
		if(retval == 0) {
			n = sizeof app_dir;
			retval = RegQueryValueEx(hKey, REG_VALUE, 0, NULL, (unsigned char*)app_dir, (unsigned long*)&n);
			RegCloseKey(hKey);
		}
		if(retval != 0) err("uToHeart PSEvCXg[ĂȂ悤łB");
	}

	/* ACew肳ꂽPƓWJAw肳ĂȂΑSWJցB */
	if(strlen(item_name) == 0) usage();
	if(strcmp(item_name, "*") == 0) {
		extract(NULL);
	} else {
		extract(item_name);
	}

	return 0;
}

/****************************************************************************
 *	pack_open
 ****************************************************************************/

LEAFPACK*
pack_open(const char* fname)
{
	int retval, i, j;
	char path[_MAX_PATH];
	char ext[_MAX_FNAME];
	char signature[8];
	LEAFPACK* pack;
	FILEINFO* file;

	/* LEAFPACK\̂mۂ܂B */
	pack = (LEAFPACK*)calloc(1, sizeof(LEAFPACK));
	if(pack == NULL) err("%s: słB", fname);

	/* pbNt@CJ܂B */
	_makepath(path, NULL, app_dir, fname, NULL);
	pack->fp = fopen(path, "rb");
	if(pack->fp == NULL) err("%s: t@CJ܂B", fname);

	/* VOl`mF܂B */
	retval = fread(signature, 1, 8, pack->fp);
	if(retval != 8) err("%s: VOl`ǂ߂܂B", fname);
	if(memcmp(signature, "LEAFPACK", 8) != 0) err("%s: VOl`słB", fname);

	/* ÍL[擾܂B */
	fseek(pack->fp, -1, SEEK_END);
	retval = fread(&pack->key_len, 1, 1, pack->fp);
	if(retval != 1) err("%s: ÍL[ǂ߂܂B", fname);

	/* ÍL[̃mۂ܂B */
	pack->key = (unsigned char*)calloc(pack->key_len, 1);
	if(pack->key == NULL) err("%s: słB", fname);

	/* ÍL[ǂݍ݂܂B */
	fseek(pack->fp, 8, SEEK_SET);
	retval = fread(pack->key, 1, pack->key_len, pack->fp);
	if(retval != pack->key_len) err("%s: ÍL[ǂ߂܂B", fname);

	/* t@C擾܂B */
	fseek(pack->fp, -3, SEEK_END);
	retval = fread(&pack->file_cnt, 2, 1, pack->fp);
	if(retval != 1) err("%s: t@Cǂ߂܂B", fname);

	/* t@Ce[ũmۂ܂B */
	pack->file = (FILEINFO*)calloc(pack->file_cnt, sizeof(FILEINFO));
	if(pack->file == NULL) err("%s: słB", fname);

	/* t@Ce[uǂݍ݂܂B */
	fseek(pack->fp, -((int)sizeof(FILEINFO) * pack->file_cnt + 3), SEEK_END);
	retval = fread(pack->file, sizeof(FILEINFO), pack->file_cnt, pack->fp);
	if(retval != pack->file_cnt) err("%s: t@Ce[uǂ߂܂B", fname);

	/* t@Ce[üÍ܂B */
	decode_key(pack, pack->file, sizeof(FILEINFO) * pack->file_cnt);

	/* et@Cɂ... */
	for(i = 0; i < pack->file_cnt; i++) {
		file = &pack->file[i];
		/* ₷悤At@C␳Ă܂B("12345   ABC\0""12345.abc\0") */
		memset(path, 0, sizeof path);
		memcpy(path, file->fname + 0, 8);
		j = strlen(path) - 1;
		while(j >= 0) {
			if(!isspace(path[j])) break;
			path[j] = '\0';
			j--;
		}
		memset(ext, 0, sizeof ext);
		memcpy(ext, file->fname + 8, 4);
		j = strlen(ext) - 1;
		while(j >= 0) {
			if(!isspace(ext[j])) break;
			ext[j] = '\0';
			j--;
		}
		memset(file->fname, 0, 8 + 4); /* fobO₷悤ɃS~Ă */
		_makepath(file->fname, NULL, NULL, path, ext);
		_strlwr(file->fname);
	}

	return pack;
}

/****************************************************************************
 *	pack_close
 ****************************************************************************/

void
pack_close(LEAFPACK* pack)
{
	fclose(pack->fp);
	free(pack->file);
	free(pack->key);
	free(pack);
}

/****************************************************************************
 *	decode_key
 ****************************************************************************/

void
decode_key(LEAFPACK* pack, void* ptr, int len)
{
	unsigned char* p;
	unsigned char* key;
	int key_len, key_ofs;

	p = (unsigned char*)ptr;
	key = pack->key;
	key_len = pack->key_len;
	key_ofs = 0;
	while(len) {
		*p++ -= key[key_ofs++];
		if(key_ofs == key_len) key_ofs = 0;
		len--;
	}
}

/****************************************************************************
 *	decode_lz
 ****************************************************************************/

#define		N	4096
#define		F	18

static unsigned char tmp_buf[N + F];

void
decode_lz(unsigned char* dst, unsigned char* src, int out_len)
{
	int i, k, r;
	int flags, pos, len;
	unsigned char c;

	/* XChobt@B */
	memset(tmp_buf, 0, sizeof tmp_buf);
	r = N - F; /* ʒu͌̕H */

	/* JE^o̓TCYɒB܂... */
	i = 0;
	while(i < out_len) {
		/* `N1oCgڂ̓tOB */
		flags = *src;
		src++;
		flags ^= 0xff; /* rbg] */
		flags = (flags << 8) | 0xff; /* 8rbg8񃋁[v̂߂̃}[Nł */
		do {
			if(i >= out_len) break;
			if(flags & 0x8000) {
				/* 1:k */
				c = *src;
				src++;
				c ^= 0xff; /* rbg] */
				*(tmp_buf + r++) = *(dst++) = c;
				r &= (N - 1);
				i++;
			} else {
				/* 0:k */
				len = *(unsigned short*)src;
				src += 2;
				len ^= 0xffff; /* rbg] */
				pos = len >> 4;
				len = (len & 0x0f) + 3;
				for(k = 0; k < len; k++) {
					if(i >= out_len) break;
					*(tmp_buf + r++) = *(dst++) = *(tmp_buf + ((pos + k) & (N - 1)));
					r &= (N - 1);
					i++;
				}
			}
			flags <<= 1;
		} while(flags & 0xff);
	}
}

/****************************************************************************
 *	extract
 ****************************************************************************/

unsigned char*
decode_ful(unsigned char* in_buf)
{
	int len;
	LEAFFUL* hdr;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf;
	BITMAPINFOHEADER* bi;
	unsigned char* bits;

	/* 摜wb_擾܂B */
	hdr = (LEAFFUL*)in_buf;
	len = hdr->w * hdr->h * 3/*RGB*/;

	/* o̓obt@mۂ܂B */
	out_buf = calloc(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + len, 1);
	if(out_buf == NULL) err("decode_ful: słB");
	bf   = (BITMAPFILEHEADER*)(out_buf);
	bi   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits =                     out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	/* rbg}bvt@C쐬B */
	bf->bfType    = 'MB';
	bf->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	bf->bfSize    = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + len;

	/* rbg}bv쐬B */
	bi->biSize     = sizeof(BITMAPINFOHEADER);
	bi->biWidth    = hdr->w;
	bi->biHeight   = hdr->h;
	bi->biPlanes   = 1;
	bi->biBitCount = 24;

	/* LZWJB */
	decode_lz(bits, in_buf + hdr->ofs, len);

	return out_buf;
}

/****************************************************************************
 *	extract
 ****************************************************************************/

unsigned char*
decode_cfl(unsigned char* in_buf)
{
	int len;
	LEAFCFL* hdr;
	unsigned char* out_buf;
	unsigned char* tmp_buf;
	BITMAPFILEHEADER* bf;
	BITMAPINFOHEADER* bi;
	unsigned char* bits;
	unsigned char* src;
	unsigned char* dst;
	unsigned char* dst_end;
	unsigned char c;

	/* 摜wb_擾܂B */
	hdr = (LEAFCFL*)in_buf;
	len = hdr->w * hdr->h * 4/*ARGB*/;

	/* o̓obt@mۂ܂B */
	out_buf = calloc(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + len, 1);
	if(out_buf == NULL) err("decode_cfl: słB");
	bf   = (BITMAPFILEHEADER*)(out_buf);
	bi   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits =                     out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	/* rbg}bvt@C쐬B */
	bf->bfType    = 'MB';
	bf->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	bf->bfSize    = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + len;

	/* rbg}bv쐬B */
	bi->biSize     = sizeof(BITMAPINFOHEADER);
	bi->biWidth    = hdr->w;
	bi->biHeight   = hdr->h;
	bi->biPlanes   = 1;
	bi->biBitCount = 32;

	/* LZWJobt@mۂ܂B */
	tmp_buf = (unsigned char*)calloc(hdr->len, 1);
	if(tmp_buf == NULL) err("decode_cfl: słB");

	/* LZWJB */
	decode_lz(tmp_buf, in_buf + hdr->ofs, hdr->len);

	/* ߈kWJB */
	src = tmp_buf;
	dst = bits;
	dst_end = bits + len;
	while(dst < dst_end) {
		c = *src++;
		switch(c) {
		case 0x00:
			*dst++ = 0;
			*dst++ = 0xff; /* ߕ킩₷悤ɗ΂ɂ܂ */
			*dst++ = 0;
			*dst++ = 0;
			break;
		case 0xff:
			*dst++ = *src++;
			*dst++ = *src++;
			*dst++ = *src++;
			*dst++ = 0xff;
			break;
		default:
			*dst++ = *src++;
			*dst++ = *src++;
			*dst++ = *src++;
			*dst++ = c;
			break;
		}
	}

	/* LZWJobt@J܂B */
	free(tmp_buf);

	return out_buf;
}

/****************************************************************************
 *	extract
 ****************************************************************************/

void
extract(const char* item_name)
{
	int retval, i_pack, i_file, done, alpha;
	LEAFPACK* pack;
	FILEINFO* file;
	char fname[_MAX_PATH];
	char cmd[_MAX_PATH];
	unsigned char *in_buf, *out_buf;
	char bmp_path[_MAX_PATH];
	BITMAPFILEHEADER* bf;
	FILE* fp;

	done = 0;	/* PƓWJAwGgWJ1ɂȂ܂B */

	/* epbNt@Cɂ... */
	for(i_pack = 0; !done && i_pack < PACK_LIST_COUNT; i_pack++) {
		/* pbNt@CJ܂B */
		pack = pack_open(pack_list[i_pack]);

		/* et@Cɂ... */
		for(i_file = 0; !done && i_file < pack->file_cnt; i_file++) {
			file = &pack->file[i_file];

			/* SWJA܂͎wGgɈv... */
			_splitpath(file->fname, NULL, NULL, fname, NULL);
			if(item_name == NULL || _strcmpi(fname, item_name) == 0) {
				/* SWJȂÃt@C\B */
				if(item_name == NULL) printf("%s(%3d): %s\n", pack_list[i_pack], i_file, file->fname);

				/* SȊĴ߂ɁANULLɏĂ܂B */
				in_buf = NULL;
				out_buf = NULL;

				/* ̓obt@mۂ܂B */
				in_buf = (unsigned char*)calloc(file->len, 1);
				if(in_buf == NULL) err("%s: słB", file->fname);

				/* t@Cǂݍ݂܂B */
				fseek(pack->fp, file->pos, SEEK_SET);
				retval = fread(in_buf, 1, file->len, pack->fp);
				if(retval != file->len) err("%s: t@Cǂ߂܂B", file->fname);

				/* Í܂B */
				decode_key(pack, in_buf, file->len);

				/* t@C`ɂ... */
				       if(memcmp(in_buf, "LEAFFUL\0", 8) == 0) {
					out_buf = decode_ful(in_buf); /* =>24bpp */
					out_buf = bmp24to32(out_buf); /* =>32bpp */
					alpha = 0;
				} else if(memcmp(in_buf, "LEAFCFL\0", 8) == 0) {
					out_buf = decode_cfl(in_buf); /* =>32bpp */
					alpha = 1;
				} else {
					if(item_name == NULL) goto SKIP; /* SWJȂXLbv */
					err("%s: Ή̃t@C`łB", file->fname);
				}

				if(opt_bmp == 1) goto L10;	/* BMPo͂ */

				/* kB */
				out_buf = reduce(out_buf);

				if(opt_bmp == 2) goto L10;	/* BMPo͂ */

				/* OCXP[ϊB */
				out_buf = bmp32to8(out_buf);
L10:
				/* rbg}bvo͂܂B */
				_splitpath(file->fname, NULL, NULL, fname, NULL);
				_makepath(bmp_path, NULL, NULL, fname, ".bmp");
				fp = fopen(bmp_path, "wb");
				bf = (BITMAPFILEHEADER*)out_buf;
				retval = fwrite(out_buf, 1, bf->bfSize, fp);
				if(retval != (int)bf->bfSize) err("%s: rbg}bvo͂Ɏs܂B", file->fname);
				fclose(fp);

				/* PGDϊB */
				if(opt_bmp == 0) {
					if(alpha) {	/* 2bit}XNt */
						sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
					} else {	/* 2bit}XNȂ */
						sprintf(cmd, "dpbmpcnv -q -b -f2  \"%s\"", bmp_path); /* -qKv! */
					}
					if(system(cmd) != 0) err("PGDϊɎs܂B");
					remove(bmp_path);	/* BMP͂Ȃ̂ō폜 */
				}

				/* PƓWJȂA}[NB */
				if(item_name != NULL) done = 1;
SKIP:
				/* obt@J܂B */
				free(out_buf);
				free(in_buf);
			}
		}

		/* pbNt@C܂B */
		pack_close(pack);
	}

	/* PƓWJŁAw肳ꂽGgȂ΁AG[B */
	if(item_name && !done) err("%s܂B", item_name);
}

/****************************************************************************
 *	bmp24to32
 ****************************************************************************/

unsigned char*
bmp24to32(unsigned char* in_buf)
{
	int w, h, x, y;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = (3 * w + 3) & ~3;

	/* o̓rbg}bv쐬B */
	stride_out = 4 * w;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 3 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 4 * x;
			;
			*pout++ = *pin++;
			*pout++ = *pin++;
			*pout++ = *pin++;
			*pout++ = 255;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	bmp8to32
 ****************************************************************************/

const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

unsigned char*
bmp32to8(unsigned char* in_buf)
{
	int w, h, x, y, r, g, b, a, c;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	RGBQUAD* rgb_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = 4 * w;

	/* o̓rbg}bv쐬B */
	stride_out = (w + 3) & ~3;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	rgb_out  = (RGBQUAD         *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256);

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 8;

	for(c = 0; c < 4; c++) {
		rgb_out[c].rgbRed       = 85 * (3 - c);
		rgb_out[c].rgbGreen     = 85 * (3 - c);
		rgb_out[c].rgbBlue      = 85 * (3 - c);
		rgb_out[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb_out[c].rgbRed       = 0;
		rgb_out[c].rgbGreen     = 255;
		rgb_out[c].rgbBlue      = 0;
		rgb_out[c].rgbReserved  = 0;
	}

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 4 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 1 * x;
			;
			b = *pin++;
			g = *pin++;
			r = *pin++;
			a = *pin++;
			;
			if(a) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			;
			*pout++ = c;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	reduce
 ****************************************************************************/

#define WIDTH_LIMIT	128
#define HEIGHT_LIMIT	 88

unsigned char*
reduce(unsigned char* in_buf)
{
	int x_in, y_in, x_out, y_out, r, g, b, a, n, x_base, y_base;
	double REDUCE_LEVEL;

	int w_in;
	int h_in;
	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	int w_out;
	int h_out;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w_in = bi_in->biWidth;
	h_in = bi_in->biHeight;
	stride_in = 4 * w_in;

	/* G[h͔䗦ŒB */
	if(opt_chr) {
		REDUCE_LEVEL = 640.0 / WIDTH_LIMIT;
	/* wi[h͔䗦ρB */
	} else {
		double rl1 = (double)w_in / WIDTH_LIMIT;
		double rl2 = (double)h_in / HEIGHT_LIMIT;
		REDUCE_LEVEL = rl1 <= rl2 ? rl1 : rl2; /* ʂςɂȂ悤 */
	}

	/* o̓rbg}bv쐬B */
	w_out = (int)(w_in / REDUCE_LEVEL);
	h_out = (int)(h_in / REDUCE_LEVEL);
	x_base = 0;
	y_base = 0;
	if(w_out > WIDTH_LIMIT) {
		x_base = (int)((w_out - WIDTH_LIMIT) / 2 * REDUCE_LEVEL);
		w_out = WIDTH_LIMIT;
	}
	if(h_out > HEIGHT_LIMIT) {
		if(!opt_chr) y_base = (int)((h_out - HEIGHT_LIMIT) / 2 * REDUCE_LEVEL);
		h_out = HEIGHT_LIMIT;
	}
	stride_out = 4 * w_out;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h_out;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w_out;
	bi_out->biHeight = h_out;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	/* kB */
	for(y_out = 0; y_out < h_out; y_out++) {
		for(x_out = 0; x_out < w_out; x_out++) {
			/* k̃sNZZB */
			r = 0;
			g = 0;
			b = 0;
			a = 0;
			n = 0;
			for(y_in = y_base + (int)(y_out * REDUCE_LEVEL); y_in < y_base + (int)((y_out + 1) * REDUCE_LEVEL); y_in++) {
				if(y_in < 0 || h_in - 1 < y_in) continue;
				for(x_in = x_base + (int)(x_out * REDUCE_LEVEL); x_in < x_base + (int)((x_out + 1) * REDUCE_LEVEL); x_in++) {
					if(x_in < 0 || w_in - 1 < x_in) continue;
					pin  = bits_in  + stride_in  * (h_in - 1 - y_in) + 4 * x_in;
					b += *pin++;
					g += *pin++;
					r += *pin++;
					a += *pin++;
					n++;
				}
			}
			/* ςďk̃sNZցB */
			pout  = bits_out + stride_out  * (h_out - 1 - y_out) + 4 * x_out;
			if(n != 0) {
				r = (r + n / 2) / n;
				g = (g + n / 2) / n;
				b = (b + n / 2) / n;
				a = (a + n / 2) / n;
			}
			*pout++ = b;
			*pout++ = g;
			*pout++ = r;
			*pout++ = a;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}
