/*
 *	jtdotcall.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTDOTCALL
 *****************************************************************************/

typedef struct _JTDOTCALL {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTCODE_INTERFACE** code;			/* IuWFNg */
	JTSYMBOL_INTERFACE** symbol;			/* \bh\V{ */
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;	/* Xg */
} JTDOTCALL;

IMPLEMENT_JTCODE_INTERFACE(JTDOTCALL, jtdotcall)

const INTERFACE_MAP jtdotcall_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTDOTCALL, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtdotcall_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol, LIST/*<JTCODE_INTERFACE**>*/ * args_list)
{
	JTDOTCALL* this = calloc(1, sizeof(JTDOTCALL));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtdotcall_interface_map);

	/* IuWFNgA\bh\V{i[܂B */
	safe_assign(this->code, code);
	safe_assign(this->symbol, symbol);

	/* Xg𕡐āAi[܂B */
	this->args_list = list_duplicate(args_list);

	return &this->jtcode_interface;
}

static void
jtdotcall_delete(JTDOTCALL* this)
{
	/* IuWFNgA\bh\V{܂B */
	safe_release(this->code);
	safe_release(this->symbol);

	/* Xg폜܂B */
	list_delete(this->args_list);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTDOTCALL* this = CONTAINING_RECORD(intf, JTDOTCALL, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTFUN_INTERFACE** fun = NULL;
	JTOBJECT_INTERFACE** object = NULL;
	//
	int i;
	int count;
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;

	/* \bhĂяoÕ^C~OŁAIuWFNg]܂B */
	safe_attach(code, (*this->code)->run(this->code)); /* V{āAIuWFNg擾鏈Ȃ */
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);
	if(!object) {
		DIE(); /* IuWFNgłȂ (ǂݍ񂾃vÕG[) */
	}

	/* V{ɑΉA֐擾܂B */
	safe_attach(code, (*object)->get_field_value(object, this->symbol));
	if(!code) {
		DIE(); /* ` (ǂݍ񂾃vÕG[) */
	}
	safe_assign_interface(fun, code, JTFUN_INTERFACE);
	if(!fun) {
		DIE(); /* ֐łȂ (ǂݍ񂾃vÕG[) */
	}

	/* ꎞIȎXg쐬܂B(]i[邽) */
	args_list = list_create(&jtcode_list_info);

	/* \bhĂяoÕ^C~OŁA]܂B */
	count = list_size(this->args_list);
	for(i = 0; i < count; i++) {
		safe_attach(code, list_get(this->args_list, i));
		safe_attach(code, (*code)->run(code));
		list_add(args_list, code);
	}

	/* \bhĂяo܂B */
	safe_attach(code, (*fun)->call(fun, args_list, object));

	/* ꎞIȎXg폜܂B */
	list_delete(args_list);

	/* svɂȂC^[tFCX܂B */
	safe_release(fun);
	safe_release(object);

	return code;
}

