/*	
 *	frammod2.c
 *
 *	RAMɓ]郂W[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2002 Naoyuki Sawa
 *
 *	* Tue Nov 19 12:30:00 JST 2002 Naoyuki Sawa
 *	- clipdobj.cclipmod.cARs[ECĐVK쐬܂B
 *	* Sun Dec 8 05:43:00 JST 2002 Naoyuki Sawa
 *	- mod_mix()̃[voOCB
 *	- e|GtFNgΉB
 *	* Fri Jan 31 21:57:00 JST 2003 Naoyuki Sawa
 *	- new_LCDDrawObject()PIXEL(p,m)}Nmask蕔ǁB
 *	 u(mask >> (m) & 1)vu(mask & (1 << (m)))vɕύX܂B
 *	  3%(Sʓ])AR[hTCY20oCgȂȂ܂B
 *	  ̉ǂ́uryuǩOH[v(http://www.interq.or.jp/earth/ryuk/)ɂ̂łB
 *	- new_LCDDrawObject()̃NbsOʊO菈ǁB
 *	  ܂ŁA]Ȃ/肻ꂼ̏̒ōsĂ̂AʉĂ܂Ƃ߂܂B
 *	  R[hTCY4oCgȂȂ܂B
 *	- ȏ̕ύXsʁA_̃R[hTCY0xfe0(4064)oCgłB
 *	* Sat Feb 1 14:08:00 JST 2003 Naoyuki Sawa
 *	- new_LCDDrawObject()ɂāAc胉C̎擾uy = obj.dhvʉAeʐߖ񂵂܂B
 *	- MODhCoσ`lɑΉ܂B
 *	* Tue Apr 1 19:00:00 JST 2003 Naoyuki Sawa
 *	- clipfram.c𕪊Ãt@CV݂܂B
 */
#include "clip.h"

/****************************************************************************
 *	P/ECE MOD Driver (~LT[)
 ****************************************************************************/

int
mod_mix(MODDRIVER* driver, short wbuff[/*MODBUFLEN*/])
{
	static int mixbuf[MODBUFLEN]; /* ~LVOobt@Ars`shbłI */

	MODHEADER* header = driver->header;
	int i, chno, period, length, repofs, replen, volume, offset, step;
	int* pmix;
	short* pout;
	char* smpdat;
	MODSAMPLE* sample;
	MODCHANNEL* channel;

	/* ܂A~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* ̊e`lɂ... */
	for(chno = 0, channel = driver->channel; chno < driver->chans; chno++, channel++) {
		if(!(period = channel->period)) continue;

		/* TvȂǂoĂ܂B */
		sample = &header->sample[channel->smpno];
		smpdat = driver->smpdat[channel->smpno];
		length = SWAPH(sample->length) * 2 << 8; /* 24.8bit */
		repofs = SWAPH(sample->repofs) * 2 << 8; /* 24.8bit */
		replen = SWAPH(sample->replen) * 2 << 8; /* 24.8bit */
		if(replen <= 1 * 2 << 8) replen = 0; /* j̗R(H)replen=1[vȂƂ */
		volume = channel->volume;
		offset = channel->offset;

		/* sIhlTvItZbg߂܂B
		 * * 萔̗RF
		 *	AmigaPAL{NbN(?) = 7093789.2[Hz]  񕪎ăTEhHɋH
		 *	P/ECẼTEho͎g =   16000  [Hz]
		 * * TvItZbgF
		 *	Đ[g    = 7093789.2 / (period * 2)
		 *	[24.8bit] = (Đ[g / 16000) * 256
		 *	              = ((7093789.2 / (period * 2)) / 16000) * 256
		 *	              = (((7093789.2 / 2) / period) / 16000) * 256
		 *	              = ((7093789.2 / (2 * 16000)) / period) * 256
		 *	              = ((7093789.2 * 256) / (2 * 16000)) / period
		 *	              = 56750.3136 / period
		 */
		step = 56750 / period;

		for(i = 0, pmix = mixbuf; i < MODBUFLEN; i++, pmix++) {
LOOP:
			/* TvItZbgTvf[^ɃNsO܂B */
			if(!replen) {
				/* [vȂF
				 * 0length܂ōĐāA~܂B
				 */
				if(offset >= length) {
					channel->period = 0; /* ~ */
					goto NO_LOOP;
				}
			} else {
				/* [vF
				 * 0(repofs+replen),repofs(repofs+replen),...
				 * (repofs+replen)`length̋Ԃ͍Đ܂B
				 */
				if(offset >= repofs + replen) {
					offset -= replen;
					goto LOOP;
				}
			}

			/* ~LVOobt@ɃTvl~{[Z܂B */
			*pmix += smpdat[offset >> 8] * volume;

			/* TvItZbgi߂܂B */
			offset += step;
		}
NO_LOOP:
		/* TvItZbg߂܂B */
		channel->offset = offset;
	}

	/* ~LVOobt@(32rbg)o̓obt@(16rbg)փRs[܂B */
	for(i = 0, pmix = mixbuf, pout = wbuff; i < MODBUFLEN; i++, pmix++, pout++) {
		volume = *pmix << 1/*ʑA*/;
		     if(volume < -32767) volume = -32767;
		else if(volume >  32767) volume =  32767;
		*pout = volume;
	}

	return 0;
}

