/*	
 *	tx.c
 *
 *	PceEth - P/ECE NDIS-WDM ~j|[ghCo
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Tue Aug 16 06:19:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Aug 19 05:53:00 JST 2005 Naoyuki Sawa
 *	- ̐ؒfɔAWindows2000L̖ǉ܂B
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

static void tx_thread_routine(void* context);

/*****************************************************************************
 *	
 *****************************************************************************/

NTSTATUS
tx_init(MINIPORT_ADAPTER* miniport_adapter)
{
	KdPrint(("tx_init called\n"));

	/* L[܂B */
	InitializeListHead(&miniport_adapter->tx_queue);

	/* ėpCxg܂B */
	KeInitializeEvent(&miniport_adapter->tx_event, SynchronizationEvent, FALSE);

	/* XbhJn܂B */
	miniport_adapter->tx_thread = create_thread(tx_thread_routine, miniport_adapter);
	if(!miniport_adapter->tx_thread) {
		KdPrint(("create_thread failed\n"));
		goto L_ERR;
	}

	return STATUS_SUCCESS;

L_ERR:	/*-------------------------------------------------------------------*/

	if(miniport_adapter->tx_thread) {
		KeSetEvent(&miniport_adapter->abort_event, IO_NO_INCREMENT, FALSE);
		delete_thread(miniport_adapter->tx_thread);
		miniport_adapter->tx_thread = NULL;
	}

	return STATUS_UNSUCCESSFUL;
}

/*****************************************************************************
 *	
 *****************************************************************************/

void
tx_exit(MINIPORT_ADAPTER* miniport_adapter)
{
	KdPrint(("tx_exit called\n"));

	/* Xbh̏I҂܂B */
	KeSetEvent(&miniport_adapter->abort_event, IO_NO_INCREMENT, FALSE);
	delete_thread(miniport_adapter->tx_thread);
	miniport_adapter->tx_thread = NULL;

	/* MpPbg܂B */
	tx_cancel_packets(miniport_adapter);

	KdPrint(("tx_exit done\n"));
}

/*****************************************************************************
 *	
 *****************************************************************************/

void
tx_cancel_packets(MINIPORT_ADAPTER* miniport_adapter)
{
	LIST_ENTRY* list_entry;
	NDIS_PACKET* packet;

	KdPrint(("tx_cancel_packets called\n"));

	/* MpPbg܂B */
	for(;;) {
		list_entry = ExInterlockedRemoveHeadList(
			&miniport_adapter->tx_queue,
			&miniport_adapter->spin_lock);
		if(!list_entry) {
			break;
		}
		packet = CONTAINING_RECORD(list_entry, NDIS_PACKET, MiniportReserved);
		NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
		InterlockedIncrement(&miniport_adapter->xmit_error);
	}

	KdPrint(("tx_cancel_packets done\n"));
}

/*****************************************************************************
 *	
 *****************************************************************************/

static void
tx_thread_routine(void* context)
{
	MINIPORT_ADAPTER* miniport_adapter = context;
	//
	unsigned char* transfer_buffer = NULL;
	//
	NTSTATUS status;
	int transfer_buffer_length;
	LIST_ENTRY* list_entry;
	NDIS_PACKET* packet;
	NDIS_BUFFER* buffer;
	int total_packet_length;
	void* virtual_address;
	int length;
	URB urb;
	//
	void* wait_objects[THREAD_WAIT_OBJECTS];
	ASSERT(THREAD_WAIT_OBJECTS >= 3);

	KdPrint(("tx_thread_routine called\n"));

	/* ]obt@mۂ܂B */
	transfer_buffer_length = miniport_adapter->tx_pipe.MaximumTransferSize;
	transfer_buffer = ExAllocatePool(NonPagedPool, transfer_buffer_length);
	if(!transfer_buffer) {
		KdPrint(("ExAllocatePool failed\n"));
		goto L_EXIT;
	}

	for(;;) {
		/* L[AMpPbgo܂B */
		wait_objects[0] = &miniport_adapter->abort_event;
		wait_objects[1] = &miniport_adapter->tx_event;
		for(;;) {
			list_entry = ExInterlockedRemoveHeadList(
				&miniport_adapter->tx_queue,
				&miniport_adapter->spin_lock);
			if(list_entry) {
				break;
			}
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				goto L_EXIT;
			}
			if(status == 0/*abort_event*/) {
				goto L_EXIT;
			}
		}
		packet = CONTAINING_RECORD(list_entry, NDIS_PACKET, MiniportReserved);

		/* pPbg̃obt@AMobt@֓WJ܂B */
		total_packet_length = 0;
		NdisQueryPacket(packet, NULL, NULL, &buffer, NULL);
		while(buffer) {
			NdisQueryBuffer(buffer, &virtual_address, &length);
			if(total_packet_length + length > transfer_buffer_length) {
				length = transfer_buffer_length - total_packet_length;
			}
			memcpy(&transfer_buffer[total_packet_length], virtual_address, length);
			total_packet_length += length;
			NdisGetNextBuffer(buffer, &buffer);
		}
		if(!total_packet_length) {
			NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_SUCCESS);
			/* pPbǵAƂđɊ܂AJEg͂ȂƂɂ܂B */
			continue; /* ̃pPbg */
		}
		if(total_packet_length < 60) {
			/* ŏt[TCY̑Mv́Aŏt[TCY܂ŃpfBOđo܂B
			 * pfBÖ̃f[^͉ł\܂񂪁AfoCXł̃fobOeՂɂ邽߁A
			 * [NAĂƂɂ܂B(K{ł͂܂)
			 */
			memset(&transfer_buffer[total_packet_length], 0, (60 - total_packet_length));
			total_packet_length = 60;
			/* p */
		}
		if(total_packet_length > 1514) {
			/* őt[TCY߂̑Mv́AMG[ƂăJEgAo܂B */
			KdPrint(("total_packet_length = %d\n", total_packet_length));
			InterlockedIncrement(&miniport_adapter->xmit_error);
			continue; /* ̃pPbg */
		}
		KdPrint(("tx %02x-%02x-%02x-%02x-%02x-%02x %02x-%02x-%02x-%02x-%02x-%02x %04x %d\n",
			transfer_buffer[ 0],transfer_buffer[1],transfer_buffer[2],transfer_buffer[3],transfer_buffer[ 4],transfer_buffer[ 5],
			transfer_buffer[ 6],transfer_buffer[7],transfer_buffer[8],transfer_buffer[9],transfer_buffer[10],transfer_buffer[11],
			transfer_buffer[12]<<8|transfer_buffer[13],total_packet_length));

		/* USB֑M܂B */
		/*{{R[h*/
		UsbBuildInterruptOrBulkTransferRequest(
			&urb,							/* Urb */
			sizeof(struct _URB_BULK_OR_INTERRUPT_TRANSFER),		/* Length */
			miniport_adapter->tx_pipe.PipeHandle,			/* PipeHandle */
			transfer_buffer,					/* TransferBuffer */
			NULL,							/* TransferBufferMDL */
			total_packet_length,					/* TransferBufferLength */
			USBD_TRANSFER_DIRECTION_OUT | USBD_SHORT_TRANSFER_OK,	/* TransferFlags */
			NULL);							/* Link */
		status = usb_transfer(miniport_adapter->next_device_object, &urb, &miniport_adapter->abort_event);
		if(!NT_SUCCESS(status)) {
			KdPrint(("exec_transfer failed\n"));
			NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
			InterlockedIncrement(&miniport_adapter->xmit_error);
			goto L_EXIT;
		}
		if(urb.UrbBulkOrInterruptTransfer.TransferBufferLength != total_packet_length) {
			KdPrint(("TransferBufferLength %d != %d\n", urb.UrbBulkOrInterruptTransfer.TransferBufferLength, total_packet_length));
			NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
			InterlockedIncrement(&miniport_adapter->xmit_error);
			goto L_EXIT;
		}
		/*}}R[h*/

		/* Gh|Cg̃pPbgTCY̔{Ȃ΁AI[̂߂ɋpPbg𑗐M܂B */
		total_packet_length %= miniport_adapter->tx_pipe.MaximumPacketSize;
		if(!total_packet_length) {
			/*{{R[h*/
			UsbBuildInterruptOrBulkTransferRequest(
				&urb,							/* Urb */
				sizeof(struct _URB_BULK_OR_INTERRUPT_TRANSFER),		/* Length */
				miniport_adapter->tx_pipe.PipeHandle,			/* PipeHandle */
				transfer_buffer,					/* TransferBuffer */
				NULL,							/* TransferBufferMDL */
				total_packet_length,					/* TransferBufferLength */
				USBD_TRANSFER_DIRECTION_OUT | USBD_SHORT_TRANSFER_OK,	/* TransferFlags */
				NULL);							/* Link */
			status = usb_transfer(miniport_adapter->next_device_object, &urb, &miniport_adapter->abort_event);
			if(!NT_SUCCESS(status)) {
				KdPrint(("exec_transfer failed\n"));
				NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
				InterlockedIncrement(&miniport_adapter->xmit_error);
				goto L_EXIT;
			}
			if(urb.UrbBulkOrInterruptTransfer.TransferBufferLength != total_packet_length) {
				KdPrint(("TransferBufferLength %d != %d\n", urb.UrbBulkOrInterruptTransfer.TransferBufferLength, total_packet_length));
				NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
				InterlockedIncrement(&miniport_adapter->xmit_error);
				goto L_EXIT;
			}
			/*}}R[h*/
		}

		/* ̃pPbg̑M܂B */
		NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_SUCCESS);
		InterlockedIncrement(&miniport_adapter->xmit_ok);
	}

L_EXIT:	/*-------------------------------------------------------------------*/

	/* ]obt@J܂B */
	if(transfer_buffer) {
		ExFreePool(transfer_buffer);
		transfer_buffer = NULL;
	}

	/*{{2005/08/19 ̐ؒfɔAWindows2000L̖ǉ܂B*/
	/* * [NICfoCXhCȍ`vgR/T[rXƂ̃oCh]̊Ԃ̃^C~O(?)P/ECEOƁA
	 *   OSfoCX̏ł𔻒fłɁAMvpPbgėĂ܂݂łB
	 *   MXbh́AUSBDւ̑MNGXgsɂ胋[v𔲂Ă܂Ă邽߁AMpPbg܂B
	 *   ƁAfoCXhCoA[hłȂȂAOS̏IłȂȂĂ܂܂B(vAdIt)
	 *   miniport_halt()Ă΂΁AIɃL[ɂł̂łAminiport_halt()Ă΂Ȃ݂łB
	 * * q̖邽߂ɁAMXbh́Aabort_eventȊO̗vŃ[v𔲂ꍇɂ́A
	 *   ɂ̓XbhIAabort_eventZbg܂ŁAMvpPbg̊p邱Ƃɂ܂B
	 * * WindowsXPł͏q̖͔܂񂪁AǉĂQƎv܂B
	 *   Windows2000łAɂẮA肪Ȃꍇ݂łB(v)
	 */
	KdPrint(("wait for abort_event start\n"));
	wait_objects[0] = &miniport_adapter->abort_event;
	wait_objects[1] = &miniport_adapter->tx_event;
	for(;;) {
		list_entry = ExInterlockedRemoveHeadList(
			&miniport_adapter->tx_queue,
			&miniport_adapter->spin_lock);
		if(list_entry) {
			packet = CONTAINING_RECORD(list_entry, NDIS_PACKET, MiniportReserved);
			NdisMSendComplete(miniport_adapter->miniport_adapter_handle, packet, NDIS_STATUS_FAILURE);
		} else {
			status = KeWaitForMultipleObjects(2, wait_objects, WaitAny, Executive, KernelMode, FALSE, NULL, NULL);
			if(!NT_SUCCESS(status)) {
				KdPrint(("KeWaitForMultipleObjects failed\n"));
				break;
			}
			if(status == 0/*abort_event*/) {
				break;
			}
		}
	}
	KdPrint(("wait for abort_event done\n"));
	/* * ̎_őML[ɎcĂpPbǵAtx_exit()Ă΂tx_cancel_packets()ɂĊ͂łB
	 *   q̏́AgMvpPbgcĂ邽߂ɃfoCXhCõA[hNȂh̉ŁA
	 *   foCXhCõA[hNĂ܂΁Aȍ~͒ʏʂ̃N[AbvɂĊ܂B
	 */
	/*}}2005/08/19 ̐ؒfɔAWindows2000L̖ǉ܂B*/

	KdPrint(("tx_thread_routine exit\n"));

	/* XbhI܂B */
	PsTerminateSystemThread(STATUS_SUCCESS);
}
