;	
;	clipz80a.s
;
;	P/ECE Z80 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
;	- 쐬JnB
;	* Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;	- "JP cc"͏/sɂ炸ǉTCNłB
;	  ܂ŊԈ+7TCNĂ܂Ă̂C܂B
;	* Mon Jan 17 05:55:00 JST 2005 Naoyuki Sawa
;	- RETI,RETNɂāAz80_check_pending()ւ̈%r12=z80ݒ肵YĂ̂C܂B
;
#include "clipz80a.h"
#ifdef Z80_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	Z80\ framz80a.sɂ`Ă!!
;
;===== WX^ =====
#define F		 0
#define A		 1
#define C		 2
#define B		 3
#define E		 4
#define D		 5
#define L		 6
#define H		 7
#define AF		 0
#define BC		 2
#define DE		 4
#define HL		 6
#define AF2		 8
#define BC2		10
#define DE2		12
#define HL2		14
#define IXL		16
#define IXH		17
#define IYL		18
#define IYH		19
#define IX		16
#define IY		18
#define SP		20
#define PC		22
;=====  =====
#define IFF1		32
#define IFF2		33
#define IM		34
#define HALT		35
#define CYCLE		36
;{{2005/01/07 INTvۗΉ̂߂ɒǉ
#define PENDING		40
#define PENDING_NO	41
;}}2005/01/07 INTvۗΉ̂߂ɒǉ
;===== O֐ =====
#define READ		48
#define WRITE		52
#define IN		56
#define OUT		60

;****************************************************************************

;
;	Z80=>DMGtOϊ\
;
				; C33(C,V,Z,N) => Z80(S,Z,V,C)
	.global z80_FLAG_CONV	; ====C33====     ====Z80====
z80_FLAG_CONV:			; ----CVZN        SZ---V-C   
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x40		; 00000010 02     01000000 40
	.byte	0xc0		; 00000011 03     11000000 c0
	.byte	0x04		; 00000100 04     00000100 04
	.byte	0x84		; 00000101 05     10000100 84
	.byte	0x44		; 00000110 06     01000100 44
	.byte	0xc4		; 00000111 07     11000100 c4
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x41		; 00001010 0a     01000001 41
	.byte	0xc1		; 00001011 0b     11000001 c1
	.byte	0x05		; 00001100 0c     00000101 05
	.byte	0x85		; 00001101 0d     10000101 85
	.byte	0x45		; 00001110 0e     01000101 45
	.byte	0xc5		; 00001111 0f     11000101 c5

;****************************************************************************
;	8-Bit Load Group
;****************************************************************************

#macro LD_r_IlmI $1
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	ld.w %r13, %r15			; lm
	xsll %r13, 8
	or %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$1], %r10
	;
	popn %r0
	ret
#endm

#macro LD_r_IrrI $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	xld.uh %r13, [%r12+$2]		; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$1], %r10
	;
	popn %r0
	ret
#endm

#macro LD_r_Irr_dI $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	xld.uh %r13, [%r12+$2]		; rr+d
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$1], %r10
	;
	popn %r0
	ret
#endm

#macro LD_IlmI_r $1
	xld.w %r10, [%r12+WRITE]
	ld.w %r13, %r15			; lm
	xsll %r13, 8
	or %r13, %r14
	xld.ub %r14, [%r12+$1]
	call %r10
	ret
#endm

#macro LD_IrrI_n $1
	xld.w %r10, [%r12+WRITE]
	xld.uh %r13, [%r12+$1]		; *anti-interlock*
	call %r10
	ret
#endm

#macro LD_IrrI_r $1, $2
	xld.w %r10, [%r12+WRITE]
	xld.uh %r13, [%r12+$1]
	xld.ub %r14, [%r12+$2]
	call %r10
	ret
#endm

#macro LD_Irr_dI_n $1
	xld.w %r10, [%r12+WRITE]
	xld.uh %r13, [%r12+$1]		; rr+d
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r14, %r15			; *delay*
	ret
#endm

#macro LD_Irr_dI_r $1, $2
	xld.w %r10, [%r12+WRITE]
	xld.uh %r13, [%r12+$1]		; rr+d
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	xld.ub %r14, [%r12+$2]
	call %r10
	ret
#endm

;****************************************************************************

	.global z80op_LD_A_IlmI
z80op_LD_A_IlmI:
	LD_r_IlmI A

	.global z80op_LD_A_IBCI
z80op_LD_A_IBCI:
	LD_r_IrrI A, BC
	.global z80op_LD_A_IDEI
z80op_LD_A_IDEI:
	LD_r_IrrI A, DE
	.global z80op_LD_A_IHLI
z80op_LD_A_IHLI:
	LD_r_IrrI A, HL
	.global z80op_LD_B_IHLI
z80op_LD_B_IHLI:
	LD_r_IrrI B, HL
	.global z80op_LD_C_IHLI
z80op_LD_C_IHLI:
	LD_r_IrrI C, HL
	.global z80op_LD_D_IHLI
z80op_LD_D_IHLI:
	LD_r_IrrI D, HL
	.global z80op_LD_E_IHLI
z80op_LD_E_IHLI:
	LD_r_IrrI E, HL
	.global z80op_LD_H_IHLI
z80op_LD_H_IHLI:
	LD_r_IrrI H, HL
	.global z80op_LD_L_IHLI
z80op_LD_L_IHLI:
	LD_r_IrrI L, HL

	.global z80op_LD_A_IIX_dI
z80op_LD_A_IIX_dI:
	LD_r_Irr_dI A, IX
	.global z80op_LD_B_IIX_dI
z80op_LD_B_IIX_dI:
	LD_r_Irr_dI B, IX
	.global z80op_LD_C_IIX_dI
z80op_LD_C_IIX_dI:
	LD_r_Irr_dI C, IX
	.global z80op_LD_D_IIX_dI
z80op_LD_D_IIX_dI:
	LD_r_Irr_dI D, IX
	.global z80op_LD_E_IIX_dI
z80op_LD_E_IIX_dI:
	LD_r_Irr_dI E, IX
	.global z80op_LD_H_IIX_dI
z80op_LD_H_IIX_dI:
	LD_r_Irr_dI H, IX
	.global z80op_LD_L_IIX_dI
z80op_LD_L_IIX_dI:
	LD_r_Irr_dI L, IX
	.global z80op_LD_A_IIY_dI
z80op_LD_A_IIY_dI:
	LD_r_Irr_dI A, IY
	.global z80op_LD_B_IIY_dI
z80op_LD_B_IIY_dI:
	LD_r_Irr_dI B, IY
	.global z80op_LD_C_IIY_dI
z80op_LD_C_IIY_dI:
	LD_r_Irr_dI C, IY
	.global z80op_LD_D_IIY_dI
z80op_LD_D_IIY_dI:
	LD_r_Irr_dI D, IY
	.global z80op_LD_E_IIY_dI
z80op_LD_E_IIY_dI:
	LD_r_Irr_dI E, IY
	.global z80op_LD_H_IIY_dI
z80op_LD_H_IIY_dI:
	LD_r_Irr_dI H, IY
	.global z80op_LD_L_IIY_dI
z80op_LD_L_IIY_dI:
	LD_r_Irr_dI L, IY

	.global z80op_LD_IlmI_A
z80op_LD_IlmI_A:
	LD_IlmI_r A

	.global z80op_LD_IHLI_n
z80op_LD_IHLI_n:
	LD_IrrI_n HL

	.global z80op_LD_IBCI_A
z80op_LD_IBCI_A:
	LD_IrrI_r BC, A
	.global z80op_LD_IDEI_A
z80op_LD_IDEI_A:
	LD_IrrI_r DE, A
	.global z80op_LD_IHLI_A
z80op_LD_IHLI_A:
	LD_IrrI_r HL, A
	.global z80op_LD_IHLI_B
z80op_LD_IHLI_B:
	LD_IrrI_r HL, B
	.global z80op_LD_IHLI_C
z80op_LD_IHLI_C:
	LD_IrrI_r HL, C
	.global z80op_LD_IHLI_D
z80op_LD_IHLI_D:
	LD_IrrI_r HL, D
	.global z80op_LD_IHLI_E
z80op_LD_IHLI_E:
	LD_IrrI_r HL, E
	.global z80op_LD_IHLI_H
z80op_LD_IHLI_H:
	LD_IrrI_r HL, H
	.global z80op_LD_IHLI_L
z80op_LD_IHLI_L:
	LD_IrrI_r HL, L

	.global z80op_LD_IIX_dI_n
z80op_LD_IIX_dI_n:
	LD_Irr_dI_n IX
	.global z80op_LD_IIY_dI_n
z80op_LD_IIY_dI_n:
	LD_Irr_dI_n IY

	.global z80op_LD_IIX_dI_A
z80op_LD_IIX_dI_A:
	LD_Irr_dI_r IX, A
	.global z80op_LD_IIX_dI_B
z80op_LD_IIX_dI_B:
	LD_Irr_dI_r IX, B
	.global z80op_LD_IIX_dI_C
z80op_LD_IIX_dI_C:
	LD_Irr_dI_r IX, C
	.global z80op_LD_IIX_dI_D
z80op_LD_IIX_dI_D:
	LD_Irr_dI_r IX, D
	.global z80op_LD_IIX_dI_E
z80op_LD_IIX_dI_E:
	LD_Irr_dI_r IX, E
	.global z80op_LD_IIX_dI_H
z80op_LD_IIX_dI_H:
	LD_Irr_dI_r IX, H
	.global z80op_LD_IIX_dI_L
z80op_LD_IIX_dI_L:
	LD_Irr_dI_r IX, L
	.global z80op_LD_IIY_dI_A
z80op_LD_IIY_dI_A:
	LD_Irr_dI_r IY, A
	.global z80op_LD_IIY_dI_B
z80op_LD_IIY_dI_B:
	LD_Irr_dI_r IY, B
	.global z80op_LD_IIY_dI_C
z80op_LD_IIY_dI_C:
	LD_Irr_dI_r IY, C
	.global z80op_LD_IIY_dI_D
z80op_LD_IIY_dI_D:
	LD_Irr_dI_r IY, D
	.global z80op_LD_IIY_dI_E
z80op_LD_IIY_dI_E:
	LD_Irr_dI_r IY, E
	.global z80op_LD_IIY_dI_H
z80op_LD_IIY_dI_H:
	LD_Irr_dI_r IY, H
	.global z80op_LD_IIY_dI_L
z80op_LD_IIY_dI_L:
	LD_Irr_dI_r IY, L

;****************************************************************************
;	16-Bit Load Group
;****************************************************************************

#macro LD_rr_rr $1, $2
	xld.uh %r10, [%r12+$2]
	xld.h [%r12+$1], %r10
	ret
#endm

#macro LD_rr_lm $1
	xsll %r15, 8
	or %r14, %r15
	xld.h [%r12+$1], %r14
	ret
#endm

#macro LD_rr_IlmI $1
	pushn %r1
	;
	ld.w %r1, %r15			; (lm+0)
	xsll %r1, 8
	or %r1, %r14
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+($1+0)], %r10	; LO
	;
	xadd %r1, %r1, 1		; (lm+1)
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+($1+1)], %r10	; HI
	;
	popn %r1
	ret
#endm

#macro LD_IlmI_rr $1
	pushn %r1
	;
	ld.w %r1, %r15			; (lm+0)
	xsll %r1, 8
	or %r1, %r14
	;
	xld.w %r10, [%r12+WRITE]
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+($1+0)]	; LO
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xadd %r1, %r1, 1		; (lm+1)
	;
	xld.w %r10, [%r0+WRITE]
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+($1+1)]	; HI
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

#macro POP_rr $1
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+($1+0)], %r10	; LO
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+($1+1)], %r10	; HI
	xadd %r1, %r1, 1		; SP++
	;
	xld.h [%r0+SP], %r1		; SP
	;
	popn %r1
	ret
#endm

#macro PUSH_rr $1
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+($1+1)]	; HI
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.w %r10, [%r0+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+($1+0)]	; LO
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+SP], %r1		; SP
	;
	popn %r1
	ret
#endm

;****************************************************************************

	.global z80op_LD_SP_HL
z80op_LD_SP_HL:
	LD_rr_rr SP, HL
	.global z80op_LD_SP_IX
z80op_LD_SP_IX:
	LD_rr_rr SP, IX
	.global z80op_LD_SP_IY
z80op_LD_SP_IY:
	LD_rr_rr SP, IY

	.global z80op_LD_BC_lm
z80op_LD_BC_lm:
	LD_rr_lm BC
	.global z80op_LD_DE_lm
z80op_LD_DE_lm:
	LD_rr_lm DE
	.global z80op_LD_HL_lm
z80op_LD_HL_lm:
	LD_rr_lm HL
	.global z80op_LD_SP_lm
z80op_LD_SP_lm:
	LD_rr_lm SP
	.global z80op_LD_IX_lm
z80op_LD_IX_lm:
	LD_rr_lm IX
	.global z80op_LD_IY_lm
z80op_LD_IY_lm:
	LD_rr_lm IY

	.global z80op_LD_BC_IlmI
z80op_LD_BC_IlmI:
	LD_rr_IlmI BC
	.global z80op_LD_DE_IlmI
z80op_LD_DE_IlmI:
	LD_rr_IlmI DE
	.global z80op_LD_HL_IlmI
z80op_LD_HL_IlmI:
	LD_rr_IlmI HL
	.global z80op_LD_SP_IlmI
z80op_LD_SP_IlmI:
	LD_rr_IlmI SP
	.global z80op_LD_IX_IlmI
z80op_LD_IX_IlmI:
	LD_rr_IlmI IX
	.global z80op_LD_IY_IlmI
z80op_LD_IY_IlmI:
	LD_rr_IlmI IY

	.global z80op_LD_IlmI_BC
z80op_LD_IlmI_BC:
	LD_IlmI_rr BC
	.global z80op_LD_IlmI_DE
z80op_LD_IlmI_DE:
	LD_IlmI_rr DE
	.global z80op_LD_IlmI_HL
z80op_LD_IlmI_HL:
	LD_IlmI_rr HL
	.global z80op_LD_IlmI_SP
z80op_LD_IlmI_SP:
	LD_IlmI_rr SP
	.global z80op_LD_IlmI_IX
z80op_LD_IlmI_IX:
	LD_IlmI_rr IX
	.global z80op_LD_IlmI_IY
z80op_LD_IlmI_IY:
	LD_IlmI_rr IY

	.global z80op_POP_AF
z80op_POP_AF:
	POP_rr AF
	.global z80op_POP_BC
z80op_POP_BC:
	POP_rr BC
	.global z80op_POP_DE
z80op_POP_DE:
	POP_rr DE
	.global z80op_POP_HL
z80op_POP_HL:
	POP_rr HL
	.global z80op_POP_IX
z80op_POP_IX:
	POP_rr IX
	.global z80op_POP_IY
z80op_POP_IY:
	POP_rr IY

	.global z80op_PUSH_AF
z80op_PUSH_AF:
	PUSH_rr AF
	.global z80op_PUSH_BC
z80op_PUSH_BC:
	PUSH_rr BC
	.global z80op_PUSH_DE
z80op_PUSH_DE:
	PUSH_rr DE
	.global z80op_PUSH_HL
z80op_PUSH_HL:
	PUSH_rr HL
	.global z80op_PUSH_IX
z80op_PUSH_IX:
	PUSH_rr IX
	.global z80op_PUSH_IY
z80op_PUSH_IY:
	PUSH_rr IY

;****************************************************************************
;	8-Bit Arithmetic Group
;****************************************************************************

; BOP8 ... 8bit Binary Operation
; UOP8 ... 8bit Unary  Operation

#macro BOP8_n $1
	xcall.d z80_$1
	ld.w %r13, %r14			; *delay*
	ret
#endm

#macro BOP8_r $1, $2
	xld.ub %r13, [%r12+$2]
	xcall z80_$1
	ret
#endm

#macro BOP8_IrrI $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]		; (rr)
	xld.uh %r13, [%r12+$2]		; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr)
	xcall.d z80_$1
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
#endm

#macro BOP8_Irr_dI $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]		; (rr+d)
	xld.uh %r13, [%r12+$2]
	ld.b %r14, %r14			; *anti-interlock*
	add %r13, %r14
	ld.uh %r13, %r13
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10			; A op (rr+d)
	xcall.d z80_$1
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
#endm

#macro UOP8_r $1, $2
	pushn %r0
	;
	xld.ub %r13, [%r12+$2]
	xcall.d z80_$1
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

#macro UOP8_IrrI $1, $2
	pushn %r0
	;
	xld.w %r10, [%r12+READ]
	xld.uh %r13, [%r12+$2]		; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d z80_$1
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	xld.w %r10, [%r0+WRITE]
	xld.uh %r13, [%r0+$2]		; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r0
	ret
#endm

#macro UOP8_Irr_dI $1, $2
	pushn %r1
	;
	xld.uh %r1, [%r12+$2]		; rr+d
	ld.b %r14, %r14			; *anti-interlock*
	add %r1, %r14
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	xcall.d z80_$1
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	xld.w %r10, [%r0+WRITE]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

;****************************************************************************

	.global z80op_ADD_A_n
z80op_ADD_A_n:
	BOP8_n ADD8
	.global z80op_ADD_A_A
z80op_ADD_A_A:
	BOP8_r ADD8, A
	.global z80op_ADD_A_B
z80op_ADD_A_B:
	BOP8_r ADD8, B
	.global z80op_ADD_A_C
z80op_ADD_A_C:
	BOP8_r ADD8, C
	.global z80op_ADD_A_D
z80op_ADD_A_D:
	BOP8_r ADD8, D
	.global z80op_ADD_A_E
z80op_ADD_A_E:
	BOP8_r ADD8, E
	.global z80op_ADD_A_H
z80op_ADD_A_H:
	BOP8_r ADD8, H
	.global z80op_ADD_A_L
z80op_ADD_A_L:
	BOP8_r ADD8, L
	.global z80op_ADD_A_IXH
z80op_ADD_A_IXH:
	BOP8_r ADD8, IXH
	.global z80op_ADD_A_IXL
z80op_ADD_A_IXL:
	BOP8_r ADD8, IXL
	.global z80op_ADD_A_IYH
z80op_ADD_A_IYH:
	BOP8_r ADD8, IYH
	.global z80op_ADD_A_IYL
z80op_ADD_A_IYL:
	BOP8_r ADD8, IYL
	.global z80op_ADD_A_IHLI
z80op_ADD_A_IHLI:
	BOP8_IrrI ADD8, HL
	.global z80op_ADD_A_IIX_dI
z80op_ADD_A_IIX_dI:
	BOP8_Irr_dI ADD8, IX
	.global z80op_ADD_A_IIY_dI
z80op_ADD_A_IIY_dI:
	BOP8_Irr_dI ADD8, IY

	.global z80op_ADC_A_n
z80op_ADC_A_n:
	BOP8_n ADC8
	.global z80op_ADC_A_A
z80op_ADC_A_A:
	BOP8_r ADC8, A
	.global z80op_ADC_A_B
z80op_ADC_A_B:
	BOP8_r ADC8, B
	.global z80op_ADC_A_C
z80op_ADC_A_C:
	BOP8_r ADC8, C
	.global z80op_ADC_A_D
z80op_ADC_A_D:
	BOP8_r ADC8, D
	.global z80op_ADC_A_E
z80op_ADC_A_E:
	BOP8_r ADC8, E
	.global z80op_ADC_A_H
z80op_ADC_A_H:
	BOP8_r ADC8, H
	.global z80op_ADC_A_L
z80op_ADC_A_L:
	BOP8_r ADC8, L
	.global z80op_ADC_A_IXH
z80op_ADC_A_IXH:
	BOP8_r ADC8, IXH
	.global z80op_ADC_A_IXL
z80op_ADC_A_IXL:
	BOP8_r ADC8, IXL
	.global z80op_ADC_A_IYH
z80op_ADC_A_IYH:
	BOP8_r ADC8, IYH
	.global z80op_ADC_A_IYL
z80op_ADC_A_IYL:
	BOP8_r ADC8, IYL
	.global z80op_ADC_A_IHLI
z80op_ADC_A_IHLI:
	BOP8_IrrI ADC8, HL
	.global z80op_ADC_A_IIX_dI
z80op_ADC_A_IIX_dI:
	BOP8_Irr_dI ADC8, IX
	.global z80op_ADC_A_IIY_dI
z80op_ADC_A_IIY_dI:
	BOP8_Irr_dI ADC8, IY

	.global z80op_SUB_n
z80op_SUB_n:
	BOP8_n SUB8
	.global z80op_SUB_A
z80op_SUB_A:
	BOP8_r SUB8, A
	.global z80op_SUB_B
z80op_SUB_B:
	BOP8_r SUB8, B
	.global z80op_SUB_C
z80op_SUB_C:
	BOP8_r SUB8, C
	.global z80op_SUB_D
z80op_SUB_D:
	BOP8_r SUB8, D
	.global z80op_SUB_E
z80op_SUB_E:
	BOP8_r SUB8, E
	.global z80op_SUB_H
z80op_SUB_H:
	BOP8_r SUB8, H
	.global z80op_SUB_L
z80op_SUB_L:
	BOP8_r SUB8, L
	.global z80op_SUB_IXH
z80op_SUB_IXH:
	BOP8_r SUB8, IXH
	.global z80op_SUB_IXL
z80op_SUB_IXL:
	BOP8_r SUB8, IXL
	.global z80op_SUB_IYH
z80op_SUB_IYH:
	BOP8_r SUB8, IYH
	.global z80op_SUB_IYL
z80op_SUB_IYL:
	BOP8_r SUB8, IYL
	.global z80op_SUB_IHLI
z80op_SUB_IHLI:
	BOP8_IrrI SUB8, HL
	.global z80op_SUB_IIX_dI
z80op_SUB_IIX_dI:
	BOP8_Irr_dI SUB8, IX
	.global z80op_SUB_IIY_dI
z80op_SUB_IIY_dI:
	BOP8_Irr_dI SUB8, IY

	.global z80op_SBC_A_n
z80op_SBC_A_n:
	BOP8_n SBC8
	.global z80op_SBC_A_A
z80op_SBC_A_A:
	BOP8_r SBC8, A
	.global z80op_SBC_A_B
z80op_SBC_A_B:
	BOP8_r SBC8, B
	.global z80op_SBC_A_C
z80op_SBC_A_C:
	BOP8_r SBC8, C
	.global z80op_SBC_A_D
z80op_SBC_A_D:
	BOP8_r SBC8, D
	.global z80op_SBC_A_E
z80op_SBC_A_E:
	BOP8_r SBC8, E
	.global z80op_SBC_A_H
z80op_SBC_A_H:
	BOP8_r SBC8, H
	.global z80op_SBC_A_L
z80op_SBC_A_L:
	BOP8_r SBC8, L
	.global z80op_SBC_A_IXH
z80op_SBC_A_IXH:
	BOP8_r SBC8, IXH
	.global z80op_SBC_A_IXL
z80op_SBC_A_IXL:
	BOP8_r SBC8, IXL
	.global z80op_SBC_A_IYH
z80op_SBC_A_IYH:
	BOP8_r SBC8, IYH
	.global z80op_SBC_A_IYL
z80op_SBC_A_IYL:
	BOP8_r SBC8, IYL
	.global z80op_SBC_A_IHLI
z80op_SBC_A_IHLI:
	BOP8_IrrI SBC8, HL
	.global z80op_SBC_A_IIX_dI
z80op_SBC_A_IIX_dI:
	BOP8_Irr_dI SBC8, IX
	.global z80op_SBC_A_IIY_dI
z80op_SBC_A_IIY_dI:
	BOP8_Irr_dI SBC8, IY

	.global z80op_AND_n
z80op_AND_n:
	BOP8_n AND
	.global z80op_AND_A
z80op_AND_A:
	BOP8_r AND, A
	.global z80op_AND_B
z80op_AND_B:
	BOP8_r AND, B
	.global z80op_AND_C
z80op_AND_C:
	BOP8_r AND, C
	.global z80op_AND_D
z80op_AND_D:
	BOP8_r AND, D
	.global z80op_AND_E
z80op_AND_E:
	BOP8_r AND, E
	.global z80op_AND_H
z80op_AND_H:
	BOP8_r AND, H
	.global z80op_AND_L
z80op_AND_L:
	BOP8_r AND, L
	.global z80op_AND_IXH
z80op_AND_IXH:
	BOP8_r AND, IXH
	.global z80op_AND_IXL
z80op_AND_IXL:
	BOP8_r AND, IXL
	.global z80op_AND_IYH
z80op_AND_IYH:
	BOP8_r AND, IYH
	.global z80op_AND_IYL
z80op_AND_IYL:
	BOP8_r AND, IYL
	.global z80op_AND_IHLI
z80op_AND_IHLI:
	BOP8_IrrI AND, HL
	.global z80op_AND_IIX_dI
z80op_AND_IIX_dI:
	BOP8_Irr_dI AND, IX
	.global z80op_AND_IIY_dI
z80op_AND_IIY_dI:
	BOP8_Irr_dI AND, IY

	.global z80op_OR_n
z80op_OR_n:
	BOP8_n OR
	.global z80op_OR_A
z80op_OR_A:
	BOP8_r OR, A
	.global z80op_OR_B
z80op_OR_B:
	BOP8_r OR, B
	.global z80op_OR_C
z80op_OR_C:
	BOP8_r OR, C
	.global z80op_OR_D
z80op_OR_D:
	BOP8_r OR, D
	.global z80op_OR_E
z80op_OR_E:
	BOP8_r OR, E
	.global z80op_OR_H
z80op_OR_H:
	BOP8_r OR, H
	.global z80op_OR_L
z80op_OR_L:
	BOP8_r OR, L
	.global z80op_OR_IXH
z80op_OR_IXH:
	BOP8_r OR, IXH
	.global z80op_OR_IXL
z80op_OR_IXL:
	BOP8_r OR, IXL
	.global z80op_OR_IYH
z80op_OR_IYH:
	BOP8_r OR, IYH
	.global z80op_OR_IYL
z80op_OR_IYL:
	BOP8_r OR, IYL
	.global z80op_OR_IHLI
z80op_OR_IHLI:
	BOP8_IrrI OR, HL
	.global z80op_OR_IIX_dI
z80op_OR_IIX_dI:
	BOP8_Irr_dI OR, IX
	.global z80op_OR_IIY_dI
z80op_OR_IIY_dI:
	BOP8_Irr_dI OR, IY

	.global z80op_XOR_n
z80op_XOR_n:
	BOP8_n XOR
	.global z80op_XOR_A
z80op_XOR_A:
	BOP8_r XOR, A
	.global z80op_XOR_B
z80op_XOR_B:
	BOP8_r XOR, B
	.global z80op_XOR_C
z80op_XOR_C:
	BOP8_r XOR, C
	.global z80op_XOR_D
z80op_XOR_D:
	BOP8_r XOR, D
	.global z80op_XOR_E
z80op_XOR_E:
	BOP8_r XOR, E
	.global z80op_XOR_H
z80op_XOR_H:
	BOP8_r XOR, H
	.global z80op_XOR_L
z80op_XOR_L:
	BOP8_r XOR, L
	.global z80op_XOR_IXH
z80op_XOR_IXH:
	BOP8_r XOR, IXH
	.global z80op_XOR_IXL
z80op_XOR_IXL:
	BOP8_r XOR, IXL
	.global z80op_XOR_IYH
z80op_XOR_IYH:
	BOP8_r XOR, IYH
	.global z80op_XOR_IYL
z80op_XOR_IYL:
	BOP8_r XOR, IYL
	.global z80op_XOR_IHLI
z80op_XOR_IHLI:
	BOP8_IrrI XOR, HL
	.global z80op_XOR_IIX_dI
z80op_XOR_IIX_dI:
	BOP8_Irr_dI XOR, IX
	.global z80op_XOR_IIY_dI
z80op_XOR_IIY_dI:
	BOP8_Irr_dI XOR, IY

	.global z80op_CP_n
z80op_CP_n:
	BOP8_n CP
	.global z80op_CP_A
z80op_CP_A:
	BOP8_r CP, A
	.global z80op_CP_B
z80op_CP_B:
	BOP8_r CP, B
	.global z80op_CP_C
z80op_CP_C:
	BOP8_r CP, C
	.global z80op_CP_D
z80op_CP_D:
	BOP8_r CP, D
	.global z80op_CP_E
z80op_CP_E:
	BOP8_r CP, E
	.global z80op_CP_H
z80op_CP_H:
	BOP8_r CP, H
	.global z80op_CP_L
z80op_CP_L:
	BOP8_r CP, L
	.global z80op_CP_IXH
z80op_CP_IXH:
	BOP8_r CP, IXH
	.global z80op_CP_IXL
z80op_CP_IXL:
	BOP8_r CP, IXL
	.global z80op_CP_IYH
z80op_CP_IYH:
	BOP8_r CP, IYH
	.global z80op_CP_IYL
z80op_CP_IYL:
	BOP8_r CP, IYL
	.global z80op_CP_IHLI
z80op_CP_IHLI:
	BOP8_IrrI CP, HL
	.global z80op_CP_IIX_dI
z80op_CP_IIX_dI:
	BOP8_Irr_dI CP, IX
	.global z80op_CP_IIY_dI
z80op_CP_IIY_dI:
	BOP8_Irr_dI CP, IY

	.global z80op_INC_A
z80op_INC_A:
	UOP8_r INC8, A
	.global z80op_INC_B
z80op_INC_B:
	UOP8_r INC8, B
	.global z80op_INC_C
z80op_INC_C:
	UOP8_r INC8, C
	.global z80op_INC_D
z80op_INC_D:
	UOP8_r INC8, D
	.global z80op_INC_E
z80op_INC_E:
	UOP8_r INC8, E
	.global z80op_INC_H
z80op_INC_H:
	UOP8_r INC8, H
	.global z80op_INC_L
z80op_INC_L:
	UOP8_r INC8, L
	.global z80op_INC_IXH
z80op_INC_IXH:
	UOP8_r INC8, IXH
	.global z80op_INC_IXL
z80op_INC_IXL:
	UOP8_r INC8, IXL
	.global z80op_INC_IYH
z80op_INC_IYH:
	UOP8_r INC8, IYH
	.global z80op_INC_IYL
z80op_INC_IYL:
	UOP8_r INC8, IYL
	.global z80op_INC_IHLI
z80op_INC_IHLI:
	UOP8_IrrI INC8, HL
	.global z80op_INC_IIX_dI
z80op_INC_IIX_dI:
	UOP8_Irr_dI INC8, IX
	.global z80op_INC_IIY_dI
z80op_INC_IIY_dI:
	UOP8_Irr_dI INC8, IY

	.global z80op_DEC_A
z80op_DEC_A:
	UOP8_r DEC8, A
	.global z80op_DEC_B
z80op_DEC_B:
	UOP8_r DEC8, B
	.global z80op_DEC_C
z80op_DEC_C:
	UOP8_r DEC8, C
	.global z80op_DEC_D
z80op_DEC_D:
	UOP8_r DEC8, D
	.global z80op_DEC_E
z80op_DEC_E:
	UOP8_r DEC8, E
	.global z80op_DEC_H
z80op_DEC_H:
	UOP8_r DEC8, H
	.global z80op_DEC_L
z80op_DEC_L:
	UOP8_r DEC8, L
	.global z80op_DEC_IXH
z80op_DEC_IXH:
	UOP8_r DEC8, IXH
	.global z80op_DEC_IXL
z80op_DEC_IXL:
	UOP8_r DEC8, IXL
	.global z80op_DEC_IYH
z80op_DEC_IYH:
	UOP8_r DEC8, IYH
	.global z80op_DEC_IYL
z80op_DEC_IYL:
	UOP8_r DEC8, IYL
	.global z80op_DEC_IHLI
z80op_DEC_IHLI:
	UOP8_IrrI DEC8, HL
	.global z80op_DEC_IIX_dI
z80op_DEC_IIX_dI:
	UOP8_Irr_dI DEC8, IX
	.global z80op_DEC_IIY_dI
z80op_DEC_IIY_dI:
	UOP8_Irr_dI DEC8, IY

;****************************************************************************
;	16-Bit Arithmetic Group
;****************************************************************************

; BOP16 ... 16bit Binary Operation

#macro BOP16_rr_rr $1, $2, $3
	pushn %r0
	;
	xld.uh %r13, [%r0+$2]
	xld.uh %r14, [%r0+$3]
	xcall.d z80_$1
	ld.w %r0, %r12			; *delay*
	xld.h [%r0+$2], %r10
	;
	popn %r0
	ret
#endm

;****************************************************************************

	.global z80op_ADD_HL_BC
z80op_ADD_HL_BC:
	BOP16_rr_rr ADD16, HL, BC
	.global z80op_ADD_HL_DE
z80op_ADD_HL_DE:
	BOP16_rr_rr ADD16, HL, DE
	.global z80op_ADD_HL_HL
z80op_ADD_HL_HL:
	BOP16_rr_rr ADD16, HL, HL
	.global z80op_ADD_HL_SP
z80op_ADD_HL_SP:
	BOP16_rr_rr ADD16, HL, SP
	.global z80op_ADD_IX_BC
z80op_ADD_IX_BC:
	BOP16_rr_rr ADD16, IX, BC
	.global z80op_ADD_IX_DE
z80op_ADD_IX_DE:
	BOP16_rr_rr ADD16, IX, DE
	.global z80op_ADD_IX_IX
z80op_ADD_IX_IX:
	BOP16_rr_rr ADD16, IX, IX
	.global z80op_ADD_IX_SP
z80op_ADD_IX_SP:
	BOP16_rr_rr ADD16, IX, SP
	.global z80op_ADD_IY_BC
z80op_ADD_IY_BC:
	BOP16_rr_rr ADD16, IY, BC
	.global z80op_ADD_IY_DE
z80op_ADD_IY_DE:
	BOP16_rr_rr ADD16, IY, DE
	.global z80op_ADD_IY_IY
z80op_ADD_IY_IY:
	BOP16_rr_rr ADD16, IY, IY
	.global z80op_ADD_IY_SP
z80op_ADD_IY_SP:
	BOP16_rr_rr ADD16, IY, SP

	.global z80op_ADC_HL_BC
z80op_ADC_HL_BC:
	BOP16_rr_rr ADC16, HL, BC
	.global z80op_ADC_HL_DE
z80op_ADC_HL_DE:
	BOP16_rr_rr ADC16, HL, DE
	.global z80op_ADC_HL_HL
z80op_ADC_HL_HL:
	BOP16_rr_rr ADC16, HL, HL
	.global z80op_ADC_HL_SP
z80op_ADC_HL_SP:
	BOP16_rr_rr ADC16, HL, SP

	.global z80op_SBC_HL_BC
z80op_SBC_HL_BC:
	BOP16_rr_rr SBC16, HL, BC
	.global z80op_SBC_HL_DE
z80op_SBC_HL_DE:
	BOP16_rr_rr SBC16, HL, DE
	.global z80op_SBC_HL_HL
z80op_SBC_HL_HL:
	BOP16_rr_rr SBC16, HL, HL
	.global z80op_SBC_HL_SP
z80op_SBC_HL_SP:
	BOP16_rr_rr SBC16, HL, SP

;****************************************************************************
;	Rotate and Shift Group
;****************************************************************************

	.global z80op_RL_A
z80op_RL_A:
	UOP8_r RL, A
	.global z80op_RL_B
z80op_RL_B:
	UOP8_r RL, B
	.global z80op_RL_C
z80op_RL_C:
	UOP8_r RL, C
	.global z80op_RL_D
z80op_RL_D:
	UOP8_r RL, D
	.global z80op_RL_E
z80op_RL_E:
	UOP8_r RL, E
	.global z80op_RL_H
z80op_RL_H:
	UOP8_r RL, H
	.global z80op_RL_L
z80op_RL_L:
	UOP8_r RL, L
	.global z80op_RL_IXH
z80op_RL_IXH:
	UOP8_r RL, IXH
	.global z80op_RL_IXL
z80op_RL_IXL:
	UOP8_r RL, IXL
	.global z80op_RL_IYH
z80op_RL_IYH:
	UOP8_r RL, IYH
	.global z80op_RL_IYL
z80op_RL_IYL:
	UOP8_r RL, IYL
	.global z80op_RL_IHLI
z80op_RL_IHLI:
	UOP8_IrrI RL, HL
	.global z80op_RL_IIX_dI
z80op_RL_IIX_dI:
	UOP8_Irr_dI RL, IX
	.global z80op_RL_IIY_dI
z80op_RL_IIY_dI:
	UOP8_Irr_dI RL, IY

	.global z80op_RLC_A
z80op_RLC_A:
	UOP8_r RLC, A
	.global z80op_RLC_B
z80op_RLC_B:
	UOP8_r RLC, B
	.global z80op_RLC_C
z80op_RLC_C:
	UOP8_r RLC, C
	.global z80op_RLC_D
z80op_RLC_D:
	UOP8_r RLC, D
	.global z80op_RLC_E
z80op_RLC_E:
	UOP8_r RLC, E
	.global z80op_RLC_H
z80op_RLC_H:
	UOP8_r RLC, H
	.global z80op_RLC_L
z80op_RLC_L:
	UOP8_r RLC, L
	.global z80op_RLC_IXH
z80op_RLC_IXH:
	UOP8_r RLC, IXH
	.global z80op_RLC_IXL
z80op_RLC_IXL:
	UOP8_r RLC, IXL
	.global z80op_RLC_IYH
z80op_RLC_IYH:
	UOP8_r RLC, IYH
	.global z80op_RLC_IYL
z80op_RLC_IYL:
	UOP8_r RLC, IYL
	.global z80op_RLC_IHLI
z80op_RLC_IHLI:
	UOP8_IrrI RLC, HL
	.global z80op_RLC_IIX_dI
z80op_RLC_IIX_dI:
	UOP8_Irr_dI RLC, IX
	.global z80op_RLC_IIY_dI
z80op_RLC_IIY_dI:
	UOP8_Irr_dI RLC, IY

	.global z80op_RR_A
z80op_RR_A:
	UOP8_r RR, A
	.global z80op_RR_B
z80op_RR_B:
	UOP8_r RR, B
	.global z80op_RR_C
z80op_RR_C:
	UOP8_r RR, C
	.global z80op_RR_D
z80op_RR_D:
	UOP8_r RR, D
	.global z80op_RR_E
z80op_RR_E:
	UOP8_r RR, E
	.global z80op_RR_H
z80op_RR_H:
	UOP8_r RR, H
	.global z80op_RR_L
z80op_RR_L:
	UOP8_r RR, L
	.global z80op_RR_IXH
z80op_RR_IXH:
	UOP8_r RR, IXH
	.global z80op_RR_IXL
z80op_RR_IXL:
	UOP8_r RR, IXL
	.global z80op_RR_IYH
z80op_RR_IYH:
	UOP8_r RR, IYH
	.global z80op_RR_IYL
z80op_RR_IYL:
	UOP8_r RR, IYL
	.global z80op_RR_IHLI
z80op_RR_IHLI:
	UOP8_IrrI RR, HL
	.global z80op_RR_IIX_dI
z80op_RR_IIX_dI:
	UOP8_Irr_dI RR, IX
	.global z80op_RR_IIY_dI
z80op_RR_IIY_dI:
	UOP8_Irr_dI RR, IY

	.global z80op_RRC_A
z80op_RRC_A:
	UOP8_r RRC, A
	.global z80op_RRC_B
z80op_RRC_B:
	UOP8_r RRC, B
	.global z80op_RRC_C
z80op_RRC_C:
	UOP8_r RRC, C
	.global z80op_RRC_D
z80op_RRC_D:
	UOP8_r RRC, D
	.global z80op_RRC_E
z80op_RRC_E:
	UOP8_r RRC, E
	.global z80op_RRC_H
z80op_RRC_H:
	UOP8_r RRC, H
	.global z80op_RRC_L
z80op_RRC_L:
	UOP8_r RRC, L
	.global z80op_RRC_IXH
z80op_RRC_IXH:
	UOP8_r RRC, IXH
	.global z80op_RRC_IXL
z80op_RRC_IXL:
	UOP8_r RRC, IXL
	.global z80op_RRC_IYH
z80op_RRC_IYH:
	UOP8_r RRC, IYH
	.global z80op_RRC_IYL
z80op_RRC_IYL:
	UOP8_r RRC, IYL
	.global z80op_RRC_IHLI
z80op_RRC_IHLI:
	UOP8_IrrI RRC, HL
	.global z80op_RRC_IIX_dI
z80op_RRC_IIX_dI:
	UOP8_Irr_dI RRC, IX
	.global z80op_RRC_IIY_dI
z80op_RRC_IIY_dI:
	UOP8_Irr_dI RRC, IY

	.global z80op_SLA_A
z80op_SLA_A:
	UOP8_r SLA, A
	.global z80op_SLA_B
z80op_SLA_B:
	UOP8_r SLA, B
	.global z80op_SLA_C
z80op_SLA_C:
	UOP8_r SLA, C
	.global z80op_SLA_D
z80op_SLA_D:
	UOP8_r SLA, D
	.global z80op_SLA_E
z80op_SLA_E:
	UOP8_r SLA, E
	.global z80op_SLA_H
z80op_SLA_H:
	UOP8_r SLA, H
	.global z80op_SLA_L
z80op_SLA_L:
	UOP8_r SLA, L
	.global z80op_SLA_IXH
z80op_SLA_IXH:
	UOP8_r SLA, IXH
	.global z80op_SLA_IXL
z80op_SLA_IXL:
	UOP8_r SLA, IXL
	.global z80op_SLA_IYH
z80op_SLA_IYH:
	UOP8_r SLA, IYH
	.global z80op_SLA_IYL
z80op_SLA_IYL:
	UOP8_r SLA, IYL
	.global z80op_SLA_IHLI
z80op_SLA_IHLI:
	UOP8_IrrI SLA, HL
	.global z80op_SLA_IIX_dI
z80op_SLA_IIX_dI:
	UOP8_Irr_dI SLA, IX
	.global z80op_SLA_IIY_dI
z80op_SLA_IIY_dI:
	UOP8_Irr_dI SLA, IY

	.global z80op_SRA_A
z80op_SRA_A:
	UOP8_r SRA, A
	.global z80op_SRA_B
z80op_SRA_B:
	UOP8_r SRA, B
	.global z80op_SRA_C
z80op_SRA_C:
	UOP8_r SRA, C
	.global z80op_SRA_D
z80op_SRA_D:
	UOP8_r SRA, D
	.global z80op_SRA_E
z80op_SRA_E:
	UOP8_r SRA, E
	.global z80op_SRA_H
z80op_SRA_H:
	UOP8_r SRA, H
	.global z80op_SRA_L
z80op_SRA_L:
	UOP8_r SRA, L
	.global z80op_SRA_IXH
z80op_SRA_IXH:
	UOP8_r SRA, IXH
	.global z80op_SRA_IXL
z80op_SRA_IXL:
	UOP8_r SRA, IXL
	.global z80op_SRA_IYH
z80op_SRA_IYH:
	UOP8_r SRA, IYH
	.global z80op_SRA_IYL
z80op_SRA_IYL:
	UOP8_r SRA, IYL
	.global z80op_SRA_IHLI
z80op_SRA_IHLI:
	UOP8_IrrI SRA, HL
	.global z80op_SRA_IIX_dI
z80op_SRA_IIX_dI:
	UOP8_Irr_dI SRA, IX
	.global z80op_SRA_IIY_dI
z80op_SRA_IIY_dI:
	UOP8_Irr_dI SRA, IY

	.global z80op_SRL_A
z80op_SRL_A:
	UOP8_r SRL, A
	.global z80op_SRL_B
z80op_SRL_B:
	UOP8_r SRL, B
	.global z80op_SRL_C
z80op_SRL_C:
	UOP8_r SRL, C
	.global z80op_SRL_D
z80op_SRL_D:
	UOP8_r SRL, D
	.global z80op_SRL_E
z80op_SRL_E:
	UOP8_r SRL, E
	.global z80op_SRL_H
z80op_SRL_H:
	UOP8_r SRL, H
	.global z80op_SRL_L
z80op_SRL_L:
	UOP8_r SRL, L
	.global z80op_SRL_IXH
z80op_SRL_IXH:
	UOP8_r SRL, IXH
	.global z80op_SRL_IXL
z80op_SRL_IXL:
	UOP8_r SRL, IXL
	.global z80op_SRL_IYH
z80op_SRL_IYH:
	UOP8_r SRL, IYH
	.global z80op_SRL_IYL
z80op_SRL_IYL:
	UOP8_r SRL, IYL
	.global z80op_SRL_IHLI
z80op_SRL_IHLI:
	UOP8_IrrI SRL, HL
	.global z80op_SRL_IIX_dI
z80op_SRL_IIX_dI:
	UOP8_Irr_dI SRL, IX
	.global z80op_SRL_IIY_dI
z80op_SRL_IIY_dI:
	UOP8_Irr_dI SRL, IY

;****************************************************************************
;	Jump Group
;****************************************************************************

#macro JP_lm
	xsll %r15, 8			; lm
	or %r14, %r15
	xld.h [%r12+PC], %r14		; PC
	ret
#endm

;;#macro JP_cc_lm $1
;;	xbtst [%r12+F], $1
;;	xjreq $$1
;;	;
;;	xsll %r15, 8			; lm
;;	or %r14, %r15
;;	;
;;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 7
;;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;;	xsub %r10, %r10, 7
;;	xld.w [%r12+CYCLE], %r10
;;$$1:
;;	ret
;;#endm
;; * Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;; - "JP cc"͏/sɂ炸ǉTCNłB
;;   ܂ŊԈ+7TCNĂ܂Ă̂C܂B
#macro JP_cc_lm $1
	xbtst [%r12+F], $1
	xjreq $$1
	;
	xsll %r15, 8			; lm
	or %r14, %r15
	;
	xld.h [%r12+PC], %r14		; PC
$$1:
	ret
#endm

;;#macro JP_Ncc_lm $1
;;	xbtst [%r12+F], $1
;;	xjrne $$1
;;	;
;;	xsll %r15, 8			; lm
;;	or %r14, %r15
;;	;
;;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 7
;;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;;	xsub %r10, %r10, 7
;;	xld.w [%r12+CYCLE], %r10
;;$$1:
;;	ret
;;#endm
;; * Tue Jan 11 19:49:00 JST 2005 Naoyuki Sawa
;; - "JP cc"͏/sɂ炸ǉTCNłB
;;   ܂ŊԈ+7TCNĂ܂Ă̂C܂B
#macro JP_Ncc_lm $1
	xbtst [%r12+F], $1
	xjrne $$1
	;
	xsll %r15, 8			; lm
	or %r14, %r15
	;
	xld.h [%r12+PC], %r14		; PC
$$1:
	ret
#endm

#macro JR_e
	xld.uh %r10, [%r12+PC]		; PC+e
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	xld.h [%r12+PC], %r14		; PC
	ret
#endm

#macro JR_c_e $1
	xbtst [%r12+F], $1
	xjreq $$1
	;
	xld.uh %r10, [%r12+PC]		; PC+e
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
	xld.h [%r12+PC], %r14		; PC *anti-interlock*
	xsub %r10, %r10, 5
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

#macro JR_Nc_e $1
	xbtst [%r12+F], $1
	xjrne $$1
	;
	xld.uh %r10, [%r12+PC]		; PC+e
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
	xld.h [%r12+PC], %r14		; PC *anti-interlock*
	xsub %r10, %r10, 5
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

#macro DJNZ_e
	xld.ub %r10, [%r12+B]		; --B
	xsub %r10, %r10, 1
	xld.b [%r12+B], %r10
	xjreq $$1
	;
	xld.uh %r10, [%r12+PC]		; PC+e
	ld.b %r14, %r14			; *anti-interlock*
	add %r14, %r10
	;
	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 5
	xld.h [%r12+PC], %r14		; PC *anti-interlock*
	xsub %r10, %r10, 5
	xld.w [%r12+CYCLE], %r10
$$1:
	ret
#endm

;****************************************************************************

	.global z80op_JP_lm
z80op_JP_lm:
	JP_lm
	.global z80op_JP_Z_lm
z80op_JP_Z_lm:
	JP_cc_lm 6
	.global z80op_JP_NZ_lm
z80op_JP_NZ_lm:
	JP_Ncc_lm 6
	.global z80op_JP_C_lm
z80op_JP_C_lm:
	JP_cc_lm 0
	.global z80op_JP_NC_lm
z80op_JP_NC_lm:
	JP_Ncc_lm 0
	.global z80op_JP_PE_lm
z80op_JP_PE_lm:
	JP_cc_lm 2
	.global z80op_JP_PO_lm
z80op_JP_PO_lm:
	JP_Ncc_lm 2
	.global z80op_JP_M_lm
z80op_JP_M_lm:
	JP_cc_lm 7
	.global z80op_JP_P_lm
z80op_JP_P_lm:
	JP_Ncc_lm 7

	.global z80op_JR_e
z80op_JR_e:
	JR_e
	.global z80op_JR_Z_e
z80op_JR_Z_e:
	JR_c_e 6
	.global z80op_JR_NZ_e
z80op_JR_NZ_e:
	JR_Nc_e 6
	.global z80op_JR_C_e
z80op_JR_C_e:
	JR_c_e 0
	.global z80op_JR_NC_e
z80op_JR_NC_e:
	JR_Nc_e 0

	.global z80op_DJNZ_e
z80op_DJNZ_e:
	DJNZ_e

;****************************************************************************
;	Call and Return Group
;****************************************************************************

#macro CALL_lm
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	xsll %r2, 8
	or %r2, %r14
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.w %r10, [%r0+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+SP], %r1		; SP
	;
	xld.h [%r0+PC], %r2		; PC
	;
	popn %r2
	ret
#endm

#macro CALL_c_lm $1
	xbtst [%r12+F], $1
	xjreq $$1
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	xsll %r2, 8
	or %r2, %r14
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.w %r10, [%r0+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+SP], %r1		; SP
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 7
	xld.h [%r0+PC], %r2		; PC *anti-interlock*
	xsub %r10, %r10, 7
	xld.w [%r0+CYCLE], %r10
	;
	popn %r2
$$1:
	ret
#endm

#macro CALL_Nc_lm $1
	xbtst [%r12+F], $1
	xjrne $$1
	;
	pushn %r2
	;
	ld.w %r2, %r15			; lm
	xsll %r2, 8
	or %r2, %r14
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.w %r10, [%r0+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+SP], %r1		; SP
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 7
	xld.h [%r0+PC], %r2		; PC *anti-interlock*
	xsub %r10, %r10, 7
	xld.w [%r0+CYCLE], %r10
	;
	popn %r2
$$1:
	ret
#endm

#macro RET
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+(PC+0)], %r10	; LO(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+(PC+1)], %r10	; HI(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.h [%r0+SP], %r1		; SP
	;
	popn %r1
	ret
#endm

#macro RET_c $1
	xbtst [%r12+F], $1
	xjreq $$1
	;
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+(PC+0)], %r10	; LO(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+(PC+1)], %r10	; HI(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 6
	xld.h [%r0+SP], %r1		; SP *anti-interlock*
	xsub %r10, %r10, 6
	xld.w [%r0+CYCLE], %r10
	;
	popn %r1
$$1:
	ret
#endm

#macro RET_Nc $1
	xbtst [%r12+F], $1
	xjrne $$1
	;
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+(PC+0)], %r10	; LO(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+(PC+1)], %r10	; HI(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= 6
	xld.h [%r0+SP], %r1		; SP *anti-interlock*
	xsub %r10, %r10, 6
	xld.w [%r0+CYCLE], %r10
	;
	popn %r1
$$1:
	ret
#endm

#macro RETI
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+(PC+0)], %r10	; LO(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+(PC+1)], %r10	; HI(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.h [%r0+SP], %r1		; SP
	;
	xcall.d z80_check_pending	; {EIRETI}̖ߕтRETIŕۗINTv󂯕t܂
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

#macro RETN
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	xld.b [%r0+(PC+0)], %r10	; LO(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.w %r10, [%r0+READ]
	ld.uh %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	xld.b [%r0+(PC+1)], %r10	; HI(PC)
	xadd %r1, %r1, 1		; SP++
	;
	xld.ub %r10, [%r0+IFF2]		; IFF1 = IFF2
	xld.h [%r0+SP], %r1		; SP *anti-interlock*
	xld.b [%r0+IFF1], %r10
	;
	xcall.d z80_check_pending	; IFF101֕ω\̂ŕۗINTv
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret
#endm

#macro RST_n $1
	pushn %r1
	;
	xld.uh %r1, [%r12+SP]		; SP
	;
	xld.w %r10, [%r12+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r12+(PC+1)]	; HI(PC)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	xld.w %r10, [%r0+WRITE]
	xsub %r1, %r1, 1		; SP--
	ld.uh %r13, %r1
	xld.ub %r14, [%r0+(PC+0)]	; LO(PC)
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.h [%r0+SP], %r1		; SP
	;
	xld.w %r10, $1			; PC
	xld.h [%r0+PC], %r10
	;
	popn %r1
	ret
#endm

;****************************************************************************

	.global z80op_CALL_lm
z80op_CALL_lm:
	CALL_lm
	.global z80op_CALL_Z_lm
z80op_CALL_Z_lm:
	CALL_c_lm 6
	.global z80op_CALL_NZ_lm
z80op_CALL_NZ_lm:
	CALL_Nc_lm 6
	.global z80op_CALL_C_lm
z80op_CALL_C_lm:
	CALL_c_lm 0
	.global z80op_CALL_NC_lm
z80op_CALL_NC_lm:
	CALL_Nc_lm 0
	.global z80op_CALL_PE_lm
z80op_CALL_PE_lm:
	CALL_c_lm 2
	.global z80op_CALL_PO_lm
z80op_CALL_PO_lm:
	CALL_Nc_lm 2
	.global z80op_CALL_M_lm
z80op_CALL_M_lm:
	CALL_c_lm 7
	.global z80op_CALL_P_lm
z80op_CALL_P_lm:
	CALL_Nc_lm 7

	.global z80op_RET
z80op_RET:
	RET
	.global z80op_RET_Z
z80op_RET_Z:
	RET_c 6
	.global z80op_RET_NZ
z80op_RET_NZ:
	RET_Nc 6
	.global z80op_RET_C
z80op_RET_C:
	RET_c 0
	.global z80op_RET_NC
z80op_RET_NC:
	RET_Nc 0
	.global z80op_RET_PE
z80op_RET_PE:
	RET_c 2
	.global z80op_RET_PO
z80op_RET_PO:
	RET_Nc 2
	.global z80op_RET_M
z80op_RET_M:
	RET_c 7
	.global z80op_RET_P
z80op_RET_P:
	RET_Nc 7

	.global z80op_RETI
z80op_RETI:
	RETI
	.global z80op_RETN
z80op_RETN:
	RETN

	.global z80op_RST_00H
z80op_RST_00H:
	RST_n 0x00
	.global z80op_RST_08H
z80op_RST_08H:
	RST_n 0x08
	.global z80op_RST_10H
z80op_RST_10H:
	RST_n 0x10
	.global z80op_RST_18H
z80op_RST_18H:
	RST_n 0x18
	.global z80op_RST_20H
z80op_RST_20H:
	RST_n 0x20
	.global z80op_RST_28H
z80op_RST_28H:
	RST_n 0x28
	.global z80op_RST_30H
z80op_RST_30H:
	RST_n 0x30
	.global z80op_RST_38H
z80op_RST_38H:
	RST_n 0x38

;****************************************************************************
;
;****************************************************************************

#endif /*Z80_ASM*/
