/*	
 *	clipredu.c
 *
 *	k`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Thu Dec 12 14:33:38 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/
/* WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B */
void render_reduced_printf(RENDER* r, int x, int y, int c, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	vsprintf(_def_vbuff, fmt, ap);
	va_end(ap);
	render_reduced_string(r, x, y, _def_vbuff, c);
}

/****************************************************************************
 *	
 ****************************************************************************/
#ifndef PIECE
  static   void render_reduced_buf(RENDER* r, int y, const unsigned char* buf, int c);
#else /*PIECE*/
/*static*/ void render_reduced_buf(RENDER* r, int y, const unsigned char* buf, int c);
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
void render_reduced_string(RENDER* r, int x, int y, const char* _str, int c) {
	unsigned char buf[((DISP_X*2)+7)>>3];
	const unsigned char *str, *adrs;
	int line, x2, i, code, font;
	const int len = (((((r->right)-(r->left))*2)-1)>>3)+1;
	if(len < 1) { return; } /* r->left >= r->right */
	if(len > sizeof buf) { DIE(); }
	pceFontSetType(0);
	for(;;) {
		for(line = 0; line < 10; line++) {
			if((y >= r->top) && (y < r->bottom)) {
				memset(buf, 0, len);
				str = _str;
				x2  = (x - r->left) * 2;
				for(;;) {
					i = (x2>>3);
					code = *str++;
					if(!ismbblead(code)) {
						if((code == '\0') || (code == '\n')) { break; }
						adrs = pceFontGetAdrs(code);
						adrs += line;
						font = *adrs;						/* 01234xxx */
						font <<= (16-(x2&7));					/* 01234xxx xxxxxxxx xxxxxxxx >> (x2&7) */
						x2 += 5;
					} else {
						if((*str == '\0') || (*str == '\n')) { break; }		/* S΍ */
						code = ((code<<8)|(*str++));
						adrs = pceFontGetAdrs(code);
						adrs += ((line>>1)*3);
						if(!(line&1)) {
							font = ( adrs[0]    <<4) | (adrs[1]>>4);	/* xxxx0123 456789oo */
						} else {
							font = ((adrs[1]&15)<<8) | (adrs[2]   );	/* xxxx0123 456789oo */
						}
						font <<= (12-(x2&7));					/* 01234567 89ooxxxx xxxxxxxx >> (x2&7) */
						x2 += 10;
					}
					while(font <<= 8) {
						if((unsigned)i < (unsigned)len) { buf[i] |= (font>>24); }
						i++;
					}
				}
				render_reduced_buf(r, y, buf, c);
			}
			y++;
		}
		if(!(_str = strchr(_str, '\n'))) { break; }
		     _str++;           /*'\n'*/
	}
}
/*--------------------------------------------------------------------------*/
static const unsigned char TBL_render_reduced_buf[4/*Fg*/][4/*Bg*/] __attribute__((unused))/*asmubNQ*/ = {
	{0<<0|0<<2|0<<4|0<<6,1<<0|0<<2|0<<4|0<<6,2<<0|1<<2|0<<4|0<<6,3<<0|2<<2|1<<4|0<<6},
	{0<<0|1<<2|1<<4|1<<6,1<<0|1<<2|1<<4|1<<6,2<<0|1<<2|1<<4|1<<6,3<<0|2<<2|1<<4|1<<6},
	{0<<0|1<<2|2<<4|2<<6,1<<0|2<<2|2<<4|2<<6,2<<0|2<<2|2<<4|2<<6,3<<0|2<<2|2<<4|2<<6},
	{0<<0|1<<2|2<<4|3<<6,1<<0|2<<2|3<<4|3<<6,2<<0|3<<2|3<<4|3<<6,3<<0|3<<2|3<<4|3<<6}};
#ifndef PIECE
static void render_reduced_buf(RENDER* r, int y, const unsigned char* buf, int c) {
	int i, v, n;
	const unsigned char* const pTBL = TBL_render_reduced_buf[c];
	            SURFACE* const s    = r->surface;
	      unsigned char*       p    = &s->vbuff[s->w * y];
	      unsigned char* const pend = p +  r->right;
	                                  p += r->left;
	i = v = n = 0;
	do {
		if(--i < 0) { i = 3; v = ((*buf++)<<24); }
		n += (v<0); v <<= 1;		/* n = +               */
		n += (v<0);			/* n = ++E            */
		*p = (pTBL[*p] >> (n*2)) & 3;
		n  = (v<0); v <<= 1;		/* n =       E = ̍ */
	} while(++p != pend);
}
#else /*PIECE*/
asm("
		.code
		.align		1
render_reduced_buf:
		;// %r12 := r
		;// %r13 := y
		;// %r14 := buf
		;// %f15 := c
		sla		%r15, 2				;// %r15      := c*4
		ext		TBL_render_reduced_buf@ah
		ext		TBL_render_reduced_buf@al
		add		%r15, %r15			;// %r15      := pTBL  = &TBL_render_reduced_buf[c]
		ld.w		%r4, [%r12]+			;// %r4       := s     = r->surface
		ld.w		%r5, [%r4]+			;// %r5[15:0] := w     = s->w
		ld.w		%r4, [%r4]			;// %r4       := p     = s->vbuff
		mlt.h		%r5, %r13			;// %alr      :=         w * y
		ld.w		%r5, %alr			;// %r5       :=         w * y
		add		%r4, %r5			;// %r4       := p    += w * y
		ld.w		%r5, %r4			;// %r5       := pend  = p
		 ld.h		%r6, [%r12]			;// %r6       :=         r->left
		xld.h		%r7, [%r12+4]			;// %r7       :=         r->right				*anti-interlock*
		add		%r4, %r6			;// %r4       := p    += r->left
		add		%r5, %r7			;// %r5       := pend += r->right
		ld.w		%r6, 0				;// %r6       := i     = 0
		ld.w		%r7, 0				;// %r7       := v     = 0
		ld.w		%r12, 0				;// %r12      := n     = 0
		;// %r4  := p
		;// %r5  := pend
		;// %r6  := i
		;// %r7  := v
		;// %r12 := n
		;// %r14 := buf
		;// %r15 := pTBL
render_reduced_buf_DO:						;// do {
		ld.ub		%r13, [%r4]			;//   %r13            :=       *p
	;//	add		%r13, %r15			;//   %r13            := &pTBL[*p]	
		sub		%r6, 1				;//   %r6             := i--			
		jrge.d		5				;//   if(i>=0)					
		 add		%r13, %r15			;//   %r13            := &pTBL[*p]			*delay*
		 ld.w		%r6, 3				;//     %r6           := i     = 3
		 ld.ub		%r7, [%r14]+			;//     %r7           := v     = *buf++
		 rr		%r7, 8				;//     %r7           := v   <<= 24
		add		%r7, %r7			;//   %psr(C)         :=         (v<0), %r7      := v <<= 1
		adc		%r12, %r8			;//   %r12      (0~2) := n    += (v<0)
		rl		%r7, 1				;//   %r7 [7:0] (0~1) :=         (v<0), %r7[31:8]:= v <<= 1
		add		%r12, %r7			;//   %r12[7:0] (0~3) := n    += (v<0)
		ld.ub		%r13, [%r13]			;//   %r13            :=  pTBL[*p]
		add		%r12, %r12			;//   %r12[7:0] (0~6) :=              (n*2)			*anti-interlock*
		sra		%r13, %r12			;//   %r13            :=  pTBL[*p] >> (n*2)			sra%r12[4:0]QƂB%r12[31:5]͕slŗǂB
		and		%r13, 3				;//   %r13            := (pTBL[*p] >> (n*2)) & 3
		ld.b		[%r4]+, %r13			;//   *p++            := (pTBL[*p] >> (n*2)) & 3
		ld.ub		%r12, %r7			;//   %r12      (0~1) := n     = (v<0)
	;//	xor		%r7, %r12			;//   %r7             := v		
		cmp		%r4, %r5			;// } while(p != pend)				
		jrne.d		render_reduced_buf_DO		;//						
		xor		%r7, %r12			;//   %r7             := v				*delay*
		ret
");
#endif/*PIECE*/

