/*	
 *	clipm65.h
 *
 *	P/ECE MOS6502 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 07 12:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_M65_H__
#define __CLIP_M65_H__

/****************************************************************************
 *
 ****************************************************************************/

/* M6502_ASMV{`ǂݍ݂܂B
 * M6502_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipm65a.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define M6502_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef M6502_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef M6502_ASM
#undef M6502_TRACE
#endif /*M6502_ASM*/ 

#ifdef M6502_TRACE
#define M6502TRACE	TRACE
#else /*M6502_TRACE*/
#define M6502TRACE	1 ? ((void)0) : TRACE
#endif /*M6502_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _M6502 M6502;

/*
 *	M6502RAO֐̌^`
 */
typedef unsigned char M6502READPROC (M6502* m6502, unsigned short addr);
typedef          void M6502WRITEPROC(M6502* m6502, unsigned short addr, unsigned char data);

/*
 *	M6502RA
 */
/*typedef*/ struct _M6502 {
	/*===== WX^ =====*/
	unsigned char a;		/* + 0, 1 */
	unsigned char x;		/* + 1, 1 */
	unsigned char y;		/* + 2, 1 */
	unsigned char resv1[1];		/* + 3, 1 */
	unsigned short pc;		/* + 4, 2 */
	unsigned char sp;		/* + 6, 1 */
	unsigned char psr;		/* + 7, 1 */
	/*=====  =====*/
	int cycle;			/* + 8, 4 */
	unsigned char wait;		/* +12, 1 */
	unsigned char resv2[3];		/* +13, 3 */
	/*===== O֐ =====*/
	M6502READPROC* read;		/* +16, 4 */
	M6502WRITEPROC* write;		/* +20, 4 */
} /*M6502*/;				/* =24    */

/*
 *	CXgNV֐錾
 */
typedef                  void M6502OPPROC (M6502* m6502, unsigned char code, unsigned short arg);
#define M6502FN_(OP, FN) void m6502op_##FN(M6502* m6502, unsigned char code, unsigned short arg);	/* 錾p */
#include "m6502/list.h" /* [m6502.xls]List!C6 */
M6502FN_("ERR_IMPLIED", ERR_IMPLIED)
#undef  M6502FN_
#define M6502FN_(    FN) void m6502op_##FN(M6502* m6502, unsigned char code, unsigned short arg)	/* `p */

/*
 *	IyR[h}bvEj[jbNe[u
 */
typedef struct _M6502OP {
	M6502OPPROC* proc;	/* + 0, 4 */
	unsigned char mode;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 m6502_op_name_table[]̕ւ̃ItZbgł */
} M6502OP;			/* = 8    */
#define M6502OP_(CODE, PROC, ADDR_MODE, FUNC_TYPE, CYCLE, NAME)	{ m6502op_##PROC##_##FUNC_TYPE, M6502_##ADDR_MODE, CYCLE, 0x##NAME },
extern const M6502OP m6502_op_table[256/*opcode*/];
extern const char m6502_op_name_table[];	/* j[jbNe[u */

/***** M6502OP.mode *****/
/*==== bytes=1 ====*/
#define M6502_IMPLIED		 0
#define M6502_ACCUMULATOR	 1
/*==== bytes=2 ====*/
#define M6502_IMMEDIATE		 2
#define M6502_RELATIVE		 3
#define M6502_ZEROPAGE		 4
#define M6502_ZEROPAGE_X	 5
#define M6502_ZEROPAGE_Y	 6
#define M6502_INDIRECT_X	 7
#define M6502_INDIRECT_Y	 8
/*==== bytes=3 ====*/
#define M6502_ABSOLUTE		 9
#define M6502_ABSOLUTE_X	10
#define M6502_ABSOLUTE_Y	11
#define M6502_INDIRECT		12

/****************************************************************************
 *	֐
 ****************************************************************************/

/* M6502Zbgɐݒ肳AM6502RÃCREAD/WRITE̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char m6502_internal_read (M6502* m6502, unsigned short addr);
         void m6502_internal_write(M6502* m6502, unsigned short addr, unsigned char data);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* M6502Zbg܂B
 * [in]
 *	m6502		M6502\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 * [note]
 *	* read,writeNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	M6502\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	M6502\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 */
void m6502_reset(M6502* m6502, M6502READPROC* read, M6502WRITEPROC* write);

/* M6502s܂B
 * [in]
 *	m6502		M6502\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂WAITԂɂȂ܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAm6502->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇAm6502->cycle=-5 ƂȂ܂B
 */
void m6502_run(M6502* m6502, int cycle);

/* }XN\荞݃NGXg𔭍s܂B
 * [in]
 *	m6502		M6502\́B
 * [note]
 *	* 荞݂֎~ĂA荞݃NGXg͖܂B
 *	  荞݃NGXg͕ۗ܂B
 */
void m6502_int(M6502* m6502);

/* BRK߂s܂B
 * [in]
 *	m6502		M6502\́B
 * [note]
 *	* gpłB
 *	  AvP[VvO͌ĂяoȂŉB
 */
void m6502_brk(M6502* m6502);

/* }XNs荞݃NGXg𔭍s܂B
 * [in]
 *	m6502		M6502\́B
 */
void m6502_nmi(M6502* m6502);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	m6502		M6502\́B
 */
void m6502_dump(M6502* m6502);

#ifdef PIECE
/* M6502s܂B(X^bNؑցE)
 * [in]
 *	m6502		M6502\́B
 *	cycle		sTCNB
 * [note]
 *	* m6502_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- m6502_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  m6502_run2()̓X^bN0x1000ɈڂAm6502_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAm6502_run2()̎gpɂ͏܂B
 *	  Em6502_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Em6502_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Em6502_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAm6502_run2()̎gpɂ͏[ȒӂKvłB
 *	  m6502_run()gꍇɊrׂāAm6502_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void m6502_run2(M6502* m6502, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_M65_H__*/
