/*	
 *	clipio.c
 *
 *	S1C33 Family CRpCpbP[W io.lib ֐u܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Nov 25 20:37:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Nov 30 08:06:00 JST 2002 Naoyuki Sawa
 *	- stderr_open()/close()/write()ǉB
 *	* Wed Dec 11 12:30:00 JST 2002 Naoyuki Sawa
 *	- LbVpoϐ(cache_sct/len/ptr)ƁALbVV[N֐(io_seek())ǉB
 *	  Afread()ĂяoŃZN^ωȂꍇ́ApceFileReadSct()g킸LbVg܂B
 *	  ̉ǂɂAfgetc()fgets()̂悤ȍׂȒPʂœǂݍ݂sA2{ȏ㑬Ȃ܂B
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- stderr_open()̓AvP[V疾IɌĂԂ悤ɂ̂ŁA(clippce.cQ)
 *	  stderr_open()Ă΂ꂽꍇ͏ɏo̓j^̐ڑ҂悤ɕύX܂B
 *	* Wed Jun 26 20:03:00 JST 2005 Naoyuki Sawa
 *	- stderr_open()̕svpceLCDDispStop()Ăяo폜܂B
 *	* Tue Dec 13 04:35:00 JST 2005 Naoyuki Sawa
 *	- Wo͂ւ݂̏AWG[o͂ƓlɁAWG[o̓j^֏o͂悤ɕύX܂B
 *	  ܂ł́AWo(stdout)ւ݂̏́AG[IƂĂ܂B
 *	  ̕ύXɂAfprintf(stderr, fmt, ...)łȂAprintf(fmt, ...)j^ł悤ɂȂ܂B
 *	* Sun Jan 15 04:02:00 JST 2005 Naoyuki Sawa
 *	- ungetc()ɂāAEOFw肳ꂽAG[ƂĈAEOFԂǉ܂B
 *	  ܂ł́AEOFw肳ꂽꍇɂAG[ƂɁAXg[֖߂sĂ܂B
 *	* Tue Oct 30 00:38:57 JST 2012 Naoyuki Sawa
 *	- fileno(),isatty()ǉ܂B錾́Aclippce.h ɂ܂B
 *	* Tue Oct 30 22:43:07 JST 2012 Naoyuki Sawa
 *	- isatty()̐R[h(͂Ȃ)Ȃ悤AύX܂B
 *	* Sat Mar 23 17:43:37 JST 2013 Naoyuki Sawa
 *	- stat(),fstat()ǉ܂B錾́Ainclude/sys/stat.h ɂ܂B
 *	* Sun Mar 09 14:07:14 JST 2014 Naoyuki Sawa
 *	- stdin_read()ǉ܂B
 *	  ̋@\ǉɔAtool/dstderr ɂ@\ǉs܂B
 *	  ڍׂ́Atool/dstderr/dstderr.c ̓̃RgQƂĂB
 *	* Mon Mar 10 17:00:24 JST 2014 Naoyuki Sawa
 *	- puts()so͂ĂȂoOC܂B
 *	- getchar,getc,putchar,putc}NA֐폜܂B
 *	  /clip/include/stdio.h QƂĂB
 *	* Thu Mar 13 01:48:55 JST 2014 Naoyuki Sawa
 *	- ڑ̃bZ[W͂̎זɂȂ鎖L邽ߍ폜܂B
 *	- tool/dstderr/dstdpipe 쐬܂B
 *	  ܂ł dstderr Ɠ̋@\A_łB
 *	  L[{[hȊO̓͂󂯕t̂ŁAt@C̗݂AvOP/ECE̒ppCvƂĂ삵܂B
 *	  ́Adstderr  dstdpipe gp悤ɂĂB
 *	* Thu Aug 07 23:44:53 JST 2014 Naoyuki Sawa
 *	- fcloseall()ǉ܂B
 */
#include "clip.h"

/* 2002/11/26݂̎ł́Å֐G[errnoݒ肵܂B
 *   errnoăG[𔻒fĂvÓAȂ\܂B
 * TODO:errnoݒ肷悤CB
 */

/****************************************************************************
 *	֐vg^Cv
 ****************************************************************************/

/*  wS5U1C33000C Manual (S1C33 Family CRpCpbP[W) (Ver.4)x(S5U1C33000C_J.pdf)
 * p.97 8.2.1 o͊֐(io.lib) \8.2.1.1 o͊֐ꗗ ̕тƓԂłB
 * eX̊֐ARgAEgčsĂB
 */
//FILE* fopen(const char* filename, const char* mode) { DIE(); return 0; }
//FILE* freopen(const char* filename, const char* mode, FILE* stream) { DIE(); return 0; }
//int fclose(FILE* stream) { DIE(); return 0; }
//int fflush(FILE* stream) { DIE(); return 0; }
//int fseek(FILE* stream, long offset, int origin) { DIE(); return 0; }
//long ftell(FILE* stream) { DIE(); return 0; }
//void rewind(FILE* stream) { DIE(); }
//int fgetpos(FILE* stream, fpos_t* pos) { DIE(); return 0; }
//int fsetpos(FILE* stream, const fpos_t* pos) { DIE(); return 0; }
//size_t fread(void* buffer, size_t size, size_t count, FILE* stream) { DIE(); return 0; }
//size_t fwrite(const void* buffer, size_t size, size_t count, FILE* stream) { DIE(); return 0; }
//int fgetc(FILE* stream) { DIE(); return 0; }
//int getc(FILE* stream) { DIE(); return 0; }
//int getchar() { DIE(); return 0; }
//int ungetc(int c, FILE* stream) { DIE(); return 0; }
//char* fgets(char* string, int n, FILE* stream) { DIE(); return 0; }
//char* gets(char* buffer) { DIE(); return 0; }
//int fputc(int c, FILE* stream) { DIE(); return 0; }
//int putc(int c, FILE* stream) { DIE(); return 0; }
//int putchar(int c) { DIE(); return 0; }
//int fputs(const char* string, FILE* stream) { DIE(); return 0; }
//int puts(const char* string) { DIE(); return 0; }
//int remove(const char* filename) { DIE(); return 0; }
int rename(const char* oldname, const char* newname) { DIE(); return 0; }
void setbuf(FILE* stream, char* buffer) { DIE(); }
int setvbuf(FILE* stream, char* buffer, int mode, size_t size) { DIE(); return 0; }
FILE* tmpfile() { DIE(); return 0; }
char* tmpnam(char* string) { DIE(); return 0; }
//int feof(FILE* stream) { DIE(); return 0; }
//int ferror(FILE* stream) { DIE(); return 0; }
//void clearerr(FILE* stream) { DIE(); }
//void perror(const char* string) { DIE(); }
int fscanf(FILE* stream, const char* format, ...) { DIE(); return 0; }
int scanf(const char* format, ...) { DIE(); return 0; }
//int sscanf(char* buffer, const char* format, ...); -> io.lib(̂܂܎gp)
//int fprintf(FILE* stream, const char* format, ...) { DIE(); return 0; }
//int printf(const char* format, ...) { DIE(); return 0; }
//int sprintf(char* buffer, const char* format, ...); -> P/ECE Kernel(pcesprintf) -> 2003/05/20 clipprnt.c
//int vfprintf(FILE* stream, const char* format, va_list argptr) { DIE(); return 0; }
//int vprintf(const char* format, va_list argptr) { DIE(); return 0; }
//int vsprintf(char* buffer, const char* format, va_list argptr); -> P/ECE Kernel(pcevsprintf) -> 2003/05/20 clipprnt.c

/****************************************************************************
 *	[JϐE֐
 ****************************************************************************/

#define MAX_IO		4		/* ɊJőt@C */
#define IO_SIG		((unsigned short)(('I'<<0)|('O'<<8)))	/* ->IO.sig */
#define IO_EOF		(1 << 0)	/* -> IO.flags */
#define IO_ERROR	(1 << 1)	/* -> IO.flags */
typedef struct _IO {
	unsigned short sig;		/* 0:/IO_SIG:gp */
	unsigned short flags;		/* IO_EOF,IO_ERROȒgݍ킹 */
	int pos;			/* ̓ǂݍ/݈ʒu */
	FILEACC fa;			/* t@CANZX\ */
	/*{{LbVpoϐ:io_seek()ɂčXV*/
	int cache_sct;			/* ŌɃANZXZN^(-1:LbV) */
	int cache_len;			/* ̃ZN^̗LoCg */
	const void* cache_ptr;		/* ̃ZN^̐擪AhX */
	/*}}LbVpoϐ:io_seek()ɂčXV*/
} IO;
static IO ios[MAX_IO];			/* t@CI/O\̃obt@ */

/* ꎞobt@ƂāAVXepzʂ𗘗pB
 * VXepzʂ128x88=11KB̂ŁAɎgp̈悪dȂȂ悤蓖Ă܂B
 */
#define sctbuf (&_def_vbuff[        0])	/* 0`BLOCKSIZE(=4KB) : fwrite()pZN^obt@ */
#define strbuf (&_def_vbuff[BLOCKSIZE])	/* BLOCKSIZE`Ō܂: vsprintfpobt@ */

/* _~[̕Wo͗pAhX`B
 * AhXɂĂȂƁAio_file()ŃG[oOɃAhXG[ŗ̂ŒӁB
 */
#define FILE_STDIN	(FILE*)(- 4)	/* _~[Bio_file()ŃG[B */
#define FILE_STDOUT	(FILE*)(- 8)	/* _~[Bio_file()ŃG[Bfwrite()̂ݓʏ */
#define FILE_STDERR	(FILE*)(-12)	/* _~[Bio_file()ŃG[Bfwrite()̂ݓʏ */

static IO*
io_file(FILE* stream)
{
	IO* io = (IO*)stream;

	/* t@CJĂ邱ƂmF܂B */
	if(io->sig != IO_SIG) DIE();

	return io;
}

static IO*
io_open(IO* io, const char* filename, const char* mode)
{
	/* ܂NAĂ܂B */
	memset(io, 0, sizeof(IO));

	/* t@CJ܂B */
	switch(*mode) { /* ꕶڂŔ */
	case 'r':
		if(pceFileOpen(&io->fa, filename, FOMD_RD) != 0) return NULL;
		break;
	case 'w':
		if(pceFileOpen(&io->fa, filename, FOMD_WR) != 0) return NULL;
		break;
	default:
		return NULL;
	}

	/* ̃Gggpł邱Ƃ}[N܂B */
	io->sig = IO_SIG;

	/* LbV𖳌Ă܂B */
	io->cache_sct = -1;

	return io;
}

static int
io_seek(IO* io, int sct)
{
	/* OƈႤZN^ȂALoCgƃZN^AhX擾ALbV܂B */
	if(sct != io->cache_sct) {
		io->cache_sct = sct;
		io->cache_len = pceFileReadSct(&io->fa, NULL, sct, BLOCKSIZE);
		io->cache_ptr = io->fa.aptr;
	}

	return io->cache_len; /* pceFileReadSct()̖݊߂lƂāALoCgԂ܂ */
}

/****************************************************************************
 *	O[oϐE֐
 ****************************************************************************/

FILE* stdin = FILE_STDIN;
FILE* stdout = FILE_STDOUT;
FILE* stderr = FILE_STDERR;

FILE*
fopen(const char* filename, const char* mode)
{
	IO* io;
	int i;

	/* t@CI/O\̃obt@A󂫃GgT܂B */
	for(io = ios, i = 0; i < MAX_IO; i++, io++) {
		if(!io->sig) break; /* 󂫃GgH */
	}
	if(i == MAX_IO) return NULL;

	/* t@CJ܂B */
	return (FILE*)io_open(io, filename, mode);
}

FILE*
freopen(const char* filename, const char* mode, FILE* stream)
{
	IO* io = io_file(stream);

	/* ܂B */
	pceFileClose(&io->fa);

	/* t@CJ܂B */
	return (FILE*)io_open(io, filename, mode); /* ̒ŃLbV܂ */
}

int
fclose(FILE* stream)
{
	IO* io = io_file(stream);

	/* t@C܂B */
	pceFileClose(&io->fa);

	/* ̃Gg󂫂ł邱Ƃ}[N܂B */
	memset(io, 0, sizeof(IO));

	return 0;
}

int
fcloseall()
{
	/* ͈ȉ̂悤Ɏׂł邪A
	 * int fcloseall(){
	 *   int i,result=0;
	 *   for(i=0;i<MAX_IO;i++){
	 *     if(ios[i].sig==IO_SIG){
	 *       if(fclose((FILE*)&ios[i])){result=EOF;}
	 *     }
	 *   }
	 *   return 0;
	 * }
	 * P/ECEŃt@C鏈͉Ȃ_~[Ȃ̂ŊȗłB
	 * {W[̃t@CI/O\̃obt@NA邾ŗǂB */
	memset(ios, 0, sizeof ios);
	/* fcloseall()̖߂lɂ́A̗V܂B
	 * GNU C: SẴt@Cɕꂽꍇ(0)ԂBG[̏ꍇAEOFԂB
	 * Visual C++: N[YXg[̑ԂBG[ƁAEOFԂB
	 * {W[̎́AGNU C̗Vɏ]܂B */
	return 0;
}

int
fflush(FILE* stream)
{
	return 0; /* ܂ */
}

int
fseek(FILE* stream, long offset, int origin)
{
	IO* io = io_file(stream);

	clearerr(stream); /* EOFEG[CWP[^NA܂ */

	switch(origin) {
	case SEEK_SET:
		io->pos = offset;
		break;
	case SEEK_CUR:
		io->pos += offset;
		break;
	case SEEK_END:
		io->pos = io->fa.fsize - offset;
		break;
	default:
		return -1;
	}

	return 0;
}

long
ftell(FILE* stream)
{
	IO* io = io_file(stream);

	return io->pos;
}

void
rewind(FILE* stream)
{
	fseek(stream, 0, SEEK_SET); /* fseek()̒EOFEG[CWP[^NA܂ */
}

int
fgetpos(FILE* stream, fpos_t* pos)
{
	*pos = ftell(stream);

	return 0;
}

int
fsetpos(FILE* stream, const fpos_t* pos)
{
	return fseek(stream, *pos, SEEK_SET); /* fseek()̒EOFEG[CWP[^NA܂ */
}

size_t
fread(void* buffer, size_t size, size_t count, FILE* stream)
{
	if(stream == FILE_STDIN) { /* W͓͂ʏŁAWG[o̓j^͂܂B */
		/* * ɂ́Ȁ͌łB
		 *   {́AW͂ɕcĂƂĂAsize̔{ɖȂubN͓ǂݍł͂ȂB
		 *   AP/ECEvOł͂قsize=1ŎgpƎv̂ŁǍ͎ɂ͂ȂȂƔfÂ܂܂ɂ邱ƂɂB
		 */
		return stdin_read(buffer, size * count) / size;
	} else {
		IO* io = io_file(stream);
		char* p = (char*)buffer;
		int len = size * count;
		int ofs, sct, sof, sln;

		/* * ݂̎ł́AŌ̍ڂr[ɓǂݍ߂ꍇA̕obt@ɓǂݍł܂܂B
		 *   Ⴆ΁A150oCg̃t@C̑O100oCgobt@ɓǂݍޏꍇA{fread()Ȃ΁F
		 *	char buf[100];
		 *	retval = fread(buf, 100, 2, fp); -> ߂l1ŁAbuf[0`99]܂łɃf[^ǂݍ܂܂
		 *   ƂȂ܂A̎ł́F
		 *	char buf[100];
		 *	retval = fread(buf, 100, 2, fp); -> ߂l1łAbuf[0`149]܂Ńf[^ǂݍ܂܂
		 *   ƂȂAobt@I[o[NĂ܂܂B
		 *   ̂悤Ȋ댯ȌĂяo邱Ƃ͂܂ȂƎv܂AÔ߂ӂB
		 */

		ofs = 0;
		while(ofs < len) {
			/* ZN^̃tbVAhX擾܂B */
			sct = (io->pos + ofs) / BLOCKSIZE;			/* sct = ݂̓ǂݍ݃ItZbg܂ރZN^ԍ                         */
			sln = io_seek(io, sct);					/* sln = ̃ZN^̃f[^TCY(ŏIZN^̂sln<=BLOCKSIZEɂȂ܂) */
			if(sln == 0) break;					/* ԂItZbg                                                   */

			/* ̃ZN^ǂݍރTCY肵܂B */
			sof = (io->pos + ofs) % BLOCKSIZE;			/* ZN^ItZbg                                                       */
			sln -= sof;						/* ZN^ItZbgȍ~ǂݍ݉\ȍőf[^TCY                 */
			if(sln > len - ofs) sln = len - ofs;			/* ǂݍ݉\ȍőf[^TCYcǂݍ݃TCYȏȂA؂l߂܂ */
			if(sln <= 0) break;					/* ԂItZbg߁A܂͓ǂݍ݃TCY0ȉw肳ꂽ(len<=0)    */

			/* ZN^obt@֓ǂݍ݂܂B */
			memcpy(p + ofs, io->cache_ptr + sof, sln);
			ofs += sln;
		}
		count = ofs / size;						/* Sɓǂݍ߂ڐ                                             */
		io->pos += count * size;					/* Sɓǂݍ߂ڂ̕At@C|C^݈̌ʒui߂܂ */
		if(count * size < len) io->flags |= IO_EOF;			/* Sɓǂݍ߂oCgAvTCY**AEOF}[N  */

		return count;							/* Sɓǂݍ߂ڐԂ܂ */
	}
}

size_t
fwrite(const void* buffer, size_t size, size_t count, FILE* stream)
{
	if((stream == FILE_STDOUT) || (stream == FILE_STDERR)) { /* Wo͂ƕWG[o͓͂ʏŁAWG[o̓j^֏o͂܂B */
		stderr_write(buffer, size * count);
		return count;
	} else {
#if 0
//		IO* io = io_file(stream);
//		char* p = (char*)buffer;
//		int len = size * count;
//		int ofs, sct, sof, sln;
//
//		/* * fread()ƓAŌ̍ڂ𒆓r[ɏł܂\܂BӂB */
//		/* * v1.18݂P/ECEJ[ĺApceFileOpen()Ɏw肳ꂽmode𖳎܂B
//		 *   FOMD_RDŊJt@Cɑ΂ĂpceFileWriteSct()ł܂AFOMD_WRŊJt@Cɑ΂ĂpceFileReadSct()ł܂B
//		 *   fwrite()֐ɓnt@CFOMD_WRŊJĂ͂łAL̓𗘗ppceFileReadSct()gĂ܂܂B
//		/* * ݏł́ALbVpoϐ(cache_sct/ptr/len)QƂAύX܂B */
//
//		ofs = 0;
//		while(ofs < len) {
//			/* ZN^̃tbVAhX擾܂B */
//			sct = (io->pos + ofs) / BLOCKSIZE;			/* sct = ݂̏݃ItZbg܂ރZN^ԍ                             */
//			sln = pceFileReadSct(&io->fa, sctbuf, sct, BLOCKSIZE);	/* ̃ZN^̑Sf[^擾܂B(ŏIZN^̂sln<=BLOCKSIZEɂȂ܂) */
//			if(sln == 0) break;					/* ԂItZbg                                                       */
//
//			/* ̃ZN^ɏރTCY肵܂B */
//			sof = (io->pos + ofs) % BLOCKSIZE;			/* ZN^ItZbg                                                       */
//			sln -= sof;						/* ZN^ItZbgȍ~ɏ݉\ȍőf[^TCY                   */
//			if(sln > len - ofs) sln = len - ofs;			/* ݉\ȍőf[^TCYc菑݃TCYȏȂA؂l߂܂ */
//			if(sln <= 0) break;					/* ԂItZbg߁A܂͏݃TCY0ȉw肳ꂽ(len<=0)    */
//
//			/* ZN^̑Sf[^̈ꕔ܂B */
//			memcpy(sctbuf + sof, p + ofs, sln);
//			ofs += sln;
//
//			/* ZN^̑Sf[^tbVɏ߂܂B */
//			pceFileWriteSct(&io->fa, sctbuf, sct, BLOCKSIZE);	/* ŏIZN^̖ߕ́ApceFileWriteSct()ɂĐ؂l߂܂  */
//										/* Ŏs邱Ƃ͂肦Ȃ͂Ȃ̂ŁAG[`FbN͍s܂ */
//		}
//		count = ofs / size;						/* Sɏ߂ڐ                                             */
//		io->pos += count * size;					/* Sɏ߂ڂ̕At@C|C^݈̌ʒui߂܂ */
//		if(count * size < len) io->flags |= IO_EOF;			/* Sɏ߂oCgAvTCY**AEOF}[N  */
//
//		return count;							/* Sɏ߂ڐԂ܂ */
#else
		/* tbV̒ʏt@Cւׂ̍ȏ݂́AtbVɂ߂鋰ꂪ̂ŁÂ݂ƂG[ƂĂ܂B */
		DIE(); return 0;
#endif
	}
}

int
fgetc(FILE* stream)
{
	char c;

	if(fread(&c, 1, 1, stream) != 1) return -1;

	return c & 0xff; /* '\x80'`'\xff'𕄍gĂ͂Ȃ */
}

//{{2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
//int
//getc(FILE* stream)
//{
//	return fgetc(stream);
//}
//
//int
//getchar()
//{
//	return getc(stdin);
//}
//}}2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB

int
ungetc(int c, FILE* stream)
{
	IO* io = io_file(stream);

	/* EOFԂƂAXg[֖߂s킸ɁAG[EOFԂ܂B
	 * ȊOȂ΁AXg[֖߂sA߂R[ĥ܂ܕԂ܂B
	 */
	if(c != EOF) {

		io->pos--; /* KȎI{ungetc()Ƃ͂񂺂Ⴂ܂ */

		/* ĂяoA'\x80'`'\xff'𕄍gāA'\xff80'`'\xffff'nꍇłA
		 * ungetc()̖߂ĺA'\x80'`'\xff'ƂȂ܂B
		 * (ۂɂ́A8bit\xffǂɂ炸Aɏ8bitNA܂B)
		 * ̎dĺAVisual C++ 6.0 SP6́A^CCũ\[X̎ɍ킹܂B
		 */
		return c & 0xff; /* '\x80'`'\xff'𕄍gĂ͂Ȃ */
	}

	return c;
}

char*
fgets(char* string, int n, FILE* stream)
{
	char* p = string;

	if(n <= 0) return NULL;

	while(--n) { /* n-1܂łǂݍ܂Ȃ̂ŁAvfNg */
		if(fread(p, 1, 1, stream) != 1) {
			if(p == string) return NULL; /* ꕶǂ߂Ȃ */
			break;
		}
		if(*p++ == '\n') break; /* s\0ɒuȂ̂ŁAKp++s */
	}
	*p = '\0';

	return string;
}

char*
gets(char* buffer)
{
	char* p = buffer;

	for(;;) {
		if(fread(p, 1, 1, stdin) != 1) {
			if(p == buffer) return NULL; /* ꕶǂ߂Ȃ */
			break;
		}
		if(*p == '\n') break; /* s\0ɒûŁA\nȂ++sȂ */
		p++;
	}
	*p = '\0';

	return buffer;
}

int
fputc(int c, FILE* stream)
{
	if(fwrite(&c, 1, 1, stream) != 1) return -1;

	return c & 0xff; /* '\x80'`'\xff'𕄍gĂ͂Ȃ */
}

//{{2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
//int
//putc(int c, FILE* stream)
//{
//	return fputc(c, stream);
//}
//
//int
//putchar(int c)
//{
//	return putc(c, stdout);
//}
//}}2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB

int
fputs(const char* string, FILE* stream)
{
	const char* p = string;

	while(*p != '\0') {
		if(fwrite(p++, 1, 1, stream) != 1) return -1;
	}

	return 0; /* ͏񂾃oCgł͂Ȃ0Ԃ */
}

int
puts(const char* string)
{
	const char* p = string;

	while(*p != '\0') {
		if(fwrite(p++, 1, 1, stdout) != 1) return -1;
	}
	if(fwrite("\n", 1, 1, stdout) != 1) return -1; /* s */

	return 0; /* ͏񂾃oCgł͂Ȃ0Ԃ */
}

int
remove(const char* filename)
{
	if(pceFileDelete(filename) != 0) return -1;

	return 0;
}

int
feof(FILE* stream)
{
	IO* io = io_file(stream);

	return io->flags & IO_EOF;
}

int
ferror(FILE* stream)
{
	IO* io = io_file(stream);

	return io->flags & IO_ERROR;
}

void
clearerr(FILE* stream)
{
	IO* io = io_file(stream);

	io->flags = 0;
}

void
perror(const char* string)
{
	if(string && *string) { /* 󕶎񎞂": "\Ȃ */
		fprintf(stderr, "%s", string);
		fprintf(stderr, ": ");
	}
	fprintf(stderr, "%s", strerror(errno));
	fprintf(stderr, "\n"); /* vs */
}

int
fprintf(FILE* stream, const char* format, ...)
{
	int retval;
	va_list argptr;

	va_start(argptr, format);
	retval = vfprintf(stream, format, argptr);
	va_end(argptr);

	return retval;
}

int
printf(const char* format, ...)
{
	int retval;
	va_list argptr;

	va_start(argptr, format);
	retval = vprintf(format, argptr);
	va_end(argptr);

	return retval;
}

int
vfprintf(FILE* stream, const char* format, va_list argptr)
{
	return fwrite(strbuf, 1, vsprintf(strbuf, format, argptr), stream);
}

int
vprintf(const char* format, va_list argptr)
{
	return vfprintf(stdout, format, argptr);
}

/****************************************************************************
 *	WbCu̕⏕ -> clippce.h
 ****************************************************************************/

int
fileno(FILE* stream)
{
	IO* io;
	int i;

	/* w肳ꂽXg[AW,Wo,WG[o͂Ȃ΁Ãt@CLqqԂ܂B */
	if(stream == FILE_STDIN ) return STDIN_FILENO;	/* W */
	if(stream == FILE_STDOUT) return STDOUT_FILENO;	/* Wo */
	if(stream == FILE_STDERR) return STDERR_FILENO;	/* WG[o */

	/* w肳ꂽXg[AW,Wo,WG[o͂łȂ΁At@CI/O\̃obt@āc */
	for(io = ios, i = 0; i < MAX_IO; i++, io++) {
		/* ̃t@CI/O\̂AI[vĂc */
		if(io->sig == IO_SIG) {
			/* ̃t@CI/O\̂Aw肳ꂽXg[Ɉvc */
			if(io == (IO*)stream) {
				/* ̃t@CI/O\̂ɑΉAt@CLqqԂ܂B
				 * t@CI/O\̂ɑΉt@CLqq́A(WG[o+1) ̒ln܂܂B
				 */
				return (STDERR_FILENO + 1) + i;
			}
		}
	}

	/* w肳ꂽXg[ALȃXg[łȂ΁A-1 Ԃ܂B */
	return -1;
}

int
isatty(int fd)
{
	/* w肳ꂽt@CLqqA[QƂt@CLqqȂ΁A1 Ԃ܂B
	 * łȂ΁A0 Ԃ܂B
	 */
//{{2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
//	return (fd == STDIN_FILENO ) ||	/* W */
//	       (fd == STDOUT_FILENO) ||	/* Wo */
//	       (fd == STDERR_FILENO);	/* WG[o */
//2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
	return (unsigned)fd <= STDERR_FILENO;	/* W,Wo,WG[o */
//}}2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
}

/****************************************************************************
 *	WbCu̕⏕ -> include/sys/stat.h
 ****************************************************************************/

int
stat(const char* path, struct stat* buf)
{
	FILEACC fa;
	if(pceFileOpen(&fa, path, FOMD_RD) == 0) {
		memset(buf, 0, sizeof(struct stat));
		buf->st_mode  = S_IFREG|S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH;
		buf->st_nlink = 1;
		buf->st_size  = fa.fsize;
		pceFileClose(&fa);
		return 0;
	}
	errno = ENOENT; /* No such file or directory */
	return -1;
}

int
fstat(int fd, struct stat* buf)
{
	if((unsigned)fd <= STDERR_FILENO) { /* STDIN_FILENO or STDOUT_FILENO or STDERR_FILENO */
		memset(buf, 0, sizeof(struct stat));
		buf->st_mode  = S_IFCHR;
		buf->st_nlink = 1;
		return 0;
	}
	if((unsigned)(fd - (STDERR_FILENO + 1)) < MAX_IO) {
		IO* io = &ios[fd - (STDERR_FILENO + 1)];
		if(io->sig == IO_SIG) {
			memset(buf, 0, sizeof(struct stat));
			buf->st_mode  = S_IFREG|S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH;
			buf->st_nlink = 1;
			buf->st_size  = io->fa.fsize;
			return 0;
		}
	}
	errno = EBADF; /* Bad file number */
	return -1;
}

/****************************************************************************
 *	WG[o,W
 ****************************************************************************/

/* UCS_RXDONEUCS_TXDONÉApceUSBCOMGetStat()ĂԂƃNAĂ܂̂ŁA~ς邽߂̕ϐKvłB
 * ʂ̖ړIŌĂяopceUSBCOMGetStat()ɂāAUCS_RXDONEUCS_TXDONENAĂ܂̂邽߁A
 * pceUSBCOMGetStat()ĂяoтɁAucsϐUCS_RX*UCS_TX*~ς悤ɂB
 */
static int ucs;	/* UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~ */

//void stderr_open() {
//	USBCOMINFO uci = { "stderr" };
//	/* WG[o͂J܂B */
//	pceUSBCOMSetup(&uci);
//	/* a{^ĂAWG[o̓j^̐ڑ҂܂B */
//	if(pcePadGetDirect() & PAD_B) {
//		unsigned char* old_vbuff;
//		pceLCDDispStop();
//		old_vbuff = pceLCDSetBuffer(_def_vbuff);
//		pceLCDDispStart();
//		pceFontSetType(0x80);
//		pceFontSetTxColor(3);
//		pceFontSetBkColor(0);
//		pceFontSetPos(0, (DISP_Y - 10 * 5) / 2);
//		/*             OPQRSTUVWXOPQ */
//		pceFontPutStr(" +----------------------+\n"
//		              " |WG[o̓j^|\n"
//		              " | ڑ҂Ă܂c |\n"
//		              " |(`{^ŃLZ)|\n"
//		              " +----------------------+");
//		pceLCDTrans();
//		while(pcePadGetDirect() & PAD_A) { /* J҂*/ }
//		for(;;) {
//			if(pceUSBCOMGetStat() & UCS_PCSTAT) break; /* ڑ */
//			if(pcePadGetDirect() & PAD_A) break; /* LZ */
//		}
//		while(pcePadGetDirect() & PAD_A) { /* J҂*/ }
//		pceLCDSetBuffer(old_vbuff);
//		stderr_write("ڑ\n", 9); /* WG[o̓j^ɕ\ */
//	}
//}
//2003/11/22 stderr_open()̓AvP[V疾IɌĂԂ悤ɂ̂ŁA
//             stderr_open()Ă΂ꂽꍇ͏ɏo̓j^̐ڑ҂悤ɕύX܂B
void stderr_open(int timeout) {
	USBCOMINFO uci = { "stderr" };
	unsigned char* old_vbuff;
	int T0, T1;
	/* WG[o͂J܂B */
	pceUSBCOMSetup(&uci);
	/* WG[o̓j^̐ڑ҂B */
	//pceLCDDispStop(); {{2005/06/26 Naoyuki Sawa svȂ̂ō폜܂}}
	old_vbuff = pceLCDSetBuffer(_def_vbuff);
	pceLCDDispStart();
	pceFontSetType(0x80);
	pceFontSetTxColor(3);
	pceFontSetBkColor(0);
	pceFontSetPos(0, (DISP_Y - 10 * 5) / 2);
	/*             OPQRSTUVWXOPQ */
	pceFontPutStr(" +----------------------+\n"
	              " |WG[o̓j^|\n"
	              " | ڑ҂Ă܂c |\n"
	              " |(`{^ŃLZ)|\n"
	              " +----------------------+");
	pceLCDTrans();
	while(pcePadGetDirect() & PAD_A) { /* J҂*/ }
	T0 = pceTimerGetCount();
	for(;;) {
		if(pceUSBCOMGetStat() & UCS_PCSTAT) break; /* ڑ */
		if(pcePadGetDirect() & PAD_A) break; /* LZ */
		if(timeout >= 0) {
			T1 = timeout * 1000 - (pceTimerGetCount() - T0);
			if(T1 <= 0) break; /* ^CAEg */
			pceFontSetPos((DISP_X - 5 * 9) / 2, DISP_Y - 16);
			/*             012345678 */
			pceFontPrintf("%3db", (T1 + 999) / 1000);
			pceLCDTrans();
		}
	}
	while(pcePadGetDirect() & PAD_A) { /* J҂*/ }
	pceLCDSetBuffer(old_vbuff);
//	stderr_write("ڑ\n", 9); /* WG[o̓j^ɕ\(LZ/dev/nul) */	{{2014/03/13폜:ڑ̃bZ[W͂̎זɂȂ鎖L邽ߍ폜܂B}}
	/* W͂́A̎Mv𔭍s܂B */
	stdin_read(NULL, 0);
}

void stderr_close() {
	USBCOMINFO uci = { "" };
	/* WG[o͂܂B
	 * * PpceUSBCOMStop()Ă񂾂ł́AUSBCOMؒfł܂B
	 *   PCƂ̐ڑmĂꍇApceUSBCOMStop()͐ؒfsȂłB
	 *   ܂AVOl`NA܂B(ȏABIOS 1.18ŊmF)
	 * * ̖ɂ́ApceUSBCOMSetup()gUSBCOMؒf܂B
	 *   pceUSBCOMSetup()Ȃ΁APC̐ڑtONÂŁA
	 *   pceUSBCOMSetup()gāF
	 *	mystat(P/ECE̐ڑtO) -> 1
	 *	pcstat(PC̐ڑtO)    -> 0
	 *	VOl`                  -> ""
	 *   ƂĂA炽߂pceUSBCOMStop()ĂŁF
	 *	mystat(P/ECE̐ڑtO) -> 0
	 *   Ƃ܂B
	 */
	pceUSBCOMSetup(&uci);
	pceUSBCOMStop();
	ucs = 0;	/* ~ϕϐNA */
}

void stderr_write(const void* ptr, int len) {
	/* 0oCgőMv𔭍sƁA΂UCS_TXDONEȂ̂ŁA(usbcom.c: txsub() Q)
	 * 炩ߏOĂ܂B
	 */
	if(len <= 0) return;
	/* PCƂ̐ڑmĂc
	 * * PISTAT1łȂPCSTAT1ɂȂ܂B(usbcom.c: usbcom() case13: (USBCOM Open) Q)
	 *   PCSTAT1łPISTAT0ɖ߂܂B(usbcom.c: pceUSBCOMStop() Q)
	 *   ]āAPCSTAT1ȂPISTATK1łBPISTATKv͂܂B
	 */
	ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	/* UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~ */
	if(ucs & UCS_PCSTAT) {
		/* Mv𔭍s܂B */
		pceUSBCOMStartTx(ptr, len);
		ucs &= ~UCS_TXSTAT;	/* UCS_TX*NA */
		/* M܂ő҂܂B */
		for(;;) {
			ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	/* UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~ */
			if(!(ucs & UCS_PCSTAT)) { break; }	/* PCƂ̐ڑ؂ꂽ */
			if(  ucs & UCS_TXDONE ) { break; }	/* M */
		}
	}
}

int stdin_read(void* _buf, int bufsize) {
#define STDIN_RXSIZE (127/**/ + 1/*nul*/)
	static char*   rxbuf/*[STDIN_RXSIZE]*/;
	static char* keepbuf/*[STDIN_RXSIZE]*/;
	static int i_keepbuf;
	//
	char* buf = _buf;
	int i_buf = 0, c;
	/* PCƂ̐ڑmĂc
	 * * PISTAT1łȂPCSTAT1ɂȂ܂B(usbcom.c: usbcom() case13: (USBCOM Open) Q)
	 *   PCSTAT1łPISTAT0ɖ߂܂B(usbcom.c: pceUSBCOMStop() Q)
	 *   ]āAPCSTAT1ȂPISTATK1łBPISTATKv͂܂B
	 */
	ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	/* UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~ */
	if(ucs & UCS_PCSTAT) {
		/* ɎMobt@ƕێobt@mۂ܂B΁Astdin_read()Ă΂ȂΗ]ȃ܂B */
		if(!rxbuf) {
			rxbuf = calloc(2, STDIN_RXSIZE);
			if(!rxbuf) { DIE(); }	/* s */
			keepbuf = rxbuf + STDIN_RXSIZE;
		}
		/* ݃|C^A݃obt@̃oCgɒB܂Łc */
		while(i_buf < bufsize) {
			/* ێobt@̕A܂cĂc */
			if((c = keepbuf[i_keepbuf])) {
				/* ێobt@ǂݏoA݃obt@Ɋi[܂B */
				buf[i_buf++] = c;
				/* ێobt@̓ǂݏoʒui߂܂B */
				i_keepbuf++;
			/* ێobt@̕AcĂȂ΁c */
			} else {
				/* O̎MvĂȂ΁c */
				if(!(ucs & UCS_RXDONE)) { break; }	/* MvsȂ΁Ảŏ̎Mv𔭍sB */
				/* O̎MvĂc */
				ucs &= ~UCS_RXSTAT;	/* UCS_RX*NA */			/* ̉Ŏ̎Mv𔭍sB */
				/* Meێobt@ɕێ܂BMobt@́Ǎ̎MvsŔj󂳂邩łB */
				strcpy(keepbuf, rxbuf);
				/* ێobt@̓ǂݏoʒuA擪ɖ߂܂B */
				i_keepbuf = 0;
			}
		}
		/* MvsĂȂ΁c */
		if(!(ucs & (UCS_RXWAIT|UCS_RXING))) { /* Mҋ@,,M */
			/* ̂߂ɁAMobt@ւ̎Mv𔭍sĂB */
			pceUSBCOMStartRx(rxbuf, STDIN_RXSIZE - 1/*nul*/);
		}
	}
	/* ݃obt@Ɋi[oCgԂ܂B */
	return i_buf;
#undef  STDIN_RXSIZE
}

