/*	
 *	clipgpio.c
 *
 *	ėpI/O[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Wed Sep 11 00:35:50 JST 2013 Naoyuki Sawa
 *	- 1st[XB
 *	* Wed Sep 11 23:15:01 JST 2013 Naoyuki Sawa
 *	- ChatteringCanceller_Update()ASMA32byteߖ񂵂܂B
 */
#include "clip.h"

/****************************************************************************
 *	`^O
 ****************************************************************************/

/* \̂܂B
 * [in]
 *	pChatteringCanceller	\̂ւ̃|C^
 *	StableCount		`^O (0`4)
 */
void ChatteringCanceller_Init(ST_ChatteringCanceller* pChatteringCanceller, int StableCount) {
	if((unsigned)StableCount > ARRAY_SIZE(pChatteringCanceller->PortStatus)) { DIE(); }	/* `^O񐔂LȔ͈͂ł邱ƂmF */
	memset(pChatteringCanceller, 0, sizeof(ST_ChatteringCanceller));			/* \̂NA */
	pChatteringCanceller->StableCount = StableCount;					/* `^O񐔂i[ */
}

/* ԂXV܂B
 * [in]
 *	pChatteringCanceller	\̂ւ̃|C^
 *	PortStatus		̃|[g
 * [note]
 *	- msԊũ^C}荞݂ĂяoāAXVsƂz肵Ă܂B
 *	  ^C}荞݂gpɁAC[vĂяočXVsĂ\܂񂪁Amቺ邨ꂪ܂B
 */
#ifndef PIECE
void ChatteringCanceller_Update(ST_ChatteringCanceller* pChatteringCanceller, int PortStatus) {
	int UnstableBit, Tmp1, Tmp2, i;
	UnstableBit = 0;	/* ̃|[gԂƁA(1`ChatteringCanceller_StableCount)Õ|[gԂAłقȂrbgAɒoBȉAsrbgƏ̂ */
	Tmp1 = PortStatus;	/* (1`ChatteringCanceller_StableCount)Õ|[gԂA񕪂ÂÂփVtg邽߂́Aꎞϐ */
	for(i = 0; i < pChatteringCanceller->StableCount; i++) {
		Tmp2 = pChatteringCanceller->PortStatus[i];				/* (i+1)Õ|[gԂ擾 */
		       pChatteringCanceller->PortStatus[i] = Tmp1;			/* |[gԂA񕪂ÂÂփVtg */
		                                             Tmp1 = Tmp2;		/*  */
		                                    UnstableBit |= (Tmp2 ^ PortStatus);	/* srbg𒊏o */
	}
	Tmp1 = ( UnstableBit & pChatteringCanceller->StableStatus) |	/* srbg̕ɂĂ͑ÖԂC */
	       (~UnstableBit & PortStatus);				/* rbg̕ɂẴ͍|[gԂgݍ킹AVԂƂ */
	Tmp2 = (pChatteringCanceller->StableStatus ^ Tmp1);		/* ÖԂƁAVԂŁAGbW𒊏o */
	pChatteringCanceller->StableStatus = Tmp1;			/* VԂi[ */
	pChatteringCanceller->StableOnEdge  |= ( Tmp1 & Tmp2);		/* ԂOnGbW~ς */
	pChatteringCanceller->StableOffEdge |= (~Tmp1 & Tmp2);		/* ԂOffGbW~ς */
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		ChatteringCanceller_Update
ChatteringCanceller_Update:
		;// %r12 := pChatteringCanceller
		;// %r13 := PortStatus
		xadd		%r9, %r12, 12			;// %r9  :=                             &pChatteringCanceller->StableCount
		ld.w		%r4, [%r9]+			;// %r4  := i = StableCount, %r9 := p = &pChatteringCanceller->PortStatus[0]
	;//	ld.w		%r5, 0				;// %r5  := UnstableBit = 0	
		cmp		%r4, 0				;// if(i) {				
		jreq.d		ChatteringCanceller_Update_L20	;//   					
		ld.w		%r5, 0				;// %r5  := UnstableBit = 0									*delay*
		ld.w		%r6, %r13			;//   %r6  := Tmp1 = PortStatus
ChatteringCanceller_Update_L10:					;//   do {
		;// %r4  := i
		;// %r5  := UnstableBit
		;// %r6  := Tmp1
		;// %r9  := p
		;// %r12 := pChatteringCanceller
		;// %r13 := PortStatus
		ld.w		%r7, [%r9]			;//     %r7  := Tmp2 = *p
		ld.w		[%r9]+, %r6			;//                    *p++ = Tmp1
		ld.w		%r6, %r7			;//     %r6  :=               Tmp1 = Tmp2
		xor		%r7, %r13			;//     %r7  :=                     (Tmp2 ^ PortStatus)
	;//	or		%r5, %r7			;//     %r5  :=      UnstableBit |= (Tmp2 ^ PortStatus)	
		sub		%r4, 1				;//     %r4  := i--						
		jrne.d		ChatteringCanceller_Update_L10	;//   } while(i)						
		or		%r5, %r7			;//     %r5  :=      UnstableBit |= (Tmp2 ^ PortStatus)						*delay*
ChatteringCanceller_Update_L20:					;// }
		;// %r5  := UnstableBit
		;// %r12 := pChatteringCanceller
		;// %r13 := PortStatus
		ld.w		%r7, [%r12]			;// %r7  :=                        pChatteringCanceller->StableStatus
		not		%r6, %r5			;// %r6  :=                                                               ~UnstableBit			*anti-interlock*
		and		%r5, %r7			;// %r5  :=         (UnstableBit & pChatteringCanceller->StableStatus)
		and		%r6, %r13			;// %r6  :=                                                              (~UnstableBit & PortStatus)
		or		%r6, %r5			;// %r6  := Tmp1 := (UnstableBit & pChatteringCanceller->StableStatus) | (~UnstableBit & PortStatus)
		xor		%r7, %r6			;// %r7  := Tmp2 =                (pChatteringCanceller->StableStatus ^ Tmp1)
		ld.w		[%r12]+, %r6			;// pChatteringCanceller->StableStatus  = Tmp1
		not		%r4, %r6			;// %r4  :=                                                ~Tmp1
		ld.w		%r5, [%r12]			;// %r5  :=                               StableOnEdge  = pChatteringCanceller->StableOnEdge
		and		%r6, %r7			;// %r6  :=                                               ( Tmp1 & Tmp2)				*anti-interlock*
		or		%r5, %r6			;// %r5  :=                               StableOnEdge  | ( Tmp1 & Tmp2)
		ld.w		[%r12]+, %r5			;// pChatteringCanceller->StableOnEdge  = StableOnEdge  | ( Tmp1 & Tmp2)
		ld.w		%r5, [%r12]			;// %r5  :=                               StableOffEdge = pChatteringCanceller->StableOffEdge
		and		%r4, %r7			;// %r6  :=                                               (~Tmp1 & Tmp2)				*anti-interlock*
		or		%r5, %r4			;// %r5  :=                               StableOffEdge | (~Tmp1 & Tmp2)
		ld.w		[%r12], %r5			;// pChatteringCanceller->StableOffEdge = StableOnEdge  | (~Tmp1 & Tmp2)
		ret
");
#endif/*PIECE*/

/* Ԃ擾܂B
 * [in]
 *	pChatteringCanceller	\̂ւ̃|C^
 *	pOnEdge			ԂOnGbWi[ϐւ̃|C^  (NULL)
 *	pOffEdge		ԂOffGbWi[ϐւ̃|C^ (NULL)
 * [out]
 *	߂l			
 * [note]
 *	- ԂOnGbW,y,ԂOffGbWsvȂ΁ANULL|C^w肵ĂB
 *	- ԂOnGbW,y,ԂOffGbẂA~ςꂽlԂƂɒӂĂB
 *	  OChatteringCanceller_GetStatus()ĂяoɁAłGbWoꂽrbg"1"ɂȂ܂B
 *	  ]āÃrbgɑΉAOnGbWOffGbW̒lAƂ"1"ɂȂ邱ƂL蓾܂B
 */
int ChatteringCanceller_GetStatus(ST_ChatteringCanceller* pChatteringCanceller, int* pOnEdge/*NULL*/, int* pOffEdge/*NULL*/) {
	int Status, Dummy;
	if(!pOnEdge)  { pOnEdge  = &Dummy; }	/* ԂOnGbWvĂȂꍇ́A_~[ϐw */
	if(!pOffEdge) { pOffEdge = &Dummy; }	/* ԂOffGbWvĂȂꍇ́A_~[ϐw */
ENTER_CS;/* ChatteringCanceller_Update()^C}荞݂Ăяo邱Ƃz */
	Status    = pChatteringCanceller->StableStatus;		/* Ԃ擾 */
	*pOnEdge  = pChatteringCanceller->StableOnEdge;		/* ԂOnGbW擾 */
	            pChatteringCanceller->StableOnEdge  = 0;	/* ԂOnGbWNA */
	*pOffEdge = pChatteringCanceller->StableOffEdge;	/* ԂOffGbW擾 */
	            pChatteringCanceller->StableOffEdge = 0;	/* ԂOffGbWNA */
LEAVE_CS;/* ChatteringCanceller_Update()^C}荞݂Ăяo邱Ƃz */
	return Status;
}

/****************************************************************************
 *	
 ****************************************************************************/

//
//	
//	ST_ChatteringCanceller\1ŁA32|[g܂ŊǗł܂B
//	32|[g𒴂͂Ǘꍇ́AST_ChatteringCanceller\̂𕡐gpĂB
//	
//	̃|[gԂA(pChatteringCanceller->StableCount+1)AœԂłꍇɁAԂƌȂ܂B
//	ۂ̃`^OԂ́AAvP[VChatteringCanceller_Update()ĂяoԊuɈˑ܂B
//	K؂ȌĂяoԊúA1`10msłB(XCb`̉HȂ̂ŁA`^OpԂɂėv)
//	
//		                  ݸ   ݸ
//		                  |<--->|   |<--->|
//		PortStatus   0000 1010 1111 0101 0000 0000 0000 0000
//		StableStatus 0000 0000 0011 1111 1100 0000 0000 0000	StableCount=2ŏꍇ̗BPortStatus(2+1)AœɈԂƌȂB
//		OnEdge       0000 0000 0011 1111 1111 1111 1100 0000
//		OffEdge      0000 0000 0000 0000 0011 1111 1100 0000
//		             |||| |||| ||||              |
//		             ChatteringCanceller_Update()    ChatteringCanceller_GetStatus()
//	
//	@\́AP/ECEg[qɉOtXCb`ڑꍇ̂߂ɗpӂ̂łB
//	P/ECE{̂̃{^͂́A@\gpKv͂܂B
//	P/ECE{̂̃{^͂́A܂łǂpcePadGet(),,CLiPCupad_get()gpĂB
//	
//gp
//	
//	ST_ChatteringCanceller stChatteringCanceller;
//	void app_isr(void* context) {
//		ChatteringCanceller_Update(&stChatteringCanceller,~(	//_ː_ϊ
//			pP0_P0D<< 0|	//[ 7: 0] P0X	P06=g[q[6],P05=g[q[7],P04=g[q[8]
//			pP1_P1D<< 8|	//[15: 8] P1X	P14=g[q[1],P12=g[q[4]
//			pK5_K5D<<16|	//[23:16] K5X	K54=START,K53=SELECT				P/ECE{̂ݓ͂ý
//			pK6_K6D<<24));	//[31:24] K6X	K65=A,K64=B,K63=ݏ,K62=݉,K61=ݍK60	P/ECE{̂ݓ͂ý
//	}
//	void app_main() {
//		int Status, OnEdge, OffEdge, OnEdgeCount = 0, OffEdgeCount = 0;
//		ChatteringCanceller_Init(&stChatteringCanceller, 4);
//		timer_start(1/*ms*/, app_isr, NULL);
//		for(;;) {
//			schedule();
//			surface_clear(&surface, 0);
//			Status = ChatteringCanceller_GetStatus(&stChatteringCanceller, &OnEdge, &OffEdge);
//			if(OnEdge  &  (1<<(24+5)/*K65*/)) { OnEdgeCount++;  }
//			if(OffEdge &  (1<<(24+5)/*K65*/)) { OffEdgeCount++; }
//			render_printf(&render,0, 0,0,3, "K65 Status      : %d", (Status>>(24+5)/*K65*/)&1);
//			render_printf(&render,0,10,0,3, "K65 OnEdgeCount : %d", OnEdgeCount);
//			render_printf(&render,0,20,0,3, "K65 OffEdgeCount: %d", OffEdgeCount);
//		}
//	}

