/*
 *	clipevtm.c
 *
 *	Cxg^C}
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Jun 09 17:53:50 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/
/* Cxg^C}B
 * [in]
 *	nEvtTmrCh	Cxg^C}`l
 *	pData		eCxg^C}`l̃f[^ (Wait,Event,Wait,Event,c̕)
 *	onEvent		AvP[V`̃Cxg֐
 * [note]
 *	- {֐́AeCxg^C}`l̃f[^Rs[A|C^i[邱ƂɒӂB
 *	  AvP[V́A{֐ԂAeCxg^C}`l̃f[^ύXjĂ͂ȂB
 */
ST_EvtTmr* EvtTmr_Init(int nEvtTmrCh, const uint16_t* const* pData/*[nEvtTmrCh]*/, void (*onEvent)(int iEvtTmrCh, int iEvent)) {
	ST_EvtTmr* pEvtTmr;
	/* Cxg^C}\̂̃mۂB */
	pEvtTmr = malloc(sizeof(ST_EvtTmr) + (sizeof(ST_EvtTmrCh) * nEvtTmrCh));
	if(!pEvtTmr) { DIE(); } /* s */
	/* Cxg^C}\̂B */
	EvtTmr_InitStatic(pEvtTmr, nEvtTmrCh, pData, onEvent);
	/* Cxg^C}\̂̃ԂB */
	return pEvtTmr;
}
/*--------------------------------------------------------------------------*/
/* ÓIɊmۂgpāACxg^C}쐬܂B
 * [in]
 *	pEvtTmr		ÓIɊmۂ
 *	nEvtTmrCh	Cxg^C}`l
 *	pData		eCxg^C}`l̃f[^ (Wait,Event,Wait,Event,c̕)
 *	onEvent		AvP[V`̃Cxg֐
 * [note]
 *	- {֐́AeCxg^C}`l̃f[^Rs[A|C^i[邱ƂɒӂB
 *	  AvP[V́A{֐ԂAeCxg^C}`l̃f[^ύXjĂ͂ȂB
 * [gp]
 *	struct {
 *	  ST_EvtTmr   evtTmr;
 *	  ST_EvtTmrCh evtTmrCh[3];
 *	} stEvtTmr;
 *	EvtTmr_InitStatic(&stEvtTmr.evtTmr, 3, pData, onEvent);
 */
void EvtTmr_InitStatic(ST_EvtTmr* pEvtTmr, int nEvtTmrCh, const uint16_t* const* pData/*[nEvtTmrCh]*/, void (*onEvent)(int iEvtTmrCh, int iEvent)) {
	/* Cxg^C}\̂NAB */
	memset(pEvtTmr, 0, sizeof(ST_EvtTmr) + (sizeof(ST_EvtTmrCh) * nEvtTmrCh));
	/* Cxg^C}\̂ɁACxg^C}`l,eCxg^C}`l̃f[^,AvP[V`̃Cxg֐i[B */
	pEvtTmr->nEvtTmrCh = nEvtTmrCh;	/* Cxg^C}`l */
	pEvtTmr->pData     = pData;	/* eCxg^C}`l̃f[^ (Wait,Event,Wait,Event,c̕) */
	pEvtTmr->onEvent   = onEvent;	/* AvP[V`̃Cxg֐ */
}
/*--------------------------------------------------------------------------*/
/* Cxg^C}`lJnB
 * [in]
 *	pEvtTmr		Cxg^C}
 *	iEvtTmrCh	Cxg^C}`lԍ
 * [note]
 *	- Cxg^C}`l쒆ꍇAX^[gB
 */
void EvtTmr_Start(ST_EvtTmr* pEvtTmr, int iEvtTmrCh) {
	ST_EvtTmrCh* pEvtTmrCh;
	/* Cxg^C}`lԍł邱ƂmFB */
	if((unsigned)iEvtTmrCh >= (unsigned)pEvtTmr->nEvtTmrCh) { DIE(); }
	/* Cxg^C}`l擾B */
	pEvtTmrCh = &pEvtTmr->EvtTmrCh[iEvtTmrCh];
	/* Cxg^C}`lJnB */
	pEvtTmrCh->pData = pEvtTmr->pData[iEvtTmrCh];
	pEvtTmrCh->Wait  = *pEvtTmrCh->pData++;		//ŏ̃Cxg̑҂Ԃ擾B
}
/*--------------------------------------------------------------------------*/
/* Cxg^C}`lmɒ~B
 * [in]
 *	pEvtTmr		Cxg^C}
 *	iEvtTmrCh	Cxg^C}`lԍ
 * [out]
 *	߂l		Cxg^C}`l쒆ꍇACxg^C}`l~A0ȊOԂB
 *			Cxg^C}`l~ꍇAA0ԂB
 * [note]
 *	* uCxg^C}`lmɒ~ȌԂԂv悤ɂŔAȉ̂ƂłB
 *	- ۂ̃AvP[V̒ŁAL̂悤ȃp^[邱ƂɋCt܂:
 *	  <>
 *	    EvtTmr_Start(pEvtTmr,EvtTmrCh_xxx);
 *	    c
 *	    if(EvtTmr_Stat(pEvtTmr,EvtTmrCh_xxx)){//ѱĂĂȂ΁c
 *	        EvtTmr_Stop(pEvtTmr,EvtTmrCh_xxx);//~
 *	        {{ѱĎɍs͂𤂱ōs}}
 *	    }else{//ѱĂĂc
 *	        {{ѱĎɍšn𤂱ōs}}//<>ѱĂŌꍇŌA餓
 *	    }
 *	- uCxg^C}`lmɒ~ȌԂԂv̖߂l𗘗pƁAL̂悤ɏ܂:
 *	  <>
 *	    EvtTmr_Start(pEvtTmr,EvtTmrCh_xxx);
 *	    c
 *	    if(EvtTmr_Stop(pEvtTmr,EvtTmrCh_xxx)){//mɒ~顒~OѱĂĂȂ΁c
 *	        {{ѱĎɍs͂𤂱ōs}}
 *	    }else{//ѱĂĂc
 *	        {{ѱĎɍšn𤂱ōs}}//<>ѱĂŌꍇŌA餓
 *	    }
 */
int EvtTmr_Stop(ST_EvtTmr* pEvtTmr, int iEvtTmrCh) {
	int iResult;
	ST_EvtTmrCh* pEvtTmrCh;
	/* Cxg^C}`lԍł邱ƂmFB */
	if((unsigned)iEvtTmrCh >= (unsigned)pEvtTmr->nEvtTmrCh) { DIE(); }
	/* Cxg^C}`l擾B */
	pEvtTmrCh = &pEvtTmr->EvtTmrCh[iEvtTmrCh];
	/* Cxg^C}`l̏Ԃ擾B */
	iResult = (int)pEvtTmrCh->pData;
	/* Cxg^C}`lmɒ~B */
	pEvtTmrCh->pData = NULL;
//sv	pEvtTmrCh->Wait  = 0;
	/* Cxg^C}`l쒆Ȃ0ȊOA~Ȃ0ԂB */
	return iResult;
}
/*--------------------------------------------------------------------------*/
/* Cxg^C}`lSĒ~B
 * [in]
 *	pEvtTmr		Cxg^C}
 */
void EvtTmr_StopAll(ST_EvtTmr* pEvtTmr) {
	memset(pEvtTmr->EvtTmrCh, 0, sizeof(ST_EvtTmrCh) * pEvtTmr->nEvtTmrCh);
}
/*--------------------------------------------------------------------------*/
/* Cxg^C}`l̏Ԃ擾B
 * [in]
 *	pEvtTmr		Cxg^C}
 *	iEvtTmrCh	Cxg^C}`lԍ
 * [out]
 *	߂l		Cxg^C}`l쒆Ȃ0ȊOA~Ȃ0ԂB
 */
int EvtTmr_Stat(ST_EvtTmr* pEvtTmr, int iEvtTmrCh) {
	ST_EvtTmrCh* pEvtTmrCh;
	/* Cxg^C}`lԍł邱ƂmFB */
	if((unsigned)iEvtTmrCh >= (unsigned)pEvtTmr->nEvtTmrCh) { DIE(); }
	/* Cxg^C}`l擾B */
	pEvtTmrCh = &pEvtTmr->EvtTmrCh[iEvtTmrCh];
	/* Cxg^C}`l쒆Ȃ0ȊOA~Ȃ0ԂB */
	return (int)pEvtTmrCh->pData;
}
/*--------------------------------------------------------------------------*/
/* Cxg^C}̎sB
 * [in]
 *	pEvtTmr		Cxg^C}
 * [note]
 *	- AvP[V`̃Cxg֐̒ŁACӂ̃`l(g܂)ɑ΂āA
 *	  EvtTmr_Start(),y,EvtTmr_Stop()ĂяoƂASłB
 */
void EvtTmr_Exec(ST_EvtTmr* pEvtTmr) {
	int iEvtTmrCh, iEvent;
	ST_EvtTmrCh* pEvtTmrCh;
	/* eCxg^C}`lɂāc */
	for(iEvtTmrCh = 0; iEvtTmrCh < pEvtTmr->nEvtTmrCh; iEvtTmrCh++) {
		/* Cxg^C}`l擾B */
		pEvtTmrCh = &pEvtTmr->EvtTmrCh[iEvtTmrCh];
		/* Cxg^C}`l쒆łԁc */
		while(pEvtTmrCh->pData) {
			/* ҂Ԃ̎cL΁Â߂ɑ҂Ԃ̎c炷B */
			if(pEvtTmrCh->Wait) { pEvtTmrCh->Wait--; break; }	//܂
			/* Cxgԍ擾B */
			iEvent = *pEvtTmrCh->pData++;
			/* Cxgԍ'I'Ȃ΁c */
			if(iEvent == EvtTmr_Event_End) {
				/* Cxg^C}`l~B */
				EvtTmr_Stop(pEvtTmr, iEvtTmrCh);
			/* Cxgԍ'[v'Ȃ΁c */
			} else if(iEvent == EvtTmr_Event_Loop) {
				/* Cxg^C}`lX^[gB */
				EvtTmr_Start(pEvtTmr, iEvtTmrCh);
			/* Cxgԍ'ȊO'(=AvP[V`̒l)Ȃ΁c */
			} else {
			    //{{̏K{
				pEvtTmrCh->Wait = *pEvtTmrCh->pData++;		//̃Cxg̑҂Ԃ擾BonEvent()̒ŁAEvtTmr_Start(),,EvtTmr_Stop()Ă΂ꂽꍇ́AWait㏑B
				(*pEvtTmr->onEvent)(iEvtTmrCh, iEvent);		//̒EvtTmr_Start(),,EvtTmr_Stop()Ă΂āAWait,y,pDataω\邪ȀȂΈSłB
			    //}}̏K{
			}
		}
	}
}

/****************************************************************************
 *	Tv
 ****************************************************************************/

//	const uint16_t Data0[]={//#0ް
//	SEC(0),10, //Jnɤޔԍ(10)s
//	SEC(2),11, // 2b҂Ĥޔԍ(11)s
//	SEC(1),12, // 1b҂Ĥޔԍ(12)s
//	SEC(0),13, //̌シޔԍ(13)s
//	SEC(3),-1};// 3b҂Ĥ擪ٰ߂
//	const uint16_t Data1[]={//#1ް
//	SEC(9),20, // 9b҂Ĥޔԍ(20)s
//	SEC(0), 0};//̌シI
//	const uint16_t* const TBL_Data[2]={Data0,Data1};//eقް
//	void onEvent(int iEvtTmrCh,int iEvent){//عݒ`̲ď֐
//	  TRACE("%d:%d:%d\n",now/FPS,iEvtTmrCh,iEvent);}
//	void Test() {
//	  ST_EvtTmr* pEvtTmr=EvtTmr_Init(2,TBL_Data,onEvent);
//	  EvtTmr_Start(pEvtTmr,0);//#0Jn
//	  EvtTmr_Start(pEvtTmr,1);//#1Jn
//	  for(;;) {//Ҳٰ
//	    schedule();
//	    EvtTmr_Exec(pEvtTmr);//ς̎s
//	  }
//	}

