/*
 *	app.c
 *
 *	P/ECEAvP[V̐^iCLiPCuŁj
 *
 *	* Tue Jul 23 21:01:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_MUSIC
#include "instdef2.c"
#endif /*USE_MUSIC*/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	for(;;) {
		if(demo_main() < 0) break;
		game_main();
	}

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static void SndMxr_TimerProc(void* context) { //Sound Mixerpϊ
	int i;
	unsigned char AttSum[32];
	if(sound_stat(1)) {SndMxr_SetMxrChAtt(pSndMxr,0,64, 0,0);} //1ŉoBGMĐȂΤðBGM𑦏          
	else              {SndMxr_SetMxrChAtt(pSndMxr,0, 0,64,5);} //1ŉoBGM~ȂΤðBGM0.5bŕA     {{TODO:عݒ}}
	if(sound_stat(3)) {SndMxr_SetMxrChAtt(pSndMxr,1,64, 0,0);} //3ŴװĐȂΤðBGM,oBGM,SE𑦏 
	else              {SndMxr_SetMxrChAtt(pSndMxr,1, 0, 0,0);} //3ŴװĐȂΤðBGM,oBGM,SE𑦕A 
	SndMxr_Exec(pSndMxr); //Sound Mixers
	SndMxr_GetSndChAttAll(pSndMxr,-1,AttSum); //Sق̌ʂ擾
	for(i=0;i<SOUND_MAXCH;i++) {sound_att(i,AttSum[i]);} //Sق̌ʂݒ肷
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static int SndSeq_fnLen(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int SndSeq_fnNext(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static int SndSeq_fnPrev(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static void SndSeq_fnPan(int iTrk, int iPan) {
	//P/ECEɂ̓XeIĐ͖̂ŁA{֐͎gpȂB
}
static void SndSeq_fnVol(int iTrk, int iVol) {
	sound_att(iTrk, 64 - (iVol * 64 / SndVol_Max));
}
static void SndSeq_fnStop(int iTrk) {
	sound_stop(iTrk);
}
static void SndSeq_fnPlay(int iTrk, int iPhr, int iVol, int iPan) {
	sound_play(iTrk, sound_table[iPhr], -1);
	sound_att(iTrk, 64 - (iVol * 64 / SndVol_Max));
}
static int SndSeq_fnTime() {
	return pceTimerGetCount(); //ݎ[ms]PʂŕԂB
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now / FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

void
app_init()
{
	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
	pceLCDDispStart();
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	music_loudness(1);
	loadInst(); /* uRandomism Zone(http://www8.plala.or.jp/randomism/)v́whFLbgver.2.10xgp */
	InitMusic();
#ifdef USE_2BIT_ADPCM
	/* - 2-bit ADPCM DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * - music_wchύX鏈́AInitMusic()ōsKv܂B
	 *   InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * - Amusic_loudness()̋@\music_wchQƂĂ܂A
	 *   Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 */
	music_wch = 3; /* `l0=2-bit ADPCM DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*USE_2BIT_ADPCM*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* Sound Mixer܂B */
#ifdef  USE_SOUND_MIXER
	{
		static const int TBL_SndMxr_SndChMask[] = { //Ͻz
			(1<<0),               //Sound Mixer0:oBGMĐΏ:ðBGM            
			(1<<0)|(1<<1)|(1<<2), //Sound Mixer1:װĐΏ  :ðBGM,oBGM,SE {{TODO:عݒ}}
			-1};                  //Sound Mixer2:İح           :S         
		pSndMxr = SndMxr_Init(ARRAY_SIZE(TBL_SndMxr_SndChMask), TBL_SndMxr_SndChMask); //Sound Mixer쐬
		timer_start(100, SndMxr_TimerProc, NULL); //Sound MixerpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TEhV[PT܂B */
#ifdef  USE_SOUND_SEQUENCER
	{
		static const ST_SndSeqInfo stSndSeqInfo = { &SndSeq_fnTime, &SndSeq_fnPlay, &SndSeq_fnStop, &SndSeq_fnVol, &SndSeq_fnPan, &SndSeq_fnLen, &SndSeq_fnNext, &SndSeq_fnPrev };
		SndSeq_Init(&stSndSeqInfo);
		timer_start(10, SndSeq_Exec, NULL); //޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static const uint16_t TBL_EvtTmr_Data0[]={//#0ް
			SEC(0),10, //Jnɤޔԍ(10)s
			SEC(2),11, // 2b҂Ĥޔԍ(11)s
			SEC(1),12, // 1b҂Ĥޔԍ(12)s
			SEC(0),13, //̌シޔԍ(13)s
			SEC(3),-1};// 3b҂Ĥ擪ٰ߂
		static const uint16_t TBL_EvtTmr_Data1[]={//#1ް
			SEC(9),20, // 9b҂Ĥޔԍ(20)s
			SEC(0), 0};//̌シI
		static const uint16_t* const TBL_EvtTmr_Data[]={//eقް
			TBL_EvtTmr_Data0, //#0ް
			TBL_EvtTmr_Data1};//#1ް
		pEvtTmr=EvtTmr_Init(ARRAY_SIZE(TBL_EvtTmr_Data),TBL_EvtTmr_Data,EvtTmr_onEvent);//ς
	}
#endif/*USE_EVENT_TIMER*/

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_MUSIC
	/* mɉyt~܂B
	 * TEh̒~̓CupceAppExit()ōsĂ̂ŁA
	 * ł͕Kv܂B
	 */
	StopMusic();
	music_loudness(0);
#endif /*USE_MUSIC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 */
void
update()
{
#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_EVENT_TIMER
			/* Cxg^C}B */
			EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();

#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void
delay(int frame)
{
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	demo_main
 ****************************************************************************/

#ifdef USE_IDLE
static int idle_proc(int param) {
	/* {{TODO:ŎԂ̂鏈s}} */
	return 0;
}
#endif /*USE_IDLE*/

#ifdef  USE_PROD
static void ProdDev_Setup_Lcd(int ProdDev, int ProdDat) {
	const char* s;
	switch(ProdDat) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- LcdUi ---
	case LcdUi_TjUi:    s = "TjUi";   break;//ʏUI
	case LcdUi_BoUi:    s = "BoUi";   break;//ްŽUI
	//--- LcdCmd ---
	case LcdCmd_TjBgSc: s = "TjBgSc"; break;//ʏBG۰
	case LcdCmd_TjBgTe: s = "TjBgTe"; break;//ʏBG~
	case LcdCmd_TjAcAl: s = "TjAcAl"; break;//ʏ
	case LcdCmd_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case LcdCmd_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case LcdCmd_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case LcdCmd_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case LcdCmd_TjAcBe: s = "TjAcBe"; break;//ʏ
	case LcdCmd_TjAcSk: s = "TjAcSk"; break;//ʏ
	case LcdCmd_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case LcdCmd_Bonus:  s = "Bonus";  break;//ްŽBG
	case LcdCmd_BoEnd:  s = "BoEnd";  break;//ްŽI
	case LcdCmd_BoGet:  s = "BoGet";  break;//ްŽGet
	case LcdCmd_BoAcTe: s = "BoAcTe"; break;//ްŽ~
	case LcdCmd_BoAcKt: s = "BoAcKt"; break;//ްŽ]
	}
	render_rectangle_fill(&render, 0,10*ProdDev, DISP_X,10, 0);
	render_string(&render, 0,10*ProdDev, s, 0,3);
}
static void ProdDev_Setup_Lmp(int ProdDev, int ProdDat) {
	const char* s;
	switch(ProdDat) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- LmpCmd ---
	case LmpCmd_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case LmpCmd_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case LmpCmd_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case LmpCmd_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case LmpCmd_TjAcBe: s = "TjAcBe"; break;//ʏ
	case LmpCmd_TjAcSk: s = "TjAcSk"; break;//ʏ
	case LmpCmd_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case LmpCmd_Bonus:  s = "Bonus";  break;//ްŽBG
	case LmpCmd_BoEnd:  s = "BoEnd";  break;//ްŽI
	case LmpCmd_BoGet:  s = "BoGet";  break;//ްŽGet
	}
	render_rectangle_fill(&render, 0,10*ProdDev, DISP_X,10, 0);
	render_string(&render, 0,10*ProdDev, s, 0,3);
}
static void ProdDev_Setup_Snd(int ProdDev, int ProdDat) {
	const char* s;
	switch(ProdDat) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- SndBgm ---
	case SndBgm_Bonus: s = "Bonus";  break;//ްŽBGM
	case SndBgm_BoEnd: s = "BoEnd";  break;//ްŽI
	//--- SndSe ---
	case SndSe_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case SndSe_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case SndSe_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case SndSe_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case SndSe_TjAcBe: s = "TjAcBe"; break;//ʏ
	case SndSe_TjAcSk: s = "TjAcSk"; break;//ʏ
	case SndSe_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case SndSe_BoAcKt: s = "BoAcKt"; break;//ްŽ]
	case SndSe_BoGet:  s = "BoGet";  break;//ްŽGet
	}
	render_rectangle_fill(&render, 0,10*ProdDev, DISP_X,10, 0);
	render_string(&render, 0,10*ProdDev, s, 0,3);
}
static void ProdDev_Setup_Prg(int ProdDev, int ProdDat) {
	const char* s;
	switch(ProdDat) {
	default: DIE(); break;
	case 0: s = ""; break;
	}
	render_rectangle_fill(&render, 0,10*ProdDev, DISP_X,10, 0);
	render_string(&render, 0,10*ProdDev, s, 0,3);
}
static void ProdDev_Setup(int ProdDev, int ProdDat) {
	static void (*const TBL_Setup[])(int,int) = {
		ProdDev_Setup_Lcd,//0 t(UI)
		ProdDev_Setup_Lcd,//1 t()
		ProdDev_Setup_Lcd,//2 t(O)
		ProdDev_Setup_Lmp,//3 ()
		ProdDev_Setup_Lmp,//4 (O)
		ProdDev_Setup_Snd,//5 (BGM)
		ProdDev_Setup_Snd,//6 (SE)
		ProdDev_Setup_Prg,//7 ۸
	};
	if((unsigned)ProdDev >= ARRAY_SIZE(TBL_Setup)) { DIE(); }
	(*TBL_Setup[ProdDev])(ProdDev, ProdDat);
}
static const ST_ProdDevInfo stProdDevInfo = { NULL, ProdDev_Setup };
#endif/*USE_PROD*/

int
demo_main()
{
#ifdef USE_IDLE
	idle_init(idle_proc, 0);
#endif /*USE_IDLE*/

#ifdef USE_MUSIC
	{
		/* SAMPLE */
		extern const unsigned char C350[];
		music_play(C350);
	}
#endif /*USE_MUSIC*/

#ifdef  USE_BISON_FLEX
	{
		/* SAMPLE */
		FILE* fp = fopen("program.txt", "r");
#if     (YYDEBUG!=0)
	//	yydebug = 1; /* nonzero means print parse trace */
#endif/*(YYDEBUG!=0)*/
		yylex_init(fp);
		if((yyparse() != 0) || (yynerrs != 0)) DIE();
		fclose(fp);
	}
#endif/*USE_BISON_FLEX*/

#ifdef  USE_LOT
	{
		/* SAMPLE */
		int hitcnt[(1+4)/*eHazure,eReplay,eBell,eCherry,eBonus*/]={0};
		int rndval;
		for(rndval = 0; rndval <= USHRT_MAX; rndval++) {
			int hitval = LOT_draw_table(TBL_LotTbl+LotTbl_Nor/*table=Nor:ʏ펞*/, 6/*id=6:ݒ6*/|(1<<16)/*skip=1:߯V*/, rndval);
			if(hitval == -1) { hitval = eHazure; }
			if((unsigned)hitval >= ARRAY_SIZE(hitcnt)) { DIE(); }
			hitcnt[hitval]++;
		}
		surface_clear(&surface, 0);
		render_printf(&render, 0,10*0, 0,3, "eHazure %5d\n", hitcnt[0]);
		render_printf(&render, 0,10*1, 0,3, "eReplay %5d\n", hitcnt[1]);
		render_printf(&render, 0,10*2, 0,3, "eBell   %5d\n", hitcnt[2]);
		render_printf(&render, 0,10*3, 0,3, "eCherry %5d\n", hitcnt[3]);
		render_printf(&render, 0,10*4, 0,3, "eBonus  %5d\n", hitcnt[4]);
		for(;;) { schedule(); if(joy & TRG_A) { break; } }
	}
#endif/*USE_LOT*/

#ifdef  USE_PROD
	{
		/* SAMPLE */
		static const unsigned short tblProdSet[]={0,
			/*1*/ProdSet_TjDef,/*2*/ProdSet_TjYkHz,/*3*/ProdSet_TjYkBo,/*4*/ProdSet_TjYkRp,/*5*/ProdSet_TjYkBe,/*6*/ProdSet_TjYkSk,/*7*/ProdSet_TjYkCh,
			/*8*/ProdSet_BoDef,/*9*/ProdSet_BoGame,/*10*/ProdSet_BoEnd};
		int selProdSet = 0;
		int selTrigger = 1;
		ProdDev_Install(&stProdDevInfo);
		surface_clear(&surface, 0);
		for(;;) {
			schedule();
			ProdCh_ExecAll();
			if((joy & PAD_A) && (joy & PAD_B)) { break; }
			if(joy & TRG_UP) { if(--selProdSet < 0) { selProdSet = ARRAY_SIZE(tblProdSet)-1; } }//ođI(-)
			if(joy & TRG_DN) { if(++selProdSet > ARRAY_SIZE(tblProdSet)-1) { selProdSet = 0; } }//ođI(+)
			if(joy & TRG_LF) { if(--selTrigger < 1) { selTrigger = 30; } }//ضޑI(-)
			if(joy & TRG_RI) { if(++selTrigger > 30) { selTrigger = 1; } }//ضޑI(+)
			if(joy & TRG_A) { ProdSetList_Setup(selProdSet ? TBL_ProdSet+tblProdSet[selProdSet] : NULL, 0); selTrigger = 1; }//oľı
			if(joy & TRG_B) { ProdCh_SendTriggerAll(selTrigger); if(++selTrigger > 30) { selTrigger = 30; } }//ضޑM
			render_rectangle_fill(&render, 0,DISP_Y-10, DISP_X,10, 0);
			render_printf(&render, 0,DISP_Y-10, 0,3, "ProdSet %2d / Trigger %2d", selProdSet, selTrigger);
		}
	}
#endif/*USE_PROD*/

#ifdef  USE_SOUND_MIXER
	{
		SndMxr_SetMxrChAtt(pSndMxr, 2, 3, 0, 0); //İحтݒ肷(3dB)
		sound_play(0, sound_table[SND_BGM_ST], -1); //ðBGM𖳌ٰߍĐ
		for(;;) {
			schedule();
			if(joy & TRG_A ) { sound_play(1, sound_table[SND_BGM_1G], 2); } //oBGM2Đ顂̊ԤðBGM͏
			if(joy & TRG_B ) { sound_play(2, sound_table[SND_SE_BTN], 1); } //SE1Đ顂͑̂ǂ̉ɂeȂ
			if(joy & TRG_UP) { sound_play(3, sound_table[SND_SE_ERR], 3); } //װ3Đ顂̊Ԥ̉Sď
			if(joy & TRG_DN) { break; }
		}
	}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_EVENT_TIMER
	{
		for(;;) {
			schedule();
			if(joy & TRG_UP) { EvtTmr_Start(pEvtTmr, 0); } //#0Jn
			if(joy & TRG_DN) { EvtTmr_Stop( pEvtTmr, 0); } //#0~
			if(joy & TRG_LF) { EvtTmr_Start(pEvtTmr, 1); } //#1Jn
			if(joy & TRG_RI) { EvtTmr_Stop( pEvtTmr, 1); } //#1~
			if(joy & TRG_A ) { break; }
		}
	}
#endif/*USE_EVENT_TIMER*/

	for(;;) {
		schedule();
		surface_clear(&surface, 1);

#ifdef USE_TCPIP
		{
			/* SAMPLE */
			if(joy & TRG_A) tcpip_config();
		}
#endif /*USE_TCPIP*/

#ifdef USE_SPRITE
		{
			/* SAMPLE */
			sprite_draw(0, 0, SPR4F/*O*/, 0);
			sprite_draw(8, 0, SPR4B/*K*/, 0);
		}
#endif /*USE_SPRITE*/

#ifdef USE_3D
		{
			/* SAMPLE */
			extern const MESH MESH_CUBE; /* mqo/cube.pmx */
			extern const WIRE WIRE_CONE; /* mqo/cone.pwx */
			render_save(&render);
				mlookat_(render.context->matrix,
					fld(0.0), fld(0.0), fld(0.0),
					fld(0.0), fld(0.0), fld(1.0),
					fld(0.0));
				render_save(&render);
#ifdef USE_TEXTURE
					render.context->texture = &texture_table[TEX_CUBE];
#endif /*USE_TEXTURE*/
					mxlate_(render.context->matrix,
						fld(-1.0), fld(0.0), fld(5.0));
					mrotq_(render.context->matrix, qslerp(
						qrot(fld(1.0), fld(0.0), fld(0.0), fld(0.0)),
						qrot(fld(1.0), fld(0.0), fld(0.0), PI),
						fidiv(fld(now % SEC(5)), SEC(5))));
					render_mesh(&render, &MESH_CUBE);
				render_restore(&render);
				render_save(&render);
					mxlate_(render.context->matrix,
						fld(1.5), fld(-1.0), fld(5.0));
					mrotq_(render.context->matrix, qslerp(
						qrot(fld(0.0), fld(1.0), fld(0.0), fld(0.0)),
						qrot(fld(0.0), fld(1.0), fld(0.0), PI),
						fidiv(fld(now % SEC(5)), SEC(5))));
					render_wire(&render, &WIRE_CONE, 3);
				render_restore(&render);
			render_restore(&render);
		}
#endif /*USE_3D*/
	}

#ifdef USE_IDLE
	idle_wait();
#endif /*USE_IDLE*/

	return 0;
}

/****************************************************************************
 *	game_main
 ****************************************************************************/

void
game_main()
{
	for(;;) {
		schedule();
	}
}
