/* 
 *	POKEY chip emulator 4.5
 *	Copyright (c) 2000 by The MAME Team
 *	̗e[ug킹Ē܂B
 */
#include <stdio.h>
#include <stdlib.h>

static void make_table(int bits, int left, int right, int add);

int
main()
{
	make_table( 4,  3, 1, 0x00004);
	make_table( 5,  3, 2, 0x00008);
	make_table( 9,  8, 1, 0x00180);
	make_table(17, 16, 1, 0x1c000);
}

static void
make_table(int bits, int left, int right, int add)
{
	int mask = (1 << bits) - 1;
	int i, v = 0;
	//
	int size  = (mask + 7) / 8;
	unsigned char* table = (unsigned char*)calloc(size, 1);
	if(!table) abort();

	for(i = 0; i < mask; i++) {
		table[i / 8] |= (v & 1) << (i & 7);
		v = ((v << left) + (v >> right) + add) & mask;
	}

	printf("/* [%dbit v(i)=((v(i-1)<<%d)+(v(i-1)>>%d)+%#x)&%#x] */\n", bits, left, right, add, mask);
	printf("const unsigned char pokey_lfsr_table%d[%#x/*output=%#x[bits],padding=%d[bits]*/] = {\n", bits, size, mask, size * 8 - mask);
	for(i = 0; i < size; i++) {
		printf("'\\x%02x',", table[i]);
		if((i & 15) == 15) printf("\n");
	}

	if(i & 15) printf("\n");
	printf("};\n");

	free(table);
}
