/*
 *	jtwhile.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTWHILE
 *****************************************************************************/

typedef struct _JTWHILE {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTCODE_INTERFACE** cond;	/*  */
	JTCODE_INTERFACE** body;	/* ^̊ԁAs镶 */
} JTWHILE;

IMPLEMENT_JTCODE_INTERFACE(JTWHILE, jtwhile)

const INTERFACE_MAP jtwhile_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTWHILE, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtwhile_create(JTCODE_INTERFACE** cond, JTCODE_INTERFACE** body)
{
	JTWHILE* this = calloc(1, sizeof(JTWHILE));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtwhile_interface_map);

	/* A^̊ԁAs镶i[܂B */
	safe_assign(this->cond, cond);
	safe_assign(this->body, body);

	return &this->jtcode_interface;
}

static void
jtwhile_delete(JTWHILE* this)
{
	/* A^̊ԁAs镶܂B */
	safe_release(this->cond);
	safe_release(this->body);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTWHILE* this = CONTAINING_RECORD(intf, JTWHILE, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTCODE_INTERFACE** cond = NULL;
	JTBOOL_INTERFACE** jtbool = NULL;

	for(;;) {
		/* s܂B */
		safe_attach(cond, (*this->cond)->run(this->cond));
		safe_assign_interface(jtbool, cond, JTBOOL_INTERFACE);
		if(!jtbool) {
			DIE(); /* JTBOOL_INTERFACEKv */
		}

		/* sʂUȂ΁A܂B */
		if(!(*jtbool)->get_value(jtbool)) {
			break;
		}

		/* ^̊ԁAs镶s܂B */
		safe_attach(code, (*this->body)->run(this->body));
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(cond);
	safe_release(jtbool);

	return code;
}

