/*
 *	jtdotassign.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTDOTASSIGN
 *****************************************************************************/

typedef struct _JTDOTASSIGN {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTCODE_INTERFACE** code;	/* IuWFNg */
	JTSYMBOL_INTERFACE** symbol;	/* tB[hϐ\V{ */
	JTCODE_INTERFACE** value;	/* tB[hϐɐݒ肷l */
} JTDOTASSIGN;

IMPLEMENT_JTCODE_INTERFACE(JTDOTASSIGN, jtdotassign)

const INTERFACE_MAP jtdotassign_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTDOTASSIGN, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtdotassign_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value)
{
	JTDOTASSIGN* this = calloc(1, sizeof(JTDOTASSIGN));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtdotassign_interface_map);

	/* IuWFNgAtB[hϐ\V{AtB[hϐɐݒ肷li[܂B */
	safe_assign(this->code, code);
	safe_assign(this->symbol, symbol);
	safe_assign(this->value, value);

	return &this->jtcode_interface;
}

static void
jtdotassign_delete(JTDOTASSIGN* this)
{
	/* IuWFNgAtB[hϐ\V{AtB[hϐɐݒ肷l܂B */
	safe_release(this->code);
	safe_release(this->symbol);
	safe_release(this->value);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTDOTASSIGN* this = CONTAINING_RECORD(intf, JTDOTASSIGN, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTOBJECT_INTERFACE** object = NULL;

	/* \bhĂяoÕ^C~OŁAIuWFNg]܂B */
	safe_attach(code, (*this->code)->run(this->code)); /* V{āAIuWFNg擾鏈Ȃ */
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);
	if(!object) {
		DIE(); /* IuWFNgłȂ (ǂݍ񂾃vÕG[) */
	}

	/* tB[hϐɐݒ肷l]܂B */
	safe_attach(code, (*this->value)->run(this->value));

	/* tB[hϐ̒lݒ肵܂B */
	(*object)->set_field_value(object, this->symbol, code);

	/* svɂȂC^[tFCX܂B */
	safe_release(object);

	return code;
}

