;
;	framz8ca.s
;
;	P/ECE Z80 Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Jan 10 19:00:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Mon Mar 07 02:08:00 JST 2005 Naoyuki Sawa
;	- HALT=1̏Ԃm6502cpu_runĂ΂ꂽƂɁAm6502cpu.cycle=0ŏI悤CB
;	  ܂ł́Am6502cpu.cycleωɏIĂ܂Ă߂ɁA
;	  Cycle̒[m6502cpu_run֌J艄ׂ悤ȏɕsĂ܂B
;
#include "clipz8ca.h"

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 2

	; ̂߁AZ80CPU\̂RAMɔzu܂B
	.global z80cpu
z80cpu:
	.space SIZEOF_Z80CPU

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

	.global z80cpu_run
z80cpu_run:
	pushn  %r3
	;
	xld.w [z80cpu+_CYCLE_], %r12	; sReLXgo܂B
	xcall  z80cpu_enter
	;
	xbtst [%CPU+HALT], 0		; HALTȂ΁AcsTCN0ɂāA
	jreq   2			;  Ƀ[v𔲂܂B(z80cpu.cycle=0ŏIB)
	ld.w   %CYCLE, 0		; (skip?)
	;
	xjp    z80cpu_run_LOOP		; Cycle=0w肳ꂽꍇ̂߂ɁA܂肩B
z80cpu_run_DO:
;----------------------------------------------------------------------------
//#define Z80CPU_RUN_TRACE
#ifdef Z80CPU_RUN_TRACE
	; g[XfobOsꍇ́ÃubNLɂĂB
	; ̍ہAz80cpu_trace()́AAvP[VɂĒ`ĂB
	; z80cpu_trace()́ACuł͒`Ă܂B
	xcall  z80cpu_leave
	xcall  z80cpu_trace
	xcall  z80cpu_enter
#endif /*Z80CPU_RUN_TRACE*/
;----------------------------------------------------------------------------
	ld.ub  %t0, [%PC]+		; OpCode擾APCi߂܂B
	xsll   %t0, 2			; OpCodeɑΉ閽߃[`Ăяo܂B
	ext    z80cpu_XXops@ah
	ext    z80cpu_XXops@al
	ld.w   %t0, [%t0]
	call   %t0
z80cpu_run_LOOP:
	xcmp   %CYCLE, 0		; Cycle0ȉɂȂ܂ŌJԂ܂B
	xjrgt  z80cpu_run_DO
	;
	xcall  z80cpu_leave		; sReLXg߂܂B
	;
	popn   %r3
	ret

;
;	CB xx
;	   ++- OpCode
;
	.global z80cpu_CB
z80cpu_CB:
	ld.ub %t0, [%PC]+		; OpCode
	xsll  %t0, 2
	ext z80cpu_CBops@ah
	ext z80cpu_CBops@al
	ld.w  %t0, [%t0]
	jp    %t0

;
;	ED xx
;	   ++- OpCode
;
	.global z80cpu_ED
z80cpu_ED:
	ld.ub %t0, [%PC]+		; OpCode
	xsll  %t0, 2
	ext z80cpu_EDops@ah
	ext z80cpu_EDops@al
	ld.w  %t0, [%t0]
	jp %t0

;
;	DD xx
;	   ++- OpCode
;
	.global z80cpu_DD
z80cpu_DD:
	ld.ub %t0, [%PC]+		; OpCode
	xsll  %t0, 2
	ext z80cpu_DDops@ah
	ext z80cpu_DDops@al
	ld.w  %t0, [%t0]
	jp %t0

;
;	FD xx
;	   ++- OpCode
;
	.global z80cpu_FD
z80cpu_FD:
	ld.ub %t0, [%PC]+		; OpCode
	xsll  %t0, 2
	ext z80cpu_FDops@ah
	ext z80cpu_FDops@al
	ld.w  %t0, [%t0]
	jp %t0

;
;	DD CB d xx
;	      | ++- OpCode
;	      +---- IX+"d"
;
; [note]
;	* DD CB d xx n̖߂͑SēoCg\ŁA[IX+d]Ɏ܂B
;	  炩߂ŁA&z80ram[IX+d]̃AhX߂Ă܂B
;	  ȍ~́AFD CB d xx nƓȂ̂ŁA߃[`Lł܂B
;	* DD CB d xx n̖߃[` %s0 = mem+IX+d ̈ŌĂяo܂B
;	  ߃[`̒ŁAAhXvZKv͂܂B
;	* DD CB d xx n̖߃[`ɂ xxx_IaddrI ƂOt܂B
;	  (z80cpu_RLC_IaddrIAz80cpu_BIT_0_IaddrI Ȃ)
;
	.global z80cpu_DDCB
z80cpu_DDCB:
	xld.uh %s0, [%CPU+IX]		; %s0 = &z80mem[IX+d(signed)]
	ld.b   %t0, [%PC]+
	add    %s0, %t0
	add    %s0, %MEM
	ld.ub  %t0, [%PC]+		; OpCode
	xsll   %t0, 2
	ext z80cpu_XXCBops@ah		; 
	ext z80cpu_XXCBops@al
	ld.w   %t0, [%t0]
	jp     %t0

;
;	FD CB d xx
;	      | ++- OpCode
;	      +---- IY+"d"
;
; [note]
;	* FD CB d xx n̖߂͑SēoCg\ŁA[IY+d]Ɏ܂B
;	  炩߂ŁA&z80ram[IY+d]̃AhX߂Ă܂B
;	  ȍ~́ADD CB d xx nƓȂ̂ŁA߃[`Lł܂B
;	* FD CB d xx n̖߃[` %s0 = mem+IX+d ̈ŌĂяo܂B
;	  ߃[`̒ŁAAhXvZKv͂܂B
;	* FD CB d xx n̖߃[`ɂ xxx_IaddrI ƂOt܂B
;	  (z80cpu_RLC_IaddrIAz80cpu_BIT_0_IaddrI Ȃ)
;
	.global z80cpu_FDCB
z80cpu_FDCB:
	xld.uh %s0, [%CPU+IY]		; %s0 = &z80mem[IY+d(signed)]
	ld.b   %t0, [%PC]+
	add    %s0, %t0
	add    %s0, %MEM
	ld.ub  %t0, [%PC]+		; OpCode
	xsll   %t0, 2
	ext z80cpu_XXCBops@ah
	ext z80cpu_XXCBops@al
	ld.w   %t0, [%t0]
	jp     %t0

;****************************************************************************
;	16-Bit Load Group
;****************************************************************************

;
;	PUSH rr
;
; [in]
;	%a0		rr
;
	.global z80cpu_push
z80cpu_push:
	xld.uh %t0, [%CPU+SP]		; %t0 = SP
	add    %t0, %MEM		; %t0 = mem+SP
	xrr    %a0, 8			; %a0[7:0] = hi(rr)
	xsub   %t0, %t0, 1		; %t0 = mem+SP-1
	ld.b  [%t0], %a0		; [mem+SP-1] = hi(rr)
	xrl    %a0, 8			; %a0[7:0] = lo(rr)
	xsub   %t0, %t0, 1		; %t0 = mem+SP-2
	ld.b  [%t0], %a0		; [mem+SP-2] = lo(rr)
	sub    %t0, %MEM		; %s0 = SP-2
	xld.h [%CPU+SP], %t0		; SP = SP-2
	ret

;
;	POP rr
;
; [out]
;	%a0		rr
;
	.global z80cpu_pop
z80cpu_pop:
	xld.uh %t0, [%CPU+SP]		; %t0 = SP
	add    %t0, %MEM		; %t0 = mem+SP
	ld.ub  %a0, [%t0]+		; %a0 = [mem+SP+0], %t0 = mem+SP+1
	ld.ub  %a1, [%t0]+		; %a1 = [mem+SP+1], %t0 = mem+SP+2
	sub    %t0, %MEM		; %t0 = SP+2
	xld.h [%CPU+SP], %t0		; SP  = SP+2
	xsll   %a1, 8			; %a0 = lo(rr)|hi(rr)<<8
	ret.d
	or     %a0, %a1			; *delay*

;****************************************************************************
;	8-Bit Arithmetic Group
;****************************************************************************

;
;	ADD A, r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if carry from bit 3, reset otherwise
;	P/V	is set if overflow, reset otherwise
;	N	is reset
;	C	is set if carry from bit 7, reset otherwise
;
; [in]
;	%a0	r
;
	.global z80cpu_add8
z80cpu_add8:
	swap %t0, %A			; %t0[31:24] = A
	swap %t1, %a0			; %t1[31:24] = r
	add  %t0, %t1			; %t0[31:24] = A+r
	;
	ld.w %F, %psr			; %F = F(00CPZS)
	xand %F, %F, CF|PF|ZF|SF
	xand %A, %A, 0xf		; %F = F(0HCPZS)
	xand %a0, %a0, 0xf
	add  %A, %a0
	xand %A, %A, HF
	or   %F, %A
	;
	ret.d
	swap %A, %t0			; %A = A+r *delay*

;
;	ADC A, r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if carry from bit 3, reset otherwise
;	P/V	is set if overflow, reset otherwise
;	N	is reset
;	C	is set if carry from bit 7: reset otherwise
;
; [in]
;	%a0	r
;
	.global z80cpu_adc8
z80cpu_adc8:
	ld.w  %t2, %psr			; %t2 = F(C)
	xand  %t2, %t2, ~CF
	xand  %F, %F, CF
	or    %t2, %F
	;
	swap  %t0, %A			; %t0[31:24] = A
	swap  %t1, %a0			; %t1[31:24] = r
	xoor  %t1, %t1, (1<<24)-1	; %t1[23: 0] = 0xffffff
	ld.w  %psr, %t2			; %t0[31:24] = A+r+F(C)
	adc   %t0, %t1
	;
	ld.w  %F, %psr			; %F = F(00CP0S)
	xand  %F, %F, CF|PF|SF		; (%t0[23:0]ŝ߁A%psr(Z)͖mł)
	xand  %A, %A, 0xf		; %F = F(0HCP0S)
	xand  %a0, %a0, 0xf
	ld.w  %psr, %t2
	adc   %A, %a0
	xand  %A, %A, HF
	or    %F, %A
	;
	swap  %A, %t0			; %A[7:0] = A+r+F(C)
	ld.ub %A, %A			; %A = A+r+F(C)
	or    %A, %A			; %F = F(0HCPZS)
	jrne  2
	add   %F, ZF			; (skip?)
	ret

;
;	SUB r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if borrow from bit 4, reset otherwise
;	P/V	is set if overflow, reset otherwise
;	N	is set
;	C	is set if borrow, reset otherwise
;
; [in]
;	%a0	r
;
	.global z80cpu_sub8
z80cpu_sub8:
	swap %t0, %A			; %t0[31:24] = A
	swap %t1, %a0			; %t1[31:24] = r
	sub  %t0, %t1			; %t0[31:24] = A-r
	;
	ld.w %F, %psr			; %F = F(00CPZS)
	xand %F, %F, CF|PF|ZF|SF
	xadd %F, %F, NF			; %F = F(N0CPZS)
	xand %A, %A, 0xf		; %F = F(NHCPZS)
	xand %a0, %a0, 0xf
	sub  %A, %a0
	xand %A, %A, HF
	or   %F, %A
	;
	ret.d
	swap %A, %t0			; %A = A-r *delay*

;
;	SBC A, r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if borrow from bit 4, reset otherwise
;	P/V	is reset if overflow, reset otherwise
;	N	is set
;	C	is set if borrow, reset otherwise
;
; [in]
;	%a0	r
;
	.global z80cpu_sbc8
z80cpu_sbc8:
	ld.w  %t2, %psr			; %t2 = F(C)
	xand  %t2, %t2, ~CF
	xand  %F, %F, CF
	or    %t2, %F
	;
	swap  %t0, %A			; %t0[31:24] = A
	swap  %t1, %a0			; %t1[31:24] = r
	ld.w  %psr, %t2			; %t0[31:24] = A-r-F(C)
	sbc   %t0, %t1
	;
	ld.w  %F, %psr			; %F = F(00CP0S)
	xand  %F, %F, CF|PF|SF		; (%t0[23:0]ŝ߁A%psr(Z)͖mł)
	xadd  %F, %F, NF		; %F = F(N0CP0S)
	xand  %A, %A, 0xf		; %F = F(NHCP0S)
	xand  %a0, %a0, 0xf
	ld.w  %psr, %t2
	sbc   %A, %a0
	xand  %A, %A, HF
	or    %F, %A
	;
	swap  %A, %t0			; %A[7:0] = A-r-F(C)
	ld.ub %A, %A			; %A = A-r-F(C)
	or    %A, %A			; %F = F(NHCPZS)
	jrne  2
	add   %F, ZF			; (skip?)
	ret

;
;	AND r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is reset
;
; [in]
;	%a0	r
;
	.global z80cpu_and
z80cpu_and:
	swap  %t0, %A			; %t0[31:24] = A
	swap  %t1, %a0			; %t1[31:24] = r
	and   %t0, %t1			; %t0[31:24] = A&r
	;
	ld.w  %F, %psr			; %F = F(0000ZS)
	xand  %F, %F, ZF|SF
	xadd  %F, %F, HF		; %F = F(0N00ZS)
	swap  %A, %t0			; %A = A&r
	ext z80cpu_parity@ah		; %F = F(0N0PZS)
	ext z80cpu_parity@al
	ld.ub %t0, [%A]
	ret.d
	or    %F, %t0			; *delay*

;
;	OR r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is reset
;
; [in]
;	%a0	r
;
	.global z80cpu_or
z80cpu_or:
	swap  %t0, %A			; %t0[31:24] = A
	swap  %t1, %a0			; %t1[31:24] = r
	or    %t0, %t1			; %t0[31:24] = A|r
	;
	ld.w  %F, %psr			; %F = F(0000ZS)
	xand  %F, %F, ZF|SF
	swap  %A, %t0			; %A = A|r
	ext z80cpu_parity@ah		; %F = F(000PZS)
	ext z80cpu_parity@al
	ld.ub %t0, [%A]
	ret.d
	or    %F, %t0			; *delay*

;
;	XOR r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is reset
;
; [in]
;	%a0	r
;
	.global z80cpu_xor
z80cpu_xor:
	swap  %t0, %A			; %t0[31:24] = A
	swap  %t1, %a0			; %t1[31:24] = r
	xor   %t0, %t1			; %t0[31:24] = A^r
	;
	ld.w  %F, %psr			; %F = F(0000ZS)
	xand  %F, %F, ZF|SF
	swap  %A, %t0			; %A = A^r
	ext z80cpu_parity@ah		; %F = F(000PZS)
	ext z80cpu_parity@al
	ld.ub %t0, [%A]
	ret.d
	or    %F, %t0			; *delay*

;
;	CP r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if borrow from bit 4, reset otherwise
;	P/V	is set if overflow, reset otherwise
;	N	is set
;	C	is set if borrow, reset otherwise
;
; [in]
;	%a0	r
;
	.global z80cpu_cp
z80cpu_cp:
	swap %t0, %A			; %t0[31:24] = A
	swap %t1, %a0			; %t1[31:24] = r
	cmp  %t0, %t1			; %t0[31:24] = A-r
	;
	ld.w %F, %psr			; %F = F(00CPZS)
	xand %F, %F, CF|PF|ZF|SF
	xadd %F, %F, NF			; %F = F(N0CPZS)
	xand %t0, %A, 0xf		; %F = F(NHCPZS)
	xand %a0, %a0, 0xf
	sub  %t0, %a0
	xand %t0, %t0, HF
	;
	ret.d
	or   %F, %t0			; *delay*

;
;	INC r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if carry from bit 3, reset otherwise
;	P/V	is set if r was 7FH before operation, reset otherwise
;	N	is reset
;	C	is not affected
;
; [in]
;	%a0	r
; [out]
;	%a0	r+1
;
	.global z80cpu_inc8
z80cpu_inc8:
	xand %t1, %F, CF		; %t1 = F(00C0000)
	swap %t0, %a0			; %t0[31:24] = r
	xadd %t0, %t0, 1<<24		; %t0[31:24] = r+1
	;
	ld.w %F, %psr			; %F = F(000PZS)
	xand %F, %F, PF|ZF|SF
	xand %a0, %a0, 0xf		; %F = F(0H0PZS)
	xadd %a0, %a0, 1
	xand %a0, %a0, HF
	or   %F, %a0
	or   %F, %t1			; %F = F(0HCPZS)
	;
	ret.d
	swap %a0, %t0			; %a0 = r+1 *delay*

;
;	DEC r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if borrow from bit 4, reset otherwise
;	P/V	is set if m was 80H before operation, reset otherwise
;	N	is set
;	C	is not affected
;
; [in]
;	%a0	r
; [out]
;	%a0	r-1
;
	.global z80cpu_dec8
z80cpu_dec8:
	xand %t1, %F, CF		; %t1 = F(00C0000)
	swap %t0, %a0			; %t0[31:24] = r
	xsub %t0, %t0, 1<<24		; %t0[31:24] = r-1
	;
	ld.w %F, %psr			; %F = F(000PZS)
	xand %F, %F, PF|ZF|SF
	xadd %F, %F, NF			; %F = F(N00PZS)
	xand %a0, %a0, 0xf		; %F = F(NH0PZS)
	xsub %a0, %a0, 1
	xand %a0, %a0, HF
	or   %F, %a0
	or   %F, %t1			; %F = F(NHCPZS)
	;
	ret.d
	swap %a0, %t0			; %a0 = r-1 *delay*

;****************************************************************************
;	16-Bit Arithmetic Group
;****************************************************************************

;
;	ADD rr, ss
;
;	S	is not affected
;	Z	is not affected
;	H	is set if carry out of bit 11, reset otherwise
;	P/V	is not affected
;	N	is reset
;	C	is set if carry from bit 15, reset otherwise
;
; [in]
;	%a0	rr
;	%a1	ss
; [out]
;	%a0	rr+ss
;
	.global z80cpu_add16
z80cpu_add16:
	xand %t2, %F, PF|ZF|SF		; %t2 = F(000PZS)
	ld.w %t0, %a0			; %t0[31:16] = rr
	xsll %t0, 16
	ld.w %t1, %a1			; %t1[31:16] = ss
	xsll %t1, 16
	add  %t0, %t1			; %t0[31:16] = rr+ss
	;
	ld.w %F, %psr			; %F = F(00C000)
	xand %F, %F, CF
	xand %a0, %a0, 0xfff		; %F = F(0HC000)
	xand %a1, %a1, 0xfff
	add  %a0, %a1
	xsrl %a0, 8
	xand %a0, %a0, HF
	or   %F, %a0
	or   %F, %t2			; %F = F(0HCPZS)
	;
	xsrl %t0, 16			; %t0 = rr+ss
	ret.d
	ld.w %a0, %t0			; %a0 = rr+ss *delay*

;
;	ADC rr, ss
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is set if carry out of bit 11, reset otherwise
;	P/V	is set if overflow, reset otherwise
;	N	is reset
;	C	is set if carry from bit 15, reset otherwise
;
; [in]
;	%a0	rr
;	%a1	ss
; [out]
;	%a0	rr+ss+F(C)
;
	.global z80cpu_adc16
z80cpu_adc16:
	ld.w %t2, %psr			; %t2 = F(C)
	xand %t2, %t2, ~CF
	xand %F, %F, CF
	or   %t2, %F
	;
	ld.w %t0, %a0			; %t0[31:16] = rr
	xsll %t0, 16
	ld.w %t1, %a1			; %t1[31:16] = ss
	xsll %t1, 16
	xoor %t1, %t1, (1<<16)-1	; %t1[15: 0] = 0xffff
	ld.w %psr, %t2			; %t0[31:16] = rr+ss+F(C)
	adc  %t0, %t1
	;
	ld.w %F, %psr			; %F = F(00CP0S)
	xand %F, %F, CF|PF|SF		; (%t0[15:0]ŝ߁A%psr(Z)͖mł)
	xand %a0, %a0, 0xfff		; %F = F(0HCP0S)
	xand %a1, %a1, 0xfff
	ld.w %psr, %t2
	adc  %a0, %a1
	xsrl %a0, 8
	xand %a0, %a0, HF
	or   %F, %a0
	;
	xsrl %t0, 16			; %t0 = rr+ss+F(C)
	jrne 2				; %F = F(0HCPZS)
	add  %F, ZF			; (skip?)
	ret.d
	ld.w %a0, %t0			; %a0 = rr+ss+F(C) *delay*

;
;	SBC rr, ss
;
;	S is set if result is negative, reset otherwise
;	Z is set if result is zero, reset otherwise
;	H is set if a borrow from bit 12, reset otherwise
;	P/V is set if overflow, reset otherwise
;	N is set
;	C is set if borrow, reset otherwise
;
; [in]
;	%a0	rr
;	%a1	ss
; [out]
;	%a0	rr-ss-F(C)
;
	.global z80cpu_sbc16
z80cpu_sbc16:
	ld.w %t2, %psr			; %t2 = F(C)
	xand %t2, %t2, ~CF
	xand %F, %F, CF
	or   %t2, %F
	;
	ld.w %t0, %a0			; %t0[31:16] = rr
	xsll %t0, 16
	ld.w %t1, %a1			; %t1[31:16] = ss
	xsll %t1, 16
	ld.w %psr, %t2			; %t0[31:16] = rr-ss-F(C)
	sbc  %t0, %t1
	;
	ld.w %F, %psr			; %F = F(00CP0S)
	xand %F, %F, CF|PF|SF		; (%t0[15:0]ŝ߁A%psr(Z)͖mł)
	xadd %F, %F, NF			; %F = F(N0CP0S)
	xand %a0, %a0, 0xfff		; %F = F(NHCP0S)
	xand %a1, %a1, 0xfff
	ld.w %psr, %t2
	sbc  %a0, %a1
	xsrl %a0, 8
	xand %a0, %a0, HF
	or   %F, %a0
	;
	xsrl %t0, 16			; %t0 = rr-ss-F(C)
	jrne 2				; %F = F(NHCPZS)
	add  %F, ZF			; (skip?)
	ret.d
	ld.w %a0, %t0			; %a0 = rr-ss-F(C) *delay*

;****************************************************************************
;	Rotate and Shift Group
;****************************************************************************

;
;	RL r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 7 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	RL r
;
	.global z80cpu_rl
z80cpu_rl:
;;	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
;;	xsll  %a0, 1			; %a0 = r:rrrrrrr0
;;	xand  %F, %F, CF		; %F  = 0:0000C000
;;	xsrl  %F, 3-0			; %F  = 0:0000000C
;;	or    %a0, %F			; %a0 = r:rrrrrrrC
;;	ld.b  %a0, %a0			; %a0 = ?:rrrrrrrC (signed)
;;	or    %a0, %a0			; (%psr֔f邽߂ɕKvł)
;;	;
;;	ld.w  %F, %psr			; %F  = F(000000ZS)
;;	and   %F, ZF|SF
;;	xsrl  %t0, 7-3			; %t0 = 0:0000rrrr
;;	xand  %t0, %t0, CF		; %t0 = 0:0000r000
;;	or    %F, %t0			; %F  = F(0000C0ZS)
;;	ld.ub %a0, %a0			; %a0 = 0:rrrrrrrC (unsigned)
;;	ext z80cpu_parity@ah		; %t0 = F(00000P00)
;;	ext z80cpu_parity@al
;;	ld.ub %t0, [%a0]
;;	ret.d
;;	or    %F, %t0			; %F  = F(0000CPZS) *delay*
;;͂ɍ܂BԂvƎvǁA΂炭lqłB
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	xsll  %a0, 1			; %a0 = r:rrrrrrr0          -+- ̓stɂƊԈႢłB
	ld.b  %a0, %a0			; %a0 = ?:rrrrrrr0 (signed) -+  tɂȂ悤ӂĂ!!
	xand  %F, %F, CF		; %F  = 0:0000C000
	xsrl  %F, 3-0			; %F  = 0:0000000C
	or    %a0, %F			; %a0 = ?:rrrrrrrC (signed)
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsrl  %t0, 7-3			; %t0 = 0:0000rrrr
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:rrrrrrrC (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	RLC r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 7 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	RLC r
;
	.global z80cpu_rlc
z80cpu_rlc:
;;	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
;;	ld.w  %t1, %a0			; %t1 = 0:rrrrrrrr
;;	xsll  %a0, 1			; %a0 = r:rrrrrrr0
;;	xsrl  %t1, 7			; %t1 = 0:0000000r
;;	or    %a0, %t1			; %a0 = r:rrrrrrrr
;;	ld.b  %a0, %a0			; %a0 = ?:rrrrrrrr (signed)
;;	or    %a0, %a0			; (%psr֔f邽߂ɕKvł)
;;	;
;;	ld.w  %F, %psr			; %F  = F(000000ZS)
;;	and   %F, ZF|SF
;;	xsrl  %t0, 7-3			; %t0 = 0:0000rrrr
;;	xand  %t0, %t0, CF		; %t0 = 0:0000r000
;;	or    %F, %t0			; %F  = F(0000C0ZS)
;;	ld.ub %a0, %a0			; %a0 = 0:rrrrrrrC (unsigned)
;;	ext z80cpu_parity@ah		; %t0 = F(00000P00)
;;	ext z80cpu_parity@al
;;	ld.ub %t0, [%a0]
;;	ret.d
;;	or    %F, %t0			; %F  = F(0000CPZS) *delay*
;;͂ɍ܂BԂvƎvǁA΂炭lqłB
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	ld.w  %t1, %a0			; %t1 = 0:rrrrrrrr
	xsll  %a0, 1			; %a0 = r:rrrrrrr0          -+- ̓stɂƊԈႢłB
	ld.b  %a0, %a0			; %a0 = ?:rrrrrrr0 (signed) -+  tɂȂ悤ӂĂ!!
	xsrl  %t1, 7			; %t1 = 0:0000000r
	or    %a0, %t1			; %a0 = ?:rrrrrrrr (signed)
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsrl  %t0, 7-3			; %t0 = 0:0000rrrr
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:rrrrrrrC (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	RR r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 0 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	RR r
;
	.global z80cpu_rr
z80cpu_rr:
;;	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
;;	xsrl  %a0, 1			; %a0 = 0:0rrrrrrr
;;	xand  %F, %F, CF		; %F  = 0:0000C000
;;	xsll  %F, 7-3			; %F  = 0:C0000000
;;	or    %a0, %F			; %a0 = 0:Crrrrrrr
;;	ld.b  %a0, %a0			; %a0 = ?:Crrrrrrr (signed)
;;	or    %a0, %a0			; (%psr֔f邽߂ɕKvł)
;;	;
;;	ld.w  %F, %psr			; %F  = F(000000ZS)
;;	and   %F, ZF|SF
;;	xsll  %t0, 3-0			; %t0 = r:rrrrr000
;;	xand  %t0, %t0, CF		; %t0 = 0:0000r000
;;	or    %F, %t0			; %F  = F(0000C0ZS)
;;	ld.ub %a0, %a0			; %a0 = 0:Crrrrrrr (unsigned)
;;	ext z80cpu_parity@ah		; %t0 = F(00000P00)
;;	ext z80cpu_parity@al
;;	ld.ub %t0, [%a0]
;;	ret.d
;;	or    %F, %t0			; %F  = F(0000CPZS) *delay*
;;͂ɍ܂BԂvƎvǁA΂炭lqłB
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	xsrl  %a0, 1			; %a0 = 0:0rrrrrrr
	xand  %F, %F, CF		; %F  = 0:0000C000
	xsll  %F, 7-3			; %F  = 0:C0000000          -+- ̓stɂƊԈႢłB
	ld.b  %F, %F			; %F  = ?:C0000000 (signed) -+  tɂȂ悤ӂĂ!!
	or    %a0, %F			; %a0 = ?:Crrrrrrr (signed)
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsll  %t0, 3-0			; %t0 = r:rrrrr000
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:Crrrrrrr (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	RRC r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 0 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	RRC r
;
	.global z80cpu_rrc
z80cpu_rrc:
;;	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
;;	ld.w  %t1, %a0			; %t1 = 0:rrrrrrrr
;;	xsrl  %a0, 1			; %a0 = 0:0rrrrrrr
;;	xsll  %t1, 7			; %t1 = r:r0000000
;;	or    %a0, %t1			; %a0 = r:rrrrrrrr
;;	ld.b  %a0, %a0			; %a0 = ?:rrrrrrrr (signed)
;;	or    %a0, %a0			; (%psr֔f邽߂ɕKvł)
;;	;
;;	ld.w  %F, %psr			; %F  = F(000000ZS)
;;	and   %F, ZF|SF
;;	xsll  %t0, 3-0			; %t0 = r:rrrrr000
;;	xand  %t0, %t0, CF		; %t0 = 0:0000r000
;;	or    %F, %t0			; %F  = F(0000C0ZS)
;;	ld.ub %a0, %a0			; %a0 = 0:Crrrrrrr (unsigned)
;;	ext z80cpu_parity@ah		; %t0 = F(00000P00)
;;	ext z80cpu_parity@al
;;	ld.ub %t0, [%a0]
;;	ret.d
;;	or    %F, %t0			; %F  = F(0000CPZS) *delay*
;;͂ɍ܂BԂvƎvǁA΂炭lqłB
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	ld.w  %t1, %a0			; %t1 = 0:rrrrrrrr
	xsrl  %a0, 1			; %a0 = 0:0rrrrrrr
	xsll  %t1, 7			; %t1 = r:r0000000          -+- ̓stɂƊԈႢłB
	ld.b  %t1, %t1			; %t1 = ?:r0000000 (signed) -+  tɂȂ悤ӂĂ!!
	or    %a0, %t1			; %a0 = ?:rrrrrrrr (signed)
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsll  %t0, 3-0			; %t0 = r:rrrrr000
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:Crrrrrrr (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	SLA r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 7
;
; [in]
;	%a0	r
; [out]
;	%a0	SLA r
;
	.global z80cpu_sla
z80cpu_sla:
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	xsll  %a0, 1			; %a0 = r:rrrrrrr0
	ld.b  %a0, %a0			; %a0 = ?:rrrrrrr0 (signed)
	or    %a0, %a0			; (%psr֔f邽߂ɕKvł)
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsrl  %t0, 7-3			; %t0 = 0:0000rrrr
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:rrrrrrr0 (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	SRA r
;
;	S	is set if result is negative, reset otherwise
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 0 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	SRA r
;
	.global z80cpu_sra
z80cpu_sra:
	ld.w  %t0, %a0			; %t0 = 0:rrrrrrrr
	ld.b  %a0, %a0			; %a0 = ?:rrrrrrrr (signed) -+- ̓stɂƊԈႢłB
	xsra  %a0, 1			; %a0 = ?:?rrrrrrr (signed) -+  tɂȂ悤ӂĂ!!
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsll  %t0, 3-0			; %t0 = r:rrrrr000
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ld.ub %a0, %a0			; %a0 = 0:?rrrrrrr (unsigned)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;
;	SRL r
;
;	S	is reset
;	Z	is set if result is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is data from bit 0 of source register
;
; [in]
;	%a0	r
; [out]
;	%a0	SRL r
;
	.global z80cpu_srl
z80cpu_srl:
	ld.w %t0, %a0			; %t0 = 0:rrrrrrrr
	xsrl %a0, 1			; %a0 = 0:0rrrrrrr
	;
	ld.w  %F, %psr			; %F  = F(000000ZS)
	and   %F, ZF|SF
	xsll  %t0, 3-0			; %t0 = r:rrrrr000
	xand  %t0, %t0, CF		; %t0 = 0:0000r000
	or    %F, %t0			; %F  = F(0000C0ZS)
	ext z80cpu_parity@ah		; %t0 = F(00000P00)
	ext z80cpu_parity@al
	ld.ub %t0, [%a0]
	ret.d
	or    %F, %t0			; %F  = F(0000CPZS) *delay*

;****************************************************************************
;	Bit Set, Reset, and Test Group
;****************************************************************************

;
;	BIT b, r
;
;	S	is unknown
;		  Undoc'd
;		  (b=7)(r[7]=1)̏ꍇsetAȂreset܂B
;		  SG-1000p`bvt^[́A̋ɈˑĂ܂B
;	Z	is set if specified bit is 0, reset otherwise
;	H	is set
;	P/V	is unknown
;		  Undoc'd
;		  ZtOƓlɂȂ܂B
;	N	is reset
;	C	is not affected
;
; [in]
;	%a0	b
;	%a1	r
;
	.global z80cpu_bit
z80cpu_bit:
	xand  %F, %F, CF		; %F = F(00C000)
	xadd  %F, %F, HF		; %F = F(0HC000)
	;
	xld.w %t0, 1<<24		; %t0[31:24] = 1<<b
	sll   %t0, %a0			; (0%a07Ȃ̂ŁAxsll͕Kv܂)
	swap  %a1, %a1			; %a1[31:24] = r
	and   %a1, %t0			; %a1[31:24] = r&(1<<b)
	;
	ld.w  %t0, %psr
	jrne.d 3
	and   %t0, ZF|SF		; %t0 = F(0000ZS) *delay*
	add   %t0, PF			; %t0 = F(000PZS) (skip?)
	;
	ret.d
	or    %F, %t0			; %F  = F(0HCPZS) *delay*

;****************************************************************************
;	Input and Output Group
;****************************************************************************

;
;	IN r, (C)
;
;	S	is set if input data is negative, reset otherwise
;	Z	is set if input data is zero, reset otherwise
;	H	is reset
;	P/V	is set if parity is even, reset otherwise
;	N	is reset
;	C	is not affected
;
; [out]
;	%a0	r
;
; [note]
;	* %a0  %r10 ̕ʖłB
;	  Ĕj󂵂Ȃ悤AӂĂB
;
	.global z80cpu_in
z80cpu_in:
	xsub   %sp, %sp, 8
	xld.w [%sp+0], %s0		; %r6ޔ
	xld.w [%sp+4], %s1		; %r7ޔ
	;
	xld.w  %r11, [%CPU+IN]		; %r11 = IN
	xld.uh %r12, [%CPU+BC]		; %r12 = BC (AhXoXbit15-8ɂBWX^̒lo͂܂)
	call   %r11			; %r10 = IN (C)
	ld.ub  %a0, %r10		; (߂lbit31-8ClearBKvł!!)
	xld.w  %CPU, z80cpu		; %r4
	xld.w  %MEM, z80mem		; %r5
	;
	xand   %F, %F, CF		; %F  = F(00C000)
	ld.b   %t0, %a0			; %t0 = IN (C) (signed)
	or     %t0, %t0			; (%psr֔f邽߂ɕKvł)
	ld.w   %t0, %psr		; %t0 = F(0000ZS)
	xand   %t0, %t0, ZF|SF
	or     %F, %t0			; %F  = F(00C0ZS)
	ext z80cpu_parity@ah		; %t0 = F(000P00)
	ext z80cpu_parity@al
	ld.ub  %t0, [%a0]
	or     %F, %t0			; %F  = F(00CPZS)
	;
	xld.w  %s0, [%sp+0]		; %r6
	xld.w  %s1, [%sp+4]		; %r6
	xadd   %sp, %sp, 8
	ret

;
;	OUT (C), r
;
;	Condition Bits Affected: None
;
; [in]
;	%a0	r
;
; [note]
;	* %a0  %r10 ̕ʖłB
;	  Ĕj󂵂Ȃ悤AӂĂB
;
	.global z80cpu_out
z80cpu_out:
	xsub   %sp, %sp, 8
	xld.w [%sp+0], %s0		; %r6ޔ
	xld.w [%sp+4], %s1		; %r7ޔ
	;
	xld.w  %r11, [%CPU+OUT]		; %r11 = OUT
	xld.uh %r12, [%CPU+BC]		; %r12 = BC (AhXoXbit15-8ɂBWX^̒lo͂܂)
	call.d %r11			; OUT (C), r
	ld.w   %r13, %a0		; %r13 = r *delay*
	xld.w  %CPU, z80cpu		; %r4
	xld.w  %MEM, z80mem		; %r5
	;
	xld.w  %s0, [%sp+0]		; %r6
	xld.w  %s1, [%sp+4]		; %r6
	xadd   %sp, %sp, 8
	ret

;****************************************************************************
;	
;****************************************************************************
