/*	
 *	clipsort.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2010 Naoyuki Sawa
 *
 *	* Fri Apr 13 00:10:09 JST 2007 Naoyuki Sawa
 *	- VK쐬B
 *	* Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
 *	- ɐ[ċAĂяoꍇ̂h߂̕ύXs܂B
 *	* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
 *	- [vꂩAwhile(){...}do{...}while()ɕύXA܂B
 *	* Sun May 13 14:21:21 JST 2007 Naoyuki Sawa
 *	- q[v\[g̎ǉ܂B
 *	  RgAEgĂ܂̂ŁACuvÔɂ͕ω܂B
 *	* Mon Oct 18 21:09:33 JST 2010 Naoyuki Sawa
 *	- msort()ǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	NBbN\[g
 *****************************************************************************/

/* * WCCuEPSONqsort()u܂B
 * - EPSONqsort()ɕs킯ł͖̂ŁÂ܂܂ł삵܂B
 *   AEPSONqsort()ɂ͏ʂȏ܂܂ĂāATCYƎsxɖʂ܂B
 *   NBbN\[gASY̕׋˂āACLiPłĂ݂邱Ƃɂ܂B
 *   قƂEPSONqsort()ƓŁAꕔ̖ʂȏ폜(֐̃RgQ)łB
 * - EPSONŁCLiPłւ̒uɂATCYߖƍ̌ʂ́Aȉ̂ƂłB
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 128oCg (68oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1682~b (10%)
 * * Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
 * - ɐ[ċAĂяoꍇ̂h߂̕ύXsƂɂA
 *   TCYƑx̓ς܂B
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 140oCg (56oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1645~b (11%)
 * * Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
 * - [vꂩAwhile(){...}do{...}while()ɕύXA܂B
 *   킸ɑȂǁATCY͌܂łB
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 140oCg (56oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1642~b (11%)
 */

static void
xchg(unsigned char* p1, unsigned char* p2, int size) {
#if 0
//	int tmp;
//	do {
//		tmp = *p1;
//		      *p1++ = *p2;
//		              *p2++ = tmp;
//	} while(--size);
#else
	asm("
	ld.ub	%r4, [%r12]
	ld.ub	%r5, [%r13]
	ld.b	[%r13]+, %r4	; *anti-interlock*
	ld.b	[%r12]+, %r5
	sub	%r14, 1
	jrne	-5
	");
#endif
}

//-------------------------------------------------------------------------------------------------------------
//void
//qsort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*))
//{
//	unsigned char* pv;	/* s{bgւ̃|C^ */
//	unsigned char* lo;	/* ʃ|C^ (ɒʗvf(s{bgȉ̗vf)i[ʒuւ̃|C^) */
//	unsigned char* hi;	/* ʃ|C^ (ɍʗvf(s{bg߂̗vf)i[ʒuւ̃|C^) */
//	int lo_cnt;		/* ʗvf */
//	int hi_cnt;		/* ʗvf */
//
//	/* vf0܂1Ȃ΁AɋA܂B
//	 * - EPSONł́A2vf̏ꍇʈāAPȔrƓւsĂ܂A̕Kv͂܂B
//	 *   2vf̏ꍇAȏ̗vf̏ꍇƓAʏ̏őΉł܂B
//	 */
//	if(num <= 1) {
//		return;
//	}
//
//	/* |C^Ɨvf܂B
//	 * - EPSONł́Az̒t߂Ɛ擪̗vfւAƂƒt߂ɂls{bgƂĂ܂B
//	 *   炠xɕłƉ肵āAt߂ɒl邱Ƃ҂Ă̂Ǝv܂B
//	 *   ۂɂ͂܂ʂAނ]vȓւ̉񐔂镪A\𗎂ƂĂ悤łB
//	 *   CLiPłł́APɐ擪̗vfs{bgƂč̗p邱Ƃɂ܂B
//	 */
//	pv = base;			/* s{bg     = 擪 */
//	lo = pv + width;		/* ʃ|C^ = s{bg̎ */
//	hi = pv + width * (num - 1);	/* ʃ|C^ =  */
//	lo_cnt = 0;			/* ʗvf   = 0 */
//	hi_cnt = 0;			/* ʗvf   = 0 */
//
//	/* ʃ|C^ƍʃ|C^܂...(As{bgȊȎSvf̒orʂm肷܂)
//	 * - (num-1)̃JEg_EŃ[v@łʂ𓾂܂A(lo<=hi)Ń[vA
//	 *   numϐ̐ԂZAϐ̃WX^蓖čœKLɓƂ҂ł܂B
//	 */
//	while(lo <= hi) { /* !!(lo<hi)ł͂܂!! */
//		/* ʃ|C^̈ʒuɗLvfAs{bgƔr܂B */
//		if(compare(lo, pv) <= 0) {
//			/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
//			 * ʃ|C^̎̈ʒuɗLvfA̔rΏۂƂȂ܂B
//			 */
//			lo += width;
//			lo_cnt++;
//		} else {
//			/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
//			 * ʃ|C^̈ʒuɗLvfA̔rʒuɈړ܂B
//			 */
//			xchg(lo, hi, width);
//			hi -= width;
//			hi_cnt++;
//		}
//	}
//
//	/* ȏ̏I_[s{bg,[ʗvf̕],[ʗvf̕]]ƂȂĂ܂B
//	 * [[ʗvf̕],s{bg,[ʗvf̕]]ƓւāAs{bg̈ʒum肵܂B
//	 * - ւɒʗvf̕яω܂A܂яɈӖ͂Ȃ̂ŁAvłB
//	 * - ʗvfꍇApv==hiƂȂĂāAxchg()̓_~[ƂȂ܂B
//	 */
//	xchg(pv, hi, width);
//
//	/* [ʗvf̕]\[g܂B */
//	qsort(pv, lo_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
//
//	/* [ʗvf̕]\[g܂B */
//	qsort(lo, hi_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
//}
//-------------------------------------------------------------------------------------------------------------
//* Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
//- ɐ[ċAĂяoꍇ̂h߂̕ύXs܂B
//- ̃RgAEǵANCbN\[ĝ΂fȎłB
//  ASYIɂ͂̂܂܂łԈႢł͂܂񂪁Aɐ[ċAĂяoꍇƂ肪܂B
//- ǂ̂悤ȃP[XŔɐ[ċAĂяo邩ƂƁA炩߃\[gꂽ\[g悤ƂꍇłB
//
//	<>	̂悤ȌĂяosꍇlĂ݂܂B
//
//			int array[10000] = { 1,2,3,...,10000 };
//			qsort(array, 10000, sizeof(int), compare);
//
//		ŏ̌ĂяoxŁA[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],1,[2,3,4,...,10000]]	(Ăяo̐[=1)
//
//		[ʗvf̕]ɑ΂ċAĂяoɒڂƁÃxŁA[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],2,[3,4,5,...,10000]]	(Ăяo̐[=2)
//
//		Ɏ̃xł́A[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],3,[4,5,6,...,10000]]	(Ăяo̐[=3)
//
//		Ōɂ́AȂ܂B
//
//			[[()],10000,[()]]	(Ăяo̐[=10000)
//
//		ȏ̗̂悤ɁA炩߃\[gꂽ\[g悤ƂƁAɐ[ċAĂяoꍇ܂B
//		̒NƂƁAőNx̍ċAĂяo܂B(炩ߊSɃ\[gĂ鐔\[g悤Ƃꍇ)
//		炩ߊSɃ\[gĂ鐔Ɍ炸ƂAx\[gĂ΂قǁAċAĂяo[Ȃ\܂B
//
//		ۂɂǂ̂炢[Ȃ邩͐̏ԂɈˑAqsort()sĂ݂܂ł킩Ȃ̂ŁA댯łB
//		ɁAP/ECÊ悤ȃX^bN̈̏ȎsŗpꍇɊ댯łB
//
//- q̖P@́Aȉ̂ƂłB
//	E[ʗvf̕][ʗvf̕]̂AvfȂċAĂяoŃ\[g܂B
//	Evf́Ǎ݂Ăяox̂܂܁Aŏ珈JԂƂŃ\[g܂B
//  ̂悤ɕύX邱ƂŁAċAĂяo̍ő[Aňł log2(N) ɗ}܂B
//- Ƃ΁A10000vf̐\[gꍇAPO͍ň10000x̍ċAĂяoĂ܂AP͍ňł14xɗ}܂B
//  \[gΏۂ̌IȒlƁA20xȏ̍ċAĂяo󋵂͂قڗL蓾Ȃƍl̂ŁAP/ECEł[ɈSłB
//- Aq̉P͂܂ł(=ċAĂяox)Ɋւ̂łAԌ͉PȂƂɒӂĂB
//  10000vfintz\[g鎞ԂvĂ݂ƁA_ȂΖ1600~błA炩߃\[gĂƖ15300~b܂B
//
//	[QlFP.J.vEK[uWbCu ANSI/ISO/JIS CKivigbpj 411`412y[W {]
void
qsort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*))
{
	unsigned char* pv;	/* s{bgւ̃|C^ */
	unsigned char* lo;	/* ʃ|C^ (ɒʗvf(s{bgȉ̗vf)i[ʒuւ̃|C^) */
	unsigned char* hi;	/* ʃ|C^ (ɍʗvf(s{bg߂̗vf)i[ʒuւ̃|C^) */
	int lo_cnt;		/* ʗvf */
	int hi_cnt;		/* ʗvf */

	/* vf0܂1Ȃ΁AɋA܂B
	 * - EPSONł́A2vf̏ꍇʈāAPȔrƓւsĂ܂A̕Kv͂܂B
	 *   2vf̏ꍇAȏ̗vf̏ꍇƓAʏ̏őΉł܂B
	 */
	while(num >= 2) {
		/* |C^Ɨvf܂B
		 * - EPSONł́Az̒t߂Ɛ擪̗vfւAƂƒt߂ɂls{bgƂĂ܂B
		 *   炠xɕłƉ肵āAt߂ɒl邱Ƃ҂Ă̂Ǝv܂B
		 *   ۂɂ͂܂ʂAނ]vȓւ̉񐔂镪A\𗎂ƂĂ悤łB
		 *   CLiPłł́APɐ擪̗vfs{bgƂč̗p邱Ƃɂ܂B
		 */
		pv = base;			/* s{bg     = 擪 */
		lo = pv + width;		/* ʃ|C^ = s{bg̎ */
		hi = pv + width * (num - 1);	/* ʃ|C^ =  */
		lo_cnt = 0;			/* ʗvf   = 0 */
		hi_cnt = 0;			/* ʗvf   = 0 */

		/* ʃ|C^ƍʃ|C^܂...(As{bgȊȎSvf̒orʂm肷܂)
		 * - (num-1)̃JEg_EŃ[v@łʂ𓾂܂A(lo<=hi)Ń[vA
		 *   numϐ̐ԂZAϐ̃WX^蓖čœKLɓƂ҂ł܂B
		 */
		//while(lo <= hi) { /* !!(lo<hi)ł͂܂!! */
		//* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
		//- (num>=2)̏菉͕K(lo<=hi)ƂȂ̂ŁAwhile(){...}Ido{...}while()ɑւ܂B
		do {
			/* ʃ|C^̈ʒuɗLvfAs{bgƔr܂B */
			if(compare(lo, pv) <= 0) {
				/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
				 * ʃ|C^̎̈ʒuɗLvfA̔rΏۂƂȂ܂B
				 */
				lo += width;
				lo_cnt++;
			} else {
				/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
				 * ʃ|C^̈ʒuɗLvfA̔rʒuɈړ܂B
				 */
				xchg(lo, hi, width);
				hi -= width;
				hi_cnt++;
			}
		//}
		//* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
		//- (num>=2)̏菉͕K(lo<=hi)ƂȂ̂ŁAwhile(){...}Ido{...}while()ɑւ܂B
		} while(lo <= hi); /* !!(lo<hi)ł͂܂!! */

		/* ȏ̏I_[s{bg,[ʗvf̕],[ʗvf̕]]ƂȂĂ܂B
		 * [[ʗvf̕],s{bg,[ʗvf̕]]ƓւāAs{bg̈ʒum肵܂B
		 * - ւɒʗvf̕яω܂A܂яɈӖ͂Ȃ̂ŁAvłB
		 * - ʗvfꍇApv==hiƂȂĂāAxchg()̓_~[ƂȂ܂B
		 */
		xchg(pv, hi, width);

		/* [ʗvf̕][ʗvf̕]̂AvfȂċAĂяoŃ\[g܂B
		 * vf́Ǎ݂Ăяox̂܂܁Aŏ珈JԂƂŃ\[g܂B
		 * - ċAĂяoŃ\[gƁAɐ[ċAĂ܂ꍇh߂łB
		 *   ̓Iɂ́Å֐̏ɏRgQƂĂB
		 */
		if(lo_cnt <= hi_cnt) {
			/* [ʗvf̕]\[g܂B */
			qsort(pv, lo_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
			/* [ʗvf̕]\[g܂B */
			base = lo, num = hi_cnt;           /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
		} else {
			/* [ʗvf̕]\[g܂B */
			qsort(lo, hi_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
			/* [ʗvf̕]\[g܂B */
			base = pv, num = lo_cnt;           /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
		}
	}
}

/*****************************************************************************
 *	q[v\[g
 *****************************************************************************/

#if 0	/*{{q[v\[g̎*/

* Sun May 13 14:21:21 JST 2007 Naoyuki Sawa
- uq[v\[g - Wikipediav̋[R[hQlɁAœKč쐬܂B
  (URL: http://ja.wikipedia.org/w/index.php?title=%E3%83%92%E3%83%BC%E3%83%97%E3%82%BD%E3%83%BC%E3%83%88&oldid=12248591)
  œKȓ_́Aeq̗vfw߂̃CfNXg킸ɁAׂă|C^ŏč}ƂłB
- q[v\[gNBbN\[gDĂ_́Af[^̂肪xɂ܂eȂƂłB
  NBbN\[ǵAlɃ_Ȑ̃\[g΂񑁂AX̃\[g͒xAt̃\[gƂxłB
  q[v\[ǵAǂ̃P[Xɑ΂Ă悻炢̑xŊ܂B
- ۂɂ́ANBbN\[gq[v\[gIʂ͖Ǝv܂B
  NBbN\[gɕsȋt̃\[głĂANBbN\[g̕q[v\[g{炢ł悤łB
  lɃ_Ȑ̃\[g̏ꍇ́A50{ȏ̑xtĂ܂܂B
  (WindowsŎꍇ͂܂ł̑x͕tȂ̂łAP/ECEł͂Ȃq̂悤ȑ卷ɂȂĂ܂܂B)
- ȉ̃R[h́AƂmFς݂łAۂɎgƂ͖Ǝv܂B
  NTCYȂ悤ɃRgAEgĂ܂̂ŁAgꍇ̓AvP[VɃRs[ĎgĂB

static void
make_heap(unsigned char* base, unsigned char* last, size_t width, int (*compare)(const void*, const void*), unsigned char* parent)
{
	unsigned char* child1;
	unsigned char* child2;

	/* ̎qL... */
	child1 = (base + (parent - base) * 2) + width;
	if(child1 <= last) {
		/* ̎q̃c[\[g܂B */
		make_heap(base, last, width, compare, child1);
		/* E̎qL... */
		child2 = child1 + width;
		if(child2 <= last) {
			/* E̎q̃c[\[g܂B */
			make_heap(base, last, width, compare, child2);
			/* child1傫̎qw悤ɂ܂B */
			if(compare(child1, child2) < 0) {
				child1 = child2;
			}
		}
		/* 傫̎qe傫... */
		if(compare(parent, child1) < 0) {
			/* 傫̎qƐeւ܂B */
			xchg(parent, child1, width);
			//make_heap(base, last, width, compare, child1);
			//q̃c[̃\[g͎ɍŝŕsvłB
		}
	}
}

void
hsort(void* _base, size_t num, size_t width, int (*compare)(const void*, const void*))
{
	unsigned char* base = _base;
	unsigned char* last = base + (width * (num - 1));

	while(base < last) {
		/* c[Ŝ~Ƀ\[g܂B */
		make_heap(base, last, width, compare, base);
		/* ővfc[̖ɐ؂藣܂B */
		xchg(base, last, width);
		last -= width;
	}
}

#endif	/*}}q[v\[g̎*/

/*****************************************************************************
 *	}[W\[g
 *****************************************************************************/

/* * Mon Oct 18 15:12:52 JST 2010 Naoyuki Sawa
 * - msort()֐ۂɎQlɂWebTCgAeLXgċL^ĂƂɂ܂B
 *   wil`wɂjASYIɂ郆[U[C^[tF[X̉ǁx̒́A
 *   @(http://www.th.cs.meiji.ac.jp/researches/2005/omoto/index.html)
 *   u8. }[W\[gṽy[WApĂ܂B
 *   @(http://www.th.cs.meiji.ac.jp/researches/2005/omoto/mergesort.html)
 * - ʓIɃ}[W\[ǵAċApĎ̂łǁALTCg̃Tv\[X́AċApȂŎĂ܂B
 *   ܂Amۂ̎dg݂₷A\[X̌ꂽ}CR̎Ǝv܂B
 * 
 * 	
 * 	}[W\[g														
 * 	
 * 
 * 	
 * 	}[W\[gƂ́H													
 * 	
 * 
 * 	}[W\[ǵAf[^ɕAĂу}[Wijɑ傫̏Ƀf[^oĕׂB
 * 	ꂽꂼꂪ傫̏ɕł΃}[Ŵ傫̏ɕԂ̂ŁAꂽ̂ɑ΂Ă
 * 	}[W\[giȂ̃\[gcႦΕ̃f[^QƂR̏ꍇ͒PȔrōςށjċAIɓKpΗǂB
 * 	\[grIŁAʂ̂̂̏ۑƂB
 * 
 * 	
 * 	l														
 * 	
 * 
 * 	oƂẮAuQ{̔zpӂAꂽm[h\[gsvƂłB
 * 
 * 	Â悤Ȕz񂪑݂ƂB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		@@@@@@@@
 * 		
 * 
 * 	ׂĂ̂A܂AQŕB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		@@@@@@@@
 * 		
 * 
 * 	ꂽ͈͓ŁAPpӂꂽzɃ\[glĂB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		@@@@@@@@@@@@
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ɐVlێz𕪊̂AQ~QSŕB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ꂽ͈͓ŁA̔zɃ\[glĂB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		@@@@@@@@@@@@@@
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ɐVlێ̔z𕪊BS~QWŕB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ꂽ͈͓ŁAPpӂꂽzɃ\[glĂB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		@@@@@@@@@@@@@@@
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	ɐVlێz𕪊̂AvfWł̂łWŕB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	ꂽ͈͓ŁA̔zɃ\[glĂB
 * 
 * 		
 * 		PQRSUVWX
 * 		
 * 		@@@@@@@@@@@@@@@
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	̔z𕪊ۂɁA͈̔͂vf𒴂ĂꍇA\[gIƂȂB
 * 
 * 	ȏオ}[W\[g̗łB
 * 
 * 	}[W\[g̃ASY͈ȉ̂悤ɋLqłB
 * 
 * 		void sort() {							// }[W\[g()
 * 			int seqsize = 1;					// 傫̏l1Ƃ
 * 			while (seqsize < length) {				// \[g傫f[^΁C
 * 				mergeseqs(seqsize, a, b);			// w肳ꂽ傫Ŕzazbփ}[W
 * 				mergeseqs(2 * seqsize, b, a);			// w肳ꂽ2{̑傫Ŕzbzaփ}[W
 * 				seqsize = 4 * seqsize;				// 傫4{ɂD
 * 			}
 * 		}
 * 
 * 		void mergeseqs(int size, int from [], int to []) {		// fromz񂩂}[Wtoz
 * 			int i, j, k, iend, jend;
 * 			int start = 0;
 * 			while (start < length) {
 * 				i = start;					// i: }[W̎n܂
 * 				j = start + size;				// j: }[W̗̎n܂
 * 				k = start;					// k: }[Wʂ̗̎n܂
 * 				iend = Math.min(start + size, length);		// ΏۂƂzvf̍ŌvZ
 * 				jend = Math.min(start + 2 * size, length);	// ΏۂƂzvf̍ŌvZ
 * 				while (i < iend && j < jend) {			// }[W2ꍇ
 * 					if (from[i] <= from[j]) {
 * 						to[k] = from[i];		// l̕Rs[
 * 						i++;
 * 						k++;
 * 					} else {
 * 						to[k] = from[j];		// l̕Rs[
 * 						j++;
 * 						k++;
 * 					}
 * 				}
 * 				while (i < iend) {				// }[W1̏ꍇ
 * 					to[k] = from[i];			// l̃Rs[
 * 					i++;
 * 					k++;
 * 				}
 * 				while (j < jend) {				// }[W1̏ꍇ
 * 					to[k] = from[j];			// l̃Rs[
 * 					j++;
 * 					k++;
 * 				}
 * 				start = start + 2 * size;			// VȊJn_ݒ
 * 			}
 * 		}
 * 
 * 	vOp
 * 	Lecture of Computer Programming I by Hiroshi Ichiji 
 * 	(http://lecture.ecc.u-tokyo.ac.jp/~cichiji/cp-01/cp-01.html)
 */

static void
mergeseqs(size_t size, const unsigned char* from, unsigned char* to, size_t length, size_t width, int (*compare)(const void*, const void*))
{
	size_t i;
	size_t j;
	size_t k;
	size_t iend;
	size_t jend;

	for(jend = 0; jend < length; /** no job **/) {
		i    = k = jend;
		iend = j = i + size;
		jend     = j + size;
		if(iend > length) {
			iend = length;
		}
		if(jend > length) {
			jend = length;
		}
		while((i < iend) && (j < jend)) {
			if(compare(&from[i * width], &from[j * width]) <= 0) {
				memcpy(&to[k++ * width], &from[i++ * width], width);
			} else {
				memcpy(&to[k++ * width], &from[j++ * width], width);
			}
		}
		if(i < iend) {
			memcpy(&to[k * width], &from[i * width], (iend - i) * width);
		}
		if(j < jend) {
			memcpy(&to[k * width], &from[j * width], (jend - j) * width);
		}
	}
}

void
msort(void* a, size_t length, size_t width, int (*compare)(const void*, const void*))
{
	void* b;
	size_t seqsize;

	b = malloc(length * width);
	if(!b) {
		DIE();
	}
	for(seqsize = 1; seqsize < length; /** no job **/) {
		mergeseqs(seqsize, a, b, length, width, compare);
		seqsize *= 2;
		mergeseqs(seqsize, b, a, length, width, compare);
		seqsize *= 2;
	}
	free(b);
}

