/*
 *	clipruds.h
 *
 *	pX[^[̑`V[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Thu Apr 24 19:33:48 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Apr 26 09:27:47 JST 2014 Naoyuki Sawa
 *	- V[PTRpC쐬܂Bclip/tool/dRudSeqC/
 *	  ߃R[h`p}Ngăf[^쐬Kv͂܂B
 *	  XNvgāAV[PTRpCŃf[^쐬ĂB
 *	* Mon May 05 19:19:03 JST 2014 Naoyuki Sawa
 *	- cliprudc.c ɒ~㎥ԂǉƂɔAuwait stopv̏ύX܂B
 *	  [ύXO] ~ɂȂ܂ő҂B
 *	  [ύX] ~,,~㎥I܂ő҂B
 */
#ifndef __CLIP_RUDS_H__
#define __CLIP_RUDS_H__

/****************************************************************************
 *	pX[^[̑`V[PT
 ****************************************************************************/
//߃Zbgdl
//
//	[def]	(x)
//
//		goto	(x)
//		call	(x)
//		repeat	[JԂ]		ȗl=0()
//
//		speed	()
//		[move]	init
//		move	rel	(Έʒu)
//		move	[abs]	(Έʒu)
//		[move]	stop
//
//		wait	[rel]	(Ύ)
//		wait	abs	(Ύ)
//		wait	[stop]
//
//		user	(ԍ)
//
//	end					ĐI,call߂,repeat߂Aendŕ\B
//
/*--------------------------------------------------------------------------*/
//߃R[hdl
//
//	end		0000 0000 0000 0000
//	[move] init	0000 0000 0000 0001
//	[move] stop	0000 0000 0000 0010
//	wait  [stop]	0000 0000 0000 0011
//	user       u	0000 0000 0000 0100	AvP[V`(0`4091)						//AV߂ǉKvꍇA͈̔͂߂\
//			0000 1111 1111 1111	
//	goto       s	0001 ssss ssss ssss	s:̖߂̈ʒuƂΈʒu						//u**߂̈ʒuƂΈʒuv*ł͂Ȃ*Ƃɒӂ
//	call       s	0010 ssss ssss ssss	s:̖߂̈ʒuƂΈʒu						//u**߂̈ʒuƂΈʒuv*ł͂Ȃ*Ƃɒӂ
//	repeat    [u]	0011 uuuu uuuu uuuu	u:0=,1`=JԂ
//	speed      u	0100 uuuu uuuu uuuu	u:(0=ő)
//	move  rel  s	0101 ssss ssss ssss	s:Έʒu
//	move [abs] s	0110 ssss ssss ssss	s:Έʒu
//	wait [rel] u	0111 uuuu uuuu uuuu	u:O̖ߊ̑Ύ
//	wait  abs  u	1uuu uuuu uuuu uuuu	u:f[^ĐJn̐Ύ
//
/*--------------------------------------------------------------------------*/
//߃R[h`p}N
#define RudSeq_Inst_end			((0<<12)|      0         )
#define RudSeq_Inst_move_init		((0<<12)|      1         )
#define RudSeq_Inst_move_stop		((0<<12)|      2         )
#define RudSeq_Inst_wait_stop		((0<<12)|      3         )
#define RudSeq_Inst_user(u)		((0<<12)|(((u)+4)&0x0FFF))	//u:0`4091
#define RudSeq_Inst_goto(s)		((1<<12)|( (s)   &0x0FFF))
#define RudSeq_Inst_call(s)		((2<<12)|( (s)   &0x0FFF))
#define RudSeq_Inst_repeat(u)		((3<<12)|( (u)   &0x0FFF))
#define RudSeq_Inst_speed(u)		((4<<12)|( (u)   &0x0FFF))
#define RudSeq_Inst_move_rel(s)		((5<<12)|( (s)   &0x0FFF))
#define RudSeq_Inst_move_abs(s)		((6<<12)|( (s)   &0x0FFF))
#define RudSeq_Inst_wait_rel(u)		((7<<12)|( (u)   &0x0FFF))	//u: 4.096[b]܂őΉ\
#define RudSeq_Inst_wait_abs(u)		((1<<15)|( (u)   &0x7FFF))	//u:32.767[b]܂őΉ\
// * Sat Apr 26 09:27:47 JST 2014 Naoyuki Sawa
// - V[PTRpC쐬܂Bclip/tool/dRudSeqC/
//   ߃R[h`p}Ngăf[^쐬Kv͂܂B
//   XNvgāAV[PTRpCŃf[^쐬ĂB
/*--------------------------------------------------------------------------*/
#define RudSeqCh_Max RudCtlCh_Max	/* V[PT`lԍ̍ől(̒l܂) */					//i``lԍ`V[PT`lԍjƂO
#define RudSeqCh_StackSize 4		/* X^bTCY */		//
/*--------------------------------------------------------------------------*/
/* X^bN */
typedef struct _ST_RudSeqCh_Stack {
	const uint16_t* pInst;		/* ߂̖߃|C^ */								//ucall,repeat̖̎߁v*ł͂Ȃ*Aucall,repeatߎgvwBend߂ɂ߂菈ɁA̖߂֐i߂B̓słB
	int16_t Repeat;			/* 0=CallX^bN,0ȊO=RepeatX^bN̎cJԂ(=) */
} ST_RudSeqCh_Stack;
/*--------------------------------------------------------------------------*/
/* `V[PT`l */
typedef struct _ST_RudSeqCh {
	const uint16_t* pInst;		/* Ɏs閽߃|C^ */
	uint16_t AbsTime;		/* f[^ĐJn̐Ύ */
	uint16_t RelTime;		/* O̖ߊ̑Ύ */
	uint16_t Speed;			/* (0=ő) */
	uint8_t StackLevel;		/* X^bNx(0`RudSeqCh_StackSize) */
	ST_RudSeqCh_Stack TBL_Stack[RudSeqCh_StackSize];	/* X^bN */
} ST_RudSeqCh;
/*--- O[o֐ ---*/
void RudSeqCh_Play(int iRudSeqCh, const uint16_t* pInst);
void RudSeqCh_Stop(int iRudSeqCh);
/*--------------------------------------------------------------------------*/
/* `V[PT */
typedef struct _ST_RudSeq {
	void (*fnUser)(int iRudSeqCh, int no);		/* AvP[V`ߏ֐(AvP[V`) */
	ST_RudSeqCh TBL_RudSeqCh[RudSeqCh_Max+1];	/* `V[PT`l */
} ST_RudSeq;
/*--- O[oϐ ---*/
extern ST_RudSeq stRudSeq;
/*--- O[o֐ ---*/
void RudSeq_Init(void (*fnUser)(int iRudSeqCh, int no));
void RudSeq_Stop();
void RudSeq_Exec();

#endif/*__CLIP_RUDS_H__*/
