/*
 *	clipleds.c
 *
 *	LEDV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sat Aug 31 17:23:06 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Oct 25 23:11:56 JST 2013 Naoyuki Sawa
 *	- LedSeq_PlaySub()̃oOC܂B
 *	* Fri Apr 04 23:43:32 JST 2014 Naoyuki Sawa
 *	- LedSeq_SetChAtt(),LedSeq_DirectNum()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/

static ST_LedSeq stLedSeq;

/****************************************************************************
 *	[J֐錾
 ****************************************************************************/

static uint8_t LedSeq_PlaySub(ST_LedSeqCh* pLedSeqCh, uint8_t IntroLoop);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* LEDV[PT܂B
 * [in]
 *	pSetup		LEDfoCXPxZbgAbv֐(NULL=s)
 * [note]
 *	- LEDfoCXPxZbgAbv֐͎wK{Ƃ܂B
 *	  LEDfoCXPxZbgAbv֐w肹ɁALEDV[PT𗘗p邱Ƃ́AӖł邩łB
 */
void LedSeq_Init(void (*pSetup)(const uint8_t* pBuffer)) {
	uint16_t iLedDec;
	/* LEDfoCXPxZbgAbv֐ł邱ƂmF܂B */
	if(!pSetup) { DIE(); }	/* oO */
	/* LEDV[PTŜNA܂B */
	memset(&stLedSeq, 0, sizeof stLedSeq);
	/* LEDfoCXPxZbgAbv֐i[܂B */
	stLedSeq.pSetup = pSetup;
	/* LEDfR[_v[܂B */
	for(iLedDec = 0; iLedDec < LedDec_Max; iLedDec++) {	/* Ō̗vf[vɊ܂߂ȂB[v́u<=vłȂu<vłB */
		stLedSeq.LedDec[iLedDec].Next = iLedDec + 1;	/* evfvfփ`FCB */
	}
	stLedSeq.LedDec[iLedDec/*=LedDec_Max*/].Next = 0xFFFF;	/* Ō̗vfI[B */
}

/*--------------------------------------------------------------------------*/

/* LEDV[PT1t[s܂B
 * [note]
 *	- {֐̒ŁALEDfoCXPxZbgAbv֐R[obN܂B
 *	  LEDfoCXPxZbgAbv֐́Anꂽobt@lLEDfoCX֐ݒ肷鏈sĂB
 *	- obt@ĺA1`31͈̔͂łB
 *	  LEDfoCXPxZbgAbv֐́Aobt@lƂ1`31ȊO̒l݂ȂƑz肵č\܂B
 */
void LedSeq_Exec() {
	uint8_t  Buffer[LedDev_Max + 1];
	uint8_t  iLedSeqCh, Value;
	uint16_t nFrameLen[2];
	uint16_t iLedDec, iLedDev;
	uint32_t nDataLen, uData;
	const uint8_t* pData;
	const uint32_t* pTable;
	ST_LedSeqCh* pLedSeqCh;
	ST_LedDec* pLedDec;
	/* WJobt@NA܂B */
	memset(Buffer, 1, sizeof Buffer);	//0ł͂Ȃ1ŃNAB0()͊i[Ȃ̂ŁAʂƂēWJobt@̒l1`31͈̔͂ɂȂBLEDfoCXPxZbgAbv֐́A0̒llȂėǂB
	/* eLEDV[PT`lɂāc */
	for(iLedSeqCh = 0; iLedSeqCh <= LedSeqCh_Max; iLedSeqCh++) {
		/* LEDV[PT`l擾܂B */
		pLedSeqCh = &stLedSeq.LedSeqCh[iLedSeqCh];
		/* ~Ȃ΁A܂B */
		if(!pLedSeqCh->pTable) { continue; }	//Đor~tB[h́ApDatał͂ȂpTableł邱Ƃɒӂ
		/* LEDV[PT`lALEDf[^̐擪AhX擾܂B */
		pData = pLedSeqCh->pData;
		if(!pData) { DIE(); }	/* oO */
		/* LEDf[^ACgt[(2byte)擾܂B */
		nFrameLen[0]  = *pData++;
		nFrameLen[0] |= *pData++ << 8;
		/* LEDf[^A[vt[(2byte)擾܂B */
		nFrameLen[1]  = *pData++;
		nFrameLen[1] |= *pData++ << 8;
		/* LEDV[PT`ĺAt[ԍł邱ƂmF܂B */
		if(pLedSeqCh->Frame >= nFrameLen[pLedSeqCh->IntroLoop]) { DIE(); }	/* oO,,f[^j */	//t[ԍt[ɓBA[v͒~ŝŁAt[ԍt[ɂȂ邱ƂB
		/* LEDV[PT`lALEDfR[_`FC̐擪ԍ擾܂B */
		iLedDec = pLedSeqCh->Root;	//ȂI[(0xFFFF)ł\L܂BLED1f[^̏ꍇÁALEDfR[_v[ōĐJnLEDfR[_`FCmۂłȂꍇB
		/* eLEDɂāc */
		for(;;) {
			/* LEDfR[_`FCI[Ȃ΁A܂B */
			if(iLedDec == 0xFFFF) { break; }	//LEDf[^ɁALEDfR[_`FCI[ɂȂ\L܂BLEDfR[_v[sāALEDfR[_`FCLEDf[^LEDmۂłȂꍇB
			/* LEDfR[_ԍł邱ƂmF܂B */
			if(iLedDec > LedDec_Max) { DIE(); }	/* oO,,f[^j */
			/* LEDf[^ALEDfoCXԍ(2byte)擾܂B */
			iLedDev  = *pData++;
			iLedDev |= *pData++ << 8;
			/* LEDfoCXԍł邱ƂmF܂B */
			if(iLedDev > LedDev_Max) { DIE(); }	/* oO,,f[^j */	//LEDfR[_`FCɁALEDf[^I[ɂȂ邱Ƃ͗L܂B
			/* LEDfR[_擾܂B */
			pLedDec = &stLedSeq.LedDec[iLedDec];
			/* A1ȏȂ΁c */								//
			if(pLedDec->RleLV >= (1<<5)) {								//
				/* A1炵܂B */							//
				pLedDec->RleLV -= (1<<5);							//
			/* A1Ȃ΁c */								//Q:/clip/tool/dpavidot/Sample/2byteRLE/LedConv2.lua,LedTest2.lua
			} else {										//
				/* (A|Px)擾܂B */						//
				pLedDec->RleLV = *pLedDec->pData++;						//
				if(pLedDec->RleLV >= (7<<5)) { pLedDec->RleLV += *pLedDec->pData++ << 5; }	//
			}											//
			/* Px擾A񓧉߂Ȃ΁c */
			Value = pLedDec->RleLV & ((1<<5)-1);
			if(Value) {						//AZu鎞́A
				//Oɏ(1)ȂΤsȂ	//rƃWv́A
				if(Value != 1) {				//ucmp %rX,1vujrlt L_STOREvujreq L_NOSTOREvŏł܂B
					//ʂ29ȉȂ΁c
					if(pLedSeqCh->Att <= 29) {
						//̋Px2(ŏPx)ȏɂB
						Value = ((Value - pLedSeqCh->Att) >= 2) ? (Value - pLedSeqCh->Att) : 2;
					//ʂ30ȏȂ΁c
					} else {
						//̋Px1()ɂB
						Value = 1;
					}
				}
				//PxWJޯ̧֊i[
				Buffer[iLedDev] = Value;
			}
			/* LEDfR[_ALEDfR[_`FC̎ԍ擾܂B */
			iLedDec = pLedDec->Next;
			/* LEDf[^ACg̈kf[^TCY(3byte)擾܂B */
			nDataLen  = *pData++;
			nDataLen |= *pData++ <<  8;
			nDataLen |= *pData++ << 16;
			/* Cg̈kf[^΂܂B */
			pData += nDataLen;
			/* LEDf[^A[v̈kf[^TCY(3byte)擾܂B */
			nDataLen  = *pData++;
			nDataLen |= *pData++ <<  8;
			nDataLen |= *pData++ << 16;
			/* [v̈kf[^΂܂B */
			pData += nDataLen;
		}
		/* LEDV[PT`l̃t[ԍi߁A݂̍Đ̃t[ɓBc */
		if(++pLedSeqCh->Frame >= nFrameLen[pLedSeqCh->IntroLoop]) {
			/* [vJn,,ĊJ܂B[v΁c */
			if(!LedSeq_PlaySub(pLedSeqCh, 1)) {
				/* LEDf[^e[uAvf̒l擾܂B */
				pTable = pLedSeqCh->pTable;	//LedSeq_PlayTable()̏ŊɎvf֐iłB
				uData  = *pTable;
				/* I[łȂ΁c */
				if(uData) {
					/* ߂Ȃ΁ALEDf[^e[ũAhX߂܂B */
					if(uData <= LedTable_RewindMax) { pTable -= uData; }
					/* LEDf[^e[uĐJn܂B */
					LedSeq_PlayTable(iLedSeqCh, pTable);	//pTable͎vf֐iŊi[B
				/* I[Ȃ΁c */
				} else {
					/* LEDV[PT`l~܂B */
					LedSeq_Stop(iLedSeqCh);
				}
			}
		}
	}
	/* eLEDfoCXɂāc */
	for(iLedDev = 0; iLedDev <= LedDev_Max; iLedDev++) {
		/* ڎwPx擾AwLȂΊi[܂B */
		Value = stLedSeq.Direct[iLedDev];
		if(Value) { Buffer[iLedDev] = Value; }
	}
	/* LEDfoCXPxZbgAbv֐֒ʒm܂B */
	(*stLedSeq.pSetup)(Buffer);
}

/*--------------------------------------------------------------------------*/

/* LEDf[^e[uĐJn܂B
 * [in]
 *	iLedSeqCh	LEDV[PT`lԍ(0`LedSeqCh_Max)
 *	_pTable		LEDf[^e[u̐擪AhX
 */
void LedSeq_PlayTable(uint8_t iLedSeqCh, const void* _pTable) {
	uint16_t iLedDec, iLedDev;
	uint32_t nDataLen;
	const uint8_t* pData;
	const uint32_t* pTable = _pTable;
	ST_LedSeqCh* pLedSeqCh;
	ST_LedDec* pLedDec;
	/* LEDV[PT`lԍLEDf[^e[u̐擪AhXł邱ƂmF܂B */
	if((iLedSeqCh > LedSeqCh_Max) || (!pTable)) { DIE(); }
	/* LEDf[^e[u̐擪vf擾Avf֐i߂܂B */
	pData = (const uint8_t*)*pTable++;
	/* LEDf[^e[u̐擪vf́ALLEDf[^łȂ΂܂BI[⊪߂łĂ͂܂B */
	if((uint32_t)pData <= (uint32_t)LedTable_RewindMax) { DIE(); }	/* f[^j */
	/* LEDV[PT`lmɒ~܂B */
	LedSeq_Stop(iLedSeqCh);
	/* LEDV[PT`l擾܂B */
	pLedSeqCh = &stLedSeq.LedSeqCh[iLedSeqCh];
	/* LEDf[^e[ũAhXi[܂B */
	pLedSeqCh->pTable = pTable;	//ɓvfڂ֐iłB
	/* LEDf[^̐擪AhXi[܂B */
	pLedSeqCh->pData = pData;
	/* Cgt[(2byte)ƃ[vt[(2byte)΂܂B */
	pData += (2 + 2);
	/* LEDfR[_v[̃`FC擪ԍ擾܂B */
	iLedDec = stLedSeq.LedDec_Root;		//ȂI[(0xFFFF)ł\L܂BLEDfR[_v[łꍇB
	/* ɁAŌLEDfR[_̃|C^擾܂B */
	pLedDec = NULL;	//ALED1f[^Ȃ΁ANULL̂܂܂ňȉ̃[vIB̂悤ȃf[^͖ʂASLED߃f[^ƂĔ̂ŁAe𓾂ȂB
	/* eLEDɂāc */
	for(;;) {
		/* LEDf[^ALEDfoCXԍ(2byte)擾܂B */
		iLedDev  = *pData++;
		iLedDev |= *pData++ << 8;
		/* LEDf[^I[Ȃ΁A܂B */
		if(iLedDev == 0xFFFF) { break; }
		/* LEDfoCXԍł邱ƂmF܂B */
		if(iLedDev > LedDev_Max) { DIE(); }	/* oO,,f[^j */
		/* LEDfR[_`FCI[Ȃ΁A܂B */
		if(iLedDec == 0xFFFF) { TRACE("LedSeq_Play: LEDfR[_s\n"); break; }	//͂邪Af[^̈ꕔLEDĐȂBLedDec_Max𑝂₷ƂB
		/* LEDfR[_ԍł邱ƂmF܂B */
		if(iLedDec > LedDec_Max) { DIE(); }	/* oO,,f[^j */
		/* LEDfR[_擾܂B */
		pLedDec = &stLedSeq.LedDec[iLedDec];
		/* LEDfR[_ALEDfR[_`FC̎ԍ擾܂B */
		iLedDec = pLedDec->Next;						//pLedDec͂܂ŌLEDfR[_wĂ邪AiLedDecɎ֐i߂ĂB
		/* LEDf[^ACg̈kf[^TCY(3byte)擾܂B */
		nDataLen  = *pData++;
		nDataLen |= *pData++ <<  8;
		nDataLen |= *pData++ << 16;
		/* Cg̈kf[^΂܂B */
		pData += nDataLen;
		/* LEDf[^A[v̈kf[^TCY(3byte)擾܂B */
		nDataLen  = *pData++;
		nDataLen |= *pData++ <<  8;
		nDataLen |= *pData++ << 16;
		/* [v̈kf[^΂܂B */
		pData += nDataLen;
	}
	/* LED1f[^łȂ΁c */
	if(pLedDec) {
		/* LEDV[PT`lgpLEDfR[_`FCALEDfR[_v[mۂ܂B */
		pLedSeqCh->Root = stLedSeq.LedDec_Root;					//
				  stLedSeq.LedDec_Root = pLedDec->Next;			//LEDV[PT`lgpLEDfR[_`FCALEDfR[_v[甲o
							 pLedDec->Next = 0xFFFF;	//
	/* LED1f[^Ȃ΁c */	//́ALEDfR[_v[ōĐJnLEDfR[_`FCmۂłȂꍇApLedDecNULL̂܂܂̏ƂȂB
	} else {
		/* LEDV[PT`ĺALEDfR[_`FC̐擪ԍ𑦏I[܂B */
		pLedSeqCh->Root = 0xFFFF;
	}
	/* CgJn܂BCg΁c */
	if(!LedSeq_PlaySub(pLedSeqCh, 0)) {
		/* [vJn܂B[v΁AG[~܂B */	//Cg[vf[^͋eȂBeƁAĐJnĨP[XlKvAeʂɕGɂȂ邩łB
		if(!LedSeq_PlaySub(pLedSeqCh, 1)) { DIE(); }	/* f[^j */
	}
}

/*--------------------------------------------------------------------------*/

/* LEDf[^ĐJn܂B
 * [in]
 *	iLedSeqCh	LEDV[PT`lԍ(0`LedSeqCh_Max)
 *	_pData		LEDf[^̐擪AhX
 * [note]
 *	- LEDf[^`ɂẮAuclip/tool/dpavidot/Sample/2byteRLE/LedConv2.batvQƂĂB
 */
void LedSeq_Play(uint8_t iLedSeqCh, const void* pData) {
	static uint32_t Table[2];	//[0]ύXLedSeq_PlayTable()ĂяoBLedSeq_PlayTable()Ԃ[0]j󂵂ėǂB[1]̓e[ȕI[vfƂċLB[1]ύXĂ͂ȂB
	/* LEDV[PT`lԍLEDf[^̐擪AhXł邱ƂmF܂B */
	if((iLedSeqCh > LedSeqCh_Max) || (!pData)) { DIE(); }
	/* e[uɁALEDf[^̐擪AhXi[B */
	Table[0] = (uint32_t)pData;
	/* LEDf[^PƂ́ALEDf[^e[u̍ĐJnƂďB */
	LedSeq_PlayTable(iLedSeqCh, Table);
}

/*--------------------------------------------------------------------------*/

/* LEDV[PT`ľʂݒ肵܂B
 * [in]
 *	iLedSeqCh	LEDV[PT`lԍ(0`LedSeqCh_Max)
 *	Att		(0`255)
 * [note]
 *	- ۂɂ́A(ʁ30)͑Sčő匸łB
 *	  LEDf[^̍őPx31A30ƁAPx1()ƂȂ邩B
 *	- LEDV[PT`ľʂ́A`lĐE~ĂωȂB
 *	  ~LEDV[PT`lɑ΂Čʂݒ肷邱Ƃ\łB
 */
void LedSeq_SetChAtt(uint8_t iLedSeqCh, uint8_t Att) {
	ST_LedSeqCh* pLedSeqCh;
	/* LEDV[PT`lԍł邱ƂmF܂B */
	if(iLedSeqCh > LedSeqCh_Max) { DIE(); }
	/* LEDV[PT`l擾܂B */
	pLedSeqCh = &stLedSeq.LedSeqCh[iLedSeqCh];
	/* LEDV[PT`lɁAʂi[܂B */
	pLedSeqCh->Att = Att;
}

/*--------------------------------------------------------------------------*/

/* LEDV[PT`l~܂B
 * [in]
 *	iLedSeqCh	LEDV[PT`lԍ(0`LedSeqCh_Max)
 */
void LedSeq_Stop(uint8_t iLedSeqCh) {
	uint16_t iLedDec;
	ST_LedSeqCh* pLedSeqCh;
	ST_LedDec* pLedDec;
	/* LEDV[PT`lԍł邱ƂmF܂B */
	if(iLedSeqCh > LedSeqCh_Max) { DIE(); }
	/* LEDV[PT`l擾܂B */
	pLedSeqCh = &stLedSeq.LedSeqCh[iLedSeqCh];
	/* ~Ȃ΁A܂B */
	if(!pLedSeqCh->pTable) { return; }	//Đor~tB[h́ApDatał͂ȂpTableł邱Ƃɒӂ
	/* LEDV[PT`lALEDfR[_`FC̐擪ԍ擾܂B */
	iLedDec = pLedSeqCh->Root;	//ȂI[(0xFFFF)ł\L܂BLED1f[^̏ꍇÁALEDfR[_v[ōĐJnLEDfR[_`FCmۂłȂꍇB
	/* ɁAŌLEDfR[_̃|C^擾܂B */
	pLedDec = NULL;	//ALED1f[^Ȃ΁ANULL̂܂܂ňȉ̃[vIB̂悤ȃf[^͖ʂASLED߃f[^ƂĔ̂ŁAe𓾂ȂB
	/* eLEDɂāc */
	for(;;) {
		/* LEDfR[_`FCI[Ȃ΁A܂B */
		if(iLedDec == 0xFFFF) { break; }	//LEDf[^ɁALEDfR[_`FCI[ɂȂ\L܂BLEDfR[_v[sāALEDfR[_`FCLEDf[^LEDmۂłȂꍇB
		/* LEDfR[_ԍł邱ƂmF܂B */
		if(iLedDec > LedDec_Max) { DIE(); }	/* oO,,f[^j */
		/* LEDfR[_擾܂B */
		pLedDec = &stLedSeq.LedDec[iLedDec];
		/* LEDfR[_ALEDfR[_`FC̎ԍ擾܂B */
		iLedDec = pLedDec->Next;						//pLedDec͂܂ŌLEDfR[_wĂ邪AiLedDecɎ֐i߂ĂB
	}
	/* LED1f[^łȂ΁c */
	if(pLedDec) {
		/* LEDV[PT`lgpĂLEDfR[_`FCŜALEDfR[_v[֕ԋp܂B */
		pLedDec->Next = stLedSeq.LedDec_Root;			//
				stLedSeq.LedDec_Root = pLedSeqCh->Root;	//LEDV[PT`lgpĂLEDfR[_`FCŜALEDfR[_v[̐擪Ƀ`FC鏈
	}
	/* LEDV[PT`lɁA~}[N܂B */
	pLedSeqCh->pTable = NULL;	//Đor~tB[h́ApDatał͂ȂpTableł邱Ƃɒӂ
}

/*--------------------------------------------------------------------------*/

/* LEDV[PT`lSĒ~܂B
 */
void LedSeq_StopAll() {
	uint8_t iLedSeqCh;
	/* eLEDV[PT`lɂāc */
	for(iLedSeqCh = 0; iLedSeqCh <= LedSeqCh_Max; iLedSeqCh++) {
		/* LEDV[PT`l~܂B */
		LedSeq_Stop(iLedSeqCh);
	}
}

/*--------------------------------------------------------------------------*/

/* LEDV[PT`l̍ĐԂ擾܂B
 * [in]
 *	iLedSeqCh	LEDV[PT`lԍ(0`LedSeqCh_Max)
 * [out]
 *	߂l		ĐȂ΁A1Ԃ܂B
 *			~Ȃ΁A0Ԃ܂B
 */
uint8_t LedSeq_Stat(uint8_t iLedSeqCh) {
	ST_LedSeqCh* pLedSeqCh;
	/* LEDV[PT`lԍł邱ƂmF܂B */
	if(iLedSeqCh > LedSeqCh_Max) { DIE(); }
	/* LEDV[PT`l擾܂B */
	pLedSeqCh = &stLedSeq.LedSeqCh[iLedSeqCh];
	/* Đ(1),,~(0)Ԃ܂B */
	return pLedSeqCh->pTable != NULL;	//Đor~tB[h́ApDatał͂ȂpTableł邱Ƃɒӂ
}

/*--------------------------------------------------------------------------*/

/* LEDfoCXɁAڎwPxݒ肵܂B
 * [in]
 *	iLedDev		LEDfoCXԍ(0`LedDev_Max)
 *	Value		ڎwPx(0=w薳,1=,2`31=_Px)
 */
void LedSeq_Direct(uint16_t iLedDev, uint8_t Value) {
	/* LEDfoCXԍƒڎwPxł邱ƂmF܂B */
	if((iLedDev > LedDev_Max) || (Value > ((1<<5)-1))) { DIE(); }
	/* w肳ꂽLEDfoCXɁAڎwPxi[܂B */
	stLedSeq.Direct[iLedDev] = Value;
}

/*--------------------------------------------------------------------------*/

/* ALEDfoCXɁAڎwPxݒ肵܂B
 * [in]
 *	iLedDev		擪LEDfoCXԍ(0`LedDev_Max)
 *	nLedDev		ALEDfoCX(0`LedDev_Max+1)
 *	Value		ڎwPx(0=w薳,1=,2`31=_Px)
 */
void LedSeq_DirectNum(uint16_t iLedDev, uint16_t nLedDev, uint8_t Value) {
	/* 擪LEDfoCXԍƘALEDfoCXƒڎwPxł邱ƂmF܂B */
	if(((iLedDev + nLedDev) > (LedDev_Max + 1)) || (Value > ((1<<5)-1))) { DIE(); }
	/* ALEDfoCXɁAڎwPxi[܂B */
	memset(&stLedSeq.Direct[iLedDev], Value, nLedDev);
}

/*--------------------------------------------------------------------------*/

/* SĂLEDfoCXɁAڎwPxݒ肵܂B
 * [in]
 *	Value		ڎwPx(0=w薳,1=,2`31=_Px)
 */
void LedSeq_DirectAll(uint8_t Value) {
	LedSeq_DirectNum(0, LedDev_Max + 1, Value);
}

/*--------------------------------------------------------------------------*/

/* ĐJnƃ[v̋ʏłB
 * [in]
 *	pLedSeqCh	LEDV[PT`l
 *	IntroLoop	Đ(0=Cg,1=[v)
 * [out]
 *	߂l		ĐJnA1Ԃ܂B
 *			w肳ꂽĐAĐJnłȂ΁A0Ԃ܂B
 * [note]
 *	- {֐͉L̃tB[hQƂύX܂B
 *	    pLedSeqCh->pTable
 *	- {֐͉L̃tB[hύXAɐݒ肳ĂlQƂ܂B
 *	    pLedSeqCh->pData      LEDf[^̐擪AhXAɐݒ肳Ă̂Ƒz肵܂B
 *	    pLedSeqCh->Root       LEDfR[_`FCAɊmۂĂ̂Ƒz肵܂B
 *	- ĐJnꍇA{֐͉L̃tB[hݒ肵܂B
 *	    pLedSeqCh->Frame      0i[܂B
 *	    pLedSeqCh->IntroLoop  w肳ꂽĐi[܂B
 */
static uint8_t LedSeq_PlaySub(ST_LedSeqCh* pLedSeqCh, uint8_t IntroLoop) {
	uint16_t nFrameLen[2];
	uint16_t iLedDec, iLedDev;
	uint32_t nDataLen;
	ST_LedDec* pLedDec;
	const uint8_t* pData;
	if(IntroLoop > 1) { DIE(); }	/* ĂяõoO */
	/* LEDV[PT`lALEDf[^̐擪AhX擾܂B */
	pData = pLedSeqCh->pData;
	if(!pData) { DIE(); }		/* ĂяõoO */
	/* LEDf[^ACgt[(2byte)擾܂B */
	nFrameLen[0]  = *pData++;
	nFrameLen[0] |= *pData++ << 8;
	/* LEDf[^A[vt[(2byte)擾܂B */
	nFrameLen[1]  = *pData++;
	nFrameLen[1] |= *pData++ << 8;
	/* wꂽ̃t[0Ȃ΁AĐJn0Ԃ܂B */
	if(nFrameLen[IntroLoop] == 0) { return 0; }
	/* t[ԍƍĐi[B */
	pLedSeqCh->Frame     = 0;	//Frame,IntroLooṕA~t[BɃNAȂ̂ŁAO̒lcĂBŖIɃNAKvB
	pLedSeqCh->IntroLoop = IntroLoop;
	/* LEDV[PT`lALEDfR[_`FC̐擪ԍ擾܂B */
	iLedDec = pLedSeqCh->Root;	//ȂI[(0xFFFF)ł\L܂BLED1f[^̏ꍇÁALEDfR[_v[ōĐJnLEDfR[_`FCmۂłȂꍇB
	/* eLEDɂāc */
	for(;;) {
		/* LEDfR[_`FCI[Ȃ΁A܂B */
		if(iLedDec == 0xFFFF) { break; }	//LEDf[^ɁALEDfR[_`FCI[ɂȂ\L܂BLEDfR[_v[sāALEDfR[_`FCLEDf[^LEDmۂłȂꍇB
		/* LEDfR[_ԍł邱ƂmF܂B */
		if(iLedDec > LedDec_Max) { DIE(); }	/* oO,,f[^j */
		/* LEDf[^ALEDfoCXԍ(2byte)擾܂B */
		iLedDev  = *pData++;
		iLedDev |= *pData++ << 8;
		/* LEDfoCXԍł邱ƂmF܂B */
		if(iLedDev > LedDev_Max) { DIE(); }	/* oO,,f[^j */	//LEDfR[_`FCɁALEDf[^I[ɂȂ邱Ƃ͗L܂B
		/* LEDfR[_擾܂B */
		pLedDec = &stLedSeq.LedDec[iLedDec];
		/* LEDfR[_́AANA܂B */
		pLedDec->RleLV = 0;							//YƁAO(A|Px)̎cgĂ܂oOɂȂBӂB
		/* LEDfR[_ALEDfR[_`FC̎ԍ擾܂B */
		iLedDec = pLedDec->Next;						//pLedDec͂܂ŌLEDfR[_wĂ邪AiLedDecɎ֐i߂ĂB
		/* LEDf[^ACg̈kf[^TCY(3byte)擾܂B */
		nDataLen  = *pData++;
		nDataLen |= *pData++ <<  8;
		nDataLen |= *pData++ << 16;
		/* wCgȂ΁A݂LEDf[^AhXi[܂B */
		if(IntroLoop == 0) { pLedDec->pData = pData; }
		/* Cg̈kf[^΂܂B */
		pData += nDataLen;
		/* LEDf[^A[v̈kf[^TCY(3byte)擾܂B */
		nDataLen  = *pData++;
		nDataLen |= *pData++ <<  8;
		nDataLen |= *pData++ << 16;
		/* w[vȂ΁A݂LEDf[^AhXi[܂B */
		if(IntroLoop == 1) { pLedDec->pData = pData; }
		/* [v̈kf[^΂܂B */
		pData += nDataLen;
	}
	/* ĐJn1Ԃ܂B */
	return 1;
}

