/*
 *	clipdire.c
 *
 *	POSIX̃fBNg䃋[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Wed Jan 26 00:13:38 JST 2011 Naoyuki Sawa
 *	- 1st [XB
 *	- P/ECEJAсAEPSONS1C33Jɂ́APOSIXdirent.hwb_t@C܂܂Ă܂B
 *	  P/ECE APIpceFileFindOpen(),pceFileFindNext(),pceFileFindClose()𒼐ڎgΏ[Ȃ̂ŁAĂȂ̂łA
 *	  Web⏑Ђ̃TvvORpC鎞ɕKvɂȂꍇɔāApӂĂƂɂ܂B
 *	  ̓Iɂ́AuvO~OLuaṽTvvORpC邽߂ɗpӂ܂B
 *	- P/ECEt@CVXeɂ́ATufBNgL܂B
 *	  opendir()֐̈ dirname ͖AɃ[gfBNgJƂ܂B
 *	* Thu Jan 27 00:39:00 JST 2011 Naoyuki Sawa
 *	- rewinddir(),telldir(),seekdir()ǉ܂B
 *	- scandir(),alphasort(),versionsort()̐錾ǉ܂BłBAKvɂȂۂɁA\łB
 *	* Sat Feb 05 01:53:09 JST 2011 Naoyuki Sawa
 *	- scandir(),alphasort()܂B
 *	* Wed May 21 15:29:53 JST 2014 Naoyuki Sawa
 *	- Windowsłopendir(),readdir(),closedir()܂B
 */
#include "clip.h"

/****************************************************************************
 *	P/ECE
 ****************************************************************************/
#ifdef  PIECE
/*--------------------------------------------------------------------------*/
DIR* opendir(const char* dirname) {
	FILEINFO* pfi = malloc(sizeof(FILEINFO));
	if(!pfi) DIE();
	pceFileFindOpen(pfi);	/* 0(I) */
	return (DIR*)pfi;
}
/*--------------------------------------------------------------------------*/
struct dirent* readdir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	if(!pceFileFindNext(pfi)) return NULL;	/* 0(t@CȂ) */
	return (struct dirent*)pfi->filename;	/* 1(t@C) */
}
/*--------------------------------------------------------------------------*/
int closedir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	pceFileFindClose(pfi);	/* 0(I) */
	free(pfi);
	return 0;
}
/*--------------------------------------------------------------------------*/
void rewinddir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	pceFileFindClose(pfi);	/* 0(I) */
	pceFileFindOpen(pfi);	/* 0(I) */
}
/*--------------------------------------------------------------------------*/
/*{{C:\usr\PIECE\sysdev\pcekn\file.c*/
typedef struct tagWORKS {
	DIRECTORY *pdir;
} WORKS;
/*}}C:\usr\PIECE\sysdev\pcekn\file.c*/
/*--------------------------------------------------------------------------*/
long telldir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	WORKS* pw = (WORKS*)pfi->works;
	return (long)pw->pdir;
}
/*--------------------------------------------------------------------------*/
void seekdir(DIR* dirp, long offset) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	WORKS* pw = (WORKS*)pfi->works;
	pw->pdir = (DIRECTORY*)offset;
}
/*--------------------------------------------------------------------------*/
#endif/*PIECE*/

/****************************************************************************
 *	Windows
 ****************************************************************************/
#ifdef  WIN32
/*--------------------------------------------------------------------------*/
struct __dirstream {
	int count;			/* readdir()Ă΂ꂽ */
	int handle;			/* findn֐̌nh */
	struct _finddata_t fileinfo;	/* findn֐̃t@Cobt@ */
};
/*--------------------------------------------------------------------------*/
DIR* opendir(const char* dirname) {
	char filespec[_MAX_PATH];
	DIR* dirp = calloc(1, sizeof(DIR));
	if(!dirp) { DIE(); }
	_makepath(filespec, NULL, dirname, "*", NULL);	//ǂłǂBu*vłu*.*vłASẴt@CɈvB
//	_makepath(filespec, NULL, dirname, "*", "*");	//̓Iɂ́Au*vgq̗Lt@CɈv邵Au*.*vgq̖t@CɈvB
	dirp->handle = _findfirst(filespec, &dirp->fileinfo);			/* 1ڂ̈vt@C */
	if(dirp->handle == -1) { DIE(); }
	return dirp;
}
/*--------------------------------------------------------------------------*/
struct dirent* readdir(DIR* dirp) {
	if(dirp->count++) {
		if(_findnext(dirp->handle, &dirp->fileinfo)) { return NULL; }	/* 2ڈȍ~̈vt@C */
	}
	return (struct dirent*)dirp->fileinfo.name;
}
/*--------------------------------------------------------------------------*/
int closedir(DIR* dirp) {
	if(_findclose(dirp->handle)) { DIE(); }
	free(dirp);
	return 0;
}
/*--------------------------------------------------------------------------*/
//void rewinddir(DIR* dirp);		/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
//long telldir(DIR* dirp);		/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
//void seekdir(DIR* dirp, long offset);	/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
#endif/*WIN32*/

/****************************************************************************
 *	P/ECE,Windows()
 ****************************************************************************/
int scandir(const char* dirname, struct dirent*** namelist, int (*filter)(const struct dirent*), int (*compar)(const struct dirent**, const struct dirent**)) {
	int i = 0;
	DIR* d;
	struct dirent* e;
	/* Ggz܂B */
	*namelist = NULL;
	/* fBNgJ܂B */
	if((d = opendir(dirname)) == NULL) {
		DIE();
	}
	/* fBNg̊eGgɂāc */
	while((e = readdir(d)) != NULL) {
		/* tB^֐w肳ĂȂÁAtB^֐ɂđIꂽc */
		if((filter == NULL) || (filter(e) != 0)) {
			/* Ggzg܂B */
			if((*namelist = realloc(*namelist, sizeof(struct dirent*) * (i + 1))) == NULL) {
				DIE();
			}
			/* Gg𕡐邽߂́Amۂ܂B */
			if(((*namelist)[i] = malloc(sizeof(struct dirent))) == NULL) {
				DIE();
			}
			memcpy((*namelist)[i++], e, sizeof(struct dirent));
		}
	}
	/* fBNg܂B */
	if(closedir(d) != 0) {
		DIE();
	}
	/* Ggr֐w肳ĂAGgr֐gă\[g܂B */
	if(compar != NULL) {
		qsort(*namelist, i, sizeof(struct dirent*), (int (*)(const void*, const void*))compar);
	}
	/* IꂽGgԂ܂B
	 * - IꂽGg 0 ̏ꍇ́A*namelist=NULL ̂܂܂łB
	 *   ĂяoAfree(*namelist) s܂Afree(NULL) ͈SȂ̂Ŗ肠܂B
	 */
	return i;
}
/*--------------------------------------------------------------------------*/
int alphasort(const void* /* const struct dirent** */ a, const void* /* const struct dirent** */ b) {
	return strcmp((*(const struct dirent**)a)->d_name, (*(const struct dirent**)b)->d_name);
}

