/*	
 *	clipcom.h
 *
 *	VAʐMhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon May 17 22:46:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_COM_H__
#define __CLIP_COM_H__

/****************************************************************************
 *	n[hEFAdl
 ****************************************************************************/

/* =============
 * P/ECEg[q
 * =============
 *
 *	----	----	----
 *	[q	@\	pr
 *	----	----	----
 *	1	P14	#CTS
 *	2	GND	GND
 *	3	DSIO	܂
 *	4	P12	#RTS
 *	5	Vcc	Vcc
 *	6	P06	܂
 *	7	SOUT1	TxD
 *	8	SIN1	RxD
 *
 *	g[qɃVAʐM@ڑCOM|[gJƁA
 *	͒[qԂsɂȂĎM荞݂ƎMG[荞݂pA
 *	nOAbvĂ܂ꍇ悤łB
 */

/****************************************************************************
 *	
 ****************************************************************************/

/* COM|[gJ܂B
 * [in]
 *	baudrate	]x(rbg/b)
 *	parity		0:peBȂ or 1:peB or 2:peB
 *	bytesize	7:7rbg or 8:8rbg
 *	stopbits	1:1rbg or 2:2rbg
 *	rxbuf_size	Mobt@TCY(oCg)B0w肷ƁAKTCYg܂B
 *	txbuf_size	Mobt@TCY(oCg)B0w肷ƁAKTCYg܂B
 *	recv_callback	MʒmR[obNw肵܂BNULLȂ΃R[obN܂B
 *	send_callback	MR[obNw肵܂BNULLȂ΃R[obN܂B
 * [note]
 *	* COM|[gJĂꍇ́AAVݒŊJȂ܂B
 *	* com_open()Ă񂾃AvP[V́AIOɕKcom_close()ĂłB
 *	  CLiPCȕI[`͎Icom_close()Ăт܂B
 *	* com_open()̏ԂŁARTSM1(f[^M\)ƂȂĂ܂B
 *	  ʏ́Â܂܂Ńf[^M\łB
 *	  Iȃn[hEFAt[sꍇ́AKvɉcom_rts()֐gĂB
 *	* MʒmR[obŃȀŌĂяo܂B
 *	  1. Vȃf[^1oCgMƂB
 *	  2. MG[ƂB
 *	* MR[obŃȀŌĂяo܂B
 *	  1. VAI/F̑Mobt@ŁAAhCȏMobt@̂ƂB
 *	  2004/05/31݂̎ł́AKM^C~Oł̂݃R[obN킯ł͂܂B
 *	    VAI/FƃhCȏMobt@ǂłCӂ̃^C~OŁAR[obN\܂B
 *	    ܂g݂͂Ȃm܂EEE
 */
void com_open(int baudrate, int parity, int bytesize, int stopbits, int rxbuf_size, int txbuf_size, void (*recv_callback)(), void (*send_callback)());

/* COM|[g܂B
 * [note]
 *	* COM|[gJĂȂꍇ́AɏԂ܂B
 */
void com_close();

/* f[^M܂B
 * [in]
 *	buf		Mf[^󂯎邽߂̃obt@̐擪AhXB
 *	maxlen		Mf[^󂯎邽߂̃obt@̃oCgB
 * [out]
 *	߂l		- Mf[^̃oCgB
 *			  ߂lmaxlen𒴂邱Ƃ͂܂B
 *			- MG[ꍇ́A-1Ԃ܂B
 *			  MG[ƁAcom_reset()ĂԂ܂-1Ԃ܂B
 */
int com_recv(void* buf, int maxlen);

/* f[^𑗐M܂B
 * [in]
 *	buf		Mf[^̐擪AhXB
 *	len		Mf[^̃oCgB
 *			-1w肷ƁAAsciiZƌȂăf[^TCYf܂B
 * [out]
 *	߂l		- Mf[^̃oCgB
 *			  lenƓlA܂͈len-1w肵ꍇ͕񒷂Ԃ܂B
 *			- MG[ꍇ́A-1Ԃ܂B
 *			  2004/05/18݂̎ł́Acom_send()֐G[ԂƂ͂܂B
 *			  At[⑗M^CAEgǉꍇɗp\łB
 * [note]
 *	* Mobt@ɋ󂫂ȂꍇAMobt@ɋ󂫂ł܂ŁA֐ɂăubN܂B
 *	  2004/05/18݂̎ł́AhCo\̂̑Mobt@I[o[t[͐΂ɔ܂B
 */
int com_send(const void* buf, int len);

/* VAʐMhCoZbg܂B
 * [note]
 *	* Mobt@NAAMG[Zbg܂B
 *	* Mobt@NA܂B
 */
void com_reset();

/* RTSMݒ肵܂B
 * [in]
 *	value		1:P/ECEf[^M\ł邱ƂAڑ@ɑ΂ĒʒmB(+12V)
 *			0:P/ECEf[^Msł邱ƂAڑ@ɑ΂ĒʒmB(-12V)
 */
void com_rts(int value);

/* CTSM擾܂B
 * [out]
 *	߂l		1:ڑ@킪f[^M\ł邱ƂAP/ECEɑ΂ĒʒmĂB(+12V)
 *			0:ڑ@킪f[^Msł邱ƂAP/ECEɑ΂ĒʒmĂB(-12V)
 */
int com_cts();

#endif /*__CLIP_COM_H__*/
