/*
 *	app.c
 *
 *	dpserial - ȈՃVAo̓c[
 *	Copyright (C) 2013 Naoyuki Sawa
 *
 *	* Thu Oct 10 16:22:59 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Oct 10 21:00:02 JST 2013 Naoyuki Sawa
 *	- vWFNgŗL̊gǉ܂B
 *	  u1oCg^Cv{4oCgf[^ṽR}h`Aut8oCgv`ɕϊđo܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <mbctype.h>
/* Win32 */
#define STRICT
#include <windows.h>

/* dv
 * R}hC̃ChJ[hWJ邽߂ɁA
 * [vWFNg̐ݒ]->[N]->[IuWFNg/CuW[]Ɂusetargv.objvǉ܂B
 */

/****************************************************************************
 *	
 ****************************************************************************/

#define VERSION "20131010"

#define DIE() die("%s(%d)",__FILE__,__LINE__)
__declspec(noreturn) void die(const char* fmt, ...);
__declspec(noreturn) void usage();
void AddData(int c);
void AddCommand(const char* pType, const char* pData);	//{{vWFNgŗL̊g}}

#define __CLIP_H__
/* getopt */
#include "../../include/getopt.h"
#include "../../getopt.c"
#undef  __CLIP_H__

/* IvV */
int opt_Verbose;	/* 1Ȃ΁Aڍו\sB */
int opt_Expression;	/* 1Ȃ΁AIvVȍ~̈vfAt@Cł͂Ȃo̓f[^ƌȂB */
int opt_eXtension;	/* 1Ȃ΁Au1oCg^Cv{4oCgf[^ṽR}h`Aut8oCgv`ɕϊđoB */	//{{vWFNgŗL̊g}}
int opt_CommPort = 1;	/* ʐM|[gԍBVB6MSCommRg[CommPortvpeBɑB */		/* IvV'c'w肳Ȃ΁AftHg1ƂB */
char* opt_Settings;	/* foCX䕶BVB6MSCommRg[SettingsvpeBɑB */

char ModuleFileName[_MAX_FNAME];	/* W[t@C */
char PortName[_MAX_FNAME];		/* |[g */
char MutexName[_MAX_PATH];		/* ~[eNX */
DCB Dcb;

HANDLE hMutex;	/* ~[eNX */
HANDLE hComm;	/* ʐM|[g */

unsigned char* DataBuffer/*[DataBufferSize]*/;	/* f[^obt@ */
int DataBufferSize;				/* f[^obt@̃oCg */
int DataLength;					/* f[^̃oCg */

/****************************************************************************
 *	
 ****************************************************************************/

int main(int argc, char* argv[]) {
	int RetVal;
	int opt;
	char* EndPtr;
	int NumberOfBytesToWrite;
	int NumberOfBytesWritten;
	char Path[_MAX_PATH];
	/* R}hCw肳ĂȂ΁Ag\AG[IB */
	if(argc <= 1) { usage(); }
	/* R}hC͂B */
	opterr = 0; /* IvṼG[bZ[ẂA{vO\Bgetopt()̃G[bZ[W}B */
	while((opt = getopt(argc, argv, "vexc:s:")) != -1) {
		switch(opt) {
		case 'v':
			opt_Verbose = 1;	/* ڍו\sB */
			break;
		case 'e':
			opt_Expression = 1;	/* IvVȍ~̈vfAt@Cł͂Ȃo̓f[^ƌȂB */
			break;
		case 'x':
			opt_eXtension = 1;	/* u1oCg^Cv{4oCgf[^ṽR}h`Aut8oCgv`ɕϊđoB */	//{{vWFNgŗL̊g}}
			break;
		case 'c':
			opt_CommPort = strtol(optarg, &EndPtr, 10);	/* ʐM|[gԍB */
			if((*EndPtr != '\0') || (opt_CommPort < 1)) { die("IvV'%c'̈słB", optopt); } /* lȊO̕܂ł炸,,1ȏ̒lł邱ƁB */
			break;
		case 's':
			opt_Settings = optarg;	/* foCX䕶B */
			break;
		default:
			die("IvV'%c'słB", optopt);
			break;
		}
	}
	/* vWFNgŗL̊gw肳Ăc */
	if(opt_eXtension) {
//{{vWFNgŗL̊g
		/* R}hCAu1oCg^Cv+4oCgf[^v̑g݂擾Aut8oCgvɕϊāAo̓f[^ɃZbgB */
		/* - vWFNgŗL̊gw肳ꂽꍇ́AÖق'-e'w肳ꂽ̂ƌȂB
		 *   '-e'̎w̗Lɂ炸A^Cvƃf[^R}hC擾B
		 */
		while(optind < argc) {
			if((optind + 2) > argc) { die("vWFNgŗL̊gɂAR}hCsłB"); }
			AddCommand(argv[optind + 0], argv[optind + 1]);
			optind += 2;
		}
//}}vWFNgŗL̊g
	/* vWFNgŗL̊gw肳ĂȂ΁c */
	} else {
		/* R}hCAo̓f[^WB */
		if(opt_Expression) {
			/* SĂ̈̑SĂ̕Ao̓f[^ɒǉB */
			while(optind < argc) {
				char  *p = argv[optind++];
				while(*p) { AddData(*p++); }
			}
		/* t@C,,W͂Ao̓f[^WB */
		} else {
			/* t@Cw肳ĂȂĂA[vsB */
			do {
				FILE* fp = stdin;	/* t@Cw肳ĂȂ΁A[v񂾂sAW͂ǂݍށB */
				/* t@Cȏw肳Ăc */
				if(optind < argc) {
					/* t@CJB */
					fp = fopen(argv[optind], "r");
					if(!fp) { die("%sJ܂B", argv[optind]); }
				}
				for(;;) {
					/* ꕶǂݍށB */
					RetVal = fgetc(fp);
					/* t@CI[ɒBAB */
					if(RetVal == EOF) { break; }
					/* o̓f[^ɒǉB */
					AddData(RetVal);
				}
				/* t@Cȏw肳Ăc */
				if(optind < argc) {
					/* t@CB */
					RetVal = fclose(fp);
					if(RetVal) { die("fcloses܂B"); }
					/* ̃t@C֐i߂B */
					optind++;
				}
			} while(optind < argc);		/* t@Cw肳ĂȂ,,t@CI[ɒBA[v𔲂B */
		}
	}
	/* W[t@C擾B */
	RetVal = GetModuleFileName(NULL, Path, sizeof Path);
	if(RetVal == 0) { die("GetModuleFileNames܂B"); }
	_splitpath(Path, NULL, NULL, ModuleFileName, NULL);
	/* |[g쐬B */
	sprintf(PortName, "COM%u", opt_CommPort);
	/* W[t@Cƃ|[gAāA~[eNX쐬B
	 * MSDNCu VisualStudio 6.0uCreateMutexvp:
	 * Oɂ́u\vȊO̔Cӂ̕gpł܂B啶͋ʂ܂Bő啶_MAX_PATHłB
	 */
	strcpy(MutexName, ModuleFileName);
	strcat(MutexName, ":");
	strcat(MutexName, PortName);
	/* ~[eNX쐬B */
	hMutex = CreateMutex(NULL, FALSE, MutexName);
	if(!hMutex) { die("CreateMutexs܂B"); }
	/* ~[eNX̏LlB
	 * AvP[V|[gɑ΂ă~[eNX̏LlĂꍇ́AJ܂ő҂B
	 * ߂ĺAWAIT_ABANDONED,,WAIT_OBJECT_0ɂȂ͂łB
	 */
//{{ڍו\
	if(opt_Verbose) { printf("r䒆\n"); }
//}}ڍו\
	RetVal = WaitForSingleObject(hMutex, INFINITE);
	if(RetVal == WAIT_FAILED) { die("WaitForSingleObjects܂B"); }
//{{ڍו\
	if(opt_Verbose) { printf("r䊮\n"); }
//}}ڍו\
	/* VA|[gJB
	 * u[SDK32]COM10ȏ̃VA|[gw肷@v(http://support.microsoft.com/kb/115831/ja)p:
	 * COM10ȏ̃VA|[gw肷ꍇ́A"\\.\"tKv܂B̍\́ACOM1COM9łLłB
	 */
	strcpy(Path, "\\\\.\\");
	strcat(Path, PortName);
	hComm = CreateFile(
		Path,		/* lpFileName */
		GENERIC_WRITE,	/* dwDesiredAccess */
		0,		/* dwShareMode */
		NULL,		/* lpSecurityAttributes */
		OPEN_EXISTING,	/* dwCreationDisposition */
		0,		/* dwFlagsAndAttributes */
		NULL);		/* hTemplateFile */
	if(hComm == INVALID_HANDLE_VALUE) { die("%sJ܂B", Path); }
	/* VA|[g̐ݒ擾B
	 * - ̌ABuildCommDCBĂяoDCBύX邪ABuildCommDCB͑SẴtB[hύXȂB
	 *   BuildCommDCBύXȂtB[h̊lƂāAGetCommStateDCB擾KvB
	 */
	RetVal = GetCommState(hComm, &Dcb);
	if(!RetVal) { die("GetCommStates܂B"); }
	/* foCX䕶񂪎w肳Ăc */
	if(opt_Settings) {
		/* DCBύXB */
		RetVal = BuildCommDCB(opt_Settings, &Dcb);
		if(!RetVal) { die("BuildCommDCBs܂B"); }
		/* VA|[g̐ݒύXB */
		RetVal = SetCommState(hComm, &Dcb);
		if(!RetVal) { die("SetCommStates܂B"); }
	}
//{{ڍו\
	if(opt_Verbose) {
		printf("ʐMfoCX̍\\n");
		printf("PortName              = %s\n", PortName);
		printf("DCB.DCBlength         = %u\n", Dcb.DCBlength);
		printf("DCB.BaudRate          = %u\n", Dcb.BaudRate);
		printf("DCB.fBinary           = %u\n", Dcb.fBinary);
		printf("DCB.fParity           = %u\n", Dcb.fParity);
		printf("DCB.fOutxCtsFlow      = %u\n", Dcb.fOutxCtsFlow);
		printf("DCB.fOutxDsrFlow      = %u\n", Dcb.fOutxDsrFlow);
		printf("DCB.fDtrControl       = %u\n", Dcb.fDtrControl);
		printf("DCB.fDsrSensitivity   = %u\n", Dcb.fDsrSensitivity);
		printf("DCB.fTXContinueOnXoff = %u\n", Dcb.fTXContinueOnXoff);
		printf("DCB.fOutX             = %u\n", Dcb.fOutX);
		printf("DCB.fInX              = %u\n", Dcb.fInX);
		printf("DCB.fErrorChar        = %u\n", Dcb.fErrorChar);
		printf("DCB.fNull             = %u\n", Dcb.fNull);
		printf("DCB.fRtsControl       = %u\n", Dcb.fRtsControl);
		printf("DCB.fAbortOnError     = %u\n", Dcb.fAbortOnError);
		printf("DCB.fDummy2           = %u\n", Dcb.fDummy2);
		printf("DCB.wReserved         = %u\n", Dcb.wReserved);
		printf("DCB.XonLim            = %u\n", Dcb.XonLim);
		printf("DCB.XoffLim           = %u\n", Dcb.XoffLim);
		printf("DCB.ByteSize          = %u\n", Dcb.ByteSize);
		printf("DCB.Parity            = %u\n", Dcb.Parity);
		printf("DCB.StopBits          = %u\n", Dcb.StopBits);
		printf("DCB.XonChar           = %u\n", Dcb.XonChar);
		printf("DCB.XoffChar          = %u\n", Dcb.XoffChar);
		printf("DCB.ErrorChar         = %u\n", Dcb.ErrorChar);
		printf("DCB.EofChar           = %u\n", Dcb.EofChar);
		printf("DCB.EvtChar           = %u\n", Dcb.EvtChar);
		printf("DCB.wReserved1        = %u\n", Dcb.wReserved1);
	}
//}}ڍו\
	/* f[^Sďo͂B */
//{{ڍו\
	if(opt_Verbose) { printf("f[^o͒"); }
//}}ڍו\
	NumberOfBytesToWrite = DataLength;
	while(NumberOfBytesToWrite) {
		RetVal = WriteFile(hComm,
			&DataBuffer[DataLength - NumberOfBytesToWrite],
			opt_Verbose ? 1 : NumberOfBytesToWrite,				/* ڍו\śAڍו\Ǝۂ̊eoCg̏o͂𓯊߁A1oCgMĊ҂ƂɂB */
			&NumberOfBytesWritten, NULL);
		if(!RetVal) { die("WriteFiles܂B"); }
//{{ڍו\
		if(opt_Verbose) {
			int i;
			for(i = 0; i < NumberOfBytesWritten; i++) {
				printf("%c%02X",
					((DataLength - NumberOfBytesToWrite + i) & 15) ? ' ' : '\n',
					DataBuffer[DataLength - NumberOfBytesToWrite + i]);
			}
			RetVal = FlushFileBuffers(hComm);				/* ڍו\śAڍו\Ǝۂ̊eoCg̏o͂𓯊߁A1oCgMĊ҂ƂɂB */
			if(!RetVal) { die("FlushFileBufferss܂B"); }	/* ڍו\śAڍו\Ǝۂ̊eoCg̏o͂𓯊߁A1oCgMĊ҂ƂɂB */
		}
//}}ڍו\
		NumberOfBytesToWrite -= NumberOfBytesWritten;
	}
	/* VA|[gOɁAmɃtbV邱ƂɂB */
	RetVal = FlushFileBuffers(hComm);				/* svmȂAŜ߂ɁB */
	if(!RetVal) { die("FlushFileBufferss܂B"); }	/* svmȂAŜ߂ɁB */
//{{ڍו\
	if(opt_Verbose) { printf("\nf[^o͊\n"); }
//}}ڍו\
	/* VA|[gB */
	RetVal = CloseHandle(hComm);
	if(!RetVal) { die("CloseHandles܂B"); }
	/* ~[eNX̏LJB */
	RetVal = ReleaseMutex(hMutex);
	if(!RetVal) { die("ReleaseMutexs܂B"); }
	/* ~[eNXJB */
	RetVal = CloseHandle(hMutex);
	if(!RetVal) { die("CloseHandles܂B"); }
	return EXIT_SUCCESS;
}

/****************************************************************************
 *	
 ****************************************************************************/

void AddData(int c) {
	static int mb;	/* O̕}`oCg̑1oCgȂΔ0 */
	static int lo;	/* f[^̍ŏIoCg̑2jui[ȂΔ0 */
	/* O̕A}`oCg̑1oCgłȂ΁c */
	if(mb) {
		/* ̌̏Ɋ֌WAO̕NAĂB */
		mb = 0;
		/* ̕A}`oCg̑2oCgȂ΁c */
		if(_ismbbtrail(c)) {
			/* O̕ƁA̕jB */
			/** no job **/
		/* ̕A}`oCg̑2oCgłȂ΁c */
		} else {
			/* sȃeLXgłƔfAG[IB */
			die("}`oCg񂪕słB");
		}
	/* O̕A}`oCg̑1oCgłȂȂ΁c */
	} else {
		/* ̕A}`oCg̑1oCgȂ΁c */
		if(_ismbblead(c)) {
			/* }`oCg̑1oCgi[B */
			mb = c;
		/* ̕A}`oCg̑2oCgłȂ΁c */
		} else {
			/* ̕A16i̕Ȃ΁c */
			if(isxdigit(c)) {
				/* ːlɕϊB */
				     if(isdigit(c)) { c -= ('0' -  0); }
				else if(islower(c)) { c -= ('a' - 10); }
				else if(isupper(c)) { c -= ('A' - 10); }
				else { DIE(); } /* oO */
				/* f[^̍ŏIoCg̑2jui[Ȃ΁c */
				if(lo) {
					/* ̌̏Ɋ֌WANAĂB */
					lo = 0;
					/* f[^̍ŏIoCǵA2juɊi[B */
					if(!DataBuffer ||				/* 1jůi[Ɋmۍς݂ł͂ */
					   (DataBufferSize < DataLength) ||		/* (obt@e)(f[^)ł͂ */
					   (DataBuffer[DataLength-1] & 15)) { DIE(); }	/* ŏIoCg̑2ju͖i[ł͂ */
					    DataBuffer[DataLength-1] |= c;
				/* f[^̍ŏIoCg̑2jui[ς݂Ȃ΁c */
				} else {
					/* ̌̏Ɋ֌WAZbgĂB */
					lo = 1;
					/* KvɉāAf[^obt@gB */
					if(DataLength == DataBufferSize) {
						DataBufferSize += (1<<10);	/* yύX\z1LoCgÂg邱ƂɂB */
						DataBuffer = realloc(DataBuffer, DataBufferSize);
						if(!DataBuffer) { die("reallocs܂B"); }
					}
					/* f[^̍ŏIoCǵA1juɊi[B */
					DataBuffer[DataLength++] = (c<<4);
				}
			/* ̕A16i̕łȂ΁c */
			} else {
				/* ̕jB */
				/** no job **/
			}
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

//{{vWFNgŗL̊g
// [w`]
// 1oCg^Cv:     T07 T06 T05 T04 T03 T02 T01 T00
// 4oCgf[^:     D31 D30 D29 D28 D27 D26 D25 D24
//                    D23 D22 D21 D20 D19 D18 D17 D16
//                    D15 D14 D13 D12 D11 D10 D09 D08
//                    D07 D06 D05 D04 D03 D02 D01 D00
// [o`]
// 8oCgof[^:  0   0   0  T07 T06 T05 T04 T03
//                     0   0   1  T02 T01 T00 D31 D30
//                     0   1   0  D29 D28 D27 D26 D25
//                     0   1   1  D24 D23 D22 D21 D20
//                     1   0   0  D19 D18 D17 D16 D15
//                     1   0   1  D14 D13 D12 D11 D10
//                     1   1   0  D09 D08 D07 D06 D05
//                     1   1   1  D04 D03 D02 D01 D00
void AddCommand(const char* pType, const char* pData) {
	unsigned char Type, Order;
	unsigned long Data;
	char* EndPtr;
	/* 1oCg^Cv4oCgf[^擾B */
	Type = (unsigned char)strtol(pType, &EndPtr, 16);	/* (unsigned char)̃LXg͌x}̈Ӗ̂ */
	if((strlen(pType) < 1) || (strlen(pType) > 2) || (*EndPtr != '\0')) { die("1oCg^CvsłB1oCg^Cv́A1-216iŎw肵ĂB"); }
	Data = strtoul(pData, &EndPtr, 16);	/* ydvzstrtol()ł͂Ȃstrtoul()gKvBstrtol()łLONG_MAX߂̒lLONG_MAXɐ؂l߂Ă܂B */
	if((strlen(pData) < 1) || (strlen(pData) > 8) || (*EndPtr != '\0')) { die("4oCgf[^słB4oCgf[^́A1-816iŎw肵ĂB"); }
	/* KvɉāAf[^obt@gB */
	if((DataLength + 8) > DataBufferSize) {
		DataBufferSize += (1<<10);	/* yύX\z1LoCgÂg邱ƂɂB */
		DataBuffer = realloc(DataBuffer, DataBufferSize);
		if(!DataBuffer) { die("reallocs܂B"); }
	}
	/* ut8oCgv`ɕϊĊi[B */
	for(Order = 0; Order < 8; Order++) {				//i[
									//nsc
									//QPOVUTSRQPO31302928272625242322212019181716151413121110XWVUTSRQPO
		DataBuffer[DataLength++] = (Order << 5) | (Type >> 3);	//
									//@@@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
									//@@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		Type <<= 5;						//@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		Type |= (Data >> (32-5));				//@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		Data <<= 5;						//EEEOOOOO
	}
}
//}}vWFNgŗL̊g

/****************************************************************************
 *	
 ****************************************************************************/

/* bZ[W\AG[IB */
__declspec(noreturn) void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; /* fobOՂ悤ɁAfobO̓fobKŎ~߂ */
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}

/****************************************************************************
 *	
 ****************************************************************************/

/* g\AG[IB */
__declspec(noreturn) void usage() {
	fprintf(stderr, "dpserial - ȈՃVAo̓c[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2013 Naoyuki Sawa All Rights Reserved.\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    dpserial [-v] [-c CommPort] [-s Settings]             co̓f[^W͂ǂݍ\n");
	fprintf(stderr, "    dpserial [-v] [-c CommPort] [-s Settings] FileName... co̓f[^t@Cǂݍ\n");
	fprintf(stderr, "    dpserial [-v] [-c CommPort] [-s Settings] -e  Data... co̓f[^CCŎw肷\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -v            ڍו\sB\n");
	fprintf(stderr, "    -c CommPort   ʐM|[gԍw肷Bw肵Ȃꍇ̊l1łB\n");
	fprintf(stderr, "                  VB6MSCommRg[CommPortvpeBɑB\n");
	fprintf(stderr, "    -s Settings   foCX䕶w肷Bw肵Ȃꍇ̓VXe̊lgpB\n");
	fprintf(stderr, "                  VB6MSCommRg[SettingsvpeBɑB\n");
	fprintf(stderr, "                  foCX䕶̏ Win32 API BuildCommDCB t@XQƂB\n");
	fprintf(stderr, "    -e            o̓f[^CCŎw肷B\n");
	fprintf(stderr, "Summary:\n");
	fprintf(stderr, "  - {c[̕ʂ̃CX^X|[ggpĂꍇAʂ̃CX^X̏I҂B\n");
	fprintf(stderr, "    {c[ȊÕAvP[V|[ggpĂꍇ́A{c[̓G[ƂȂB\n");
	fprintf(stderr, "  - o̓f[^́AW,t@C,,R}hCŎw\łB\n");
	fprintf(stderr, "    ǂ̕@Ŏw肷ꍇAo̓f[^͓̏łB\n");
	fprintf(stderr, "  - o̓f[^̏́A16i*ȊO*SĖāA216iƉ߂B\n");
	fprintf(stderr, "    L̗͑Sāu0x12 0x9A 0xEFvƉ߂B\n");
	fprintf(stderr, "    E 12 9a ef\n");
	fprintf(stderr, "    E 12 9A EF\n");
	fprintf(stderr, "    E 1 2 9 A E F\n");
	fprintf(stderr, "    E 12,9A,EF\n");
	fprintf(stderr, "    E 1,2,9,A,E,F\n");
	fprintf(stderr, "    E 12\\t9A\\r\\nEF\n");
	fprintf(stderr, "    E 12 9A GH EF\n");
	fprintf(stderr, "    E 129A{EF\n");
	fprintf(stderr, "    AŏIoCg1łꍇ́Aʃju0Ɖ߂B\n");
	fprintf(stderr, "  - hꍇ́A'-v'IvVw肵āAۂ̏o̓f[^ĂB\n");
	fprintf(stderr, "Example:\n");
	fprintf(stderr, "    @ dpserial -c 1 -s \"9600,N,8,1\"\n");
	fprintf(stderr, "       o̓f[^W͂ǂݍ݁ACOM1ցAw肳ꂽʐMݒŏo͂B\n");
	fprintf(stderr, "    A dpserial -c 1 -s \"9600,N,8,1\" Data1.txt Data2.txt\n");
	fprintf(stderr, "       o̓f[^t@Cǂݍ݁ACOM1ցAw肳ꂽʐMݒŏo͂B\n");
	fprintf(stderr, "       Data1.txtData2.txtɂ́AK؂ȏo̓f[^eLXgi[Ă邱ƁB\n");
	fprintf(stderr, "       AChJ[hgĕ̃t@Cw肷邱Ƃ\łB\n");
	fprintf(stderr, "    B dpserial -c 1 -s \"9600,N,8,1\" -e 01 23 45 67 89 AB CD EF\n");
	fprintf(stderr, "       o̓f[^CCœǂݍ݁ACOM1ցAw肳ꂽʐMݒŏo͂B\n");
	fprintf(stderr, "    C dpserial -c 1 -s \"9600,N,8,1\" -e 0 1 2 3 4 5 6 7 8 9 A B C D E F\n");
	fprintf(stderr, "       BƓeo͂B\n");
	fprintf(stderr, "       {c[́A16i*ȊO*SĖāA216iƉ߂邱ƂɒӂB\n");
	fprintf(stderr, "eXtension:\n");
	fprintf(stderr, "    vWFNgŗL̊gƂāA\n");
	fprintf(stderr, "    u1oCg^Cv+4oCgf[^v`̃R}hAut8oCgvɕϊďo͂B\n");
	fprintf(stderr, "    dpserial [-v] [-c CommPort] [-s Settings] -x Type Data ...\n");
	fprintf(stderr, "    @ dpserial -c 1 -s \"9600,N,8,1\" -x 01 0123CDEF 00 00000000\n");
	fprintf(stderr, "       {Type=0x00,Data=0x0123CDEF},{Type=0x00,Data=0x00000000}Aϊďo͂B\n");
	fprintf(stderr, "    A dpserial -c 1 -s \"9600,N,8,1\" -x 1 123CDEF 0 0\n");
	fprintf(stderr, "       @Ɠeo͂B\n");
	fprintf(stderr, "       Type1-216iŎw肵Aʌ0߂ȗĂǂB\n");
	fprintf(stderr, "       Data1-816iŎw肵Aʌ0߂ȗĂǂB\n");
	exit(EXIT_FAILURE);
}

