# USAGE:
#	gawk -f MkLotTbl.awk ̓t@C > o̓t@C

#*******************************************************************************
# G[bZ[W\ďI܂B
function die(s) {
	print "### " s > "/dev/stderr"
	_die_exit = 1
	exit 1
}

#*******************************************************************************
# e[uJn܂B
function BeginTable() {
	# mɁAe[uI܂B
	EndTable()
	# e[ud`ĂȂƂmF܂B
	if($1 in aTableName) {
		die(FILENAME "(" FNR ")" "e[ud`Ă܂B")
	}
	aTableName[$1] = 1
	# e[ui[܂B
	TableName = $1
	# e[uf[^NA܂B
	NumCols = 0
	NumRows = 0
	delete TableData
}

#*******************************************************************************
# e[uI܂B
function EndTable() {
	# e[uJnĂc
	if(TableName != "") {
		# ȂƂsȏ̃f[^KvłB
		# - ŏ̃e[u\́A{e[u{Iid̍s}łBIlƏdݒl̍śAsĂ\܂B
		if(NumRows == 0) {
			die(FILENAME "(" FNR ")" "f[^̖e[uL܂BȂƂsȏ̃f[^KvłB")
		}
		# ڈȍ~𒊑IƌȂ܂BeIɂāc
		tmpSize = 0
		tmpStr = ""
		for(Col = 2; Col <= NumCols; Col++) {
			# dݒl0łȂ𐔂AIl(dݒl-1)𕶎ɒǉ܂B
			ColId = TableData[Col, 1]	# Iid
			ColSize = 0			# dݒl0łȂ
			ColStr = ""			# Il(dݒl-1)ǉ邽߂̕
			# sڂ́AIid̍słBIlƏdݒl̍śAsڂJn܂B
			# - ŏ̃e[u\́A{e[u{Iid̍s}łBIlƏdݒl̍śAsĂ\܂B
			#   ]āAȉ̃[v͈ʂȂ\L܂B
			for(Row = 2; Row <= NumRows; Row++) {
				# ڂ𓖑IlƌȂ܂B
				HitVal = TableData[1, Row]
				# dݒl擾܂B
				Weight = TableData[Col, Row]
				# dݒl0łȂ΁c
				if(Weight != 0) {
					# dݒl0łȂ𑝂₵܂B
					ColSize++
					# Il(dݒl-1)𕶎ɒǉ܂B
					ColStr = ColStr "," HitVal ",(" Weight ")-1"	# dݒlA,,V{Œ`ĂꍇA(Weight-1)̒lvZłȂ߁A"-1"t^邱Ƃɂ܂B
				}
			}
			# IidAdݒl0łȂAyсAIl(dݒl-1)̕ǉ܂B
			tmpSize += (2 + ColSize * 2)
			tmpStr = tmpStr ColId "," ColSize ColStr ",\n"
		}
		# I\do^܂B
		if(!(tmpStr in aTable)) {
			sSource = sSource (NumCols-1) ",//" TableIndex "\n" tmpStr	# \[Xɒǉ
			aTable[tmpStr] = TableIndex
			TableIndex += (1 + tmpSize)
		}
		sHeader = sHeader "#define LotTbl_" TableName " " aTable[tmpStr] "\n"	# wb_ɒǉ
	}
	# e[uNA܂B
	TableName = ""
	# e[uf[^NA܂B
	NumCols = 0
	NumRows = 0
	delete TableData
}

#*******************************************************************************
# Jn̏s܂B
BEGIN {
	#tB[hZp[^^uɐݒ肵܂B(CSV)
	FS = "\t"
	# \[Xo͂鎞ɁA[0]͖vfƂĖIɏo͂܂BLvf[1]o^܂B
	TableIndex = 1
}

#*******************************************************************************
# sȊO܂B
NF != 0 {
	# etB[h̐擪Ɩ̋󔒂폜܂B
	for(Col = 1; Col <= NF; Col++) {
		gsub(/(^[[:blank:]]+)|([[:blank:]]+$)/, "", $Col)
	}
	# tB[h1Ȃ΁c
	if(NF == 1) {
		# e[uƌȂAe[uJn܂B
		BeginTable()
	# tB[h2ȏȂ΁c
	} else {
		# e[uf[^słBe[uJnĂȂĂ͂Ȃ܂B
		if(TableName == "") {
			die(FILENAME "(" FNR ")" "e[uJnÕf[^`܂Bf[^ɁAe[uKvłB")
		}
		# e[uJnAsڂ̃e[uf[^sȂ΁c
		if(NumCols == 0) {
			# 񐔂L܂B
			NumCols = NF
		# e[uJnAsڈȍ~̃e[uf[^sȂ΁c
		} else {
			# 񐔂ł邱ƂmF܂B
			if(NF != NumCols) {
				die(FILENAME "(" FNR ")" "񐔂قȂ܂B̃e[ȗSĂ̍s̗񐔂́AłȂĂ͂Ȃ܂B")
			}
		}
		# s𑝂₵܂B
		NumRows++
		# e[uf[^i[܂B
		for(Col = 1; Col <= NumCols; Col++) {
			TableData[Col, NumRows] = $Col
			# I\̒̑SĂ̗vf́AłĂ͂Ȃ܂B
			if($Col == "") {
				die(FILENAME "(" FNR ")" Col "ڂɁAsȗvf̒`܂BI\̒̑SĂ̗vf́AłĂ͂Ȃ܂B")
			}
			# sڂ́AIid̍słB
			if(NumRows == 1) {
				if(Col == 1) {
					# sڂ̈ڂ̃Z͖܂BĂ\܂B
					#** no job **#
				} else {
					# sڂ̓ڈȍ~́AIidłBlAÁAV{łB
					# AwkXNvgŁAl,,,V{ł邱ƂmF͓̂߁Ał͊mFAo̓f[^̃RpCG[Ŕf邱Ƃɂ܂B
				}
			# sڈȍ~́AIlƏdݒl̍słB
			} else {
				if(Col == 1) {
					# sڈȍ~̈ڂ̃ŹAIlłBÁAV{łB
					# AwkXNvgŁAl,,,V{ł邱ƂmF͓̂߁Ał͊mFAo̓f[^̃RpCG[Ŕf邱Ƃɂ܂B
				} else {
					# sڈȍ~̓ڈȍ~̃ŹAdݒlłBÁAV{łB
					# AwkXNvgŁAl,,,V{ł邱ƂmF͓̂߁Ał͊mFAo̓f[^̃RpCG[Ŕf邱Ƃɂ܂B
				}
			}
		}
	}
}

#*******************************************************************************
# Ȉs܂B
END {
	# die()oRȂ΁AEND̃ANVsɏI܂B
	if(_die_exit) {
		exit	# Awk̎dl: texitŏɎsǍňexitsƁȂOɎgIXe[^XƂĎg
	}
	# mɁAe[uI܂B
	EndTable()
	# wb_o͂܂B
	print  "//{{HEADER"
	printf sHeader
	print  "#define LotTbl_SIZE " TableIndex
	print "extern const unsigned short TBL_LotTbl[LotTbl_SIZE];"
	print  "//}}HEADER"
	# \[Xo͂܂B
	print  "//{{SOURCE"
	print  "#include \"app.h\""
	print  "const unsigned short TBL_LotTbl[" TableIndex "]={0,"
	printf sSource
	print  "};"
	print  "//}}SOURCE"
}
