;	
;	framz80a.s
;
;	P/ECE Z80 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sun Feb 22 10:45:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;	  ܂ŁÃ[`framz80.c̃CCAZuŒ`Ă܂B
;	  CPŨG~[VvOɍ킹āAPƂ.st@Cֈړ܂B
;
#include "clipz80a.h"
#ifdef Z80_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

;
;	Z80\ clipz80a.sɂ`Ă!!
;
;===== WX^ =====
#define F		 0
#define A		 1
#define C		 2
#define B		 3
#define E		 4
#define D		 5
#define L		 6
#define H		 7
#define AF		 0
#define BC		 2
#define DE		 4
#define HL		 6
#define AF2		 8
#define BC2		10
#define DE2		12
#define HL2		14
#define IXL		16
#define IXH		17
#define IYL		18
#define IYH		19
#define IX		16
#define IY		18
#define SP		20
#define PC		22
;=====  =====
#define IFF1		32
#define IFF2		33
#define IM		34
#define HALT		35
#define CYCLE		36
;{{2005/01/07 INTvۗΉ̂߂ɒǉ
#define PENDING		40
#define PENDING_NO	41
;}}2005/01/07 INTvۗΉ̂߂ɒǉ
;===== O֐ =====
#define READ		48
#define WRITE		52
#define IN		56
#define OUT		60

;****************************************************************************
;	
;****************************************************************************

;
;	Z80G~[Vs܂B
;
;	* Fri Nov 28 06:00:00 JST 2003 Naoyuki Sawa
;	- argc̏o䗦uargc=0argc=1argc=2vƉ肵č܂B
;	  z80op_CB/ED/DD/FD/DDCB/FDCBɂĂlłB
;
	.global z80_run
z80_run:
	pushn %r3
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.w %r3, [%r0+READ]		; z80->read
	xld.w [%r0+CYCLE], %r13		; CYCLE
	xcmp %r13, 0			; if(CYCLE <= 0) break
	xjrle z80_run_L50
	;
z80_run_L10:
	xld.ub %r10, [%r0+HALT]		; if(HALT) break
	xld.uh %r1, [%r0+PC]		; PC *anti-interlock*
	xcmp %r10, 0
	xjrne z80_run_L50
	;
	ld.w %r12, %r0			; code = z80->read(z80, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table		; op = &z80_op_table[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 0 ?
	xcmp %r10, 0	
	xjreq z80_run_L20
	xld.b [%sp+0], %r13		; (save code)
	;
	ld.w %r12, %r0			; arg1 = z80->read(z80, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 1 ?
	xcmp %r10, 1	
	xjreq z80_run_L30
	xld.b [%sp+1], %r14		; (save arg1)
	;
	ld.w %r12, %r0			; arg2 = z80->read(z80, PC++)
	ld.w %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
z80_run_L30:
	xld.ub %r13, [%sp+0]		; (restore code)
z80_run_L20:
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	xjrgt z80_run_L10		; if(CYCLE <= 0) break
z80_run_L50:
	;
	xadd %sp, %sp, 4
	popn %r3
	ret

;****************************************************************************

;
;	CB XX ߂̃e[uWvłB
;
	.global z80op_CB
z80op_CB:
	pushn %r2
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_CB	; op = &z80_op_table_CB[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	popn %r2
	ret

;****************************************************************************

;
;	ED XX ߂̃e[uWvłB
;
	.global z80op_ED
z80op_ED:
	pushn %r2
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_ED	; op = &z80_op_table_ED[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 0 ?
	xcmp %r10, 0	
	xjreq z80op_ED_L10
	xld.b [%sp+0], %r13		; (save code)
	;
	xld.w %r11, [%r0+READ]		; arg1 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	xld.b [%sp+1], %r10		; (save arg1)
	;
	xld.w %r11, [%r0+READ]		; arg2 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
	xld.ub %r13, [%sp+0]		; (restore code)
z80op_ED_L10:
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	DD XX ߂̃e[uWvłB
;
	.global z80op_DD
z80op_DD:
	pushn %r2
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_DD	; op = &z80_op_table_DD[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 0 ?
	xcmp %r10, 0	
	xjreq z80op_DD_L10
	xld.b [%sp+0], %r13		; (save code)
	;
	xld.w %r11, [%r0+READ]		; arg1 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 1 ?
	xcmp %r10, 1	
	xjreq z80op_DD_L20
	xld.b [%sp+1], %r14		; (save arg1)
	;
	xld.w %r11, [%r0+READ]		; arg2 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
z80op_DD_L20:
	xld.ub %r13, [%sp+0]		; (restore code)
z80op_DD_L10:
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	FD XX ߂̃e[uWvłB
;
	.global z80op_FD
z80op_FD:
	pushn %r2
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_FD	; op = &z80_op_table_FD[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 0 ?
	xcmp %r10, 0	
	xjreq z80op_FD_L10
	xld.b [%sp+0], %r13		; (save code)
	;
	xld.w %r11, [%r0+READ]		; arg1 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	xld.ub %r10, [%r2+4]		; argc == 1 ?
	xcmp %r10, 1	
	xjreq z80op_FD_L20
	xld.b [%sp+1], %r14		; (save arg1)
	;
	xld.w %r11, [%r0+READ]		; arg2 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	xld.ub %r14, [%sp+1]		; (restore arg1)
z80op_FD_L20:
	xld.ub %r13, [%sp+0]		; (restore code)
z80op_FD_L10:
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	DD CB d XX ߂̃e[uWvłB
;
	.global z80op_DDCB
z80op_DDCB:
	pushn %r2
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; arg1 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	xld.b [%sp+0], %r10		; (save arg1)
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_DDCB	; op = &z80_op_table_DDCB[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r14, [%sp+0]		; (restore arg1)
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	FD CB d XX ߂̃e[uWvłB
;
	.global z80op_FDCB
z80op_FDCB:
	pushn %r2
	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	xld.uh %r1, [%r0+PC]		; PC
	;
	xld.w %r11, [%r0+READ]		; arg1 = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	xld.b [%sp+0], %r10		; (save arg1)
	;
	xld.w %r11, [%r0+READ]		; code = z80->read(z80, PC++)
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	xld.w %r2, z80_op_table_FDCB	; op = &z80_op_table_FDCB[code]
	xsll %r10, 3
	add %r2, %r10
	;
	xld.ub %r14, [%sp+0]		; (restore arg1)
	;
	xld.w %r10, [%r2+0]		; op->proc(z80, code, arg1, arg2)
	xld.h [%r0+PC], %r1		; PC *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	xld.w %r10, [%r0+CYCLE]		; CYCLE -= op->cycle
	xld.ub %r11, [%r2+5]
	sub %r10, %r11
	xld.w [%r0+CYCLE], %r10
	;
	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************
;	General-Purpose Arithmetic and CPU Control Group
;****************************************************************************

;
;	8rbgZs܂B
;
	.global z80_ADD8
z80_ADD8:
	xld.ub %r14, [%r12+A]			; A
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	add %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	xand %r11, %r11, 0xf
	xld.ub %r11, [%r11+z80_FLAG_CONV]
	;
	swap %r10, %r10				; A
	xld.b [%r12+A], %r10
	;
	xand %r10, %r10, 0x28			; F(Y,X)
	or %r11, %r10
	;
	xand %r14, %r14, 0xf			; F(H)
	xand %r13, %r13, 0xf
	add %r14, %r13
	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZ(L[)s܂B
;
;	* {A,n,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	  ڂƓڂ̉Z̃I[o[t[tOAr_aōƂ낪|Cg!
;
	.global z80_ADC8
z80_ADC8:
	xld.ub %r15, [%r12+F]			; F(C)
	xld.ub %r14, [%r12+A]			; A *anti-interlock*
	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A + n
	swap %r11, %r13
	add %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	xand %r11, %r11, 0xc
	;
	swap %r4, %r15				; A + n + c
	add %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r5, %r4, 0x4
	xor %r11, %r5
	xand %r4, %r4, 0xb
	or %r11, %r4
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	;
	swap %r10, %r10				; A
	xld.b [%r12+A], %r10
	;
	xand %r10, %r10, 0x28			; F(Y,X)
	or %r11, %r10
	;
	xand %r14, %r14, 0xf			; F(H)
	xand %r13, %r13, 0xf
	add %r14, %r13
	add %r14, %r15
	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZs܂B
;
	.global z80_SUB8
z80_SUB8:
	xld.ub %r14, [%r12+A]			; A
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	sub %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	xand %r11, %r11, 0xf
	xld.ub %r11, [%r11+z80_FLAG_CONV]
	;
	swap %r10, %r10				; A
	xld.b [%r12+A], %r10
	;
	xand %r10, %r10, 0x28			; F(Y,X)
	or %r11, %r10
	;
	xand %r14, %r14, 0xf			; F(H)
	xand %r13, %r13, 0xf
	sub %r14, %r13
	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	xoor %r11, %r11, 2			; F(N)
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZ({[)s܂B
;
;	{A,n,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	ڂƓڂ̉Z̃I[o[t[tOAr_aōƂ낪|Cg!
;
	.global z80_SBC8
z80_SBC8:
	xld.ub %r15, [%r12+F]			; F(C)
	xld.ub %r14, [%r12+A]			; A *anti-interlock*
	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A - n
	swap %r11, %r13
	sub %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	xand %r11, %r11, 0xc
	;
	swap %r4, %r15				; A - n - c
	sub %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r5, %r4, 0x4
	xor %r11, %r5
	xand %r4, %r4, 0xb
	or %r11, %r4
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	;
	swap %r10, %r10				; A
	xld.b [%r12+A], %r10
	;
	xand %r10, %r10, 0x28			; F(Y,X)
	or %r11, %r10
	;
	xand %r14, %r14, 0xf			; F(H)
	xand %r13, %r13, 0xf
	sub %r14, %r13
	sub %r14, %r15
	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	xoor %r11, %r11, 2			; F(N)
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	_ς߂܂B
;
	.global z80_AND
z80_AND:
	xld.ub %r10, [%r12+A]		; A
	and %r10, %r13			; A & n !INTERLOCK!
	xjrne.d z80_AND_L10
	ld.w %r11, 0x10			; F(H) *delay*
	xoor %r11, %r11, 0x40		; F(Z)
z80_AND_L10:
	xld.b [%r12+A], %r10		; A
	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	or %r11, %r13
	or %r11, %r10
	xld.b [%r12+F], %r11		; F
	ret

;****************************************************************************

;
;	_a߂܂B
;
	.global z80_OR
z80_OR:
	xld.ub %r10, [%r12+A]		; A
	or %r10, %r13			; A | n !INTERLOCK!
	xjrne.d z80_OR_L10
	ld.w %r11, 0			; *delay*
	xoor %r11, %r11, 0x40		; F(Z)
z80_OR_L10:
	xld.b [%r12+A], %r10		; A
	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	or %r11, %r13
	or %r11, %r10
	xld.b [%r12+F], %r11		; F
	ret

;****************************************************************************

;
;	r_a߂܂B
;
	.global z80_XOR
z80_XOR:
	xld.ub %r10, [%r12+A]		; A
	xor %r10, %r13			; A ^ n !INTERLOCK!
	xjrne.d z80_XOR_L10
	ld.w %r11, 0			; *delay*
	xoor %r11, %r11, 0x40		; F(Z)
z80_XOR_L10:
	xld.b [%r12+A], %r10		; A
	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	or %r11, %r13
	or %r11, %r10
	xld.b [%r12+F], %r11		; F
	ret

;****************************************************************************

;
;	rs܂B
;
	.global z80_CP
z80_CP:
	xld.ub %r14, [%r12+A]			; A
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	cmp %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	xand %r11, %r11, 0xf
	xld.ub %r11, [%r11+z80_FLAG_CONV]
	;
	xand %r10, %r13, 0x28			; F(Y,X) *anti-interlock*
	or %r11, %r10
	;
	xand %r14, %r14, 0xf			; F(H)
	xand %r13, %r13, 0xf
	sub %r14, %r13
	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	xoor %r11, %r11, 2			; F(N)
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbglCNg܂B
;
;	{r,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	CłɊrׂăTCY͏ǁA1%炢xȂĂ܂܂EEE
;
	.global z80_INC8
z80_INC8:
	swap %r10, %r13				; r + 1
	xadd %r10, %r10, 0x01000000
	;
	ld.w %r11, %psr				; %psr(V,N,Z)
	xand %r11, %r11, 0x7
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V)
	;
	swap %r10, %r10				; r
	;
	xand %r14, %r10, 0x28			; F(Y,X)
	xld.ub %r15, [%r12+F]			; F(C)
	or %r11, %r14				; *anti-interlock*
	xand %r15, %r15, 1
	or %r11, %r15
	;
	xand %r13, %r13, 0xf			; F(H)
	xadd %r13, %r13, 1
	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbglfNg܂B
;
;	{r,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	CłɊrׂăTCY͏ǁA1%炢xȂĂ܂܂EEE
;
	.global z80_DEC8
z80_DEC8:
	swap %r10, %r13				; r - 1
	xsub %r10, %r10, 0x01000000
	;
	ld.w %r11, %psr				; %psr(V,N,Z)
	xand %r11, %r11, 0x7
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V)
	;
	swap %r10, %r10				; r
	;
	xand %r14, %r10, 0x28			; F(Y,X)
	xld.ub %r15, [%r12+F]			; F(C)
	or %r11, %r14				; *anti-interlock*
	xand %r15, %r15, 1
	or %r11, %r15
	;
	xand %r13, %r13, 0xf			; F(H)
	xsub %r13, %r13, 1
	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	xoor %r11, %r11, 2			; F(N)
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************
;	16-Bit Arithmetic Group
;****************************************************************************

;
;	16rbgZs܂B
;
	.global z80_ADD16
z80_ADD16:
	xld.ub %r11, [%r12+F]			; F(S,Z,V)
	ld.w %r10, %r13				; rr + nn *anti-interlock*
	xand %r11, %r11, 0xc4
	add %r10, %r14
	xand %r15, %r10, 0xffff0000
	xjreq z80_ADD16_L10
	sub %r10, %r15
	xoor %r11, %r11, 1			; F(C)
z80_ADD16_L10:
	;
	ld.w %r15, %r10				; F(Y,X)
	xsrl %r15, 8
	xand %r15, %r15, 0x28
	or %r11, %r15
	;
	xand %r13, %r13, 0xfff			; F(H)
	xand %r14, %r14, 0xfff
	add %r13, %r14
	xsrl %r13, 8
	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	16rbgZ(L[)s܂B
;
	.global z80_ADC16
z80_ADC16:
	xld.ub %r15, [%r12+F]			; F(C)
	ld.w %r10, %r13
	ld.w %r11, %r14
	xand %r15, %r15, 1
	;
	xsll %r10, 16				; rr + nn
	xsll %r11, 16
	add %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	xand %r11, %r11, 0xc
	;
	ld.w %r4, %r15				; rr + nn + c
	xsll %r4, 16
	add %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r5, %r4, 0x4
	xor %r11, %r5
	xand %r4, %r4, 0xb
	or %r11, %r4
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	;
	xsrl %r10, 16				; rr
	;
	ld.w %r4, %r10				; F(Y,X)
	xsrl %r4, 8
	xand %r4, %r4, 0x28
	or %r11, %r4
	;
	xand %r13, %r13, 0xfff			; F(H)
	xand %r14, %r14, 0xfff
	add %r13, %r14
	add %r13, %r15
	xsrl %r13, 8
	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************

;
;	16rbgZ({[)s܂B
;
	.global z80_SBC16
z80_SBC16:
	xld.ub %r15, [%r12+F]			; F(C)
	ld.w %r10, %r13
	ld.w %r11, %r14
	xand %r15, %r15, 1
	;
	xsll %r10, 16				; rr - nn
	xsll %r11, 16
	sub %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	xand %r11, %r11, 0xc
	;
	ld.w %r4, %r15				; rr - nn - c
	xsll %r4, 16
	sub %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	xand %r5, %r4, 0x4
	xor %r11, %r5
	xand %r4, %r4, 0xb
	or %r11, %r4
	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	;
	xsrl %r10, 16				; rr
	;
	ld.w %r4, %r10				; F(Y,X)
	xsrl %r4, 8
	xand %r4, %r4, 0x28
	or %r11, %r4
	;
	xand %r13, %r13, 0xfff			; F(H)
	xand %r14, %r14, 0xfff
	sub %r13, %r14
	sub %r13, %r15
	xsrl %r13, 8
	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	xoor %r11, %r11, 2			; F(N)
	;
	xld.b [%r12+F], %r11			; F
	;
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*Z80_ASM*/
