/*
 *	framht2.c
 *
 *	2D蔻胋[``܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Sun Oct 08 13:37:42 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* QlAukeep/p`̌莑.7zvɕۑĂ܂B */

/*****************************************************************************
 *	ht2_seg_seg
 *****************************************************************************/

/* * Mon Oct 09 08:46:56 JST 2006 Naoyuki Sawa
 * - u|jnmd's c|r|v̋L (http://kone.vis.ne.jp/)
 *   wp`̌ҁ|Qi_̓Ojx      (http://kone.vis.ne.jp/diary/diaryb09.html#040518)
 *   wp`̌ҁ|PiTvƕӂ̌jx(http://kone.vis.ne.jp/diary/diaryb09.html#040528)
 *   QlɂĂ܂B
 * - uAB_CƓ_D𕪒fĂ邩A܂́A_CƓ_D̏ȂƂABɗLv̔fA
 *   ʑΊp炢̑傫̐m̔莞ɁAŒ菬Zł͂ɃI[o[t[Ă܂܂B
 *   I[o[t[h߂ɁAZg킸Arbg(bit31)Xor@Ŏ܂B
 *   AZo[W쐬ꍇ́AZg@ō쐬ĂB
 */
int
ht2_seg_seg(fixed ax, fixed ay, fixed bx, fixed by, fixed cx, fixed cy, fixed dx, fixed dy)
{
	fixed ab_xmin;
	fixed ab_xmax;
	fixed ab_ymin;
	fixed ab_ymax;
	fixed cd_xmin;
	fixed cd_xmax;
	fixed cd_ymin;
	fixed cd_ymax;
	//
	fixed dax;
	fixed day;
	fixed abx;
	fixed aby;
	fixed bcx;
	fixed bcy;
	fixed cdx;
	fixed cdy;
	//
	fixed dab;
	fixed abc;
	fixed bcd;
	fixed cda;

	/* @:
	 * ABƐCD꒼̗ꂽʒuɂꍇO邽߂ɁA
	 * ABƐCD̋E`mɂdȂ蔻s܂B
	 * ̔sȂƁAAŌďdȂƔfĂ܂܂B
	 */
	if(fcom(ax, <=, bx)) { ab_xmin = ax; ab_xmax = bx; }
	else                 { ab_xmin = bx; ab_xmax = ax; }
	if(fcom(cx, <=, dx)) { cd_xmin = cx; cd_xmax = dx; }
	else                 { cd_xmin = dx; cd_xmax = cx; }
	if(fcom(ab_xmax, <, cd_xmin) || fcom(cd_xmax, <, ab_xmin)) {
		return 0;
	}
	if(fcom(ay, <=, by)) { ab_ymin = ay; ab_ymax = by; }
	else                 { ab_ymin = by; ab_ymax = ay; }
	if(fcom(cy, <=, dy)) { cd_ymin = cy; cd_ymax = dy; }
	else                 { cd_ymin = dy; cd_ymax = cy; }
	if(fcom(ab_ymax, <, cd_ymin) || fcom(cd_ymax, <, ab_ymin)) {
		return 0;
	}

	/* A:
	 * ABƐCĎ𔻒f邽߂ɁAȉ̏`FbN܂B
	 * EAB_CƓ_D𕪒fĂ邩A܂́A_CƓ_D̏ȂƂABɗL
	 * ECD_AƓ_B𕪒fĂ邩A܂́A_AƓ_B̏ȂƂCDɗL
	 * ̏ɖꍇAABƐCD͌Ă܂B
	 */
	dax = fsubr(dx, ax); day = fsubr(dy, ay);	/* DA */
	abx = fsubr(ax, bx); aby = fsubr(ay, by);	/* AB */
	bcx = fsubr(bx, cx); bcy = fsubr(by, cy);	/* BC */
	cdx = fsubr(cx, dx); cdy = fsubr(cy, dy);	/* CD */
	dab = fsub(fmul(dax, aby), fmul(abx, day));	/* DA~AB */
	abc = fsub(fmul(abx, bcy), fmul(bcx, aby));	/* AB~BC */
	//if(ficom(fmul(dab, abc), >, 0)) {
	//I[o[t[h~
	if(dab && abc && ((int)dab ^ (int)abc) > 0) {
		return 0;
	}
	bcd = fsub(fmul(bcx, cdy), fmul(cdx, bcy));	/* BC~CD */
	cda = fsub(fmul(cdx, day), fmul(dax, cdy));	/* CD~DA */
	//if(ficom(fmul(bcd, cda), >, 0)) {
	//I[o[t[h~
	if(bcd && cda && ((int)bcd ^ (int)cda) > 0) {
		return 0;
	}

	return 1;
}

/*****************************************************************************
 *	ht2_pt_pgn
 *****************************************************************************/

/* * Mon Oct 09 08:46:56 JST 2006 Naoyuki Sawa
 * - ȑOɕo[WŎ̂ƁAقړASYłB
 *   ukeep/01_ŉZ`R[hۑ/clipmath.cv́Apoint_in_polygon()QƂĂB
 * - point_in_polygon()ɊrׂāAȉ̎O_P܂B
 *   E΂̒_TƂɁAɋE`߁A܂ȓ蔻sč܂B
 *   Ep[^F́u-Fv̌`ŗp̂ŁA炩߁u-FvƂċ߂Ă悤ύX܂B
 *   E_Ap`̕ӏ܂͒_ɗLꍇɁAĊOƔfꍇ̂C܂B
 *	@Q	Ƃ΁A}̂悤ȑp`1-2-3-4́A_1ɑ݂_̓OsꍇA
 *	@	4-1Ƃ̔莞ɈA2-3Ƃ̔莞Ɉ́AvŊOƔfĂ܂B
 *	SR	̖h߁A_p`̕ӏ܂͒_ɂꍇ́AɓƔf܂B
 */
int
ht2_pt_pgn(fixed px, fixed py, const fixed pgn[/*n*/][2/*x,y*/], int n)
{
	int i;
	int j;
	int cross;
	fixed x0;
	fixed y0;
	fixed x1;
	fixed y1;
	fixed  C;
	fixed  D;
	fixed  E;
	fixed _F;
	fixed DE_CF;
	fixed Dprev;
	fixed xmin;
	fixed xmax;
	fixed ymin;
	fixed ymax;

	/* p`̒_0Ȃ΁A蔻薳ƌȂ܂B(2006/10/17ǉ) */
	if(!n) {
		return 0;
	}

	/* ΂̒_ȂAɋE{bNX߁A܂ȓ蔻s܂B */
	i = 0;
	xmin = xmax = pgn[i][0];
	ymin = ymax = pgn[i][1];
	for(j = 1; j < n; j++) {
		x0 = pgn[j][0];
		y0 = pgn[j][1];
		if(fcom(x0, <, xmin)) { xmin = x0;        } else if(fcom(x0, >, xmax)) { xmax = x0; }
		if(fcom(y0, <, ymin)) { ymin = y0; i = j; } else if(fcom(y0, >, ymax)) { ymax = y0; }
	}
	if(fcom(px, <, xmin) || fcom(px, >, xmax) ||
	   fcom(py, <, ymin) || fcom(py, >, ymax)) {
		return 0;
	}

	/* _n_Ƃ锼ƁAp`̕ӂ̌񐔂߁AȂΓAȂΊOłB */
	cross = 0;
	Dprev = 0;
	x0 = pgn[i][0];
	y0 = pgn[i][1];
	for(j = 0; j < n; j++) {
		if(++i == n) {
			i = 0;
		}
		x1 = pgn[i][0];
		y1 = pgn[i][1];

		 C = fsub(x1, x0);
		 D = fsub(y1, y0);
		 E = fsub(x0, px);
		_F = fsub(py, y0); /* -F */

		DE_CF = fadd(fmul(D, E), fmul(C, _F)); /* DE-CF */
		if(!DE_CF) {
			return 1; /* _Ap`̕ӏA܂́A_ɗL */
		}
		if(ficom(D, >, 0)) {
			if(ficom(Dprev, >, 0)) { if(ficom(DE_CF, >, 0) && ficom(_F, > , 0) && fcom(D, >=, _F)) cross++; }
			else                   { if(ficom(DE_CF, >, 0) && ficom(_F, >=, 0) && fcom(D, >=, _F)) cross++; }
			Dprev = D;
		} else if(ficom(D, <, 0)) {
			if(ficom(Dprev, <, 0)) { if(ficom(DE_CF, <, 0) && ficom(_F, < , 0) && fcom(D, <=, _F)) cross++; }
			else                   { if(ficom(DE_CF, <, 0) && ficom(_F, <=, 0) && fcom(D, <=, _F)) cross++; }
			Dprev = D;
		}

		x0 = x1;
		y0 = y1;
	}
	return cross & 1;
}

/*****************************************************************************
 *	ht2_pgn_pgn
 *****************************************************************************/

/* * Mon Oct 09 08:46:56 JST 2006 Naoyuki Sawa
 * - u|jnmd's c|r|v̋L (http://kone.vis.ne.jp/)
 *   wp`̌ҁ|Qi_̓Ojx      (http://kone.vis.ne.jp/diary/diaryb09.html#040518)
 *   wp`̌ҁ|PiTvƕӂ̌jx(http://kone.vis.ne.jp/diary/diaryb09.html#040528)
 *   QlɂĂ܂B
 */
int
ht2_pgn_pgn(const fixed a[/*na*/][2/*x,y*/], int na, const fixed b[/*nb*/][2/*x,y*/], int nb)
{
	int i;
	int j;
	fixed ax0;
	fixed ay0;
	fixed ax1;
	fixed ay1;
	fixed bx0;
	fixed by0;
	fixed bx1;
	fixed by1;
	fixed a_xmin;
	fixed a_xmax;
	fixed a_ymin;
	fixed a_ymax;
	fixed b_xmin;
	fixed b_xmax;
	fixed b_ymin;
	fixed b_ymax;

	/* p`̒_0Ȃ΁A蔻薳ƌȂ܂B(2006/10/17ǉ) */
	//if(!na || !nb) {	// cmp %NA,0; jreq EXIT; cmp %NB,0; jreq EXIT;
	//
	if(!(na & nb)) {	// ld.w %TMP,%NA; and %TMP,%NB; jreq EXIT;
		return 0;
	}

	/* E`߁A܂ȓ蔻s܂B */
	a_xmin = a_xmax = a[0][0];
	a_ymin = a_ymax = a[0][1];
	for(i = 1; i < na; i++) {
		ax0 = a[i][0];
		ay0 = a[i][1];
		if(fcom(ax0, <, a_xmin)) { a_xmin = ax0; } else if(fcom(ax0, >, a_xmax)) { a_xmax = ax0; }
		if(fcom(ay0, <, a_ymin)) { a_ymin = ay0; } else if(fcom(ay0, >, a_ymax)) { a_ymax = ay0; }
	}
	b_xmin = b_xmax = b[0][0];
	b_ymin = b_ymax = b[0][1];
	for(i = 1; i < nb; i++) {
		bx0 = b[i][0];
		by0 = b[i][1];
		if(fcom(bx0, <, b_xmin)) { b_xmin = bx0; } else if(fcom(bx0, >, b_xmax)) { b_xmax = bx0; }
		if(fcom(by0, <, b_ymin)) { b_ymin = by0; } else if(fcom(by0, >, b_ymax)) { b_ymax = by0; }
	}
	if(fcom(a_xmax, <, b_xmin) || fcom(b_xmax, <, a_xmin) ||
	   fcom(a_ymax, <, b_ymin) || fcom(b_ymax, <, a_ymin)) {
		return 0;
	}

	/* m̌sAp`mĂ邩f܂B */
	ax0 = a[na - 1][0];
	ay0 = a[na - 1][1];
	for(i = 0; i < na; i++) {
		ax1 = a[i][0];
		ay1 = a[i][1];
		bx0 = b[nb - 1][0];
		by0 = b[nb - 1][1];
		for(j = 0; j < nb; j++) {
			bx1 = b[j][0];
			by1 = b[j][1];
			if(ht2_seg_seg(ax0, ay0, ax1, ay1, bx0, by0, bx1, by1)) {
				return 1; /* Ă */
			}
			bx0 = bx1;
			by0 = by1;
		}
		ax0 = ax1;
		ay0 = ay1;
	}

	/* ̑p`ɂ̑p`SɊ܂܂Ă邩f܂B */
	if(ht2_pt_pgn(a[0][0], a[0][1], b, nb)) {
		return 1; /* p`Ap`B܂ł */
	}
	if(ht2_pt_pgn(b[0][0], b[0][1], a, na)) {
		return 1; /* p`Bp`A܂ł */
	}

	return 0;
}

/*****************************************************************************
 *	ht2_srt_pgn
 *****************************************************************************/

void
ht2_srt_pgn(const SRT* srt, const fixed pgn_in[/*n*/][2/*x,y*/], fixed pgn_out[/*n*/][2/*x,y*/], int n)
{
	if(n) { /* "while(n--){...}""do{...}while(--n);"̂̕ŁAɔ肵Ă܂B */
		const fixed* p_in  = &pgn_in [0][0];
		      fixed* p_out = &pgn_out[0][0];
		if(ficom(srt->r, ==, 0) && ficom(srt->s, ==, 1)) {
			/* gk]̃P[XƎv̂ŁAPɍ܂B */
			do {
				*p_out++ = fadd(*p_in++, srt->x);
				*p_out++ = fadd(*p_in++, srt->y);
			} while(--n);
		} else {
			/* | Xout |   | cos(r)*s -sin(r)*s x | | Xin |
			 * | Yout | = | sin(r)*s  cos(r)*s y | | Yin |
			 * |    1 |   |        0         0 1 | |   1 |
			 */
			fixed c = fmul(fcos(srt->r), srt->s);
			fixed s = fmul(fsin(srt->r), srt->s);
			do {
				fixed x = *p_in++; /* pgn_in==pgn_out̏ꍇ̂߂ɁA */
				fixed y = *p_in++; /* oĂKv܂B  */
				*p_out++ = fadd(fsub(fmul(c, x), fmul(s, y)), srt->x);
				*p_out++ = fadd(fadd(fmul(s, x), fmul(c, y)), srt->y);
			} while(--n);
		}
	}
}
