/*
 *	clipsrch.c
 *
 *	POSIXW̃jAT[`֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Jan 13 19:05:18 JST 2014 Naoyuki Sawa
 *	- lfind()lsearch()̐錾Aclippce.hinclude/search.h֕܂B
 *	- lfind()lsearch()̎Aclippce.cclipsrch.c֕܂B
 *	* Fri Feb 14 21:17:26 JST 2014 Naoyuki Sawa
 *	- hcreate(),hsearch(),hdestroy(),hcreate_r(),hsearch_r(),hdestroy_r()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* * Sat Jul 04 21:25:58 JST 2009 Naoyuki Sawa
 * - POSIXW̃jAT[`֐łB
 *   VŴ悤ŁAP/ECEJEPSONCuɂ͊܂܂ĂȂ̂ŁAŎ܂B
 *   PȏłA\[g̔zjAT[`(=bsearch()͎gȂ)ꍇ͌\L̂ŁA֗Ǝv܂B
 * - ֐dĺAWeb̎AMSDNȂǂQƂĂB(Visual C++ 6.0MSDNɂڂĂ܂B)
 *   lfind()̈ŁAnum|C^nȂ̂ʂɌ܂A炭Alsearch()ƈ^v߂Ǝv܂B
 *   ܂AbaseAlfind()constAlsearch()͔constłႢɒӂĂB
 *   lfind()͔zύXAlsearch()͌ȂƂɔzɗvfǉ邱ƂA邽߂Ǝv܂B
 *   (̊ɂ́Alfind()̖߂ľ^͔constɂȂĂ_Aѐ܂񂪁c)
 * - lsearch()gāAȒPɁAd̖Zbg쐬邱Ƃł܂B
 *   ȉɁAgp܂B
 *	<>
 *		static int compare(const void* elem1, const void* elem2) {
 *			char* str1 = *(char**)elem1;
 *			char* str2 = *(char**)elem2;
 *			return strcmp(str1, str2);
 *		}
 *		void sample() {
 *			char* set[10];
 *			int num = 0;
 *			char* key;
 *			int i;
 *			if(num < 10) key = "One";   lsearch(&key, set, &num, sizeof set[0], compare);
 *			if(num < 10) key = "Two";   lsearch(&key, set, &num, sizeof set[0], compare);
 *			if(num < 10) key = "One";   lsearch(&key, set, &num, sizeof set[0], compare);
 *			if(num < 10) key = "Three"; lsearch(&key, set, &num, sizeof set[0], compare);
 *			if(num < 10) key = "Two";   lsearch(&key, set, &num, sizeof set[0], compare);
 *			if(num < 10) key = "Four";  lsearch(&key, set, &num, sizeof set[0], compare);
 *			for(i = 0; i < num; i++) { printf("%d: %s\n", i, set[i]); }
 *		}
 *	<>
 *		0: One
 *		1: Two
 *		2: Three
 *		3: Four
 */

void*
lfind(const void* key, const void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2))
{
	int i = *num;
	while(i) {
		if(!(*compare)(key, base)) {
			return (void*)base;
		}
		base = (char*)base + width;
		i--;
	}
	return NULL;
}

void*
lsearch(const void* key, void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2))
{
	void* ptr = lfind(key, base, num, width, compare);
	if(!ptr) {
		ptr = memcpy((char*)base + ((*num)++ * width), key, width);
	}
	return ptr;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* hcreate(),hsearch(),hdestroy()p */
static struct hsearch_data _htab;

/* struct hsearch_data ̓f[^ */
struct hsearch_internal_data {
	unsigned size;
	ENTRY table[0/*size*/];
};

/*--------------------------------------------------------------------------*/
int hcreate(size_t nel) {
	return hcreate_r(nel, &_htab);
}
int hcreate_r(size_t nel, struct hsearch_data* htab) {
	/* sĆCe[uς݂Ȃ΁AG[~B */
	if(!nel || !htab || htab->internal) { DIE(); }
	/* f[^mۂB */
	htab->internal = calloc(sizeof(struct hsearch_internal_data) + (sizeof(ENTRY) * nel), 1);
	if(!htab->internal) { DIE(); }	/* s */
	/* e[u̍őGgi[B */
	htab->internal->size = nel;
	return 1;
}

/*--------------------------------------------------------------------------*/
ENTRY* hsearch(ENTRY item, ACTION action) {
	ENTRY* retval;
	hsearch_r(item, action, &retval, &_htab);
	return retval;
}
int hsearch_r(ENTRY item, ACTION action, ENTRY** retval, struct hsearch_data* htab) {
	ENTRY* table;
	unsigned size, i, n;
	/* sĆCe[uȂ΁AG[~B */
	if(!item.key || !retval || !htab || !htab->internal) { DIE(); }
	/* e[u̍őGgƁAe[uAhXoĂB */
	size  = htab->internal->size;
	table = htab->internal->table;
	/* L[̃nbVvZAŏɎQƂGgԍ肷B */
	i = (unsigned)crc32_ieee_r(item.key, strlen(item.key)) % size;
	/* ŏɎQƂGgJnAőGgɒB܂Łc */
	n = size;
	do {
		/* 󂫃Ggc */
		if(!table[i].key) {
			/* actionFINDȂ΁A[v𔲂G[ցB */
			if(action == FIND) { break; }
			/* actionENTERȂ΁AGgi[B */
			table[i] = item;
			*retval = &table[i];
			return 1;
		}
		/* L[vGgc */
		if(!strcmp(table[i].key, item.key)) {
			/* ꍇAaction̒lENTERłׂł͂ȂB
			 * http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/hsearch.3.html
			 * SVr4POSIX.1-2001̋Kł́Aaction͌sƂɂӖƂȂĂB
			 * āAꍇAaction̒lENTERłׂł͂ȂB
			 * o[W2.3O)libcglibc̎͂̋KiɈᔽĂȀ󋵂ŁAw肳ꂽkeyɑΉdataXVB
			 */
		//	if(action == ENTER) { table[i] = item; }  Ă͂Ȃ!!
			*retval = &table[i];
			return 1;
		}
		if(++i == size) { i = 0; }
	} while(--n);
	/* actionENTERŁAkeye[uɌ炸Ae[uɐVGgǉ]nȂB
	 * ́AactionFINDŁAkeye[uɌȂB
	 */
	*retval = NULL;
	return 0;
}

/*--------------------------------------------------------------------------*/
void hdestroy() {
	hdestroy_r(&_htab);
}
void hdestroy_r(struct hsearch_data* htab) {
	/* sȂ΁AG[~B */
	if(!htab) { DIE(); }
	/* f[^JBe[uȂ΁A_~[ƂȂB */
	free(htab->internal);
	/* e[uł邱ƂA}[NB */
	htab->internal = NULL;
}

