/*
 *	clipsndx.c
 *
 *	Sound Mixer
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Mar 24 10:56:48 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- Sound Mixer쐬ŔAL̒ʂłB
 *	  ȑOSound Manager(clipsndm.h,c)쐬̂łAgÂ炭܂𗧂܂łB
 *	  ŁAۂ̃AvP[VŕKvȋ@\ɍiāASound Mixer쐬邱Ƃɂ܂B
 *	- Sound MixeŕATEhV[PT(clipsnds.h,c)Ƃ̕pz肵č쐬܂B
 *	  t[YPʂ̉ʐ́ATEhV[PTɔC܂B
 *	  Sound MixeŕATEh`l̃O[vPʂŁAďʐsƂړIłB
 *	- gp clip/test.pce/app.c QƂĂB
 */
#include "clip.h"

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

ST_SndMxr* SndMxr_Init(int nSndMxrCh, const int pSndChMask[/*nSndMxrCh*/]) {
	ST_SndMxr* pSndMxr;
	/* Sound Mixer\̂̃mۂB */
	pSndMxr = malloc(sizeof(ST_SndMxr) + (sizeof(ST_SndMxrCh) * nSndMxrCh));
	if(!pSndMxr) { DIE(); } /* s */
	/* Sound Mixer\̂B */
	SndMxr_InitStatic(pSndMxr, nSndMxrCh, pSndChMask);
	return pSndMxr;
}

/*--------------------------------------------------------------------------*/

void SndMxr_InitStatic(ST_SndMxr* pSndMxr, int nSndMxrCh, const int pSndChMask[/*nSndMxrCh*/]) {
	int iSndMxrCh;
	/* Sound Mixer\̂NAB */
	memset(pSndMxr, 0, sizeof(ST_SndMxr) + (sizeof(ST_SndMxrCh) * nSndMxrCh));
	/* Sound Mixer\̂ɁASound Mixer`li[B */
	pSndMxr->nSndMxrCh = nSndMxrCh;
	/* Sound Mixer`l\̂ɁATEh`l}XNi[B */
	for(iSndMxrCh = 0; iSndMxrCh < pSndMxr->nSndMxrCh; iSndMxrCh++) {
		if(!pSndChMask[iSndMxrCh]) { DIE(); } /* TEh`l}XNz񂪕s */
		pSndMxr->pSndMxrCh[iSndMxrCh].SndChMask = pSndChMask[iSndMxrCh];
	}
}

/*--------------------------------------------------------------------------*/

void SndMxr_Exec(ST_SndMxr* pSndMxr) {
	int iSndMxrCh;
	for(iSndMxrCh = 0; iSndMxrCh < pSndMxr->nSndMxrCh; iSndMxrCh++) {
		/* Sound Mixer`l\̂擾B */
		ST_SndMxrCh* pSndMxrCh = &pSndMxr->pSndMxrCh[iSndMxrCh];
		/* ݌ʂƖڕWʂoĂB */
		int AttNow = pSndMxrCh->AttNow;	/* ݌ */
		int AttTo  = pSndMxrCh->AttTo;	/* ڕW */
		/* ݌ʂƖڕWʂႤȂ(=ωȂ)c */
		if(AttNow != AttTo) {
			/* 덷ɌʕωxZAωʂ߂B */
			div_t d = div(pSndMxrCh->ErrTerm + pSndMxrCh->Rate, pSndMxrCh->Scale);
			/* ωʂcA덷ɏ߂B */
			pSndMxrCh->ErrTerm = d.rem;
			/* ωʂA݌ʂɔfB */
			if(AttNow < AttTo) { if((AttNow += d.quot) > AttTo) { AttNow = AttTo; } } /* ω̏ꍇ */
			else               { if((AttNow -= d.quot) < AttTo) { AttNow = AttTo; } } /* ω̏ꍇ */
			/* ݌ʂ߂B */
			pSndMxrCh->AttNow = AttNow;
		}
	}
}

/*--------------------------------------------------------------------------*/

void SndMxr_SetMxrChAtt(ST_SndMxr* pSndMxr, int iSndMxrCh, int AttTo, int Rate, int Scale) {
	ST_SndMxrCh* pSndMxrCh;
	if(((unsigned)iSndMxrCh >= pSndMxr->nSndMxrCh) || ((unsigned)AttTo > UCHAR_MAX) || ((unsigned)Rate > UCHAR_MAX) || ((unsigned)Scale > UCHAR_MAX)) { DIE(); } /* s */
	/* Sound Mixer`l\̂擾B */
	pSndMxrCh = &pSndMxr->pSndMxrCh[iSndMxrCh];
ENTER_CS; /* SndMxr_Exec()Ăԏꍇ̂߂ɔrsBSndMxr_Exec()ʏ폈Ăԏꍇ͕svAsĂQ͖B */
	/* p[^łAVωJnBp[^Ȃ΁A݂̕ωpB */
	if((pSndMxrCh->AttTo != AttTo) || (pSndMxrCh->Rate != Rate) || (pSndMxrCh->Scale != Scale)) {
		/* p[^i[B */
		pSndMxrCh->AttTo   = AttTo;	/* ڕW */
		pSndMxrCh->Rate    = Rate;	/* ʕωx */
		pSndMxrCh->Scale   = Scale;	/* ʕωx */
		pSndMxrCh->ErrTerm = 0;		/* 덷 */
		/* ʕωx̃p[^Еł0(=f)Ȃ΁AڕWʂ݌ʂ֑fB */
		if(!Rate || !Scale) { pSndMxrCh->AttNow = AttTo; }
	}
LEAVE_CS; /* SndMxr_Exec()Ăԏꍇ̂߂ɔrsBSndMxr_Exec()ʏ폈Ăԏꍇ͕svAsĂQ͖B */
}

/*--------------------------------------------------------------------------*/

int SndMxr_GetSndChAtt(ST_SndMxr* pSndMxr, int iSndCh) {
	int iSndMxrCh, SndChMask, AttSum;
	if((unsigned)iSndCh > 31) { DIE(); } /* s */
	/* w肳ꂽTEh`lɑΉA}XN쐬B */
	SndChMask = 1 << iSndCh;
	/* w肳ꂽTEh`ĺA݌ʂ̍v߂B */
	AttSum = 0;
	for(iSndMxrCh = 0; iSndMxrCh < pSndMxr->nSndMxrCh; iSndMxrCh++) {
		/* Sound Mixer`l\̂擾B */
		ST_SndMxrCh* pSndMxrCh = &pSndMxr->pSndMxrCh[iSndMxrCh];
		/* Sound Mixer`l̃TEh`l}XNAw肳ꂽTEh`l܂ނȂ΁A݌ʂZB */
		if(pSndMxrCh->SndChMask & SndChMask) { AttSum += pSndMxrCh->AttNow; }
	}
	return (AttSum <= UCHAR_MAX) ? AttSum : UCHAR_MAX;
}

/*--------------------------------------------------------------------------*/

void SndMxr_GetSndChAttAll(ST_SndMxr* pSndMxr, unsigned char AttSum[/*32*/]) {
	int iSndMxrCh;
	/* SẴTEh`ľʂNAĂB */
	memset(AttSum, 0, 32);
	/* eSound Mixer`lɂāc */
	for(iSndMxrCh = 0; iSndMxrCh < pSndMxr->nSndMxrCh; iSndMxrCh++) {
		/* Sound Mixer`l\̂擾B */
		ST_SndMxrCh* pSndMxrCh = &pSndMxr->pSndMxrCh[iSndMxrCh];
		/* TEh`l}XN擾B */
		unsigned SndChMask = pSndMxrCh->SndChMask;
		/* ݌ʂ擾B */
		int AttNow = pSndMxrCh->AttNow;
		/* eTEh`lɂāc */
		unsigned char* pAttSum = AttSum;
		do {
			/* Sound Mixer`l̃TEh`l}XNAw肳ꂽTEh`l܂ނȂ΁A݌ʂZB */
			if(SndChMask & 1) { int x = *pAttSum + AttNow; *pAttSum = (x <= UCHAR_MAX) ? x : UCHAR_MAX; }
			/* TEh`l֐i߂B */
			pAttSum++;
		} while(SndChMask >>= 1);	/* Sound Mixer`l̃TEh`l}XNɁA}XNrbgcĂԁAJԂB */
	}
}

