/*	
 *	clipslot.c
 *
 *	XbgQ[pTu[`W
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sun Jun 02 15:09:44 JST 2013 Naoyuki Sawa
 *	- 1st[XB
 *	* Sun Aug 18 17:39:58 JST 2013 Naoyuki Sawa
 *	- Ǘǉ܂B
 *	* Sat Mar 29 15:51:51 JST 2014 Naoyuki Sawa
 *	- epCǉ܂B
 *	* Tue Apr 01 00:42:49 JST 2014 Naoyuki Sawa
 *	- ܔǉ܂B
 *	- [zǉ܂B
 *	* Tue Apr 08 00:24:56 JST 2014 Naoyuki Sawa
 *	- Cǉ܂B
 *	- ǉ܂B
 *	* Sat May 03 23:21:41 JST 2014 Naoyuki Sawa
 *	- ~ǉ܂B
 *	* Mon May 05 15:01:01 JST 2014 Naoyuki Sawa
 *	- ~f[^r_ǉ܂B
 *	  PCŃc[쐬鎞Ɏgp܂BP/ECEł͎gp܂B
 *	* Mon May 12 12:39:59 JST 2014 Naoyuki Sawa
 *	- XybNf[^쐬Eo͂ǉ܂B
 *	  PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
 *	* Sat May 31 13:04:14 JST 2014 Naoyuki Sawa
 *	- Slot_PrintStpCtl()AST_Slot_StpCtl\̂o͂悤ɕύX܂B
 *	  ܂ł́ASlot_PrintStpCtl()͌X̃e[uo͂āAAvP[VST_Slot_StpCtl\̂`Ă܂B
 *	  ́ASlot_PrintStpCtl()ST_Slot_StpCtl\̂ɂ܂Ƃ߂ďo͂̂ŁAAvP[VŒ`Kv͂܂B
 */
#include "clip.h"

/****************************************************************************
 *	oǗ
 ****************************************************************************/

void SlotDeritu_Init(ST_SlotDeritu* Me) {
	/* SẴtB[h0NAB */
	memset(Me, 0, sizeof(ST_SlotDeritu));
}

/*--------------------------------------------------------------------------*/

void SlotDeritu_Update(ST_SlotDeritu* Me, int In, int Out) {
	/* Z,,̃Q[` */
	static const unsigned short TermLength[3/*0=Z,1=,2=*/] = { 400, 6000, 17500 };
	int iTerm, iLog;

	/* 0`3Ao0`15͈̔͂ł邱ƂmFB */
	if(((unsigned)In > 3) || ((unsigned)Out > 15)) { DIE(); }
	/* Z,,ɂĥ */
	for(iTerm = 0; iTerm < 3/*0=Z,1=,2=*/; iTerm++) {
		/* NQ[O̓(o)i[ĂAR[hCfNX(0`17499)߂B */
		iLog = (unsigned)(Me->GameCount - TermLength[iTerm] + 17500) % (unsigned)17500;
		/* (o)ɁA̓(o)𑫂ANQ[O̓(o)B
		 * - NQ[O̓(o)i[Ȃ΁AR[hl0Ȃ̂ŁAō\ȂB
		 */
		Me->TotalIn[ iTerm] += (In  - ((Me->InLog[ iLog>>2] >> ((iLog&3)<<1)) &  3));
		Me->TotalOut[iTerm] += (Out - ((Me->OutLog[iLog>>1] >> ((iLog&1)<<2)) & 15));
		/*                            NQ[O̓(o)  */
		/* NQ[ȏo߂Ăꍇ̂݁ANQ[Ԃ̏oZo\łB
		 * - ł͂܂o߃Q[i߂ĂȂ̂ŁA(NQ[-1)Ɣr邱ƂɒӂB
		 */
		if((unsigned)Me->GameCount >= (unsigned)(TermLength[iTerm] - 1/*LRgQ*/)) {
			/* o[%]o[][]~100 łB
			 * - ANQ[Ԃ̑0̏ꍇ̂݁Aoo~100 ƂB
			 *   NQ[ԁASčėVZIꍇɁA0ƂȂ邱Ƃ蓾B
			 */
			Me->Deritu[iTerm] = (double)Me->TotalOut[iTerm] * 100.0;
			if(Me->TotalIn[iTerm] != 0) { Me->Deritu[iTerm] /= Me->TotalIn[iTerm]; }
		} else {
			/* NQ[ȏo߂܂ł́ANQ[Ԃ̏oAl(0.0)̂܂܈ێB */
		}
	}
	/* ̓(o)i[AR[hCfNX(0`17499)߂B */
	iLog = Me->GameCount % 17500;
	/* (o)OɁA̓(o)i[B */
	Me->InLog[ iLog>>2] = (Me->InLog[ iLog>>2] & ~( 3 << ((iLog&3)<<1))) | (In  << ((iLog&3)<<1));
	Me->OutLog[iLog>>1] = (Me->OutLog[iLog>>1] & ~(15 << ((iLog&1)<<2))) | (Out << ((iLog&1)<<2));
	/* o߃Q[i߂BI[o[t[AG[~ƂB */
	if(++Me->GameCount == 0) { DIE(); }
}

/****************************************************************************
 *	Ǘ
 ****************************************************************************/

void SlotYakuhi_Init(ST_SlotYakuhi* Me) {
	/* SẴtB[h0NAB */
	memset(Me, 0, sizeof(ST_SlotYakuhi));
}

/*--------------------------------------------------------------------------*/

void SlotYakuhi_Update(ST_SlotYakuhi* Me, int Yak, int Out) {
	int iLog, YakLog, OutLog;

	/* 𕨍쓮tOA0,1̒lɕϊB */
	if(Yak) { Yak = 1; }
	/* o0`15͈̔͂ł邱ƂmFB */
	if((unsigned)Out > 15) { DIE(); }
	/* SoɁA̕o𑫂B */
	Me->AllOut += Out;
	/* 𕨍쓮Ȃ΁A𕨍쓮oɂA̕o𑫂B */
	if(Yak) { Me->YakOut += Out; }
	/* 6000Q[O̖𕨍쓮tO,y,oi[ĂAR[hCfNX(0`5999)߂B */
	iLog = Me->GameCount % 6000;
	/* 6000Q[O̖𕨍쓮tO,y,o擾B */
	YakLog = (Me->YakLog[iLog>>3] >> ((iLog&7)   )) &  1;
	OutLog = (Me->OutLog[iLog>>1] >> ((iLog&1)<<2)) & 15;
	/* OɁA̖𕨍쓮tO,y,oi[B */
	Me->YakLog[iLog>>3] = (Me->YakLog[iLog>>3] & ~( 1 << ((iLog&7)   ))) | (Yak << ((iLog&7)   ));
	Me->OutLog[iLog>>1] = (Me->OutLog[iLog>>1] & ~(15 << ((iLog&1)<<2))) | (Out << ((iLog&1)<<2));
	/* SoA6000Q[O̕oB */
	Me->AllOut -= OutLog;
	/* 6000Q[O𕨍쓮Ȃ΁A𕨍쓮oA6000Q[O̕oB */
	if(YakLog) { Me->YakOut -= OutLog; }
	/* o߃Q[i߂BI[o[t[AG[~ƂB */
	if(++Me->GameCount == 0) { DIE(); }
	/* 6000Q[ȏo߂Ăꍇ̂݁A6000Q[Ԃ̖Zo\łB */
	if(Me->GameCount >= 6000) {
		/* [%]𕨍쓮o[]So[]~100 łB
		 * - A6000Q[Ԃ̑So0̏ꍇ̂݁A䁁𕨍쓮o~100 ƂB
		 *   6000Q[ԁASĂ͂,,ėVZIꍇɁASo0ƂȂ邱Ƃ蓾B
		 */
		Me->Yakuhi = (double)Me->YakOut * 100.0;
		if(Me->AllOut != 0) { Me->Yakuhi /= Me->AllOut; }
	} else {
		/* 6000Q[ȏo߂܂ł́A6000Q[Ԃ̖Al(0.0)̂܂܈ێB */
	}
}

/****************************************************************************
 *	epC
 ****************************************************************************/

#ifndef PIECE
int Slot_CheckTenpai(const unsigned char aStopPict[3/*㒆*/][3/*E*/], int iPictLCR) {
	int iTenpaiLineMask = 0;
	int iMask, iRow, iPictL, iPictC, iPictR, iStopPictL, iStopPictC, iStopPictR;

	/* 񓷓ɒ~Ɩ~݂ĂȂƂmFB(=㒆̓ł0,,㒆̓ł0ȊOȂ΃G[B) */
	if(((aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]) == 0) && ((aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]) != 0)) { DIE(); }
	if(((aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]) == 0) && ((aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]) != 0)) { DIE(); }
	if(((aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]) == 0) && ((aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]) != 0)) { DIE(); }
	/* Gg𕪉B(0=Any) */
	iPictL = (iPictLCR>>0) & 15;
	iPictC = (iPictLCR>>4) & 15;
	iPictR = (iPictLCR>>8) & 15;
	/* eCɂāc */
	iMask = (1<<4); /* (1<<4)΃C,(1<<3)~΃C,(1<<2)iC,(1<<1)iC,(1<<0)iC̏ɔ肷 */
	iRow = (2/**/<< 0)|(1/**/<< 2)|(0/**/<< 4)| /* 4 ΃C c ȉdo`whiléA1[vڂŎgp */
	       (0/**/<< 6)|(1/**/<< 8)|(2/**/<<10)| /* 3 ~΃C c ȉdo`whiléA2[vڂŎgp */
	       (2/**/<<12)|(2/**/<<14)|(2/**/<<16)| /* 2 iC c ȉdo`whiléA3[vڂŎgp */
	       (1/**/<<18)|(1/**/<<20)|(1/**/<<22)| /* 1 iC c ȉdo`whiléA4[vڂŎgp */
	       (0/**/<<24)|(0/**/<<26)|(0/**/<<28); /* 0 iC c ȉdo`whiléA5[vڂŎgp */
	do {
		/* E񓷂̒~G擾B(0=~) */
		iStopPictL = aStopPict[iRow & 3][0/**/]; iRow >>= 2;
		iStopPictC = aStopPict[iRow & 3][1/**/]; iRow >>= 2;
		iStopPictR = aStopPict[iRow & 3][2/*E*/]; iRow >>= 2;
		/* 񓷂łu~ς,,AnyŁAsvvȂ΁ÃCŃepCł͂ȂB */
		if((iPictL && iStopPictL) && (iPictL != iStopPictL)) { continue; }
		if((iPictC && iStopPictC) && (iPictC != iStopPictC)) { continue; }
		if((iPictR && iStopPictR) && (iPictR != iStopPictR)) { continue; }
		/* ̃CŃepCłBepCC̃rbg}XNɁÃC̃rbg}XNǉB */
		iTenpaiLineMask |= iMask;
	} while(iMask >>= 1);
	/* epCC̃rbg}XNԂB */
	return iTenpaiLineMask;
}
#else //PIECE
int Slot_CheckTenpai(const unsigned char aStopPict[3/*㒆*/][3/*E*/], int iPictLCR);
asm("
		.code
		.align		1
		.global		Slot_CheckTenpai
Slot_CheckTenpai:
		;// %r12 := aStopPict
		;// %r13 := iPictLCR
		ld.ub		%r4,  [%r12]+			;// %r4  := aStopPict[0][0]
		ld.ub		%r5,  [%r12]+			;// %r5  := aStopPict[0][1]
		ld.ub		%r6,  [%r12]+			;// %r6  := aStopPict[0][2]
;//{{eʐߖ
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][0]
;//		mltu.h		%r4,  %r9			;// %alr := aStopPict[0][0]*aStopPict[1][0]
;//		ld.w		%r4,  %alr			;// %r4  := aStopPict[0][0]*aStopPict[1][0]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][1]
;//		mltu.h		%r5,  %r9			;// %alr := aStopPict[0][1]*aStopPict[1][1]
;//		ld.w		%r5,  %alr			;// %r5  := aStopPict[0][1]*aStopPict[1][1]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][2]
;//		mltu.h		%r6,  %r9			;// %alr := aStopPict[0][2]*aStopPict[1][2]
;//		ld.w		%r6,  %alr			;// %r6  := aStopPict[0][2]*aStopPict[1][2]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][0]
;//		mltu.h		%r4,  %r9			;// %alr := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
;//		ld.w		%r4,  %alr			;// %r4  := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][1]
;//		mltu.h		%r5,  %r9			;// %alr := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
;//		ld.w		%r5,  %alr			;// %r5  := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
;//		ld.ub		%r9,  [%r12]			;// %r9  :=                                 aStopPict[2][2]
;//		mltu.h		%r6,  %r9			;// %alr := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
;//		ld.w		%r6,  %alr			;// %r6  := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
;//eʐߖ
		ld.w		%r7,  2				;// %r7  := i = 2; do {
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][0]%r9  :=                                 aStopPict[2][0]
		 mltu.h		%r4,  %r9			;//   %alr := aStopPict[0][0]*aStopPict[1][0]%alr := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
		 ld.w		%r4,  %alr			;//   %r4  := aStopPict[0][0]*aStopPict[1][0]%r4  := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][1]%r9  :=                                 aStopPict[2][1]
		 mltu.h		%r5,  %r9			;//   %alr := aStopPict[0][1]*aStopPict[1][1]%alr := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
		 ld.w		%r5,  %alr			;//   %r5  := aStopPict[0][1]*aStopPict[1][1]%r5  := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][2]%r9  :=                                 aStopPict[2][2]
		 mltu.h		%r6,  %r9			;//   %alr := aStopPict[0][2]*aStopPict[1][2]%alr := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
		 ld.w		%r6,  %alr			;//   %r6  := aStopPict[0][2]*aStopPict[1][2]%r6  := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
		 sub		%r7,  1				;//   %r7  := i--
		jrne		-10				;// } while(i)
;//}}eʐߖ
		sub		%r12, 9				;// %r12 := aStopPict
		ld.ub		%r7,  [%r12]+			;// %r7  := aStopPict[0][0]
		ld.ub		%r10, [%r12]+			;// %r10 := aStopPict[0][1]
		ld.ub		%r11, [%r12]+			;// %r11 := aStopPict[0][2]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][0]
		add		%r7,  %r9			;// %r7  := aStopPict[0][0]+aStopPict[1][0]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][1]
		add		%r10, %r9			;// %r10 := aStopPict[0][1]+aStopPict[1][1]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][2]
		add		%r11, %r9			;// %r11 := aStopPict[0][2]+aStopPict[1][2]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][0]
		add		%r7,  %r9			;// %r7  := aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]
		jreq.d		4				;//     if((aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]) != 0) &&
		 ld.w		%r14, %r13			;// %r14 :=           iPictLCR			*delay*		
		 cmp		%r4,  0				;//        (aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][1]			
		add		%r10, %r9			;// %r10 := aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]			
		jreq.d		4				;//     if((aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]) != 0) &&		
		 ld.w		%r15, %r13			;// %r15 :=           iPictLCR			*delay*		
		 cmp		%r5,  0				;//        (aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
		ld.ub		%r9,  [%r12]			;// %r9  :=                                 aStopPict[2][2]			
		add		%r11, %r9			;// %r11 := aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]			
		jreq.d		4				;//     if((aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]) != 0) &&		
		 sub		%r12, 8				;// %r12 := aStopPict				*delay*			
		 cmp		%r6,  0				;//        (aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
;//		sub		%r12, 8				;// %r12 := aStopPict							
		;//---------------------------------------------;//										
;//		ld.w		%r14, %r13			;// %r14 :=           iPictLCR					
;//		ld.w		%r15, %r13			;// %r15 :=           iPictLCR					
		sra		%r14, 4				;// %r14 :=          (iPictLCR>>4)
		sra		%r15, 8				;// %r15 :=          (iPictLCR>>8)
		and		%r13, 15			;// %r13 := iPictL = (iPictLCR>>0) & 15
		and		%r14, 15			;// %r14 := iPictC = (iPictLCR>>4) & 15
		and		%r15, 15			;// %r15 := iPictR = (iPictLCR>>8) & 15
		ld.w		%r7,  16			;// %r7  := iMask = (1<<4)
		ld.w		%r9,  3				;// %r9  := sizeof aStopPict[0] = 3
		ld.w		%r10, 0				;// %r10 := iTenpaiLineMask = 0
		xld.w		%r11, 0x0056A906		;// %r11 := iRow = (2<<0)|(1<<2)|(0<<4) | (0<<6)|(1<<8)|(2<<10) | (2<<12)|(2<<14)|(2<<16) | (1<<18)|(1<<20)|(1<<22) | (0<<24)|(0<<26)|(0<<28)
		;// %r7  := iMask
		;// %r9  := sizeof aStopPict[0]
		;// %r10 := iTenpaiLineMask
		;// %r11 := iRow
		;// %r12 := aStopPict
		;// %r13 := iPictL
		;// %r14 := iPictC
		;// %r15 := iPictR
Slot_CheckTenpai_LOOP:						;// do {
		ld.w		%r4,  %r11			;//   %r4  := iRowL = iRow
		sra		%r11, 2				;//   %r11 :=         iRow >>= 2
		ld.w		%r5,  %r11			;//   %r5  := iRowC = iRow
		sra		%r11, 2				;//   %r11 :=         iRow >>= 2
		ld.w		%r6,  %r11			;//   %r6  := iRowR = iRow
;//		sra		%r11, 2				;//   %r11 :=         iRow >>= 2				
		cmp		%r13, 0				;//   if(iPictL) {							
		jreq		10				;//     								
		 and		%r4,  3				;//     %r4  := iRowL &= 3						
		 mlt.h		%r4,  %r9			;//     %alr := iRowL *= 3						
		 ld.w		%r4,  %alr			;//     %r4  :=                        iRowL				
		 add		%r4,  %r12			;//     %r4  :=              aStopPict[iRowL]				
		 ld.ub		%r4,  [%r4]			;//     %r4  := iStopPictL = aStopPict[iRowL][0]			
		 cmp		%r4,  0				;//     if(iStopPictL) {			!INTERLOCK!		
		 jreq		3				;//       								
		  cmp		%r13, %r4			;//       if(iPictL != iStopPictL) { continue }				
		  jrne		Slot_CheckTenpai_NEXT		;//   } }								
		cmp		%r14, 0				;//   if(iPictC) {							
		jreq		11				;//     								
		 and		%r5,  3				;//     %r5  := iRowC &= 3						
		 mlt.h		%r5,  %r9			;//     %alr := iRowC *= 3						
		 ld.w		%r5,  %alr			;//     %r5  :=                        iRowC				
		 add		%r5,  %r12			;//     %r5  :=              aStopPict[iRowC]				
		 ext		1				;//     								
		 ld.ub		%r5,  [%r5]			;//     %r5  := iStopPictC = aStopPict[iRowC][1]			
		 cmp		%r5,  0				;//     if(iStopPictC) {			!INTERLOCK!		
		 jreq		3				;//       								
		  cmp		%r14, %r5			;//       if(iPictC != iStopPictC) { continue }				
		  jrne		Slot_CheckTenpai_NEXT		;//   } }								
		cmp		%r15, 0				;//   if(iPictR) {							
		jreq		11				;//     								
		 and		%r6,  3				;//     %r6  := iRowR &= 3						
		 mlt.h		%r6,  %r9			;//     %alr := iRowR *= 3						
		 ld.w		%r6,  %alr			;//     %r6  :=                        iRowR				
		 add		%r6,  %r12			;//     %r6  :=              aStopPict[iRowR]				
		 ext		2				;//     								
		 ld.ub		%r6,  [%r6]			;//     %r6  := iStopPictR = aStopPict[iRowR][2]			
		 cmp		%r6,  0				;//     if(iStopPictR) {			!INTERLOCK!		
		 jreq		3				;//       								
		  cmp		%r15, %r6			;//       if(iPictR != iStopPictR) { continue }				
		  jrne		Slot_CheckTenpai_NEXT		;//   } }								
		or		%r10, %r7			;//   %r10 := iTenpaiLineMask |= iMask					
Slot_CheckTenpai_NEXT:						;//									
		sra		%r7,  1				;// } while(iMask >>= 1)						
		jrne.d		Slot_CheckTenpai_LOOP		;//									
		sra		%r11, 2				;//   %r11 := iRow >>= 2			*delay*		
		ret
");
static void __attribute__((noreturn,unused)) Slot_CheckTenpai_DIE() { DIE(); }
#endif//PIECE

/****************************************************************************
 *	ܔ
 ****************************************************************************/

#ifndef PIECE
#if 0
/* PȎBëӐ}cɂ́AQƂĂB */
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[/*㒆~*/]) {
	int iHitFlg, iMask, iLine;
	/* nHitFlg(Gge[u̗vf)A(1`256)ł邱ƂmFB */
	if((nHitFlg < 1) || (nHitFlg > 256)) { DIE(); }
	/* Gge[ůevfɂāc */
	for(iHitFlg = 0; iHitFlg < nHitFlg; iHitFlg++) {
		/* ̊GgɂāA5C̓ܔsB */
		iMask = Slot_CheckTenpai(aStopPict, aHitFlg[iHitFlg]);
		/* eCɂāc */
		for(iLine = 0; iLine < 5; iLine++) {
			/* ̃Cɓ܂ĂÅGgԍʔz֊i[B */
			if(iMask & (1<<iLine)) { aResult[iLine] = iHitFlg; }
		}
	}
}
#else
/* œKBAZuł́Ax[XɃAZu܂B */
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[/*㒆~*/]) {
	/* nHitFlg(Gge[u̗vf)A(1`256)ł邱ƂmFBA̓s゠炩(-1)Ă̂ŁA(0`255)ł邱ƂmFB */
	if((unsigned)--nHitFlg > 255) { DIE(); } /* s */
	/* nHitFlg[31:8]=(Gge[u̎cvf-1),nHitFlg[7:0]=(Ggԍ)ƂB[vϐ炷߂̍HvłB */
	nHitFlg <<= 8;
	/* Gge[ůevfɂāc */
	do {
		/* ̊GgɂāA5C̓ܔsB */
		int iMask = Slot_CheckTenpai(aStopPict, *aHitFlg++);
		/* eCɂāc */
		unsigned char* pResult = aResult; /* ŏ̃Cɑ΂Aʔzւ̃|C^ */
		do {
			/* ̃Cɓ܂ĂÅGgԍʔz֊i[B */
			if(iMask & 1) { *pResult = nHitFlg; } /* nHitFlg[7:0]=(Ggԍ) */
			/* ʔzւ̃|C^ÃC֐i߂B */
			pResult++;
		} while(iMask >>= 1); /* ܃tÕC֐i߂B1̃rbgȂIB5CܖłA1[v邱ƂɂȂ邪AQ͖B */
	/* nHitFlg[31:8]=(Gge[u̎cvf-1)(-1),nHitFlg[7:0]=(Ggԍ)(+1)BAnHitFlg[31:0](-255)B */
	/* - [vÍA0**ł͂ȂA0*ȉ*ł邱ƂɒӂB                                                                  */
	/*   ďö(nHitFlg=256)̏ꍇAŌ(nHitFlg[31:8]:00,nHitFlg[7:0]:2550)A(nHitFlg[31:0]:2550)ŏI邩łB */
	} while((nHitFlg -= 255) > 0);
}
#endif
#else //PIECE
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[/*㒆~*/]);
asm("
		.code
		.align		1
		.global		Slot_CheckPrize
Slot_CheckPrize:
		;// %r12 := aStopPict
		;// %r13 := aHitFlg
		;// %r14 := nHitFlg
		;// %r15 := aResult
		sub		%r14, 1			;// if((unsigned)--nHitFlg > 255) {
		xcmp		%r14, 255		;//   DIE
		jrugt		Slot_CheckPrize_DIE	;// }
		pushn		%r3
		ld.w		%r0, %r12		;// %r0       := aStopPict
		ld.w		%r1, %r13		;// %r1       := aHitFlg
		ld.w		%r2, %r14		;// %r2[31:8] := nHitFlg
		sla		%r2, 8			;// %r2[ 7:0] := iHitFlg = 0
		ld.w		%r3, %r15		;// %r3       := aResult
		;// %r0       := aStopPict
		;// %r1       := aHitFlg
		;// %r2[31:8] := nHitFlg
		;// %r2[ 7:0] := iHitFlg = 0
		;// %r3       := aResult
Slot_CheckPrize_LOOP:					;// do {
		ld.uh		%r13, [%r1]+		;//   %r13 :=                                     *aHitFlg++
		xcall.d		Slot_CheckTenpai	;//   %r10 := iMask = Slot_CheckTenpai(aStopPict, *aHitFlg++)	iMask[ 0] := i, iMask[ 1] := i, iMask[ 2] := i, iMask[ 3] := ~, iMask[ 4] := 
		ld.w		%r12, %r0		;//   %r12 :=                          aStopPict		*delay*
		swap		%r10, %r10		;//   %r10 := iMask =   swap(iMask)				iMask[24] := i, iMask[25] := i, iMask[26] := i, iMask[27] := ~, iMask[28] := 
		mirror		%r10, %r10		;//   %r10 := iMask = mirror(iMask)				iMask[31] := i, iMask[30] := i, iMask[29] := i, iMask[28] := ~, iMask[27] := 
		ld.w		%r12, %r3		;//   %r12 := pResult = aResult
		add		%r10, %r10		;//   do {
		 jruge		2			;//     %psr(C) := iMask[31], %r10 := iMask <<= 1
		  ld.b		[%r12], %r2		;//     if(%psr(C)) { *pResult = iHitFlg }
		jrne.d		-3			;//   } while(iMask)
		add		%r12, 1			;//   %r12 := pResult++						*delay*
		xsub		%r2, %r2, 255		;//   %r2[31:8] := nHitFlg--, %r2[7:0] := iHitFlg++
		jrgt		Slot_CheckPrize_LOOP	;// } while(((nHitFlg<<8)|iHitFlg) > 0)				ďö(nHitFlg=256)̏ꍇAŌ(nHitFlg:00,iHitFlg:2550)A(%r2:2550)ŏIBeʐߖOƔfႤƂɒӂBjrgełȂjrgtłB
		popn		%r3
		ret
");
static void __attribute__((noreturn,unused)) Slot_CheckPrize_DIE() { DIE(); }
#endif//PIECE

/****************************************************************************
 *	[z
 ****************************************************************************/

#ifndef PIECE
int Slot_GetReelPict(const unsigned short aReel[/*21*/], int iPos, int iReel) {
	int iPict;
	/* 񓷔ԍ(0`2)͈̔͂ł邱ƂmFB */
	if((unsigned)iReel > 2) { DIE(); }
	/* Gʒu(0`20)͈̔͊OȂ΁A(0`20)͈̔͂ɐ܂ԂB */
	if((iPos %= 21) < 0) { iPos += 21; }
	/* [źAGʒu̗vf́A񓷔ԍ̊G擾B */
	iPict = (aReel[iPos] >> (iReel << 2)) & 15;
	if(!iPict) { DIE(); }
	return iPict;
}
#else //PIECE
int Slot_GetReelPict(const unsigned short aReel[/*21*/], int iPos, int iReel);
asm("
		.code
		.align		1
		.global		Slot_GetReelPict
Slot_GetReelPict:
		cmp		%r14, 2				;// if((unsigned)iReel > 2) {
		jrugt		Slot_GetReelPict_DIE		;//   DIE() }
		ld.w		%r15, %r12			;// %r15 := aReel
		ld.w		%r12, %r13			;// %r12 := iPos
		xcall.d		__modsi3			;// %r10 := iPos %= 21
		ld.w		%r13, 21			;// %r13 :=         21		*delay*
		add		%r10, %r10			;// %r10 := iPos *= sizeof aReel[0]
		jrge.d		3				;// if(iPos < 0) {
		 sla		%r14, 2				;// %r14 := iReel *= 4		*delay*
		 add		%r10, 42			;//   %r10 := iPos += (21 * sizeof aReel[0]) }
		add		%r10, %r15			;// %r10 := iPict =  aReel += iPos
		ld.uh		%r10, [%r10]			;// %r10 := iPict = *aReel
		sra		%r10, %r14			;// %r10 := iPict >>= iReel	!INTERLOCK!
		and		%r10, 15			;// %r10 := iPict &= 15
		jreq		Slot_GetReelPict_DIE		;// if(!iPict) { DIE() }
		ret						;// return  iPict
");
static void __attribute__((noreturn,unused)) Slot_GetReelPict_DIE() { DIE(); }
#endif//PIECE

//
//[zf[^̃rbg12`15͕slō\Ȃ̂ŁAAvP[V̗prɗpč\ȂB
//ۂ̂ƂALȗp@͖낤BÃrbg͖ʂłB
//ŁAGʒu3s2oCgɃpbNĂlĂ݂B͉L̒ʂ:
//
//	int Slot_GetReelPict_Packed(const unsigned char aReel[/*32*/], int iPos, int iReel) {
//		int i, iPict;
//		/* 񓷔ԍ(0`2)͈̔͂ł邱ƂmFB */
//		if((unsigned)iReel > 2) { DIE(); }
//		/* Gʒu(0`20)͈̔͊OȂ΁A(0`20)͈̔͂ɐ܂ԂB */
//		if((iPos %= 21) < 0) { iPos += 21; }
//		/* GʒuƉ񓷔ԍA[zւ̃juPʂ̃CfNX߂B */
//		i = (iPos * 3) + iReel;
//		/* [źAGʒu̗vf́A񓷔ԍ̊G擾B */
//		iPict = (aReel[i>>1] >> ((i&1)<<2)) & 15;
//		if(!iPict) { DIE(); }
//		return iPict;
//	}
//	#else //PIECE
//	int Slot_GetReelPict_Packed(const unsigned char aReel[/*21*/], int iPos, int iReel);
//	asm("
//			.code
//			.align		1
//			.global		Slot_GetReelPict_Packed
//	Slot_GetReelPict_Packed:
//			cmp		%r14, 2				;// if((unsigned)iReel > 2) {
//			jrugt		Slot_GetReelPict_Packed_DIE	;//   DIE() }
//			ld.w		%r15, %r12			;// %r15 := aReel
//			ld.w		%r12, %r13			;// %r12 := iPos
//			xcall.d		__modsi3			;// %r10 := iPos %= 21
//			ld.w		%r13, 21			;// %r13 :=         21		*delay*
//			ld.w		%r12, %r10			;// %r12 := iPos
//			add		%r10, %r10			;// %r10 := iPos * 2
//			jrge.d		3				;// if(iPos < 0) {
//			 add		%r10, %r12			;// %r10 := iPos * 3		*delay*
//			 add		%r10, 63			;//   iPos += 21 * 3 }
//			add		%r10, %r14			;// %r10 := i = iPos + iReel
//			ld.w		%r14, %r10			;// %r14 := i
//			sra		%r10, 1				;// %r10 :=               i>>1
//			add		%r10, %r15			;// %r10 :=        &aReel[i>>1]
//			ld.ub		%r10, [%r10]			;// %r10 := iPict = aReel[i>>1]
//			and		%r14, 1				;// %r14 :=            i&1
//			sla		%r14, 2				;// %r14 :=           (i&1)*4
//			sra		%r10, %r14			;// %r10 := iPict >>= (i&1)*4
//			and		%r10, 15			;// %r10 := iPict &= 15
//			jreq		Slot_GetReelPict_Packed_DIE	;// if(!iPict) { DIE() }
//			ret						;// return  iPict
//	");
//	static void __attribute__((noreturn,unused)) Slot_GetReelPict_Packed_DIE() { DIE(); }
//	#endif//PIECE
//L̃o[WgƁA[zf[^ɖʂȃrbgȂB
//AvZĂ݂ƁA[zf[^̌AR[hTCY̑̕B
//Eް: 4232 10޲Č
//E޻: 1723 12޲đ
//Ƃ킯ŁAL̃o[W͗_̂ŁA̗pȂBꉞAL^܂łɎcĂB

/****************************************************************************
 *	C
 ****************************************************************************/

#ifndef PIECE
int Slot_GetLineRow(int iLine, int iReel) {
	if(((unsigned)iLine > 4) || ((unsigned)iReel > 2)) { DIE(); }
	if(iLine <= 2) { return iLine; } /* T,M,B */
	if(iLine == 3) { return iReel; } /* F */
	return 2 - iReel;                /* Z */
}
#else //PIECE
int Slot_GetLineRow(int iLine, int iReel);
asm("
		.code
		.align		1
		.global		Slot_GetLineRow
Slot_GetLineRow:
		cmp		%r12, 4			;// if(((unsigned)iLine > 4) { DIE }
		jrugt		Slot_GetLineRow_DIE
		cmp		%r13, 2			;// if(((unsigned)iCol  > 2) { DIE }
		jrugt		Slot_GetLineRow_DIE
		cmp		%r12, 3			;// if(iLine <= 2) { return iLine }
		jrlt		5
		 ld.w		%r12, %r13		;// if(iLine == 3) { return iCol }
		 jreq		3
		  ld.w		%r12, 2			;// return 2 - iCol
		  sub		%r12, %r13
		ret.d
		ld.w		%r10, %r12		;//	*delay*
");
static void __attribute__((noreturn,unused)) Slot_GetLineRow_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if((Slot_GetLineRow(Slot_Line_T,0)!=0)||(Slot_GetLineRow(Slot_Line_T,1)!=0)||(Slot_GetLineRow(Slot_Line_T,2)!=0)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_M,0)!=1)||(Slot_GetLineRow(Slot_Line_M,1)!=1)||(Slot_GetLineRow(Slot_Line_M,2)!=1)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_B,0)!=2)||(Slot_GetLineRow(Slot_Line_B,1)!=2)||(Slot_GetLineRow(Slot_Line_B,2)!=2)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_F,0)!=0)||(Slot_GetLineRow(Slot_Line_F,1)!=1)||(Slot_GetLineRow(Slot_Line_F,2)!=2)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_Z,0)!=2)||(Slot_GetLineRow(Slot_Line_Z,1)!=1)||(Slot_GetLineRow(Slot_Line_Z,2)!=0)){DIE();}
//}

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
int Slot_GetOrderReel(int iOrder, int iStop) {
	if(((unsigned)iOrder > 5) || ((unsigned)iStop > 2)) { DIE(); }
	if((iOrder -= 3) < 0) { iOrder += iStop; }	/* LCR,CRL,RLC */	//(-3`1)
	                 else { iOrder -= iStop; }	/* LRC,CLR,RCL */	//(-2`2)(-3`2)
	if(iOrder < 0) { iOrder += 3; }						//         ( 0`2)

	return iOrder;
}
#else //PIECE
int Slot_GetOrderReel(int iOrder, int iStop);
asm("
		.code
		.align		1
		.global		Slot_GetOrderReel
Slot_GetOrderReel:
		cmp		%r12, 5			;// if((unsigned)iOrder > 5) { DIE }
		jrugt		Slot_GetOrderReel_DIE
		cmp		%r13, 2			;// if((unsigned)iStop  > 2) { DIE }
		jrugt		Slot_GetOrderReel_DIE
		sub		%r12, 3			;// %r12 :=   iOrder -= 3
		jrlt.d		4			;// if(iOrder) < 0) {
		add		%r12, %r13		;// %r12 :=   iOrder += iStop } else {	*delay*		%psr(N)=?,%psr(V)=0	̉ZŃI[o[t[͔Ȃ̂ŁA%psr(V)=0ƂȂB
		 sub		%r12, %r13		;//   %r12 := iOrder									
		 sub		%r12, %r13		;//   %r12 := iOrder -= iStop }				%psr(N)=?,%psr(V)=0	̌ZŃI[o[t[͔Ȃ̂ŁA%psr(V)=0ƂȂB
		jrge		2			;// if(iOrder < 0) {					jrge̕(N=V)B%psr(V)=0Ȃ̂ŁA%psr(N)݂̂ŔfB
		 add		%r12, 3			;//   %r12 := iOrder += 3 }
		ret.d					;// return    iOrder
		ld.w		%r10, %r12		;// %r10   := iOrder			*delay*
");
static void __attribute__((noreturn,unused)) Slot_GetOrderReel_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if((Slot_GetOrderReel(Slot_Order_LCR,0)!=0)||(Slot_GetOrderReel(Slot_Order_LCR,1)!=1)||(Slot_GetOrderReel(Slot_Order_LCR,2)!=2)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_CRL,0)!=1)||(Slot_GetOrderReel(Slot_Order_CRL,1)!=2)||(Slot_GetOrderReel(Slot_Order_CRL,2)!=0)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_RLC,0)!=2)||(Slot_GetOrderReel(Slot_Order_RLC,1)!=0)||(Slot_GetOrderReel(Slot_Order_RLC,2)!=1)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_LRC,0)!=0)||(Slot_GetOrderReel(Slot_Order_LRC,1)!=2)||(Slot_GetOrderReel(Slot_Order_LRC,2)!=1)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_CLR,0)!=1)||(Slot_GetOrderReel(Slot_Order_CLR,1)!=0)||(Slot_GetOrderReel(Slot_Order_CLR,2)!=2)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_RCL,0)!=2)||(Slot_GetOrderReel(Slot_Order_RCL,1)!=1)||(Slot_GetOrderReel(Slot_Order_RCL,2)!=0)){DIE();}
//}

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int Slot_FindOrder(int iReel1, int iReel2) {
	if(((unsigned)iReel1 > 2) || ((unsigned)iReel2 > 2) || (iReel1 == iReel2)) { DIE(); }
	if((iReel2 -= iReel1) < 0) { iReel2 += 3; }	//iReel2=1,2
	if(iReel2 != 1) { iReel1 += 3; }		//iReel1=0~5
	return iReel1;
}
#else //PIECE
int Slot_FindOrder(int iReel1, int iReel2);
asm("
		.code
		.align		1
		.global		Slot_FindOrder
Slot_FindOrder:
		cmp		%r12, 2			;// if((unsigned)iReel1 > 2) { DIE }
		jrugt		Slot_FindOrder_DIE
		cmp		%r13, 2			;// if((unsigned)iReel2 > 2) { DIE }
		jrugt		Slot_FindOrder_DIE
		sub		%r13, %r12		;// %r13 := iReel2 -= iReel1
		jrgt		3			;// if(  iReel2 <= 0) {
		 jreq		Slot_FindOrder_DIE	;//   if(iReel2 == 0) { DIE }
		 add		%r13, 3			;//   %r13 := iReel2 += 3 }
		cmp		%r13, 1			;// if(iReel2 != 1) {
		jreq		2
		 add		%r12, 3			;//   %r12 := iReel1 += 3 }
		ret.d					;// return  iReel1
		ld.w		%r10, %r12		;// %r10 := iReel1		*delay*
");
static void __attribute__((noreturn,unused)) Slot_FindOrder_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if(Slot_FindOrder(0,1)!=Slot_Order_LCR){DIE();}
//  if(Slot_FindOrder(1,2)!=Slot_Order_CRL){DIE();}
//  if(Slot_FindOrder(2,0)!=Slot_Order_RLC){DIE();}
//  if(Slot_FindOrder(0,2)!=Slot_Order_LRC){DIE();}
//  if(Slot_FindOrder(1,0)!=Slot_Order_CLR){DIE();}
//  if(Slot_FindOrder(2,1)!=Slot_Order_RCL){DIE();}
//}

/****************************************************************************
 *	~
 ****************************************************************************/

/*--------------------------------------------------------------------------*
 *	1[~
 *--------------------------------------------------------------------------*/

/* Zbg1ԍ(iHkmSet1)́Aʒu1(iPushPos1)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet1	Zbg1ԍ		0`(HkmSet1_Size-1)
 *	iPushPos1	ʒu1		0`20
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg1Ƃ́A(~ʒu1)̑gAdo^̂łB
 */
static int GetHkmSet1(const ST_Slot_StpCtl* pStpCtl, int iHkmSet1, int iPushPos1) {
	unsigned char (*Buf/*[HkmSet1_CompUnit]*/)[21 / 3] = alloca(pStpCtl->HkmSet1_CompUnit * (21 / 3));
	int nHkmCnt, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet1 >= pStpCtl->HkmSet1_Size) { DIE(); }
	if((unsigned)iPushPos1 > 20) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet1 / pStpCtl->HkmSet1_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet1_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet1_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet1_CompUnit * 21,
		&pStpCtl->TBL_HkmSet1_CompData[iCompData],
		 pStpCtl->TBL_HkmSet1_CompSize[iCompSize]);
	if(((nUncompSize % (21 / 3)) != 0) ||
	   ((nUncompSize / (21 / 3)) < (iHkmSet1 % pStpCtl->HkmSet1_CompUnit))) { DIE(); }
	nHkmCnt = Buf[iHkmSet1 % pStpCtl->HkmSet1_CompUnit][iPushPos1 / 3];
	switch(iPushPos1 % 3) {
	case 0: nHkmCnt = nHkmCnt      % 6; break;
	case 1: nHkmCnt = nHkmCnt /  6 % 6; break;
	case 2: nHkmCnt = nHkmCnt / 36    ; break;
	default: DIE();
	}
	if((unsigned)nHkmCnt > 4) { DIE(); }
	return nHkmCnt;
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl1(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iPushPos1) {
	int iHkmSet1;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iPushPos1 > 20) { DIE(); }
	iHkmSet1 = pStpCtl->TBL_StpCtl1[iHitCd][iReel1];
	return GetHkmSet1(pStpCtl, iHkmSet1, iPushPos1);
}

/*--------------------------------------------------------------------------*
 *	2[~
 *--------------------------------------------------------------------------*/

/* Zbg2ԍ(iHkmSet2)́A~ʒu1(iStopPos1),ʒu2(iPushPos2)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet2	Zbg2ԍ		0`(HkmSet2_Size-1)
 *	iStopPos1	~ʒu1		0`20
 *	iPushPos2	ʒu2		0`20
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg2Ƃ́A(Zbg1ԍ~~ʒu1)̑gAdo^̂łB
 *	- Zbg2f[^́A(HkmSet2_CompUnit)PʂŁAkĂ܂B
 */
static int GetHkmSet2(const ST_Slot_StpCtl* pStpCtl, int iHkmSet2, int iStopPos1, int iPushPos2) {
	unsigned char (*Buf/*[HkmSet2_CompUnit]*/)[21] = alloca(pStpCtl->HkmSet2_CompUnit * 21);
	int iHkmSet1, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet2 >= pStpCtl->HkmSet2_Size) { DIE(); }
	if((unsigned)iStopPos1 > 20) { DIE(); }
	if((unsigned)iPushPos2 > 20) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet2 / pStpCtl->HkmSet2_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet2_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet2_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet2_CompUnit * 21,
		&pStpCtl->TBL_HkmSet2_CompData[iCompData],
		 pStpCtl->TBL_HkmSet2_CompSize[iCompSize]);
	if(((nUncompSize % 21) != 0) ||
	   ((nUncompSize / 21) < (iHkmSet2 % pStpCtl->HkmSet2_CompUnit))) { DIE(); }
	iHkmSet1 = Buf[iHkmSet2 % pStpCtl->HkmSet2_CompUnit][iStopPos1];
	return GetHkmSet1(pStpCtl, iHkmSet1, iPushPos2);
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl2(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iReel2, int iStopPos1, int iPushPos2) {
	int iHkmSet2, iOrder;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iReel2 > 2) { DIE(); }
	if((unsigned)iStopPos1 > 20) { DIE(); }
	if((unsigned)iPushPos2 > 20) { DIE(); }
	iOrder = Slot_FindOrder(iReel1, iReel2);
	iHkmSet2 = pStpCtl->TBL_StpCtl2[iHitCd][iOrder];
	return GetHkmSet2(pStpCtl, iHkmSet2, iStopPos1, iPushPos2);
}

/*--------------------------------------------------------------------------*
 *	3[~
 *--------------------------------------------------------------------------*/

/* Zbg3ԍ(iHkmSet3)́A~ʒu1(iStopPos1),~ʒu2(iStopPos2),ʒu3(iPushPos3)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet3	Zbg3ԍ		0`(HkmSet3_Size-1)
 *	iStopPos1	~ʒu1		0`20
 *	iStopPos2	~ʒu2		0`20
 *	iPushPos3	ʒu3		0`20
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg3Ƃ́A(Zbg2ԍ~~ʒu1)̑gAdo^̂łB
 *	- Zbg3f[^́A(HkmSet3_CompUnit)PʂŁAkĂ܂B
 */
static int GetHkmSet3(const ST_Slot_StpCtl* pStpCtl, int iHkmSet3, int iStopPos1, int iStopPos2, int iPushPos3) {
	unsigned char (*Buf/*[HkmSet3_CompUnit]*/)[21] = alloca(pStpCtl->HkmSet3_CompUnit * 21);
	int iHkmSet2, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet3 >= pStpCtl->HkmSet3_Size) { DIE(); }
	if((unsigned)iStopPos1 > 20) { DIE(); }
	if((unsigned)iStopPos2 > 20) { DIE(); }
	if((unsigned)iPushPos3 > 20) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet3 / pStpCtl->HkmSet3_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet3_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet3_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet3_CompUnit * 21,
		&pStpCtl->TBL_HkmSet3_CompData[iCompData],
		 pStpCtl->TBL_HkmSet3_CompSize[iCompSize]);
	if(((nUncompSize % 21) != 0) ||
	   ((nUncompSize / 21) < (iHkmSet3 % pStpCtl->HkmSet3_CompUnit))) { DIE(); }
	iHkmSet2 = Buf[iHkmSet3 % pStpCtl->HkmSet3_CompUnit][iStopPos1];
	return GetHkmSet2(pStpCtl, iHkmSet2, iStopPos2, iPushPos3);
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl3(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iReel2, int iReel3, int iStopPos1, int iStopPos2, int iPushPos3) {
	int iHkmSet3, iOrder;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iReel2 > 2) { DIE(); }
	if((unsigned)iReel3 > 2) { DIE(); }
	if((unsigned)iStopPos1 > 20) { DIE(); }
	if((unsigned)iStopPos2 > 20) { DIE(); }
	if((unsigned)iPushPos3 > 20) { DIE(); }
	iOrder = Slot_FindOrder(iReel1, iReel2);
	iHkmSet3 = pStpCtl->TBL_StpCtl3[iHitCd][iOrder];
	return GetHkmSet3(pStpCtl, iHkmSet3, iStopPos1, iStopPos2, iPushPos3);
}

/****************************************************************************
 *	~f[^r_
 ****************************************************************************/
#ifdef  WIN32	//PCŒ~f[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
/* ~f[^r_ */
typedef struct _ST_Slot_StpCtl_Builder {
	unsigned short HkmSet1_Size;
	unsigned short HkmSet2_Size;
	unsigned short HkmSet3_Size;
	unsigned short HkmSet1_CompData_Size;
	unsigned short HkmSet2_CompData_Size;
	unsigned short HkmSet3_CompData_Size;
	unsigned char (*TBL_StpCtl1/*[HitCd_Size]*/)[3]/*[21]*/;		//                                                                                          TBL_HkmSet1
	unsigned char (*TBL_StpCtl2/*[HitCd_Size]*/)[6]/*[21][21]*/;		//                                             (TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)TBL_HkmSet1
	unsigned char (*TBL_StpCtl3/*[HitCd_Size]*/)[6]/*[21][21][21]*/;	//(TBL_HkmSet3_CompSize,TBL_HkmSet3_CompData)(TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)TBL_HkmSet1
	unsigned char TBL_HkmSet1[256/*HkmSet1_Sizȅ*/][21];
	unsigned char TBL_HkmSet2[256/*HkmSet2_Sizȅ*/][21];
	unsigned char TBL_HkmSet3[256/*HkmSet3_Sizȅ*/][21];
	unsigned char TBL_HkmSet1_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet2_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet3_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet1_CompData[8192/*[ȃTCY*/];
	unsigned char TBL_HkmSet2_CompData[8192/*[ȃTCY*/];
	unsigned char TBL_HkmSet3_CompData[8192/*[ȃTCY*/];
	unsigned char (*TBL_StpFlg1/*[HitCd_Size]*/)[/*iPos1*/21];		//1[~tOBu(HitCd_Size)ŁA(bit0-5ɑΉ)̎ɁA1~[(iPos1)ɒ~邩B
	unsigned char (*TBL_StpFlg2/*[HitCd_Size]*/)[/*iPos1*/21][/*iPos2*/21];	//2[~tOBu(HitCd_Size)ŁA(bit0-5ɑΉ)̎ɁA1~[(iPos1),2~[(iPos2)ɒ~邩B
	unsigned char TBL_HkmSet1_Pack[256/*HkmSet1_Sizȅ*/][21 / 3];
} ST_Slot_StpCtl_Builder;
/*--------------------------------------------------------------------------*/
static int memcmp21(const void* x, const void* y) { return memcmp(x, y, 21); }
/*--------------------------------------------------------------------------*/
/* Zbg1do^ */
static int UnionHkmSet1(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmCnt[21]) {
	int iHkmSet1;
	for(iHkmSet1 = 0; iHkmSet1 < pBuilder->HkmSet1_Size; iHkmSet1++) {
		if(!memcmp21(pBuilder->TBL_HkmSet1[iHkmSet1], aHkmCnt)) { return iHkmSet1; }
	}
	if(pBuilder->HkmSet1_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet1)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet1[pBuilder->HkmSet1_Size], aHkmCnt, 21);
	return pBuilder->HkmSet1_Size++;
}
/*--------------------------------------------------------------------------*/
/* Zbg2do^ */
static int UnionHkmSet2(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmSet1[21]) {
	int iHkmSet2;
	for(iHkmSet2 = 0; iHkmSet2 < pBuilder->HkmSet2_Size; iHkmSet2++) {
		if(!memcmp21(pBuilder->TBL_HkmSet2[iHkmSet2], aHkmSet1)) { return iHkmSet2; }
	}
	if(pBuilder->HkmSet2_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet2)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet2[pBuilder->HkmSet2_Size], aHkmSet1, 21);
	return pBuilder->HkmSet2_Size++;
}
/*--------------------------------------------------------------------------*/
/* Zbg3do^ */
static int UnionHkmSet3(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmSet2[21]) {
	int iHkmSet3;
	for(iHkmSet3 = 0; iHkmSet3 < pBuilder->HkmSet3_Size; iHkmSet3++) {
		if(!memcmp21(pBuilder->TBL_HkmSet3[iHkmSet3], aHkmSet2)) { return iHkmSet3; }
	}
	if(pBuilder->HkmSet3_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet3)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet3[pBuilder->HkmSet3_Size], aHkmSet2, 21);
	return pBuilder->HkmSet3_Size++;
}
/*--------------------------------------------------------------------------*/
ST_Slot_StpCtl* Slot_BuildStpCtl(const ST_Slot_StpCtl_BuilderInfo* pInfo) {
	ST_Slot_StpCtl* pStpCtl;
	ST_Slot_StpCtl_Builder* pBuilder;
	int iHitCd, iOrder, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3, i, j, n;
	unsigned char aHkmCnt[21], aHkmSet1[21], aHkmSet2[21];
	unsigned char* p;
	/* kPʂ擾B0w肳ꂽꍇAlgpB */
	int HkmSet1_CompUnit = pInfo->HkmSet1_CompUnit ? pInfo->HkmSet1_CompUnit : 16/*l*/;
	int HkmSet2_CompUnit = pInfo->HkmSet2_CompUnit ? pInfo->HkmSet2_CompUnit : 16/*l*/;
	int HkmSet3_CompUnit = pInfo->HkmSet3_CompUnit ? pInfo->HkmSet3_CompUnit : 16/*l*/;
	/* ~f[^r_̃mۂB(1̃ubNƂĊmۂB1̃ubNƂĊJB) */
	p = calloc(1, sizeof(ST_Slot_StpCtl_Builder) +
		(pInfo->HitCd_Size * 3) +	/* TBL_StpCtl1 */
		(pInfo->HitCd_Size * 6) +	/* TBL_StpCtl2 */
		(pInfo->HitCd_Size * 6) +	/* TBL_StpCtl3 */
		(pInfo->HitCd_Size * 21) +	/* TBL_StpFlg1 */
		(pInfo->HitCd_Size * 21 * 21));	/* TBL_StpFlg2 */
	if(!p) { DIE(); }
	pBuilder              = (void*)p;   p += sizeof(ST_Slot_StpCtl_Builder);
	pBuilder->TBL_StpCtl1 = (void*)p;   p += (pInfo->HitCd_Size * 3);
	pBuilder->TBL_StpCtl2 = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pBuilder->TBL_StpCtl3 = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pBuilder->TBL_StpFlg1 = (void*)p;   p += (pInfo->HitCd_Size * 21);
	pBuilder->TBL_StpFlg2 = (void*)p; //p += (pInfo->HitCd_Size * 21 * 21);
	/*--- Zbg1do^ ---*/
	/* 1[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 3; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~[ */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				n = (*pInfo->fnGetStpCtl1)(pInfo->pParam, iHitCd, iReel1, iPos1);
				if((unsigned)n > 4) { DIE(); }
				pBuilder->TBL_StpFlg1[iHitCd][(iPos1 - n + 21) % 21] |= (((1<<0)|(1<<3))<<iOrder);		//1[~tOZbgB2~ŉ\̗L2ނ̉ɑ΂ăZbgB
				aHkmCnt[iPos1] = n;
			}
			UnionHkmSet1(pBuilder, aHkmCnt);			//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
						pBuilder->TBL_StpFlg2[iHitCd][iPos1][(iPos2 - n + 21) % 21] |= (1<<iOrder);	//2[~tOZbgB
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				UnionHkmSet1(pBuilder, aHkmCnt);		//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
			}
		}
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					for(iPos3 = 0; iPos3 < 21; iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					UnionHkmSet1(pBuilder, aHkmCnt);	//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
				}
			}
		}
	}
	/* Zbg1\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet1, pBuilder->HkmSet1_Size, 21, memcmp21);	//ŁAZbg1ԍm肷B
	/*--- Zbg2do^ ---*/
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				aHkmSet1[iPos1] = UnionHkmSet1(pBuilder, aHkmCnt);
			}
			UnionHkmSet2(pBuilder, aHkmSet1);			//\[g܂ŁAZbg2ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					for(iPos3 = 0; iPos3 < 21; iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				UnionHkmSet2(pBuilder, aHkmSet1);		//\[g܂ŁAZbg2ԍ͖mBł́Ao^̂ݍsB
			}
		}
	}
	/* Zbg2\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet2, pBuilder->HkmSet2_Size, 21, memcmp21);	//ŁAZbg2ԍm肷B
	/*--- Zbg3do^ ---*/
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					for(iPos3 = 0; iPos3 < 21; iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				aHkmSet2[iPos1] = UnionHkmSet2(pBuilder, aHkmSet1);
			}
			UnionHkmSet3(pBuilder, aHkmSet2);			//\[g܂ŁAZbg3ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* Zbg3\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet2, pBuilder->HkmSet2_Size, 21, memcmp21);	//ŁAZbg3ԍm肷B
	/*--- 1[~f[^,2[~f[^,3[~f[^쐬 ---*/
	/* 1[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 3; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~[ */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				n = (*pInfo->fnGetStpCtl1)(pInfo->pParam, iHitCd, iReel1, iPos1);
				if((unsigned)n > 4) { DIE(); }
				aHkmCnt[iPos1] = n;
			}
			pBuilder->TBL_StpCtl1[iHitCd][iOrder] = UnionHkmSet1(pBuilder, aHkmCnt);
		}
	}
	for(i = 0; i < pBuilder->HkmSet1_Size; i++) {
		for(j = 0; j < (21 / 3); j++) {
			pBuilder->TBL_HkmSet1_Pack[i][j] = (pBuilder->TBL_HkmSet1[i][(j * 3) + 0]     ) +
			                                   (pBuilder->TBL_HkmSet1[i][(j * 3) + 1] *  6) +
			                                   (pBuilder->TBL_HkmSet1[i][(j * 3) + 2] * 36);
		}
	}
	for(i = 0; i < pBuilder->HkmSet1_Size; i += HkmSet1_CompUnit) {
		n = pBuilder->HkmSet1_Size - i;
		if(n > HkmSet1_CompUnit) { n = HkmSet1_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet1_CompData[pBuilder->HkmSet1_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet1_CompData) - pBuilder->HkmSet1_CompData_Size,
			&pBuilder->TBL_HkmSet1_Pack[i], n * (21 / 3));
		pBuilder->TBL_HkmSet1_CompSize[i / HkmSet1_CompUnit] = n;
		if((pBuilder->HkmSet1_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet1_CompData)) { DIE(); }
	}
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				aHkmSet1[iPos1] = UnionHkmSet1(pBuilder, aHkmCnt);
			}
			pBuilder->TBL_StpCtl2[iHitCd][iOrder] = UnionHkmSet2(pBuilder, aHkmSet1);
		}
	}
	for(i = 0; i < pBuilder->HkmSet2_Size; i += HkmSet2_CompUnit) {
		n = pBuilder->HkmSet2_Size - i;
		if(n > HkmSet2_CompUnit) { n = HkmSet2_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet2_CompData[pBuilder->HkmSet2_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet2_CompData) - pBuilder->HkmSet2_CompData_Size,
			&pBuilder->TBL_HkmSet2[i], n * 21);
		pBuilder->TBL_HkmSet2_CompSize[i / HkmSet2_CompUnit] = n;
		if((pBuilder->HkmSet2_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet2_CompData)) { DIE(); }
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < 21; iPos1++) {
				for(iPos2 = 0; iPos2 < 21; iPos2++) {
					for(iPos3 = 0; iPos3 < 21; iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				aHkmSet2[iPos1] = UnionHkmSet2(pBuilder, aHkmSet1);
			}
			pBuilder->TBL_StpCtl3[iHitCd][iOrder] = UnionHkmSet3(pBuilder, aHkmSet2);
		}
	}
	for(i = 0; i < pBuilder->HkmSet3_Size; i += HkmSet3_CompUnit) {
		n = pBuilder->HkmSet3_Size - i;
		if(n > HkmSet3_CompUnit) { n = HkmSet3_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet3_CompData[pBuilder->HkmSet3_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet3_CompData) - pBuilder->HkmSet3_CompData_Size,
			&pBuilder->TBL_HkmSet3[i], n * 21);
		pBuilder->TBL_HkmSet3_CompSize[i / HkmSet3_CompUnit] = n;
		if((pBuilder->HkmSet3_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet3_CompData)) { DIE(); }
	}
	/* ~f[^̃mۂB(1̃ubNƂĊmۂB1̃ubNƂĊJB) */
	p = calloc(1, sizeof(ST_Slot_StpCtl) +
		(pInfo->HitCd_Size * 3) +						/* TBL_StpCtl1 */
		(pInfo->HitCd_Size * 6) +						/* TBL_StpCtl2 */
		(pInfo->HitCd_Size * 6) +						/* TBL_StpCtl3 */
		((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit) +	/* TBL_HkmSet1_CompSize */
		((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit) +	/* TBL_HkmSet2_CompSize */
		((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit) +	/* TBL_HkmSet3_CompSize */
		pBuilder->HkmSet1_CompData_Size +					/* TBL_HkmSet1_CompData */
		pBuilder->HkmSet2_CompData_Size +					/* TBL_HkmSet2_CompData */
		pBuilder->HkmSet3_CompData_Size);					/* TBL_HkmSet3_CompData */
	if(!p) { DIE(); }
	pStpCtl                       = (void*)p;   p += sizeof(ST_Slot_StpCtl);
	pStpCtl->TBL_StpCtl1          = (void*)p;   p += (pInfo->HitCd_Size * 3);
	pStpCtl->TBL_StpCtl2          = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pStpCtl->TBL_StpCtl3          = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pStpCtl->TBL_HkmSet1_CompSize = (void*)p;   p += ((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit);
	pStpCtl->TBL_HkmSet2_CompSize = (void*)p;   p += ((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit);
	pStpCtl->TBL_HkmSet3_CompSize = (void*)p;   p += ((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit);
	pStpCtl->TBL_HkmSet1_CompData = (void*)p;   p += pBuilder->HkmSet1_CompData_Size;
	pStpCtl->TBL_HkmSet2_CompData = (void*)p;   p += pBuilder->HkmSet2_CompData_Size;
	pStpCtl->TBL_HkmSet3_CompData = (void*)p; //p += pBuilder->HkmSet3_CompData_Size;
	/* ~f[^i[B */
	pStpCtl->HitCd_Size            =    pInfo->HitCd_Size;
	pStpCtl->HkmSet1_CompUnit      =           HkmSet1_CompUnit;
	pStpCtl->HkmSet2_CompUnit      =           HkmSet2_CompUnit;
	pStpCtl->HkmSet3_CompUnit      =           HkmSet3_CompUnit;
	pStpCtl->HkmSet1_Size          = pBuilder->HkmSet1_Size;
	pStpCtl->HkmSet2_Size          = pBuilder->HkmSet2_Size;
	pStpCtl->HkmSet3_Size          = pBuilder->HkmSet3_Size;
	pStpCtl->HkmSet1_CompData_Size = pBuilder->HkmSet1_CompData_Size;
	pStpCtl->HkmSet2_CompData_Size = pBuilder->HkmSet2_CompData_Size;
	pStpCtl->HkmSet3_CompData_Size = pBuilder->HkmSet3_CompData_Size;
	memcpy((void*)pStpCtl->TBL_StpCtl1, pBuilder->TBL_StpCtl1, (pInfo->HitCd_Size * 3));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_StpCtl2, pBuilder->TBL_StpCtl2, (pInfo->HitCd_Size * 6));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_StpCtl3, pBuilder->TBL_StpCtl3, (pInfo->HitCd_Size * 6));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet1_CompSize, pBuilder->TBL_HkmSet1_CompSize, ((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet2_CompSize, pBuilder->TBL_HkmSet2_CompSize, ((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet3_CompSize, pBuilder->TBL_HkmSet3_CompSize, ((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet1_CompData, pBuilder->TBL_HkmSet1_CompData, pBuilder->HkmSet1_CompData_Size);						//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet2_CompData, pBuilder->TBL_HkmSet2_CompData, pBuilder->HkmSet2_CompData_Size);						//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet3_CompData, pBuilder->TBL_HkmSet3_CompData, pBuilder->HkmSet3_CompData_Size);						//LXgconstx}̂
	/* ~f[^r_̃JB */
	free(pBuilder);
	/* ~f[^̃ԂBďoŊJB */
	return pStpCtl;
}
/*--------------------------------------------------------------------------*/
void Slot_PrintStpCtl(const ST_Slot_StpCtl* pStpCtl, FILE* fpH, FILE* fpC) {
	int iHitCd, iOrder, i;
	//1[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl1[/*HitCd_Size*/][3]/*[21]*/={//(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 3; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl1[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//2[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl2[/*HitCd_Size*/][6]/*[21][21]*/={//{TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData}(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 6; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl2[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//3[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl3[/*HitCd_Size*/][6]/*[21][21][21]*/={//(TBL_HkmSet3_CompSize,TBL_HkmSet3_CompData)(TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 6; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl3[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//Zbg1o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet1_CompSize[/*(HkmSet1_Size+HkmSet1_CompUnit-1)/HkmSet1_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet1_Size; i += pStpCtl->HkmSet1_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet1_CompSize[i/pStpCtl->HkmSet1_CompUnit],
			                             (i/pStpCtl->HkmSet1_CompUnit),
			i, (((i+pStpCtl->HkmSet1_CompUnit)<pStpCtl->HkmSet1_Size)?(i+pStpCtl->HkmSet1_CompUnit):pStpCtl->HkmSet1_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet1_CompData[/*HkmSet1_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet1_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet1_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet1_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//Zbg2o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet2_CompSize[/*(HkmSet2_Size+HkmSet2_CompUnit-1)/HkmSet2_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet2_Size; i += pStpCtl->HkmSet2_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet2_CompSize[i/pStpCtl->HkmSet2_CompUnit],
			                             (i/pStpCtl->HkmSet2_CompUnit),
			i, (((i+pStpCtl->HkmSet2_CompUnit)<pStpCtl->HkmSet2_Size)?(i+pStpCtl->HkmSet2_CompUnit):pStpCtl->HkmSet2_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet2_CompData[/*HkmSet2_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet2_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet2_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet2_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//Zbg3o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet3_CompSize[/*(HkmSet3_Size+HkmSet3_CompUnit-1)/HkmSet3_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet3_Size; i += pStpCtl->HkmSet3_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet3_CompSize[i/pStpCtl->HkmSet3_CompUnit],
			                             (i/pStpCtl->HkmSet3_CompUnit),
			i, (((i+pStpCtl->HkmSet3_CompUnit)<pStpCtl->HkmSet3_Size)?(i+pStpCtl->HkmSet3_CompUnit):pStpCtl->HkmSet3_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet3_CompData[/*HkmSet3_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet3_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet3_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet3_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//~f[^o͂B
	fprintf(fpH, "extern const ST_Slot_StpCtl stStpCtl;\n");
	fprintf(fpC,        "const ST_Slot_StpCtl stStpCtl={\n");
	fprintf(fpC, "%4d,//HitCd_Size\n",            pStpCtl->HitCd_Size);
	fprintf(fpC, "%4d,//HkmSet1_CompUnit\n",      pStpCtl->HkmSet1_CompUnit);
	fprintf(fpC, "%4d,//HkmSet2_CompUnit\n",      pStpCtl->HkmSet2_CompUnit);
	fprintf(fpC, "%4d,//HkmSet3_CompUnit\n",      pStpCtl->HkmSet3_CompUnit);
	fprintf(fpC, "%4d,//HkmSet1_Size\n",          pStpCtl->HkmSet1_Size);
	fprintf(fpC, "%4d,//HkmSet2_Size\n",          pStpCtl->HkmSet2_Size);
	fprintf(fpC, "%4d,//HkmSet3_Size\n",          pStpCtl->HkmSet3_Size);
	fprintf(fpC, "%4d,//HkmSet1_CompData_Size\n", pStpCtl->HkmSet1_CompData_Size);
	fprintf(fpC, "%4d,//HkmSet2_CompData_Size\n", pStpCtl->HkmSet2_CompData_Size);
	fprintf(fpC, "%4d,//HkmSet3_CompData_Size\n", pStpCtl->HkmSet3_CompData_Size);
	fprintf(fpC, "TBL_StpCtl1,\n");
	fprintf(fpC, "TBL_StpCtl2,\n");
	fprintf(fpC, "TBL_StpCtl3,\n");
	fprintf(fpC, "TBL_HkmSet1_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet2_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet3_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet1_CompData,\n");
	fprintf(fpC, "TBL_HkmSet2_CompData,\n");
	fprintf(fpC, "TBL_HkmSet3_CompData,\n");
	fprintf(fpC, "};\n");
}
#endif//WIN32	//PCŒ~f[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B

/****************************************************************************
 *	XybNf[^쐬Eo
 ****************************************************************************/
#ifdef  WIN32	//PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
/*--------------------------------------------------------------------------*
 *	o̔f
 *--------------------------------------------------------------------------*/
//#define SLOT_SPEC_ALLOW_TPIHZ_NOBONUS	//̃V{`ƁA_uepCnYEgvepCnYeB
//#define SLOT_SPEC_ALLOW_MIDCH_NOBONUS	//̃V{`ƁAi`F[[`ڂƂȂB
//#define SLOT_SPEC_ALLOW_CHSEV_NOBONUS	//̃V{`ƁAi`F[tZu[`ڂƂȂB
/*--------------------------------------------------------------------------*
 *	\
 *--------------------------------------------------------------------------*/
/* 3[ܔ */
typedef struct _ST_Slot_HitChk3 {
	unsigned char	iHitFlg[5/*iLine*/];					//[Cԍ]ˊGgԍ				0`(SIZE_HitFlg-1)
	unsigned char	aPriority[64/*SIZE_HitCd*/];				//[uԍ]˗Dx				0,1`		uDx=0vȂ΁A~sł邱ƂB
} ST_Slot_HitChk3;
/* 2[ܗ\ */
typedef struct _ST_Slot_HitChk2 {
	unsigned char	aMinPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍŏDx				0,1`		uŏDx=0vȂ΁A~sł邱ƂB
	unsigned char	aMaxPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍőDx				0,1`		őDxŏDx
} ST_Slot_HitChk2;
/* 1[ܗ\ */
typedef struct _ST_Slot_HitChk1 {
	unsigned char	aMinPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍŏDx				0,1`		uŏDx=0vȂ΁A~sł邱ƂB
	unsigned char	aMaxPriority[64/*SIZE_HitCd*/];				//[uԍ]ˍőDx				0,1`		őDxŏDx
} ST_Slot_HitChk1;
/* 1[~ */
typedef struct _ST_Slot_StpCtl1 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl1;
/* 2[~ */
typedef struct _ST_Slot_StpCtl2 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl2;
/* 3[~ */
typedef struct _ST_Slot_StpCtl3 {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/];				//[uԍ]ˈ				0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aStpFlg[64/*SIZE_HitCd*/];				//[uԍ]˒~\				0,1
} ST_Slot_StpCtl3;
/* ~eXg */
typedef struct _ST_Slot_StpTst {
	unsigned char	aHkmCnt[64/*SIZE_HitCd*/][3];				//[uԍ][[ԍ]ˈ			0`4,5		u=5vƂ́A~σ[̒~sʒułA`ĂȂƂB
	unsigned char	aPriority[64/*SIZE_HitCd*/];				//[uԍ]˗Dx				0,1`
} ST_Slot_StpTst;
/* GgeXg */
typedef struct _ST_Slot_CmbTst {
	int		nCmbCnt;						//Gg					0~
	int		aStpCnt[64/*SIZE_HitCd*/][5/*iLine*/];			//[uԍ][Cԍ]ˊGg\	0~
	unsigned char	aResult[64/*SIZE_HitCd*/];				//[uԍ]ˌ				0~2		0=,1=G[:uɊ܂܂Ȃ̂ɕ\ꂽ,2=x:uɊ܂܂̂ɕ\Ȃ
} ST_Slot_CmbTst;
/* XybNf[^r_ */
typedef struct _ST_Slot_Spec_Builder {
	const ST_Slot_SpecInfo* pInfo;						//XybN
	ST_Slot_HitChk3 TBL_HitChk3[21][21][21];				//[[~ʒu][[~ʒu][E[~ʒu]3[ܔ
	ST_Slot_HitChk2 TBL_HitChk2[3][21][21];					//[][~σ[1~ʒu][~σ[2~ʒu]2[ܗ\
										// =0c~σ[1=,~σ[2=
										// =1c~σ[1=,~σ[2=E
										// =2c~σ[1=E,~σ[2=
	ST_Slot_HitChk1 TBL_HitChk1[3][21];					//[][~σ[~ʒu]1[ܗ\
										// =0c~σ[=
										// =1c~σ[=
										// =2c~σ[=E
	ST_Slot_StpCtl1 TBL_StpCtl1[3][21];					//[][~[ʒu]1[~
										// =0c~[=
										// =1c~[=
										// =2c~[=E
	ST_Slot_StpCtl2 TBL_StpCtl2[6][21][21];					//[][~σ[~ʒu][~[ʒu]2[~
										// =0c~σ[=,~[=
										// =1c~σ[=,~[=E
										// =2c~σ[=E,~[=
										// =3c~σ[=,~[=E
										// =4c~σ[=,~[=
										// =5c~σ[=E,~[=
	ST_Slot_StpCtl3 TBL_StpCtl3[6][21][21][21];				//[][~σ[1~ʒu][~σ[2~ʒu][~[ʒu]3[~
										// =0c~σ[1=,~σ[2=,~[=E
										// =1c~σ[1=,~σ[2=E,~[=
										// =2c~σ[1=E,~σ[2=,~[=
										// =3c~σ[1=,~σ[2=E,~[=
										// =4c~σ[1=,~σ[2=,~[=E
										// =5c~σ[1=E,~σ[2=,~[=
	ST_Slot_StpTst TBL_StpTst[6][21][21][21];				//[ԍ][1~[ʒu][2~[ʒu][3~[ʒu]˒~eXg
	ST_Slot_CmbTst TBL_CmbTst[256/*SIZE_HitFlg*/];				//[Ggԍ]ˊGgeXg
} ST_Slot_Spec_Builder;
/*--------------------------------------------------------------------------*
 *	[J萔
 *--------------------------------------------------------------------------*/
static const char* const TBL_Slot_Spec_Color[7+1]={"gray","red","green","yellow","blue","magenta","cyan","white"};	//[Fԍ]HTMLJ[l[
static const unsigned char TBL_Slot_Spec_HkmCnt_Color[5+1]={7,6,3,5,1,0};	//[]ːFԍ
static const char* const TBL_Slot_Spec_Result_Mark[2+1]={"","~",""};	//[]ˌʋL
static const unsigned char TBL_Slot_Spec_Result_Color[2+1]={4,1,3};		//[]ːFԍ
/*--------------------------------------------------------------------------*
 *	[J֐
 *--------------------------------------------------------------------------*/
/* Gʒu(iPictPos)A(nHkmCnt)A񂾊Gʒu߂B
 * [in]
 *	iPictPos	Gʒu	0`20
 *	nHkmCnt			0`4
 * [out]
 *	߂l		Gʒu	0`20
 */
static int Slot_Spec_GetPictPos_Hkm(int iPictPos, int nHkmCnt) {
	if((unsigned)iPictPos > 20) { DIE(); }
	if((unsigned)nHkmCnt > 4) { DIE(); }
	if((iPictPos -= nHkmCnt) < 0) { iPictPos += 21; }
	return iPictPos;
}
/*--------------------------------------------------------------------------*/
/* e[̒~GAiPict1,iPict2,iPict3łAGgB
 * [in]
 *	pBuilder	XybNf[^r_
 *	iPict1		[̊Gԍ	0`(SIZE_Pict-1)
 *	iPict2		[̊Gԍ	0`(SIZE_Pict-1)
 *	iPict3		E[̊Gԍ	0`(SIZE_Pict-1)
 * [out]
 *	߂l		Ggԍ		0`(SIZE_HitFlg-1)
 */
static int Slot_Spec_FindHitFlg(ST_Slot_Spec_Builder* pBuilder, int iPict1, int iPict2, int iPict3) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iHitFlg;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	/* w肳ꂽGԍł邱ƂmFB */
	if(((unsigned)iPict1 >= (unsigned)pInfo->SIZE_Pict) ||
	   ((unsigned)iPict2 >= (unsigned)pInfo->SIZE_Pict) ||
	   ((unsigned)iPict3 >= (unsigned)pInfo->SIZE_Pict)) { DIE(); }
	/* eGgɂāc */
	for(iHitFlg = pInfo->SIZE_HitFlg - 1; iHitFlg >= 0; iHitFlg--) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		/* Ggf[^jĂȂƂmFB */
		if(((unsigned)pHitFlg->aPict[0] >= (unsigned)pInfo->SIZE_Pict) ||
		   ((unsigned)pHitFlg->aPict[1] >= (unsigned)pInfo->SIZE_Pict) ||
		   ((unsigned)pHitFlg->aPict[2] >= (unsigned)pInfo->SIZE_Pict)) { DIE(); }
		/* GԍvAGgԍԂB */
		if((!pHitFlg->aPict[0] || (pHitFlg->aPict[0] == iPict1)) &&
		   (!pHitFlg->aPict[1] || (pHitFlg->aPict[1] == iPict2)) &&
		   (!pHitFlg->aPict[2] || (pHitFlg->aPict[2] == iPict3))) { return iHitFlg; }
	}
	DIE(); /* ȂƂA(iHitFlg=0:nY)Ɉv͂Ȃ̂ŁA֓BG[B */
}
/*--------------------------------------------------------------------------*
 *	3[ܔ
 *--------------------------------------------------------------------------*/
/* 3[ܔf[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk3(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iReel1, iReel2, iReel3, iLine, iHitCd;
	ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	iReel1 = 0; /* [ */
	iReel2 = 1; /* [ */
	iReel3 = 2; /* E[ */
	/* [̊e~ʒuɂāc */
	for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
		/* [̊e~ʒuɂāc */
		for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
			/* E[̊e~ʒuɂāc */
			for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
				pHitChk3 = &pBuilder->TBL_HitChk3[aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
				/* eCɂāc */
				for(iLine = 0; iLine < 5; iLine++) {
					/* Ggԍ擾B */
					pHitChk3->iHitFlg[iLine] = Slot_Spec_FindHitFlg(pBuilder,
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + Slot_GetLineRow(iLine, iReel1), iReel1),
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + Slot_GetLineRow(iLine, iReel2), iReel2),
						Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3] + Slot_GetLineRow(iLine, iReel3), iReel3));
				}
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					/* eCɂāc */
					for(iLine = 0; iLine < 5; iLine++) {
						/* ̃ĆAGg擾B */
						pHitFlg = &pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]];
						if(pHitFlg->aPriority[iHitCd] < -1) { DIE(); }
						/* ̏uŒ~\ȊGgȂ΁c */	//̔fł́ADx(-1)܂߂B
						if(pHitFlg->aPriority[iHitCd]) {
							/* DxXVB */			//̔fŁADx(-1)OB
							if((int)pHitFlg->aPriority[iHitCd] > (int)pHitChk3->aPriority[iHitCd]) { pHitChk3->aPriority[iHitCd] = pHitFlg->aPriority[iHitCd]; }
						/* ̏uŒ~sȊGg1łL΁c */
						} else {
							/* ~sƌ肷B */
							pHitChk3->aPriority[iHitCd] = 0;
							break; /* ܂ */
						}
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 3[ܔf[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk3(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iReel1, iReel2, iReel3, iLine, iHitCd;
	const ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_Pict* pPict;
	iReel1 = 0; /* [ */
	iReel2 = 1; /* [ */
	iReel3 = 2; /* E[ */
	fprintf(fp, "<table>\n");
	fprintf(fp, "<caption>%s</caption>\n", "TBL_HitChk3");
	/* [̊e~ʒuɂāc */
	for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
		/* [̊e~ʒuɂāc */
		for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
			/* E[̊e~ʒuɂāc */
			for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
				pHitChk3 = &pBuilder->TBL_HitChk3[aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel3]);							//E[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3], iReel3)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//E[~G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* eCɂāc */
				  fprintf(fp, "<td>");
				    for(iLine = 0; iLine < 5; iLine++) {
				    	if(iLine) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]].iColor]);
				    	  fprintf(fp, "%s", pInfo->TBL_HitFlg[pHitChk3->iHitFlg[iLine]].pName);			//Gg
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				  //euɂāc
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk3->aPriority[iHitCd] ? 7 : 0]);
				    	  fprintf(fp, "%d", pHitChk3->aPriority[iHitCd]);					//Dx
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
	}
	fprintf(fp, "</table>\n");
}
/*--------------------------------------------------------------------------*
 *	2[ܗ\
 *--------------------------------------------------------------------------*/
/* 2[ܗ\f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk2(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, nHkmCnt, nMinPriority1, nMaxPriority1, nMinPriority2, nMaxPriority2;
	ST_Slot_HitChk2* pHitChk2;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ][ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pHitChk2 = &pBuilder->TBL_HitChk2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					nMinPriority1 = nMaxPriority1 = 0;
					/* ][̊e~ʒuɂāc */
					for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
						nMinPriority2 = nMaxPriority2 = 0;
						/* ő擾B */
						nHkmCnt = (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel3 == pInfo->CT_Reel)) ? 1 : 4;
						/* eɂāc */
						do {
							/* 3[ܔf[^擾 */
							switch(iReel3) {
							case 0: pHitChk3 = &pBuilder->TBL_HitChk3[Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ][                         aPictPos[2]          ]; break;
							case 1: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
							case 2: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
							default: DIE();
							}
							/* ~\Ȃ΁c */
							if(pHitChk3->aPriority[iHitCd]) {
								/* ŏDxƍőDxXVB */
								if(!nMinPriority2) {	/*  */
									nMinPriority2 = pHitChk3->aPriority[iHitCd];
									nMaxPriority2 = pHitChk3->aPriority[iHitCd];
								} else {		/* XV */
									if(pHitChk3->aPriority[iHitCd] < nMinPriority2) { nMinPriority2 = pHitChk3->aPriority[iHitCd]; }
									if(pHitChk3->aPriority[iHitCd] > nMaxPriority2) { nMaxPriority2 = pHitChk3->aPriority[iHitCd]; }
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁c */
						if(!nMinPriority2) {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
							break; /* ܂ */
						}
						/* ŏDxƍőDxXVB */
						if(!nMinPriority1) {	/*  */
							nMinPriority1 = nMinPriority2;
							nMaxPriority1 = nMaxPriority2;
						} else {		/* XV */
							if(nMinPriority2 < nMinPriority1) { nMinPriority1 = nMinPriority2; }
							if(nMaxPriority2 > nMaxPriority1) { nMaxPriority1 = nMaxPriority2; }
						}
					}
#ifndef SLOT_SPEC_ALLOW_TPIHZ_NOBONUS
					//{{--- _uepCnYEgvepCnY֎~ꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
					/* unYȂ΁c */
					if(!iHitCd) {
						int iLine, TpiCnt = 0;
						/* eCɂāc */
						for(iLine = 0; iLine < 5; iLine++) {
							/* epCsB */
							if(Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + Slot_GetLineRow(iLine, iReel1), iReel1) ==
							   Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2] + Slot_GetLineRow(iLine, iReel2), iReel2)) { TpiCnt++; }
						}
						/* unYŁAepCC2CȏȂ΁A~sƌ肷B */
						if(TpiCnt >= 2) { nMinPriority1 = nMaxPriority1 = 0; }
					}
					//}}--- _uepCnYEgvepCnY֎~ꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_TPIHZ_NOBONUS
					/* ŏDxƍőDxi[B */
					pHitChk2->aMinPriority[iHitCd] = nMinPriority1;
					pHitChk2->aMaxPriority[iHitCd] = nMaxPriority1;
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 2[ܗ\f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk2(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd;
	const ST_Slot_HitChk2* pHitChk2;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_HitChk2", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pHitChk2 = &pBuilder->TBL_HitChk2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//~σ[1~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[1~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//~σ[2~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[2~G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* euɂāc */
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk2->aMinPriority[iHitCd] ? 7 : 0]);
				    	  fprintf(fp, "%d-%d", pHitChk2->aMinPriority[iHitCd], pHitChk2->aMaxPriority[iHitCd]);	//ŏDx,őDx
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	1[ܗ\
 *--------------------------------------------------------------------------*/
/* 1[ܗ\f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildHitChk1(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd, nHkmCnt, nMinPriority1, nMaxPriority1, nMinPriority2, nMaxPriority2, nMinPriority3, nMaxPriority3;
	ST_Slot_HitChk1* pHitChk1;
	const ST_Slot_HitChk2* pHitChk2;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pHitChk1 = &pBuilder->TBL_HitChk1[iOrder][aPictPos[iReel1]];
			/* euɂāc */
			for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				nMinPriority1 = nMaxPriority1 = 0;
				/* ][1Ɖ][2ɂāc */
				for(iReel2 = (iReel1+1)%3; iReel2 != iReel1; iReel2 = (iReel2+1)%3) {
					nMinPriority2 = nMaxPriority2 = 0;
					/* ][̊e~ʒuɂāc */
					for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
						nMinPriority3 = nMaxPriority3 = 0;
						/* ő擾B */
						nHkmCnt = (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel2 == pInfo->CT_Reel)) ? 1 : 4;
						/* eɂāc */
						do {
							/* 2[ܗ\f[^擾 */
							switch(iReel1) {
							case 0:
								switch(iReel2) {
								case 1: pHitChk2 = &pBuilder->TBL_HitChk2[0][                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)]; break;
								case 2: pHitChk2 = &pBuilder->TBL_HitChk2[2][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)][                         aPictPos[0]          ]; break;
								default: DIE();
								}
								break;
							case 1:
								switch(iReel2) {
								case 2: pHitChk2 = &pBuilder->TBL_HitChk2[1][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
								case 0: pHitChk2 = &pBuilder->TBL_HitChk2[0][Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ]; break;
								default: DIE();
								}
								break;
							case 2:
								switch(iReel2) {
								case 0: pHitChk2 = &pBuilder->TBL_HitChk2[2][                         aPictPos[2]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)]; break;
								case 1: pHitChk2 = &pBuilder->TBL_HitChk2[1][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
								default: DIE();
								}
								break;
							default:
								DIE();
							}
							/* ~\Ȃ΁c */
							if(pHitChk2->aMinPriority[iHitCd]) {
								/* ŏDxƍőDxXVB */
								if(!nMinPriority3) {
									nMinPriority3 = pHitChk2->aMinPriority[iHitCd];
									nMaxPriority3 = pHitChk2->aMaxPriority[iHitCd];
								} else {
									if(pHitChk2->aMinPriority[iHitCd] < nMinPriority3) { nMinPriority3 = pHitChk2->aMinPriority[iHitCd]; }
									if(pHitChk2->aMaxPriority[iHitCd] > nMaxPriority3) { nMaxPriority3 = pHitChk2->aMaxPriority[iHitCd]; }
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁c */
						if(!nMinPriority3) {
							/* ~sƌ肷B */
							nMinPriority2 = nMaxPriority2 = 0;
							break; /* ܂ */
						}
						/* ŏDxƍőDxXVB */
						if(!nMinPriority2) {
							nMinPriority2 = nMinPriority3;
							nMaxPriority2 = nMaxPriority3;
						} else {
							if(nMinPriority3 < nMinPriority2) { nMinPriority2 = nMinPriority3; }
							if(nMaxPriority3 > nMaxPriority2) { nMaxPriority2 = nMaxPriority3; }
						}
					}
					/* ][̕Еł~sȂ΁c */
					if(!nMinPriority2) {
						/* ~sƌ肷B */
						nMinPriority1 = nMaxPriority1 = 0;
						break; /* ܂ */
					}
					/* ŏDxƍőDxXVB */
					if(!nMinPriority1) {
						nMinPriority1 = nMinPriority2;
						nMaxPriority1 = nMaxPriority2;
					} else {
						if(nMinPriority2 < nMinPriority1) { nMinPriority1 = nMinPriority2; }
						if(nMaxPriority2 > nMaxPriority1) { nMaxPriority1 = nMaxPriority2; }
					}
				}
#ifndef SLOT_SPEC_ALLOW_MIDCH_NOBONUS
				//{{--- [1~Ai`F[[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
				/* [1~Ȃ΁c */
				if(iReel1 == 0) {
					/* i`F[Ȃ΁c */
					if(strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 1/*i*/, iReel1)].pName, "ذ")) {
						/* u{[iXȂ΁c */
						if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ްŽ")) {
							/* oA[`ڂނƂɂB͉o̔fłAK{ł͂ȂB */
							if(!nMinPriority1) { DIE(); }	/* ŏDxA~\ł͂BłȂΐ݌v~XB */
							nMaxPriority1++;		/* őDxAZů̗Dx+1ƂB */			//uőDxŏDxvێ邽߂ɁAőDx̕𑝂₷ƂɂBŗǂvB͈ႤA{[iXƏdID搧ƂꍇɁADɂȂȂ肪邩mȂBŏDx𑝂₷K؂?
						/* u{[iXȊOȂ΁c */
						} else {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
						}
					}
				}
				//}}--- [1~Ai`F[[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_MIDCH_NOBONUS
#ifndef SLOT_SPEC_ALLOW_CHSEV_NOBONUS
				//{{--- E[1~Ai`F[tZu[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
				/* E[1~Ȃ΁c */
				if(iReel1 == 2) {
					/* i`F[tZuȂ΁c */
					if(strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 1/*i*/, iReel1)].pName, "ذ") &&
					   strstr(pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1] + 2/*i*/, iReel1)].pName, "")) {
						/* u{[iXȂ΁c */
						if(strstr(pInfo->TBL_HitCd[iHitCd].pName, "ްŽ")) {
							/* oA[`ڂނƂɂB͉o̔fłAK{ł͂ȂB */
							if(!nMinPriority1) { DIE(); }	/* ŏDxA~\ł͂BłȂΐ݌v~XB */
							nMaxPriority1++;		/* őDxAZů̗Dx+1ƂB */			//uőDxŏDxvێ邽߂ɁAőDx̕𑝂₷ƂɂBŗǂvB͈ႤA{[iXƏdID搧ƂꍇɁADɂȂȂ肪邩mȂBŏDx𑝂₷K؂?
						/* u{[iXȊOȂ΁c */
						} else {
							/* ~sƌ肷B */
							nMinPriority1 = nMaxPriority1 = 0;
						}
					}
				}
				//}}--- E[1~Ai`F[tZu[`ڂƂꍇ́ÃubNLɂB͉o̔fłAK{ł͂ȂB ---
#endif//SLOT_SPEC_ALLOW_CHSEV_NOBONUS
				/* ŏDxƍőDxi[B */
				pHitChk1->aMinPriority[iHitCd] = nMinPriority1;
				pHitChk1->aMaxPriority[iHitCd] = nMaxPriority1;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 1[ܗ\f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintHitChk1(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd;
	const ST_Slot_HitChk1* pHitChk1;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_HitChk1", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pHitChk1 = &pBuilder->TBL_HitChk1[iOrder][aPictPos[iReel1]];
			fprintf(fp, "<tr>");
			  fprintf(fp, "<td>");
			    fprintf(fp, "%2d", aPictPos[iReel1]);								//~σ[~ʒu
			    fprintf(fp, " ");
			    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
			    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
			      fprintf(fp, "%s", pPict->pName);									//~σ[~G
			    fprintf(fp, "</font>");
			  fprintf(fp, "</td>");
			  /* euɂāc */
			  fprintf(fp, "<td>");
			    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			    	if(iHitCd) { fprintf(fp, " "); }
			    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitChk1->aMinPriority[iHitCd] ? 7 : 0]);
			    	  fprintf(fp, "%d-%d", pHitChk1->aMinPriority[iHitCd], pHitChk1->aMaxPriority[iHitCd]);		//ŏDx,őDx
			    	fprintf(fp, "</font>");
			    }
			  fprintf(fp, "</td>");
			fprintf(fp, "</tr>\n");
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	1[~
 *--------------------------------------------------------------------------*/
/* 1[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl1(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd, nHkmCnt, nMinPriority, nMaxPriority;
	ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_HitChk1* pHitChk1;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~[ */
		/* ~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][aPictPos[iReel1]];
			/* euɂāc */
			for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				nMinPriority = nMaxPriority = 0;
				pStpCtl1->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
				/* ő擾B */
				nHkmCnt = (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel1 == pInfo->CT_Reel)) ? 1 : 4;
				/* eɂāc */
				do {
					/* 1[ܗ\f[^擾 */
					switch(iReel1) {
					case 0: pHitChk1 = &pBuilder->TBL_HitChk1[0][Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)]; break;
					case 1: pHitChk1 = &pBuilder->TBL_HitChk1[1][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)]; break;
					case 2: pHitChk1 = &pBuilder->TBL_HitChk1[2][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
					default: DIE();
					}
					/* ~\Ȃ΁c */
					if(pHitChk1->aMinPriority[iHitCd]) {
						/* I:
						 * EőDx傫΁AIB
						 * EőDx,,ŏDx傫΁AIB
						 * EőDx,,ŏDxȂ΁AIBA[v̌Dŏ㏑B
						 */
						if((pHitChk1->aMaxPriority[iHitCd] >  nMaxPriority) ||
						  ((pHitChk1->aMaxPriority[iHitCd] == nMaxPriority) && (pHitChk1->aMinPriority[iHitCd] >= nMinPriority))) {
							nMinPriority = pHitChk1->aMinPriority[iHitCd];
							nMaxPriority = pHitChk1->aMaxPriority[iHitCd];
							pStpCtl1->aHkmCnt[iHitCd] = nHkmCnt;
						}
					}
				} while(--nHkmCnt >= 0);
				/* SĂ̈Œ~sȂ΁A݌v~XłB */
				if(pStpCtl1->aHkmCnt[iHitCd] == 5) { DIE(); }
				/* ۂɒ~~ʒuɁA~\}[NB */
				pBuilder->TBL_StpCtl1[iOrder][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpCtl1->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 1[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl1(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iHitCd;
	const ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 3; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl1", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~[ */
		/* ~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][aPictPos[iReel1]];
			fprintf(fp, "<tr>");
			  fprintf(fp, "<td>");
			    fprintf(fp, "%2d", aPictPos[iReel1]);								//~[ʒu
			    fprintf(fp, " ");
			    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
			    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
			      fprintf(fp, "%s", pPict->pName);									//~[G
			    fprintf(fp, "</font>");
			  fprintf(fp, "</td>");
			  /* euɂāc */
			  fprintf(fp, "<td>");
			    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			    	if(iHitCd) { fprintf(fp, " "); }
			    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl1->aHkmCnt[iHitCd]]]);
			    	  fprintf(fp, "%d", pStpCtl1->aHkmCnt[iHitCd]);							//
			    	fprintf(fp, "</font>");
			    }
			  fprintf(fp, "</td>");
			fprintf(fp, "</tr>\n");
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	2[~
 *--------------------------------------------------------------------------*/
/* 2[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl2(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd, nHkmCnt, nMinPriority, nMaxPriority;
	ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_HitChk2* pHitChk2;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				/* euɂāc */
				for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					nMinPriority = nMaxPriority = 0;
					pStpCtl2->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
					/* ~σ[̒~ʒuA~\Ȃ΁c */
					if(pBuilder->TBL_StpCtl1[iReel1][aPictPos[iReel1]].aStpFlg[iHitCd]) {
						/* ő擾B */
						nHkmCnt = (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel2 == pInfo->CT_Reel)) ? 1 : 4;
						/* eɂāc */
						do {
							/* 2[ܗ\f[^擾 */
							switch(iReel1) {
							case 0:
								switch(iReel2) {
								case 1: pHitChk2 = &pBuilder->TBL_HitChk2[0][                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)]; break;
								case 2: pHitChk2 = &pBuilder->TBL_HitChk2[2][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)][                         aPictPos[0]          ]; break;
								default: DIE();
								}
								break;
							case 1:
								switch(iReel2) {
								case 2: pHitChk2 = &pBuilder->TBL_HitChk2[1][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
								case 0: pHitChk2 = &pBuilder->TBL_HitChk2[0][Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ]; break;
								default: DIE();
								}
								break;
							case 2:
								switch(iReel2) {
								case 0: pHitChk2 = &pBuilder->TBL_HitChk2[2][                         aPictPos[2]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)]; break;
								case 1: pHitChk2 = &pBuilder->TBL_HitChk2[1][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
								default: DIE();
								}
								break;
							default:
								DIE();
							}
							/* ~\Ȃ΁c */
							if(pHitChk2->aMinPriority[iHitCd]) {
								/* I:
								 * EőDx傫΁AIB
								 * EőDx,,ŏDx傫΁AIB
								 * EőDx,,ŏDxȂ΁AIBA[v̌Dŏ㏑B
								 */
								if((pHitChk2->aMaxPriority[iHitCd] >  nMaxPriority) ||
								  ((pHitChk2->aMaxPriority[iHitCd] == nMaxPriority) && (pHitChk2->aMinPriority[iHitCd] >= nMinPriority))) {
									nMinPriority = pHitChk2->aMinPriority[iHitCd];
									nMaxPriority = pHitChk2->aMaxPriority[iHitCd];
									pStpCtl2->aHkmCnt[iHitCd] = nHkmCnt;
								}
							}
						} while(--nHkmCnt >= 0);
						/* SĂ̈Œ~sȂ΁A݌v~XłB */
						if(pStpCtl2->aHkmCnt[iHitCd] == 5) { DIE(); }
						/* ۂɒ~~ʒuɁA~\}[NB */
						pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpCtl2->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 2[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl2(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iHitCd;
	const ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl2", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~[ */
		/* ~σ[̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]];
				fprintf(fp, "<tr>");
				  fprintf(fp, "<td>");
				    fprintf(fp, "%2d", aPictPos[iReel1]);							//~σ[~ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~σ[~G
				    fprintf(fp, "</font>");
				    fprintf(fp, " ");
				    fprintf(fp, "%2d", aPictPos[iReel2]);							//~[ʒu
				    fprintf(fp, " ");
				    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
				    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
				      fprintf(fp, "%s", pPict->pName);								//~[G
				    fprintf(fp, "</font>");
				  fprintf(fp, "</td>");
				  /* euɂāc */
				  fprintf(fp, "<td>");
				    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
				    	if(iHitCd) { fprintf(fp, " "); }
				    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl2->aHkmCnt[iHitCd]]]);
				    	  fprintf(fp, "%d", pStpCtl2->aHkmCnt[iHitCd]);						//
				    	fprintf(fp, "</font>");
				    }
				  fprintf(fp, "</td>");
				fprintf(fp, "</tr>\n");
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	3[~
 *--------------------------------------------------------------------------*/
/* 3[~f[^쐬B
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpCtl3(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, nHkmCnt, Priority;
	ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ~[ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* ~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						Priority = 0;;
						pStpCtl3->aHkmCnt[iHitCd] = 5;	/* ~sƂĂB */
						/* ~σ[1ƒ~σ[2̒~ʒuA~\Ȃ΁c */
						if(pBuilder->TBL_StpCtl2[iOrder][aPictPos[iReel1]][aPictPos[iReel2]].aStpFlg[iHitCd]) {
							/* ő擾B */
							nHkmCnt = (strstr(pInfo->TBL_HitCd[iHitCd].pName, "S") && (iReel3 == pInfo->CT_Reel)) ? 1 : 4;
							/* eɂāc */
							do {
								/* 3[ܔf[^擾 */
								switch(iReel3) {
								case 0: pHitChk3 = &pBuilder->TBL_HitChk3[Slot_Spec_GetPictPos_Hkm(aPictPos[0], nHkmCnt)][                         aPictPos[1]          ][                         aPictPos[2]          ]; break;
								case 1: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[1], nHkmCnt)][                         aPictPos[2]          ]; break;
								case 2: pHitChk3 = &pBuilder->TBL_HitChk3[                         aPictPos[0]          ][                         aPictPos[1]          ][Slot_Spec_GetPictPos_Hkm(aPictPos[2], nHkmCnt)]; break;
								default: DIE();
								}
								/* ~\Ȃ΁c */
								if(pHitChk3->aPriority[iHitCd]) {
									/* I:
									 * EDx傫΁AIB
									 * EDxȂ΁AIBA[v̌Dŏ㏑B
									 */
									if(pHitChk3->aPriority[iHitCd] >= Priority) {
										Priority = pHitChk3->aPriority[iHitCd];
										pStpCtl3->aHkmCnt[iHitCd] = nHkmCnt;
									}
								}
							} while(--nHkmCnt >= 0);
							/* SĂ̈Œ~sȂ΁A݌v~XłB */
							if(pStpCtl3->aHkmCnt[iHitCd] == 5) { DIE(); }
							/* ۂɒ~~ʒuɁA~\}[NB */
							pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpCtl3->aHkmCnt[iHitCd])].aStpFlg[iHitCd] = 1;
						}
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* 3[~f[^HTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpCtl3(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd;
	const ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_Spec_Pict* pPict;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpCtl3", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* ~σ[1 */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* ~σ[2 */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* ~[ */
		/* ~σ[1̊e~ʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* ~σ[2̊e~ʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* ~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					fprintf(fp, "<tr>");
					  fprintf(fp, "<td>");
					    fprintf(fp, "%2d", aPictPos[iReel1]);						//~σ[1~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel1], iReel1)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~σ[1~G
					    fprintf(fp, "</font>");
					    fprintf(fp, " ");
					    fprintf(fp, "%2d", aPictPos[iReel2]);						//~σ[2~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel2], iReel2)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~σ[2~G
					    fprintf(fp, "</font>");
					    fprintf(fp, " ");
					    fprintf(fp, "%2d", aPictPos[iReel3]);						//~[~ʒu
					    fprintf(fp, " ");
					    pPict = &pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[iReel3], iReel3)];
					    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pPict->iColor]);
					      fprintf(fp, "%s", pPict->pName);							//~[~G
					    fprintf(fp, "</font>");
					  fprintf(fp, "</td>");
					  /* euɂāc */
					  fprintf(fp, "<td>");
					    for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					    	if(iHitCd) { fprintf(fp, " "); }
					    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_HkmCnt_Color[pStpCtl3->aHkmCnt[iHitCd]]]);
					    	  fprintf(fp, "%d", pStpCtl3->aHkmCnt[iHitCd]);					//
					    	fprintf(fp, "</font>");
					    }
					  fprintf(fp, "</td>");
					fprintf(fp, "</tr>\n");
				}
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	~eXg
 *--------------------------------------------------------------------------*/
/* ~eXgsB
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildStpTst(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, iOrder1, iOrder2, iOrder3, aStopPos[3];
	ST_Slot_StpTst* pStpTst;
	const ST_Slot_StpCtl1* pStpCtl1;
	const ST_Slot_StpCtl2* pStpCtl2;
	const ST_Slot_StpCtl3* pStpCtl3;
	const ST_Slot_HitChk3* pHitChk3;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						/* 1[~f[^2[~f[^3[~f[^̉ԍ擾B */
						iOrder1 = iOrder % 3;	/* 0,1,2,0,1,2 */
						iOrder2 = iOrder;	/* 0,1,2,3,4,5 */
						iOrder3 = iOrder;	/* 0,1,2,3,4,5 */
						/* 1~[̈i[B */
						pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder1][aPictPos[iReel1]];
						pStpTst->aHkmCnt[iHitCd][iReel1] = pStpCtl1->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel1] > 4) { DIE(); }
						aStopPos[iReel1] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpTst->aHkmCnt[iHitCd][iReel1]);
						/* 2~[̈i[B */
						pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder2][aStopPos[iReel1]][aPictPos[iReel2]];
						pStpTst->aHkmCnt[iHitCd][iReel2] = pStpCtl2->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel2] > 4) { DIE(); }
						aStopPos[iReel2] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpTst->aHkmCnt[iHitCd][iReel2]);
						/* 3~[̈i[B */
						pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder3][aStopPos[iReel1]][aStopPos[iReel2]][aPictPos[iReel3]];
						pStpTst->aHkmCnt[iHitCd][iReel3] = pStpCtl3->aHkmCnt[iHitCd];
						if(pStpTst->aHkmCnt[iHitCd][iReel3] > 4) { DIE(); }
						aStopPos[iReel3] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpTst->aHkmCnt[iHitCd][iReel3]);
						/* 3[ܔf[^擾 */
						pHitChk3 = &pBuilder->TBL_HitChk3[aStopPos[0]][aStopPos[1]][aStopPos[2]];
						/* Dx擾B */
						pStpTst->aPriority[iHitCd] = pHitChk3->aPriority[iHitCd];
						if(!pStpTst->aPriority[iHitCd]) { DIE(); }
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ~eXǧʂHTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintStpTst(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd;
	const ST_Slot_StpTst* pStpTst;
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		fprintf(fp, "<table>\n");
		fprintf(fp, "<caption>%s[%d]</caption>\n", "TBL_StpTst", iOrder);
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					fprintf(fp, "<tr>");
					  fprintf(fp, "<td>%2d %2d %2d</td>", aPictPos[iReel1],					//1~[̉ʒu
					                                      aPictPos[iReel2],					//2~[̉ʒu
					                                      aPictPos[iReel3]);				//3~[̉ʒu
					  /* euɂāc */
					  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
					  	fprintf(fp, "<td>");
					  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[0]);
					  	    fprintf(fp, "%d %d %d", pStpTst->aHkmCnt[iHitCd][iReel1],			//1~[̈
					  	                            pStpTst->aHkmCnt[iHitCd][iReel2],			//2~[̈
					  	                            pStpTst->aHkmCnt[iHitCd][iReel3]);			//3~[̈
					  	  fprintf(fp, "</font>");
					  	  fprintf(fp, " ");
					  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[1]);
					  	    fprintf(fp, "%d", pStpTst->aPriority[iHitCd]);				//Dx
					  	  fprintf(fp, "</font>");
					  	fprintf(fp, "</td>");
					  }
					fprintf(fp, "</tr>\n");
				}
			}
		}
		fprintf(fp, "</table>\n");
	}
}
/*--------------------------------------------------------------------------*
 *	GgeXg
 *--------------------------------------------------------------------------*/
/* GgeXgsB
 * [in]
 *	pBuilder	XybNf[^r_
 * [out]
 *	
 */
static void Slot_Spec_BuildCmbTst(ST_Slot_Spec_Builder* pBuilder) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int aPictPos[3], iOrder, iReel1, iReel2, iReel3, iHitCd, iHitFlg, iLine, nStpCntSum, aStopPos[3];
	ST_Slot_CmbTst* pCmbTst;
	const ST_Slot_StpTst* pStpTst;
	const ST_Slot_HitChk3* pHitChk3;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	/* [̊eGʒuɂāc */
	for(aPictPos[0] = 0; aPictPos[0] < 21; aPictPos[0]++) {
		/* [̊eGʒuɂāc */
		for(aPictPos[1] = 0; aPictPos[1] < 21; aPictPos[1]++) {
			/* E[̊eGʒuɂāc */
			for(aPictPos[2] = 0; aPictPos[2] < 21; aPictPos[2]++) {
				/* Ggԍ擾B */
				iHitFlg = Slot_Spec_FindHitFlg(pBuilder,
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[0], 0),
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[1], 1),
					Slot_GetReelPict(pInfo->TBL_Reel, aPictPos[2], 2));
				/* GgZB */
				pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];
				pCmbTst->nCmbCnt++;
			}
		}
	}
	/* eɂāc */
	for(iOrder = 0; iOrder < 6; iOrder++) {
		iReel1 = Slot_GetOrderReel(iOrder, 0); /* 1~[ */
		iReel2 = Slot_GetOrderReel(iOrder, 1); /* 2~[ */
		iReel3 = Slot_GetOrderReel(iOrder, 2); /* 3~[ */
		/* 1~[̊eʒuɂāc */
		for(aPictPos[iReel1] = 0; aPictPos[iReel1] < 21; aPictPos[iReel1]++) {
			/* 2~[̊eʒuɂāc */
			for(aPictPos[iReel2] = 0; aPictPos[iReel2] < 21; aPictPos[iReel2]++) {
				/* 3~[̊eʒuɂāc */
				for(aPictPos[iReel3] = 0; aPictPos[iReel3] < 21; aPictPos[iReel3]++) {
					pStpTst = &pBuilder->TBL_StpTst[iOrder][aPictPos[iReel1]][aPictPos[iReel2]][aPictPos[iReel3]];
					/* euɂāc */
					for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
						/* 1~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel1] > 4) { DIE(); }
						aStopPos[iReel1] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel1], pStpTst->aHkmCnt[iHitCd][iReel1]);
						/* 2~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel2] > 4) { DIE(); }
						aStopPos[iReel2] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel2], pStpTst->aHkmCnt[iHitCd][iReel2]);
						/* 3~[̒~ʒu擾B */
						if(pStpTst->aHkmCnt[iHitCd][iReel3] > 4) { DIE(); }
						aStopPos[iReel3] = Slot_Spec_GetPictPos_Hkm(aPictPos[iReel3], pStpTst->aHkmCnt[iHitCd][iReel3]);
						/* 3[ܔf[^擾 */
						pHitChk3 = &pBuilder->TBL_HitChk3[aStopPos[0]][aStopPos[1]][aStopPos[2]];
						/* eCɂāc */
						for(iLine = 0; iLine < 5; iLine++) {
							/* Gg\񐔂𑝂₷B */
							if((unsigned)pHitChk3->iHitFlg[iLine] >= (unsigned)pInfo->SIZE_HitFlg) { DIE(); }
							pCmbTst = &pBuilder->TBL_CmbTst[pHitChk3->iHitFlg[iLine]];
							pCmbTst->aStpCnt[iHitCd][iLine]++;
						}
					}
				}
			}
		}
	}
	/* eGgɂāc */
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];	/* Gg */
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];		/* Gg\ */
		/* euɂāc */
		for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
			/* eCɂāc */
			nStpCntSum = 0;			/* Gg\񐔂̍v */
			for(iLine = 0; iLine < 5; iLine++) {
				/* Gg\񐔂̍vZB */
				nStpCntSum += pCmbTst->aStpCnt[iHitCd][iLine];
			}
			/* ̏uŁÅGg\Ȃ΁c */
			if(nStpCntSum) {
				/* ̏uɁÅGg܂܂Ȃ΁c */
				if(pHitFlg->aPriority[iHitCd]) {
					pCmbTst->aResult[iHitCd] = 0;	/*  */
				/* ̏uɁÅGg܂܂ȂȂ΁c */
				} else {
					pCmbTst->aResult[iHitCd] = 1;	/* G[:uɊ܂܂Ȃ̂ɕ\ꂽ */
					fprintf(stderr, "###Slot_BuildCmbTst: uԍ%d,Ggԍ%dɂāuG[:uɊ܂܂Ȃ̂ɕ\ꂽv܂B\n", iHitCd, iHitFlg);
				}
			/* ̏uŁÅGg\ȂȂ΁c */
			} else {
				/* ̏uɁÅGg܂܂Ȃ΁c */
				if(pHitFlg->aPriority[iHitCd]) {
					pCmbTst->aResult[iHitCd] = 2;	/* x:uɊ܂܂̂ɕ\Ȃ */
					if(iHitCd != (pInfo->SIZE_HitCd-1)/*S*/) { /* uSȂ΁Aɂ͏uɊGg͒`Ȃ̂ŁAx\ȂB\Ă\ȂAx\B */
						fprintf(stderr, "###Slot_BuildCmbTst: uԍ%d,Ggԍ%dɂāux:uɊ܂܂̂ɕ\Ȃv܂B\n", iHitCd, iHitFlg);
					}
				/* ̏uɁÅGg܂܂ȂȂ΁c */
				} else {
					pCmbTst->aResult[iHitCd] = 0;	/*  */
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* GgeXǧʂHTMLo͂B
 * [in]
 *	pBuilder	XybNf[^r_
 *	fp		o̓Xg[
 * [out]
 *	
 */
static void Slot_Spec_PrintCmbTst(ST_Slot_Spec_Builder* pBuilder, FILE* fp) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iHitFlg, iHitCd, iReel, iLine, aStpCntSum[5/*iLine*/], nCmbCntSum = 0;	/* o̗L鏬̊Gg̍v */
	const ST_Slot_CmbTst* pCmbTst;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	fprintf(fp, "<table>\n");
	fprintf(fp, "<caption>%s</caption>\n", "TBL_CmbTst");
	/* wb_\B */
	fprintf(fp, "<tr>");
	  fprintf(fp, "<th></th>");
	  fprintf(fp, "<th></th>");
	  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
	  	fprintf(fp, "<th>");
	  	  fprintf(fp, "%2d", iHitCd);											//uԍ
	  	  fprintf(fp, " ");
	  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_HitCd[iHitCd].iColor]);
	  	    fprintf(fp, "%s",  pInfo->TBL_HitCd[iHitCd].pName);								//u
	  	  fprintf(fp, "</font>");
	  	fprintf(fp, "</th>");
	  }
	  fprintf(fp, "<th align=center>v</th>");
	fprintf(fp, "</tr>");
	/* eGgɂāc */
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pCmbTst = &pBuilder->TBL_CmbTst[iHitFlg];
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fp, "<tr>");
		  fprintf(fp, "<td>");
		    fprintf(fp, "%2d", iHitFlg);										//Ggԍ
		    for(iReel = 0; iReel < 3; iReel++) {
		    	fprintf(fp, " ");
		    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pInfo->TBL_Pict[pHitFlg->aPict[iReel]].iColor]);
		    	  fprintf(fp, "%s", pInfo->TBL_Pict[pHitFlg->aPict[iReel]].pName);					//Gg
		    	fprintf(fp, "</font>");
		    }
		    fprintf(fp, " ");
		    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitFlg->nPay ? 7 : 0]);
		      fprintf(fp, "%2d", pHitFlg->nPay);									//o
		    fprintf(fp, "</font>");
		  fprintf(fp, "</td>");
		  //Gg\B
		  fprintf(fp, "<td>");
		    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pHitFlg->nPay ? 7 : 0]);
		      fprintf(fp, "%4d", pCmbTst->nCmbCnt);									//Gg
		      if(pHitFlg->nPay) { nCmbCntSum += pCmbTst->nCmbCnt; }		/* o̗L鏬̊Gg̍vZB */
		    fprintf(fp, "</font>");
		  fprintf(fp, "</td>");
		  /* Gg\񐔂̍vNAB */
		  memset(aStpCntSum, 0, sizeof aStpCntSum);
		  /* euɂāc */
		  for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		  	fprintf(fp, "<td>");
		  	  fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[TBL_Slot_Spec_Result_Color[pCmbTst->aResult[iHitCd]]]);
		  	    fprintf(fp, "%s", TBL_Slot_Spec_Result_Mark[pCmbTst->aResult[iHitCd]]);				//
		  	  fprintf(fp, "</font>");
		  	  /* eCɂāc */
		  	  for(iLine = 0; iLine < 5; iLine++) {
		  	  	fprintf(fp, " ");
		  	  	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[pCmbTst->aStpCnt[iHitCd][iLine] ? 7 : 0]);
		  	  	  fprintf(fp, "%5d", pCmbTst->aStpCnt[iHitCd][iLine]);						//Gg\
		  	  	fprintf(fp, "</font>");
		  	  	aStpCntSum[iLine] += pCmbTst->aStpCnt[iHitCd][iLine];	/* Gg\񐔂̍vZB */
		  	  }
		  	fprintf(fp, "</td>");
		  }
		  /* Gg\񐔂̍v\B */
		  fprintf(fp, "<td>");
		    for(iLine = 0; iLine < 5; iLine++) {
		    	if(iLine) { fprintf(fp, " "); }
		    	fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[aStpCntSum[iLine] ? 7 : 0]);
		    	  fprintf(fp, "%6d", aStpCntSum[iLine]);								//Gg\񐔂̍v
		    	fprintf(fp, "</font>");
		    }
		  fprintf(fp, "</td>");
		fprintf(fp, "</tr>\n");
	}
	/* Gg̍v\B
	 * uVZ@̔Fyь^̌蓙ɊւK ʕ\5 񓷎VZ@ɌWZp̋Ki(1)\ɊւKivv:
	 * BB̊Gg킹
	 * EBB̕o360ȉ(CTڗL)̏ꍇABB̊GgA(21^3)/(2/1500)ȉł邱ƁBAő12ʂB		(@ɂ͊֌W)
	 * EBB̕o360(CTږ)̏ꍇABB̊GgA(21^3)/(1/1500)ȉł邱ƁBAő 6ʂB		(@ɂ͊֌W)
	 * RB&JAC̊Gg킹
	 * EBBڗL̏ꍇARB̊GgA(21^3)*(1/500)ȉł邱ƁBAő18ʂB					(@ɂ͊֌W)
	 * @BBږ̏ꍇARB̊GgA(21^3)*(3/500)ȉł邱ƁBAő55ʂB					(@ɂ͊֌W)
	 * ERBJACINL̏ꍇAJACIN̊GgA(21^3)/(10/500)ȉł邱ƁBAő185ʂB				(@ɂ͊֌W)
	 * CT̊Gg킹
	 * ECT̊Ggɂ́AB
	 * ̊Gg
	 * Eo̗L鏬̊GgA(21^3)/(11/100),,(21^3)/(40/100)ȉł邱ƁBAŏ1019,ő3704ʂB	̓_eXg
	 * EvC̊Gg킹ɂ́AB
	 */
	fprintf(fp, "<tr>");
	  fprintf(fp, "<td align=center>1019v3704</td>");
	  fprintf(fp, "<td>");
	    fprintf(fp, "<font color=%s>", TBL_Slot_Spec_Color[((nCmbCntSum >= 1019) && (nCmbCntSum <= 3704)) ? 7 : 1]);
	      fprintf(fp, "%4d", nCmbCntSum);											//o̗L鏬̊Gg̍v
	    fprintf(fp, "</font>");
	  fprintf(fp, "</td>");
	  fprintf(fp, "<td colspan=%d></td>", pInfo->SIZE_HitCd+1);
	fprintf(fp, "</tr>\n");
	fprintf(fp, "</table>\n");
}
/*--------------------------------------------------------------------------*
 *	f[^쐬
 *--------------------------------------------------------------------------*/
static void Slot_Spec_BuildData(ST_Slot_Spec_Builder* pBuilder) {
	static const struct {
		const char* HtmlFileName;
		void (*pfnBuild)(ST_Slot_Spec_Builder* pBuilder);
		void (*pfnPrint)(ST_Slot_Spec_Builder* pBuilder, FILE* fp);
	} tbl[]={
		/* f[^쐬 */
		{"HitChk3.html",&Slot_Spec_BuildHitChk3,&Slot_Spec_PrintHitChk3},	//3[ܔ
		{"HitChk2.html",&Slot_Spec_BuildHitChk2,&Slot_Spec_PrintHitChk2},	//2[ܗ\
		{"HitChk1.html",&Slot_Spec_BuildHitChk1,&Slot_Spec_PrintHitChk1},	//1[ܗ\
		/* f[^쐬 */
		{"StpCtl1.html",&Slot_Spec_BuildStpCtl1,&Slot_Spec_PrintStpCtl1},	//1[~
		{"StpCtl2.html",&Slot_Spec_BuildStpCtl2,&Slot_Spec_PrintStpCtl2},	//2[~
		{"StpCtl3.html",&Slot_Spec_BuildStpCtl3,&Slot_Spec_PrintStpCtl3},	//3[~
		/* eXg */
		{"StpTst.html",&Slot_Spec_BuildStpTst,&Slot_Spec_PrintStpTst},		//~eXg
		{"CmbTst.html",&Slot_Spec_BuildCmbTst,&Slot_Spec_PrintCmbTst},		//GgeXg
	};
	FILE* fp;
	int i;
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		fp = fopen(tbl[i].HtmlFileName, "w");
		if(!fp) { DIE(); }
		/* f[^쐬Ef[^쐬EeXg */
		(*tbl[i].pfnBuild)(pBuilder);
		/* HTMLwb_o */
		fprintf(fp, "<html>\n");
		fprintf(fp, "<head>\n");
		fprintf(fp, "  <style type=\"text/css\">\n");
		fprintf(fp, "    *{font-family:\"MS Mincho\";font-size:12px}\n");
		fprintf(fp, "    *{white-space:pre}\n");
		fprintf(fp, "    body{color:white;background-color:black}\n");
		fprintf(fp, "    table,caption,th,td{border-width:1px;border-style:solid;border-collapse:collapse}\n");
		fprintf(fp, "  </style>\n");
		fprintf(fp, "</head>\n");
		fprintf(fp, "<body>\n");
		/* HTML{fBo */
		(*tbl[i].pfnPrint)(pBuilder, fp);
		/* HTMLtb^o */
		fprintf(fp, "</body>\n");
		fprintf(fp, "</html>\n");
		fclose(fp);
	}
	/* HTMLCfNXy[Wo */
	fp = fopen("index.html", "w");
	if(!fp) { DIE(); }
	fprintf(fp, "<html>\n");
	fprintf(fp, "<body>\n");
	fprintf(fp, "<table>\n");
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		struct stat st;
		if(stat(tbl[i].HtmlFileName, &st)) { DIE(); }
		fprintf(fp, "<tr><td><a href=\"%s\">%s</td><td align=right>%d</td></tr>\n", tbl[i].HtmlFileName, tbl[i].HtmlFileName, (int)st.st_size);
	}
	fprintf(fp, "</table>\n");
	fprintf(fp, "</body>\n");
	fprintf(fp, "</html>\n");
	fclose(fp);
}
/*--------------------------------------------------------------------------*
 *	f[^o
 *--------------------------------------------------------------------------*/
/* G */
static void Slot_Spec_PrintData_Pict(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_Pict* pPict;
	int iPict;
	for(iPict = 0; iPict < pInfo->SIZE_Pict; iPict++) {
		pPict = &pInfo->TBL_Pict[iPict];
		fprintf(fpH, "#define Pict_%s %2d//%s\n",
			pPict->pSym, iPict, pPict->pName);
	}
	fprintf(fpH, "#define Pict_Size %d\n", pInfo->SIZE_Pict);
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_Pict_Name[Pict_Size]={\n");
	for(iPict = 0; iPict < pInfo->SIZE_Pict; iPict++) {
		pPict = &pInfo->TBL_Pict[iPict];
		fprintf(fpC, "\"%s\",//%2d %s\n",
			pPict->pName,
			iPict, pPict->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_Pict_Name[Pict_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* [z */
static void Slot_Spec_PrintData_Reel(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	int iPictPos;
	fprintf(fpH, "#define Reel_CT %d\n", pInfo->CT_Reel);
	//
	fprintf(fpC, "const unsigned short TBL_Reel[21]={\n");
	for(iPictPos = 0; iPictPos < 21; iPictPos++) {
		fprintf(fpC, "%2d<<0|%2d<<4|%2d<<8,//%2d %s %s %s\n",
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 0),
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 1),
			Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 2),
			iPictPos,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 0)].pName,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 1)].pName,
			pInfo->TBL_Pict[Slot_GetReelPict(pInfo->TBL_Reel, iPictPos, 2)].pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const unsigned short TBL_Reel[21];\n");
}
/*--------------------------------------------------------------------------*/
/* u */
static void Slot_Spec_PrintData_HitCd(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitCd* pHitCd;
	int iHitCd;
	fprintf(fpC, "const unsigned short TBL_HitCd[HitCd_Size][6]={\n");
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		fprintf(fpH, "#define HitCd_%s %2d//%s\n",
			pHitCd->pSym, iHitCd, pHitCd->pName);
		fprintf(fpC, "{%5d,%5d,%5d,%5d,%5d,%5d},//%2d %s %s\n",
			pHitCd->aWeight[0], pHitCd->aWeight[1], pHitCd->aWeight[2], pHitCd->aWeight[3], pHitCd->aWeight[4], pHitCd->aWeight[5],
			iHitCd, pHitCd->pSym, pHitCd->pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "#define HitCd_Size %d\n", pInfo->SIZE_HitCd);
	fprintf(fpH, "extern const unsigned short TBL_HitCd[HitCd_Size][6];\n");
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_HitCd_Name[HitCd_Size]={\n");
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		fprintf(fpC, "\"%s\",//%2d %s\n",
			pHitCd->pName,
			iHitCd, pHitCd->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_HitCd_Name[HitCd_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* Gg */
static void Slot_Spec_PrintData_HitFlg(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitFlg* pHitFlg;
	int iHitFlg, nNameLen = strlen(pInfo->TBL_Pict[0].pName);
	fprintf(fpC, "const unsigned short TBL_HitFlg[HitFlg_Size]={\n");
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fpH, "#define HitFlg_%s %2d//%s\n",
			pHitFlg->pSym, iHitFlg, pHitFlg->pName);
		fprintf(fpC, "%2d|%2d<<4|%2d<<8|%2d<<12,//%2d %s %s %-*s %-*s %-*s\n",
			pHitFlg->aPict[0],pHitFlg->aPict[1],pHitFlg->aPict[2],pHitFlg->nPay,
			iHitFlg, pHitFlg->pSym, pHitFlg->pName,
			nNameLen,pHitFlg->aPict[0]?pInfo->TBL_Pict[pHitFlg->aPict[0]].pName:"-",
			nNameLen,pHitFlg->aPict[1]?pInfo->TBL_Pict[pHitFlg->aPict[1]].pName:"-",
			nNameLen,pHitFlg->aPict[2]?pInfo->TBL_Pict[pHitFlg->aPict[2]].pName:"-");

	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "#define HitFlg_Size %d\n", pInfo->SIZE_HitFlg);
	fprintf(fpH, "extern const unsigned short TBL_HitFlg[HitFlg_Size];\n");
	//
	fprintf(fpC, "#ifdef  USE_NAME\n");
	fprintf(fpH, "#ifdef  USE_NAME\n");
	fprintf(fpC, "const char* const TBL_HitFlg_Name[HitFlg_Size]={\n");
	for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
		pHitFlg = &pInfo->TBL_HitFlg[iHitFlg];
		fprintf(fpC, "\"%s\",//%2d %s\n",
			pHitFlg->pName,
			iHitFlg, pHitFlg->pSym);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const char* const TBL_HitFlg_Name[HitFlg_Size];\n");
	fprintf(fpC, "#endif//USE_NAME\n");
	fprintf(fpH, "#endif//USE_NAME\n");
}
/*--------------------------------------------------------------------------*/
/* uˊGg */
static void Slot_Spec_PrintData_HitCd_HitFlg(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	const ST_Slot_Spec_HitCd* pHitCd;
	int iHitCd, iHitFlg, x;
	fprintf(fpC, "const unsigned char TBL_HitCd_HitFlg[HitCd_Size][(HitFlg_Size+7)/8]={\n");
	for(iHitCd = 0; iHitCd < pInfo->SIZE_HitCd; iHitCd++) {
		pHitCd = &pInfo->TBL_HitCd[iHitCd];
		x = 0;
		fprintf(fpC, "{");
		for(iHitFlg = 0; iHitFlg < pInfo->SIZE_HitFlg; iHitFlg++) {
			if(pInfo->TBL_HitFlg[iHitFlg].aPriority[iHitCd]) { x |= (1<<(iHitFlg&7)); }
			if(((iHitFlg&7) == 7) || (iHitFlg == (pInfo->SIZE_HitFlg-1))) {
				fprintf(fpC, "%3d", x);
				x = 0;
				if(iHitFlg != (pInfo->SIZE_HitFlg-1)) { fprintf(fpC, ","); }
			}
		}
		fprintf(fpC, "},//%2d %s %s\n",
			iHitCd, pHitCd->pSym, pHitCd->pName);
	}
	fprintf(fpC, "};\n");
	fprintf(fpH, "extern const unsigned char TBL_HitCd_HitFlg[HitCd_Size][(HitFlg_Size+7)/8];\n");
}
/*--------------------------------------------------------------------------*/
/* ~ */
static int Slot_Spec_PrintData_fnGetStpCtl1(void* pParam, int iHitCd, int iReel1, int iPushPos1) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl1* pStpCtl1;
	int iOrder = iReel1;
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl1   )) { DIE(); }
	if((unsigned)iPushPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl1[0])) { DIE(); }
	pStpCtl1 = &pBuilder->TBL_StpCtl1[iOrder][iPushPos1];
	if((unsigned)pStpCtl1->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl1->aHkmCnt[iHitCd];
}
static int Slot_Spec_PrintData_fnGetStpCtl2(void* pParam, int iHitCd, int iReel1, int iReel2, int iStopPos1, int iPushPos2) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl2* pStpCtl2;
	int iOrder = Slot_FindOrder(iReel1, iReel2);
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl2      )) { DIE(); }
	if((unsigned)iStopPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl2[0]   )) { DIE(); }
	if((unsigned)iPushPos2 >= ARRAY_SIZE(pBuilder->TBL_StpCtl2[0][0])) { DIE(); }
	pStpCtl2 = &pBuilder->TBL_StpCtl2[iOrder][iStopPos1][iPushPos2];
	if((unsigned)pStpCtl2->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl2->aHkmCnt[iHitCd];
}
static int Slot_Spec_PrintData_fnGetStpCtl3(void* pParam, int iHitCd, int iReel1, int iReel2, int iReel3, int iStopPos1, int iStopPos2, int iPushPos3) {
	ST_Slot_Spec_Builder* pBuilder = pParam;
	const ST_Slot_StpCtl3* pStpCtl3;
	int iOrder = Slot_FindOrder(iReel1, iReel2);
	if((unsigned)iOrder    >= ARRAY_SIZE(pBuilder->TBL_StpCtl3         )) { DIE(); }
	if((unsigned)iStopPos1 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0]      )) { DIE(); }
	if((unsigned)iStopPos2 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0][0]   )) { DIE(); }
	if((unsigned)iPushPos3 >= ARRAY_SIZE(pBuilder->TBL_StpCtl3[0][0][0])) { DIE(); }
	pStpCtl3 = &pBuilder->TBL_StpCtl3[iOrder][iStopPos1][iStopPos2][iPushPos3];
	if((unsigned)pStpCtl3->aHkmCnt[iHitCd] > 4) { DIE(); }
	return pStpCtl3->aHkmCnt[iHitCd];
}
static void Slot_Spec_PrintData_StpCtl(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC) {
	const ST_Slot_SpecInfo* pInfo = pBuilder->pInfo;
	ST_Slot_StpCtl_BuilderInfo stBuilderInfo;
	ST_Slot_StpCtl* pStpCtl;
	/* ~f[^r_ݒ肷B */
	memset(&stBuilderInfo, 0, sizeof stBuilderInfo);
	stBuilderInfo.HitCd_Size   = pInfo->SIZE_HitCd;
	stBuilderInfo.pParam       = pBuilder;
	stBuilderInfo.fnGetStpCtl1 = &Slot_Spec_PrintData_fnGetStpCtl1;
	stBuilderInfo.fnGetStpCtl2 = &Slot_Spec_PrintData_fnGetStpCtl2;
	stBuilderInfo.fnGetStpCtl3 = &Slot_Spec_PrintData_fnGetStpCtl3;
	/* ~f[^쐬B */
	pStpCtl = Slot_BuildStpCtl(&stBuilderInfo);
	/* ~f[^o͂B */
	Slot_PrintStpCtl(pStpCtl, fpH, fpC);
	/* ~f[^JB */
	free(pStpCtl);
}
/*--------------------------------------------------------------------------*/
static void Slot_Spec_PrintData(ST_Slot_Spec_Builder* pBuilder) {
	static const struct {
		void (*pfnPrint)(ST_Slot_Spec_Builder* pBuilder, FILE* fpH, FILE* fpC);
	} tbl[]={
		{&Slot_Spec_PrintData_Pict},		//G
		{&Slot_Spec_PrintData_Reel},		//[z
		{&Slot_Spec_PrintData_HitCd},		//u
		{&Slot_Spec_PrintData_HitFlg},		//Gg
		{&Slot_Spec_PrintData_HitCd_HitFlg},	//uˊGg
		{&Slot_Spec_PrintData_StpCtl},		//~
	};
	FILE *fpH, *fpC;
	int i;
	if(!(fpH = fopen("SlotData.h", "w"))) { DIE(); }
	if(!(fpC = fopen("SlotData.c", "w"))) { DIE(); }
	fprintf(fpC, "#include <clip.h>\n");
	fprintf(fpC, "#include \"SlotData.h\"\n");
	fprintf(fpH, "#ifndef __SLOTDATA_H__\n");
	fprintf(fpH, "#define __SLOTDATA_H__\n");
	for(i = 0; i < ARRAY_SIZE(tbl); i++) {
		(*tbl[i].pfnPrint)(pBuilder, fpH, fpC);
	}
	fprintf(fpH, "#endif//__SLOTDATA_H__\n");
	fclose(fpH);
	fclose(fpC);
}
/*--------------------------------------------------------------------------*
 *	O[o֐
 *--------------------------------------------------------------------------*/
void Slot_MakeSpec(const ST_Slot_SpecInfo* pInfo) {
	ST_Slot_Spec_Builder* pBuilder;
	/* XybNB */
	if((pInfo->SIZE_Pict   < 1) || (pInfo->SIZE_Pict   >  10)) { DIE(); }
	if(                   (unsigned)pInfo->CT_Reel     >   2 ) { DIE(); }
	if((pInfo->SIZE_HitCd  < 1) || (pInfo->SIZE_HitCd  >  64)) { DIE(); }
	if((pInfo->SIZE_HitFlg < 1) || (pInfo->SIZE_HitFlg > 256)) { DIE(); }
	/* XybNf[^r_̃mۂB */
	pBuilder = calloc(1, sizeof(ST_Slot_Spec_Builder));
	if(!pBuilder) { DIE(); }
	/* XybNi[B */
	pBuilder->pInfo = pInfo;
	/* f[^쐬 */
	Slot_Spec_BuildData(pBuilder);
	/* f[^o */
	Slot_Spec_PrintData(pBuilder);
	/* XybNf[^r_̃JB */
	free(pBuilder);
}
#endif//WIN32	//PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
