/*
 *	clipncs.h
 *
 *	Ȑ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Tue Sep 22 12:42:29 JST 2009 Naoyuki Sawa
 *	- VK쐬B
 *	* Sat Sep 26 16:40:28 JST 2009 Naoyuki Sawa
 *	- ferguson_coons_interpolate()ACRS_interpolate()ǉ܂B
 *	- ANCS(R3XvC)ł͂ȂȂ̂ŁA{̓W["clipncs.h"ςׂȂ̂łA
 *	  ̃hLg炱̃W[QƂĂӏ̂h߁Â܂܂Ƃ邱Ƃɂ܂B
 *	* Sun Oct 04 22:59:17 JST 2009 Naoyuki Sawa
 *	- NCS\̃f[^o͂c[Atool/NcsEdit쐬܂B
 *	  {W[ɂ͕ύXL܂B
 */
#ifndef __CLIP_NCS_H__
#define __CLIP_NCS_H__

/****************************************************************************
 *	R3XvC(NCS : Natural cubic spline)
 ****************************************************************************/

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
typedef struct _NCS_SEG {
	float t;	/* + 0,4: Ԃ̊Jn */
	float a;	/* + 4,4: ԌW(t^3) */
	float b;	/* + 8,4: ԌW(t^2) */
	float c;	/* +12,4: ԌW(t^1) */
	float d;	/* +16,4: ԌW(t^0) */
} NCS_SEG;		/* =20 */

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
typedef struct _NCS {
	int n_seg;			/* +0,4  : Ԑ */
	NCS_SEG seg[0/*n_seg*/];	/* +4,20N: Ԃ̔z */
} NCS;					/* =4+20N */

/*--------------------------------------------------------------------------*/

/* NCSԌW쐬܂B
 * [in]
 *	t		̔zBł邱ƁB
 *	t_stride	̗vfԋB[oCg]
 *	p		W̔zB
 *	p_stride	W̗vfԋB[oCg]
 *	n		ƍW̔z̗vfB1ȏł邱ƁB
 * [out]
 *	߂l		쐬NCSԌWւ̃|C^B
 * [note]
 *	* R3XvC̎Akeep/R3XvC.7zɕۑ܂B
 *	  {֐́Aq̎̃ASYɏ]āA܂B
 *
 *	* 쐬NCS\̂̒ɁAtpւ̃|C^QƂ͊i[܂B
 *	  ԂɕKvȏ́AׂāANCS\̂̒ɍ\z܂B
 *	  {֐ԂAĂяóAtp̓ej󂵂Ă\܂B
 *
 *	* ȉɁAgp܂B
 *
 *	- <1> tp\̂ɂ܂Ƃ߁At_stridep_strideɓlw肷@:
 *
 *		const struct {
 *			float t;
 *			vec2f p;
 *		} node[] = {
 *			{ 1.0f, {  20.0f, 20.0f } },
 *			{ 2.5f, { 100.0f, 40.0f } },
 *			{ 3.0f, {  70.0f, 70.0f } },
 *			{ 5.0f, {  40.0f, 10.0f } },
 *
 *		};
 *		void sample1() {
 *			NCS* ncs_x = NCS_new(&node[0].t,   sizeof node[0],
 *			                     &node[0].p.x, sizeof node[0],
 *			                     ARRAY_SIZE(node));
 *			NCS* ncs_y = NCS_new(&node[0].t,   sizeof node[0],
 *			                     &node[0].p.y, sizeof node[0],
 *			                     ARRAY_SIZE(node));
 *			float t;
 *			for(t = 0.0f; t <= 6.0f; t += 0.01f) {
 *				float x = NCS_interpolate(ncs_x, t);
 *				float y = NCS_interpolate(ncs_y, t);
 *				render_point(&render, x, y, 3);
 *			}
 *			NCS_free(ncs_x);
 *			NCS_free(ncs_y);
 *		}
 *
 *	- <2> tpʂ̔zƂAt_stridep_strideɕʂ̒lw肷@:
 *
 *		const float T[] = { 1.0f, 2.5f, 3.0f, 5.0f };
 *		const vec2f P[] = {
 *			{  20.0f, 20.0f },
 *			{ 100.0f, 40.0f },
 *			{  70.0f, 70.0f },
 *			{  40.0f, 10.0f },
 *		};
 *		void sample2() {
 *			NCS* ncs_x = NCS_new(&T[0],   sizeof T[0],
 *			                     &P[0].x, sizeof P[0],
 *			                     ARRAY_SIZE(T));
 *			NCS* ncs_y = NCS_new(&T[0],   sizeof T[0],
 *			                     &P[0].y, sizeof P[0],
 *			                     ARRAY_SIZE(T));
 *			float t;
 *			for(t = 0.0f; t <= 6.0f; t += 0.01f) {
 *				float x = NCS_interpolate(ncs_x, t);
 *				float y = NCS_interpolate(ncs_y, t);
 *				render_point(&render, x, y, 3);
 *			}
 *			NCS_free(ncs_x);
 *			NCS_free(ncs_y);
 *		}
 */
NCS* NCS_new(const float t[/*n*/], int t_stride, const float p[/*n*/], int p_stride, int n);

/* NCSԌWJ܂B
 * [in]
 *	self		NCSԌWւ̃|C^B
 */
void NCS_free(NCS* self);

/* NCSԂsW擾܂B
 * [in]
 *	self		NCSԌWւ̃|C^B
 *	t		B
 *			NCS_new()Ɏw肵̔źAŏ̎AŌ̎߂ł\܂B
 * [out]
 *	߂l		WB
 */
float NCS_interpolate(NCS* self, float t);

/****************************************************************************
 *	Ferguson/Coons(t@[K\/N[Y)Ȑ
 ****************************************************************************/

/* Ferguson/CoonsȐԂsW擾܂B
 * [in]
 *	p0		n_WB
 *	p1		I_WB
 *	v0		n_̐ڐxNgB
 *	v1		I_̐ڐxNgB
 *	t		B
 *			0.0n_A1.0I_ɑ܂B
 *			0.0A1.0߂̎w肷邱Ƃ\łB
 * [out]
 *	߂l		WB
 * [note]
 *	* ȉɁAgp܂B
 *
 *		const vec2f p0 = {  40.0f, 30.0f };
 *		const vec2f p1 = {  80.0f, 70.0f };
 *		const vec2f v0 = {  30.0f, 40.0f };
 *		const vec2f v1 = { -20.0f, 30.0f };
 *		void sample() {
 *			float t;
 *			for(t = -1.0f; t <= 2.0f; t += 0.01f) {
 *				float x = ferguson_coons_interpolate(p0.x, p1.x, v0.x, v1.x, t);
 *				float y = ferguson_coons_interpolate(p0.y, p1.y, v0.y, v1.y, t);
 *				render_point(&render, x, y, 3);
 *			}
 *		}
 */
float ferguson_coons_interpolate(float p0, float p1, float v0, float v1, float t);

/****************************************************************************
 *	Lbg}XvC(CRS : Catmull-Rom spline)
 ****************************************************************************/

/* Catmull-RomXvCԂsW擾܂B
 * [in]
 *	p,p_stride,n	NCS_new()̈gpƓłBNCS_new()̃RgQƂĂB
 *	t		B
 *			0.0ŏ̐ߓ_A(n-1)Ō̐ߓ_ɑ܂B
 *			0.0A(n-1)߂̎w肷邱Ƃ\łB
 * [out]
 *	߂l		WB
 * [note]
 *	* ȉɁAgp܂B
 *
 *		const vec2f P[] = {
 *			{  20.0f, 20.0f },
 *			{ 100.0f, 40.0f },
 *			{  70.0f, 70.0f },
 *			{  40.0f, 10.0f },
 *		};
 *		void sample() {
 *			float t;
 *			for(t = -1.0f; t <= 4.0f; t += 0.01f) {
 *				float x = CRS_interpolate(&P[0].x, sizeof P[0], ARRAY_SIZE(P), t);
 *				float y = CRS_interpolate(&P[0].y, sizeof P[0], ARRAY_SIZE(P), t);
 *				render_point(&render, x, y, 3);
 *			}
 *		}
 */
float CRS_interpolate(const float* p, int p_stride, int n, float t);

#endif /*__CLIP_NCS_H__*/
