
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		LOT_draw_column
LOT_draw_column:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := rndval
LOT_draw_column_LOOP:
		sub		%r13, 1			;// %r13 := column_size--
		jrlt		LOT_draw_column_MISS	;// if(column_size < 0) return -1
		;//
		ld.uh		%r10, [%r12]+		;// %r10 := hitval = *column++
		ld.uh		%r11, [%r12]+		;// %r11 := weight = *column++
;//{{
;//		add		%r11, 1			;// %r11 :=           (weight + 1)
;//		sub		%r14, %r11		;// %r14 := rndval -= (weight + 1)
;//		jrge		LOT_draw_column_LOOP	;// if(rndval <  0) return hitval
;//
		sub		%r14, %r11		;// %r14 := rndval -= (weight    )
		jrgt.d		LOT_draw_column_LOOP	;// if(rndval <= 0) return hitval
		sub		%r14, 1			;// %r14 := rndval -= (         1)	*delay*
;//}}
		ret					;// return  hitval
LOT_draw_column_MISS:
		ret.d					;// return  -1
		ld.w		%r10, -1		;// %r10 := -1				*delay*

	
		.code
		.align		1
		.global		LOT_get_column_weight
LOT_get_column_weight:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := hitval_sel
LOT_get_column_weight_LOOP:
		sub		%r13, 1				;// %r13 := column_size--
		jrlt		LOT_get_column_weight_MISS	;// if(column_size < 0) return 0
		;//
		ld.uh		%r11, [%r12]+			;// %r11 := hitval = *column++
		ld.uh		%r10, [%r12]+			;// %r10 := weight = *column++
		cmp		%r11, %r14			;// if(hitval == hitval_sel)
		jrne		LOT_get_column_weight_LOOP
		ret.d						;//   return  (weight + 1)
		add		%r10, 1				;//   %r10 := (weight + 1)	*delay*
LOT_get_column_weight_MISS:
		ret.d						;// return  0
		ld.w		%r10, 0				;// %r10 := 0			*delay*

	
		.code
		.align		1
LOT_seek_and_call:
		;// %r12        := table
		;// %r13[15: 0] := id
		;// %r13[31:16] := skip
		;// %r14        := param
		;// %r15        := fn
		ld.uh		%r4, %r13		;// %r4  := id   = (unsigned short)(id_skip >>  0) /* 0`65535 */
		ld.w		%r5, %r13		;// %r5  := skip = (unsigned short)(id_skip >> 16) /* 0`65535 */
	srl	%r5,0x8		; 		xsrl		%r5, 16
	srl	%r5,0x8
		ld.uh		%r6, [%r12]+		;// %r6  := table_size = *table++
LOT_seek_and_call_LOOP:					;// for(;;) {
		sub		%r6, 1			;//   %r6  := table_size--
		jrlt		LOT_seek_and_call_DIE	;//   if(table_size < 0) { DIE() } /* f[^G[: I\̒ɁAw肳ꂽidI񂪁A(skip+1)ȏoȂB */
		ld.uh		%r9, [%r12]+		;//   %r9  := column_id   = *table++
		ld.uh		%r13, [%r12]+		;//   %r13 := column_size = *table++
		cmp		%r9, %r4		;//   if((column_id == id)
		jrne		3
		 sub		%r5, 1			;//   && (--skip < 0)) { break }
		 jrlt		LOT_seek_and_call_RET
		sla		%r13, 2			;//   %r13 :=          column_size * 4
		jp.d		LOT_seek_and_call_LOOP	;// }
		add		%r12, %r13		;//   %r12 := table += column_size * 4	*delay*
LOT_seek_and_call_RET:
		jp		%r15			;// return (*fn)(table, column_size, param)

	.code
	.align	2
__LC0:
	.ascii	"cliplot.$\000"
; NO_APP
	.code
	.align	1
LOT_seek_and_call_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x2		; 	xld.w	%r13,0x000000ad		; 173
	ld.w	%r13,0x2d
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP
	
		.code
		.align		1
		.global		LOT_draw_table
LOT_draw_table:
	ext	LOT_draw_column+0x0@h	; 		xld.w		%r15, LOT_draw_column
	ext	LOT_draw_column+0x0@m
	ld.w	%r15,LOT_draw_column+0x0@l
		jp		LOT_seek_and_call

	
		.code
		.align		1
		.global		LOT_get_table_weight
LOT_get_table_weight:
	ext	LOT_get_column_weight+0x0@h	; 		xld.w		%r15, LOT_get_column_weight
	ext	LOT_get_column_weight+0x0@m
	ld.w	%r15,LOT_get_column_weight+0x0@l
		jp		LOT_seek_and_call

	
		.code
		.align		1
		.global		LOT_get_table_column_id
LOT_get_table_column_id:
		ld.uh		%r15, [%r12]+			;// %r15 := table_size = *table++;
		cmp		%r15, %r13			;// if(table_size <= i_column) { DIE() }
		jrle		LOT_get_table_column_id_DIE
		ld.w		%r14, %r12			;// %r14 := column
		;// %r12 := table	I[0]wĂ
		;// %r13 := i_column
		;// %r14 := column	I[0]wĂ
LOT_get_table_column_id_LOOP1:
		sub		%r13, 1				;// while(--i_column >= 0) {
		jrlt		LOT_get_table_column_id_EXIT1
		add		%r14, 2				;//   %r14 :=                column++
		ld.uh		%r15, [%r14]+			;//   %r15 := column_size = *column++
		sla		%r15, 2				;//   %r15 :=                          (column_size * 4)
		jp.d		LOT_get_table_column_id_LOOP1	;// }
		add		%r14, %r15			;//   %r14 :=                column += (column_size * 4)	*delay*
LOT_get_table_column_id_EXIT1:
		ld.uh		%r10, [%r14]			;// %r10 := id = *column
		ld.w		%r11, 0				;// %r11 := skip = 0
		;// %r10 := id		I[i_column]column_id
		;// %r11 := skip
		;// %r12 := table	I[0]wĂ
		;// %r14 := column	I[i_column]wĂ
LOT_get_table_column_id_LOOP2:
		cmp		%r12, %r14			;// while(table != column) {
		jreq		LOT_get_table_column_id_EXIT2
		ld.uh		%r13, [%r12]+			;//   %r13 := column_id   = *table++
		ld.uh		%r15, [%r12]+			;//   %r15 := column_size = *table++
		cmp		%r13, %r10			;//   if(column_id == id) {
		jrne.d		LOT_get_table_column_id_SKIP
		 sla		%r15, 2				;//   %r15 :=                         (column_size * 4)		*delay*
	ext	0x400		; 		 xadd		%r11, %r11, 0x10000		;//     %r11 := skip += (1<<16)							u1ZŌ16rbgVtgorvu(1<<16)ZŌɂ̂܂orvꖽߐߖłBʓIȒI\łskip=0ł邱Ƃʂ邱Ƃ͏Ȃ̂Ő\ቺ͂قږł낤B
	add	%r11,0x0
LOT_get_table_column_id_SKIP:
		jp.d		LOT_get_table_column_id_LOOP2	;// }
		add		%r12, %r15			;//   %r12 :=                table += (column_size * 4)		*delay*
LOT_get_table_column_id_EXIT2:
		ret.d						;// return  id | skip
		or		%r10, %r11			;// %r10 := id | skip						*delay*

; NO_APP
	.align	1
LOT_get_table_column_id_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x4		; 	xld.w	%r13,0x0000011c		; 284
	ld.w	%r13,0x1c
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
