/*	
 *	cliplot.c
 *
 *	I
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Tue May 29 00:54:45 JST 2012 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Aug 03 00:18:29 JST 2013 Naoyuki Sawa
 *	- I\̃f[^\ύXAI̐ǉ܂B
 *	  LOT_draw_table()ɕsȒICfNXw肵AG[~悤ɂ܂B
 *	- tool/MkLotTbl.awk ύXAVf[^\ɉI\o͂悤ɂ܂B
 *	  AÂf[^\̒I\gp鎖͂܂B
 *	* Tue Jan 14 23:30:11 JST 2014 Naoyuki Sawa
 *	- I\̃f[^\ύXAIidǉ܂B
 *	  LOT_draw_table()̎dlύXAICfNXłȂidƃXLbv񐔂Ŏw肷悤ɂ܂B
 *	- tool/MkLotTbl.awk ύXAVf[^\ɉI\o͂悤ɂ܂B
 *	  AÂf[^\̒I\gp鎖͂܂B
 *	* Fri Jan 31 01:01:32 JST 2014 Naoyuki Sawa
 *	- LOT_get_column_weight()LOT_get_table_weight()ǉ܂B
 *	* Fri Feb 28 01:16:14 JST 2014 Naoyuki Sawa
 *	- LOT_get_table_size()LOT_get_table_column_id()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	I
 ****************************************************************************/

#ifndef PIECE
int LOT_draw_column(const unsigned short* column, int column_size, int rndval) {
	int hitval, weight;
	for(;;) {
		/* ȈI[ɓBA-1Ԃ܂B */
		if(--column_size < 0) { return -1; }
		/*  Il   擾܂B */
		hitval = *column++;
		/* (dݒl-1)擾܂B */
		weight = *column++;
		/* ldݒlA0ɂȂ瓖IłB */
		if((rndval -= (weight + 1)) < 0) { return hitval; }
	}
}
#else /*PIECE*/
int LOT_draw_column(const unsigned short* column, int column_size, int rndval);
asm("
		.code
		.align		1
		.global		LOT_draw_column
LOT_draw_column:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := rndval
LOT_draw_column_LOOP:
		sub		%r13, 1			;// %r13 := column_size--
		jrlt		LOT_draw_column_MISS	;// if(column_size < 0) return -1
		;//
		ld.uh		%r10, [%r12]+		;// %r10 := hitval = *column++
		ld.uh		%r11, [%r12]+		;// %r11 := weight = *column++
;//{{
;//		add		%r11, 1			;// %r11 :=           (weight + 1)
;//		sub		%r14, %r11		;// %r14 := rndval -= (weight + 1)
;//		jrge		LOT_draw_column_LOOP	;// if(rndval <  0) return hitval
;//
		sub		%r14, %r11		;// %r14 := rndval -= (weight    )
		jrgt.d		LOT_draw_column_LOOP	;// if(rndval <= 0) return hitval
		sub		%r14, 1			;// %r14 := rndval -= (         1)	*delay*
;//}}
		ret					;// return  hitval
LOT_draw_column_MISS:
		ret.d					;// return  -1
		ld.w		%r10, -1		;// %r10 := -1				*delay*
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int LOT_get_column_weight(const unsigned short* column, int column_size, int hitval_sel) {
	int hitval, weight;
	for(;;) {
		/* ȈI[ɓBA0Ԃ܂B */
		if(--column_size < 0) { return 0; }
		/*  Il   擾܂B */
		hitval = *column++;
		/* (dݒl-1)擾܂B */
		weight = *column++;
		/* IlvAdݒl(1`65536)Ԃ܂B */
		if(hitval == hitval_sel) { return (weight + 1); }
	}
}
#else /*PIECE*/
int LOT_get_column_weight(const unsigned short* column, int column_size, int hitval_sel);
asm("
		.code
		.align		1
		.global		LOT_get_column_weight
LOT_get_column_weight:
		;// %r12 := column
		;// %r13 := column_size
		;// %r14 := hitval_sel
LOT_get_column_weight_LOOP:
		sub		%r13, 1				;// %r13 := column_size--
		jrlt		LOT_get_column_weight_MISS	;// if(column_size < 0) return 0
		;//
		ld.uh		%r11, [%r12]+			;// %r11 := hitval = *column++
		ld.uh		%r10, [%r12]+			;// %r10 := weight = *column++
		cmp		%r11, %r14			;// if(hitval == hitval_sel)
		jrne		LOT_get_column_weight_LOOP
		ret.d						;//   return  (weight + 1)
		add		%r10, 1				;//   %r10 := (weight + 1)	*delay*
LOT_get_column_weight_MISS:
		ret.d						;// return  0
		ld.w		%r10, 0				;// %r10 := 0			*delay*
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
static int LOT_seek_and_call(const unsigned short* table, int id_skip, int param, int (*fn)(const unsigned short* column, int column_size, int param)) {
	int id, skip, table_size, column_id, column_size;
	/* IidƃXLbv񐔂𕪗܂B */
	id   = (unsigned short)(id_skip >>  0); /* 0`65535 */
	skip = (unsigned short)(id_skip >> 16); /* 0`65535 */
	/* I\̗񐔂擾܂B */
	table_size = *table++;
	for(;;) {
		/* I\̍ŏI𒴂ĂAG[~܂B */
		if(--table_size < 0) { DIE(); } /* f[^G[: I\̒ɁAw肳ꂽidI񂪁A(skip+1)ȏoȂB */
		/* Iid擾܂B */
		column_id   = *table++;
		/* I̗vf擾܂B */
		column_size = *table++;
		/* w肳ꂽidI񂪌AXLbv񐔂炵0ɂȂA֐s܂B */
		if((column_id == id) && (--skip < 0)) { return (*fn)(table, column_size, param); }
		/* IXLbv܂B */
		table += column_size * 2/*{hitval,weight}*/;
	}
}
#else /*PIECE*/
/*static*/ int LOT_seek_and_call(const unsigned short* table, int id_skip, int param, int (*fn)(const unsigned short* column, int column_size, int param));
asm("
		.code
		.align		1
LOT_seek_and_call:
		;// %r12        := table
		;// %r13[15: 0] := id
		;// %r13[31:16] := skip
		;// %r14        := param
		;// %r15        := fn
		ld.uh		%r4, %r13		;// %r4  := id   = (unsigned short)(id_skip >>  0) /* 0`65535 */
		ld.w		%r5, %r13		;// %r5  := skip = (unsigned short)(id_skip >> 16) /* 0`65535 */
		xsrl		%r5, 16
		ld.uh		%r6, [%r12]+		;// %r6  := table_size = *table++
LOT_seek_and_call_LOOP:					;// for(;;) {
		sub		%r6, 1			;//   %r6  := table_size--
		jrlt		LOT_seek_and_call_DIE	;//   if(table_size < 0) { DIE() } /* f[^G[: I\̒ɁAw肳ꂽidI񂪁A(skip+1)ȏoȂB */
		ld.uh		%r9, [%r12]+		;//   %r9  := column_id   = *table++
		ld.uh		%r13, [%r12]+		;//   %r13 := column_size = *table++
		cmp		%r9, %r4		;//   if((column_id == id)
		jrne		3
		 sub		%r5, 1			;//   && (--skip < 0)) { break }
		 jrlt		LOT_seek_and_call_RET
		sla		%r13, 2			;//   %r13 :=          column_size * 4
		jp.d		LOT_seek_and_call_LOOP	;// }
		add		%r12, %r13		;//   %r12 := table += column_size * 4	*delay*
LOT_seek_and_call_RET:
		jp		%r15			;// return (*fn)(table, column_size, param)
");
static void __attribute__((noreturn,unused)) LOT_seek_and_call_DIE() { DIE(); /*ICfNXs*/ } /*asmubNQ*/
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int LOT_draw_table(const unsigned short* table, int id_skip, int rndval) {
	return LOT_seek_and_call(table, id_skip, rndval, LOT_draw_column);
}
#else /*PIECE*/
int LOT_draw_table(const unsigned short* table, int id, int rndval);
asm("
		.code
		.align		1
		.global		LOT_draw_table
LOT_draw_table:
		xld.w		%r15, LOT_draw_column
		jp		LOT_seek_and_call
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int LOT_get_table_weight(const unsigned short* table, int id_skip, int hitval_sel) {
	return LOT_seek_and_call(table, id_skip, hitval_sel, LOT_get_column_weight);
}
#else /*PIECE*/
int LOT_get_table_weight(const unsigned short* table, int id_skip, int hitval_sel);
asm("
		.code
		.align		1
		.global		LOT_get_table_weight
LOT_get_table_weight:
		xld.w		%r15, LOT_get_column_weight
		jp		LOT_seek_and_call
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int LOT_get_table_column_id(const unsigned short* table, int i_column) {
	int table_size, column_size, id, skip;
	const unsigned short* column;
	/* I\̗񐔂擾܂B */
	table_size = *table++;
	/* I\̗񐔂AȈ(0`)ȉłꍇ́AG[~܂B */
	if(table_size <= i_column) { DIE(); }
	/* (i_column)Ԗڂ̒ÍAid擾܂B */
	column = table;
	while(--i_column >= 0) {
		               column++; /*column_id*/
		column_size = *column++;
		               column += column_size * 2/*{hitval,weight}*/;
	}
	id = *column;
	/* (i_column)Ԗڂ̒IOɁA(i_column)Ԗڂ̒IƓid̒I񂪑݂ꍇA̗񐔂XLbv񐔂ƂĐ܂B */
	skip = 0;
	while(table != column) {
		           if(*table++ == id) { skip += (1<<16); } /*column_id*/
		column_size = *table++;
		               table += column_size * 2/*{hitval,weight}*/;
	}
	/* IidƁAXLbv񐔂Ԃ܂B */
	return id | skip;
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		LOT_get_table_column_id
LOT_get_table_column_id:
		ld.uh		%r15, [%r12]+			;// %r15 := table_size = *table++;
		cmp		%r15, %r13			;// if(table_size <= i_column) { DIE() }
		jrle		LOT_get_table_column_id_DIE
		ld.w		%r14, %r12			;// %r14 := column
		;// %r12 := table	I[0]wĂ
		;// %r13 := i_column
		;// %r14 := column	I[0]wĂ
LOT_get_table_column_id_LOOP1:
		sub		%r13, 1				;// while(--i_column >= 0) {
		jrlt		LOT_get_table_column_id_EXIT1
		add		%r14, 2				;//   %r14 :=                column++
		ld.uh		%r15, [%r14]+			;//   %r15 := column_size = *column++
		sla		%r15, 2				;//   %r15 :=                          (column_size * 4)
		jp.d		LOT_get_table_column_id_LOOP1	;// }
		add		%r14, %r15			;//   %r14 :=                column += (column_size * 4)	*delay*
LOT_get_table_column_id_EXIT1:
		ld.uh		%r10, [%r14]			;// %r10 := id = *column
		ld.w		%r11, 0				;// %r11 := skip = 0
		;// %r10 := id		I[i_column]column_id
		;// %r11 := skip
		;// %r12 := table	I[0]wĂ
		;// %r14 := column	I[i_column]wĂ
LOT_get_table_column_id_LOOP2:
		cmp		%r12, %r14			;// while(table != column) {
		jreq		LOT_get_table_column_id_EXIT2
		ld.uh		%r13, [%r12]+			;//   %r13 := column_id   = *table++
		ld.uh		%r15, [%r12]+			;//   %r15 := column_size = *table++
		cmp		%r13, %r10			;//   if(column_id == id) {
		jrne.d		LOT_get_table_column_id_SKIP
		 sla		%r15, 2				;//   %r15 :=                         (column_size * 4)		*delay*
		 xadd		%r11, %r11, 0x10000		;//     %r11 := skip += (1<<16)							u1ZŌ16rbgVtgorvu(1<<16)ZŌɂ̂܂orvꖽߐߖłBʓIȒI\łskip=0ł邱Ƃʂ邱Ƃ͏Ȃ̂Ő\ቺ͂قږł낤B
LOT_get_table_column_id_SKIP:
		jp.d		LOT_get_table_column_id_LOOP2	;// }
		add		%r12, %r15			;//   %r12 :=                table += (column_size * 4)		*delay*
LOT_get_table_column_id_EXIT2:
		ret.d						;// return  id | skip
		or		%r10, %r11			;// %r10 := id | skip						*delay*
");
static void __attribute__((noreturn,unused)) LOT_get_table_column_id_DIE() { DIE(); }
#endif/*PIECE*/
