/*	
 *	clipjkis.c
 *
 *	JKISS32[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2012 Naoyuki Sawa
 *
 *	* Thu Dec 06 17:08:54 JST 2012 Naoyuki Sawa
 *	- 1st [XB
 *	- JKISS32[̎Akeep/JKISS32[.7zɕۑ܂B
 */
#include "clip.h"

/****************************************************************************
 *	JKISS32[
 ****************************************************************************/

#ifndef PIECE
void JKISS32_init(JKISS32* self, unsigned s) {
	     self->x = rnd32(&s);			/* 0`0xFFFFFFFF */
	do { self->y = rnd32(&s); } while(!self->y);	/* 1`0xFFFFFFFF */
	     self->z = rnd32(&s) & 0x7FFFFFFF;		/* 0`0x7FFFFFFF */
//{{31rbg1rbg܂Ƃ߂Ĉ32rbgŏ
//	     self->w = rnd32(&s) & 0x7FFFFFFF;		/* 0`0x7FFFFFFF */
//	     self->c = rnd32(&s) & 1;			/* 0`1 */
//31rbg1rbg܂Ƃ߂Ĉ32rbgŏ
	     ((unsigned*)self)[3] = rnd32(&s);		/* w = 0`0x7FFFFFFF, c = 0`1 */
//}}31rbg1rbg܂Ƃ߂Ĉ32rbgŏ
}
#else /*PIECE*/
asm("
		.align		1
		.global		JKISS32_init
JKISS32_init:

		pushn		%r1
		xsub		%sp, %sp, 4
		;//
		ld.w		%r0, %r12		;// %r0   := self
		xld.w		%r1, rnd32		;// %r1   := rnd32
		xld.w		[%sp], %r13		;// [%sp] := s
		;//
		ld.w		%r12, %sp		;// %r12 :=           &s
		call		%r1			;// %r10 := r = rnd32(&s)
		ld.w		[%r0]+, %r10		;// self->x = r
		;//
		ld.w		%r12, %sp		;// do {
		 call		%r1			;//   %r12 :=           &s
		 cmp		%r10, 0			;//   %r10 := r = rnd32(&s)
		jreq		-3			;// } while(r == 0)
		ld.w		[%r0]+, %r10		;// self->y = r
		;//
		ld.w		%r12, %sp		;// %r12 :=           &s
		call		%r1			;// %r10 := r = rnd32(&s)
		sll		%r10, 1			;// %r10 := r <<= 1
		srl		%r10, 1			;// %r10 := r >>= 1
		ld.w		[%r0]+, %r10		;// self->z = r
		;//
		ld.w		%r12, %sp		;// %r12 :=           &s
		call		%r1			;// %r10 := r = rnd32(&s)
		ld.w		[%r0], %r10		;// self->w = r[30:0]
		;//					;// self->c = r[31]
		xadd		%sp, %sp, 4
		popn		%r1
		ret
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
//{{AZuՂ悤ɏύX
//unsigned JKISS32_next(JKISS32* self) {
//	unsigned t;
//	self->y ^= (self->y <<  5);
//	self->y ^= (self->y >>  7);
//	self->y ^= (self->y << 22);			/* 1`0xFFFFFFFF */
//	      t  =  self->z + self->w + self->c;	/* 0`0xFFFFFFFF */
//	self->z  =  self->w;				/* 0`0x7FFFFFFF */
//	self->c  = (t & 0x80000000) >> 31;		/* 0`1 */
//	self->w  = (t & 0x7FFFFFFF);			/* 0`0x7FFFFFFF */
//	self->x += 1411392427;				/* 0`0xFFFFFFFF */
//	return self->x + self->y + self->w;
//}
//AZuՂ悤ɏύX
unsigned JKISS32_next(JKISS32* self) {
	unsigned x = self->x;				/* 0`0xFFFFFFFF */
	unsigned y = self->y;				/* 1`0xFFFFFFFF */
	unsigned z = self->z;				/* 0`0x7FFFFFFF */
	unsigned w = self->w;				/* 0`0x7FFFFFFF */
	unsigned t = self->c + z + w;			/* 0`0xFFFFFFFF */
	x  += 1411392427;	self->x = x;		/* 0`0xFFFFFFFF */
	y  ^= (y <<  5);
	y  ^= (y >>  7);
	y  ^= (y << 22);	self->y = y;		/* 1`0xFFFFFFFF */
				self->z = w;		/* 0`0x7FFFFFFF */
	w   = (t <<  1) >> 1;	self->w = w;		/* 0`0x7FFFFFFF */
	t >>= 31;		self->c = t;		/* 0`1 */
	return x + y + w;
}
//}}AZuՂ悤ɏύX
#else /*PIECE*/
asm("
		.align		1
		.global		JKISS32_next
JKISS32_next:
		ld.w		%r10, [%r12]+		;// %r10       := x = self->x
		ld.w		%r11, [%r12]+		;// %r11       := y = self->y
		ld.w		%r13, [%r12]+		;// %r13       := z = self->z
		ld.w		%r14, [%r12]		;// %r14[30:0] := w = self->w
		;//					;// %r14[31]   := c = self->c
		sub		%r12, 12		;// %r12       := self
		;//
		add		%r14, %r14		;// %psr[C] := c
		srl		%r14, 1			;// %r14    := w
		adc		%r13, %r14		;// %r13    := t = z + w + c
		;//
		xadd		%r10, %r10, 1411392427	;// %r10 := x += 1411392427
		ld.w		[%r12]+, %r10		;// self->x = x
		;//
		ld.w		%r9, %r11		;// %r9  :=       y
		xsll		%r9, 5			;// %r9  :=      (y <<  5)
		xor		%r11, %r9		;// %r11 := y ^= (y <<  5)
		ld.w		%r9, %r11		;// %r9  :=       y
		xsrl		%r9, 7			;// %r9  :=      (y >>  7)
		xor		%r11, %r9		;// %r11 := y ^= (y >>  7)
		ld.w		%r9, %r11		;// %r9  :=       y
		xsll		%r9, 22			;// %r9  :=      (y << 22)
		xor		%r11, %r9		;// %r11 := y ^= (y << 22)
		ld.w		[%r12]+, %r11		;// self->y = y
		;//
		ld.w		[%r12]+, %r14		;// self->z = w
		;//
		ld.w		[%r12], %r13		;// self->w = t[30:0]
		;//					;// self->c = t[31]
		;//
		add		%r10, %r11		;// %r10 := x + y
		sll		%r13, 1			;// %r13 :=         self->w
		srl		%r13, 1
		ret.d
		add		%r10, %r13		;// %r10 := x + y + self->w	*delay*
");
#endif

