/*
 *	dfpck - FilePack [eBeB[
 *	Copyright (C) 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *
 *	* Mon May 13 11:51:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- 쐬JnB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

/* [NOTE]
 * * R}hC̃ChJ[hWJ邽߂ɁA
 *   [vWFNg̐ݒ]->[N]->[IuWFNg/CuW[]
 *   usetargv.objvǉĂ܂B
 */

#define VERSION		"20020514"
#define LIST_FMT	"%8d %s\n"

char arc_path[_MAX_PATH];
char arc_drive[_MAX_DRIVE];
char arc_dir[_MAX_DIR];
char arc_fname[_MAX_FNAME];
char arc_ext[_MAX_EXT];

/* fpkt@C`Ɋւ\ */
#define SIGNATURE	'FPAK'
#define FNAME_LEN	16
typedef struct _FILE_PAC_INFO {	/* pbN */
	unsigned long head;	/* VOl` */
	long famount;		/* t@C */
} FILE_PAC_INFO;
typedef struct _FILE_INFO {	/* t@C                         */
	char fname[FNAME_LEN];	/* t@C                           */
	unsigned long offset;	/* ItZbg(fpkt@C擪0Ƃ) */
	unsigned long size;	/* t@CTCY                       */
} FILE_INFO;

/* f[^Ǘp̍\ */
typedef struct _FILE_ITEM {
	char fname[FNAME_LEN];	/* t@C   */
	int size;		/* f[^TCY */
	char* data;		/* f[^       */
} FILE_ITEM;
int n_file_items;		/* ACe     */
FILE_ITEM* file_items;		/* ACeXg */

void cmd_list(int n_fnames, char* fnames[]);
void cmd_extract(int n_fnames, char* fnames[]);
void cmd_append(int n_fnames, char* fnames[]);
void cmd_create(int n_fnames, char* fnames[]);

FILE_ITEM* find(const char* fname);
void load();
void save();

void
err(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	abort();
}

void
usage(int err)
{
	fprintf(stderr, "dfpck - FilePack [eBeB[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2002 Naoyuki Sawa <nsawa@north.hokkai.net>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "g: dfpck <command> <archive[.fpk]> [filename...]\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "COMMAND:\n");
	fprintf(stderr, "	c	VɃt@C쐬܂B\n");
	fprintf(stderr, "	r	̏ɂɃt@Cǉ܂B\n");
	fprintf(stderr, "	t	̏ɂ̃t@Cꗗ\܂B\n");
	fprintf(stderr, "	x	̏ɂt@C𒊏o܂B\n");

	if(err) {
		abort();
	} else {
		exit(0);
	}
}

int
main(int argc, char* argv[])
{
	/* ŋNꂽAg\܂B */
	if(argc == 1) usage(0);

	/* ȂƂAR}hƏɃt@CKvłB */
	if(argc < 1 + 2) usage(1);

	/* Ƀt@C擾܂B */
	strcpy(arc_path, argv[2]);
	_splitpath(arc_path, arc_drive, arc_dir, arc_fname, arc_ext);
	if(strlen(arc_ext) == 0) {
		strcpy(arc_ext, ".fpk");
		_makepath(arc_path, arc_drive, arc_dir, arc_fname, arc_ext);
	}

	/* R}hɂ... */
	if(strcmp(argv[1], "c") == 0) {
		cmd_create(argc - 3, &argv[3]);
	} else if(strcmp(argv[1], "r") == 0) {
		cmd_append(argc - 3, &argv[3]);
	} else if(strcmp(argv[1], "t") == 0) {
		cmd_list(argc - 3, &argv[3]);
	} else if(strcmp(argv[1], "x") == 0) {
		cmd_extract(argc - 3, &argv[3]);
	} else {
		usage(1);
	}

	return 0;
}

void
cmd_list(int n_fnames, char* fnames[])
{
	int i;
	FILE_ITEM* item_pos;

	/* Ƀt@Cǂݍ݂܂B */
	load();

	if(n_fnames == 0) {
		/* St@CXg\܂B */
		for(i = 0, item_pos = file_items;
		    i < n_file_items;
		    i++, item_pos++) {
			/* t@C\܂B */
			printf(LIST_FMT, item_pos->size, item_pos->fname);
		}
	} else {
		/* w肳ꂽt@C̃Xg\܂B */
		for(i = 0; i < n_fnames; i++) {
			/* t@CT܂B */
			item_pos = find(fnames[i]);
			if(item_pos == NULL) err("%s t@C܂B", fnames[i]);
			/* t@C\܂B */
			printf(LIST_FMT, item_pos->size, item_pos->fname);
		}
	}
}

void
cmd_extract(int n_fnames, char* fnames[])
{
	int retval, i;
	FILE_ITEM* item_pos;
	FILE* fp;

	/* Ƀt@Cǂݍ݂܂B */
	load();

	if(n_fnames == 0) {
		/* St@C𒊏o܂B */
		for(i = 0, item_pos = file_items;
		    i < n_file_items;
		    i++, item_pos++) {
			/* t@C݂܂B */
			fp = fopen(item_pos->fname, "wb");
			if(fp == NULL) err("%s t@C쐬ł܂B", item_pos->fname);
			retval = fwrite(item_pos->data, 1, item_pos->size, fp);
			if(retval != item_pos->size) err("%s t@C߂܂B", item_pos->fname);
			fclose(fp);
		}
	} else {
		/* w肳ꂽt@C𒊏o܂B */
		for(i = 0; i < n_fnames; i++) {
			/* t@CT܂B */
			item_pos = find(fnames[i]);
			if(item_pos == NULL) err("%s t@C܂B", fnames[i]);
			/* t@C݂܂B */
			fp = fopen(item_pos->fname, "wb");
			if(fp == NULL) err("%s t@C쐬ł܂B", fnames[i]);
			retval = fwrite(item_pos->data, 1, item_pos->size, fp);
			if(retval != item_pos->size) err("%s t@C߂܂B", fnames[i]);
			fclose(fp);
		}
	}

}

void
cmd_append(int n_fnames, char* fnames[])
{
	/* Ƀt@Cǂݍ݂܂B */
	load();

	/* ́AVK쐬ƓłB */
	cmd_create(n_fnames, fnames);
}

void
cmd_create(int n_fnames, char* fnames[])
{
	int retval, i;
	FILE_ITEM* item_pos;
	char path[_MAX_PATH];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	FILE* fp;

	/* t@CǗe[ug܂B */
	file_items = (FILE_ITEM*)realloc(file_items, sizeof(FILE_ITEM) * (n_file_items + n_fnames));
	if(file_items == NULL) err("t@CǗe[ũsłB");
	/* ܂n_file_items͍XVȂI */

	/* w肳ꂽt@Cǂݍ݂܂B */
	for(i = 0, item_pos = file_items + n_file_items;
	    i < n_fnames;
	    i++, item_pos++) {
		/* t@Ci[܂B */
		_splitpath(fnames[i], NULL, NULL, fname, ext);
		_makepath(path, NULL, NULL, fname, ext);
		strlwr(path);
		if(strlen(path) > FNAME_LEN - 1) err("%s t@C܂B", fnames[i]);
		if(find(path) != NULL) err("%s t@CdĂ܂B", fnames[i]);
		strcpy(item_pos->fname, path);
		/* t@Cǂݍ݂܂B */
		fp = fopen(fnames[i], "rb");
		if(fp == NULL) err("%s t@CJ܂B", fnames[i]);
		retval = fseek(fp, 0, SEEK_END);
		if(retval != 0) err("%s t@C̃V[NG[łB", fnames[i]);
		item_pos->size = ftell(fp);
		rewind(fp);
		item_pos->data = (char*)malloc(item_pos->size);
		if(item_pos->data == NULL) err("%s t@Cǂݍނ߂̃słB", fnames[i]);
		retval = fread(item_pos->data, 1, item_pos->size, fp);
		if(retval != item_pos->size) err("%s t@Cǂݍ߂܂B", fnames[i]);
		fclose(fp);
	}

	/* n_file_itemsXVI */
	n_file_items += n_fnames;

	/* Ƀt@C݂܂B */
	save();
}

FILE_ITEM*
find(const char* fname)
{
	int i;
	FILE_ITEM* item_pos;

	for(i = 0, item_pos = file_items;
	    i < n_file_items;
	    i++, item_pos++) {
		if(strcmpi(item_pos->fname, fname) == 0) return item_pos;
	}

	return NULL;
}

void
load()
{
	int retval, i;
	FILE* fp;
	FILE_PAC_INFO pac;
	FILE_INFO *info, *info_pos;
	FILE_ITEM *item_pos;

	/* Ƀt@CJ܂B */
	fp = fopen(arc_path, "rb");
	if(fp == NULL) err("%s Ƀt@CJ܂B", arc_path);

	/* wb_ǂݍ݂܂B */
	retval = fread(&pac, 1, sizeof pac, fp);
	if(retval != sizeof pac) err("wb_ǂݍ߂܂B");
	if(pac.head != SIGNATURE) err("VOl`słB");
	if(pac.famount < 0) err("t@CsłB");
	n_file_items = pac.famount;

	/* t@Cǂݍ݂܂B */
	info = (FILE_INFO*)malloc(sizeof(FILE_INFO) * n_file_items);
	if(info == NULL) err("t@Cǂݍނ߂̃słB");
	retval = fread(info, 1, sizeof(FILE_INFO) * n_file_items, fp);
	if(retval != (int)(sizeof(FILE_INFO) * n_file_items)) err("t@C񂪓ǂݍ߂܂B");

	/* t@Cǂݍ݂܂B */
	file_items = (FILE_ITEM*)malloc(sizeof(FILE_ITEM) * n_file_items);
	if(file_items == NULL) err("t@CǗe[ũsłB");
	for(i = 0, info_pos = info, item_pos = file_items;
	    i < n_file_items;
	    i++, info_pos++, item_pos++) {
		if(memchr(info_pos->fname, '\0', FNAME_LEN) == NULL) err("t@CĂ܂B");
		strcpy(item_pos->fname, info_pos->fname);
		retval = fseek(fp, info_pos->offset, SEEK_SET);
		if(retval != 0) err("%s t@CʒuĂ܂B", info_pos->fname);
		item_pos->size =               info_pos->size;
		item_pos->data = (char*)malloc(info_pos->size);
		if(item_pos->data == NULL) err("%s t@Cǂݍނ߂̃słB", info_pos->fname);
		retval = fread(item_pos->data, 1, item_pos->size, fp);
		if(retval != item_pos->size) err("%s t@CTCYĂ܂B", info_pos->fname);
	}

	/* t@CJ܂B */
	free(info);

	/* Ƀt@C܂B */
	fclose(fp);
}

void
save()
{
	int retval, i, offset;
	FILE* fp;
	FILE_PAC_INFO pac;
	FILE_INFO *info, *info_pos;
	FILE_ITEM *item_pos;

	/* t@C̏ɕёւ܂B
	 * * FILE_ITEM̐擪ɒڃt@Ci[Ă̂ŁA
	 *   r֐ɂstrcmp()̂܂܎g܂B
	 */
	qsort(file_items, n_file_items, sizeof(FILE_ITEM), strcmp);

	/* Ƀt@C쐬܂B */
	fp = fopen(arc_path, "wb");
	if(fp == NULL) err("%s Ƀt@C쐬ł܂B", arc_path);

	/* wb_݂܂B */
	pac.head = SIGNATURE;
	pac.famount = n_file_items;
	retval = fwrite(&pac, 1, sizeof pac, fp);
	if(retval != sizeof pac) err("wb_߂܂B");

	/* t@C݂܂B */
	info = (FILE_INFO*)malloc(sizeof(FILE_INFO) * n_file_items);
	if(info == NULL) err("t@Cނ߂̃słB");
	offset = sizeof(FILE_PAC_INFO) + sizeof(FILE_INFO) * n_file_items;
	for(i = 0, info_pos = info, item_pos = file_items;
	    i < n_file_items;
	    i++, info_pos++, item_pos++) {
		strncpy(info_pos->fname, item_pos->fname, FNAME_LEN); /* ]'\0'Ŗ߂邽 */
		offset = offset + 3 & ~3; /* f[^Jnʒu4oCgE֐ */
		info_pos->offset = offset;
		info_pos->size = item_pos->size;
		offset += item_pos->size;
	}
	retval = fwrite(info, 1, sizeof(FILE_INFO) * n_file_items, fp);
	if(retval != (int)(sizeof(FILE_INFO) * n_file_items)) err("t@C񂪏߂܂B");

	/* t@Cǂݍ݂܂B */
	for(i = 0, info_pos = info, item_pos = file_items;
	    i < n_file_items;
	    i++, info_pos++, item_pos++) {
		retval = fseek(fp, info_pos->offset, SEEK_SET);
		if(retval != 0) err("%s t@C̃V[NG[łB", item_pos->fname);
		retval = fwrite(item_pos->data, 1, item_pos->size, fp);
		if(retval != item_pos->size) err("%s t@C߂܂B", item_pos->fname);
	}

	/* t@CJ܂B */
	free(info);

	/* Ƀt@C܂B */
	fclose(fp);
}
