/*
 *	main.c
 *
 *	P/ECE CLiP Library Wire Loader
 *
 *	ExportPieceClipWire - P/ECE CLiP Library 3D Object Exporter (Wire)
 *	o̓t@CǂݍށACLiPp[`̎ړĨvWFNgłB
 *	̃c[P̂ŗp邱Ƃ͖Ǝv܂B
 *	2006/07/28prύX
 *	XML`̃C[t[f[^AC`ɕϊc[Ƃėp邱Ƃɂ܂B
 *
 *	* Thu Jun 29 14:41:47 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Jul 28 00:16:53 JST 2006 Naoyuki Sawa
 *	- ܂ł́AXML`̃C[t[f[^̓ǂݍ݃eXgsvOłA
 *	  ̕ύXɂAC`ɕϊc[Ƃėp邱Ƃɂ܂B
 *	  P/ECEŁAXML`̃C[t[f[^̂܂܈ƁAȉ̂悤Ȗ肪܂B
 *	  EXMLt@C͑傫āAtbV𑽂B
 *	  EXMLt@CǂݍނɂExpatNKvACRAM𑽂B
 *	  E݂wire_load()̓t@C̓ǂݍ݂ɂΉĂȂ̂ŁA
 *	    pext@CŃAvP[V\邱ƂłȂB
 *	  ȏ̂悤Ȗ_邽߂ɁÁA{c[pXML`̃C[t[f[^
 *	  C`ɃRo[gApext@Cɒڊ܂߂邱Ƃɂ܂B
 *	  c[IȃvOł́Awire_load()ɂXMLt@C̓ǂݍ݂s܂B
 *	  (Ƃ΁A3DIuWFNgr[AȂ)
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

static void
out_data(const char* prefix, const char* path, const unsigned char* data, int size)
{
	char fname[_MAX_FNAME];
	int i;

	_splitpath(path, NULL, NULL, fname, NULL);
	strupr(fname);
	printf("const unsigned char %s_%s[] = {", prefix, fname);

	for(i = 0; i < size; i++) {
		if(!(i & 15)) {
			printf("\n");
		}
		printf("0x%02X,", data[i]);
	}

	printf("\n};\n");
}

/*****************************************************************************
 *	
 *****************************************************************************/

static int
get_size(const WIRE* w)
{
	int size = 0;
	//
	const vector* v;
	const WSEG* s;
	//
	int nv;
	int ns;
	//
	int iv;
	int is;

	size += sizeof(WIRE);
	nv = w->nv;
	ns = w->ns;
	w++;

	v = (vector*)w;
	for(iv = 0; iv < nv; iv++) {
		size += sizeof(vector);
		v++;
	}

	s = (WSEG*)v;
	for(is = 0; is < ns; is++) {
		size += sizeof(WSEG);
		s++;
	}

	return size;
}

/*****************************************************************************
 *	
 *****************************************************************************/

int
main(int argc, char* argv[])
{
	WIRE* w;

	if(argc != 1 + 1) {
		DIE();
	}
	w = wire_load(argv[1]);
	if(!w) {
		DIE();
	}
#if 0 /*{{2006/07/28*/
//	free(w);
//
//	printf("ǂݍ݃eXg͐ɏI܂B\n");
#else /*}}2006/07/28{{*/
	out_data("WIRE", argv[1], (unsigned char*)w, get_size(w));
	free(w);
#endif/*}}2006/07/28*/

	return 0;
}

