/*
 *	ExportMesh.cpp
 *
 *	P/ECE CLiP Library 3D Object Exporter
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Thu Jun 29 11:46:08 JST 2006 Naoyuki Sawa
 *	- bVGNX|[gʃt@Cɕ܂B
 *	* Wed Jul 26 06:27:42 JST 2006 Naoyuki Sawa
 *	- IvV_CAOɂāAg嗦Ɣ]wł悤AύX܂B
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

#define N_MATS_MAX	255	/* }eȀBꂮ炢Ώ[?() */

/*****************************************************************************
 *	
 *****************************************************************************/

/* {֐̒Ŋmۂ郊\[X͂܂B
 * t@CI[vƍƗpIuWFNg̊mۂƉ́AĂяo(MQExportFile())ōsĂ܂B
 * ]āA{֐ł̃G[́A\[X[NCɂɁA"return FALSE"ł܂B
 */
BOOL
DoExportMesh(FILE* fp, MQDocument doc, MQObject obj, struct _OPTION* option)
{
#if 0 /*{{MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
//	MQFileDialogInfo info;
#endif/*}}MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
	//
	int n_mats;				/* 0`N_MATS_MAX */
	int i_mat;
	static MQMaterial mats[N_MATS_MAX];	memset(mats, 0, sizeof mats);
	static MQColor mat_colors[N_MATS_MAX];	memset(mat_colors, 0, sizeof mat_colors);
	static int mat_brights[N_MATS_MAX];	memset(mat_brights, 0, sizeof mat_brights);
	static SIZE mat_texsizes[N_MATS_MAX];	memset(mat_texsizes, 0, sizeof mat_texsizes);
	//
	int n_objs;
	int i_obj;
	MQObject obj_tmp;
	//
	int n_vectors;				/* 0`255 (P/ECE CLiP Library Mesh̎dl) */
	int i_vector;
	static MQPoint vectors[255];		memset(vectors, 0, sizeof vectors);
	//
	int n_faces;				/* 0`255 (P/ECE CLiP Library Mesh̎dl) */
	int i_face;
	//
	int n_face_vertices;			/* 0 or 2 or 3 or 4 (MQObject::GetFacePointCount()̎dl) */
	int i_face_vertex;
	static int face_vertices[4];		memset(face_vertices, 0, sizeof face_vertices);
	static MQCoordinate face_coords[4];	memset(face_coords, 0, sizeof face_coords);
	//
	int n_coords;				/* 0`255 (P/ECE CLiP Library Mesh̎dl) */
	int i_coord;
	static POINT coords[255];		memset(coords, 0, sizeof coords);
	static unsigned char fvs_ic[255][4];	memset(fvs_ic, 0, sizeof fvs_ic);

#if 0 /*{{MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
//	/* WϊȂǂ̋@\t@C_CAO\܂B
//	 * * _CAOɂ́AuE𔽓]vuʕ𔽓]vƂ`FbN{bNXL܂A
//	 *   ̃`FbN{bNXύXĂMQFileDialogInfo\̂ɔfȂ悤łB
//	 *   ʂƂāAMQ_ExportAxis()ɂ`BꂸAo̓t@CɈႢ͗L܂B
//	 * - C^[lbgŌJẴvOCAl݂̓Ȃ̂ŁAԂdlłB
//	 *   ̂߂ɁuE𔽓]vuʕ𔽓]vƂ`FbN{bNXL̂AłB
//	 * - Ƃ낪AMetasequoia{̂́u3D Studio (*.3ds)vo͂ł́A̐ݒ肪f݂łB
//	 *   ǂāA`FbN{bNX̏Ԃ擾Ă̂ł傤?
//	 *   Metasequoia{̂̌ĂяoƁAOvOCƂł́AC^[tFCXႤ̂ł傤?
//	 * * MQFileDialogInfo.typéAɎĝsłB
//	 *   Plug-in SDK Tvłݒ肵ĂȂAƂ肠0̂܂܂ɂĂƂɂ܂B
//	 *   MQFileDialogInfo.softnameAɎĝsłB
//	 *   \tgEFÂ̖Ɉvꍇ̂݁uWvR{{bNXɔf܂AĂ܂Ӗ悤ȋC܂BBB
//	 */
//	memset(&info, 0, sizeof info);
//	info.dwSize = sizeof info;
//	info.axis_x = MQFILE_TYPE_RIGHT;
//	info.axis_y = MQFILE_TYPE_UP;
//	info.axis_z = MQFILE_TYPE_BACK;
//	MQ_ShowFileDialog("P/ECE CLiP Library Mesh Export", &info);
//	/* MQ_ShowFileDialog()ԂƁAscale,axis_x,axis_y,axis_zɕύXfĂ܂B */
#endif/*}}MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/

	/*{{o*/
	fprintf(fp, "<?xml version='1.0' ?>\n");
	/*}}o*/

	/* int MQDocument::GetMaterialCount()
	 *
	 * hLg̃}eA̐擾܂B
	 * ۂɑ݂}eAł͂Ȃzvf̑傫Ԃ̂ŁAMQDocument::DeleteMaterial()ɂNULLɂȂ̂Ƃē܂B
	 * mȐ𓾂ɂMQDocument::GetMaterial()ɂNULLȊÔ̂𐔂Kv܂B
	 * [out]
	 *	߂l		}eA̔zvfB
	 */
	n_mats = doc->GetMaterialCount();
	if(n_mats > N_MATS_MAX) { /* N_MATS_MAX𒲐Ă */
		MessageBox(MQ_GetWindowHandle(),
			"}eA܂B",
			APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
		return FALSE;
	}

	for(i_mat = 0; i_mat < n_mats; i_mat++) {

		/* MQMaterial MQDocument::GetMaterial(int material)
		 * 
		 * }eANXւ̃|C^擾܂B
		 * w肵CfNXɃ}eA݂ȂꍇNULLԂ܂B
		 * [in]
		 *	material	}eÃCfNXB
		 * [out]
		 *	߂l		}eANXB
		 */
		mats[i_mat] = doc->GetMaterial(i_mat);
		if(mats[i_mat]) {
			mat_colors[i_mat] = mats[i_mat]->GetColor();
			mat_brights[i_mat] = (int)(((mat_colors[i_mat].r * 0.30) +
						    (mat_colors[i_mat].g * 0.59) +
						    (mat_colors[i_mat].b * 0.11)) * 4);
			if(mat_brights[i_mat] < 1) {		// R G B 0.30R+0.59G+0.11B=?    *4=? c MetasequoiaP/ECE
				mat_brights[i_mat] = 3;		// 0 0 0                  =0.00 0.00 3          
			} else if(mat_brights[i_mat] < 2) {	// 0 0 1             0.11 =0.11 0.44 3          
				mat_brights[i_mat] = 2;		// 0 1 0       0.59       =0.59 2.36 1          ΁
			} else if(mat_brights[i_mat] < 3) {	// 0 1 1       0.59+ 0.11 =0.70 2.80 1      VA
				mat_brights[i_mat] = 1;		// 1 0 0 0.30+             0.30 1.20 2          ԁ
			} else {				// 1 0 1 0.30+       0.11 =0.41 1.64 2    }[^
				mat_brights[i_mat] = 0;		// 1 1 0 0.30+ 0.59       =0.89 3.56 0          
			}					// 1 1 1 0.30+ 0.59+ 0.11 =1.00 4.00 0          

			/* eNX`TCY擾܂B
			 * - eNX`̖}eAA݂Ȃ摜t@CQƂĂꍇ́A
			 *   MQDocument::FindMappingFile()A܂́AMQ_LoadImage()s͂łB
			 *   eNX`̃[h݂Ďsꍇ́Amat_texsizes[i_mat]={0,0}̂܂܂ƂA
			 *   eNX`̖}eAł邱ƂƂɂ܂B
			 */
			char filename[MAX_PATH]; /* ΃pX擾p */
			char path[MAX_PATH];     /* ΃pX擾p */
			mats[i_mat]->GetTextureName(filename, sizeof filename); /* eNX`ꍇ͋󕶎񂪕Ԃ܂ */
			if(doc->FindMappingFile(path, filename, MQMAPPING_TEXTURE)) {
				BITMAPINFOHEADER* header; /* SDKhLgɂ͏ĂȂǁABITMAPINFOHEADERԂdl݂ł */
				void* buffer;
				if(MQ_LoadImage(path, (void**)&header, (void**)&buffer, 0)) {
					mat_texsizes[i_mat].cx = header->biWidth;
					mat_texsizes[i_mat].cy = header->biHeight;
					LocalFree(header); /* 摜wb_͂sv */
					LocalFree(buffer); /* 摜f[^͎gȂ */
				}
			}
		}
	}

	/* int MQDocument::GetObjectCount()
	 *
	 * hLg̃IuWFNg̐擾܂B
	 * ۂɑ݂IuWFNgł͂Ȃzvf̑傫Ԃ̂ŁAMQDocument::DeleteObject()ɂNULLɂȂ̂Ƃē܂B
	 * mȐ𓾂ɂMQDocument::GetObject()ɂNULLȊÔ̂𐔂Kv܂B
	 * [out]
	 *	߂l		IuWFNg̔zvfB
	 */
	n_objs = doc->GetObjectCount();

	/* ƗpIuWFNgɁAׂẴIuWFNg܂B */
	for(i_obj = 0; i_obj < n_objs; i_obj++) {

		/* MQObject MQDocument::GetObject(int index)
		 *
		 * IuWFNgNXւ̃|C^擾܂B
		 * w肵CfNXɃIuWFNg݂ȂꍇNULLԂ܂B
		 * [in]
		 *	index		IuWFNg̃CfNXB
		 * [out]
		 *	߂l		IuWFNgNXB
		 */
		obj_tmp = doc->GetObject(i_obj);
		if(!obj_tmp) {
			continue; /* L蓾܂!! MQDocument::GetObjectCount()̃RgQ */
		}

		/* \̃IuWFNg͏o͂ȂƂɂ܂B */
		if(!obj_tmp->GetVisible()) {
			continue;
		}

		/* MQObject::Freeze()ɂeύX̂ŁAIuWFNg𕡐Ă܂B */
		obj_tmp = obj_tmp->Clone();

		/* Ȗʂ⋾ʂȂǂ̑t[YĊSɃ|S܂B */
		obj_tmp->Freeze(MQOBJECT_FREEZE_ALL);

		/* ƗpIuWFNgɍ܂B */
		obj->Merge(obj_tmp);

		/* void MQObject::DeleteThis()
		 *
		 * IuWFNgNXf[g()܂B
		 * ̊֐̓hLgɓo^ĂȂIuWFNgɂ̂ݗLŁAhLgɓo^ꂽIuWFNgłꍇMQDocement::DeleteObject()gpȂ΂Ȃ܂B
		 */
		obj_tmp->DeleteThis();
	}

	/* int MQObject::GetVertexCount()
	 *
	 * _̐擾܂B
	 * ۂɑ݂钸_ł͂Ȃzvf̑傫ł̂ŁAmȒ_𒲂ׂɂ͊e_ƂMQObject::GetVertexRefCount()0ȊOԂ邩ǂ𒲂ׂKv܂B
	 * [out]
	 *	߂l		_z̗vfB
	 */
	n_vectors = obj->GetVertexCount();
	if(n_vectors > 255) { /* P/ECE CLiP Library Mesh̎dl */
		MessageBox(MQ_GetWindowHandle(),
			"_W܂B",
			APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
		return FALSE;
	}

	/* int MQObject::GetFaceCount()
	 *
	 * ʐ擾܂B
	 * ۂɑ݂ʐł͂Ȃzvf̑傫ł̂ŁAmȖʐ𓾂ɂ͊eʂƂMQObject::GetFacePointCount()0ȊOԂ邩ǂ𒲂ׂKv܂B
	 * [out]
	 *	߂l		ʔz̗vfB
	 */
	n_faces = obj->GetFaceCount();
	if(n_faces > 255) { /* P/ECE CLiP Library Mesh̎dl */
		MessageBox(MQ_GetWindowHandle(),
			"tFCX܂B",
			APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
		return FALSE;
	}

	/* dȂeNX`Wz쐬܂B */
	n_coords = 0;
	for(i_face = 0; i_face < n_faces; i_face++) {

		/* int MQObject::GetFaceMaterial(int face)
		 *
		 * ʂɊ蓖Ăꂽ}eÃCfNX擾܂B
		 * CfNX̓IuWFNghLĝ̂ɂȂ܂B
		 * ǂ̃}eA蓖ĂĂȂuFʁv̏ꍇ-1Ԃ܂B
		 * [in]
		 *	face		ʂ̃CfNXB
		 * [out]
		 *	߂l		}eÃCfNXB
		 */
		i_mat = obj->GetFaceMaterial(i_face);

		if(i_mat >= 0 && mats[i_mat]) { /* FtFCX͏O */
			SIZE texsize = mat_texsizes[i_mat];
			if(texsize.cx && texsize.cy) { /* eNX`̖}eA͏O */

				/* int MQObject::GetFacePointCount(int face)
				 *
				 * w肵ʂɑ钸_̐擾܂B
				 * 0,2,3,4̂ꂩԂ܂B
				 * 0̏ꍇMQObject::DeleteFace()ɂɔjꑶ݂ĂȂƂ܂B
				 * [in]
				 *	face		ʂ̃CfNXB
				 * [out]
				 *	߂l		_
				 */
				n_face_vertices = obj->GetFacePointCount(i_face);
				if(n_face_vertices > 4) { /* L蓾Ȃ */
					MessageBox(MQ_GetWindowHandle(),
						"\ȂtFCX_łB",
						APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
					return FALSE;
				}

				/* void MQObject::GetFaceCoordinateArray(int face, MQCoordinate* uvarray)
				 *
				 * w肵ʂ̊e_UVlzƂĎ擾܂B
				 * uvarrayMQObject::GetFacePointCount()œ鐔ȏ̑傫złȂ΂Ȃ܂B
				 *
				 * [in]
				 *	face		ʂ̃CfNXB
				 *	uvarray		UVli[obt@B
				 */
				obj->GetFaceCoordinateArray(i_face, face_coords);

				/* ɓeNX`W΂̗pAoȂ΃eNX`Wzɉ܂B */
				for(i_face_vertex = 0; i_face_vertex < n_face_vertices; i_face_vertex++) {
					POINT coord;
					coord.x = (unsigned char)(face_coords[i_face_vertex].u * (texsize.cx - 1/*Metasequoia̓ObhWP/ECE̓sNZW*/));
					coord.y = (unsigned char)(face_coords[i_face_vertex].v * (texsize.cy - 1/*Metasequoia̓ObhWP/ECE̓sNZW*/));
					for(i_coord = 0; i_coord < n_coords; i_coord++) {
						if(coords[i_coord].x == coord.x &&
						   coords[i_coord].y == coord.y) {
							break;
						}
					}
					if(i_coord == n_coords) {     /* eNX`WȂ? */
						if(n_coords == 255) { /* ɃeNX`WɒBĂ? (P/ECE CLiP Library Mesh̎dl) */
							MessageBox(MQ_GetWindowHandle(),
								"eNX`W܂B",
								APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
							return FALSE;
						}
						coords[n_coords++] = coord;
					}
					fvs_ic[i_face][i_face_vertex] = i_coord; /* ̃tFCX_̃eNX`WCfNXL */
				}
			}
		}
	}

	/*{{o*/
	fprintf(fp, "<mesh nv='%d' nc='%d' nf='%d'>\n", n_vectors, n_coords, n_faces);
	/*}}o*/

	/* void MQObject::GetVertexArray(MQPoint* ptsarray);
	 *
	 * IuWFNĝׂĂ̒_̈ʒuzƂĈꊇ擾܂B
	 * ptsarray̔zvfMQObject::GetVertexCount()ŕԂ鐔ȏłȂ΂Ȃ܂B
	 * [in]
	 *	ptsarray	ʒuzB
	 */
	obj->GetVertexArray(vectors);

#if 0 /*{{2006/07/26*/
//#if 0 /*{{MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
////	/* void MQ_ImportAxis(MQFileDialogInfo* info, MQPoint* pts, int pts_count)
////	 * void MQ_ExportAxis(MQFileDialogInfo* info, MQPoint* pts, int pts_count)
////	 *
////	 * t@C_CAO̍Wf[^ɒ_ʒuϊ܂B
////	 * ͗pƏo͗płꂼقȂ܂B
////	 */
////	MQ_ExportAxis(&info, vectors, n_vectors);
//#else
//	/* * MQ_ExportAxis()́AZ]wƁAX܂Ŕ]Ă܂݂łB
//	 *   dl悭킩Ȃ̂ŁAOōWϊsAZ]sƂɂ܂B
//	 * * Metasequoia̕WIȃXP[͑傫̂ŁA1001ŏo͂邱Ƃɂ܂B
//	 *   ̕ΐAMQFileDialogInfo.scale̐ݒɑ܂B
//	 *   _CAOŕύX邱ƂłȂȂĂ܂܂AƂ肠ŒƂ܂B
//	 *   AJX^_CAOāAύXł悤ɂ悤Ǝv܂B(TODO:)
//	 */
//	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
//		vectors[i_vector].x =  vectors[i_vector].x / 100;
//		vectors[i_vector].y =  vectors[i_vector].y / 100;
//		vectors[i_vector].z = -vectors[i_vector].z / 100;
//	}
//#endif/*}}MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
#else /*}}2006/07/26{{*/
	/* * Wed Jul 26 06:27:42 JST 2006 Naoyuki Sawa
	 * - IvV_CAOɂāAg嗦Ɣ]wł悤AύX܂B
	 */
	double scale = option->scale * pow(10, option->exp);
	double scale_x = option->axis == 0 ? -scale : scale;
	double scale_y = option->axis == 1 ? -scale : scale;
	double scale_z = option->axis == 2 ? -scale : scale;
	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
		vectors[i_vector].x = (float)(vectors[i_vector].x * scale_x);
		vectors[i_vector].y = (float)(vectors[i_vector].y * scale_y);
		vectors[i_vector].z = (float)(vectors[i_vector].z * scale_z);
	}
#endif /*}}2006/07/26*/

	/*{{o*/
	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
		float x = vectors[i_vector].x;
		float y = vectors[i_vector].y;
		float z = vectors[i_vector].z;
		fprintf(fp, "\t<vector x='%d' y='%d' z='%d' /> <!-- %f %f %f -->\n", fld(x), fld(y), fld(z), x, y, z);
	}
	for(i_coord = 0; i_coord < n_coords; i_coord++) {
		POINT coord = coords[i_coord];
		fprintf(fp, "\t<tcoord s='%d' t='%d' />\n", coord.x, coord.y);
	}
	/*}}o*/

	for(i_face = 0; i_face < n_faces; i_face++) {

		/* int MQObject::GetFaceMaterial(int face)
		 *
		 * ʂɊ蓖Ăꂽ}eÃCfNX擾܂B
		 * CfNX̓IuWFNghLĝ̂ɂȂ܂B
		 * ǂ̃}eA蓖ĂĂȂuFʁv̏ꍇ-1Ԃ܂B
		 * [in]
		 *	face		ʂ̃CfNXB
		 * [out]
		 *	߂l		}eÃCfNXB
		 */
		i_mat = obj->GetFaceMaterial(i_face);

		/* int MQObject::GetFacePointCount(int face)
		 *
		 * w肵ʂɑ钸_̐擾܂B
		 * 0,2,3,4̂ꂩԂ܂B
		 * 0̏ꍇMQObject::DeleteFace()ɂɔjꑶ݂ĂȂƂ܂B
		 * [in]
		 *	face		ʂ̃CfNXB
		 * [out]
		 *	߂l		_
		 */
		n_face_vertices = obj->GetFacePointCount(i_face);
		if(n_face_vertices > 4) { /* L蓾Ȃ */
			MessageBox(MQ_GetWindowHandle(),
				"\ȂtFCX_łB",
				APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
			return FALSE;
		}

		/* void MQObject::GetFacePointArray(int face, int* vertex)
		 *
		 * w肵ʂ̒_CfNXzƂĎ擾܂B
		 * vertexMQObject::GetFacePointCount()œ鐔ȏ̑傫złȂ΂Ȃ܂B
		 *
		 * [in]
		 *	face		ʂ̃CfNXB
		 *	vertex		_CfNXi[obt@B
		 */
		obj->GetFacePointArray(i_face, face_vertices);

		/*{{o*/
		if(i_mat >= 0 && mats[i_mat]) {
			fprintf(fp, "\t<face nfv='%d' c='%d'> <!-- %f %f %f -->\n", n_face_vertices, mat_brights[i_mat], mat_colors[i_mat].r, mat_colors[i_mat].g, mat_colors[i_mat].b);
		} else {
			fprintf(fp, "\t<face nfv='%d' c='%d'> <!-- no-material -->\n", n_face_vertices, mat_brights[i_mat]);
		}
#if 0 /*{{MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
//		/* Metasequoia͉EWnŁÃtFCX\łB
//		 * P/ECE CLiP Library Mesh͍WnŁAẼtFCX\łB
//		 * MQ_ExportAxis()ɂAEWnWnϊ(Z])͍sĂ܂A聨Eϊ͍s܂B
//		 * ȉ̃[vŁAIɍ聨EϊsAo͂邱Ƃɂ܂B
//		 */
//		for(i_face_vertex = n_face_vertices - 1; i_face_vertex >= 0; i_face_vertex--) {
//			fprintf(fp, "\t\t<facevertex iv='%d' ic='%d' />\n", face_vertices[i_face_vertex], i_coord);
//		}
#else
		/* Iȍ聨EΐAAsvɂȂ܂B
		 * * ̖ubNɏRǵAԈĂ݂łB
		 *   Oq̒ʂAMQ_ExportAxis()́AZ]wƁAX܂Ŕ]Ă܂݂łB
		 *   񎲔]ƂȂ̂ŁÂ܂܂ɂȂĂ݂łB
		 *   ́AOZ]ŝŁAꎲ]ƂȂÂ܂܂̏ŉELqƂȂ܂B
		 *   ]āAIɍ聨EϊsKv͂܂B
		 */
		for(i_face_vertex = 0; i_face_vertex < n_face_vertices; i_face_vertex++) {
			fprintf(fp, "\t\t<facevertex iv='%d' ic='%d' />\n", face_vertices[i_face_vertex], fvs_ic[i_face][i_face_vertex]);
		}
#endif/*}}MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B*/
		fprintf(fp, "\t</face>\n");
		/*}}o*/
	}

	/*{{o*/
	fprintf(fp, "</mesh>\n");
	/*}}o*/

	return TRUE;
}

