;	
;	framstia.s
;
;	P/ECE STIC Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Wed May 18 20:00:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#define STIC_DEFINE_OFFSET
#include "clipstia.h"
#ifdef STIC_ASM

	.code
	.align	1

;****************************************************************************
;	
;****************************************************************************

;
;	void stic_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*96*/])
;
	.global	stic_reduce
stic_reduce:
	xld.w	%r10, 8				; z = 8
stic_reduce_DO_Z:				; do {
	;
	xld.w	%r11, 11-1			;   y = 11-1
stic_reduce_DO_Y:				;   do {
	;
	xld.w	%r14, 32			;     x = 32
stic_reduce_DO_X0:				;     do {
	;
	ld.ub	%r4, [%r13]+			;       %r4    =  src[0]
	ld.ub	%r5, [%r13]+			;       %r5    =  src[1]
	ld.ub	%r6, [%r13]+			;       %r6    =  src[2]
	ld.b	[%r12]+, %r4			;       dst[0] =  src[0]
	ld.b	[%r12]+, %r5			;       dst[1] =  src[1]
	ld.b	[%r12]+, %r6			;       dst[2] =  src[2]
	ld.ub	%r4, [%r13]+			;       %r4    =  src[3]
	ld.ub	%r5, [%r13]+			;       %r5    =  src[4]
	xadd	%r4, %r4, 1			;       %r4    =  src[3]       +1			*anti-interlock*
	add	%r4, %r5			;       %r4    =  src[3]+src[4]+1
	xsrl	%r4, 1				;       %r4    = (src[3]+src[4]+1)>>1
	ld.b	[%r12]+, %r4			;       dst[3] = (src[3]+src[4]+1)>>1
	;
	xsub	%r14, %r14, 1			;     } while(x)
	xjrne	stic_reduce_DO_X0
	;
stic_reduce_LOOP_Y:
	xsub	%r11, %r11, 1			;   } while(y)
	xjrne	stic_reduce_DO_Y
	;
	xld.w	%r14, 32			;   x = 32
stic_reduce_DO_X1:				;   do {
	;
	xld.ub	%r4, [%r13+160]			;     %r4    =         src[160]
	 ld.ub	%r5, [%r13]+			;     %r5    =  src[0]
	xadd	%r4, %r4, 1			;     %r4    =         src[160]+1			*anti-interlock*
	add	%r4, %r5			;     %r4    =  src[0]+src[160]+1
	xsrl	%r4, 1				;     %r4    = (src[0]+src[160]+1)>>1
	ld.b	[%r12]+, %r4			;     dst[0] = (src[0]+src[160]+1)>>1
	xld.ub	%r4, [%r13+160]			;     %r4    =         src[161]
	 ld.ub	%r5, [%r13]+			;     %r5    =  src[1]
	xadd	%r4, %r4, 1			;     %r4    =         src[161]+1			*anti-interlock*
	add	%r4, %r5			;     %r4    =  src[1]+src[161]+1
	xsrl	%r4, 1				;     %r4    = (src[1]+src[161]+1)>>1
	ld.b	[%r12]+, %r4			;     dst[1] = (src[1]+src[161]+1)>>1
	xld.ub	%r4, [%r13+160]			;     %r4    =         src[162]
	 ld.ub	%r5, [%r13]+			;     %r5    =  src[2]
	xadd	%r4, %r4, 1			;     %r4    =         src[162]+1			*anti-interlock*
	add	%r4, %r5			;     %r4    =  src[2]+src[162]+1
	xsrl	%r4, 1				;     %r4    = (src[2]+src[162]+1)>>1
	ld.b	[%r12]+, %r4			;     dst[2] = (src[2]+src[162]+1)>>1
	xld.ub	%r4, [%r13+160]			;     %r4    =                src[163]
	 ld.ub	%r5, [%r13]+			;     %r5    =  src[3]
	xld.ub	%r6, [%r13+160]			;     %r6    =                         src[164]
	 ld.ub	%r7, [%r13]+			;     %r7    =         src[4]
	xadd	%r4, %r4, 2			;     %r4    =                src[163]         +2
	add	%r4, %r5			;     %r4    =  src[3]       +src[163]         +2
	add	%r4, %r6			;     %r4    =  src[3]       +src[163]+src[164]+2
	add	%r4, %r7			;     %r4    =  src[3]+src[4]+src[163]+src[164]+2
	xsrl	%r4, 2				;     %r4    = (src[3]+src[4]+src[163]+src[164]+2)>>2
	ld.b	[%r12]+, %r4			;     dst[3] = (src[3]+src[4]+src[163]+src[164]+2)>>2
	;
	xsub	%r14, %r14, 1			;   } while(x)
	xjrne	stic_reduce_DO_X1
	xadd	%r13, %r13, 160			;   src += 160
	;
	xsub	%r10, %r10, 1			; } while(z)
	xjrne	stic_reduce_DO_Z
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*STIC_ASM*/
