/*	
 *	frams3m.c
 *
 *	P/ECE S3M Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Nov 14 20:03:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/****************************************************************************
 *	P/ECE S3M Driver
 ****************************************************************************/

#ifdef PIECE
#define S3M_ASM
#endif /*PIECE*/

int
s3m_run(S3MDRIVER* driver)
{
	int flags;
	int note;
	int octave;
	int period;
	int instrument;
	int volume;
	int special_command;
	int command_info;
	int i_channel;
	S3MCHANNEL* channel;
	S3MSAMPLE* sample;

	if(driver->stat) goto L_EXIT;

	/* 1[Tick]̎Ԍo߂JEgAbv܂B
	 * Tempo̐ݒl125̏ꍇɁA1[Tick]=1/50[Sec]ƂȂ܂B
	 */
	driver->progress += driver->tempo;
	while(driver->progress >= 125 * 5/*1/5[Tick]PʂŌĂ΂Bs3m_stream_callback()Q*/) {
		driver->progress -= 125 * 5/*1/5[Tick]PʂŌĂ΂Bs3m_stream_callback()Q*/;

		/* 1[Tick]o߂܂B
		 * oTickSpeed̐ݒlɒBA1[Row]i݂܂B
		 */
		driver->tick++;
		while(driver->tick >= driver->speed) {
			driver->tick -= driver->speed;

			/* Position jumpvĂ... */
			if(driver->position_jump != -1) {

				/* Orderݒ肵܂B
				 * * sOrderւPosition jumṕAPattern擾SongI[ƂČo܂B
				 */
				driver->order = driver->position_jump;
				driver->row = 0; /* Kv!! */

				/* Pattern擾܂B */
				if(s3m_init_pattern(driver) != 0) {
					driver->stat = ERRNO; /* SongI[܂Patterns */
					goto L_EXIT;
				}

				/* Position jump܂B */
				driver->position_jump = -1;
			}

			/* Pattern breakvĂ邩A܂PatternI... */
			if((driver->pattern_break != -1) ||
			   (driver->row >= 64)) {

				/* Order̐擪Row֐i߂܂B
				 * * SongI[́APattern擾Ɍo܂B
				 * * S3Mɂ́AMODXMɂ悤ȁASongI[ł̃[v䂪܂B
				 *   [vSongɂ́AIPosition jumpݒKvłB
				 */
				driver->order++;
				driver->row = 0;

				/* Pattern擾܂B */
				if(s3m_init_pattern(driver) != 0) {
					driver->stat = ERRNO; /* SongI[܂Patterns */
					goto L_EXIT;
				}

				/* Pattern breakvĂ... */
				if(driver->pattern_break != -1) {

					/* Pattern breakɂĎw肳ꂽRow܂Ői߂܂B */
					if(s3m_seek_pattern(driver, driver->pattern_break) != 0) {
						driver->stat = ERRNO; /* Pattern breaks */
						goto L_EXIT;
					}

					/* Pattern break܂B */
					driver->pattern_break = -1;
				}
			}

			/* ̂߂ɁARowi߂Ă܂B */
			driver->row++;

			/* ܂AmSpecial command܂B */
			for(i_channel = 0, channel = driver->channels;
			    i_channel < 32;
			    i_channel++, channel++) {
				channel->special_command = 0; /*  */
				/* Command info͌p\̂ŁANAĂ̓_!! */
			}

			/* 1[Row]Pattern data܂B */
			for(;;) {
				flags = *driver->pattern_position++;
				if(!flags) break; /* end of row */
				if(flags & 0x20) {
					note = *driver->pattern_position++;
					instrument = *driver->pattern_position++;
				} else {
					note = 0;
					instrument = 0;
				}
				if(flags & 0x40) {
					volume = *driver->pattern_position++;
				} else {
					volume = -1; /* Volume=0͗LlȂ̂ŁA-1ƂĂ܂ */
				}
				if(flags & 0x80) {
					special_command = *driver->pattern_position++;
					command_info = *driver->pattern_position++;
				} else {
					special_command = 0;
					command_info = 0;
				}

				/* * S3Mt@Cł͋HɁAChannelɑ΂锭vĂ݂łB(2ND_PM.S3M)
				 *   G[2ND_PM.S3MtłȂȂ邽߁A邱Ƃɂ܂B
				 */
				i_channel = flags & 0x1f;
				channel = &driver->channels[i_channel];
				if(channel->pending_sample) { /* ChannelL? */

					/* Instruments܂B */
					if(instrument) {
						if((instrument >= 1) &&
						   (instrument <= driver->insnum)) {
							sample = &driver->samples[instrument - 1/*YȂ!!*/];
							if(sample->sampledata) { /* SampleL? */
								channel->pending_sample = sample;
								channel->vol = sample->vol; /* VolumeKey onɓKp܂!! */
							}
						}
					}

					/* Notes܂B */
					if(note) {
						switch(note) {
						case 255: /* empty note */
							/** no job **/
							break;
						case 254: /* key off */
							channel->playing_sample = NULL;
							break;
						default: /* key on */
							octave = note >> 4;
							note &= 15;
							if(note < 12) { /* 0=C,1=C#,..,10=A#,11=B */
								sample = channel->pending_sample;
								if(sample->sampledata) { /* SampleL? */
								      //period = ((8363 << 4) * (s3m_note_frequency_table[note] >> octave)) / sample->c2spd;
								      //xUp̂ߎό`
									period = ((8363 << 4) * (s3m_note_frequency_table[note]) >> octave) / sample->c2spd;
									if((special_command ==  7) ||	/* Gxy Tone portamento */
									   (special_command == 12)) {	/* Lxy Volslide+Toneporta */
										channel->tone_portamento = period;
										/* Tone portamentoƕpāuInstrumentƈقȂInstrumentݒ肷vƁA
										 * gKƂȂ悤łB(ModplugTrackerŊmF) ̐U镑͖łB
										 */
									} else {
										channel->playing_sample = sample;
										channel->period = period;
										channel->progress = 0;
										channel->sample_position = sample->sampledata;
										/* VolumeInstrumentŝƂœKpĂ܂!! */
									}
								}
							}
							break;
						}
					}

					/* Volumes܂B
					 *   0x00..0x40: Set volume
					 *   0x80..0xc0: Set panning (Ή)
					 */
					if((volume >= 0x00) &&
					   (volume <= 0x40)) {
						channel->vol = volume;
					}

					/* Special commandi[܂B */
					if(special_command) {
						channel->special_command = special_command;
						if(command_info) {
							channel->command_info = command_info;
						} else {
							/* Command info0̏ꍇAꕔSpecial command͑Olp܂B
							 * ȉswitch`caseŁARgAEgā@遚Special command́AOlp܂B
							 *                       RgAEgāȂSpecial command́A0i[܂B
							 * ǂSpecial commandOlpDocumentɖLĂȂ̂ŁAƎfłB
							 */
							switch(special_command) {
							case  1: /* Axy Set speed */
							case  2: /* Bxy Position jump */
							case  3: /* Cxy Pattern break */
							//case  4: /* Dxy Volume slide */
							//case  5: /* Exy Portamento down */
							//case  6: /* Fxy Portamento up */
							//case  7: /* Gxy Tone portamento */
							//case  8: /* Hxy Vibrato */
							//case  9: /* Ixy Tremor */
							//case 10: /* Jxy Arpeggio */
							//case 11: /* Kxy Volslide+Vibrato */
							//case 12: /* Lxy Volslide+Toneporta */
							//case 13: /* Mxy Set channel volume */
							//case 14: /* Nxy Channel volslide */
							//case 15: /* Oxy Set offset */
							//case 16: /* Pxy Panning slide */
							//case 17: /* Qxy Retrigger note */
							//case 18: /* Rxy Tremolo */
							//case 19: /* Sxy Extended S3M commands */ /* Ή */
							case 20: /* Txy Set tempo */
							//case 21: /* Uxy Fine vibrato */
							case 22: /* Vxy Set global volume */
							//case 23: /* Wxy Global volume slide */
							//case 24: /* Xxy Set panning */
							//case 25: /* Yxy Panbrello */
							//case 26: /* Zxy Midi macro */
								channel->command_info = command_info;
								break;
							}
						}
					}
				}
			}
		}

		/* e`lɂ... */
		for(i_channel = 0, channel = driver->channels;
		    i_channel < 32;
		    i_channel++, channel++) {

			/* ChannelȂΔ΂܂B */
			if(!channel->pending_sample) continue;

			/* Special commandLȂ΁As܂B */
			special_command = channel->special_command; /* o */
			if(special_command) {
				command_info = channel->command_info;
				switch(special_command) {
				case  1: /* Axy Set speed */
					driver->speed = command_info;
					if(driver->speed < 1) {
						driver->stat = ERRNO; /* t~ (Ǝ߁AModplugTrackerł͒Pɖ܂) */
						goto L_EXIT;
					}
					special_command = 0; /*  */
					break;
				case  2: /* Bxy Position jump */
					driver->position_jump = command_info;
					special_command = 0; /*  */
					break;
				case  3: /* Cxy Pattern break */
					driver->pattern_break = command_info;
					special_command = 0; /*  */
					break;
VOLUME_SLIDE:			case  4: /* Dxy Volume slide */
					if(driver->tick) { /* Row̍ŏFrameł͕ωȂ */
						       if((command_info & 0xf0) == 0x00) { /* D0x Volume slide down */
							channel->vol -= command_info & 15;
							if(channel->vol < 0) {
								channel->vol = 0;
								special_command = 0; /*  */
							}
						} else if((command_info & 0x0f) == 0x00) { /* Dx0 Volume slide up */
							channel->vol += command_info >> 4;
							if(channel->vol > 64) {
								channel->vol = 64;
								special_command = 0; /*  */
							}
						} else if((command_info & 0xf0) == 0xf0) { /* DFx Fine volume slide down */
							channel->vol -= command_info & 15;
							if(channel->vol < 0) {
								channel->vol = 0;
							}
							special_command = 0; /*  */
						} else if((command_info & 0x0f) == 0x0f) { /* DxF Fine volume slide up */
							channel->vol += command_info >> 4;
							if(channel->vol > 64) {
								channel->vol = 64;
							}
							special_command = 0; /*  */
						}
					}
					break;
				case  5: /* Exy Portamento down */
					if(driver->tick) { /* Row̍ŏFrameł͕ωȂ */
						switch(command_info & 0xf0) {
						case 0xe0: /* EEx Extra fine portamento down */
							channel->period += command_info;
							if(channel->period > S3M_PERIOD_MAX) {
								channel->period = S3M_PERIOD_MAX;
							}
							special_command = 0; /*  */
							break;
						case 0xf0: /* EFx Fine portamento down */
							channel->period += command_info << 2;
							if(channel->period > S3M_PERIOD_MAX) {
								channel->period = S3M_PERIOD_MAX;
							}
							special_command = 0; /*  */
							break;
						default:   /* Exy Portamento down */
							channel->period += command_info << 2;
							if(channel->period > S3M_PERIOD_MAX) {
								channel->period = S3M_PERIOD_MAX;
								special_command = 0; /*  */
							}
							break;
						}
					}
					break;
				case  6: /* Fxy Portamento up */
					if(driver->tick) { /* Row̍ŏFrameł͕ωȂ */
						switch(command_info & 0xf0) {
						case 0xe0: /* FEx Extra fine portamento up */
							channel->period -= command_info;
							if(channel->period < S3M_PERIOD_MIN) {
								channel->period = S3M_PERIOD_MIN;
							}
							special_command = 0; /*  */
							break;
						case 0xf0: /* FFx Fine portamento up */
							channel->period -= command_info << 2;
							if(channel->period < S3M_PERIOD_MIN) {
								channel->period = S3M_PERIOD_MIN;
							}
							special_command = 0; /*  */
							break;
						default:   /* Fxy Portamento up */
							channel->period -= command_info << 2;
							if(channel->period < S3M_PERIOD_MIN) {
								channel->period = S3M_PERIOD_MIN;
								special_command = 0; /*  */
							}
							break;
						}
					}
					break;
				case  7: /* Gxy Tone portamento */
					/* Row̍ŏFrameω邩ۂsBԂωH Ǝf */
					       if(channel->period < channel->tone_portamento) {
						channel->period += command_info << 2;
						if(channel->period >= channel->tone_portamento) {
							channel->period = channel->tone_portamento;
							special_command = 0; /*  */
						}
					} else if(channel->period > channel->tone_portamento) {
						channel->period -= command_info << 2;
						if(channel->period <= channel->tone_portamento) {
							channel->period = channel->tone_portamento;
							special_command = 0; /*  */
						}
					}
					break;
				//case  8: /* Hxy Vibrato */
				//case  9: /* Ixy Tremor */
				//case 10: /* Jxy Arpeggio */
				case 11: /* Kxy Volslide+Vibrato */
					/* Vibrato͖Ή */
					goto VOLUME_SLIDE;
					break;
				case 12: /* Lxy Volslide+Toneporta */
					/* Tone portamento͖Ή */
					goto VOLUME_SLIDE;
					break;
				//case 13: /* Mxy Set channel volume */
				//case 14: /* Nxy Channel volslide */
				//case 15: /* Oxy Set offset */
				//case 16: /* Pxy Panning slide */
				//case 17: /* Qxy Retrigger note */
				//case 18: /* Rxy Tremolo */
				//case 19: /* Sxy Extended S3M commands */
				case 20: /* Txy Set tempo */
					driver->tempo = command_info;
					if(driver->tempo < 1) {
						driver->stat = ERRNO; /* t~ (Ǝ߁AModplugTrackerł͒Pɖ܂) */
						goto L_EXIT;
					}
					special_command = 0; /*  */
					break;
				//case 21: /* Uxy Fine vibrato */
				case 22: /* Vxy Set global volume */
					driver->g_v = command_info;
					special_command = 0; /*  */
					break;
				case 23: /* Wxy Global volume slide */
					if(driver->tick) { /* Row̍ŏFrameł͕ωȂ */
						       if((command_info & 0xf0) == 0x00) { /* W0x Global volume slide down */
							driver->g_v -= command_info & 15;
							if(driver->g_v < 0) {
								driver->g_v = 0;
								special_command = 0; /*  */
							}
						} else if((command_info & 0x0f) == 0x00) { /* Wx0 Global volume slide up */
							driver->g_v += command_info >> 4;
							if(driver->g_v > 64) {
								driver->g_v = 64;
								special_command = 0; /*  */
							}
						} else if((command_info & 0xf0) == 0xf0) { /* WFx Fine global volume slide down */
							driver->g_v -= command_info & 15;
							if(driver->g_v < 0) {
								driver->g_v = 0;
							}
							special_command = 0; /*  */
						} else if((command_info & 0x0f) == 0x0f) { /* WxF Fine global volume slide up */
							driver->g_v += command_info >> 4;
							if(driver->g_v > 64) {
								driver->g_v = 64;
							}
							special_command = 0; /*  */
						}
					}
					break;
				//case 24: /* Xxy Set panning */
				//case 25: /* Yxy Panbrello */
				//case 26: /* Zxy Midi macro */
				}
				channel->special_command = special_command; /* ߂ */
			}
		}
	}

L_EXIT:
	return driver->stat;
}

int
s3m_mix(S3MDRIVER* driver, short wbuff[/*S3MBUFLEN_5*/])
{
	static int mixbuf[S3MBUFLEN_5]; /* ~LVOobt@Ars`shbłI */
	//
	int i_channel;
	int frequency;
	int volume;
	S3MCHANNEL* channel;

	if(driver->stat) goto L_EXIT;

	/* ܂A~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* e`lɂ... */
	for(i_channel = 0, channel = driver->channels;
	    i_channel < 32;
	    i_channel++, channel++) {

		/* SilentȂΔ΂܂B
		 * Channel͕KSilentێĂ̂ŁAChannelۂ̔f͕svłB
		 */
		if(!channel->playing_sample) continue;

		/* {[߂܂B */
		volume = driver->g_v *	/*   0..64 ( 6bit) */
			 channel->vol;	/* x 0..64 ( 6bit) */
					/* =       (12bit) */
		if(!volume) continue; /*  */

		/* Đg߂܂B */
		frequency = 14317056 / channel->period;

		/* 1/5[Tick]~LVO܂B */
		s3m_mix1(channel, volume, frequency, mixbuf);
	}

	/* ~LVOobt@NbsOāAo̓obt@֏݂܂B */
	s3m_mix2(wbuff, mixbuf);

L_EXIT:
	return driver->stat;
}

#ifndef S3M_ASM
void
s3m_mix1(S3MCHANNEL* channel, int volume, int frequency, int* mixbuf)
{
	int n;
	int progress;
	const unsigned char* sample_position;
	const unsigned char* loop_begin;
	const unsigned char* loop_end;

	/* ̂߁ApɂɎgtB[hoĂ܂B */
	progress = channel->progress;
	sample_position = channel->sample_position;

	/* ̃tB[h͕ωȂ̂ŁA߂svłB */
	loop_begin = channel->playing_sample->loop_begin;
	loop_end = channel->playing_sample->loop_end;

	n = S3MBUFLEN_5;
	do {
		progress += frequency;
		while(progress >= SPEAKER_FREQUENCY) {
			progress -= SPEAKER_FREQUENCY;
			sample_position++;
			if(sample_position >= loop_end) {
				if(!loop_begin) { /* Loop off */
					channel->playing_sample = NULL;
					return;
				}
				sample_position = loop_begin;
			}
		}
		*mixbuf++ += (*sample_position - 128) * volume;
	} while(--n);

	/* otB[h߂܂B */
	channel->progress = progress;
	channel->sample_position = sample_position;
}
#else /*S3M_ASM*/
asm("
	.code
	.align 1
	.global s3m_mix1
s3m_mix1:
	; %r12 = channel
	; %r13 = volume
	; %r14 = frequency
	; %r15 = mixbuf
	pushn %r2
	xld.w %r4, [%r12+16]		; channel->progress
	xld.w %r5, [%r12+20]		; channel->sample_position

	xld.w %r10, [%r12+4]		; channel->playing_sample
	xld.w %r6, [%r10+4]		; playing_sample->loop_begin
	xld.w %r7, [%r10+8]		; playing_sample->loop_end
	xld.w %r0, 16000		; SPEAKER_FREQUENCY
	xld.w %r1, 128			; 128

	xld.w %r2, 64			; S3MBUFLEN_5
					; do {
	add %r4, %r14			;   progress += frequency (ڈȍ~̓[vDelaySlotōs)
s3m_mix1_L10:				;   
	cmp %r4, %r0			;   while(progress >= SPEAKER_FREQUENCY) {
	xjrlt s3m_mix1_L20

	sub %r4, %r0			;     progress -= SPEAKER_FREQUENCY
	xadd %r5, %r5, 1		;     sample_position++
	cmp %r5, %r7			;     if(sample_position < loop_end) {
	xjrult s3m_mix1_L10		;       continue
					;     }
	xcmp %r6, 0			;     if(loop_begin) {
	xjrne.d s3m_mix1_L10		;       sample_position = loop_begin
	ld.w %r5, %r6			;	continue (*delay* loop_begin==NULL̓_~[ƂȂ܂)
					;     }
	xld.w [%r12+4], %r6		;     channel->playing_sample = NULL
	xjp s3m_mix1_EXIT		;     return

s3m_mix1_L20:
	ld.ub %r10, [%r5]		;   *sample_position
	ld.w %r11, [%r15]		;   *mixbuf (*anti-interlock*)
	sub %r10, %r1			;   *sample_position - 128
	mlt.h %r10, %r13		;   (*sample_position - 128) * volume (8bit~12bit)
	ld.w %r10, %alr			;   
	add %r10, %r11			;   (*sample_position - 128) * volume + *mixbuf
	ld.w [%r15]+, %r10		;   
	xsub %r2, %r2, 1		; } while(--n)
	xjrne.d s3m_mix1_L10		; 
	add %r4, %r14			; progress += frequency (*delay* [v擪̏)
	sub %r4, %r14			; DelaySlot͖Ŏs邽߁AŌ̈͑߂Ȃ̂Ŗ߂

	xld.w [%r12+16], %r4		; channel->progress
	xld.w [%r12+20], %r5		; channel->sample_position
s3m_mix1_EXIT:
	popn %r2
	ret
");
#endif /*S3M_ASM*/

#ifndef S3M_ASM
void
s3m_mix2(short* wbuff, const int* mixbuf)
{
	int n;
	int output;

	n = S3MBUFLEN_5;
	do {
		/*   volume (12bit)
		 * x sample ( 8bit)
		 * x 32[ch] ( 5bit)
		 * =        (25bit)
		 */
		output = *mixbuf++ >> ((25 - 16) - 4/**/);
		if(output >  32767) output =  32767;
		if(output < -32768) output = -32768;
		*wbuff++ = output;
	} while(--n);
}
#else /*S3M_ASM*/
asm("
	.code
	.align 1
	.global s3m_mix2
s3m_mix2:
	; %r12 = wbuff
	; %r13 = mixbuf
	xld.w %r4, 64			; S3MBUFLEN_5
	xld.w %r5, 32767
	not %r6, %r5			; -32768
s3m_mix2_L10:
	ld.w %r7, [%r13]+
	xsra %r7, 5			; ((25 - 16) - 4/**/)
	cmp %r7, %r5
	xjrle.d s3m_mix2_L20
	cmp %r7, %r6			; *delay*
	ld.w %r7, %r5
s3m_mix2_L20:
	xjrge.d s3m_mix2_L30
	sub %r4, 1			; *delay*
	ld.w %r7, %r6
s3m_mix2_L30:
	ld.h [%r12]+, %r7
	xjrne s3m_mix2_L10
	ret
");
#endif /*S3M_ASM*/
