/*	
 *	cliptlz.h
 *
 *	ȈLZk
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2008 Naoyuki Sawa
 *
 *	* Sun Feb 17 22:17:30 JST 2008 Naoyuki Sawa
 *	- 1st [XB
 *	- tbgvg̋ɏړIƂč쐬AȈLZk`łB
 *	  ʓILZk`ł́AWJXg[ƂɐLoCg̎obt@̂łA
 *	  gݍݗpCPȂǂRAM̏ȂŁA̓WJXg[sēǂݏoKvLꍇɁA
 *	  WJXg[̊Ǘ\̃TCY傫ălbNƂȂ܂B
 *	  {W[̈k`͎obt@15oCgƂAɍ킹ēWJ[`œK܂B
 *	  obt@߈k͗ǂ܂񂪁AOq̂悤RAM̏Ȃłp\łB
 */
#ifndef __CLIP_TLZ_H__
#define __CLIP_TLZ_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* ȈLZk̓WJXg[Ǘ\̂łB */
typedef struct _TinyLZ {
	const unsigned char* p;		/* + 0, 4 */
	unsigned char len_pos;		/* + 4, 1 = (len<<4)|pos */
	unsigned char dic[15];		/* + 5,15 */
} TinyLZ;				/* =20 */

/****************************************************************************
 *	
 ****************************************************************************/

/* WJXg[܂B
 * [in]
 *	tlz		TinyLZ\̂ւ̃|C^B
 *	p		kf[^̐擪AhXB
 */
void TinyLZ_init(TinyLZ* tlz, const void* p);

/* WJXg[1oCgǂݏo܂B
 * [in]
 *	tlz		TinyLZ\̂ւ̃|C^B
 * [out]
 *	߂l		ǂݏof[^B(0`255)
 * [note]
 *	* {W[̈k`ɂ́AWJXg[̏I[𔻒f@\L܂B
 *	  tbgvgɏ邽߂ɁAk`P߂łB
 *	  AvP[Vňȉ̂悤ȕ@gāAWJXg[̏I[𔻒fĂB
 *
 *	- kÕf[^ŒTCYƂ@
 *		TinyLZ_init(&tlz, compressed_data);
 *		for(i = 0; i < UNCOMPRESSED_SIZE; i++) {
 *			c = TinyLZ_get(&tlz);
 *			...
 *		}
 *
 *	- kÕf[^ɏI[}[N𖄂ߍł@
 *		TinyLZ_init(&tlz, compressed_data);
 *		for(;;) {
 *			c = TinyLZ_get(&tlz);
 *			if(c == '\x1A') break;
 *			...
 *		}
 *
 *	- kf[^̏I[Ď@ (TinyLZ_uncompress()̎QƂĂ)
 *		TinyLZ_init(&tlz, compressed_data);
 *		while((tlz.p < &compressed_data[COMPRESSED_SIZE]) || (tlz.len_pos > 15)) {
 *			c = TinyLZ_get(&tlz);
 *			...
 *		}
 */
int TinyLZ_get(TinyLZ* tlz);

/* kf[^WJ܂B
 * [in]
 *	_dst		WJobt@̐擪AhXB
 *	dst_max		WJobt@̃oCgB
 *	_src		kf[^̐擪AhXB
 *	src_len		kf[^̃oCgB
 * [out]
 *	߂l		WJf[^̃oCgB
 *	_dst[]		WJf[^B
 * [note]
 *	* WJf[^WJobt@𒴂ꍇA͏݂܂B
 *	  ̏ꍇA߂l̓WJf[^̃oCǵA܂݂܂B
 *	  ̋𗘗pāAƂΈȉ̂悤ɏ邱Ƃł܂B
 *		dst_max = TinyLZ_uncompress(NULL, 0, src, src_len); // WJf[^̃oCg擾
 *		dst = malloc(dst_len);                              // WJobt@m
 *		TinyLZ_uncompress(dst, dst_max, src, src_len);      // WJ
 *	* {W[̊{IȎǵATinyLZ_init()TinyLZ_get()g1oCgÂWJłA
 *	  kf[^ŜCɓWJ郆[eBeBƂāA{֐pӂ܂B
 */
int TinyLZ_uncompress(void* _dst, int dst_max, const void* _src, int src_len);

#ifndef PIECE
/* f[^k܂B
 * [in]
 *	_dst		kobt@̐擪AhXB
 *	dst_max		kobt@̃oCgB
 *	_src		f[^̐擪AhXB
 *	src_len		f[^̃oCgB
 * [out]
 *	߂l		kf[^̃oCgB
 *	_dst[]		kf[^B
 * [note]
 *	* kf[^kobt@𒴂ꍇA͏݂܂B
 *	  ̏ꍇA߂l̈kf[^̃oCǵA܂݂܂B
 *	  ̋𗘗pāAƂΈȉ̂悤ɏ邱Ƃł܂B
 *		dst_max = TinyLZ_compress(NULL, 0, src, src_len); // kf[^̃oCg擾
 *		dst = malloc(dst_len);                            // kobt@m
 *		TinyLZ_compress(dst, dst_max, src, src_len);      // k
 *	* P/ECE@ł͗pȂƔfāAt@CTCYߖ̂߂ɊO܂B
 *	  kf[^̍쐬́ADOSR}hCc[utool/dtinylzv𗘗pĂB
 */
int TinyLZ_compress(void* _dst, int dst_max, const void* _src, int src_len);
#endif /*PIECE*/

#endif /*__CLIP_TLZ_H__*/
