/*	
 *	clipsv.h
 *
 *	P/ECE SUPERVISION Video/Sound Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Thu Apr 14 05:55:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SV_H__
#define __CLIP_SV_H__

/****************************************************************************
 *	
 ****************************************************************************/

#define SUPERVISION_CLOCK (4000000) /* SUPERVISIONVXeNbN */

/****************************************************************************
 *	Video
 ****************************************************************************/

typedef struct _SVVIDEO {
	unsigned char* ram/*[0x0000..0x5fff]*/;	/* RAM/WX^ */
} SVVIDEO;
extern SVVIDEO svvideo;

/* SUPERVISION VideoRAZbg܂B
 * [in]
 *	ram		RAM/WX^擪ւ̃|C^w肵ĂB
 *			~~~~~~~~~~~~=65C02Cԃobt@擪
 * [note]
 *	* RAM/WX^́AȂƂ[0x0000..0x5fff]͈̔͂KvłB
 *	  SUPERVISION VideoW[́Aȉ̗̈gp܂B
 *
 *		0x2000,   1	x size (Ή)
 *		0x2001,   1	y size (Ή)
 *		0x2002,   1	horicontal offset in pixel
 *		0x2003,   1	vertical   offset in pixel
 *		0x4000,8160	VRAM (0x4000..0x5fdf͈̔͂Wraparound܂)
 *				              ~~~~~~=0x4000+(192*170-1)
 *
 *				screen startaddress
 *				 = 0x4000+(([0x2003]*192+[0x2002])/4)%(192*170/4)
 *				  |
 *				  |	|      160      |  32  |
 *				  |	|<------------->|<---->|
 *				  +--->	+---------------+------+---
 *					|               |      | A
 *					|               |      | |
 *					|               |      | |
 *					|    visible    |      | | 160
 *					|               |      | |
 *					|               |      | |
 *					|               |      | V
 *					+---------------+------+---
 *					|               |      | A
 *					|               |      | | 10
 *					|               |      | V
 *					+---------------+------+---
 */
void svvideo_reset(unsigned char ram[/*0x0000..0x5fff*/]);

/* VideoWX^֏݂܂B
 * [in]
 *	addr		ރWX^AhXB(0x2000..0x2003)
 *	data		ރf[^B
 */
void svvideo_write(int addr, int data);

/* ʂ`悵܂B
 * [in]
 *	vbuff		160x160ʃobt@B
 *			NULLw肵ꍇ́AɁAɏԂ܂B
 */
void svvideo_update(unsigned char vbuff[/*160*160*/]);

/* 160x160x4~OCXP[A128x88x4~OCXP[֏kRs[܂B
 * [in]
 *	src		160x160x4~OCXP[ʃobt@B
 *	dst		128x 88x4~OCXP[ʃobt@B
 * [note]
 *	* srcdst͓AhXwĂĂ\܂B
 *	  ŏII128x88̉ʃC[WKvȂ΁A160x160128x88
 *	  ʃobt@ʂɂāAߖł܂B
 */
void svvideo_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*160*/]);

/****************************************************************************
 *	Sound
 ****************************************************************************/

#define SVSOUNDBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/* AZu[`璼ڎQƂ̂ŁACAEgŒłB */
typedef struct _SVSOUNDTONE {
	int volume;	/* + 0,4: {[ (silent:0..15:max) */
	int period;	/* + 4,4: () */
	int polar;	/* + 8,4: o͋ɐ 0:-/1:+ */
	int count;	/* +12,4: JE^ */
} SVSOUNDTONE;		/* =16 */

/* AZu[`璼ڎQƂ̂ŁACAEgŒłB */
typedef struct _SVSOUNDNOISE {
	int on;		/* + 0,4: 0:Off/1:On */
	int volume;	/* + 4,4: {[ (silent:0..15:max) */
	int period;	/* + 8,4: () */
	int lfsr;	/* +12,4: mCYLFSR */
	int count;	/* +16,4: JE^ */
} SVSOUNDNOISE;		/* =20 */

void svsound_tone_mix(SVSOUNDTONE* tone, short wbuff[/*SVSOUNDBUFLEN*/]);
void svsound_noise_mix(SVSOUNDNOISE* noise, short wbuff[/*SVSOUNDBUFLEN*/]);
void svsound_volume_shift(short wbuff[/*SVSOUNDBUFLEN*/]);

typedef struct _SVSOUND {
	      unsigned char* ram/*[0x0000..0x0x5fff]*/;		/* RAM/WX^ */
	const unsigned char* rom/*[0x0000..0x7fff or 0xffff]*/;	/* ROMC[W */
	//
	SVSOUNDTONE tone[2];
	SVSOUNDNOISE noise;
} SVSOUND;
extern SVSOUND svsound;

/* SUPERVISION SoundRAZbg܂B
 * [in]
 *	ram		RAM/WX^擪ւ̃|C^w肵ĂB
 *			~~~~~~~~~~~~=65C02Cԃobt@擪
 *	rom		ROMC[W擪ւ̃|C^w肵ĂB
 */
void svsound_reset(unsigned char ram[/*0x0000..0x5fff*/],
             const unsigned char rom[/*0x0000..0x7fff or 0xffff*/]);

/* SoundWX^֏݂܂B
 * [in]
 *	addr		ރWX^AhXB
 *	data		ރf[^B
 */
void svsound_write(int addr, int data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁASVSOUNDBUFLENTṽ~LVOs܂B
 * [in]
 *	wbuff		o̓Tvobt@B
 */
void svsound_mix(short wbuff[/*SVSOUNDBUFLEN*/]);

#endif /*__CLIP_SV_H__*/
