;
;	clips26a.s
;
;	P/ECE Signetics 2650 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#include "clips26a.h"

;****************************************************************************
;	
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

	.global	s2650_irq
s2650_irq:
	pushn	%r3
	xcall	s2650_enter			; sReLXg֓܂B
	;
	xbset	[%CPU+FLAGS], FLAGS_IRQ		; 荞ݗvZbg܂B
	xld.b	[%CPU+VECTOR], %r12		; 荞݃xN^i[܂B
	xcall	s2650_check_pending		; Ɋ荞ݎs\ׂ܂B
	;
	xcall	s2650_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

	.global	s2650_check_pending
s2650_check_pending:
	xbtst	[%CPU+FLAGS], FLAGS_IRQ		; 荞ݗvZbgĂȂ΁A܂B
	xjreq	s2650_check_pending_EXIT
	xbtst	[%CPU+PSU], PSU_II		; 荞݋֎~(II=1)Ȃ΁A܂B
	xjrne	s2650_check_pending_EXIT
	;
	xbclr	[%CPU+FLAGS], FLAGS_IRQ		; 荞ݗvNABHALTȂHALT܂B
	xbclr	[%CPU+FLAGS], FLAGS_HALT
	xbset	[%CPU+PSU], PSU_II		; 荞݋֎~(II=1)܂B
	;
	xld.ub	%data, [%CPU+VECTOR]		; "ZBSR vector"̏s܂B
	xcall	s2650_VEC			; AddressMode
	xcall	s2650_BS
s2650_check_pending_EXIT:
	ret

;****************************************************************************
;	AddressMode (gppxႢ)
;****************************************************************************

	.global	s2650_CTL
s2650_CTL: /* M/#IO=#IO, D/#C=#C(Control), E/#NE=#NE(Non-extended) */
	xld.w	%addr, 0x100			; addr = 0x100
	ret

	.global	s2650_DAT
s2650_DAT: /* M/#IO=#IO, D/#C=D(Data), E/#NE=#NE(Non-extended) */
	xld.w	%addr, 0x101			; addr = 0x101
	ret

	.global	s2650_EXT
s2650_EXT: /* M/#IO=#IO, E/#NE=E(Extended), A7:0=2nd byte of the instruction */
	xcall.d	s2650_read			; addr = [IAR++]
	ld.w	%r12, %IAR			;						*delay*
	add	%IAR, 1
	ret.d
	ld.w	%addr, %r10			;						*delay*

;****************************************************************************
;	Operation (gppxႢ)
;****************************************************************************

	.global	s2650_ERR
s2650_ERR:
	xcall	s2650_leave			; sReLXg𔲂܂B
	xjp	s2650_err			; Cł̃G[[`ցB

/*--------------------------------------------------------------------------*/

	.global	s2650_RETE
s2650_RETE:
	ld.w	%r9, [%seq]+			; Condition
	call	%r9
	xjrne	s2650_RETE_EXIT
	xcall	s2650_RET
	xbclr	[%CPU+PSU], PSU_II		; II=0:荞݋
	xcall	s2650_check_pending
s2650_RETE_EXIT:
	ret

/*--------------------------------------------------------------------------*/

	.global	s2650_REDp
s2650_REDp:
	ld.w	%r9, [%seq]+			; Register
	call	%r9
	ld.w	%r9, [%seq]+			; AddressMode
	call	%r9
	xcall.d	s2650_read_io			; %r10 = [port]
	ld.w	%r12, %addr			;				*delay*
	ld.b	[%reg], %r10			; r    = %r10
	ret.d
	ld.w	%CC, %r10			; CC   = %r10			*delay*

	.global	s2650_WRTp
s2650_WRTp:
	ld.w	%r9, [%seq]+			; Register
	call	%r9
	ld.w	%r9, [%seq]+			; AddressMode
	call	%r9
	ld.ub	%r13, [%reg]			; [port] = r
	xjp.d	s2650_write_io
	ld.w	%r12, %addr

/*--------------------------------------------------------------------------*/

	.global	s2650_NOP
s2650_NOP:
	/** no job **/
	ret

	.global	s2650_DAR
s2650_DAR:
	ld.w	%r9, [%seq]+			; Register
	call	%r9
	ld.ub	%r10, [%reg]			; %r10 = hi = r
	ld.w	%r11, %r10			; %r11 = lo = r
	xbtst	[%CPU+C+1], 0			; if(!C) {
	xjrne	s2650_DAR_L10
	xadd	%r10, %r10, 0xa0		;   hi += 0xa0
s2650_DAR_L10:					; }
	xbtst	[%CPU+IDC], 4			; if(!IDC) {
	xjrne	s2650_DAR_L20
	xadd	%r11, %r11, 0x0a		;   lo += 0x0a
s2650_DAR_L20:					; }
	xand	%r10, %r10, 0xf0		; r = (hi&0xf0)|(lo&0x0f)
	xand	%r11, %r11, 0x0f
	or	%r10, %r11
	ld.b	[%reg], %r10
	ret

	.global	s2650_HALT
s2650_HALT:
	xbset	[%CPU+FLAGS], FLAGS_HALT
	ret.d
	ld.w	%CYCLE, 0			;				*delay*

;****************************************************************************
;	
;****************************************************************************
