/*
 *	clipfix.c
 *
 *	Œ菬Cu܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Mon Mar 24 04:30:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa
 *	- ꕔ̊֐framfix.cֈړB
 *	* Thu Jul  8 06:00:00 JST 2004 Naoyuki Sawa
 *	- fcom()ficom()̈ύXɒǏ]B
 *	* Mon Jul 12 21:02:00 JST 2004 Naoyuki Sawa
 *	- fatan2()܂B
 *	* Wed Sep 15 06:36:00 JST 2004 Naoyuki Sawa
 *	- RND8/16,RND8/16_RANGẼ}N֐ɔAFRND,FRND_RANGE֐܂B
 *	  ߋ̃\[X̌݊̂߁A֐Ăяo}N`Ă܂B
 *	* Tue Dec 21 06:00:00 JST 2004 Naoyuki Sawa
 *	  vnormal()Ƀ[xNgw肳ꂽꍇÂ܂܃[xNgԂ悤ɂ܂B
 *	  (܂ł́A[xNgw肳ƁA[ZG[ɂȂĂ܂B)
 *	- mlookat()ɂāAxNg^Ăꍇ̋~ϑ[uƂāȀꍇɌA
 *	  {̏xNg(0,1,0)ł͂Ȃ(0,0,1)Ƃ邱Ƃɂ܂B
 *	  ^ʂԂ珙Xɂɉց`^P[Xz肵Ă܂B
 *	  (܂ł́AxNg^ƕ`挋ʂsƂȂĂ܂B)
 *	* Wed Dec 22 06:05:00 JST 2004 Naoyuki Sawa
 *	- mlookat()̉Z덷ጸ܂B
 *	* Thu Jul 06 13:17:03 JST 2006 Naoyuki Sawa
 *	- frnd()̎ύX܂B
 *	  rnd32()̐V݂ɔArnd16()rnd32()𗘗p悤ύX܂B
 *	  FRACT_MASK16bitȉȂ̂ŁA܂łǂrnd16()gĂ͖̂łA
 *	  ECuŜrnd16()rnd32()ɓꂷjł邱ƁB
 *	  Ernd16()͓rnd32()ĂяoĂArnd32()Ăяoł邱ƁB
 *	  ȏ̗RɂArnd32()𗘗p悤AύX邱Ƃɂ܂B
 *	- frnd_range()̎ύX܂B
 *	  ܂ł́A܂0.0ȏ1.0̗𐶐AXP[OČʂƂĂ܂B
 *	  ̕@ł́A0.0`1.0̉𑜓x10bit(FRACT_BITS)̂ŁA傫ꂽa`b͈̔͂w肳ꂽꍇɂA
 *	  ߂l̉𑜓x1024iKƂ肪܂B
 *	  Aʊ֐Ƃrnd32_range()𗘗p悤ύXAa`b͈̔͂ɉ𑜓x悤ɂȂ܂B
 *	* Sun Jul 30 22:17:45 JST 2006 Naoyuki Sawa
 *	- mrot()܂B
 *	  2003/03/24ɃCuŒ菬ĈȗA݂܂ŁAmrot()͐錾Ŏ܂łA
 *	  {AƎs܂B
 *	  s񎮂́AŒ菬O̕o[WŎgĂ̂ƓAPɌŒ菬̂łB
 *	  o[ẂAuclip/keep/01_ŉZ`R[hۑ/clipmath.cvQƂĂB
 *	* Thu Sep 07 01:18:27 JST 2006 Naoyuki Sawa
 *	- fasin()facos()܂B
 */
#include "clip.h"

/* * Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa */
/* - fmul()framfix.cֈړ܂B         */

/* * Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa */
/* - fdiv()framfix.cֈړ܂B         */

/* * Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa */
/* - fsqrt()framfix.cֈړ܂B        */

/****************************************************************************
 *	frnd,frnd_range
 ****************************************************************************/

//fixed
//frnd(int* seed)
//{
//	return (fixed)(rnd16(seed) & FRACT_MASK);
//}
//* Thu Jul 06 13:17:03 JST 2006 Naoyuki Sawa
//- frnd()̎ύX܂B
//  rnd32()̐V݂ɔArnd16()rnd32()𗘗p悤ύX܂B
//  FRACT_MASK16bitȉȂ̂ŁA܂łǂrnd16()gĂ͖̂łA
//  ECuŜrnd16()rnd32()ɓꂷjł邱ƁB
//  Ernd16()͓rnd32()ĂяoĂArnd32()Ăяoł邱ƁB
//  ȏ̗RɂArnd32()𗘗p悤AύX邱Ƃɂ܂B
fixed
frnd(int* seed)
{
	return (fixed)(rnd32(seed) & FRACT_MASK);
}

//fixed
//frnd_range(int* seed, fixed a, fixed b)
//{
//	return fadd(fmul(frnd(seed), fsub(b, a)), a);
//}
//* Thu Jul 06 13:17:03 JST 2006 Naoyuki Sawa
//- frnd_range()̎ύX܂B
//  ܂ł́A܂0.0ȏ1.0̗𐶐AXP[OČʂƂĂ܂B
//  ̕@ł́A0.0`1.0̉𑜓x10bit(FRACT_BITS)̂ŁA傫ꂽa`b͈̔͂w肳ꂽꍇɂA
//  ߂l̉𑜓x1024iKƂ肪܂B
//  Aʊ֐Ƃrnd32_range()𗘗p悤ύXAa`b͈̔͂ɉ𑜓x悤ɂȂ܂B
fixed
frnd_range(int* seed, fixed a, fixed b)
{
	/* (fixed)(int)́uŒ菬̈ʒuǂȂv̈ႢȂ̂ŁA
	 * oCi̊ϓ_ł́Afrnd_range()rnd32_range()̏e͑SłB
	 */
	return (fixed)rnd32_range(seed, (int)a, (int)b);
}

/****************************************************************************
 *	fsin
 ****************************************************************************/

fixed
fsin(fixed a)
{
	return fcos(fsub(a, PI_2));	/* sin() = cos(-/2) */
}

/****************************************************************************
 *	fcos
 ****************************************************************************/

/* fcos_tbl[]́ALinux/SPARCňȉ̃vOgĐ܂B
 * Œ菬p[^ύXAfcos_tbl[]蒼Kv܂B
 *--------------------------------------------------------------------------
 *	#include <stdio.h>
 *	#include <math.h>
 *	#define FRACT_BITS	  10
 *	#define _PI_2		1608
 *	int main() {
 *		double pi_2, d;
 *		int i, v;
 *		printf("static const short fcos_tbl[_PI_2 + 1] = {\n");
 *		pi_2 = atan2(0, -1) / 2;
 *		for(i = 0; i <= _PI_2; i++) {
 *			d = pi_2 * i / _PI_2;
 *			v = (int)(cos(d) * (1 << FRACT_BITS) + 0.5);
 *			if(i % 50 ==  0) printf("\t");
 *			printf("0x%04x,", v);
 *			if(i % 50 == 49) printf("\n");
 *		}
 *		printf("\n};\n");
 *		return 0;
 *	}
 *--------------------------------------------------------------------------
 */
#if (FRACT_BITS != 10) || (_PI_2 != 1608)
#error Œ菬p[^zlƈقȂ܂B
#endif
static const short fcos_tbl[_PI_2 + 1] = {
	0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,
	0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03ff,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fe,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fd,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fc,0x03fb,0x03fb,0x03fb,
	0x03fb,0x03fb,0x03fb,0x03fb,0x03fb,0x03fb,0x03fb,0x03fa,0x03fa,0x03fa,0x03fa,0x03fa,0x03fa,0x03fa,0x03fa,0x03fa,0x03f9,0x03f9,0x03f9,0x03f9,0x03f9,0x03f9,0x03f9,0x03f9,0x03f8,0x03f8,0x03f8,0x03f8,0x03f8,0x03f8,0x03f8,0x03f8,0x03f7,0x03f7,0x03f7,0x03f7,0x03f7,0x03f7,0x03f7,0x03f7,0x03f6,0x03f6,0x03f6,0x03f6,0x03f6,0x03f6,0x03f6,0x03f5,0x03f5,0x03f5,
	0x03f5,0x03f5,0x03f5,0x03f5,0x03f4,0x03f4,0x03f4,0x03f4,0x03f4,0x03f4,0x03f4,0x03f3,0x03f3,0x03f3,0x03f3,0x03f3,0x03f3,0x03f2,0x03f2,0x03f2,0x03f2,0x03f2,0x03f2,0x03f1,0x03f1,0x03f1,0x03f1,0x03f1,0x03f1,0x03f0,0x03f0,0x03f0,0x03f0,0x03f0,0x03f0,0x03ef,0x03ef,0x03ef,0x03ef,0x03ef,0x03ee,0x03ee,0x03ee,0x03ee,0x03ee,0x03ed,0x03ed,0x03ed,0x03ed,0x03ed,
	0x03ed,0x03ec,0x03ec,0x03ec,0x03ec,0x03ec,0x03eb,0x03eb,0x03eb,0x03eb,0x03eb,0x03ea,0x03ea,0x03ea,0x03ea,0x03e9,0x03e9,0x03e9,0x03e9,0x03e9,0x03e8,0x03e8,0x03e8,0x03e8,0x03e8,0x03e7,0x03e7,0x03e7,0x03e7,0x03e6,0x03e6,0x03e6,0x03e6,0x03e6,0x03e5,0x03e5,0x03e5,0x03e5,0x03e4,0x03e4,0x03e4,0x03e4,0x03e4,0x03e3,0x03e3,0x03e3,0x03e3,0x03e2,0x03e2,0x03e2,
	0x03e2,0x03e1,0x03e1,0x03e1,0x03e1,0x03e0,0x03e0,0x03e0,0x03e0,0x03df,0x03df,0x03df,0x03df,0x03de,0x03de,0x03de,0x03de,0x03dd,0x03dd,0x03dd,0x03dd,0x03dc,0x03dc,0x03dc,0x03dc,0x03db,0x03db,0x03db,0x03da,0x03da,0x03da,0x03da,0x03d9,0x03d9,0x03d9,0x03d9,0x03d8,0x03d8,0x03d8,0x03d7,0x03d7,0x03d7,0x03d7,0x03d6,0x03d6,0x03d6,0x03d5,0x03d5,0x03d5,0x03d5,
	0x03d4,0x03d4,0x03d4,0x03d3,0x03d3,0x03d3,0x03d3,0x03d2,0x03d2,0x03d2,0x03d1,0x03d1,0x03d1,0x03d1,0x03d0,0x03d0,0x03d0,0x03cf,0x03cf,0x03cf,0x03ce,0x03ce,0x03ce,0x03cd,0x03cd,0x03cd,0x03cd,0x03cc,0x03cc,0x03cc,0x03cb,0x03cb,0x03cb,0x03ca,0x03ca,0x03ca,0x03c9,0x03c9,0x03c9,0x03c8,0x03c8,0x03c8,0x03c7,0x03c7,0x03c7,0x03c6,0x03c6,0x03c6,0x03c5,0x03c5,
	0x03c5,0x03c4,0x03c4,0x03c4,0x03c3,0x03c3,0x03c3,0x03c2,0x03c2,0x03c2,0x03c1,0x03c1,0x03c1,0x03c0,0x03c0,0x03c0,0x03bf,0x03bf,0x03bf,0x03be,0x03be,0x03bd,0x03bd,0x03bd,0x03bc,0x03bc,0x03bc,0x03bb,0x03bb,0x03bb,0x03ba,0x03ba,0x03ba,0x03b9,0x03b9,0x03b8,0x03b8,0x03b8,0x03b7,0x03b7,0x03b7,0x03b6,0x03b6,0x03b5,0x03b5,0x03b5,0x03b4,0x03b4,0x03b4,0x03b3,
	0x03b3,0x03b2,0x03b2,0x03b2,0x03b1,0x03b1,0x03b1,0x03b0,0x03b0,0x03af,0x03af,0x03af,0x03ae,0x03ae,0x03ad,0x03ad,0x03ad,0x03ac,0x03ac,0x03ab,0x03ab,0x03ab,0x03aa,0x03aa,0x03a9,0x03a9,0x03a9,0x03a8,0x03a8,0x03a7,0x03a7,0x03a7,0x03a6,0x03a6,0x03a5,0x03a5,0x03a5,0x03a4,0x03a4,0x03a3,0x03a3,0x03a2,0x03a2,0x03a2,0x03a1,0x03a1,0x03a0,0x03a0,0x039f,0x039f,
	0x039f,0x039e,0x039e,0x039d,0x039d,0x039d,0x039c,0x039c,0x039b,0x039b,0x039a,0x039a,0x0399,0x0399,0x0399,0x0398,0x0398,0x0397,0x0397,0x0396,0x0396,0x0396,0x0395,0x0395,0x0394,0x0394,0x0393,0x0393,0x0392,0x0392,0x0391,0x0391,0x0391,0x0390,0x0390,0x038f,0x038f,0x038e,0x038e,0x038d,0x038d,0x038c,0x038c,0x038c,0x038b,0x038b,0x038a,0x038a,0x0389,0x0389,
	0x0388,0x0388,0x0387,0x0387,0x0386,0x0386,0x0385,0x0385,0x0384,0x0384,0x0384,0x0383,0x0383,0x0382,0x0382,0x0381,0x0381,0x0380,0x0380,0x037f,0x037f,0x037e,0x037e,0x037d,0x037d,0x037c,0x037c,0x037b,0x037b,0x037a,0x037a,0x0379,0x0379,0x0378,0x0378,0x0377,0x0377,0x0376,0x0376,0x0375,0x0375,0x0374,0x0374,0x0373,0x0373,0x0372,0x0372,0x0371,0x0371,0x0370,
	0x0370,0x036f,0x036f,0x036e,0x036e,0x036d,0x036d,0x036c,0x036c,0x036b,0x036b,0x036a,0x036a,0x0369,0x0368,0x0368,0x0367,0x0367,0x0366,0x0366,0x0365,0x0365,0x0364,0x0364,0x0363,0x0363,0x0362,0x0362,0x0361,0x0361,0x0360,0x035f,0x035f,0x035e,0x035e,0x035d,0x035d,0x035c,0x035c,0x035b,0x035b,0x035a,0x0359,0x0359,0x0358,0x0358,0x0357,0x0357,0x0356,0x0356,
	0x0355,0x0355,0x0354,0x0353,0x0353,0x0352,0x0352,0x0351,0x0351,0x0350,0x0350,0x034f,0x034e,0x034e,0x034d,0x034d,0x034c,0x034c,0x034b,0x034a,0x034a,0x0349,0x0349,0x0348,0x0348,0x0347,0x0346,0x0346,0x0345,0x0345,0x0344,0x0344,0x0343,0x0342,0x0342,0x0341,0x0341,0x0340,0x033f,0x033f,0x033e,0x033e,0x033d,0x033d,0x033c,0x033b,0x033b,0x033a,0x033a,0x0339,
	0x0338,0x0338,0x0337,0x0337,0x0336,0x0335,0x0335,0x0334,0x0334,0x0333,0x0332,0x0332,0x0331,0x0331,0x0330,0x032f,0x032f,0x032e,0x032e,0x032d,0x032c,0x032c,0x032b,0x032b,0x032a,0x0329,0x0329,0x0328,0x0327,0x0327,0x0326,0x0326,0x0325,0x0324,0x0324,0x0323,0x0323,0x0322,0x0321,0x0321,0x0320,0x031f,0x031f,0x031e,0x031e,0x031d,0x031c,0x031c,0x031b,0x031a,
	0x031a,0x0319,0x0319,0x0318,0x0317,0x0317,0x0316,0x0315,0x0315,0x0314,0x0313,0x0313,0x0312,0x0312,0x0311,0x0310,0x0310,0x030f,0x030e,0x030e,0x030d,0x030c,0x030c,0x030b,0x030a,0x030a,0x0309,0x0308,0x0308,0x0307,0x0306,0x0306,0x0305,0x0305,0x0304,0x0303,0x0303,0x0302,0x0301,0x0301,0x0300,0x02ff,0x02ff,0x02fe,0x02fd,0x02fd,0x02fc,0x02fb,0x02fb,0x02fa,
	0x02f9,0x02f9,0x02f8,0x02f7,0x02f7,0x02f6,0x02f5,0x02f5,0x02f4,0x02f3,0x02f3,0x02f2,0x02f1,0x02f0,0x02f0,0x02ef,0x02ee,0x02ee,0x02ed,0x02ec,0x02ec,0x02eb,0x02ea,0x02ea,0x02e9,0x02e8,0x02e8,0x02e7,0x02e6,0x02e6,0x02e5,0x02e4,0x02e3,0x02e3,0x02e2,0x02e1,0x02e1,0x02e0,0x02df,0x02df,0x02de,0x02dd,0x02dd,0x02dc,0x02db,0x02da,0x02da,0x02d9,0x02d8,0x02d8,
	0x02d7,0x02d6,0x02d5,0x02d5,0x02d4,0x02d3,0x02d3,0x02d2,0x02d1,0x02d1,0x02d0,0x02cf,0x02ce,0x02ce,0x02cd,0x02cc,0x02cc,0x02cb,0x02ca,0x02c9,0x02c9,0x02c8,0x02c7,0x02c7,0x02c6,0x02c5,0x02c4,0x02c4,0x02c3,0x02c2,0x02c1,0x02c1,0x02c0,0x02bf,0x02bf,0x02be,0x02bd,0x02bc,0x02bc,0x02bb,0x02ba,0x02b9,0x02b9,0x02b8,0x02b7,0x02b7,0x02b6,0x02b5,0x02b4,0x02b4,
	0x02b3,0x02b2,0x02b1,0x02b1,0x02b0,0x02af,0x02ae,0x02ae,0x02ad,0x02ac,0x02ab,0x02ab,0x02aa,0x02a9,0x02a8,0x02a8,0x02a7,0x02a6,0x02a5,0x02a5,0x02a4,0x02a3,0x02a2,0x02a2,0x02a1,0x02a0,0x029f,0x029f,0x029e,0x029d,0x029c,0x029c,0x029b,0x029a,0x0299,0x0299,0x0298,0x0297,0x0296,0x0296,0x0295,0x0294,0x0293,0x0292,0x0292,0x0291,0x0290,0x028f,0x028f,0x028e,
	0x028d,0x028c,0x028c,0x028b,0x028a,0x0289,0x0288,0x0288,0x0287,0x0286,0x0285,0x0285,0x0284,0x0283,0x0282,0x0281,0x0281,0x0280,0x027f,0x027e,0x027e,0x027d,0x027c,0x027b,0x027a,0x027a,0x0279,0x0278,0x0277,0x0276,0x0276,0x0275,0x0274,0x0273,0x0273,0x0272,0x0271,0x0270,0x026f,0x026f,0x026e,0x026d,0x026c,0x026b,0x026b,0x026a,0x0269,0x0268,0x0267,0x0267,
	0x0266,0x0265,0x0264,0x0263,0x0263,0x0262,0x0261,0x0260,0x025f,0x025f,0x025e,0x025d,0x025c,0x025b,0x025b,0x025a,0x0259,0x0258,0x0257,0x0256,0x0256,0x0255,0x0254,0x0253,0x0252,0x0252,0x0251,0x0250,0x024f,0x024e,0x024e,0x024d,0x024c,0x024b,0x024a,0x0249,0x0249,0x0248,0x0247,0x0246,0x0245,0x0244,0x0244,0x0243,0x0242,0x0241,0x0240,0x0240,0x023f,0x023e,
	0x023d,0x023c,0x023b,0x023b,0x023a,0x0239,0x0238,0x0237,0x0236,0x0236,0x0235,0x0234,0x0233,0x0232,0x0231,0x0231,0x0230,0x022f,0x022e,0x022d,0x022c,0x022c,0x022b,0x022a,0x0229,0x0228,0x0227,0x0226,0x0226,0x0225,0x0224,0x0223,0x0222,0x0221,0x0221,0x0220,0x021f,0x021e,0x021d,0x021c,0x021b,0x021b,0x021a,0x0219,0x0218,0x0217,0x0216,0x0216,0x0215,0x0214,
	0x0213,0x0212,0x0211,0x0210,0x0210,0x020f,0x020e,0x020d,0x020c,0x020b,0x020a,0x0209,0x0209,0x0208,0x0207,0x0206,0x0205,0x0204,0x0203,0x0203,0x0202,0x0201,0x0200,0x01ff,0x01fe,0x01fd,0x01fd,0x01fc,0x01fb,0x01fa,0x01f9,0x01f8,0x01f7,0x01f6,0x01f6,0x01f5,0x01f4,0x01f3,0x01f2,0x01f1,0x01f0,0x01ef,0x01ef,0x01ee,0x01ed,0x01ec,0x01eb,0x01ea,0x01e9,0x01e8,
	0x01e8,0x01e7,0x01e6,0x01e5,0x01e4,0x01e3,0x01e2,0x01e1,0x01e1,0x01e0,0x01df,0x01de,0x01dd,0x01dc,0x01db,0x01da,0x01d9,0x01d9,0x01d8,0x01d7,0x01d6,0x01d5,0x01d4,0x01d3,0x01d2,0x01d1,0x01d1,0x01d0,0x01cf,0x01ce,0x01cd,0x01cc,0x01cb,0x01ca,0x01c9,0x01c8,0x01c8,0x01c7,0x01c6,0x01c5,0x01c4,0x01c3,0x01c2,0x01c1,0x01c0,0x01c0,0x01bf,0x01be,0x01bd,0x01bc,
	0x01bb,0x01ba,0x01b9,0x01b8,0x01b7,0x01b6,0x01b6,0x01b5,0x01b4,0x01b3,0x01b2,0x01b1,0x01b0,0x01af,0x01ae,0x01ad,0x01ad,0x01ac,0x01ab,0x01aa,0x01a9,0x01a8,0x01a7,0x01a6,0x01a5,0x01a4,0x01a3,0x01a3,0x01a2,0x01a1,0x01a0,0x019f,0x019e,0x019d,0x019c,0x019b,0x019a,0x0199,0x0198,0x0198,0x0197,0x0196,0x0195,0x0194,0x0193,0x0192,0x0191,0x0190,0x018f,0x018e,
	0x018d,0x018c,0x018c,0x018b,0x018a,0x0189,0x0188,0x0187,0x0186,0x0185,0x0184,0x0183,0x0182,0x0181,0x0180,0x0180,0x017f,0x017e,0x017d,0x017c,0x017b,0x017a,0x0179,0x0178,0x0177,0x0176,0x0175,0x0174,0x0173,0x0173,0x0172,0x0171,0x0170,0x016f,0x016e,0x016d,0x016c,0x016b,0x016a,0x0169,0x0168,0x0167,0x0166,0x0165,0x0164,0x0164,0x0163,0x0162,0x0161,0x0160,
	0x015f,0x015e,0x015d,0x015c,0x015b,0x015a,0x0159,0x0158,0x0157,0x0156,0x0155,0x0154,0x0154,0x0153,0x0152,0x0151,0x0150,0x014f,0x014e,0x014d,0x014c,0x014b,0x014a,0x0149,0x0148,0x0147,0x0146,0x0145,0x0144,0x0143,0x0143,0x0142,0x0141,0x0140,0x013f,0x013e,0x013d,0x013c,0x013b,0x013a,0x0139,0x0138,0x0137,0x0136,0x0135,0x0134,0x0133,0x0132,0x0131,0x0130,
	0x012f,0x012f,0x012e,0x012d,0x012c,0x012b,0x012a,0x0129,0x0128,0x0127,0x0126,0x0125,0x0124,0x0123,0x0122,0x0121,0x0120,0x011f,0x011e,0x011d,0x011c,0x011b,0x011a,0x0119,0x0118,0x0117,0x0117,0x0116,0x0115,0x0114,0x0113,0x0112,0x0111,0x0110,0x010f,0x010e,0x010d,0x010c,0x010b,0x010a,0x0109,0x0108,0x0107,0x0106,0x0105,0x0104,0x0103,0x0102,0x0101,0x0100,
	0x00ff,0x00fe,0x00fd,0x00fc,0x00fb,0x00fb,0x00fa,0x00f9,0x00f8,0x00f7,0x00f6,0x00f5,0x00f4,0x00f3,0x00f2,0x00f1,0x00f0,0x00ef,0x00ee,0x00ed,0x00ec,0x00eb,0x00ea,0x00e9,0x00e8,0x00e7,0x00e6,0x00e5,0x00e4,0x00e3,0x00e2,0x00e1,0x00e0,0x00df,0x00de,0x00dd,0x00dc,0x00db,0x00da,0x00d9,0x00d8,0x00d7,0x00d6,0x00d5,0x00d5,0x00d4,0x00d3,0x00d2,0x00d1,0x00d0,
	0x00cf,0x00ce,0x00cd,0x00cc,0x00cb,0x00ca,0x00c9,0x00c8,0x00c7,0x00c6,0x00c5,0x00c4,0x00c3,0x00c2,0x00c1,0x00c0,0x00bf,0x00be,0x00bd,0x00bc,0x00bb,0x00ba,0x00b9,0x00b8,0x00b7,0x00b6,0x00b5,0x00b4,0x00b3,0x00b2,0x00b1,0x00b0,0x00af,0x00ae,0x00ad,0x00ac,0x00ab,0x00aa,0x00a9,0x00a8,0x00a7,0x00a6,0x00a5,0x00a4,0x00a3,0x00a2,0x00a1,0x00a0,0x009f,0x009e,
	0x009d,0x009c,0x009b,0x009a,0x0099,0x0098,0x0097,0x0096,0x0096,0x0095,0x0094,0x0093,0x0092,0x0091,0x0090,0x008f,0x008e,0x008d,0x008c,0x008b,0x008a,0x0089,0x0088,0x0087,0x0086,0x0085,0x0084,0x0083,0x0082,0x0081,0x0080,0x007f,0x007e,0x007d,0x007c,0x007b,0x007a,0x0079,0x0078,0x0077,0x0076,0x0075,0x0074,0x0073,0x0072,0x0071,0x0070,0x006f,0x006e,0x006d,
	0x006c,0x006b,0x006a,0x0069,0x0068,0x0067,0x0066,0x0065,0x0064,0x0063,0x0062,0x0061,0x0060,0x005f,0x005e,0x005d,0x005c,0x005b,0x005a,0x0059,0x0058,0x0057,0x0056,0x0055,0x0054,0x0053,0x0052,0x0051,0x0050,0x004f,0x004e,0x004d,0x004c,0x004b,0x004a,0x0049,0x0048,0x0047,0x0046,0x0045,0x0044,0x0043,0x0042,0x0041,0x0040,0x003f,0x003e,0x003d,0x003c,0x003b,
	0x003a,0x0039,0x0038,0x0037,0x0036,0x0035,0x0034,0x0033,0x0032,0x0031,0x0030,0x002f,0x002e,0x002d,0x002c,0x002b,0x002a,0x0029,0x0028,0x0027,0x0026,0x0025,0x0024,0x0023,0x0022,0x0021,0x0020,0x001f,0x001e,0x001d,0x001c,0x001b,0x001a,0x0019,0x0018,0x0017,0x0016,0x0015,0x0014,0x0013,0x0012,0x0011,0x0010,0x000f,0x000e,0x000d,0x000c,0x000b,0x000a,0x0009,
	0x0008,0x0007,0x0006,0x0005,0x0004,0x0003,0x0002,0x0001,0x0000,
};

fixed
fcos(fixed a)
{
	int i = (int)a;

	if(i < 0) i = -i;							/* 0𒆐SɍEΏ    */
	if(i > _PI2) i %= _PI2; /* ]Z͒x̂ŁA2΂𒴂ꍇ̂ */	/* 0`2ΎŌJԂ */
	     if(i <= _PI_2 * 1) return (fixed)(int) fcos_tbl[       i      ];	/*       0Ɓ/2    */
	else if(i <= _PI_2 * 2) return (fixed)(int)-fcos_tbl[_PI  - i      ];	/*    /2Ɓ      */
	else if(i <= _PI_2 * 3) return (fixed)(int)-fcos_tbl[       i - _PI];	/*      ΁Ɓ(3/2) */
	else                    return (fixed)(int) fcos_tbl[_PI2 - i      ];	/* (3/2)΁Ɓ2     */
}

/****************************************************************************
 *	ftan
 ****************************************************************************/

fixed
ftan(fixed a)
{
	return fdiv(fsin(a), fcos(a));	/* tan() = sin() / cos() */
}

/****************************************************************************
 *	fasin
 ****************************************************************************/

fixed
fasin(fixed a)
{
	fixed b;
	fixed c;
	fixed d;

	/* 덷ጸ̂߂̓ᏈB */
	if(ficom(a, >=,  1)) return      PI_2 ;
	if(ficom(a, <=, -1)) return fchs(PI_2);

	/* oCiT[`-/2`/2̐rApx𔻒肵܂B */
	c = 0;
	d = fidiv(PI_2, 2);
	do {
		b = fsin(c);
		       if(fcom(a, >, b)) {
			fadd_(c, d);
		} else if(fcom(a, <, b)) {
			fsub_(c, d);
		} else {
			break;
		}
		fidiv_(d, 2);
	} while(d);

	return c;
}

/****************************************************************************
 *	facos
 ****************************************************************************/

fixed
facos(fixed a)
{
	return fsub(PI_2, fasin(a));
}

/****************************************************************************
 *	fatan
 ****************************************************************************/

/* TODO */
fixed fatan(fixed a);

/****************************************************************************
 *	fatan2
 ****************************************************************************/

fixed
fatan2(fixed y, fixed x)
{
	int z = 0;
	fixed a;
	fixed b;
	fixed t1;
	fixed t2;
	fixed tmp;

	/* -0`-180ꎞI0`180ɕϊB */
	if(ficom(y, <, 0)) {
		y = fchs(y);
		z |= 4;
	}
	/* 180`90ꎞI0`90ɕϊB */
	if(ficom(x, <, 0)) {
		x = fchs(x);
		z |= 2;
	}
	/* 90`45ꎞI0`45ɕϊB */
	if(fcom(x, <, y)) {
		tmp = x;
		      x = y;
		          y = tmp;
		z |= 1;
	}

	if(ficom(y, ==, 0)) {
		/* oCiT[`ł͌덷̂ߔ肪ɃYĂ܂܂B
		 * 0͂0Ɣ肵̂ŁAʔƂ܂B
		 * (x,y)=(0,0)̏ꍇɊ܂܂܂B
		 */
		a = 0;
	} else {
		/* oCiT[`0`45̐ڂrApx𔻒肵܂B */
		t1 = fdiv(y, x);
		a = fidiv(PI_2, 4);
		b = fidiv(PI_2, 8);
		do {
			t2 = ftan(a);
			       if(fcom(t1, >, t2)) {
				a = fadd(a, b);
			} else if(fcom(t1, <, t2)) {
				a = fsub(a, b);
			} else {
				break;
			}
			b = fidiv(b, 2);
		} while(b);
	}

	/* Kvɉ0`4590`45ɖ߂B */
	if(z & 1) {
		a = fsub(PI_2, a);
	}
	/* Kvɉ0`90180`90ɖ߂B */
	if(z & 2) {
		a = fsub(PI, a);
	}
	/* Kvɉ0`180-0`-180ɖ߂B */
	if(z & 4) {
		a = fchs(a);
	}

	return a;
}

/*****************************************************************************
 *	vector
 *****************************************************************************/

/* L@̒` */
#define Ax	a.x
#define Ay	a.y
#define Az	a.z
#define Bx	b.x
#define By	b.y
#define Bz	b.z

const vector VECTOR_0 = { fild(0), fild(0), fild(0) };
const vector VECTOR_X = { fild(1), fild(0), fild(0) };
const vector VECTOR_Y = { fild(0), fild(1), fild(0) };
const vector VECTOR_Z = { fild(0), fild(0), fild(1) };

/****************************************************************************
 *	vchs
 ****************************************************************************/

vector
vchs(vector a)
{
	return (vector){
		fchs(Ax),
		fchs(Ay),
		fchs(Az)};
}

/****************************************************************************
 *	vadd
 ****************************************************************************/

vector
vadd(vector a, vector b)
{
	return (vector){
		fadd(Ax, Bx),
		fadd(Ay, By),
		fadd(Az, Bz)};
}

/****************************************************************************
 *	vsub
 ****************************************************************************/

vector
vsub(vector a, vector b)
{
	return (vector){
		fsub(Ax, Bx),
		fsub(Ay, By),
		fsub(Az, Bz)};
}

/****************************************************************************
 *	vmul
 ****************************************************************************/

vector
vmul(vector a, vector b)
{
	return (vector){
		fmul(Ax, Bx),
		fmul(Ay, By),
		fmul(Az, Bz)};
}

/****************************************************************************
 *	vfmul
 ****************************************************************************/

vector
vfmul(vector a, fixed b)
{
	return (vector){
		fmul(Ax, b),
		fmul(Ay, b),
		fmul(Az, b)};
}

/****************************************************************************
 *	vimul
 ****************************************************************************/

vector
vimul(vector a, int b)
{
	return (vector){
		fimul(Ax, b),
		fimul(Ay, b),
		fimul(Az, b)};
}

/****************************************************************************
 *	vdiv
 ****************************************************************************/

vector
vdiv(vector a, vector b)
{
	return (vector){
		fdiv(Ax, Bx),
		fdiv(Ay, By),
		fdiv(Az, Bz)};
}

/****************************************************************************
 *	vfdiv
 ****************************************************************************/

vector
vfdiv(vector a, fixed b)
{
	return (vector){
		fdiv(Ax, b),
		fdiv(Ay, b),
		fdiv(Az, b)};
}

/****************************************************************************
 *	vidiv
 ****************************************************************************/

vector
vidiv(vector a, int b)
{
	return (vector){
		fidiv(Ax, b),
		fidiv(Ay, b),
		fidiv(Az, b)};
}

/****************************************************************************
 *	vdot
 ****************************************************************************/

fixed
vdot(vector a, vector b)
{
	return	fadd(
		fadd(fmul(Ax, Bx),
		     fmul(Ay, By)),
		     fmul(Az, Bz));
}

/****************************************************************************
 *	vcross
 ****************************************************************************/

vector
vcross(vector a, vector b)
{
	return (vector){
		fsub(fmul(Ay, Bz), fmul(Az, By)),
		fsub(fmul(Az, Bx), fmul(Ax, Bz)),
		fsub(fmul(Ax, By), fmul(Ay, Bx))};
}

/****************************************************************************
 *	vnormal
 ****************************************************************************/

vector
vnormal(vector a)
{
	//return vfdiv(a, vmag(a));
	//2004/12/21 ύX 
	// * Tue Dec 21 06:00:00 JST 2004 Naoyuki Sawa
	// - [xNgw肳ꂽꍇ́Â܂܃[xNgԂ悤ɂ܂B
	//   (܂ł́A[xNgw肳ƁA[ZG[ɂȂĂ܂B)
	fixed b = vmag(a);
	return b ? vfdiv(a, b) : a;
}

/****************************************************************************
 *	vmag
 ****************************************************************************/

fixed
vmag(vector a)
{
	return fsqrt(vmag2(a));

}

/****************************************************************************
 *	vmag2
 ****************************************************************************/

fixed
vmag2(vector a)
{
	return vdot(a, a);
}

/****************************************************************************
 *	vreflect
 ****************************************************************************/

vector
vreflect(vector N, vector E)
{
	return vsub(vfmul(N, fimul(vdot(E, N), 2)), E);
	//                         ~~~~~~~~~~(EEN)
	//                   ~~~~~~~~~~~~~~~~~~~~2(EEN)
	//          ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~2(EEN)N
	//     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~2(EEN)N - E
}

/*****************************************************************************
 *	matrix
 *****************************************************************************/

/* L@̒` */
#define A00	a.a00
#define A01	a.a01
#define A02	a.a02
#define A03	a.a03
#define A10	a.a10
#define A11	a.a11
#define A12	a.a12
#define A13	a.a13
#define A20	a.a20
#define A21	a.a21
#define A22	a.a22
#define A23	a.a23
#define B00	b.a00
#define B01	b.a01
#define B02	b.a02
#define B03	b.a03
#define B10	b.a10
#define B11	b.a11
#define B12	b.a12
#define B13	b.a13
#define B20	b.a20
#define B21	b.a21
#define B22	b.a22
#define B23	b.a23

const matrix MATRIX_I = {
	fild(1), fild(0), fild(0), fild(0),
	fild(0), fild(1), fild(0), fild(0),
	fild(0), fild(0), fild(1), fild(0)
};

/****************************************************************************
 *	mxpose
 ****************************************************************************/

matrix
mxpose(matrix a)
{
	return (matrix){
		A00, A10, A20, fild(0),
		A01, A11, A21, fild(0),
		A02, A12, A22, fild(0)};
}

/****************************************************************************
 *	minv
 ****************************************************************************/

matrix
minv(matrix a)
{
	int i, j, k;
	fixed s, t;

	/* 4x4s񂪉24x8s肵A
	 * sAEPʍsƂ܂B
	 */
	fixed m[4][8] = {
		{     A00,     A01,     A02,     A03, fild(1), fild(0), fild(0), fild(0) },
		{     A10,     A11,     A12,     A13, fild(0), fild(1), fild(0), fild(0) },
		{     A20,     A21,     A22,     A23, fild(0), fild(0), fild(1), fild(0) },
		{ fild(0), fild(0), fild(0), fild(1), fild(0), fild(0), fild(0), fild(1) },
	};

	/* sim肳鏈... */
	for(i = 0; i < 4; i++) {
		/* m[j=i`3][i]̐Βlԑ傫sjT܂B
		 * _́A0ȊOȂǂł\Ȃ̂łA
		 * 덷邽߂ɁAԑ傫lg܂B
		 */
		j = i;
		s = ffabs(m[j][i]);
		for(k = j + 1; k < 4; k++) {
			t = ffabs(m[k][i]);
			if(fcom(t, >, s)) {
				j = k;
				s = t;
			}
		}
		/* t=0ȂstłAs܂B */

		/* sij܂B */
		if(i != j) {
			for(k = 0; k < 8; k++) {
				s = m[i][k];
				    m[i][k] = m[j][k];
				              m[j][k] = s;
			}
		}

		/* m[i][i]1ɂȂ悤Asim[i][i]Ŋ܂B */
		s = fdiv(fild(1), m[i][i]);
		for(j = 0; j < 8; j++) m[i][j] = fmul(m[i][j], s);

		/* m[j=iȊO][i]0ɂȂ悤Asim[j][i]{Ĉ܂B */
		for(j = 0; j < 4; j++) {
			if(j == i) continue;
			s = m[j][i];
			for(k = 0; k < 8; k++) m[j][k] = fsub(m[j][k], fmul(m[i][k], s));
		}
		/* ōsim肵܂B */
	}

	/* Es̋tsɂȂĂ܂B */
	return (matrix){
		m[0][4], m[0][5], m[0][6], m[0][7],
		m[1][4], m[1][5], m[1][6], m[1][7],
		m[2][4], m[2][5], m[2][6], m[2][7]};
}

/****************************************************************************
 *	minvno
 ****************************************************************************/

matrix
minvno(matrix a)
{
	/* Ks̋tΐA̒ʂłB
	 *	| R P |-1 = | RT RT*(-P) |
	 * A
	 *	R  = ]\3x3s
	 *	P  = sړ\3xNg
	 *	RT = R̓]us
	 * Ƃ܂B
	 */
	return (matrix){
		A00, A10, A20, fchs(fadd(fadd(fmul(A00, A03), fmul(A10, A13)), fmul(A20, A23))),
		A01, A11, A21, fchs(fadd(fadd(fmul(A01, A03), fmul(A11, A13)), fmul(A21, A23))),
		A02, A12, A22, fchs(fadd(fadd(fmul(A02, A03), fmul(A12, A13)), fmul(A22, A23)))};
}

/* * Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa */
/* - vxform()framfix.cֈړ܂B       */

/* * Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa */
/* - mxform()framfix.cֈړ܂B       */

/****************************************************************************
 *	mxlate
 ****************************************************************************/

matrix
mxlate(matrix a, fixed x, fixed y, fixed z)
{
	return mxform(a, (matrix){
		fild(1), fild(0), fild(0), x,
		fild(0), fild(1), fild(0), y,
		fild(0), fild(0), fild(1), z});
}

/****************************************************************************
 *	mscale
 ****************************************************************************/

matrix
mscale(matrix a, fixed x, fixed y, fixed z)
{
	return mxform(a, (matrix){
		     x , fild(0), fild(0), fild(0),
		fild(0),      y , fild(0), fild(0),
		fild(0), fild(0),      z , fild(0)});
}

/****************************************************************************
 *	mfscale
 ****************************************************************************/

matrix
mfscale(matrix a, fixed s)
{
	return mxform(a, (matrix){
		     s , fild(0), fild(0), fild(0),
		fild(0),      s , fild(0), fild(0),
		fild(0), fild(0),      s , fild(0)});
}

/****************************************************************************
 *	mrot
 ****************************************************************************/

matrix
mrot(matrix a, fixed x, fixed y, fixed z, fixed d)
{
	vector v = vnormal((vector){x,y,z}); /* ]xNg𐳋K */
	fixed s = fsin(d), c = fcos(d);
	fixed C = fisubr(c, 1); /* 1-c */
	x = v.x, y = v.y, z = v.z;
	return mxform(a, (matrix){
		fadd(fmul(fmul(x,x),C),       c ), fsub(fmul(fmul(x,y),C),fmul(z,s)), fadd(fmul(fmul(x,z),C),fmul(y,s)), fild(0),
		fadd(fmul(fmul(y,x),C),fmul(z,s)), fadd(fmul(fmul(y,y),C),       c ), fsub(fmul(fmul(y,z),C),fmul(x,s)), fild(0),
		fsub(fmul(fmul(z,x),C),fmul(y,s)), fadd(fmul(fmul(z,y),C),fmul(x,s)), fadd(fmul(fmul(z,z),C),       c ), fild(0)});
}

/****************************************************************************
 *	mrotx
 ****************************************************************************/

matrix
mrotx(matrix a, fixed d)
{
	/* X]śA̒ʂłB
	 *	|  1, 0, 0, 0 |
	 *	|  0, c,-s, 0 |
	 *	|  0, s, c, 0 |
	 * A
	 *	c = cos(d)
	 *	s = sin(d)
	 *	d = ]px
	 * Ƃ܂B
	 */
	fixed c, s;
	c = fcos(d);
	s = fsin(d);
	return mxform(a, (matrix){
		fild(1), fild(0), fild(0), fild(0),
		fild(0),      c , fchs(s), fild(0),
		fild(0),      s ,      c , fild(0)});
}

/****************************************************************************
 *	mroty
 ****************************************************************************/

matrix
mroty(matrix a, fixed d)
{
	/* Y]śA̒ʂłB
	 *	|  c, 0, s, 0 |
	 *	|  0, 1, 0, 0 |
	 *	| -s, 0, c, 0 |
	 * A
	 *	c = cos(d)
	 *	s = sin(d)
	 *	d = ]px
	 * Ƃ܂B
	 */
	fixed c, s;
	c = fcos(d);
	s = fsin(d);
	return mxform(a, (matrix){
		     c , fild(0),      s , fild(0),
		fild(0), fild(1), fild(0), fild(0),
		fchs(s), fild(0),      c , fild(0)});
}

/****************************************************************************
 *	mrotz
 ****************************************************************************/

matrix
mrotz(matrix a, fixed d)
{
	/* Z]śA̒ʂłB
	 *	|  c,-s, 0, 0 |
	 *	|  s, c, 0, 0 |
	 *	|  0, 0, 1, 0 |
	 * A
	 *	c = cos(d)
	 *	s = sin(d)
	 *	d = ]px
	 * Ƃ܂B
	 */
	fixed c, s;
	c = fcos(d);
	s = fsin(d);
	return mxform(a, (matrix){
		     c , fchs(s), fild(0), fild(0),
		     s ,      c , fild(0), fild(0),
		fild(0), fild(0), fild(1), fild(0)});
}

/****************************************************************************
 *	Œ񎲉]
 ****************************************************************************/

matrix
mrotxyx(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		          cB           ,                       fmul(sA,sB)           ,                             fmul(cA,sB)           , 0,
		fmul(fchs(sB),fchs(sC)), fadd(fmul(cA,cC),fmul(fmul(sA,cB),fchs(sC))), fadd(fmul(fchs(sA),cC),fmul(fmul(cA,cB),fchs(sC))), 0,
		fmul(fchs(sB),     cC ), fadd(fmul(cA,sC),fmul(fmul(sA,cB),     cC )), fadd(fmul(fchs(sA),sC),fmul(fmul(cA,cB),     cC )), 0});
}

matrix
mrotxzx(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		     cB    ,           fmul(cA,fchs(sB))                  ,                fmul(fchs(sA),fchs(sB))                       , 0,
		fmul(sB,cC), fadd(fmul(fmul(cA,     cB ),cC),fmul(sA,fchs(sC))), fadd(fmul(fmul(fchs(sA),     cB ),cC),fmul(cA,fchs(sC))), 0,
		fmul(sB,sC), fadd(fmul(fmul(cA,     cB ),sC),fmul(sA,     cC )), fadd(fmul(fmul(fchs(sA),     cB ),sC),fmul(cA,     cC )), 0});
}

matrix
mrotyxy(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(cA,     cC ),fmul(fmul(fchs(sA),     cB ),sC)), fmul(sB,sC), fadd(fmul(sA,     cC ),fmul(fmul(cA,     cB ),sC)), 0,
		                            fmul(fchs(sA),fchs(sB))     ,      cB    ,                             fmul(cA,fchs(sB))     , 0,
		fadd(fmul(cA,fchs(sC)),fmul(fmul(fchs(sA),     cB ),cC)), fmul(sB,cC), fadd(fmul(sA,fchs(sC)),fmul(fmul(cA,     cB ),cC)), 0});
}

matrix
mrotyzy(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(fmul(cA,cB),     cC ),fmul(fchs(sA),sC)), fmul(fchs(sB),     cC ), fadd(fmul(fmul(sA,cB),     cC ),fmul(cA,sC)), 0,
		          fmul(cA,sB)                             ,           cB           ,           fmul(sA,sB)                       , 0,
		fadd(fmul(fmul(cA,cB),fchs(sC)),fmul(fchs(sA),cC)), fmul(fchs(sB),fchs(sC)), fadd(fmul(fmul(sA,cB),fchs(sC)),fmul(cA,cC)), 0});
}

matrix
mrotzxz(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(cA,cC),fmul(fmul(sA,cB),fchs(sC))), fadd(fmul(fchs(sA),cC),fmul(fmul(cA,cB),fchs(sC))), fmul(fchs(sB),fchs(sC)), 0,
		fadd(fmul(cA,sC),fmul(fmul(sA,cB),     cC )), fadd(fmul(fchs(sA),sC),fmul(fmul(cA,cB),     cC )), fmul(fchs(sB),     cC ), 0,
		                      fmul(sA,sB)           ,                             fmul(cA,sB)           ,           cB           , 0});
}

matrix
mrotzyz(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(fmul(cA,     cB ),cC),fmul(sA,fchs(sC))), fadd(fmul(fmul(fchs(sA),     cB ),cC),fmul(cA,fchs(sC))), fmul(sB,cC), 0,
		fadd(fmul(fmul(cA,     cB ),sC),fmul(sA,     cC )), fadd(fmul(fmul(fchs(sA),     cB ),sC),fmul(cA,     cC )), fmul(sB,sC), 0,
		          fmul(cA,fchs(sB))                       ,           fmul(fchs(sA),fchs(sB))                       ,      cB    , 0});
}

/****************************************************************************
 *	ŒO]
 ****************************************************************************/

matrix
mrotxyz(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fmul(     cB ,cC), fadd(fmul(fmul(sA,sB),cC),fmul(cA,fchs(sC))), fadd(fmul(fmul(cA,sB),cC),fmul(fchs(sA),fchs(sC))), 0,
		fmul(     cB ,sC), fadd(fmul(fmul(sA,sB),sC),fmul(cA,     cC )), fadd(fmul(fmul(cA,sB),sC),fmul(fchs(sA),     cC )), 0,
		     fchs(sB)    ,           fmul(sA,cB)                       ,           fmul(cA,cB)                             , 0});
}

matrix
mrotxzy(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fmul(cB,     cC ), fadd(fmul(fmul(cA,fchs(sB)),     cC ),fmul(sA,sC)), fadd(fmul(fmul(fchs(sA),fchs(sB)),     cC ),fmul(cA,sC)), 0,
		     sB          ,           fmul(cA,     cB )                       ,           fmul(fchs(sA),     cB )                       , 0,
		fmul(cB,fchs(sC)), fadd(fmul(fmul(cA,fchs(sB)),fchs(sC)),fmul(sA,cC)), fadd(fmul(fmul(fchs(sA),fchs(sB)),fchs(sC)),fmul(cA,cC)), 0});
}

matrix
mrotyxz(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(cA,cC),fmul(fmul(fchs(sA),fchs(sB)),fchs(sC))), fmul(cB,fchs(sC)), fadd(fmul(sA,cC),fmul(fmul(cA,fchs(sB)),fchs(sC))), 0,
		fadd(fmul(cA,sC),fmul(fmul(fchs(sA),fchs(sB)),     cC )), fmul(cB,     cC ), fadd(fmul(sA,sC),fmul(fmul(cA,fchs(sB)),     cC )), 0,
		                      fmul(fchs(sA),     cB )           ,      sB          ,                       fmul(cA,     cB )           , 0});
}

matrix
mrotyzx(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		          fmul(cA,cB)                             ,      fchs(sB)    ,           fmul(sA,cB)                       , 0,
		fadd(fmul(fmul(cA,sB),cC),fmul(fchs(sA),fchs(sC))), fmul(     cB ,cC), fadd(fmul(fmul(sA,sB),cC),fmul(cA,fchs(sC))), 0,
		fadd(fmul(fmul(cA,sB),sC),fmul(fchs(sA),     cC )), fmul(     cB ,sC), fadd(fmul(fmul(sA,sB),sC),fmul(cA,     cC )), 0});
}

matrix
mrotzxy(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		fadd(fmul(cA,     cC ),fmul(fmul(sA,sB),sC)), fadd(fmul(fchs(sA),     cC ),fmul(fmul(cA,sB),sC)), fmul(     cB ,sC), 0,
		                            fmul(sA,cB)     ,                                   fmul(cA,cB)     ,      fchs(sB)    , 0,
		fadd(fmul(cA,fchs(sC)),fmul(fmul(sA,sB),cC)), fadd(fmul(fchs(sA),fchs(sC)),fmul(fmul(cA,sB),cC)), fmul(     cB ,cC), 0});
}

matrix
mrotzyx(matrix a, fixed x, fixed y, fixed z)
{
	fixed cA = fcos(x), sA = fsin(x);
	fixed cB = fcos(y), sB = fsin(y);
	fixed cC = fcos(z), sC = fsin(z);
	return mxform(a, (matrix){
		                      fmul(cA,     cB )           ,                       fmul(fchs(sA),     cB )           ,      sB          , 0,
		fadd(fmul(sA,cC),fmul(fmul(cA,fchs(sB)),fchs(sC))), fadd(fmul(cA,cC),fmul(fmul(fchs(sA),fchs(sB)),fchs(sC))), fmul(cB,fchs(sC)), 0,
		fadd(fmul(sA,sC),fmul(fmul(cA,fchs(sB)),     cC )), fadd(fmul(cA,sC),fmul(fmul(fchs(sA),fchs(sB)),     cC )), fmul(cB,     cC ), 0});
}

/****************************************************************************
 *	mrotget
 ****************************************************************************/

/* TODO */
fixed mrotget(vector* v, matrix a);

/****************************************************************************
 *	morient
 ****************************************************************************/

matrix
morient(matrix a,
	fixed dx, fixed dy, fixed dz,
	fixed ux, fixed uy, fixed uz)
{
	/* pśA̒ʂłB
	 *	| rx, ux, dx, 0 |
	 *	| ry, uy, dy, 0 |
	 *	| rz, uz, dz, 0 |
	 * A
	 *	| rx, ry, rz |T = XpxNg
	 *	| ux, uy, uz |T = YpxNg
	 *	| dx, dy, dz |T = ZpxNg
	 * Ƃ܂B
	 */
	vector r, u, d;

	/* ZxNg𐳋K܂B */
	d = (vector){dx, dy, dz};
	d = vnormal(d);

	/* XxNg߂āAK܂B 
	 * XxNǵAY->ZƂisA
	 * Ȃ킿OςłB
	 */
	u = (vector){ux, uy, uz};
	r = vcross(u, d);
	r = vnormal(r);

	/* YxNg߂܂B
	 * YxNǵAZ->XƂisA
	 * Ȃ킿OςłB
	 * ZXxNgɐKĂ̂ŁA
	 * YxNg𖾎IɐKKv͂܂B
	 */
	u = vcross(d, r);

	return mxform(a, (matrix){
		r.x, u.x, d.x, fild(0),
		r.y, u.y, d.y, fild(0),
		r.z, u.z, d.z, fild(0)});
}

/****************************************************************************
 *	mlookat
 ****************************************************************************/

matrix
mlookat(matrix a,
	fixed ex, fixed ey, fixed ez,
	fixed cx, fixed cy, fixed cz,
	fixed bank)
{
	/* Jg̓\ϊśA̒ʂłB
	 * 1. oNB
	 * 2. ̊pxA_W璍_Wւ̌ƂB
	 * 3. _WֈړB
	 * _ϊśAJŒ肵ĐE𓮂̂ŁA
	 * 1`3̋tϊƂȂ܂B
	 * s]u^ɂ̂ŁAIuWFNgɋ߂ϊɂȂ܂B
	 *   āA1`3̏͋tōs܂B(matrix_lookat()Ɍ炸)
	 */
	matrix m;
	vector d; /* xNg */
	vector u; /* {xNg */
	fixed nd; /* xNg̑傫 */

	/* _ϊs쐬܂B */
	m = MATRIX_I;
	m = mxlate (m, ex, ey, ez);
#if 0	//{{2004/12/21,2004/12/22ύX
//	m = morient(m, fsub(cx, ex), fsub(cy, ey), fsub(cz, ez), fild(0), fild(1), fild(0));
#elif 0	//2004/12/21 ύX
//	/* * Tue Dec 21 06:00:00 JST 2004 Naoyuki Sawa
//	 * - xNg^Ăꍇ̋~ϑ[uƂāȀꍇɌA
//	 *   {̏xNg(0,1,0)ł͂Ȃ(0,0,1)Ƃ邱Ƃɂ܂B
//	 *   ^ʂԂ珙Xɂɉց`^P[Xz肵Ă܂B
//	 *   (܂ł́AxNg^ƕ`挋ʂsƂȂĂ܂B)
//	 * - ^Ɏ΂߂Ăꍇɂ́AL̋~ϑ[u͓KpȂ߁A
//	 *   Zx̌EɂāA͂`挋ʂsƂȂ܂B
//	 *   Sɐ^ŒłvOȊOŁA^t߂\ꍇ́A
//	 *   mlookat()ĝ͔AxNg𖾎morientgSłB
//	 */
//	dx = fsub(cx, ex);
//	dy = fsub(cy, ey);
//	dz = fsub(cz, ez);
//	if(dx || dz) {	/* xNgZXʐL΁A^ĂȂƔf܂ */
//		ux = fild(0);
//		uy = fild(1);
//		uz = fild(0);
//	} else {	/* xNgZXʐ΁A^ĂƔf܂ */
//		ux = fild(0);
//		uy = fild(0);
//		uz = fild(1);
//	}
//	m = morient(m, dx, dy, dz, ux, uy, uz);
#else	//2004/12/22 ύX
	/* * Wed Dec 22 06:05:00 JST 2004 Naoyuki Sawa
	 * - Z덷ጸ邽߂ɁA{xNg̑傫́AxNgƓ܂B
	 *   (łςg^Ɏ΂߂Ăꍇhɂ͕`挋ʂsmł)
	 */
	d.x = fsub(cx, ex);
	d.y = fsub(cy, ey);
	d.z = fsub(cz, ez);
	nd  = vmag(d);
	if(d.x || d.z) { /* xNgZXʐL΁A^ĂȂƔf܂ */
		u.x =  0;
		u.y = nd;
		u.z =  0;
	} else {         /* xNgZXʐ΁A^ĂƔf܂ */
		u.x =  0;
		u.y =  0;
		u.z = nd;
	}
	m = morient(m, d.x, d.y, d.z, u.x, u.y, u.z);
#endif	//}}2004/12/21,2004/12/22ύX
	m = mrotz  (m, bank);
	m = minvno (m);

	/* ϊsɊ|킹܂B */
	return mxform(a, m);
}

/****************************************************************************
 *	mfrustum
 ****************************************************************************/

matrix
mfrustum(matrix a, fixed width, fixed height, fixed front)
{
	/* eśA̒ʂłB
	 *	| 2*front/width,              0,                 0,                        0 |
	 *	|             0, 2*front/height,                 0,                        0 |
	 *	|             0,              0, back/(back-front), -front*back/(back-front) |
	 *	|             0,              0,                 1,                        0 |
	 * AłZW𐳋KȂ̂ŁA
	 *	| 2*front/width,              0, 0, 0 |
	 *	|             0, 2*front/height, 0, 0 |
	 *	|             0,              0, 1, 0 |
	 * Ƃ܂BA
	 *	width  = eʂ̕
	 *	height = eʂ̍
	 *	front  = tgNbsO
	 *	back   = obNtbsO
	 * Ƃ܂B
	 */
	return mxform(a, (matrix){
		fimul(fdiv(front, width), 2),                       fild(0), fild(0), fild(0),
		                     fild(0), fimul(fdiv(front, height), 2), fild(0), fild(0),
		                     fild(0),                       fild(0), fild(1), fild(0)});
}

/****************************************************************************
 *	mperspect
 ****************************************************************************/

matrix
mperspect(matrix a, fixed fovy, fixed aspect, fixed front)
{
	fixed width, height;
	height = fmul(front, fimul(ftan(fidiv(fovy, 2)), 2)); /* eʂ̕   */
	width  = fmul(height, aspect);                        /* eʂ̍ */
	return mfrustum(a, width, height, front);
}

/****************************************************************************
 *	mviewport
 ****************************************************************************/

matrix
mviewport (matrix a, int left, int top, int width, int height)
{
	/* KW(x,y)
	 *	x = :-1`1:E
	 *	y = :-1`1:
	 * Ar[|[gW(X,Y)
	 *	X = :left      `left+width:E
	 *	Y = :top+height`       top:
	 * ւ̕ϊɂāA܂B
	 *
	 * 1) fϊ->_ϊ->ϊ->x=x/z,y=y/z->r[|[gϊ
	 *    Ƃ菇̏ꍇ...
	 * ΐA̒ʂłB
	 *	X = left + (x + 1) *  width  / 2 = ( width  / 2) * x + (left + width  / 2)
	 *	Y = top  + (y - 1) * -height / 2 = (-height / 2) * y + (top  + height / 2)
	 * āAr[|[gϊśA̒ʂłB
	 *	| width/2,         0, 0, left+width/2 |
	 *	|       0, -height/2, 0, top+height/2 |
	 *	|       0,         0, 1,            0 |
	 *
	 * 2) fϊ->_ϊ->ϊ->r[|[gϊ->x=x/z,y=y-z
	 *    Ƃ菇̏ꍇ...
	 * 萔ɂ1/zeĂ܂Ƃ炩ߍlāA
	 *	X = ( width  / 2) * x + (left + width  / 2) * z
	 *	Y = (-height / 2) * y + (top  + height / 2) * z
	 * āAr[|[gϊśA̒ʂłB
	 *	| width/2,         0, left+width/2, 0 |
	 *	|       0, -height/2, top+height/2, 0 |
	 *	|       0,         0,            1, 0 |
	 */
	return mxform(a, (matrix){
		fild(width/2), fild(        0), fild(0), fild(left+width/2),
		fild(      0), fild(-height/2), fild(0), fild(top+height/2),
		fild(      0), fild(        0), fild(1), fild(           0)});
}

/****************************************************************************
 *	mviewportz
 ****************************************************************************/

matrix
mviewportz(matrix a, int left, int top, int width, int height)
{
	/* matrix_viewport()̃RgQƂĂB */
	return mxform(a, (matrix){
		fild(width/2), fild(        0), fild(left+width/2), fild(0),
		fild(      0), fild(-height/2), fild(top+height/2), fild(0),
		fild(      0), fild(        0), fild(           1), fild(0)});
}

/****************************************************************************
 *	mshadow
 ****************************************************************************/

matrix
mshadow(matrix a,
	fixed Lx, fixed Ly, fixed Lz,
	fixed Gx, fixed Gy, fixed Gz,
	fixed Nx, fixed Ny, fixed Nz)
{
	/*	P = eW
	 *	L = xNg
	 *	G = nʂ̈_
	 *	N = nʂ̖@
	 * ɑ΂āAeꂽWS߂@́A̒ʂłB
	 * 炩߁A
	 *	LN = LEN
	 *	GN = GEN
	 *	A  = Lx / LN
	 *	B  = Ly / LN
	 *	C  = Lz / LN
	 * ߂ĂA
	 *	Sx = Px*(1 - Nx*A) + Py*(  - Ny*A) + Pz(  - Nz*A) + GN*A
	 *	Sy = Px*(  - Nx*B) + Py*(1 - Ny*B) + Pz(  - Nz*B) + GN*B
	 *	Sz = Px*(  - Nx*C) + Py*(  - Ny*C) + Pz(1 - Nz*C) + GN*C
	 * āAes
	 *	| 1-Nx*A,  -Ny*A,  -Nz*A, GN*A |
	 *	|  -Nx*B, 1-Ny*B,  -Nz*B, GN*B |
	 *	|  -Nx*C,  -Ny*C, 1-Nz*C, GN*C |
	 * ƂȂ܂B
	 */
	vector L, G, N;
	fixed LN, GN;
	fixed A, B, C;
	L = (vector){Lx, Ly, Lz};
	G = (vector){Gx, Gy, Gz};
	N = (vector){Nx, Ny, Nz};
	LN = vdot(L, N);
	GN = vdot(G, N);
	A = fdiv(L.x, LN);
	B = fdiv(L.y, LN);
	C = fdiv(L.z, LN);
	return mxform(a, (matrix){
		fsub(fild(1),fmul(Nx,A)), fchs(        fmul(Ny,A)), fchs(        fmul(Nz,A)), fmul(GN,A),
		fchs(        fmul(Nx,B)), fsub(fild(1),fmul(Ny,B)), fchs(        fmul(Nz,B)), fmul(GN,B),
		fchs(        fmul(Nx,C)), fchs(        fmul(Ny,C)), fsub(fild(1),fmul(Nz,C)), fmul(GN,C)});
}
