/*
 *	ExportWire.cpp
 *
 *	P/ECE CLiP Library 3D Object Exporter
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Thu Jun 29 11:55:47 JST 2006 Naoyuki Sawa
 *	- Ct[GNX|[g@\쐬JnB
 *	* Wed Jul 26 06:27:42 JST 2006 Naoyuki Sawa
 *	- IvV_CAOɂāAg嗦Ɣ]wł悤AύX܂B
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

/*{{clipwire.c*/
#define NV_MAX 938 //(sizeof _def_vbuff / sizeof(vector)) /* 128~8812=938 */
/*}}clipwire.c*/
#define NS_MAX 32767 /* WIRE.nsshortȂ̂ŃZOgSHRT_MAX=32767 */

/*****************************************************************************
 *	
 *****************************************************************************/

/* dv
 * * P/ECE CLiP Library Wire̒_WAZOg̏́AMeshƈ255ł͂ȂƂɒӂĂ!!
 * - Mesh̏ꍇA̐𕄍1oCglŊi[Ă̂ŁA255łA
 *   WirȅꍇA_W͍Ɨpς938_܂ŁAZOgshort32767܂őΉł܂B
 * - ȏ̂悤ȗRɂÃ\[Xt@CɂẮA"255"ƂŒl̋Lq͌Ȃ͂łB
 *   "255"̕T[`sAcĂAExportMesh.cpp痬pR[h̃`FbN̕ύXYł\łB
 *   vOXVɂ́A"255"̕T[`sāAqbgȂƂmFĂB
 */

/* {֐̒Ŋmۂ郊\[X͂܂B
 * t@CI[vƍƗpIuWFNg̊mۂƉ́AĂяo(MQExportFile())ōsĂ܂B
 * ]āA{֐ł̃G[́A\[X[NCɂɁA"return FALSE"ł܂B
 */
BOOL
DoExportWire(FILE* fp, MQDocument doc, MQObject obj, struct _OPTION* option)
{
	int n_objs;
	int i_obj;
	MQObject obj_tmp;
	//
	int n_vectors;				/* 0`NV_MAX (P/ECE CLiP Library Wire̎dl) */
	int i_vector;
	static MQPoint vectors[NV_MAX];		memset(vectors, 0, sizeof vectors);
	//
	int n_faces;
	int i_face;
	//
	int n_face_vertices;			/* 0 or 2 or 3 or 4 (MQObject::GetFacePointCount()̎dl) */
	int i_face_vertex;
	static int face_vertices[4];		memset(face_vertices, 0, sizeof face_vertices);
	//
	int n_wsegs;				/* 0`NS_MAX (P/ECE CLiP Library Wire̎dl) */
	int i_wseg;
	static short wsegs[NS_MAX][2];		memset(wsegs, 0, sizeof wsegs);

	/*{{o*/
	fprintf(fp, "<?xml version='1.0' ?>\n");
	/*}}o*/

	/* int MQDocument::GetObjectCount()
	 *
	 * hLg̃IuWFNg̐擾܂B
	 * ۂɑ݂IuWFNgł͂Ȃzvf̑傫Ԃ̂ŁAMQDocument::DeleteObject()ɂNULLɂȂ̂Ƃē܂B
	 * mȐ𓾂ɂMQDocument::GetObject()ɂNULLȊÔ̂𐔂Kv܂B
	 * [out]
	 *	߂l		IuWFNg̔zvfB
	 */
	n_objs = doc->GetObjectCount();

	/* ƗpIuWFNgɁAׂẴIuWFNg܂B */
	for(i_obj = 0; i_obj < n_objs; i_obj++) {

		/* MQObject MQDocument::GetObject(int index)
		 *
		 * IuWFNgNXւ̃|C^擾܂B
		 * w肵CfNXɃIuWFNg݂ȂꍇNULLԂ܂B
		 * [in]
		 *	index		IuWFNg̃CfNXB
		 * [out]
		 *	߂l		IuWFNgNXB
		 */
		obj_tmp = doc->GetObject(i_obj);
		if(!obj_tmp) {
			continue; /* L蓾܂!! MQDocument::GetObjectCount()̃RgQ */
		}

		/* \̃IuWFNg͏o͂ȂƂɂ܂B */
		if(!obj_tmp->GetVisible()) {
			continue;
		}

		/* MQObject::Freeze()ɂeύX̂ŁAIuWFNg𕡐Ă܂B */
		obj_tmp = obj_tmp->Clone();

		/* Ȗʂ⋾ʂȂǂ̑t[YĊSɃ|S܂B */
		obj_tmp->Freeze(MQOBJECT_FREEZE_ALL);

		/* ƗpIuWFNgɍ܂B */
		obj->Merge(obj_tmp);

		/* void MQObject::DeleteThis()
		 *
		 * IuWFNgNXf[g()܂B
		 * ̊֐̓hLgɓo^ĂȂIuWFNgɂ̂ݗLŁAhLgɓo^ꂽIuWFNgłꍇMQDocement::DeleteObject()gpȂ΂Ȃ܂B
		 */
		obj_tmp->DeleteThis();
	}

	/* int MQObject::GetVertexCount()
	 *
	 * _̐擾܂B
	 * ۂɑ݂钸_ł͂Ȃzvf̑傫ł̂ŁAmȒ_𒲂ׂɂ͊e_ƂMQObject::GetVertexRefCount()0ȊOԂ邩ǂ𒲂ׂKv܂B
	 * [out]
	 *	߂l		_z̗vfB
	 */
	n_vectors = obj->GetVertexCount();
	if(n_vectors > NV_MAX) { /* P/ECE CLiP Library Wire̎dl */
		MessageBox(MQ_GetWindowHandle(),
			"_W܂B",
			APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
		return FALSE;
	}

	/* int MQObject::GetFaceCount()
	 *
	 * ʐ擾܂B
	 * ۂɑ݂ʐł͂Ȃzvf̑傫ł̂ŁAmȖʐ𓾂ɂ͊eʂƂMQObject::GetFacePointCount()0ȊOԂ邩ǂ𒲂ׂKv܂B
	 * [out]
	 *	߂l		ʔz̗vfB
	 */
	n_faces = obj->GetFaceCount();

	/* dȂZOgz쐬܂B
	 * - Metasequoia Ver2.3.4ɑ݂A[IuWFNg][Wired]@\Kp΁AMetasequoiadȂC[t[sĂ܂B
	 *   Aʏ̃|SfC[t[f[^𐶐ł悤A̎ł́AOŏdȂZOgz쐬Ƃɂ܂B
	 * - [IuWFNg][Wired]@\KpɁA{vOCɂăC[t[f[^o͂邱Ƃł܂B
	 *   PɁAȉ̏dȂZOgz쐬AʏƂȂ邾łB
	 */
	n_wsegs = 0;
	for(i_face = 0; i_face < n_faces; i_face++) {

		/* int MQObject::GetFacePointCount(int face)
		 *
		 * w肵ʂɑ钸_̐擾܂B
		 * 0,2,3,4̂ꂩԂ܂B
		 * 0̏ꍇMQObject::DeleteFace()ɂɔjꑶ݂ĂȂƂ܂B
		 * [in]
		 *	face		ʂ̃CfNXB
		 * [out]
		 *	߂l		_
		 */
		n_face_vertices = obj->GetFacePointCount(i_face);
		if(n_face_vertices > 4) { /* L蓾Ȃ */
			MessageBox(MQ_GetWindowHandle(),
				"\ȂtFCX_łB",
				APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
			return FALSE;
		}

		/* void MQObject::GetFacePointArray(int face, int* vertex)
		 *
		 * w肵ʂ̒_CfNXzƂĎ擾܂B
		 * vertexMQObject::GetFacePointCount()œ鐔ȏ̑傫złȂ΂Ȃ܂B
		 *
		 * [in]
		 *	face		ʂ̃CfNXB
		 *	vertex		_CfNXi[obt@B
		 */
		obj->GetFacePointArray(i_face, face_vertices);

		/* ɓZOgΉAoȂ΃ZOgzɒǉ܂B */
		for(i_face_vertex = 0; i_face_vertex < n_face_vertices; i_face_vertex++) {
			int iv0 = face_vertices[ i_face_vertex + 0                   ];
			int iv1 = face_vertices[(i_face_vertex + 1) % n_face_vertices];
			for(i_wseg = 0; i_wseg < n_wsegs; i_wseg++) {
				if((wsegs[i_wseg][0] == iv0 && wsegs[i_wseg][1] == iv1) ||
				   (wsegs[i_wseg][0] == iv1 && wsegs[i_wseg][1] == iv0)) { /* tłv */
					break;
				}
			}
			if(i_wseg == n_wsegs) { /* ZOgȂ? */
				if(n_wsegs == NS_MAX) { /* ɃZOgɒBĂ? (P/ECE CLiP Library Wire̎dl) */
					MessageBox(MQ_GetWindowHandle(),
						"ZOg܂B",
						APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
					return FALSE;
				}
				wsegs[n_wsegs][0] = iv0;
				wsegs[n_wsegs][1] = iv1;
				n_wsegs++;
			}
		}
	}

	/*{{o*/
	fprintf(fp, "<wire nv='%d' ns='%d'>\n", n_vectors, n_wsegs);
	/*}}o*/

	/* void MQObject::GetVertexArray(MQPoint* ptsarray);
	 *
	 * IuWFNĝׂĂ̒_̈ʒuzƂĈꊇ擾܂B
	 * ptsarray̔zvfMQObject::GetVertexCount()ŕԂ鐔ȏłȂ΂Ȃ܂B
	 * [in]
	 *	ptsarray	ʒuzB
	 */
	obj->GetVertexArray(vectors);

#if 0 /*{{2006/07/26*/
//	/* * MQ_ExportAxis()́AZ]wƁAX܂Ŕ]Ă܂݂łB
//	 *   dl悭킩Ȃ̂ŁAOōWϊsAZ]sƂɂ܂B
//	 * * Metasequoia̕WIȃXP[͑傫̂ŁA1001ŏo͂邱Ƃɂ܂B
//	 *   ̕ΐAMQFileDialogInfo.scale̐ݒɑ܂B
//	 *   _CAOŕύX邱ƂłȂȂĂ܂܂AƂ肠ŒƂ܂B
//	 *   AJX^_CAOāAύXł悤ɂ悤Ǝv܂B(TODO:)
//	 */
//	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
//		vectors[i_vector].x =  vectors[i_vector].x / 100;
//		vectors[i_vector].y =  vectors[i_vector].y / 100;
//		vectors[i_vector].z = -vectors[i_vector].z / 100;
//	}
#else /*}}2006/07/26{{*/
	/* * Wed Jul 26 06:27:42 JST 2006 Naoyuki Sawa
	 * - IvV_CAOɂāAg嗦Ɣ]wł悤AύX܂B
	 */
	double scale = option->scale * pow(10, option->exp);
	double scale_x = option->axis == 0 ? -scale : scale;
	double scale_y = option->axis == 1 ? -scale : scale;
	double scale_z = option->axis == 2 ? -scale : scale;
	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
		vectors[i_vector].x = (float)(vectors[i_vector].x * scale_x);
		vectors[i_vector].y = (float)(vectors[i_vector].y * scale_y);
		vectors[i_vector].z = (float)(vectors[i_vector].z * scale_z);
	}
#endif /*}}2006/07/26*/

	/*{{o*/
	for(i_vector = 0; i_vector < n_vectors; i_vector++) {
		float x = vectors[i_vector].x;
		float y = vectors[i_vector].y;
		float z = vectors[i_vector].z;
		fprintf(fp, "\t<vector x='%d' y='%d' z='%d' /> <!-- %f %f %f -->\n", fld(x), fld(y), fld(z), x, y, z);
	}
	for(i_wseg = 0; i_wseg < n_wsegs; i_wseg++) {
		fprintf(fp, "\t<wseg iv0='%d' iv1='%d' />\n", wsegs[i_wseg][0], wsegs[i_wseg][1]);
	}
	/*}}o*/

	/*{{o*/
	fprintf(fp, "</wire>\n");
	/*}}o*/

	return TRUE;
}

