/*
 *	ExportPieceClip.cpp
 *
 *	P/ECE CLiP Library 3D Object Exporter
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Tue Jun 27 07:27:03 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	  s: Metasequoia Ver2.3.4
 *	  쐬: Metasequoia Plug-in SDK Rev2.31 (2004/02/28)
 *	* Tue Jun 27 23:45:49 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	  _ŁAeNX`Wo͂łB
 *	* Wed Jun 28 04:23:49 JST 2006 Naoyuki Sawa
 *	- RGBmNϊ̖Ât̂C܂B
 *	* Wed Jun 28 14:55:11 JST 2006 Naoyuki Sawa
 *	- MQ_ExportAxis()̍Wϊ͎dl悭킩Ȃ̂ŁAOŏ邱Ƃɂ܂B
 *	  MQ_ExportAxis()́AZ]wƁAX܂Ŕ]Ă܂݂łB
 *	  dl悭킩Ȃ̂ŁAOōWϊsAZ]sƂɂ܂B
 *	- Metasequoia̕WIȃXP[͑傫̂ŁA1001ŏo͂邱Ƃɂ܂B
 *	  ̕ΐAMQFileDialogInfo.scale̐ݒɑ܂B
 *	  _CAOŕύX邱ƂłȂȂĂ܂܂AƂ肠ŒƂ܂B
 *	  AJX^_CAOāAύXł悤ɂ悤Ǝv܂B(TODO:)
 *	* Thu Jun 29 01:25:58 JST 2006 Naoyuki Sawa
 *	- eNX`Wo͂ǉ܂B
 *	- P/ECE CLiP Libraryrender_mesh()́AbVPʂň̃eNX`Kp(܂͖)̂ŁA
 *	  ۂɂ́ÃeNX`gpIuWFNg\邱Ƃ͂ł܂B
 *	  A{c[̏o̓t@Cɂ́AeNX`Ƃ̊֘At͊܂܂ꂸAPɃeNX`Wz
 *	  o݂͂̂Ȃ̂ŁAG[Ƃɂ̂܂܏o͂邱Ƃɂ܂BpґŒӂĂB
 *	- P/ECE CLiP LibrarỹeNX`ẂAsNZWnŁA0`255̒l܂B
 *	  eNX`TCY255̏ꍇ́A傫l(0`255)w肷邱ƂŁA[v\łB
 *	  MetasequoiãeNX`ẂAeNX`TCY0.0`1.0ƂObhWnłB
 *	  sNZWnɕϊʁA0`255͈̔͂𒴂ꍇ́AP/ECEł͐eNX`WƂȂ܂B
 *	  ̎ł́AG[ƂɒP0`255Ƀ}XNďo͂邱Ƃɂ܂BpґŒӂĂB
 *	* Thu Jun 29 04:15:33 JST 2006 Naoyuki Sawa
 *	- s̃G[bZ[W{bNXǉ܂B
 *	* Thu Jun 29 11:55:47 JST 2006 Naoyuki Sawa
 *	- AvP[VŜ̒`app.hɁAbVGNX|[g@\ExportMesh.cppɕ܂B
 *	- Ct[GNX|[g@\쐬JnB(ExportWire.cpp)
 *	* Wed Jul 26 06:27:42 JST 2006 Naoyuki Sawa
 *	- IvV_CAOɂāAg嗦Ɣ]wł悤AύX܂B
 *	* Wed Sep 27 03:54:09 JST 2006 Naoyuki Sawa
 *	- bVt@C̊gqAxmlpmxɕύX܂B
 *	- C[t[t@C̊gqAxmlpwxɕύX܂B
 */
#include "app.h"

/*****************************************************************************
 *	[Jϐ
 *****************************************************************************/

static HMODULE hModule;		/* DLLW[nh */

static OPTION option = {	/* IvV_CAO̐ݒe */
	1.0,	/* scale */
	-2,	/* exp */
	2,	/* axis */
};

/*****************************************************************************
 *	Cu֐
 *****************************************************************************/

/* DLLAvZXXbhɃA^b`A܂́Af^b`ꂽƂɁAWindowsVXeĂяo܂B
 * ɂ́ÃvZXA^b`̂ݏΏ[łAhinstDLL͂Ȃ̂ŁAʂȂƂɂ܂B
 * - _CAO\[X[h邽߂ɁADLLW[nhLĂ܂B
 *   DoOptionDialog()ŕKvƂȂ邽߂ɁADllMain()̒`ǉ܂B(2006/07/26)
 *   DLLW[nhLĂƂsvȂ΁ADllMain()`Kv͂܂B
 */
BOOL WINAPI
DllMain(HINSTANCE hinstDLL,	/* handle to DLL module */
	DWORD fdwReason,	/* reason for calling function */
	LPVOID lpvReserved)	/* reserved */
{
	hModule = hinstDLL;
	return TRUE;
}

/* v_Ng(Җ)IDAS64bit̒lƂĕԂ܂B
 * ProductID̒l͑ƏdȂ悤ȓKɃ_Ȃ̂ō\܂B
 * ̊֐͋NɌĂяo܂B
 * [in]
 *	Product		v_Ng(Җ)Zbgׂ|C^B
 *	ID		v_NgIDZbgׂ|C^B
 */
MQPLUGIN_EXPORT void
MQGetPlugInID(DWORD* Product, DWORD* ID)
{
	*Product = APP_PRODUCT;
	*ID      = APP_ID;
}

/* [vOCɂ]_CAOŕ\vOCԂ܂B
 * ̊֐̓_CAO\ɌĂяo܂B
 * [out]
 *	߂l		vOCB
 */
MQPLUGIN_EXPORT const char*
MQGetPlugInName()
{
	return "P/ECE CLiP Library 3D Object Exporter, Copyright (C) 2006 Naoyuki Sawa";
}

/* vOC̃^CvԂ܂B
 * ̊֐͋NɌĂяo܂B
 * [out]
 *	߂l		vOC^CvB
 *			[MQPLUGIN_TYPE_IMPORT] t@C͗p
 *			[MQPLUGIN_TYPE_EXPORT] t@Co͗p
 *			[MQPLUGIN_TYPE_CREATE] IuWFNg쐬p
 *			[MQPLUGIN_TYPE_OBJECT] IuWFNgό`p
 *			[MQPLUGIN_TYPE_SELECT] I𕔕ό`p
 */
MQPLUGIN_EXPORT int
MQGetPlugInType()
{
	return MQPLUGIN_TYPE_EXPORT;
}

/* t@Č`Ԃ܂B
 * Ԃ`̓t@C_CAÕR{{bNXɕ\܂B
 * ̊֐͋NɌĂяo܂B
 * index0珇ɌĂяo邲ƂɑĂA߂lƂNULLԂƂɌĂяoI܂B
 * [in]
 *	index		t@C̎ނ̃CfNXB
 * [out]
 *	߂l		vOCB
 */
MQPLUGIN_EXPORT const char*
MQEnumFileType(int index)
{
	switch(index){
	case 0:	/* bV */
	//	return "P/ECE CLiP Library Mesh (*.xml)";
	//* Wed Sep 27 03:54:09 JST 2006 Naoyuki Sawa
	//- bVt@C̊gqAxmlpmxɕύX܂B
		return "P/ECE CLiP Library Mesh (*.pmx)";
	case 1:	/* Ct[ */
	//	return "P/ECE CLiP Library Wire (*.xml)";
	//* Wed Sep 27 03:54:09 JST 2006 Naoyuki Sawa
	//- C[t[t@C̊gqAxmlpwxɕύX܂B
		return "P/ECE CLiP Library Wire (*.pwx)";
	}
	return NULL;
}

/* t@C̊gqԂ܂B
 * Ԃgq̓t@C_CAOň܂B
 * ̊֐͋NɌĂяo܂B
 * index0珇ɌĂяo邲ƂɑĂA߂lƂNULLԂƂɌĂяoI܂B
 * [in]
 *	index		t@C̎ނ̃CfNXB
 * [out]
 *	߂l		gqB
 */
MQPLUGIN_EXPORT const char*
MQEnumFileExt(int index)
{
	switch(index){
	//case 0:	/* bV */
	//case 1:	/* Ct[ */
	//	return "xml"; /* gq͋ʂł */
	//* Wed Sep 27 03:54:09 JST 2006 Naoyuki Sawa
	//- bVt@C̊gqAxmlpmxɕύX܂B
	//- C[t[t@C̊gqAxmlpwxɕύX܂B
	case 0:	/* bV */
		return "pmx";
	case 1:	/* Ct[ */
		return "pwx";
	}
	return NULL;
}

/* hLgɓo^ĂIuWFNgt@C֏݂܂B
 * 炩̗Rŏ݂ɎsꍇFALSEԂ悤ɂĂB
 * [in]
 *	index		t@C̎ނ̃CfNXB
 *	filename	t@C(tpX)B
 *	doc		hLgNXB
 * [out]
 *	߂l		t@Co͂̐̉ہB
 *			[TRUE] o͂ɐ
 *			[FALSE] o͂Ɏs
 */
MQPLUGIN_EXPORT BOOL
MQExportFile(int index, const char* filename, MQDocument doc)
{
	BOOL result = FALSE;
	//
	FILE* fp;
	MQObject obj;

	switch(index){
	case 0:	/* bV */
	case 1:	/* Ct[ */
		/* IvV_CAO\܂B */
		if(DoOptionDialog(hModule, MQ_GetWindowHandle(), &option)) {
			/* t@C쐬܂B */
			fp = fopen(filename, "wt");
			if(fp) {
				/* ׂẴIuWFNgɍ邽߂ɁAƗpIuWFNg쐬܂B */
				obj = MQ_CreateObject();
				if(obj) {
					/* GNX|[gs܂B */
					switch(index){
					case 0:	/* bV */
						result = DoExportMesh(fp, doc, obj, &option);
						break;
					case 1:	/* Ct[ */
						result = DoExportWire(fp, doc, obj, &option);
						break;
					default:
						/* L蓾Ȃ */
						break;
					}

					/* ƗpIuWFNg͂svȂ̂ŁA폜܂B */
					obj->DeleteThis();
				} else {
					MessageBox(MQ_GetWindowHandle(),
						"ƗpIuWFNg̍쐬Ɏs܂B",
						APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
				}

				/* t@C܂B */
				fclose(fp);

				/* t@C쐬ɐAAGNX|[gɎsꍇAt@C폜܂B */
				if(!result) {
					remove(filename);
				}
			} else {
				MessageBox(MQ_GetWindowHandle(),
					"t@C̍쐬Ɏs܂B",
					APP_TITLE, MB_ICONEXCLAMATION | MB_OK);
			}
		}
		break;
	}

	return result;
}

